﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace TheBoxSoftware.Diagnostics {
#if !TEST
	/// <summary>
	/// Centralised Trace class that managed all Tracing information generated by
	/// the application.
	/// </summary>
	/// <remarks>
	/// All trace information generated by implementing applications should travel
	/// through the <see cref="TraceHelper"/>.
	/// 
	/// That is so it can manage wether or not the trace information is output to
	/// the trace listeners. All method calls internally check the <see cref="IsTraceEnabled"/>
	/// property.
	/// </remarks>
	public static class TraceHelper {
		/// <summary>
		/// Indicates if Traceing has been switched on for this application.
		/// </summary>
		public static bool IsTraceEnabled { get; set; }

		public static void Indent() {
			System.Diagnostics.Trace.Indent();
		}

		public static void Unindent() {
			System.Diagnostics.Trace.Unindent();
		}

		public static void WriteLine(object value) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLine(value);
			}
		}

		public static void WriteLine(string message) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLine(message);
			}
		}

		public static void WriteLine(string format, object arg1) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLine(string.Format(format, arg1));
			}
		}

		public static void WriteLine(string format, object arg1, object arg2) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLine(string.Format(format, arg1, arg2));
			}
		}

		public static void WriteLine(string format, object arg1, object arg2, object arg3) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLine(string.Format(format, arg1, arg2, arg3));
			}
		}

		public static void WriteLineIf(bool condition, object value) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLineIf(condition, value);
			}
		}

		public static void WriteLineIf(bool condition, string message) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLineIf(condition, message);
			}
		}

		public static void WriteLineIf(bool condition, string format, object arg1) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLineIf(condition, string.Format(format, arg1));
			}
		}

		public static void WriteLineIf(bool condition, string format, object arg1, object arg2) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLineIf(condition, string.Format(format, arg1, arg2));
			}
		}

		public static void WriteLineIf(bool condition, string format, object arg1, object arg2, object arg3) {
			if (TraceHelper.IsTraceEnabled) {
				System.Diagnostics.Trace.WriteLineIf(condition, string.Format(format, arg1, arg2, arg3));
			}
		}
	}
#else
    /// <summary>
    /// 
    /// </summary>
    public static class TraceHelper
    {
        private static TraceSource ts;
        private static bool initilialised = false;

        public static void Initialise(TraceSource loadedSource)
        {
            ts = loadedSource;
            initilialised = true;
        }

        public static bool IsTraceEnabled { get; set; }

        public static void Indent()
        {
        }

        public static void Unindent()
        {
        }

        public static void WriteLine(string format, object arg1, object arg2, object arg3, object arg4)
        {
            WriteLine(string.Format(format, arg1, arg2, arg3, arg4));
        }

        public static void WriteLine(string format, object arg1, object arg2, object arg3)
        {
            WriteLine(string.Format(format, arg1, arg2, arg3));
        }

        public static void WriteLine(string format, object arg1, object arg2)
        {
            WriteLine(string.Format(format, arg1, arg2));
        }

        public static void WriteLine(string format, string message)
        {
            WriteLine(string.Format(format, message));
        }

        public static void WriteLine(string message)
        {
            WriteLine(TraceEventType.Information, message);
        }

        public static void WriteLine(TraceEventType eventType, string message)
        {
            if (ts != null)
            {
                if (eventType == TraceEventType.Information)
                {
                    ts.TraceInformation(message);
                }
                else
                {
                    ts.TraceEvent(eventType, 0, message);
                }
            }
        }
    }
#endif
}
