﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TheBoxSoftware.Reflection
{
    public class OpCodes
    {
        // Fields
        public static readonly OpCode Add = new OpCode("add", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x58, FlowControl.Next, false, -1);
        public static readonly OpCode Add_Ovf = new OpCode("add.ovf", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd6, FlowControl.Next, false, -1);
        public static readonly OpCode Add_Ovf_Un = new OpCode("add.ovf.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd7, FlowControl.Next, false, -1);
        public static readonly OpCode And = new OpCode("and", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x5f, FlowControl.Next, false, -1);
        public static readonly OpCode Arglist = new OpCode("arglist", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 0, FlowControl.Next, false, 1);
        public static readonly OpCode Beq = new OpCode("beq", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x3b, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Beq_S = new OpCode("beq.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x2e, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bge = new OpCode("bge", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 60, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bge_S = new OpCode("bge.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x2f, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bge_Un = new OpCode("bge.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x41, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bge_Un_S = new OpCode("bge.un.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x34, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bgt = new OpCode("bgt", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x3d, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bgt_S = new OpCode("bgt.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x30, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bgt_Un = new OpCode("bgt.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x42, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bgt_Un_S = new OpCode("bgt.un.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x35, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Ble = new OpCode("ble", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x3e, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Ble_S = new OpCode("ble.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x31, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Ble_Un = new OpCode("ble.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x43, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Ble_Un_S = new OpCode("ble.un.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x36, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Blt = new OpCode("blt", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x3f, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Blt_S = new OpCode("blt.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 50, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Blt_Un = new OpCode("blt.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x44, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Blt_Un_S = new OpCode("blt.un.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x37, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bne_Un = new OpCode("bne.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x40, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Bne_Un_S = new OpCode("bne.un.s", StackBehaviour.Pop1_pop1, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x33, FlowControl.Cond_Branch, false, -2);
        public static readonly OpCode Box = new OpCode("box", StackBehaviour.Pop1, StackBehaviour.Pushref, OperandType.InlineType, OpCodeType.Primitive, 1, 0xff, 140, FlowControl.Next, false, 0);
        public static readonly OpCode Br = new OpCode("br", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Primitive, 1, 0xff, 0x38, FlowControl.Branch, true, 0);
        public static readonly OpCode Br_S = new OpCode("br.s", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x2b, FlowControl.Branch, true, 0);
        public static readonly OpCode Break = new OpCode("break", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 1, FlowControl.Break, false, 0);
        public static readonly OpCode Brfalse = new OpCode("brfalse", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Primitive, 1, 0xff, 0x39, FlowControl.Cond_Branch, false, -1);
        public static readonly OpCode Brfalse_S = new OpCode("brfalse.s", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x2c, FlowControl.Cond_Branch, false, -1);
        public static readonly OpCode Brtrue = new OpCode("brtrue", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Primitive, 1, 0xff, 0x3a, FlowControl.Cond_Branch, false, -1);
        public static readonly OpCode Brtrue_S = new OpCode("brtrue.s", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Macro, 1, 0xff, 0x2d, FlowControl.Cond_Branch, false, -1);
        public static readonly OpCode Call = new OpCode("call", StackBehaviour.Varpop, StackBehaviour.Varpush, OperandType.InlineMethod, OpCodeType.Primitive, 1, 0xff, 40, FlowControl.Call, false, 0);
        public static readonly OpCode Calli = new OpCode("calli", StackBehaviour.Varpop, StackBehaviour.Varpush, OperandType.InlineSig, OpCodeType.Primitive, 1, 0xff, 0x29, FlowControl.Call, false, 0);
        public static readonly OpCode Callvirt = new OpCode("callvirt", StackBehaviour.Varpop, StackBehaviour.Varpush, OperandType.InlineMethod, OpCodeType.Objmodel, 1, 0xff, 0x6f, FlowControl.Call, false, 0);
        public static readonly OpCode Castclass = new OpCode("castclass", StackBehaviour.Popref, StackBehaviour.Pushref, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x74, FlowControl.Next, false, 0);
        public static readonly OpCode Ceq = new OpCode("ceq", StackBehaviour.Pop1_pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 1, FlowControl.Next, false, -1);
        public static readonly OpCode Cgt = new OpCode("cgt", StackBehaviour.Pop1_pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 2, FlowControl.Next, false, -1);
        public static readonly OpCode Cgt_Un = new OpCode("cgt.un", StackBehaviour.Pop1_pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 3, FlowControl.Next, false, -1);
        public static readonly OpCode Ckfinite = new OpCode("ckfinite", StackBehaviour.Pop1, StackBehaviour.Pushr8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xc3, FlowControl.Next, false, 0);
        public static readonly OpCode Clt = new OpCode("clt", StackBehaviour.Pop1_pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 4, FlowControl.Next, false, -1);
        public static readonly OpCode Clt_Un = new OpCode("clt.un", StackBehaviour.Pop1_pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 5, FlowControl.Next, false, -1);
        public static readonly OpCode Constrained = new OpCode("constrained.", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineType, OpCodeType.Prefix, 2, 0xfe, 0x16, FlowControl.Meta, false, 0);
        public static readonly OpCode Conv_I = new OpCode("conv.i", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd3, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_I1 = new OpCode("conv.i1", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x67, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_I2 = new OpCode("conv.i2", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x68, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_I4 = new OpCode("conv.i4", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x69, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_I8 = new OpCode("conv.i8", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x6a, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I = new OpCode("conv.ovf.i", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd4, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I_Un = new OpCode("conv.ovf.i.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x8a, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I1 = new OpCode("conv.ovf.i1", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb3, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I1_Un = new OpCode("conv.ovf.i1.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 130, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I2 = new OpCode("conv.ovf.i2", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb5, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I2_Un = new OpCode("conv.ovf.i2.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x83, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I4 = new OpCode("conv.ovf.i4", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb7, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I4_Un = new OpCode("conv.ovf.i4.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x84, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I8 = new OpCode("conv.ovf.i8", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb9, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_I8_Un = new OpCode("conv.ovf.i8.un", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x85, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U = new OpCode("conv.ovf.u", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd5, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U_Un = new OpCode("conv.ovf.u.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x8b, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U1 = new OpCode("conv.ovf.u1", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 180, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U1_Un = new OpCode("conv.ovf.u1.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x86, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U2 = new OpCode("conv.ovf.u2", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb6, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U2_Un = new OpCode("conv.ovf.u2.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x87, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U4 = new OpCode("conv.ovf.u4", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xb8, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U4_Un = new OpCode("conv.ovf.u4.un", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x88, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U8 = new OpCode("conv.ovf.u8", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xba, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_Ovf_U8_Un = new OpCode("conv.ovf.u8.un", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x89, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_R_Un = new OpCode("conv.r.un", StackBehaviour.Pop1, StackBehaviour.Pushr8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x76, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_R4 = new OpCode("conv.r4", StackBehaviour.Pop1, StackBehaviour.Pushr4, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x6b, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_R8 = new OpCode("conv.r8", StackBehaviour.Pop1, StackBehaviour.Pushr8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x6c, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_U = new OpCode("conv.u", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xe0, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_U1 = new OpCode("conv.u1", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 210, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_U2 = new OpCode("conv.u2", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd1, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_U4 = new OpCode("conv.u4", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x6d, FlowControl.Next, false, 0);
        public static readonly OpCode Conv_U8 = new OpCode("conv.u8", StackBehaviour.Pop1, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 110, FlowControl.Next, false, 0);
        public static readonly OpCode Cpblk = new OpCode("cpblk", StackBehaviour.Popi_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 0x17, FlowControl.Next, false, -3);
        public static readonly OpCode Cpobj = new OpCode("cpobj", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x70, FlowControl.Next, false, -2);
        public static readonly OpCode Div = new OpCode("div", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x5b, FlowControl.Next, false, -1);
        public static readonly OpCode Div_Un = new OpCode("div.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x5c, FlowControl.Next, false, -1);
        public static readonly OpCode Dup = new OpCode("dup", StackBehaviour.Pop1, StackBehaviour.Push1_push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x25, FlowControl.Next, false, 1);
        public static readonly OpCode Endfilter = new OpCode("endfilter", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 0x11, FlowControl.Return, true, -1);
        public static readonly OpCode Endfinally = new OpCode("endfinally", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 220, FlowControl.Return, true, 0);
        public static readonly OpCode Initblk = new OpCode("initblk", StackBehaviour.Popi_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 0x18, FlowControl.Next, false, -3);
        public static readonly OpCode Initobj = new OpCode("initobj", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.InlineType, OpCodeType.Objmodel, 2, 0xfe, 0x15, FlowControl.Next, false, -1);
        public static readonly OpCode Isinst = new OpCode("isinst", StackBehaviour.Popref, StackBehaviour.Pushi, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x75, FlowControl.Next, false, 0);
        public static readonly OpCode Jmp = new OpCode("jmp", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineMethod, OpCodeType.Primitive, 1, 0xff, 0x27, FlowControl.Call, true, 0);
        public static readonly OpCode Ldarg = new OpCode("ldarg", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 9, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarg_0 = new OpCode("ldarg.0", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 2, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarg_1 = new OpCode("ldarg.1", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 3, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarg_2 = new OpCode("ldarg.2", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 4, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarg_3 = new OpCode("ldarg.3", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 5, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarg_S = new OpCode("ldarg.s", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 14, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarga = new OpCode("ldarga", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 10, FlowControl.Next, false, 1);
        public static readonly OpCode Ldarga_S = new OpCode("ldarga.s", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 15, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4 = new OpCode("ldc.i4", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineI, OpCodeType.Primitive, 1, 0xff, 0x20, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_0 = new OpCode("ldc.i4.0", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x16, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_1 = new OpCode("ldc.i4.1", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x17, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_2 = new OpCode("ldc.i4.2", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x18, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_3 = new OpCode("ldc.i4.3", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x19, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_4 = new OpCode("ldc.i4.4", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x1a, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_5 = new OpCode("ldc.i4.5", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x1b, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_6 = new OpCode("ldc.i4.6", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x1c, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_7 = new OpCode("ldc.i4.7", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x1d, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_8 = new OpCode("ldc.i4.8", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 30, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_M1 = new OpCode("ldc.i4.m1", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 0x15, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I4_S = new OpCode("ldc.i4.s", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.ShortInlineI, OpCodeType.Macro, 1, 0xff, 0x1f, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_I8 = new OpCode("ldc.i8", StackBehaviour.Pop0, StackBehaviour.Pushi8, OperandType.InlineI8, OpCodeType.Primitive, 1, 0xff, 0x21, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_R4 = new OpCode("ldc.r4", StackBehaviour.Pop0, StackBehaviour.Pushr4, OperandType.ShortInlineR, OpCodeType.Primitive, 1, 0xff, 0x22, FlowControl.Next, false, 1);
        public static readonly OpCode Ldc_R8 = new OpCode("ldc.r8", StackBehaviour.Pop0, StackBehaviour.Pushr8, OperandType.InlineR, OpCodeType.Primitive, 1, 0xff, 0x23, FlowControl.Next, false, 1);
        public static readonly OpCode Ldelem = new OpCode("ldelem", StackBehaviour.Popref_popi, StackBehaviour.Push1, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0xa3, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_I = new OpCode("ldelem.i", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x97, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_I1 = new OpCode("ldelem.i1", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x90, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_I2 = new OpCode("ldelem.i2", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x92, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_I4 = new OpCode("ldelem.i4", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x94, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_I8 = new OpCode("ldelem.i8", StackBehaviour.Popref_popi, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 150, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_R4 = new OpCode("ldelem.r4", StackBehaviour.Popref_popi, StackBehaviour.Pushr4, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x98, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_R8 = new OpCode("ldelem.r8", StackBehaviour.Popref_popi, StackBehaviour.Pushr8, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x99, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_Ref = new OpCode("ldelem.ref", StackBehaviour.Popref_popi, StackBehaviour.Pushref, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9a, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_U1 = new OpCode("ldelem.u1", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x91, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_U2 = new OpCode("ldelem.u2", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x93, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelem_U4 = new OpCode("ldelem.u4", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x95, FlowControl.Next, false, -1);
        public static readonly OpCode Ldelema = new OpCode("ldelema", StackBehaviour.Popref_popi, StackBehaviour.Pushi, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x8f, FlowControl.Next, false, -1);
        public static readonly OpCode Ldfld = new OpCode("ldfld", StackBehaviour.Popref, StackBehaviour.Push1, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x7b, FlowControl.Next, false, 0);
        public static readonly OpCode Ldflda = new OpCode("ldflda", StackBehaviour.Popref, StackBehaviour.Pushi, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x7c, FlowControl.Next, false, 0);
        public static readonly OpCode Ldftn = new OpCode("ldftn", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineMethod, OpCodeType.Primitive, 2, 0xfe, 6, FlowControl.Next, false, 1);
        public static readonly OpCode Ldind_I = new OpCode("ldind.i", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4d, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_I1 = new OpCode("ldind.i1", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 70, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_I2 = new OpCode("ldind.i2", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x48, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_I4 = new OpCode("ldind.i4", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4a, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_I8 = new OpCode("ldind.i8", StackBehaviour.Popi, StackBehaviour.Pushi8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4c, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_R4 = new OpCode("ldind.r4", StackBehaviour.Popi, StackBehaviour.Pushr4, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4e, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_R8 = new OpCode("ldind.r8", StackBehaviour.Popi, StackBehaviour.Pushr8, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4f, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_Ref = new OpCode("ldind.ref", StackBehaviour.Popi, StackBehaviour.Pushref, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 80, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_U1 = new OpCode("ldind.u1", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x47, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_U2 = new OpCode("ldind.u2", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x49, FlowControl.Next, false, 0);
        public static readonly OpCode Ldind_U4 = new OpCode("ldind.u4", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x4b, FlowControl.Next, false, 0);
        public static readonly OpCode Ldlen = new OpCode("ldlen", StackBehaviour.Popref, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x8e, FlowControl.Next, false, 0);
        public static readonly OpCode Ldloc = new OpCode("ldloc", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 12, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloc_0 = new OpCode("ldloc.0", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 6, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloc_1 = new OpCode("ldloc.1", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 7, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloc_2 = new OpCode("ldloc.2", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 8, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloc_3 = new OpCode("ldloc.3", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 9, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloc_S = new OpCode("ldloc.s", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 0x11, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloca = new OpCode("ldloca", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 13, FlowControl.Next, false, 1);
        public static readonly OpCode Ldloca_S = new OpCode("ldloca.s", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 0x12, FlowControl.Next, false, 1);
        public static readonly OpCode Ldnull = new OpCode("ldnull", StackBehaviour.Pop0, StackBehaviour.Pushref, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 20, FlowControl.Next, false, 1);
        public static readonly OpCode Ldobj = new OpCode("ldobj", StackBehaviour.Popi, StackBehaviour.Push1, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x71, FlowControl.Next, false, 0);
        public static readonly OpCode Ldsfld = new OpCode("ldsfld", StackBehaviour.Pop0, StackBehaviour.Push1, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x7e, FlowControl.Next, false, 1);
        public static readonly OpCode Ldsflda = new OpCode("ldsflda", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x7f, FlowControl.Next, false, 1);
        public static readonly OpCode Ldstr = new OpCode("ldstr", StackBehaviour.Pop0, StackBehaviour.Pushref, OperandType.InlineString, OpCodeType.Objmodel, 1, 0xff, 0x72, FlowControl.Next, false, 1);
        public static readonly OpCode Ldtoken = new OpCode("ldtoken", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineTok, OpCodeType.Primitive, 1, 0xff, 0xd0, FlowControl.Next, false, 1);
        public static readonly OpCode Ldvirtftn = new OpCode("ldvirtftn", StackBehaviour.Popref, StackBehaviour.Pushi, OperandType.InlineMethod, OpCodeType.Primitive, 2, 0xfe, 7, FlowControl.Next, false, 0);
        public static readonly OpCode Leave = new OpCode("leave", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineBrTarget, OpCodeType.Primitive, 1, 0xff, 0xdd, FlowControl.Branch, true, 0);
        public static readonly OpCode Leave_S = new OpCode("leave.s", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.ShortInlineBrTarget, OpCodeType.Primitive, 1, 0xff, 0xde, FlowControl.Branch, true, 0);
        public static readonly OpCode Localloc = new OpCode("localloc", StackBehaviour.Popi, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 15, FlowControl.Next, false, 0);
        public static readonly OpCode Mkrefany = new OpCode("mkrefany", StackBehaviour.Popi, StackBehaviour.Push1, OperandType.InlineType, OpCodeType.Primitive, 1, 0xff, 0xc6, FlowControl.Next, false, 0);
        public static readonly OpCode Mul = new OpCode("mul", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 90, FlowControl.Next, false, -1);
        public static readonly OpCode Mul_Ovf = new OpCode("mul.ovf", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd8, FlowControl.Next, false, -1);
        public static readonly OpCode Mul_Ovf_Un = new OpCode("mul.ovf.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xd9, FlowControl.Next, false, -1);
        public static readonly OpCode Neg = new OpCode("neg", StackBehaviour.Pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x65, FlowControl.Next, false, 0);
        public static readonly OpCode Newarr = new OpCode("newarr", StackBehaviour.Popi, StackBehaviour.Pushref, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0x8d, FlowControl.Next, false, 0);
        public static readonly OpCode Newobj = new OpCode("newobj", StackBehaviour.Varpop, StackBehaviour.Pushref, OperandType.InlineMethod, OpCodeType.Objmodel, 1, 0xff, 0x73, FlowControl.Call, false, 1);
        public static readonly OpCode Nop = new OpCode("nop", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0, FlowControl.Next, false, 0);
        public static readonly OpCode Not = new OpCode("not", StackBehaviour.Pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x66, FlowControl.Next, false, 0);
        public static readonly OpCode Or = new OpCode("or", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x60, FlowControl.Next, false, -1);
        public static readonly OpCode Pop = new OpCode("pop", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x26, FlowControl.Next, false, -1);
        public static readonly OpCode Prefix1 = new OpCode("prefix1", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xfe, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix2 = new OpCode("prefix2", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xfd, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix3 = new OpCode("prefix3", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xfc, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix4 = new OpCode("prefix4", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xfb, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix5 = new OpCode("prefix5", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 250, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix6 = new OpCode("prefix6", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xf9, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefix7 = new OpCode("prefix7", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xf8, FlowControl.Meta, false, 0);
        public static readonly OpCode Prefixref = new OpCode("prefixref", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Nternal, 1, 0xff, 0xff, FlowControl.Meta, false, 0);
        public static readonly OpCode Readonly = new OpCode("readonly.", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Prefix, 2, 0xfe, 30, FlowControl.Meta, false, 0);
        public static readonly OpCode Refanytype = new OpCode("refanytype", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineNone, OpCodeType.Primitive, 2, 0xfe, 0x1d, FlowControl.Next, false, 0);
        public static readonly OpCode Refanyval = new OpCode("refanyval", StackBehaviour.Pop1, StackBehaviour.Pushi, OperandType.InlineType, OpCodeType.Primitive, 1, 0xff, 0xc2, FlowControl.Next, false, 0);
        public static readonly OpCode Rem = new OpCode("rem", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x5d, FlowControl.Next, false, -1);
        public static readonly OpCode Rem_Un = new OpCode("rem.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x5e, FlowControl.Next, false, -1);
        public static readonly OpCode Ret = new OpCode("ret", StackBehaviour.Varpop, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x2a, FlowControl.Return, true, 0);
        public static readonly OpCode Rethrow = new OpCode("rethrow", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 2, 0xfe, 0x1a, FlowControl.Throw, true, 0);
        public static readonly OpCode Shl = new OpCode("shl", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x62, FlowControl.Next, false, -1);
        public static readonly OpCode Shr = new OpCode("shr", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x63, FlowControl.Next, false, -1);
        public static readonly OpCode Shr_Un = new OpCode("shr.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 100, FlowControl.Next, false, -1);
        public static readonly OpCode Sizeof = new OpCode("sizeof", StackBehaviour.Pop0, StackBehaviour.Pushi, OperandType.InlineType, OpCodeType.Primitive, 2, 0xfe, 0x1c, FlowControl.Next, false, 1);
        public static readonly OpCode Starg = new OpCode("starg", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 11, FlowControl.Next, false, -1);
        public static readonly OpCode Starg_S = new OpCode("starg.s", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 0x10, FlowControl.Next, false, -1);
        public static readonly OpCode Stelem = new OpCode("stelem", StackBehaviour.Popref_popi_pop1, StackBehaviour.Push0, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0xa4, FlowControl.Next, false, 0);
        public static readonly OpCode Stelem_I = new OpCode("stelem.i", StackBehaviour.Popref_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9b, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_I1 = new OpCode("stelem.i1", StackBehaviour.Popref_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9c, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_I2 = new OpCode("stelem.i2", StackBehaviour.Popref_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9d, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_I4 = new OpCode("stelem.i4", StackBehaviour.Popref_popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9e, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_I8 = new OpCode("stelem.i8", StackBehaviour.Popref_popi_popi8, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x9f, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_R4 = new OpCode("stelem.r4", StackBehaviour.Popref_popi_popr4, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 160, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_R8 = new OpCode("stelem.r8", StackBehaviour.Popref_popi_popr8, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0xa1, FlowControl.Next, false, -3);
        public static readonly OpCode Stelem_Ref = new OpCode("stelem.ref", StackBehaviour.Popref_popi_popref, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0xa2, FlowControl.Next, false, -3);
        public static readonly OpCode Stfld = new OpCode("stfld", StackBehaviour.Popref_pop1, StackBehaviour.Push0, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x7d, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_I = new OpCode("stind.i", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xdf, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_I1 = new OpCode("stind.i1", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x52, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_I2 = new OpCode("stind.i2", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x53, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_I4 = new OpCode("stind.i4", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x54, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_I8 = new OpCode("stind.i8", StackBehaviour.Popi_popi8, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x55, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_R4 = new OpCode("stind.r4", StackBehaviour.Popi_popr4, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x56, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_R8 = new OpCode("stind.r8", StackBehaviour.Popi_popr8, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x57, FlowControl.Next, false, -2);
        public static readonly OpCode Stind_Ref = new OpCode("stind.ref", StackBehaviour.Popi_popi, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x51, FlowControl.Next, false, -2);
        public static readonly OpCode Stloc = new OpCode("stloc", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineVar, OpCodeType.Primitive, 2, 0xfe, 14, FlowControl.Next, false, -1);
        public static readonly OpCode Stloc_0 = new OpCode("stloc.0", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 10, FlowControl.Next, false, -1);
        public static readonly OpCode Stloc_1 = new OpCode("stloc.1", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 11, FlowControl.Next, false, -1);
        public static readonly OpCode Stloc_2 = new OpCode("stloc.2", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 12, FlowControl.Next, false, -1);
        public static readonly OpCode Stloc_3 = new OpCode("stloc.3", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Macro, 1, 0xff, 13, FlowControl.Next, false, -1);
        public static readonly OpCode Stloc_S = new OpCode("stloc.s", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.ShortInlineVar, OpCodeType.Macro, 1, 0xff, 0x13, FlowControl.Next, false, -1);
        public static readonly OpCode Stobj = new OpCode("stobj", StackBehaviour.Popi_pop1, StackBehaviour.Push0, OperandType.InlineType, OpCodeType.Primitive, 1, 0xff, 0x81, FlowControl.Next, false, -2);
        public static readonly OpCode Stsfld = new OpCode("stsfld", StackBehaviour.Pop1, StackBehaviour.Push0, OperandType.InlineField, OpCodeType.Objmodel, 1, 0xff, 0x80, FlowControl.Next, false, -1);
        public static readonly OpCode Sub = new OpCode("sub", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x59, FlowControl.Next, false, -1);
        public static readonly OpCode Sub_Ovf = new OpCode("sub.ovf", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xda, FlowControl.Next, false, -1);
        public static readonly OpCode Sub_Ovf_Un = new OpCode("sub.ovf.un", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0xdb, FlowControl.Next, false, -1);
        public static readonly OpCode Switch = new OpCode("switch", StackBehaviour.Popi, StackBehaviour.Push0, OperandType.InlineSwitch, OpCodeType.Primitive, 1, 0xff, 0x45, FlowControl.Cond_Branch, false, -1);
        public static readonly OpCode Tailcall = new OpCode("tail.", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Prefix, 2, 0xfe, 20, FlowControl.Meta, false, 0);
        public static readonly OpCode Throw = new OpCode("throw", StackBehaviour.Popref, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Objmodel, 1, 0xff, 0x7a, FlowControl.Throw, true, -1);
        public static readonly OpCode Unaligned = new OpCode("unaligned.", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.ShortInlineI, OpCodeType.Prefix, 2, 0xfe, 0x12, FlowControl.Meta, false, 0);
        public static readonly OpCode Unbox = new OpCode("unbox", StackBehaviour.Popref, StackBehaviour.Pushi, OperandType.InlineType, OpCodeType.Primitive, 1, 0xff, 0x79, FlowControl.Next, false, 0);
        public static readonly OpCode Unbox_Any = new OpCode("unbox.any", StackBehaviour.Popref, StackBehaviour.Push1, OperandType.InlineType, OpCodeType.Objmodel, 1, 0xff, 0xa5, FlowControl.Next, false, 0);
        public static readonly OpCode Volatile = new OpCode("volatile.", StackBehaviour.Pop0, StackBehaviour.Push0, OperandType.InlineNone, OpCodeType.Prefix, 2, 0xfe, 0x13, FlowControl.Meta, false, 0);
        public static readonly OpCode Xor = new OpCode("xor", StackBehaviour.Pop1_pop1, StackBehaviour.Push1, OperandType.InlineNone, OpCodeType.Primitive, 1, 0xff, 0x61, FlowControl.Next, false, -1);

        // Methods
        private OpCodes()
        {
        }

        public static bool TakesSingleByteArgument(OpCode inst)
        {
            switch(inst.m_operand)
            {
                case OperandType.ShortInlineBrTarget:
                case OperandType.ShortInlineI:
                case OperandType.ShortInlineVar:
                    return true;
            }
            return false;
        }
    }
}