import Head from 'next/head'
import { MenuPageLayout, Feedback } from '@periodic-table-pro/components'
import { useAtom } from 'jotai'
import { themeModeState } from '@periodic-table-pro/components/recoil/atom'

export default function FeedbackPage() {
  const [themeMode] = useAtom(themeModeState)

  return (
    <>
      <Head>
        <title>意见反馈 - 元素周期表PRO 高颜值化学必备小工具</title>
      </Head>
      <div>
        <MenuPageLayout themeClass={themeMode} title="意见反馈">
          <Feedback
            themeClass={themeMode}
            chatPage="https://tawk.to/periodictablepro"
          />
        </MenuPageLayout>
      </div>
    </>
  )
}
