# The Poppins Manifesto

Whether you are building an Open Source program in your company or starting your own way on the OSS world, you may notice that it's not that easy to find projects and communities that are focused on mentoring and guiding beginners and "non-natives" on this journey. Open Source is beautiful, but when you are someone with a heavy background on corporate software development or individual freelancing that does all your stuff alone, there's a tough path until you become an effectivelly OSS contributor. Part of this learning path is definitely getting real work done. But how to find real work for beginners in OSS? There are some tips and resources out there and Poppins is one of these.

## What is Poppins?

Poppins is a kind of project managed to help open source **beginners** to level up their skills and increase their experience in a **mentorship** community atmosphere. Poppins projects have a slower development pace and are not focused on making the best software out there, instead it aims to help beginners make their first contributions following a mentor-based learning approach, covering the main aspects of how to build a good OSS in a healthy community.

Projects created with this purpose may use the Poppins badge [![This is a Poppins project](https://raw.githubusercontent.com/bancodobrasil/poppins/master/badge-poppins.svg)](https://github.com/bancodobrasil/poppins) to identify them as a good place for beginners to make their first contributions and learn how the OSS development works for real.

**Badge code**: `[![This is a Poppins project](https://raw.githubusercontent.com/bancodobrasil/poppins/master/badge-poppins.svg)](https://github.com/bancodobrasil/poppins)`

## Why Poppins?

Part of the OSS mentoring journey is based on courses, readings and tutorials on how to use Git, GitHub, good practices in open source communities, why OSS is a hot thing in the IT industry and so on. After understanding and learning all this stuff you will face the challenge of making your first contribution. Whether you already know the project you want to contribute or not, you can find lots of resources in the Internet on how to find "Good First Issues". Some of them are outdated, but others are automated resources, like the [GitHub good first issues feature](https://github.blog/2020-01-22-how-we-built-good-first-issues/). But those good first issues resources **can be a step too big in your onboarding** process and maybe it would be smoother if you could contribute on projects that are **"good first projects"** before going to the good first issues.

## Guidelines to make a Poppins project

The following guidelines are just suggestions on how to make your project beginner-friendly, but it is not a golden rule. So, if you already have your own set of practices working, keep doing it.! The important thing here is that the project is focused on mentoring beginners and first-contributors.

1. Identify your project as a "Poppins project" by placing this badge [![This is a Poppins project](https://raw.githubusercontent.com/bancodobrasil/poppins/master/badge-poppins.svg)](https://github.com/bancodobrasil/poppins) on top of the README. Badge code: `[![This is a Poppins project](https://raw.githubusercontent.com/bancodobrasil/poppins/master/badge-poppins.svg)](https://github.com/bancodobrasil/poppins)`
1. Don't choose critical or "rush scheduled" projects to be a Poppins project. Remember: the focus of the project is the beginners' journey not the release of the software itself.

1. Follow all the guidelines of https://opensource.guide/building-community/

1. Put as the first or second item on your README this piece of content:

```

## This project was made for first-time contributors and open source beginners

This project follows the [Poppins manifesto guidelines](https://github.com/bancodobrasil/poppins) as part of it's community principles and policies, focusing all the decisions and interactions on providing open source beginners mentorship with real and relevant experiences, respecting each learning pace, background experience, academic formation, questions, suggestions, doubts and opinion. 

## Contribute now!

So, let's start contributing! **Open an issue asking for a task to be done by you**. A mentor/maintainer will come and provide a technical overview of the project and what are the possibles ways of contributing to the project. You will discuss the options and a suitable issue will be assigned or created to you. 

That's it. Just make yourself at home and good luck!


```

1. Put a list of other [awesome](https://github.com/sindresorhus/awesome) Poppins projects at the end of your README

1. Pin a welcoming issue with instructions on how the users can ask for a task to be done. For example: https://github.com/bancodobrasil/poppins/issues/1

1. Keep the issue notifications enabled for all the maintainers of the project so one of them will quickly come and welcome recent users. When you respond gentle and quickly, people will feel they are part of a dialogue, and they’ll be more enthusiastic about participating. Don't let a user more than 48 hours without a response.

1. When a new user creates an issue asking for a task to do, answer him/her with an overview of the project goals, how the tech stack is set, what are the contributing options available and ask him some questions to try to find out what is his technical level so you can write an issue that is perfect for him.

1. Once you created an issue for the user, assign it to him/her and offer any help he/she may need to accomplish the task, whether the struggling being with the code itself, the open source process, the understanding of the problem, lack of documentation and so on. Walk side by side with the user from the day you opened the issue to when the user opens his Pull Request.

1. All the issues **MUST** be beginner-friendly and be labelled as `good first issue` and  `first-timers-only`. If you think the issue you are writing is not a good first issue, try to break it into smaller pieces that could be faced as so.

1. Before making your repo public, guarantee that it has enough documentation on how to run and test it so beginners won't struggle to run a "hello world" with it

1. Keep your issues area clean, leaving just the issues that are assigned to first-contributors and are actually being done.

1. Don't use the issues as a backlog. Keep your backlog in another tool and use it to pick an issue when a first-time contributor arrives and ask for a task to be done.

1. Don't run over the project if there is little first-contributors coming. Instead of rush into the development by yourself, head to Twitter, Hackernews, Reddit, LinkedIn and other sort of social platforms and dev communities out there and announce your project as a receptive place for first-contributors to come. 

1. It is not a rule, but try to build a project with a "non-heavy" tech stack. Prefer libs and frameworks that has lots of tutorials, videos, blogs posts, stackoverflow answers and runs easily in any environment, with no special configurations or OS restrictions.

1. Have fun and learn by teaching!

## Let's fix Poppins! PR, please...

Please, open issues in this Poppins repo bringing all the lessons learned, good examples of projects welcoming and guiding beginners, bring suggestions of what you think a Poppins project must and must no have and finally, make your (first) contribution to Poppins by sending a PR with your name on the [I met Poppins List](I_MET_POPPINS.md)!
