# Music World
A webpage with full of music suggestions from all over the world!
# Welcome to Hacktoberfest #10 2023
![Hacktoberfest Banner](hf10_banner_sponsors_1032x600.png)

![Icon 1](08@1x.png) ![Icon 2](05@1x.png) ![Icon 3](03@1x.png)

⭐ This repository is made for beginners who are looking for a beginner-friendly repository to start open source contributions! 

⭐ Feel free to use this project to make your first contribution to an open-source project on GitHub.

⭐ Star this repository for a better reach!

# What is Hacktoberfest? 🤔
A month-long celebration from October 1st to October 31st presented by Digital Ocean and DEV Community collaborated with GitHub to get people involved in Open Source.

https://hacktoberfest.com/

# Note 🔥
1. To qualify for digital rewards by Hacktoberfest, you must register for the event and make four Pull Requests (PRs) between October 1-31, 2023 (in any time zone).

2. Pull requests can be made in any GitHub or GitLab hosted project that’s participating in Hacktoberfest (look for the “hacktoberfest” topic). 

3. The first 50,000 participants to have their first PR/MR accepted will have a tree planted in their name through Tree Nation

# Contribution Rules 🤍

⭐ Follow these steps to add your song to the webpage:

1. **Navigate to the JSON File**:
   - Open the `musicData.json` in your project directory.

2. **Use the Template**:
   - Copy the provided JSON template structure to use it for your song addition.

    ```json
    {
        "id": ,
        "src": "PASTE_YOUR_SPOTIFY_LINK_HERE",
        "suggestedBy": "your-name"
    }
    ```

3. **Get the Link from Spotify**:
   - Choose your favorite song in Spotify.
   - Navigate to the share options of the song.
   - Select 'Copy Song Link' from the available options.

4. **Paste Your Song's Link**:
   - Return to the `musicData.json`.
   - Replace `PASTE_YOUR_SPOTIFY_LINK_HERE` in the JSON template with the copied song link.

5. **Add Your Name**:
   - In the placeholder `your-name` within the "suggestedBy" field, replace `your-name` with your actual name.

6. **Final Steps**:
   - Once you have made all the necessary changes, save the `musicData.json` file.
   - Proceed to create a pull request for the changes you made. If you're collaborating on a platform like GitHub, ensure to provide a meaningful commit message and pull request description for others to understand your additions.

Your song will be added to the list once the pull request is reviewed and merged! 🎵

⭐ Don't make any other changes in the code! If you find any bug or have a feature suggestion, feel free to raise an issue.

Happy Coding!
