/*
 * Copyright (c) 2020 Legrand North America, LLC.
 *
 * SPDX-License-Identifier: MIT
 */

/* @file
 * @brief test of bsc-socket interface
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <zephyr/ztest.h>
#include <time.h>
#include <bacnet/bacenum.h>
#include <bacnet/datalink/bsc/bsc-socket.h>
#include <bacnet/datalink/bsc/bsc-event.h>
#include <bacnet/datalink/bsc/bsc-util.h>
#include <bacnet/datalink/bsc/bsc-retcodes.h>
#include <bacnet/datalink/bsc/websocket.h>
#include <bacnet/datalink/bsc/bsc-hub-connector.h>
#include <bacnet/datalink/bsc/bsc-hub-function.h>

unsigned char ca_key[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52,
    0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b,
    0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x45,
    0x6f, 0x67, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41,
    0x31, 0x66, 0x7a, 0x73, 0x2b, 0x56, 0x62, 0x46, 0x39, 0x31, 0x65, 0x45,
    0x66, 0x4c, 0x32, 0x67, 0x44, 0x63, 0x6a, 0x79, 0x44, 0x47, 0x68, 0x62,
    0x4d, 0x6f, 0x44, 0x48, 0x6c, 0x71, 0x53, 0x6d, 0x70, 0x78, 0x7a, 0x45,
    0x2b, 0x4a, 0x48, 0x34, 0x6f, 0x46, 0x47, 0x46, 0x42, 0x31, 0x47, 0x48,
    0x0a, 0x69, 0x35, 0x47, 0x7a, 0x33, 0x73, 0x47, 0x51, 0x4d, 0x6e, 0x41,
    0x6e, 0x32, 0x4c, 0x41, 0x6e, 0x51, 0x53, 0x5a, 0x72, 0x46, 0x77, 0x6c,
    0x77, 0x72, 0x48, 0x34, 0x68, 0x43, 0x36, 0x62, 0x6d, 0x4a, 0x33, 0x71,
    0x55, 0x58, 0x72, 0x61, 0x32, 0x64, 0x76, 0x63, 0x45, 0x34, 0x2f, 0x32,
    0x2f, 0x70, 0x74, 0x6b, 0x34, 0x31, 0x47, 0x39, 0x68, 0x75, 0x45, 0x4f,
    0x75, 0x77, 0x69, 0x6b, 0x68, 0x0a, 0x7a, 0x5a, 0x59, 0x65, 0x67, 0x6b,
    0x4b, 0x68, 0x62, 0x78, 0x46, 0x70, 0x77, 0x56, 0x2f, 0x76, 0x48, 0x32,
    0x48, 0x6f, 0x55, 0x45, 0x39, 0x30, 0x4d, 0x43, 0x56, 0x7a, 0x66, 0x59,
    0x56, 0x51, 0x62, 0x6a, 0x38, 0x51, 0x2f, 0x73, 0x51, 0x50, 0x6d, 0x79,
    0x4f, 0x6d, 0x64, 0x76, 0x46, 0x74, 0x4a, 0x41, 0x4e, 0x47, 0x53, 0x2f,
    0x52, 0x58, 0x31, 0x67, 0x6b, 0x2b, 0x6e, 0x7a, 0x67, 0x38, 0x0a, 0x54,
    0x4f, 0x33, 0x6f, 0x4a, 0x45, 0x6b, 0x70, 0x69, 0x6e, 0x67, 0x34, 0x45,
    0x31, 0x4c, 0x4a, 0x2b, 0x63, 0x48, 0x66, 0x45, 0x66, 0x4a, 0x45, 0x49,
    0x5a, 0x4f, 0x4d, 0x69, 0x4e, 0x69, 0x6a, 0x31, 0x4d, 0x72, 0x50, 0x70,
    0x32, 0x4d, 0x63, 0x36, 0x4d, 0x49, 0x7a, 0x54, 0x6f, 0x76, 0x4c, 0x6f,
    0x51, 0x31, 0x38, 0x36, 0x2f, 0x68, 0x63, 0x59, 0x50, 0x36, 0x62, 0x4f,
    0x76, 0x46, 0x59, 0x0a, 0x6d, 0x59, 0x78, 0x68, 0x59, 0x46, 0x30, 0x68,
    0x52, 0x38, 0x4f, 0x57, 0x53, 0x4c, 0x30, 0x55, 0x45, 0x78, 0x69, 0x4e,
    0x6f, 0x64, 0x45, 0x2f, 0x61, 0x70, 0x68, 0x7a, 0x39, 0x41, 0x56, 0x52,
    0x63, 0x6d, 0x79, 0x62, 0x76, 0x62, 0x4f, 0x6c, 0x77, 0x32, 0x4c, 0x71,
    0x44, 0x50, 0x42, 0x43, 0x62, 0x46, 0x6b, 0x72, 0x50, 0x75, 0x4c, 0x7a,
    0x6d, 0x6e, 0x47, 0x6b, 0x78, 0x46, 0x57, 0x41, 0x0a, 0x45, 0x42, 0x65,
    0x52, 0x38, 0x51, 0x43, 0x33, 0x77, 0x72, 0x57, 0x6a, 0x6e, 0x6a, 0x34,
    0x30, 0x71, 0x66, 0x6e, 0x33, 0x78, 0x50, 0x6c, 0x4e, 0x41, 0x73, 0x57,
    0x42, 0x64, 0x7a, 0x52, 0x2f, 0x64, 0x32, 0x43, 0x6d, 0x63, 0x51, 0x49,
    0x44, 0x41, 0x51, 0x41, 0x42, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x43, 0x58,
    0x49, 0x78, 0x7a, 0x38, 0x76, 0x70, 0x7a, 0x30, 0x4a, 0x59, 0x77, 0x64,
    0x7a, 0x0a, 0x70, 0x44, 0x4e, 0x4b, 0x37, 0x42, 0x4a, 0x73, 0x79, 0x73,
    0x32, 0x63, 0x46, 0x36, 0x48, 0x74, 0x36, 0x4d, 0x39, 0x52, 0x4d, 0x53,
    0x61, 0x43, 0x2f, 0x39, 0x65, 0x76, 0x44, 0x55, 0x4a, 0x42, 0x6a, 0x79,
    0x47, 0x42, 0x31, 0x4c, 0x54, 0x63, 0x6b, 0x4d, 0x32, 0x58, 0x4b, 0x44,
    0x49, 0x47, 0x79, 0x4b, 0x65, 0x6b, 0x56, 0x50, 0x78, 0x34, 0x57, 0x6b,
    0x44, 0x61, 0x39, 0x4a, 0x4c, 0x4f, 0x0a, 0x49, 0x59, 0x32, 0x50, 0x41,
    0x32, 0x76, 0x46, 0x37, 0x32, 0x6f, 0x4b, 0x4b, 0x2f, 0x37, 0x6c, 0x36,
    0x31, 0x56, 0x57, 0x76, 0x63, 0x59, 0x6b, 0x39, 0x4b, 0x68, 0x49, 0x71,
    0x79, 0x37, 0x31, 0x66, 0x46, 0x61, 0x45, 0x7a, 0x31, 0x5a, 0x49, 0x31,
    0x61, 0x42, 0x36, 0x2f, 0x71, 0x56, 0x36, 0x66, 0x77, 0x71, 0x58, 0x69,
    0x79, 0x48, 0x44, 0x4a, 0x63, 0x7a, 0x71, 0x6a, 0x2f, 0x33, 0x31, 0x0a,
    0x38, 0x45, 0x48, 0x48, 0x4f, 0x51, 0x55, 0x44, 0x4d, 0x59, 0x34, 0x2f,
    0x4f, 0x55, 0x46, 0x2f, 0x56, 0x37, 0x6f, 0x6f, 0x4b, 0x64, 0x31, 0x33,
    0x67, 0x35, 0x72, 0x7a, 0x4c, 0x41, 0x50, 0x47, 0x4e, 0x74, 0x43, 0x37,
    0x6e, 0x2b, 0x56, 0x6b, 0x6a, 0x41, 0x31, 0x31, 0x78, 0x38, 0x4f, 0x6c,
    0x32, 0x57, 0x62, 0x48, 0x33, 0x64, 0x6a, 0x31, 0x78, 0x4f, 0x47, 0x2f,
    0x66, 0x50, 0x52, 0x57, 0x0a, 0x72, 0x63, 0x69, 0x57, 0x46, 0x61, 0x79,
    0x4a, 0x72, 0x33, 0x71, 0x56, 0x6c, 0x5a, 0x2b, 0x42, 0x79, 0x31, 0x66,
    0x44, 0x43, 0x59, 0x38, 0x31, 0x4d, 0x73, 0x55, 0x56, 0x41, 0x65, 0x55,
    0x57, 0x2f, 0x54, 0x33, 0x6b, 0x39, 0x42, 0x6e, 0x4b, 0x67, 0x36, 0x68,
    0x71, 0x61, 0x33, 0x4a, 0x47, 0x36, 0x37, 0x4e, 0x41, 0x36, 0x42, 0x72,
    0x63, 0x7a, 0x4e, 0x4b, 0x53, 0x4b, 0x47, 0x79, 0x37, 0x0a, 0x70, 0x70,
    0x56, 0x56, 0x41, 0x65, 0x61, 0x47, 0x44, 0x49, 0x73, 0x37, 0x62, 0x73,
    0x43, 0x7a, 0x52, 0x70, 0x45, 0x42, 0x43, 0x67, 0x4e, 0x68, 0x52, 0x42,
    0x5a, 0x45, 0x2f, 0x41, 0x79, 0x65, 0x77, 0x4d, 0x56, 0x6e, 0x42, 0x4a,
    0x62, 0x4b, 0x41, 0x72, 0x6e, 0x72, 0x79, 0x69, 0x69, 0x38, 0x2f, 0x5a,
    0x62, 0x56, 0x51, 0x55, 0x4d, 0x4c, 0x56, 0x48, 0x32, 0x70, 0x68, 0x34,
    0x46, 0x69, 0x0a, 0x6b, 0x2b, 0x30, 0x56, 0x66, 0x56, 0x45, 0x43, 0x67,
    0x59, 0x45, 0x41, 0x2f, 0x5a, 0x45, 0x39, 0x35, 0x71, 0x4b, 0x46, 0x6d,
    0x71, 0x51, 0x65, 0x4f, 0x36, 0x6d, 0x76, 0x42, 0x37, 0x6b, 0x56, 0x6b,
    0x70, 0x56, 0x4b, 0x53, 0x58, 0x47, 0x75, 0x2f, 0x59, 0x35, 0x6b, 0x46,
    0x63, 0x70, 0x4c, 0x57, 0x4f, 0x63, 0x35, 0x45, 0x56, 0x48, 0x4c, 0x36,
    0x46, 0x6d, 0x66, 0x7a, 0x62, 0x71, 0x42, 0x0a, 0x41, 0x78, 0x6f, 0x71,
    0x39, 0x48, 0x68, 0x66, 0x4c, 0x79, 0x39, 0x61, 0x37, 0x4e, 0x7a, 0x73,
    0x61, 0x43, 0x77, 0x30, 0x66, 0x34, 0x56, 0x79, 0x5a, 0x72, 0x73, 0x4f,
    0x61, 0x73, 0x67, 0x42, 0x31, 0x43, 0x42, 0x5a, 0x50, 0x36, 0x30, 0x32,
    0x43, 0x47, 0x69, 0x38, 0x68, 0x62, 0x48, 0x61, 0x6a, 0x4a, 0x4d, 0x77,
    0x4a, 0x67, 0x37, 0x42, 0x39, 0x64, 0x38, 0x52, 0x71, 0x62, 0x67, 0x35,
    0x0a, 0x76, 0x61, 0x6b, 0x45, 0x75, 0x64, 0x70, 0x42, 0x31, 0x68, 0x39,
    0x6a, 0x6d, 0x39, 0x4e, 0x4a, 0x35, 0x61, 0x63, 0x52, 0x37, 0x2f, 0x76,
    0x63, 0x64, 0x56, 0x70, 0x45, 0x67, 0x70, 0x6e, 0x32, 0x6e, 0x50, 0x38,
    0x34, 0x52, 0x6e, 0x2f, 0x4e, 0x36, 0x72, 0x65, 0x75, 0x77, 0x52, 0x56,
    0x61, 0x38, 0x2f, 0x75, 0x2b, 0x59, 0x65, 0x63, 0x43, 0x67, 0x59, 0x45,
    0x41, 0x32, 0x41, 0x70, 0x36, 0x0a, 0x4f, 0x36, 0x78, 0x4d, 0x32, 0x32,
    0x70, 0x4e, 0x44, 0x64, 0x33, 0x70, 0x35, 0x79, 0x50, 0x65, 0x38, 0x36,
    0x38, 0x66, 0x79, 0x66, 0x35, 0x56, 0x35, 0x2f, 0x32, 0x4b, 0x6f, 0x76,
    0x34, 0x76, 0x46, 0x38, 0x77, 0x66, 0x69, 0x73, 0x61, 0x45, 0x63, 0x66,
    0x62, 0x2f, 0x57, 0x62, 0x4a, 0x52, 0x67, 0x77, 0x63, 0x36, 0x2f, 0x6b,
    0x55, 0x55, 0x6b, 0x31, 0x6c, 0x4a, 0x6e, 0x78, 0x6e, 0x47, 0x0a, 0x50,
    0x4b, 0x39, 0x38, 0x48, 0x6d, 0x6a, 0x69, 0x64, 0x35, 0x59, 0x33, 0x39,
    0x64, 0x7a, 0x69, 0x6c, 0x58, 0x67, 0x74, 0x43, 0x36, 0x36, 0x58, 0x56,
    0x41, 0x75, 0x30, 0x4f, 0x4a, 0x30, 0x34, 0x6c, 0x71, 0x69, 0x6c, 0x73,
    0x4d, 0x34, 0x42, 0x53, 0x43, 0x64, 0x6b, 0x6c, 0x69, 0x6d, 0x70, 0x68,
    0x75, 0x46, 0x73, 0x7a, 0x4a, 0x33, 0x50, 0x4f, 0x74, 0x36, 0x55, 0x37,
    0x68, 0x67, 0x42, 0x0a, 0x31, 0x71, 0x73, 0x4b, 0x4d, 0x4b, 0x61, 0x75,
    0x74, 0x6a, 0x33, 0x2f, 0x38, 0x76, 0x32, 0x53, 0x77, 0x63, 0x71, 0x36,
    0x46, 0x49, 0x78, 0x36, 0x6c, 0x36, 0x46, 0x6f, 0x37, 0x71, 0x2b, 0x73,
    0x70, 0x74, 0x56, 0x72, 0x57, 0x65, 0x63, 0x43, 0x67, 0x59, 0x42, 0x2b,
    0x36, 0x63, 0x31, 0x54, 0x76, 0x4a, 0x43, 0x6d, 0x66, 0x2f, 0x4a, 0x70,
    0x35, 0x6c, 0x6f, 0x6d, 0x77, 0x57, 0x71, 0x63, 0x0a, 0x76, 0x59, 0x41,
    0x37, 0x46, 0x6c, 0x32, 0x42, 0x70, 0x31, 0x31, 0x4d, 0x30, 0x72, 0x32,
    0x33, 0x74, 0x37, 0x4f, 0x47, 0x69, 0x61, 0x78, 0x48, 0x6c, 0x57, 0x51,
    0x34, 0x73, 0x6c, 0x71, 0x55, 0x56, 0x4f, 0x71, 0x66, 0x42, 0x67, 0x69,
    0x4f, 0x4d, 0x32, 0x4f, 0x4e, 0x48, 0x6c, 0x35, 0x74, 0x48, 0x59, 0x4d,
    0x42, 0x4f, 0x4b, 0x65, 0x7a, 0x35, 0x33, 0x67, 0x6c, 0x31, 0x67, 0x6d,
    0x6b, 0x0a, 0x52, 0x4c, 0x53, 0x6d, 0x2f, 0x47, 0x6b, 0x49, 0x2b, 0x48,
    0x4d, 0x7a, 0x62, 0x33, 0x74, 0x31, 0x31, 0x4d, 0x33, 0x4b, 0x6e, 0x71,
    0x52, 0x53, 0x44, 0x64, 0x35, 0x6e, 0x56, 0x6b, 0x41, 0x41, 0x50, 0x37,
    0x4b, 0x50, 0x32, 0x30, 0x41, 0x4d, 0x6a, 0x68, 0x56, 0x72, 0x44, 0x75,
    0x76, 0x7a, 0x75, 0x42, 0x56, 0x77, 0x53, 0x6c, 0x31, 0x6a, 0x6c, 0x31,
    0x53, 0x6e, 0x45, 0x61, 0x79, 0x76, 0x0a, 0x6b, 0x38, 0x5a, 0x30, 0x38,
    0x73, 0x37, 0x37, 0x35, 0x67, 0x66, 0x66, 0x75, 0x48, 0x4b, 0x58, 0x6e,
    0x36, 0x38, 0x41, 0x6a, 0x51, 0x4b, 0x42, 0x67, 0x46, 0x58, 0x73, 0x4c,
    0x4e, 0x73, 0x6f, 0x31, 0x74, 0x52, 0x35, 0x50, 0x62, 0x59, 0x6a, 0x4b,
    0x56, 0x44, 0x39, 0x69, 0x6b, 0x47, 0x65, 0x78, 0x2b, 0x54, 0x64, 0x57,
    0x36, 0x74, 0x4e, 0x77, 0x6d, 0x4b, 0x36, 0x39, 0x31, 0x33, 0x65, 0x0a,
    0x6d, 0x44, 0x6a, 0x6f, 0x5a, 0x57, 0x71, 0x79, 0x45, 0x72, 0x4c, 0x49,
    0x34, 0x66, 0x52, 0x62, 0x33, 0x74, 0x47, 0x63, 0x42, 0x65, 0x66, 0x6f,
    0x6e, 0x67, 0x68, 0x43, 0x42, 0x76, 0x37, 0x42, 0x79, 0x48, 0x71, 0x4c,
    0x75, 0x6d, 0x35, 0x58, 0x64, 0x32, 0x41, 0x34, 0x66, 0x6f, 0x46, 0x31,
    0x37, 0x32, 0x78, 0x79, 0x2f, 0x73, 0x71, 0x31, 0x63, 0x50, 0x4d, 0x48,
    0x54, 0x4b, 0x64, 0x57, 0x0a, 0x34, 0x62, 0x63, 0x6b, 0x35, 0x34, 0x75,
    0x62, 0x35, 0x7a, 0x78, 0x31, 0x79, 0x32, 0x2f, 0x53, 0x6e, 0x69, 0x50,
    0x76, 0x4b, 0x36, 0x6b, 0x39, 0x4e, 0x7a, 0x78, 0x4f, 0x6e, 0x67, 0x53,
    0x54, 0x75, 0x42, 0x54, 0x4c, 0x5a, 0x6a, 0x63, 0x6a, 0x42, 0x33, 0x58,
    0x4c, 0x39, 0x68, 0x39, 0x50, 0x45, 0x70, 0x7a, 0x7a, 0x6c, 0x68, 0x70,
    0x53, 0x58, 0x74, 0x70, 0x33, 0x55, 0x68, 0x4a, 0x30, 0x0a, 0x56, 0x53,
    0x4c, 0x48, 0x41, 0x6f, 0x47, 0x41, 0x44, 0x4e, 0x79, 0x6b, 0x52, 0x50,
    0x32, 0x55, 0x38, 0x34, 0x78, 0x70, 0x50, 0x6d, 0x36, 0x77, 0x31, 0x69,
    0x36, 0x72, 0x47, 0x48, 0x71, 0x50, 0x38, 0x67, 0x65, 0x2b, 0x4f, 0x6f,
    0x6f, 0x77, 0x69, 0x47, 0x47, 0x4b, 0x48, 0x54, 0x45, 0x48, 0x72, 0x56,
    0x39, 0x53, 0x79, 0x66, 0x6c, 0x2f, 0x63, 0x42, 0x39, 0x55, 0x4d, 0x65,
    0x79, 0x43, 0x0a, 0x45, 0x49, 0x68, 0x46, 0x37, 0x4e, 0x71, 0x6b, 0x35,
    0x76, 0x2b, 0x4d, 0x68, 0x2b, 0x50, 0x31, 0x52, 0x49, 0x52, 0x71, 0x35,
    0x39, 0x66, 0x4d, 0x41, 0x34, 0x72, 0x4e, 0x7a, 0x6d, 0x61, 0x78, 0x65,
    0x6b, 0x35, 0x72, 0x4b, 0x36, 0x45, 0x50, 0x67, 0x31, 0x62, 0x2f, 0x67,
    0x78, 0x7a, 0x45, 0x73, 0x4c, 0x56, 0x45, 0x45, 0x42, 0x58, 0x49, 0x51,
    0x35, 0x57, 0x57, 0x6e, 0x58, 0x6a, 0x52, 0x0a, 0x75, 0x2b, 0x5a, 0x56,
    0x49, 0x37, 0x33, 0x68, 0x62, 0x36, 0x79, 0x56, 0x56, 0x70, 0x75, 0x6f,
    0x4e, 0x68, 0x52, 0x43, 0x67, 0x59, 0x67, 0x45, 0x70, 0x48, 0x6b, 0x6e,
    0x47, 0x43, 0x45, 0x76, 0x62, 0x55, 0x52, 0x4b, 0x4f, 0x68, 0x79, 0x44,
    0x4d, 0x4e, 0x69, 0x6c, 0x49, 0x6a, 0x31, 0x6d, 0x71, 0x44, 0x4d, 0x3d,
    0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53,
    0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45,
    0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};

unsigned char ca_cert[] = { 0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x42,
                            0x45,
                            0x47,
                            0x49,
                            0x4e,
                            0x20,
                            0x43,
                            0x45,
                            0x52,
                            0x54,
                            0x49,
                            0x46,
                            0x49,
                            0x43,
                            0x41,
                            0x54,
                            0x45,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x0a,
                            0x4d,
                            0x49,
                            0x49,
                            0x44,
                            0x48,
                            0x44,
                            0x43,
                            0x43,
                            0x41,
                            0x67,
                            0x51,
                            0x43,
                            0x43,
                            0x51,
                            0x44,
                            0x43,
                            0x44,
                            0x35,
                            0x33,
                            0x59,
                            0x5a,
                            0x4a,
                            0x4a,
                            0x37,
                            0x6c,
                            0x6a,
                            0x41,
                            0x4e,
                            0x42,
                            0x67,
                            0x6b,
                            0x71,
                            0x68,
                            0x6b,
                            0x69,
                            0x47,
                            0x39,
                            0x77,
                            0x30,
                            0x42,
                            0x41,
                            0x51,
                            0x73,
                            0x46,
                            0x41,
                            0x44,
                            0x42,
                            0x50,
                            0x4d,
                            0x52,
                            0x73,
                            0x77,
                            0x47,
                            0x51,
                            0x59,
                            0x44,
                            0x56,
                            0x51,
                            0x51,
                            0x4b,
                            0x45,
                            0x78,
                            0x4a,
                            0x73,
                            0x0a,
                            0x61,
                            0x57,
                            0x4a,
                            0x33,
                            0x5a,
                            0x57,
                            0x4a,
                            0x7a,
                            0x62,
                            0x32,
                            0x4e,
                            0x72,
                            0x5a,
                            0x58,
                            0x52,
                            0x7a,
                            0x4c,
                            0x58,
                            0x52,
                            0x6c,
                            0x63,
                            0x33,
                            0x51,
                            0x78,
                            0x45,
                            0x6a,
                            0x41,
                            0x51,
                            0x42,
                            0x67,
                            0x4e,
                            0x56,
                            0x42,
                            0x41,
                            0x63,
                            0x54,
                            0x43,
                            0x56,
                            0x68,
                            0x70,
                            0x59,
                            0x57,
                            0x39,
                            0x69,
                            0x61,
                            0x58,
                            0x52,
                            0x68,
                            0x62,
                            0x6a,
                            0x45,
                            0x50,
                            0x4d,
                            0x41,
                            0x30,
                            0x47,
                            0x41,
                            0x31,
                            0x55,
                            0x45,
                            0x43,
                            0x42,
                            0x4d,
                            0x47,
                            0x0a,
                            0x56,
                            0x47,
                            0x46,
                            0x70,
                            0x63,
                            0x47,
                            0x56,
                            0x70,
                            0x4d,
                            0x51,
                            0x73,
                            0x77,
                            0x43,
                            0x51,
                            0x59,
                            0x44,
                            0x56,
                            0x51,
                            0x51,
                            0x47,
                            0x45,
                            0x77,
                            0x4a,
                            0x55,
                            0x56,
                            0x7a,
                            0x41,
                            0x67,
                            0x46,
                            0x77,
                            0x30,
                            0x79,
                            0x4d,
                            0x6a,
                            0x41,
                            0x33,
                            0x4d,
                            0x44,
                            0x59,
                            0x78,
                            0x4d,
                            0x54,
                            0x49,
                            0x30,
                            0x4d,
                            0x6a,
                            0x42,
                            0x61,
                            0x47,
                            0x41,
                            0x38,
                            0x79,
                            0x4d,
                            0x44,
                            0x55,
                            0x77,
                            0x4d,
                            0x44,
                            0x63,
                            0x78,
                            0x4f,
                            0x54,
                            0x45,
                            0x78,
                            0x0a,
                            0x4d,
                            0x6a,
                            0x51,
                            0x79,
                            0x4d,
                            0x46,
                            0x6f,
                            0x77,
                            0x54,
                            0x7a,
                            0x45,
                            0x62,
                            0x4d,
                            0x42,
                            0x6b,
                            0x47,
                            0x41,
                            0x31,
                            0x55,
                            0x45,
                            0x43,
                            0x68,
                            0x4d,
                            0x53,
                            0x62,
                            0x47,
                            0x6c,
                            0x69,
                            0x64,
                            0x32,
                            0x56,
                            0x69,
                            0x63,
                            0x32,
                            0x39,
                            0x6a,
                            0x61,
                            0x32,
                            0x56,
                            0x30,
                            0x63,
                            0x79,
                            0x31,
                            0x30,
                            0x5a,
                            0x58,
                            0x4e,
                            0x30,
                            0x4d,
                            0x52,
                            0x49,
                            0x77,
                            0x45,
                            0x41,
                            0x59,
                            0x44,
                            0x56,
                            0x51,
                            0x51,
                            0x48,
                            0x45,
                            0x77,
                            0x6c,
                            0x59,
                            0x0a,
                            0x61,
                            0x57,
                            0x46,
                            0x76,
                            0x59,
                            0x6d,
                            0x6c,
                            0x30,
                            0x59,
                            0x57,
                            0x34,
                            0x78,
                            0x44,
                            0x7a,
                            0x41,
                            0x4e,
                            0x42,
                            0x67,
                            0x4e,
                            0x56,
                            0x42,
                            0x41,
                            0x67,
                            0x54,
                            0x42,
                            0x6c,
                            0x52,
                            0x68,
                            0x61,
                            0x58,
                            0x42,
                            0x6c,
                            0x61,
                            0x54,
                            0x45,
                            0x4c,
                            0x4d,
                            0x41,
                            0x6b,
                            0x47,
                            0x41,
                            0x31,
                            0x55,
                            0x45,
                            0x42,
                            0x68,
                            0x4d,
                            0x43,
                            0x56,
                            0x46,
                            0x63,
                            0x77,
                            0x67,
                            0x67,
                            0x45,
                            0x69,
                            0x4d,
                            0x41,
                            0x30,
                            0x47,
                            0x43,
                            0x53,
                            0x71,
                            0x47,
                            0x0a,
                            0x53,
                            0x49,
                            0x62,
                            0x33,
                            0x44,
                            0x51,
                            0x45,
                            0x42,
                            0x41,
                            0x51,
                            0x55,
                            0x41,
                            0x41,
                            0x34,
                            0x49,
                            0x42,
                            0x44,
                            0x77,
                            0x41,
                            0x77,
                            0x67,
                            0x67,
                            0x45,
                            0x4b,
                            0x41,
                            0x6f,
                            0x49,
                            0x42,
                            0x41,
                            0x51,
                            0x44,
                            0x56,
                            0x2f,
                            0x4f,
                            0x7a,
                            0x35,
                            0x56,
                            0x73,
                            0x58,
                            0x33,
                            0x56,
                            0x34,
                            0x52,
                            0x38,
                            0x76,
                            0x61,
                            0x41,
                            0x4e,
                            0x79,
                            0x50,
                            0x49,
                            0x4d,
                            0x61,
                            0x46,
                            0x73,
                            0x79,
                            0x67,
                            0x4d,
                            0x65,
                            0x57,
                            0x70,
                            0x4b,
                            0x61,
                            0x6e,
                            0x0a,
                            0x48,
                            0x4d,
                            0x54,
                            0x34,
                            0x6b,
                            0x66,
                            0x69,
                            0x67,
                            0x55,
                            0x59,
                            0x55,
                            0x48,
                            0x55,
                            0x59,
                            0x65,
                            0x4c,
                            0x6b,
                            0x62,
                            0x50,
                            0x65,
                            0x77,
                            0x5a,
                            0x41,
                            0x79,
                            0x63,
                            0x43,
                            0x66,
                            0x59,
                            0x73,
                            0x43,
                            0x64,
                            0x42,
                            0x4a,
                            0x6d,
                            0x73,
                            0x58,
                            0x43,
                            0x58,
                            0x43,
                            0x73,
                            0x66,
                            0x69,
                            0x45,
                            0x4c,
                            0x70,
                            0x75,
                            0x59,
                            0x6e,
                            0x65,
                            0x70,
                            0x52,
                            0x65,
                            0x74,
                            0x72,
                            0x5a,
                            0x32,
                            0x39,
                            0x77,
                            0x54,
                            0x6a,
                            0x2f,
                            0x62,
                            0x2b,
                            0x6d,
                            0x0a,
                            0x32,
                            0x54,
                            0x6a,
                            0x55,
                            0x62,
                            0x32,
                            0x47,
                            0x34,
                            0x51,
                            0x36,
                            0x37,
                            0x43,
                            0x4b,
                            0x53,
                            0x48,
                            0x4e,
                            0x6c,
                            0x68,
                            0x36,
                            0x43,
                            0x51,
                            0x71,
                            0x46,
                            0x76,
                            0x45,
                            0x57,
                            0x6e,
                            0x42,
                            0x58,
                            0x2b,
                            0x38,
                            0x66,
                            0x59,
                            0x65,
                            0x68,
                            0x51,
                            0x54,
                            0x33,
                            0x51,
                            0x77,
                            0x4a,
                            0x58,
                            0x4e,
                            0x39,
                            0x68,
                            0x56,
                            0x42,
                            0x75,
                            0x50,
                            0x78,
                            0x44,
                            0x2b,
                            0x78,
                            0x41,
                            0x2b,
                            0x62,
                            0x49,
                            0x36,
                            0x5a,
                            0x32,
                            0x38,
                            0x57,
                            0x30,
                            0x6b,
                            0x0a,
                            0x41,
                            0x30,
                            0x5a,
                            0x4c,
                            0x39,
                            0x46,
                            0x66,
                            0x57,
                            0x43,
                            0x54,
                            0x36,
                            0x66,
                            0x4f,
                            0x44,
                            0x78,
                            0x4d,
                            0x37,
                            0x65,
                            0x67,
                            0x6b,
                            0x53,
                            0x53,
                            0x6d,
                            0x4b,
                            0x65,
                            0x44,
                            0x67,
                            0x54,
                            0x55,
                            0x73,
                            0x6e,
                            0x35,
                            0x77,
                            0x64,
                            0x38,
                            0x52,
                            0x38,
                            0x6b,
                            0x51,
                            0x68,
                            0x6b,
                            0x34,
                            0x79,
                            0x49,
                            0x32,
                            0x4b,
                            0x50,
                            0x55,
                            0x79,
                            0x73,
                            0x2b,
                            0x6e,
                            0x59,
                            0x78,
                            0x7a,
                            0x6f,
                            0x77,
                            0x6a,
                            0x4e,
                            0x4f,
                            0x69,
                            0x38,
                            0x75,
                            0x68,
                            0x0a,
                            0x44,
                            0x58,
                            0x7a,
                            0x72,
                            0x2b,
                            0x46,
                            0x78,
                            0x67,
                            0x2f,
                            0x70,
                            0x73,
                            0x36,
                            0x38,
                            0x56,
                            0x69,
                            0x5a,
                            0x6a,
                            0x47,
                            0x46,
                            0x67,
                            0x58,
                            0x53,
                            0x46,
                            0x48,
                            0x77,
                            0x35,
                            0x5a,
                            0x49,
                            0x76,
                            0x52,
                            0x51,
                            0x54,
                            0x47,
                            0x49,
                            0x32,
                            0x68,
                            0x30,
                            0x54,
                            0x39,
                            0x71,
                            0x6d,
                            0x48,
                            0x50,
                            0x30,
                            0x42,
                            0x56,
                            0x46,
                            0x79,
                            0x62,
                            0x4a,
                            0x75,
                            0x39,
                            0x73,
                            0x36,
                            0x58,
                            0x44,
                            0x59,
                            0x75,
                            0x6f,
                            0x4d,
                            0x38,
                            0x45,
                            0x4a,
                            0x73,
                            0x0a,
                            0x57,
                            0x53,
                            0x73,
                            0x2b,
                            0x34,
                            0x76,
                            0x4f,
                            0x61,
                            0x63,
                            0x61,
                            0x54,
                            0x45,
                            0x56,
                            0x59,
                            0x41,
                            0x51,
                            0x46,
                            0x35,
                            0x48,
                            0x78,
                            0x41,
                            0x4c,
                            0x66,
                            0x43,
                            0x74,
                            0x61,
                            0x4f,
                            0x65,
                            0x50,
                            0x6a,
                            0x53,
                            0x70,
                            0x2b,
                            0x66,
                            0x66,
                            0x45,
                            0x2b,
                            0x55,
                            0x30,
                            0x43,
                            0x78,
                            0x59,
                            0x46,
                            0x33,
                            0x4e,
                            0x48,
                            0x39,
                            0x33,
                            0x59,
                            0x4b,
                            0x5a,
                            0x78,
                            0x41,
                            0x67,
                            0x4d,
                            0x42,
                            0x41,
                            0x41,
                            0x45,
                            0x77,
                            0x44,
                            0x51,
                            0x59,
                            0x4a,
                            0x0a,
                            0x4b,
                            0x6f,
                            0x5a,
                            0x49,
                            0x68,
                            0x76,
                            0x63,
                            0x4e,
                            0x41,
                            0x51,
                            0x45,
                            0x4c,
                            0x42,
                            0x51,
                            0x41,
                            0x44,
                            0x67,
                            0x67,
                            0x45,
                            0x42,
                            0x41,
                            0x49,
                            0x6d,
                            0x4a,
                            0x76,
                            0x71,
                            0x6e,
                            0x70,
                            0x50,
                            0x64,
                            0x53,
                            0x75,
                            0x46,
                            0x4f,
                            0x5a,
                            0x54,
                            0x36,
                            0x76,
                            0x74,
                            0x48,
                            0x31,
                            0x70,
                            0x4a,
                            0x43,
                            0x45,
                            0x76,
                            0x4a,
                            0x39,
                            0x62,
                            0x53,
                            0x78,
                            0x31,
                            0x43,
                            0x41,
                            0x76,
                            0x36,
                            0x46,
                            0x34,
                            0x46,
                            0x44,
                            0x6f,
                            0x77,
                            0x4b,
                            0x77,
                            0x0a,
                            0x43,
                            0x71,
                            0x4b,
                            0x53,
                            0x6c,
                            0x59,
                            0x45,
                            0x6a,
                            0x72,
                            0x49,
                            0x4c,
                            0x64,
                            0x6c,
                            0x42,
                            0x30,
                            0x39,
                            0x32,
                            0x31,
                            0x4f,
                            0x54,
                            0x30,
                            0x76,
                            0x61,
                            0x68,
                            0x33,
                            0x6c,
                            0x55,
                            0x76,
                            0x2f,
                            0x6b,
                            0x47,
                            0x4e,
                            0x4c,
                            0x76,
                            0x58,
                            0x55,
                            0x71,
                            0x54,
                            0x69,
                            0x42,
                            0x61,
                            0x6b,
                            0x77,
                            0x66,
                            0x52,
                            0x47,
                            0x30,
                            0x39,
                            0x61,
                            0x49,
                            0x45,
                            0x6e,
                            0x53,
                            0x68,
                            0x6d,
                            0x79,
                            0x6f,
                            0x30,
                            0x68,
                            0x63,
                            0x65,
                            0x4f,
                            0x68,
                            0x33,
                            0x0a,
                            0x4f,
                            0x31,
                            0x4b,
                            0x4b,
                            0x59,
                            0x76,
                            0x4a,
                            0x32,
                            0x6a,
                            0x4a,
                            0x47,
                            0x6b,
                            0x36,
                            0x50,
                            0x6c,
                            0x52,
                            0x78,
                            0x65,
                            0x53,
                            0x67,
                            0x37,
                            0x64,
                            0x35,
                            0x4d,
                            0x69,
                            0x37,
                            0x58,
                            0x67,
                            0x6e,
                            0x41,
                            0x64,
                            0x65,
                            0x61,
                            0x78,
                            0x77,
                            0x68,
                            0x75,
                            0x76,
                            0x5a,
                            0x5a,
                            0x6d,
                            0x61,
                            0x49,
                            0x7a,
                            0x62,
                            0x68,
                            0x41,
                            0x57,
                            0x50,
                            0x38,
                            0x71,
                            0x67,
                            0x49,
                            0x30,
                            0x36,
                            0x50,
                            0x32,
                            0x52,
                            0x42,
                            0x53,
                            0x35,
                            0x42,
                            0x4a,
                            0x76,
                            0x0a,
                            0x72,
                            0x44,
                            0x44,
                            0x33,
                            0x44,
                            0x68,
                            0x77,
                            0x38,
                            0x4e,
                            0x38,
                            0x47,
                            0x77,
                            0x42,
                            0x44,
                            0x31,
                            0x52,
                            0x59,
                            0x32,
                            0x79,
                            0x4b,
                            0x72,
                            0x79,
                            0x46,
                            0x51,
                            0x2b,
                            0x34,
                            0x55,
                            0x32,
                            0x31,
                            0x45,
                            0x72,
                            0x73,
                            0x77,
                            0x2f,
                            0x33,
                            0x38,
                            0x63,
                            0x59,
                            0x38,
                            0x55,
                            0x41,
                            0x46,
                            0x54,
                            0x6b,
                            0x67,
                            0x33,
                            0x72,
                            0x57,
                            0x72,
                            0x34,
                            0x44,
                            0x57,
                            0x78,
                            0x36,
                            0x74,
                            0x6e,
                            0x49,
                            0x66,
                            0x64,
                            0x72,
                            0x4e,
                            0x31,
                            0x49,
                            0x49,
                            0x0a,
                            0x70,
                            0x52,
                            0x71,
                            0x53,
                            0x78,
                            0x48,
                            0x51,
                            0x57,
                            0x34,
                            0x6b,
                            0x5a,
                            0x61,
                            0x67,
                            0x31,
                            0x75,
                            0x5a,
                            0x64,
                            0x46,
                            0x63,
                            0x53,
                            0x69,
                            0x61,
                            0x59,
                            0x54,
                            0x2b,
                            0x65,
                            0x62,
                            0x4c,
                            0x57,
                            0x56,
                            0x58,
                            0x41,
                            0x7a,
                            0x62,
                            0x66,
                            0x4a,
                            0x4c,
                            0x4f,
                            0x56,
                            0x38,
                            0x45,
                            0x46,
                            0x46,
                            0x33,
                            0x52,
                            0x44,
                            0x43,
                            0x2f,
                            0x41,
                            0x33,
                            0x55,
                            0x33,
                            0x56,
                            0x63,
                            0x4f,
                            0x52,
                            0x44,
                            0x42,
                            0x44,
                            0x57,
                            0x44,
                            0x68,
                            0x6d,
                            0x68,
                            0x0a,
                            0x38,
                            0x72,
                            0x34,
                            0x54,
                            0x2b,
                            0x36,
                            0x46,
                            0x67,
                            0x67,
                            0x59,
                            0x4c,
                            0x32,
                            0x65,
                            0x6a,
                            0x4d,
                            0x6d,
                            0x66,
                            0x77,
                            0x62,
                            0x65,
                            0x77,
                            0x7a,
                            0x49,
                            0x2b,
                            0x48,
                            0x6d,
                            0x34,
                            0x53,
                            0x69,
                            0x64,
                            0x67,
                            0x4f,
                            0x78,
                            0x4c,
                            0x66,
                            0x31,
                            0x46,
                            0x78,
                            0x31,
                            0x64,
                            0x32,
                            0x76,
                            0x34,
                            0x3d,
                            0x0a,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x45,
                            0x4e,
                            0x44,
                            0x20,
                            0x43,
                            0x45,
                            0x52,
                            0x54,
                            0x49,
                            0x46,
                            0x49,
                            0x43,
                            0x41,
                            0x54,
                            0x45,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x2d,
                            0x0a
#ifdef CONFIG_MBEDTLS
                            ,
                            0x00
#endif
};

unsigned char client_key[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52,
    0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b,
    0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x4a,
    0x4b, 0x51, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x67, 0x45, 0x41,
    0x72, 0x77, 0x53, 0x79, 0x4e, 0x6e, 0x68, 0x66, 0x76, 0x44, 0x69, 0x63,
    0x47, 0x4a, 0x4f, 0x42, 0x66, 0x55, 0x51, 0x4c, 0x47, 0x45, 0x70, 0x4b,
    0x43, 0x32, 0x2f, 0x4e, 0x32, 0x35, 0x54, 0x6f, 0x32, 0x4b, 0x66, 0x36,
    0x36, 0x7a, 0x6b, 0x44, 0x62, 0x33, 0x6d, 0x34, 0x49, 0x50, 0x77, 0x4c,
    0x0a, 0x63, 0x63, 0x78, 0x47, 0x57, 0x48, 0x57, 0x75, 0x65, 0x78, 0x69,
    0x70, 0x6d, 0x76, 0x41, 0x77, 0x46, 0x2b, 0x58, 0x32, 0x36, 0x46, 0x47,
    0x7a, 0x35, 0x66, 0x4a, 0x64, 0x71, 0x38, 0x46, 0x68, 0x77, 0x6c, 0x71,
    0x2b, 0x6e, 0x71, 0x6a, 0x34, 0x50, 0x68, 0x6c, 0x2f, 0x51, 0x2b, 0x77,
    0x55, 0x42, 0x6c, 0x51, 0x2b, 0x58, 0x4d, 0x6a, 0x71, 0x49, 0x70, 0x77,
    0x79, 0x7a, 0x70, 0x5a, 0x6d, 0x0a, 0x34, 0x48, 0x6d, 0x2b, 0x4f, 0x4f,
    0x43, 0x4b, 0x66, 0x73, 0x79, 0x58, 0x64, 0x6d, 0x4c, 0x4c, 0x70, 0x46,
    0x79, 0x56, 0x6b, 0x34, 0x72, 0x72, 0x32, 0x47, 0x51, 0x34, 0x4b, 0x46,
    0x53, 0x51, 0x58, 0x51, 0x58, 0x79, 0x5a, 0x78, 0x78, 0x62, 0x4e, 0x46,
    0x64, 0x67, 0x6e, 0x43, 0x72, 0x76, 0x6d, 0x74, 0x6b, 0x49, 0x42, 0x51,
    0x62, 0x76, 0x6d, 0x6e, 0x42, 0x79, 0x50, 0x2b, 0x77, 0x6e, 0x0a, 0x65,
    0x7a, 0x68, 0x55, 0x51, 0x4b, 0x4c, 0x6b, 0x6d, 0x51, 0x50, 0x32, 0x53,
    0x6a, 0x37, 0x65, 0x52, 0x7a, 0x4c, 0x6f, 0x79, 0x58, 0x32, 0x71, 0x41,
    0x49, 0x75, 0x43, 0x46, 0x59, 0x62, 0x57, 0x41, 0x36, 0x44, 0x57, 0x53,
    0x39, 0x50, 0x4c, 0x56, 0x75, 0x67, 0x71, 0x53, 0x76, 0x4c, 0x65, 0x51,
    0x71, 0x7a, 0x31, 0x74, 0x70, 0x32, 0x66, 0x5a, 0x70, 0x68, 0x42, 0x64,
    0x6a, 0x66, 0x49, 0x0a, 0x6c, 0x65, 0x44, 0x42, 0x75, 0x7a, 0x59, 0x67,
    0x42, 0x30, 0x61, 0x63, 0x39, 0x79, 0x44, 0x48, 0x31, 0x6d, 0x65, 0x65,
    0x51, 0x4f, 0x43, 0x4e, 0x50, 0x61, 0x7a, 0x52, 0x41, 0x63, 0x57, 0x57,
    0x77, 0x75, 0x2b, 0x6f, 0x56, 0x57, 0x6d, 0x45, 0x42, 0x45, 0x6b, 0x50,
    0x44, 0x49, 0x31, 0x70, 0x68, 0x75, 0x6e, 0x44, 0x39, 0x33, 0x33, 0x47,
    0x31, 0x52, 0x63, 0x57, 0x64, 0x6d, 0x51, 0x55, 0x0a, 0x72, 0x37, 0x6b,
    0x48, 0x65, 0x50, 0x4d, 0x50, 0x77, 0x35, 0x70, 0x33, 0x42, 0x7a, 0x2b,
    0x71, 0x6a, 0x71, 0x61, 0x48, 0x2b, 0x36, 0x6f, 0x43, 0x54, 0x68, 0x5a,
    0x43, 0x6f, 0x2b, 0x59, 0x55, 0x39, 0x68, 0x51, 0x2f, 0x34, 0x2b, 0x48,
    0x77, 0x4d, 0x4e, 0x79, 0x38, 0x51, 0x73, 0x79, 0x6a, 0x61, 0x6d, 0x66,
    0x37, 0x31, 0x7a, 0x35, 0x67, 0x34, 0x43, 0x68, 0x65, 0x32, 0x34, 0x51,
    0x50, 0x0a, 0x66, 0x63, 0x6e, 0x30, 0x33, 0x57, 0x79, 0x2f, 0x5a, 0x52,
    0x61, 0x75, 0x53, 0x67, 0x73, 0x51, 0x6e, 0x79, 0x7a, 0x68, 0x72, 0x5a,
    0x7a, 0x39, 0x57, 0x4a, 0x35, 0x2b, 0x38, 0x77, 0x55, 0x71, 0x6a, 0x34,
    0x34, 0x51, 0x38, 0x45, 0x36, 0x70, 0x59, 0x52, 0x4c, 0x30, 0x68, 0x34,
    0x78, 0x65, 0x49, 0x73, 0x45, 0x4f, 0x76, 0x2b, 0x49, 0x77, 0x4e, 0x62,
    0x56, 0x59, 0x6d, 0x38, 0x57, 0x31, 0x0a, 0x62, 0x48, 0x5a, 0x62, 0x64,
    0x57, 0x31, 0x53, 0x65, 0x4d, 0x77, 0x70, 0x74, 0x45, 0x62, 0x37, 0x47,
    0x50, 0x67, 0x55, 0x61, 0x4f, 0x2f, 0x79, 0x4a, 0x7a, 0x2f, 0x68, 0x4b,
    0x71, 0x63, 0x72, 0x70, 0x49, 0x4a, 0x37, 0x2f, 0x49, 0x6f, 0x61, 0x41,
    0x54, 0x4b, 0x2b, 0x6a, 0x39, 0x70, 0x38, 0x32, 0x62, 0x33, 0x51, 0x69,
    0x32, 0x2f, 0x55, 0x54, 0x70, 0x71, 0x49, 0x44, 0x49, 0x67, 0x79, 0x0a,
    0x79, 0x5a, 0x41, 0x4c, 0x55, 0x6b, 0x36, 0x68, 0x57, 0x48, 0x39, 0x37,
    0x53, 0x6f, 0x4d, 0x61, 0x71, 0x6b, 0x68, 0x55, 0x6a, 0x73, 0x44, 0x38,
    0x36, 0x7a, 0x50, 0x32, 0x31, 0x4b, 0x48, 0x45, 0x4e, 0x35, 0x47, 0x35,
    0x6b, 0x58, 0x33, 0x36, 0x41, 0x77, 0x79, 0x66, 0x53, 0x45, 0x41, 0x6d,
    0x52, 0x76, 0x6c, 0x48, 0x63, 0x7a, 0x47, 0x6a, 0x78, 0x66, 0x71, 0x51,
    0x50, 0x42, 0x71, 0x7a, 0x0a, 0x4d, 0x63, 0x65, 0x39, 0x46, 0x53, 0x78,
    0x39, 0x4e, 0x2b, 0x52, 0x39, 0x62, 0x77, 0x2f, 0x56, 0x42, 0x73, 0x66,
    0x43, 0x63, 0x7a, 0x46, 0x35, 0x4c, 0x4b, 0x6d, 0x37, 0x52, 0x6f, 0x6a,
    0x48, 0x44, 0x35, 0x7a, 0x77, 0x4f, 0x62, 0x4f, 0x33, 0x36, 0x57, 0x7a,
    0x74, 0x75, 0x50, 0x61, 0x62, 0x62, 0x6f, 0x66, 0x7a, 0x30, 0x6d, 0x46,
    0x69, 0x56, 0x79, 0x75, 0x46, 0x33, 0x63, 0x4f, 0x62, 0x0a, 0x2f, 0x74,
    0x71, 0x47, 0x56, 0x56, 0x39, 0x33, 0x6e, 0x49, 0x72, 0x41, 0x42, 0x62,
    0x79, 0x2f, 0x44, 0x62, 0x42, 0x62, 0x49, 0x51, 0x4a, 0x58, 0x4c, 0x73,
    0x73, 0x74, 0x6e, 0x70, 0x77, 0x70, 0x6c, 0x5a, 0x62, 0x61, 0x5a, 0x6b,
    0x59, 0x71, 0x50, 0x76, 0x4f, 0x37, 0x47, 0x52, 0x56, 0x37, 0x30, 0x48,
    0x38, 0x77, 0x4e, 0x4f, 0x35, 0x4f, 0x66, 0x33, 0x4d, 0x43, 0x41, 0x77,
    0x45, 0x41, 0x0a, 0x41, 0x51, 0x4b, 0x43, 0x41, 0x67, 0x42, 0x6c, 0x78,
    0x33, 0x56, 0x62, 0x39, 0x2b, 0x53, 0x30, 0x73, 0x4c, 0x63, 0x57, 0x45,
    0x37, 0x48, 0x61, 0x42, 0x78, 0x66, 0x73, 0x71, 0x45, 0x63, 0x6e, 0x48,
    0x33, 0x32, 0x33, 0x6c, 0x49, 0x46, 0x55, 0x66, 0x56, 0x75, 0x4f, 0x4c,
    0x7a, 0x6d, 0x77, 0x4f, 0x6a, 0x69, 0x35, 0x39, 0x64, 0x6b, 0x78, 0x39,
    0x48, 0x6c, 0x30, 0x4e, 0x2f, 0x75, 0x66, 0x0a, 0x32, 0x6c, 0x66, 0x48,
    0x6f, 0x71, 0x5a, 0x56, 0x50, 0x34, 0x61, 0x32, 0x30, 0x38, 0x79, 0x71,
    0x6a, 0x4b, 0x65, 0x73, 0x6d, 0x6d, 0x6b, 0x66, 0x66, 0x57, 0x59, 0x64,
    0x48, 0x6d, 0x59, 0x2b, 0x74, 0x74, 0x55, 0x72, 0x79, 0x72, 0x35, 0x61,
    0x62, 0x2b, 0x4e, 0x55, 0x55, 0x67, 0x4c, 0x57, 0x33, 0x62, 0x38, 0x75,
    0x4a, 0x49, 0x6a, 0x76, 0x51, 0x64, 0x30, 0x39, 0x64, 0x6c, 0x63, 0x55,
    0x0a, 0x4a, 0x69, 0x5a, 0x75, 0x30, 0x6b, 0x56, 0x61, 0x37, 0x2f, 0x79,
    0x4d, 0x4d, 0x4e, 0x32, 0x32, 0x6d, 0x5a, 0x47, 0x4f, 0x34, 0x70, 0x36,
    0x52, 0x65, 0x6b, 0x50, 0x64, 0x63, 0x73, 0x41, 0x58, 0x55, 0x44, 0x6a,
    0x2b, 0x6d, 0x48, 0x6c, 0x2b, 0x73, 0x33, 0x66, 0x57, 0x64, 0x4a, 0x49,
    0x69, 0x58, 0x67, 0x49, 0x53, 0x36, 0x6d, 0x4b, 0x4c, 0x5a, 0x64, 0x61,
    0x5a, 0x51, 0x43, 0x46, 0x77, 0x0a, 0x57, 0x72, 0x31, 0x2f, 0x72, 0x38,
    0x2f, 0x54, 0x31, 0x2b, 0x64, 0x49, 0x52, 0x61, 0x76, 0x33, 0x5a, 0x53,
    0x6e, 0x68, 0x47, 0x75, 0x69, 0x61, 0x63, 0x34, 0x34, 0x72, 0x79, 0x70,
    0x38, 0x56, 0x69, 0x79, 0x34, 0x4e, 0x4a, 0x2b, 0x2f, 0x5a, 0x46, 0x6e,
    0x78, 0x4f, 0x46, 0x70, 0x76, 0x38, 0x4c, 0x63, 0x37, 0x6a, 0x30, 0x4d,
    0x7a, 0x31, 0x58, 0x42, 0x39, 0x4e, 0x6e, 0x38, 0x78, 0x41, 0x0a, 0x62,
    0x76, 0x41, 0x5a, 0x52, 0x78, 0x62, 0x76, 0x75, 0x4a, 0x4a, 0x76, 0x61,
    0x43, 0x61, 0x37, 0x46, 0x79, 0x54, 0x30, 0x77, 0x74, 0x4e, 0x4a, 0x79,
    0x64, 0x55, 0x36, 0x31, 0x6f, 0x48, 0x50, 0x66, 0x43, 0x30, 0x6b, 0x50,
    0x35, 0x68, 0x2b, 0x76, 0x4c, 0x4d, 0x5a, 0x32, 0x69, 0x73, 0x6e, 0x41,
    0x4b, 0x59, 0x76, 0x63, 0x30, 0x51, 0x55, 0x62, 0x4b, 0x58, 0x4c, 0x30,
    0x49, 0x33, 0x36, 0x0a, 0x55, 0x6e, 0x6d, 0x6c, 0x33, 0x59, 0x42, 0x79,
    0x4e, 0x4b, 0x59, 0x66, 0x31, 0x46, 0x35, 0x43, 0x79, 0x75, 0x38, 0x32,
    0x49, 0x54, 0x64, 0x50, 0x59, 0x37, 0x64, 0x43, 0x39, 0x39, 0x55, 0x6f,
    0x6e, 0x2f, 0x47, 0x35, 0x66, 0x52, 0x55, 0x56, 0x6e, 0x61, 0x6d, 0x58,
    0x34, 0x41, 0x2b, 0x4e, 0x62, 0x66, 0x47, 0x45, 0x68, 0x6c, 0x4a, 0x32,
    0x58, 0x58, 0x55, 0x51, 0x58, 0x54, 0x69, 0x68, 0x0a, 0x41, 0x77, 0x46,
    0x75, 0x5a, 0x48, 0x72, 0x54, 0x48, 0x41, 0x4a, 0x58, 0x39, 0x64, 0x6f,
    0x77, 0x34, 0x4c, 0x51, 0x51, 0x75, 0x49, 0x68, 0x44, 0x50, 0x4f, 0x59,
    0x55, 0x4e, 0x7a, 0x5a, 0x6f, 0x34, 0x57, 0x30, 0x34, 0x44, 0x44, 0x4a,
    0x2b, 0x62, 0x75, 0x66, 0x34, 0x67, 0x7a, 0x70, 0x4e, 0x68, 0x31, 0x39,
    0x59, 0x52, 0x65, 0x42, 0x44, 0x75, 0x7a, 0x67, 0x33, 0x43, 0x54, 0x62,
    0x59, 0x0a, 0x4b, 0x38, 0x52, 0x45, 0x6e, 0x58, 0x76, 0x4d, 0x59, 0x34,
    0x4b, 0x44, 0x36, 0x63, 0x69, 0x4d, 0x4f, 0x72, 0x61, 0x78, 0x4a, 0x53,
    0x31, 0x43, 0x49, 0x6d, 0x67, 0x53, 0x70, 0x68, 0x56, 0x70, 0x50, 0x37,
    0x54, 0x77, 0x4f, 0x4f, 0x6c, 0x62, 0x75, 0x78, 0x6a, 0x39, 0x76, 0x31,
    0x45, 0x63, 0x54, 0x41, 0x78, 0x34, 0x49, 0x68, 0x31, 0x38, 0x71, 0x72,
    0x71, 0x6c, 0x36, 0x32, 0x32, 0x56, 0x0a, 0x34, 0x45, 0x70, 0x34, 0x6c,
    0x62, 0x2f, 0x4a, 0x78, 0x57, 0x6e, 0x58, 0x4e, 0x48, 0x77, 0x2f, 0x7a,
    0x32, 0x64, 0x70, 0x64, 0x4d, 0x55, 0x6b, 0x4a, 0x4a, 0x66, 0x33, 0x6c,
    0x6d, 0x6e, 0x2b, 0x2f, 0x34, 0x5a, 0x56, 0x2b, 0x67, 0x4e, 0x42, 0x74,
    0x42, 0x79, 0x71, 0x4c, 0x52, 0x49, 0x50, 0x54, 0x47, 0x32, 0x6c, 0x37,
    0x4f, 0x34, 0x55, 0x6e, 0x52, 0x2f, 0x32, 0x69, 0x75, 0x71, 0x78, 0x0a,
    0x30, 0x77, 0x4b, 0x70, 0x59, 0x37, 0x54, 0x68, 0x34, 0x49, 0x66, 0x58,
    0x6a, 0x53, 0x56, 0x57, 0x36, 0x73, 0x4f, 0x63, 0x2b, 0x4a, 0x77, 0x37,
    0x64, 0x35, 0x68, 0x73, 0x56, 0x2f, 0x7a, 0x37, 0x41, 0x55, 0x52, 0x45,
    0x45, 0x4a, 0x34, 0x57, 0x58, 0x36, 0x4e, 0x4e, 0x70, 0x42, 0x77, 0x51,
    0x5a, 0x4e, 0x32, 0x56, 0x78, 0x48, 0x30, 0x37, 0x49, 0x78, 0x79, 0x76,
    0x6b, 0x33, 0x5a, 0x51, 0x0a, 0x58, 0x67, 0x56, 0x51, 0x58, 0x4e, 0x68,
    0x72, 0x79, 0x4e, 0x43, 0x49, 0x57, 0x70, 0x74, 0x2f, 0x66, 0x57, 0x69,
    0x76, 0x75, 0x50, 0x43, 0x7a, 0x77, 0x74, 0x32, 0x55, 0x74, 0x4f, 0x72,
    0x70, 0x2f, 0x35, 0x57, 0x43, 0x35, 0x37, 0x77, 0x31, 0x65, 0x65, 0x4d,
    0x73, 0x58, 0x63, 0x68, 0x72, 0x41, 0x51, 0x4b, 0x43, 0x41, 0x51, 0x45,
    0x41, 0x35, 0x4b, 0x48, 0x7a, 0x4c, 0x34, 0x76, 0x57, 0x0a, 0x42, 0x58,
    0x65, 0x66, 0x6f, 0x36, 0x2f, 0x4b, 0x68, 0x77, 0x49, 0x4a, 0x41, 0x37,
    0x79, 0x35, 0x54, 0x53, 0x67, 0x41, 0x62, 0x44, 0x68, 0x59, 0x70, 0x51,
    0x69, 0x34, 0x32, 0x4c, 0x6c, 0x74, 0x33, 0x37, 0x4e, 0x4d, 0x6e, 0x4a,
    0x63, 0x79, 0x4b, 0x54, 0x56, 0x6d, 0x79, 0x78, 0x70, 0x66, 0x59, 0x47,
    0x38, 0x65, 0x6e, 0x70, 0x31, 0x46, 0x71, 0x7a, 0x54, 0x56, 0x59, 0x74,
    0x63, 0x65, 0x0a, 0x5a, 0x49, 0x77, 0x33, 0x65, 0x39, 0x54, 0x35, 0x48,
    0x47, 0x4e, 0x71, 0x55, 0x6a, 0x70, 0x6f, 0x78, 0x43, 0x70, 0x35, 0x33,
    0x4b, 0x63, 0x44, 0x75, 0x38, 0x69, 0x47, 0x46, 0x36, 0x43, 0x51, 0x71,
    0x4a, 0x4d, 0x46, 0x72, 0x6b, 0x38, 0x47, 0x6b, 0x56, 0x51, 0x55, 0x38,
    0x31, 0x71, 0x58, 0x75, 0x57, 0x6f, 0x41, 0x50, 0x32, 0x79, 0x4a, 0x66,
    0x51, 0x53, 0x6d, 0x42, 0x75, 0x68, 0x67, 0x0a, 0x50, 0x64, 0x48, 0x4b,
    0x55, 0x4b, 0x31, 0x68, 0x47, 0x31, 0x6f, 0x36, 0x32, 0x44, 0x48, 0x32,
    0x67, 0x57, 0x33, 0x65, 0x6e, 0x37, 0x6a, 0x33, 0x70, 0x78, 0x43, 0x70,
    0x34, 0x4e, 0x68, 0x70, 0x39, 0x49, 0x70, 0x2f, 0x35, 0x39, 0x67, 0x30,
    0x4c, 0x73, 0x50, 0x44, 0x42, 0x67, 0x36, 0x6e, 0x59, 0x69, 0x38, 0x78,
    0x35, 0x61, 0x44, 0x4e, 0x6f, 0x59, 0x6d, 0x76, 0x45, 0x56, 0x45, 0x41,
    0x0a, 0x35, 0x46, 0x52, 0x7a, 0x37, 0x75, 0x2f, 0x77, 0x77, 0x67, 0x79,
    0x6d, 0x47, 0x49, 0x50, 0x67, 0x57, 0x70, 0x59, 0x47, 0x33, 0x63, 0x35,
    0x6b, 0x73, 0x31, 0x6e, 0x51, 0x41, 0x5a, 0x47, 0x53, 0x61, 0x37, 0x64,
    0x4c, 0x46, 0x74, 0x44, 0x4d, 0x45, 0x59, 0x4f, 0x78, 0x34, 0x37, 0x36,
    0x77, 0x42, 0x75, 0x48, 0x41, 0x56, 0x53, 0x57, 0x53, 0x41, 0x70, 0x64,
    0x55, 0x4d, 0x38, 0x56, 0x77, 0x0a, 0x6b, 0x2f, 0x6b, 0x63, 0x66, 0x2f,
    0x76, 0x61, 0x6f, 0x33, 0x4f, 0x7a, 0x71, 0x65, 0x33, 0x6f, 0x73, 0x37,
    0x37, 0x43, 0x6f, 0x46, 0x52, 0x77, 0x5a, 0x4d, 0x4e, 0x61, 0x7a, 0x2f,
    0x46, 0x2f, 0x7a, 0x35, 0x53, 0x77, 0x63, 0x47, 0x77, 0x42, 0x6f, 0x65,
    0x34, 0x51, 0x67, 0x69, 0x42, 0x6f, 0x33, 0x39, 0x4b, 0x58, 0x52, 0x33,
    0x5a, 0x63, 0x57, 0x33, 0x48, 0x63, 0x68, 0x76, 0x7a, 0x7a, 0x0a, 0x46,
    0x38, 0x54, 0x36, 0x6d, 0x38, 0x30, 0x78, 0x61, 0x7a, 0x67, 0x54, 0x6a,
    0x51, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41, 0x77, 0x2f, 0x66, 0x55, 0x62,
    0x53, 0x78, 0x69, 0x6b, 0x33, 0x78, 0x38, 0x5a, 0x70, 0x59, 0x50, 0x71,
    0x53, 0x4a, 0x5a, 0x6f, 0x62, 0x30, 0x58, 0x76, 0x4b, 0x6b, 0x74, 0x67,
    0x37, 0x52, 0x35, 0x44, 0x4e, 0x32, 0x57, 0x2f, 0x65, 0x4c, 0x6e, 0x46,
    0x34, 0x63, 0x55, 0x0a, 0x45, 0x33, 0x70, 0x2b, 0x38, 0x5a, 0x33, 0x38,
    0x4c, 0x57, 0x76, 0x37, 0x6c, 0x36, 0x72, 0x72, 0x4e, 0x47, 0x4d, 0x41,
    0x4e, 0x48, 0x6a, 0x59, 0x44, 0x47, 0x53, 0x5a, 0x2f, 0x67, 0x79, 0x2b,
    0x48, 0x31, 0x6f, 0x75, 0x38, 0x69, 0x72, 0x54, 0x2b, 0x55, 0x64, 0x42,
    0x6c, 0x6c, 0x58, 0x4b, 0x70, 0x71, 0x44, 0x35, 0x39, 0x5a, 0x56, 0x55,
    0x73, 0x2b, 0x6f, 0x76, 0x4e, 0x73, 0x7a, 0x52, 0x0a, 0x68, 0x50, 0x37,
    0x77, 0x6c, 0x4c, 0x4d, 0x30, 0x42, 0x67, 0x45, 0x44, 0x58, 0x33, 0x6b,
    0x6e, 0x36, 0x78, 0x52, 0x41, 0x63, 0x5a, 0x2b, 0x74, 0x6b, 0x59, 0x53,
    0x64, 0x57, 0x79, 0x63, 0x6f, 0x2b, 0x5a, 0x4b, 0x4f, 0x48, 0x63, 0x66,
    0x71, 0x75, 0x54, 0x2f, 0x72, 0x4a, 0x34, 0x4b, 0x35, 0x42, 0x43, 0x65,
    0x75, 0x33, 0x31, 0x48, 0x6f, 0x78, 0x74, 0x51, 0x6c, 0x78, 0x4a, 0x44,
    0x51, 0x0a, 0x52, 0x36, 0x4b, 0x6a, 0x42, 0x4e, 0x2b, 0x61, 0x63, 0x37,
    0x63, 0x33, 0x6c, 0x32, 0x57, 0x52, 0x47, 0x7a, 0x2f, 0x70, 0x4b, 0x6a,
    0x30, 0x47, 0x39, 0x35, 0x32, 0x71, 0x42, 0x43, 0x72, 0x58, 0x4c, 0x71,
    0x32, 0x32, 0x30, 0x54, 0x4e, 0x71, 0x44, 0x4b, 0x44, 0x44, 0x4c, 0x50,
    0x54, 0x32, 0x5a, 0x46, 0x41, 0x6b, 0x65, 0x48, 0x77, 0x7a, 0x50, 0x58,
    0x32, 0x65, 0x65, 0x71, 0x53, 0x75, 0x0a, 0x62, 0x34, 0x6b, 0x48, 0x45,
    0x49, 0x44, 0x7a, 0x72, 0x66, 0x4d, 0x55, 0x44, 0x35, 0x63, 0x6d, 0x54,
    0x73, 0x42, 0x50, 0x71, 0x30, 0x4c, 0x59, 0x75, 0x6c, 0x67, 0x75, 0x42,
    0x59, 0x78, 0x5a, 0x57, 0x73, 0x50, 0x63, 0x6d, 0x2b, 0x66, 0x57, 0x63,
    0x53, 0x6e, 0x77, 0x39, 0x73, 0x32, 0x4c, 0x2b, 0x45, 0x4c, 0x32, 0x37,
    0x52, 0x39, 0x39, 0x49, 0x67, 0x7a, 0x43, 0x76, 0x64, 0x47, 0x49, 0x0a,
    0x71, 0x52, 0x45, 0x75, 0x2f, 0x69, 0x65, 0x5a, 0x66, 0x79, 0x6d, 0x31,
    0x6e, 0x67, 0x65, 0x58, 0x33, 0x56, 0x70, 0x73, 0x50, 0x4e, 0x54, 0x36,
    0x77, 0x43, 0x55, 0x58, 0x4c, 0x61, 0x63, 0x70, 0x79, 0x4a, 0x46, 0x6d,
    0x59, 0x57, 0x71, 0x65, 0x2f, 0x77, 0x4b, 0x43, 0x41, 0x51, 0x42, 0x44,
    0x75, 0x49, 0x53, 0x6a, 0x7a, 0x4c, 0x4f, 0x30, 0x49, 0x74, 0x36, 0x79,
    0x53, 0x56, 0x75, 0x66, 0x0a, 0x36, 0x63, 0x5a, 0x70, 0x79, 0x50, 0x6a,
    0x4b, 0x46, 0x64, 0x4d, 0x71, 0x4f, 0x76, 0x5a, 0x6d, 0x79, 0x39, 0x4b,
    0x55, 0x76, 0x7a, 0x67, 0x41, 0x54, 0x73, 0x65, 0x65, 0x69, 0x6c, 0x70,
    0x64, 0x51, 0x6d, 0x67, 0x55, 0x4f, 0x4e, 0x65, 0x50, 0x5a, 0x4e, 0x71,
    0x59, 0x2b, 0x4e, 0x53, 0x75, 0x42, 0x5a, 0x51, 0x2f, 0x46, 0x71, 0x44,
    0x31, 0x2f, 0x32, 0x4a, 0x66, 0x31, 0x35, 0x47, 0x43, 0x0a, 0x43, 0x79,
    0x42, 0x76, 0x41, 0x73, 0x59, 0x4e, 0x64, 0x4e, 0x64, 0x72, 0x75, 0x44,
    0x79, 0x75, 0x33, 0x70, 0x4a, 0x35, 0x5a, 0x53, 0x48, 0x30, 0x44, 0x4c,
    0x68, 0x65, 0x44, 0x53, 0x4a, 0x51, 0x34, 0x61, 0x72, 0x69, 0x2b, 0x69,
    0x35, 0x2b, 0x79, 0x52, 0x73, 0x52, 0x72, 0x6b, 0x42, 0x37, 0x4f, 0x32,
    0x6c, 0x43, 0x47, 0x6f, 0x71, 0x48, 0x52, 0x53, 0x43, 0x38, 0x44, 0x4e,
    0x37, 0x36, 0x0a, 0x6a, 0x78, 0x74, 0x6d, 0x39, 0x6b, 0x57, 0x68, 0x79,
    0x4c, 0x31, 0x73, 0x61, 0x67, 0x6c, 0x51, 0x2f, 0x75, 0x71, 0x53, 0x6f,
    0x77, 0x65, 0x66, 0x57, 0x33, 0x62, 0x50, 0x59, 0x59, 0x62, 0x7a, 0x59,
    0x79, 0x44, 0x64, 0x4a, 0x6e, 0x49, 0x46, 0x37, 0x78, 0x7a, 0x45, 0x65,
    0x34, 0x44, 0x74, 0x48, 0x43, 0x38, 0x79, 0x33, 0x64, 0x39, 0x35, 0x77,
    0x6c, 0x6f, 0x6b, 0x71, 0x41, 0x57, 0x55, 0x0a, 0x4e, 0x4e, 0x4c, 0x74,
    0x36, 0x41, 0x49, 0x49, 0x55, 0x75, 0x2f, 0x74, 0x75, 0x7a, 0x69, 0x77,
    0x74, 0x79, 0x57, 0x5a, 0x6b, 0x56, 0x6a, 0x68, 0x64, 0x77, 0x56, 0x53,
    0x32, 0x4c, 0x33, 0x5a, 0x59, 0x6a, 0x7a, 0x4b, 0x7a, 0x4b, 0x79, 0x76,
    0x48, 0x53, 0x63, 0x76, 0x45, 0x56, 0x58, 0x53, 0x56, 0x71, 0x69, 0x6d,
    0x50, 0x52, 0x45, 0x2f, 0x67, 0x30, 0x59, 0x68, 0x30, 0x71, 0x50, 0x4d,
    0x0a, 0x54, 0x6e, 0x55, 0x6c, 0x48, 0x45, 0x63, 0x56, 0x46, 0x71, 0x66,
    0x6e, 0x66, 0x5a, 0x74, 0x63, 0x2f, 0x56, 0x42, 0x6b, 0x7a, 0x34, 0x2b,
    0x67, 0x47, 0x4e, 0x61, 0x36, 0x4e, 0x67, 0x4f, 0x31, 0x78, 0x79, 0x49,
    0x30, 0x71, 0x51, 0x7a, 0x6e, 0x58, 0x79, 0x56, 0x59, 0x45, 0x59, 0x4d,
    0x42, 0x77, 0x78, 0x51, 0x6a, 0x46, 0x38, 0x47, 0x5a, 0x68, 0x4d, 0x73,
    0x47, 0x59, 0x78, 0x30, 0x45, 0x0a, 0x4f, 0x54, 0x50, 0x78, 0x41, 0x6f,
    0x49, 0x42, 0x41, 0x51, 0x43, 0x36, 0x67, 0x31, 0x72, 0x4c, 0x32, 0x59,
    0x32, 0x73, 0x76, 0x37, 0x4f, 0x4b, 0x30, 0x39, 0x48, 0x74, 0x38, 0x51,
    0x4b, 0x4c, 0x2f, 0x48, 0x50, 0x6d, 0x48, 0x4d, 0x4a, 0x7a, 0x38, 0x73,
    0x57, 0x76, 0x61, 0x41, 0x74, 0x34, 0x63, 0x6f, 0x66, 0x74, 0x6a, 0x61,
    0x4f, 0x65, 0x38, 0x6c, 0x78, 0x31, 0x7a, 0x42, 0x36, 0x69, 0x0a, 0x67,
    0x48, 0x37, 0x42, 0x6d, 0x47, 0x77, 0x70, 0x76, 0x50, 0x77, 0x4a, 0x39,
    0x4f, 0x58, 0x7a, 0x7a, 0x5a, 0x2f, 0x2b, 0x2b, 0x74, 0x50, 0x4d, 0x39,
    0x55, 0x46, 0x76, 0x50, 0x54, 0x48, 0x6f, 0x74, 0x46, 0x67, 0x4a, 0x4a,
    0x48, 0x67, 0x75, 0x35, 0x56, 0x46, 0x68, 0x32, 0x70, 0x48, 0x32, 0x64,
    0x72, 0x49, 0x66, 0x48, 0x77, 0x74, 0x65, 0x34, 0x47, 0x48, 0x4c, 0x74,
    0x55, 0x2b, 0x54, 0x0a, 0x55, 0x30, 0x32, 0x4a, 0x68, 0x62, 0x39, 0x6e,
    0x62, 0x79, 0x76, 0x79, 0x75, 0x4c, 0x34, 0x79, 0x6e, 0x4a, 0x78, 0x44,
    0x6b, 0x46, 0x37, 0x67, 0x51, 0x67, 0x73, 0x2b, 0x37, 0x76, 0x4a, 0x4a,
    0x42, 0x44, 0x76, 0x6b, 0x71, 0x2f, 0x63, 0x35, 0x72, 0x43, 0x63, 0x30,
    0x35, 0x7a, 0x6c, 0x38, 0x57, 0x35, 0x66, 0x69, 0x6f, 0x4d, 0x32, 0x4c,
    0x45, 0x4a, 0x44, 0x46, 0x5a, 0x36, 0x67, 0x52, 0x0a, 0x38, 0x46, 0x52,
    0x5a, 0x70, 0x4e, 0x4a, 0x5a, 0x74, 0x42, 0x64, 0x51, 0x47, 0x79, 0x74,
    0x52, 0x61, 0x74, 0x37, 0x51, 0x2f, 0x70, 0x45, 0x31, 0x48, 0x53, 0x4b,
    0x39, 0x73, 0x34, 0x69, 0x41, 0x6f, 0x6c, 0x57, 0x41, 0x71, 0x56, 0x6b,
    0x45, 0x6d, 0x6e, 0x35, 0x4c, 0x71, 0x6a, 0x48, 0x2b, 0x6d, 0x56, 0x76,
    0x48, 0x63, 0x49, 0x75, 0x52, 0x48, 0x6b, 0x4c, 0x36, 0x41, 0x7a, 0x46,
    0x70, 0x0a, 0x34, 0x73, 0x75, 0x36, 0x46, 0x75, 0x72, 0x66, 0x30, 0x77,
    0x74, 0x41, 0x66, 0x65, 0x76, 0x57, 0x56, 0x32, 0x7a, 0x64, 0x33, 0x50,
    0x6d, 0x43, 0x65, 0x4a, 0x32, 0x30, 0x53, 0x52, 0x43, 0x42, 0x50, 0x69,
    0x44, 0x59, 0x56, 0x55, 0x4f, 0x64, 0x73, 0x75, 0x5a, 0x66, 0x51, 0x7a,
    0x51, 0x4f, 0x76, 0x30, 0x52, 0x74, 0x38, 0x30, 0x70, 0x31, 0x56, 0x79,
    0x52, 0x35, 0x77, 0x75, 0x6a, 0x46, 0x0a, 0x37, 0x63, 0x57, 0x73, 0x74,
    0x5a, 0x39, 0x6c, 0x6a, 0x74, 0x55, 0x72, 0x68, 0x4b, 0x31, 0x76, 0x53,
    0x52, 0x33, 0x70, 0x56, 0x6f, 0x74, 0x66, 0x47, 0x48, 0x76, 0x76, 0x78,
    0x64, 0x47, 0x7a, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x51, 0x43, 0x36, 0x59,
    0x70, 0x5a, 0x64, 0x71, 0x4d, 0x38, 0x7a, 0x68, 0x32, 0x45, 0x41, 0x30,
    0x75, 0x69, 0x4e, 0x55, 0x4f, 0x55, 0x2f, 0x5a, 0x63, 0x6d, 0x54, 0x0a,
    0x31, 0x51, 0x6c, 0x4b, 0x67, 0x2b, 0x69, 0x58, 0x4b, 0x66, 0x57, 0x5a,
    0x72, 0x2b, 0x61, 0x64, 0x50, 0x56, 0x50, 0x6b, 0x31, 0x64, 0x54, 0x39,
    0x79, 0x55, 0x78, 0x2f, 0x6e, 0x4e, 0x77, 0x6e, 0x66, 0x43, 0x62, 0x4b,
    0x63, 0x54, 0x45, 0x79, 0x56, 0x74, 0x37, 0x65, 0x41, 0x7a, 0x69, 0x69,
    0x4c, 0x73, 0x5a, 0x77, 0x36, 0x65, 0x58, 0x4f, 0x50, 0x4b, 0x39, 0x55,
    0x38, 0x7a, 0x76, 0x43, 0x0a, 0x4a, 0x50, 0x55, 0x71, 0x67, 0x67, 0x44,
    0x5a, 0x33, 0x2b, 0x6b, 0x62, 0x6b, 0x34, 0x6a, 0x50, 0x44, 0x52, 0x41,
    0x73, 0x30, 0x4a, 0x74, 0x49, 0x6b, 0x43, 0x30, 0x62, 0x75, 0x48, 0x7a,
    0x6b, 0x58, 0x46, 0x30, 0x72, 0x67, 0x41, 0x34, 0x62, 0x4a, 0x7a, 0x75,
    0x55, 0x47, 0x30, 0x44, 0x45, 0x73, 0x58, 0x4a, 0x58, 0x59, 0x71, 0x48,
    0x6f, 0x4f, 0x6d, 0x31, 0x4f, 0x56, 0x4a, 0x66, 0x73, 0x0a, 0x78, 0x6f,
    0x4c, 0x50, 0x74, 0x68, 0x71, 0x55, 0x44, 0x30, 0x44, 0x32, 0x73, 0x43,
    0x59, 0x37, 0x46, 0x62, 0x4a, 0x58, 0x67, 0x4e, 0x4d, 0x61, 0x33, 0x76,
    0x59, 0x62, 0x31, 0x39, 0x6b, 0x78, 0x65, 0x4a, 0x37, 0x76, 0x37, 0x70,
    0x69, 0x42, 0x72, 0x69, 0x68, 0x4c, 0x6b, 0x35, 0x4c, 0x57, 0x64, 0x41,
    0x78, 0x32, 0x6c, 0x53, 0x56, 0x30, 0x6c, 0x61, 0x46, 0x45, 0x39, 0x4f,
    0x38, 0x43, 0x0a, 0x68, 0x36, 0x48, 0x61, 0x5a, 0x65, 0x52, 0x39, 0x4a,
    0x49, 0x69, 0x42, 0x79, 0x63, 0x5a, 0x39, 0x71, 0x48, 0x49, 0x58, 0x50,
    0x50, 0x43, 0x79, 0x5a, 0x57, 0x51, 0x4f, 0x6c, 0x6c, 0x43, 0x49, 0x56,
    0x69, 0x31, 0x71, 0x53, 0x51, 0x6b, 0x70, 0x51, 0x4e, 0x34, 0x76, 0x59,
    0x4e, 0x68, 0x63, 0x2f, 0x49, 0x45, 0x37, 0x4d, 0x76, 0x51, 0x31, 0x4a,
    0x42, 0x61, 0x4f, 0x62, 0x6c, 0x4a, 0x48, 0x0a, 0x63, 0x73, 0x63, 0x49,
    0x4c, 0x43, 0x38, 0x61, 0x69, 0x4a, 0x56, 0x46, 0x4f, 0x53, 0x5a, 0x6e,
    0x4e, 0x6a, 0x4b, 0x2f, 0x66, 0x6c, 0x6f, 0x72, 0x78, 0x74, 0x54, 0x4f,
    0x44, 0x44, 0x39, 0x49, 0x47, 0x33, 0x67, 0x48, 0x66, 0x78, 0x54, 0x52,
    0x31, 0x73, 0x66, 0x61, 0x4c, 0x76, 0x35, 0x7a, 0x43, 0x51, 0x66, 0x39,
    0x77, 0x4f, 0x49, 0x35, 0x52, 0x49, 0x2f, 0x78, 0x0a, 0x2d, 0x2d, 0x2d,
    0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50, 0x52,
    0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d,
    0x2d, 0x2d, 0x0a
};

unsigned char client_key_der[] = {
    0x30, 0x82, 0x09, 0x29, 0x02, 0x01, 0x00, 0x02, 0x82, 0x02, 0x01, 0x00,
    0xAF, 0x04, 0xB2, 0x36, 0x78, 0x5F, 0xBC, 0x38, 0x9C, 0x18, 0x93, 0x81,
    0x7D, 0x44, 0x0B, 0x18, 0x4A, 0x4A, 0x0B, 0x6F, 0xCD, 0xDB, 0x94, 0xE8,
    0xD8, 0xA7, 0xFA, 0xEB, 0x39, 0x03, 0x6F, 0x79, 0xB8, 0x20, 0xFC, 0x0B,
    0x71, 0xCC, 0x46, 0x58, 0x75, 0xAE, 0x7B, 0x18, 0xA9, 0x9A, 0xF0, 0x30,
    0x17, 0xE5, 0xF6, 0xE8, 0x51, 0xB3, 0xE5, 0xF2, 0x5D, 0xAB, 0xC1, 0x61,
    0xC2, 0x5A, 0xBE, 0x9E, 0xA8, 0xF8, 0x3E, 0x19, 0x7F, 0x43, 0xEC, 0x14,
    0x06, 0x54, 0x3E, 0x5C, 0xC8, 0xEA, 0x22, 0x9C, 0x32, 0xCE, 0x96, 0x66,
    0xE0, 0x79, 0xBE, 0x38, 0xE0, 0x8A, 0x7E, 0xCC, 0x97, 0x76, 0x62, 0xCB,
    0xA4, 0x5C, 0x95, 0x93, 0x8A, 0xEB, 0xD8, 0x64, 0x38, 0x28, 0x54, 0x90,
    0x5D, 0x05, 0xF2, 0x67, 0x1C, 0x5B, 0x34, 0x57, 0x60, 0x9C, 0x2A, 0xEF,
    0x9A, 0xD9, 0x08, 0x05, 0x06, 0xEF, 0x9A, 0x70, 0x72, 0x3F, 0xEC, 0x27,
    0x7B, 0x38, 0x54, 0x40, 0xA2, 0xE4, 0x99, 0x03, 0xF6, 0x4A, 0x3E, 0xDE,
    0x47, 0x32, 0xE8, 0xC9, 0x7D, 0xAA, 0x00, 0x8B, 0x82, 0x15, 0x86, 0xD6,
    0x03, 0xA0, 0xD6, 0x4B, 0xD3, 0xCB, 0x56, 0xE8, 0x2A, 0x4A, 0xF2, 0xDE,
    0x42, 0xAC, 0xF5, 0xB6, 0x9D, 0x9F, 0x66, 0x98, 0x41, 0x76, 0x37, 0xC8,
    0x95, 0xE0, 0xC1, 0xBB, 0x36, 0x20, 0x07, 0x46, 0x9C, 0xF7, 0x20, 0xC7,
    0xD6, 0x67, 0x9E, 0x40, 0xE0, 0x8D, 0x3D, 0xAC, 0xD1, 0x01, 0xC5, 0x96,
    0xC2, 0xEF, 0xA8, 0x55, 0x69, 0x84, 0x04, 0x49, 0x0F, 0x0C, 0x8D, 0x69,
    0x86, 0xE9, 0xC3, 0xF7, 0x7D, 0xC6, 0xD5, 0x17, 0x16, 0x76, 0x64, 0x14,
    0xAF, 0xB9, 0x07, 0x78, 0xF3, 0x0F, 0xC3, 0x9A, 0x77, 0x07, 0x3F, 0xAA,
    0x8E, 0xA6, 0x87, 0xFB, 0xAA, 0x02, 0x4E, 0x16, 0x42, 0xA3, 0xE6, 0x14,
    0xF6, 0x14, 0x3F, 0xE3, 0xE1, 0xF0, 0x30, 0xDC, 0xBC, 0x42, 0xCC, 0xA3,
    0x6A, 0x67, 0xFB, 0xD7, 0x3E, 0x60, 0xE0, 0x28, 0x5E, 0xDB, 0x84, 0x0F,
    0x7D, 0xC9, 0xF4, 0xDD, 0x6C, 0xBF, 0x65, 0x16, 0xAE, 0x4A, 0x0B, 0x10,
    0x9F, 0x2C, 0xE1, 0xAD, 0x9C, 0xFD, 0x58, 0x9E, 0x7E, 0xF3, 0x05, 0x2A,
    0x8F, 0x8E, 0x10, 0xF0, 0x4E, 0xA9, 0x61, 0x12, 0xF4, 0x87, 0x8C, 0x5E,
    0x22, 0xC1, 0x0E, 0xBF, 0xE2, 0x30, 0x35, 0xB5, 0x58, 0x9B, 0xC5, 0xB5,
    0x6C, 0x76, 0x5B, 0x75, 0x6D, 0x52, 0x78, 0xCC, 0x29, 0xB4, 0x46, 0xFB,
    0x18, 0xF8, 0x14, 0x68, 0xEF, 0xF2, 0x27, 0x3F, 0xE1, 0x2A, 0xA7, 0x2B,
    0xA4, 0x82, 0x7B, 0xFC, 0x8A, 0x1A, 0x01, 0x32, 0xBE, 0x8F, 0xDA, 0x7C,
    0xD9, 0xBD, 0xD0, 0x8B, 0x6F, 0xD4, 0x4E, 0x9A, 0x88, 0x0C, 0x88, 0x32,
    0xC9, 0x90, 0x0B, 0x52, 0x4E, 0xA1, 0x58, 0x7F, 0x7B, 0x4A, 0x83, 0x1A,
    0xAA, 0x48, 0x54, 0x8E, 0xC0, 0xFC, 0xEB, 0x33, 0xF6, 0xD4, 0xA1, 0xC4,
    0x37, 0x91, 0xB9, 0x91, 0x7D, 0xFA, 0x03, 0x0C, 0x9F, 0x48, 0x40, 0x26,
    0x46, 0xF9, 0x47, 0x73, 0x31, 0xA3, 0xC5, 0xFA, 0x90, 0x3C, 0x1A, 0xB3,
    0x31, 0xC7, 0xBD, 0x15, 0x2C, 0x7D, 0x37, 0xE4, 0x7D, 0x6F, 0x0F, 0xD5,
    0x06, 0xC7, 0xC2, 0x73, 0x31, 0x79, 0x2C, 0xA9, 0xBB, 0x46, 0x88, 0xC7,
    0x0F, 0x9C, 0xF0, 0x39, 0xB3, 0xB7, 0xE9, 0x6C, 0xED, 0xB8, 0xF6, 0x9B,
    0x6E, 0x87, 0xF3, 0xD2, 0x61, 0x62, 0x57, 0x2B, 0x85, 0xDD, 0xC3, 0x9B,
    0xFE, 0xDA, 0x86, 0x55, 0x5F, 0x77, 0x9C, 0x8A, 0xC0, 0x05, 0xBC, 0xBF,
    0x0D, 0xB0, 0x5B, 0x21, 0x02, 0x57, 0x2E, 0xCB, 0x2D, 0x9E, 0x9C, 0x29,
    0x95, 0x96, 0xDA, 0x66, 0x46, 0x2A, 0x3E, 0xF3, 0xBB, 0x19, 0x15, 0x7B,
    0xD0, 0x7F, 0x30, 0x34, 0xEE, 0x4E, 0x7F, 0x73, 0x02, 0x03, 0x01, 0x00,
    0x01, 0x02, 0x82, 0x02, 0x00, 0x65, 0xC7, 0x75, 0x5B, 0xF7, 0xE4, 0xB4,
    0xB0, 0xB7, 0x16, 0x13, 0xB1, 0xDA, 0x07, 0x17, 0xEC, 0xA8, 0x47, 0x27,
    0x1F, 0x7D, 0xB7, 0x94, 0x81, 0x54, 0x7D, 0x5B, 0x8E, 0x2F, 0x39, 0xB0,
    0x3A, 0x38, 0xB9, 0xF5, 0xD9, 0x31, 0xF4, 0x79, 0x74, 0x37, 0xFB, 0x9F,
    0xDA, 0x57, 0xC7, 0xA2, 0xA6, 0x55, 0x3F, 0x86, 0xB6, 0xD3, 0xCC, 0xAA,
    0x8C, 0xA7, 0xAC, 0x9A, 0x69, 0x1F, 0x7D, 0x66, 0x1D, 0x1E, 0x66, 0x3E,
    0xB6, 0xD5, 0x2B, 0xCA, 0xBE, 0x5A, 0x6F, 0xE3, 0x54, 0x52, 0x02, 0xD6,
    0xDD, 0xBF, 0x2E, 0x24, 0x88, 0xEF, 0x41, 0xDD, 0x3D, 0x76, 0x57, 0x14,
    0x26, 0x26, 0x6E, 0xD2, 0x45, 0x5A, 0xEF, 0xFC, 0x8C, 0x30, 0xDD, 0xB6,
    0x99, 0x91, 0x8E, 0xE2, 0x9E, 0x91, 0x7A, 0x43, 0xDD, 0x72, 0xC0, 0x17,
    0x50, 0x38, 0xFE, 0x98, 0x79, 0x7E, 0xB3, 0x77, 0xD6, 0x74, 0x92, 0x22,
    0x5E, 0x02, 0x12, 0xEA, 0x62, 0x8B, 0x65, 0xD6, 0x99, 0x40, 0x21, 0x70,
    0x5A, 0xBD, 0x7F, 0xAF, 0xCF, 0xD3, 0xD7, 0xE7, 0x48, 0x45, 0xAB, 0xF7,
    0x65, 0x29, 0xE1, 0x1A, 0xE8, 0x9A, 0x73, 0x8E, 0x2B, 0xCA, 0x9F, 0x15,
    0x8B, 0x2E, 0x0D, 0x27, 0xEF, 0xD9, 0x16, 0x7C, 0x4E, 0x16, 0x9B, 0xFC,
    0x2D, 0xCE, 0xE3, 0xD0, 0xCC, 0xF5, 0x5C, 0x1F, 0x4D, 0x9F, 0xCC, 0x40,
    0x6E, 0xF0, 0x19, 0x47, 0x16, 0xEF, 0xB8, 0x92, 0x6F, 0x68, 0x26, 0xBB,
    0x17, 0x24, 0xF4, 0xC2, 0xD3, 0x49, 0xC9, 0xD5, 0x3A, 0xD6, 0x81, 0xCF,
    0x7C, 0x2D, 0x24, 0x3F, 0x98, 0x7E, 0xBC, 0xB3, 0x19, 0xDA, 0x2B, 0x27,
    0x00, 0xA6, 0x2F, 0x73, 0x44, 0x14, 0x6C, 0xA5, 0xCB, 0xD0, 0x8D, 0xFA,
    0x52, 0x79, 0xA5, 0xDD, 0x80, 0x72, 0x34, 0xA6, 0x1F, 0xD4, 0x5E, 0x42,
    0xCA, 0xEF, 0x36, 0x21, 0x37, 0x4F, 0x63, 0xB7, 0x42, 0xF7, 0xD5, 0x28,
    0x9F, 0xF1, 0xB9, 0x7D, 0x15, 0x15, 0x9D, 0xA9, 0x97, 0xE0, 0x0F, 0x8D,
    0x6D, 0xF1, 0x84, 0x86, 0x52, 0x76, 0x5D, 0x75, 0x10, 0x5D, 0x38, 0xA1,
    0x03, 0x01, 0x6E, 0x64, 0x7A, 0xD3, 0x1C, 0x02, 0x57, 0xF5, 0xDA, 0x30,
    0xE0, 0xB4, 0x10, 0xB8, 0x88, 0x43, 0x3C, 0xE6, 0x14, 0x37, 0x36, 0x68,
    0xE1, 0x6D, 0x38, 0x0C, 0x32, 0x7E, 0x6E, 0xE7, 0xF8, 0x83, 0x3A, 0x4D,
    0x87, 0x5F, 0x58, 0x45, 0xE0, 0x43, 0xBB, 0x38, 0x37, 0x09, 0x36, 0xD8,
    0x2B, 0xC4, 0x44, 0x9D, 0x7B, 0xCC, 0x63, 0x82, 0x83, 0xE9, 0xC8, 0x8C,
    0x3A, 0xB6, 0xB1, 0x25, 0x2D, 0x42, 0x22, 0x68, 0x12, 0xA6, 0x15, 0x69,
    0x3F, 0xB4, 0xF0, 0x38, 0xE9, 0x5B, 0xBB, 0x18, 0xFD, 0xBF, 0x51, 0x1C,
    0x4C, 0x0C, 0x78, 0x22, 0x1D, 0x7C, 0xAA, 0xBA, 0xA5, 0xEB, 0x6D, 0x95,
    0xE0, 0x4A, 0x78, 0x95, 0xBF, 0xC9, 0xC5, 0x69, 0xD7, 0x34, 0x7C, 0x3F,
    0xCF, 0x67, 0x69, 0x74, 0xC5, 0x24, 0x24, 0x97, 0xF7, 0x96, 0x69, 0xFE,
    0xFF, 0x86, 0x55, 0xFA, 0x03, 0x41, 0xB4, 0x1C, 0xAA, 0x2D, 0x12, 0x0F,
    0x4C, 0x6D, 0xA5, 0xEC, 0xEE, 0x14, 0x9D, 0x1F, 0xF6, 0x8A, 0xEA, 0xB1,
    0xD3, 0x02, 0xA9, 0x63, 0xB4, 0xE1, 0xE0, 0x87, 0xD7, 0x8D, 0x25, 0x56,
    0xEA, 0xC3, 0x9C, 0xF8, 0x9C, 0x3B, 0x77, 0x98, 0x6C, 0x57, 0xFC, 0xFB,
    0x01, 0x44, 0x44, 0x10, 0x9E, 0x16, 0x5F, 0xA3, 0x4D, 0xA4, 0x1C, 0x10,
    0x64, 0xDD, 0x95, 0xC4, 0x7D, 0x3B, 0x23, 0x1C, 0xAF, 0x93, 0x76, 0x50,
    0x5E, 0x05, 0x50, 0x5C, 0xD8, 0x6B, 0xC8, 0xD0, 0x88, 0x5A, 0x9B, 0x7F,
    0x7D, 0x68, 0xAF, 0xB8, 0xF0, 0xB3, 0xC2, 0xDD, 0x94, 0xB4, 0xEA, 0xE9,
    0xFF, 0x95, 0x82, 0xE7, 0xBC, 0x35, 0x79, 0xE3, 0x2C, 0x5D, 0xC8, 0x6B,
    0x01, 0x02, 0x82, 0x01, 0x01, 0x00, 0xE4, 0xA1, 0xF3, 0x2F, 0x8B, 0xD6,
    0x05, 0x77, 0x9F, 0xA3, 0xAF, 0xCA, 0x87, 0x02, 0x09, 0x03, 0xBC, 0xB9,
    0x4D, 0x28, 0x00, 0x6C, 0x38, 0x58, 0xA5, 0x08, 0xB8, 0xD8, 0xB9, 0x6D,
    0xDF, 0xB3, 0x4C, 0x9C, 0x97, 0x32, 0x29, 0x35, 0x66, 0xCB, 0x1A, 0x5F,
    0x60, 0x6F, 0x1E, 0x9E, 0x9D, 0x45, 0xAB, 0x34, 0xD5, 0x62, 0xD7, 0x1E,
    0x64, 0x8C, 0x37, 0x7B, 0xD4, 0xF9, 0x1C, 0x63, 0x6A, 0x52, 0x3A, 0x68,
    0xC4, 0x2A, 0x79, 0xDC, 0xA7, 0x03, 0xBB, 0xC8, 0x86, 0x17, 0xA0, 0x90,
    0xA8, 0x93, 0x05, 0xAE, 0x4F, 0x06, 0x91, 0x54, 0x14, 0xF3, 0x5A, 0x97,
    0xB9, 0x6A, 0x00, 0x3F, 0x6C, 0x89, 0x7D, 0x04, 0xA6, 0x06, 0xE8, 0x60,
    0x3D, 0xD1, 0xCA, 0x50, 0xAD, 0x61, 0x1B, 0x5A, 0x3A, 0xD8, 0x31, 0xF6,
    0x81, 0x6D, 0xDE, 0x9F, 0xB8, 0xF7, 0xA7, 0x10, 0xA9, 0xE0, 0xD8, 0x69,
    0xF4, 0x8A, 0x7F, 0xE7, 0xD8, 0x34, 0x2E, 0xC3, 0xC3, 0x06, 0x0E, 0xA7,
    0x62, 0x2F, 0x31, 0xE5, 0xA0, 0xCD, 0xA1, 0x89, 0xAF, 0x11, 0x51, 0x00,
    0xE4, 0x54, 0x73, 0xEE, 0xEF, 0xF0, 0xC2, 0x0C, 0xA6, 0x18, 0x83, 0xE0,
    0x5A, 0x96, 0x06, 0xDD, 0xCE, 0x64, 0xB3, 0x59, 0xD0, 0x01, 0x91, 0x92,
    0x6B, 0xB7, 0x4B, 0x16, 0xD0, 0xCC, 0x11, 0x83, 0xB1, 0xE3, 0xBE, 0xB0,
    0x06, 0xE1, 0xC0, 0x55, 0x25, 0x92, 0x02, 0x97, 0x54, 0x33, 0xC5, 0x70,
    0x93, 0xF9, 0x1C, 0x7F, 0xFB, 0xDA, 0xA3, 0x73, 0xB3, 0xA9, 0xED, 0xE8,
    0xB3, 0xBE, 0xC2, 0xA0, 0x54, 0x70, 0x64, 0xC3, 0x5A, 0xCF, 0xF1, 0x7F,
    0xCF, 0x94, 0xB0, 0x70, 0x6C, 0x01, 0xA1, 0xEE, 0x10, 0x82, 0x20, 0x68,
    0xDF, 0xD2, 0x97, 0x47, 0x76, 0x5C, 0x5B, 0x71, 0xDC, 0x86, 0xFC, 0xF3,
    0x17, 0xC4, 0xFA, 0x9B, 0xCD, 0x31, 0x6B, 0x38, 0x13, 0x8D, 0x02, 0x82,
    0x01, 0x01, 0x00, 0xC3, 0xF7, 0xD4, 0x6D, 0x2C, 0x62, 0x93, 0x7C, 0x7C,
    0x66, 0x96, 0x0F, 0xA9, 0x22, 0x59, 0xA1, 0xBD, 0x17, 0xBC, 0xA9, 0x2D,
    0x83, 0xB4, 0x79, 0x0C, 0xDD, 0x96, 0xFD, 0xE2, 0xE7, 0x17, 0x87, 0x14,
    0x13, 0x7A, 0x7E, 0xF1, 0x9D, 0xFC, 0x2D, 0x6B, 0xFB, 0x97, 0xAA, 0xEB,
    0x34, 0x63, 0x00, 0x34, 0x78, 0xD8, 0x0C, 0x64, 0x99, 0xFE, 0x0C, 0xBE,
    0x1F, 0x5A, 0x2E, 0xF2, 0x2A, 0xD3, 0xF9, 0x47, 0x41, 0x96, 0x55, 0xCA,
    0xA6, 0xA0, 0xF9, 0xF5, 0x95, 0x54, 0xB3, 0xEA, 0x2F, 0x36, 0xCC, 0xD1,
    0x84, 0xFE, 0xF0, 0x94, 0xB3, 0x34, 0x06, 0x01, 0x03, 0x5F, 0x79, 0x27,
    0xEB, 0x14, 0x40, 0x71, 0x9F, 0xAD, 0x91, 0x84, 0x9D, 0x5B, 0x27, 0x28,
    0xF9, 0x92, 0x8E, 0x1D, 0xC7, 0xEA, 0xB9, 0x3F, 0xEB, 0x27, 0x82, 0xB9,
    0x04, 0x27, 0xAE, 0xDF, 0x51, 0xE8, 0xC6, 0xD4, 0x25, 0xC4, 0x90, 0xD0,
    0x47, 0xA2, 0xA3, 0x04, 0xDF, 0x9A, 0x73, 0xB7, 0x37, 0x97, 0x65, 0x91,
    0x1B, 0x3F, 0xE9, 0x2A, 0x3D, 0x06, 0xF7, 0x9D, 0xAA, 0x04, 0x2A, 0xD7,
    0x2E, 0xAD, 0xB6, 0xD1, 0x33, 0x6A, 0x0C, 0xA0, 0xC3, 0x2C, 0xF4, 0xF6,
    0x64, 0x50, 0x24, 0x78, 0x7C, 0x33, 0x3D, 0x7D, 0x9E, 0x7A, 0xA4, 0xAE,
    0x6F, 0x89, 0x07, 0x10, 0x80, 0xF3, 0xAD, 0xF3, 0x14, 0x0F, 0x97, 0x26,
    0x4E, 0xC0, 0x4F, 0xAB, 0x42, 0xD8, 0xBA, 0x58, 0x2E, 0x05, 0x8C, 0x59,
    0x5A, 0xC3, 0xDC, 0x9B, 0xE7, 0xD6, 0x71, 0x29, 0xF0, 0xF6, 0xCD, 0x8B,
    0xF8, 0x42, 0xF6, 0xED, 0x1F, 0x7D, 0x22, 0x0C, 0xC2, 0xBD, 0xD1, 0x88,
    0xA9, 0x11, 0x2E, 0xFE, 0x27, 0x99, 0x7F, 0x29, 0xB5, 0x9E, 0x07, 0x97,
    0xDD, 0x5A, 0x6C, 0x3C, 0xD4, 0xFA, 0xC0, 0x25, 0x17, 0x2D, 0xA7, 0x29,
    0xC8, 0x91, 0x66, 0x61, 0x6A, 0x9E, 0xFF, 0x02, 0x82, 0x01, 0x00, 0x43,
    0xB8, 0x84, 0xA3, 0xCC, 0xB3, 0xB4, 0x22, 0xDE, 0xB2, 0x49, 0x5B, 0x9F,
    0xE9, 0xC6, 0x69, 0xC8, 0xF8, 0xCA, 0x15, 0xD3, 0x2A, 0x3A, 0xF6, 0x66,
    0xCB, 0xD2, 0x94, 0xBF, 0x38, 0x00, 0x4E, 0xC7, 0x9E, 0x8A, 0x5A, 0x5D,
    0x42, 0x68, 0x14, 0x38, 0xD7, 0x8F, 0x64, 0xDA, 0x98, 0xF8, 0xD4, 0xAE,
    0x05, 0x94, 0x3F, 0x16, 0xA0, 0xF5, 0xFF, 0x62, 0x5F, 0xD7, 0x91, 0x82,
    0x0B, 0x20, 0x6F, 0x02, 0xC6, 0x0D, 0x74, 0xD7, 0x6B, 0xB8, 0x3C, 0xAE,
    0xDE, 0x92, 0x79, 0x65, 0x21, 0xF4, 0x0C, 0xB8, 0x5E, 0x0D, 0x22, 0x50,
    0xE1, 0xAA, 0xE2, 0xFA, 0x2E, 0x7E, 0xC9, 0x1B, 0x11, 0xAE, 0x40, 0x7B,
    0x3B, 0x69, 0x42, 0x1A, 0x8A, 0x87, 0x45, 0x20, 0xBC, 0x0C, 0xDE, 0xFA,
    0x8F, 0x1B, 0x66, 0xF6, 0x45, 0xA1, 0xC8, 0xBD, 0x6C, 0x6A, 0x09, 0x50,
    0xFE, 0xEA, 0x92, 0xA3, 0x07, 0x9F, 0x5B, 0x76, 0xCF, 0x61, 0x86, 0xF3,
    0x63, 0x20, 0xDD, 0x26, 0x72, 0x05, 0xEF, 0x1C, 0xC4, 0x7B, 0x80, 0xED,
    0x1C, 0x2F, 0x32, 0xDD, 0xDF, 0x79, 0xC2, 0x5A, 0x24, 0xA8, 0x05, 0x94,
    0x34, 0xD2, 0xED, 0xE8, 0x02, 0x08, 0x52, 0xEF, 0xED, 0xBB, 0x38, 0xB0,
    0xB7, 0x25, 0x99, 0x91, 0x58, 0xE1, 0x77, 0x05, 0x52, 0xD8, 0xBD, 0xD9,
    0x62, 0x3C, 0xCA, 0xCC, 0xAC, 0xAF, 0x1D, 0x27, 0x2F, 0x11, 0x55, 0xD2,
    0x56, 0xA8, 0xA6, 0x3D, 0x11, 0x3F, 0x83, 0x46, 0x21, 0xD2, 0xA3, 0xCC,
    0x4E, 0x75, 0x25, 0x1C, 0x47, 0x15, 0x16, 0xA7, 0xE7, 0x7D, 0x9B, 0x5C,
    0xFD, 0x50, 0x64, 0xCF, 0x8F, 0xA0, 0x18, 0xD6, 0xBA, 0x36, 0x03, 0xB5,
    0xC7, 0x22, 0x34, 0xA9, 0x0C, 0xE7, 0x5F, 0x25, 0x58, 0x11, 0x83, 0x01,
    0xC3, 0x14, 0x23, 0x17, 0xC1, 0x99, 0x84, 0xCB, 0x06, 0x63, 0x1D, 0x04,
    0x39, 0x33, 0xF1, 0x02, 0x82, 0x01, 0x01, 0x00, 0xBA, 0x83, 0x5A, 0xCB,
    0xD9, 0x8D, 0xAC, 0xBF, 0xB3, 0x8A, 0xD3, 0xD1, 0xED, 0xF1, 0x02, 0x8B,
    0xFC, 0x73, 0xE6, 0x1C, 0xC2, 0x73, 0xF2, 0xC5, 0xAF, 0x68, 0x0B, 0x78,
    0x72, 0x87, 0xED, 0x8D, 0xA3, 0x9E, 0xF2, 0x5C, 0x75, 0xCC, 0x1E, 0xA2,
    0x80, 0x7E, 0xC1, 0x98, 0x6C, 0x29, 0xBC, 0xFC, 0x09, 0xF4, 0xE5, 0xF3,
    0xCD, 0x9F, 0xFE, 0xFA, 0xD3, 0xCC, 0xF5, 0x41, 0x6F, 0x3D, 0x31, 0xE8,
    0xB4, 0x58, 0x09, 0x24, 0x78, 0x2E, 0xE5, 0x51, 0x61, 0xDA, 0x91, 0xF6,
    0x76, 0xB2, 0x1F, 0x1F, 0x0B, 0x5E, 0xE0, 0x61, 0xCB, 0xB5, 0x4F, 0x93,
    0x53, 0x4D, 0x89, 0x85, 0xBF, 0x67, 0x6F, 0x2B, 0xF2, 0xB8, 0xBE, 0x32,
    0x9C, 0x9C, 0x43, 0x90, 0x5E, 0xE0, 0x42, 0x0B, 0x3E, 0xEE, 0xF2, 0x49,
    0x04, 0x3B, 0xE4, 0xAB, 0xF7, 0x39, 0xAC, 0x27, 0x34, 0xE7, 0x39, 0x7C,
    0x5B, 0x97, 0xE2, 0xA0, 0xCD, 0x8B, 0x10, 0x90, 0xC5, 0x67, 0xA8, 0x11,
    0xF0, 0x54, 0x59, 0xA4, 0xD2, 0x59, 0xB4, 0x17, 0x50, 0x1B, 0x2B, 0x51,
    0x6A, 0xDE, 0xD0, 0xFE, 0x91, 0x35, 0x1D, 0x22, 0xBD, 0xB3, 0x88, 0x80,
    0xA2, 0x55, 0x80, 0xA9, 0x59, 0x04, 0x9A, 0x7E, 0x4B, 0xAA, 0x31, 0xFE,
    0x99, 0x5B, 0xC7, 0x70, 0x8B, 0x91, 0x1E, 0x42, 0xFA, 0x03, 0x31, 0x69,
    0xE2, 0xCB, 0xBA, 0x16, 0xEA, 0xDF, 0xD3, 0x0B, 0x40, 0x7D, 0xEB, 0xD6,
    0x57, 0x6C, 0xDD, 0xDC, 0xF9, 0x82, 0x78, 0x9D, 0xB4, 0x49, 0x10, 0x81,
    0x3E, 0x20, 0xD8, 0x55, 0x43, 0x9D, 0xB2, 0xE6, 0x5F, 0x43, 0x34, 0x0E,
    0xBF, 0x44, 0x6D, 0xF3, 0x4A, 0x75, 0x57, 0x24, 0x79, 0xC2, 0xE8, 0xC5,
    0xED, 0xC5, 0xAC, 0xB5, 0x9F, 0x65, 0x8E, 0xD5, 0x2B, 0x84, 0xAD, 0x6F,
    0x49, 0x1D, 0xE9, 0x56, 0x8B, 0x5F, 0x18, 0x7B, 0xEF, 0xC5, 0xD1, 0xB3,
    0x02, 0x82, 0x01, 0x01, 0x00, 0xBA, 0x62, 0x96, 0x5D, 0xA8, 0xCF, 0x33,
    0x87, 0x61, 0x00, 0xD2, 0xE8, 0x8D, 0x50, 0xE5, 0x3F, 0x65, 0xC9, 0x93,
    0xD5, 0x09, 0x4A, 0x83, 0xE8, 0x97, 0x29, 0xF5, 0x99, 0xAF, 0xE6, 0x9D,
    0x3D, 0x53, 0xE4, 0xD5, 0xD4, 0xFD, 0xC9, 0x4C, 0x7F, 0x9C, 0xDC, 0x27,
    0x7C, 0x26, 0xCA, 0x71, 0x31, 0x32, 0x56, 0xDE, 0xDE, 0x03, 0x38, 0xA2,
    0x2E, 0xC6, 0x70, 0xE9, 0xE5, 0xCE, 0x3C, 0xAF, 0x54, 0xF3, 0x3B, 0xC2,
    0x24, 0xF5, 0x2A, 0x82, 0x00, 0xD9, 0xDF, 0xE9, 0x1B, 0x93, 0x88, 0xCF,
    0x0D, 0x10, 0x2C, 0xD0, 0x9B, 0x48, 0x90, 0x2D, 0x1B, 0xB8, 0x7C, 0xE4,
    0x5C, 0x5D, 0x2B, 0x80, 0x0E, 0x1B, 0x27, 0x3B, 0x94, 0x1B, 0x40, 0xC4,
    0xB1, 0x72, 0x57, 0x62, 0xA1, 0xE8, 0x3A, 0x6D, 0x4E, 0x54, 0x97, 0xEC,
    0xC6, 0x82, 0xCF, 0xB6, 0x1A, 0x94, 0x0F, 0x40, 0xF6, 0xB0, 0x26, 0x3B,
    0x15, 0xB2, 0x57, 0x80, 0xD3, 0x1A, 0xDE, 0xF6, 0x1B, 0xD7, 0xD9, 0x31,
    0x78, 0x9E, 0xEF, 0xEE, 0x98, 0x81, 0xAE, 0x28, 0x4B, 0x93, 0x92, 0xD6,
    0x74, 0x0C, 0x76, 0x95, 0x25, 0x74, 0x95, 0xA1, 0x44, 0xF4, 0xEF, 0x02,
    0x87, 0xA1, 0xDA, 0x65, 0xE4, 0x7D, 0x24, 0x88, 0x81, 0xC9, 0xC6, 0x7D,
    0xA8, 0x72, 0x17, 0x3C, 0xF0, 0xB2, 0x65, 0x64, 0x0E, 0x96, 0x50, 0x88,
    0x56, 0x2D, 0x6A, 0x49, 0x09, 0x29, 0x40, 0xDE, 0x2F, 0x60, 0xD8, 0x5C,
    0xFC, 0x81, 0x3B, 0x32, 0xF4, 0x35, 0x24, 0x16, 0x8E, 0x6E, 0x52, 0x47,
    0x72, 0xC7, 0x08, 0x2C, 0x2F, 0x1A, 0x88, 0x95, 0x45, 0x39, 0x26, 0x67,
    0x36, 0x32, 0xBF, 0x7E, 0x5A, 0x2B, 0xC6, 0xD4, 0xCE, 0x0C, 0x3F, 0x48,
    0x1B, 0x78, 0x07, 0x7F, 0x14, 0xD1, 0xD6, 0xC7, 0xDA, 0x2E, 0xFE, 0x73,
    0x09, 0x07, 0xFD, 0xC0, 0xE2, 0x39, 0x44, 0x8F, 0xF1
};

unsigned char client_cert[] = { 0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x42,
                                0x45,
                                0x47,
                                0x49,
                                0x4e,
                                0x20,
                                0x43,
                                0x45,
                                0x52,
                                0x54,
                                0x49,
                                0x46,
                                0x49,
                                0x43,
                                0x41,
                                0x54,
                                0x45,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x0a,
                                0x4d,
                                0x49,
                                0x49,
                                0x45,
                                0x47,
                                0x44,
                                0x43,
                                0x43,
                                0x41,
                                0x77,
                                0x43,
                                0x67,
                                0x41,
                                0x77,
                                0x49,
                                0x42,
                                0x41,
                                0x67,
                                0x49,
                                0x44,
                                0x45,
                                0x41,
                                0x41,
                                0x45,
                                0x4d,
                                0x41,
                                0x30,
                                0x47,
                                0x43,
                                0x53,
                                0x71,
                                0x47,
                                0x53,
                                0x49,
                                0x62,
                                0x33,
                                0x44,
                                0x51,
                                0x45,
                                0x42,
                                0x43,
                                0x77,
                                0x55,
                                0x41,
                                0x4d,
                                0x45,
                                0x38,
                                0x78,
                                0x47,
                                0x7a,
                                0x41,
                                0x5a,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x6f,
                                0x54,
                                0x45,
                                0x6d,
                                0x78,
                                0x70,
                                0x0a,
                                0x59,
                                0x6e,
                                0x64,
                                0x6c,
                                0x59,
                                0x6e,
                                0x4e,
                                0x76,
                                0x59,
                                0x32,
                                0x74,
                                0x6c,
                                0x64,
                                0x48,
                                0x4d,
                                0x74,
                                0x64,
                                0x47,
                                0x56,
                                0x7a,
                                0x64,
                                0x44,
                                0x45,
                                0x53,
                                0x4d,
                                0x42,
                                0x41,
                                0x47,
                                0x41,
                                0x31,
                                0x55,
                                0x45,
                                0x42,
                                0x78,
                                0x4d,
                                0x4a,
                                0x57,
                                0x47,
                                0x6c,
                                0x68,
                                0x62,
                                0x32,
                                0x4a,
                                0x70,
                                0x64,
                                0x47,
                                0x46,
                                0x75,
                                0x4d,
                                0x51,
                                0x38,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x49,
                                0x45,
                                0x77,
                                0x5a,
                                0x55,
                                0x0a,
                                0x59,
                                0x57,
                                0x6c,
                                0x77,
                                0x5a,
                                0x57,
                                0x6b,
                                0x78,
                                0x43,
                                0x7a,
                                0x41,
                                0x4a,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x59,
                                0x54,
                                0x41,
                                0x6c,
                                0x52,
                                0x58,
                                0x4d,
                                0x43,
                                0x41,
                                0x58,
                                0x44,
                                0x54,
                                0x49,
                                0x79,
                                0x4d,
                                0x44,
                                0x63,
                                0x77,
                                0x4e,
                                0x6a,
                                0x45,
                                0x78,
                                0x4d,
                                0x6a,
                                0x55,
                                0x78,
                                0x4f,
                                0x46,
                                0x6f,
                                0x59,
                                0x44,
                                0x7a,
                                0x49,
                                0x77,
                                0x4e,
                                0x54,
                                0x41,
                                0x77,
                                0x4e,
                                0x7a,
                                0x45,
                                0x35,
                                0x4d,
                                0x54,
                                0x45,
                                0x79,
                                0x0a,
                                0x4e,
                                0x54,
                                0x45,
                                0x34,
                                0x57,
                                0x6a,
                                0x42,
                                0x4d,
                                0x4d,
                                0x51,
                                0x73,
                                0x77,
                                0x43,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x47,
                                0x45,
                                0x77,
                                0x4a,
                                0x55,
                                0x56,
                                0x7a,
                                0x45,
                                0x50,
                                0x4d,
                                0x41,
                                0x30,
                                0x47,
                                0x41,
                                0x31,
                                0x55,
                                0x45,
                                0x43,
                                0x42,
                                0x4d,
                                0x47,
                                0x56,
                                0x47,
                                0x46,
                                0x70,
                                0x63,
                                0x47,
                                0x56,
                                0x70,
                                0x4d,
                                0x52,
                                0x73,
                                0x77,
                                0x47,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x4b,
                                0x45,
                                0x78,
                                0x4a,
                                0x73,
                                0x0a,
                                0x61,
                                0x57,
                                0x4a,
                                0x33,
                                0x5a,
                                0x57,
                                0x4a,
                                0x7a,
                                0x62,
                                0x32,
                                0x4e,
                                0x72,
                                0x5a,
                                0x58,
                                0x52,
                                0x7a,
                                0x4c,
                                0x58,
                                0x52,
                                0x6c,
                                0x63,
                                0x33,
                                0x51,
                                0x78,
                                0x44,
                                0x7a,
                                0x41,
                                0x4e,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x4d,
                                0x54,
                                0x42,
                                0x6d,
                                0x4e,
                                0x73,
                                0x61,
                                0x57,
                                0x56,
                                0x75,
                                0x64,
                                0x44,
                                0x43,
                                0x43,
                                0x41,
                                0x69,
                                0x49,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x4a,
                                0x4b,
                                0x6f,
                                0x5a,
                                0x49,
                                0x68,
                                0x76,
                                0x63,
                                0x4e,
                                0x0a,
                                0x41,
                                0x51,
                                0x45,
                                0x42,
                                0x42,
                                0x51,
                                0x41,
                                0x44,
                                0x67,
                                0x67,
                                0x49,
                                0x50,
                                0x41,
                                0x44,
                                0x43,
                                0x43,
                                0x41,
                                0x67,
                                0x6f,
                                0x43,
                                0x67,
                                0x67,
                                0x49,
                                0x42,
                                0x41,
                                0x4b,
                                0x38,
                                0x45,
                                0x73,
                                0x6a,
                                0x5a,
                                0x34,
                                0x58,
                                0x37,
                                0x77,
                                0x34,
                                0x6e,
                                0x42,
                                0x69,
                                0x54,
                                0x67,
                                0x58,
                                0x31,
                                0x45,
                                0x43,
                                0x78,
                                0x68,
                                0x4b,
                                0x53,
                                0x67,
                                0x74,
                                0x76,
                                0x7a,
                                0x64,
                                0x75,
                                0x55,
                                0x36,
                                0x4e,
                                0x69,
                                0x6e,
                                0x2b,
                                0x75,
                                0x73,
                                0x35,
                                0x0a,
                                0x41,
                                0x32,
                                0x39,
                                0x35,
                                0x75,
                                0x43,
                                0x44,
                                0x38,
                                0x43,
                                0x33,
                                0x48,
                                0x4d,
                                0x52,
                                0x6c,
                                0x68,
                                0x31,
                                0x72,
                                0x6e,
                                0x73,
                                0x59,
                                0x71,
                                0x5a,
                                0x72,
                                0x77,
                                0x4d,
                                0x42,
                                0x66,
                                0x6c,
                                0x39,
                                0x75,
                                0x68,
                                0x52,
                                0x73,
                                0x2b,
                                0x58,
                                0x79,
                                0x58,
                                0x61,
                                0x76,
                                0x42,
                                0x59,
                                0x63,
                                0x4a,
                                0x61,
                                0x76,
                                0x70,
                                0x36,
                                0x6f,
                                0x2b,
                                0x44,
                                0x34,
                                0x5a,
                                0x66,
                                0x30,
                                0x50,
                                0x73,
                                0x46,
                                0x41,
                                0x5a,
                                0x55,
                                0x50,
                                0x6c,
                                0x7a,
                                0x49,
                                0x0a,
                                0x36,
                                0x69,
                                0x4b,
                                0x63,
                                0x4d,
                                0x73,
                                0x36,
                                0x57,
                                0x5a,
                                0x75,
                                0x42,
                                0x35,
                                0x76,
                                0x6a,
                                0x6a,
                                0x67,
                                0x69,
                                0x6e,
                                0x37,
                                0x4d,
                                0x6c,
                                0x33,
                                0x5a,
                                0x69,
                                0x79,
                                0x36,
                                0x52,
                                0x63,
                                0x6c,
                                0x5a,
                                0x4f,
                                0x4b,
                                0x36,
                                0x39,
                                0x68,
                                0x6b,
                                0x4f,
                                0x43,
                                0x68,
                                0x55,
                                0x6b,
                                0x46,
                                0x30,
                                0x46,
                                0x38,
                                0x6d,
                                0x63,
                                0x63,
                                0x57,
                                0x7a,
                                0x52,
                                0x58,
                                0x59,
                                0x4a,
                                0x77,
                                0x71,
                                0x37,
                                0x35,
                                0x72,
                                0x5a,
                                0x43,
                                0x41,
                                0x55,
                                0x47,
                                0x0a,
                                0x37,
                                0x35,
                                0x70,
                                0x77,
                                0x63,
                                0x6a,
                                0x2f,
                                0x73,
                                0x4a,
                                0x33,
                                0x73,
                                0x34,
                                0x56,
                                0x45,
                                0x43,
                                0x69,
                                0x35,
                                0x4a,
                                0x6b,
                                0x44,
                                0x39,
                                0x6b,
                                0x6f,
                                0x2b,
                                0x33,
                                0x6b,
                                0x63,
                                0x79,
                                0x36,
                                0x4d,
                                0x6c,
                                0x39,
                                0x71,
                                0x67,
                                0x43,
                                0x4c,
                                0x67,
                                0x68,
                                0x57,
                                0x47,
                                0x31,
                                0x67,
                                0x4f,
                                0x67,
                                0x31,
                                0x6b,
                                0x76,
                                0x54,
                                0x79,
                                0x31,
                                0x62,
                                0x6f,
                                0x4b,
                                0x6b,
                                0x72,
                                0x79,
                                0x33,
                                0x6b,
                                0x4b,
                                0x73,
                                0x39,
                                0x62,
                                0x61,
                                0x64,
                                0x0a,
                                0x6e,
                                0x32,
                                0x61,
                                0x59,
                                0x51,
                                0x58,
                                0x59,
                                0x33,
                                0x79,
                                0x4a,
                                0x58,
                                0x67,
                                0x77,
                                0x62,
                                0x73,
                                0x32,
                                0x49,
                                0x41,
                                0x64,
                                0x47,
                                0x6e,
                                0x50,
                                0x63,
                                0x67,
                                0x78,
                                0x39,
                                0x5a,
                                0x6e,
                                0x6e,
                                0x6b,
                                0x44,
                                0x67,
                                0x6a,
                                0x54,
                                0x32,
                                0x73,
                                0x30,
                                0x51,
                                0x48,
                                0x46,
                                0x6c,
                                0x73,
                                0x4c,
                                0x76,
                                0x71,
                                0x46,
                                0x56,
                                0x70,
                                0x68,
                                0x41,
                                0x52,
                                0x4a,
                                0x44,
                                0x77,
                                0x79,
                                0x4e,
                                0x61,
                                0x59,
                                0x62,
                                0x70,
                                0x77,
                                0x2f,
                                0x64,
                                0x39,
                                0x0a,
                                0x78,
                                0x74,
                                0x55,
                                0x58,
                                0x46,
                                0x6e,
                                0x5a,
                                0x6b,
                                0x46,
                                0x4b,
                                0x2b,
                                0x35,
                                0x42,
                                0x33,
                                0x6a,
                                0x7a,
                                0x44,
                                0x38,
                                0x4f,
                                0x61,
                                0x64,
                                0x77,
                                0x63,
                                0x2f,
                                0x71,
                                0x6f,
                                0x36,
                                0x6d,
                                0x68,
                                0x2f,
                                0x75,
                                0x71,
                                0x41,
                                0x6b,
                                0x34,
                                0x57,
                                0x51,
                                0x71,
                                0x50,
                                0x6d,
                                0x46,
                                0x50,
                                0x59,
                                0x55,
                                0x50,
                                0x2b,
                                0x50,
                                0x68,
                                0x38,
                                0x44,
                                0x44,
                                0x63,
                                0x76,
                                0x45,
                                0x4c,
                                0x4d,
                                0x6f,
                                0x32,
                                0x70,
                                0x6e,
                                0x2b,
                                0x39,
                                0x63,
                                0x2b,
                                0x0a,
                                0x59,
                                0x4f,
                                0x41,
                                0x6f,
                                0x58,
                                0x74,
                                0x75,
                                0x45,
                                0x44,
                                0x33,
                                0x33,
                                0x4a,
                                0x39,
                                0x4e,
                                0x31,
                                0x73,
                                0x76,
                                0x32,
                                0x55,
                                0x57,
                                0x72,
                                0x6b,
                                0x6f,
                                0x4c,
                                0x45,
                                0x4a,
                                0x38,
                                0x73,
                                0x34,
                                0x61,
                                0x32,
                                0x63,
                                0x2f,
                                0x56,
                                0x69,
                                0x65,
                                0x66,
                                0x76,
                                0x4d,
                                0x46,
                                0x4b,
                                0x6f,
                                0x2b,
                                0x4f,
                                0x45,
                                0x50,
                                0x42,
                                0x4f,
                                0x71,
                                0x57,
                                0x45,
                                0x53,
                                0x39,
                                0x49,
                                0x65,
                                0x4d,
                                0x58,
                                0x69,
                                0x4c,
                                0x42,
                                0x44,
                                0x72,
                                0x2f,
                                0x69,
                                0x0a,
                                0x4d,
                                0x44,
                                0x57,
                                0x31,
                                0x57,
                                0x4a,
                                0x76,
                                0x46,
                                0x74,
                                0x57,
                                0x78,
                                0x32,
                                0x57,
                                0x33,
                                0x56,
                                0x74,
                                0x55,
                                0x6e,
                                0x6a,
                                0x4d,
                                0x4b,
                                0x62,
                                0x52,
                                0x47,
                                0x2b,
                                0x78,
                                0x6a,
                                0x34,
                                0x46,
                                0x47,
                                0x6a,
                                0x76,
                                0x38,
                                0x69,
                                0x63,
                                0x2f,
                                0x34,
                                0x53,
                                0x71,
                                0x6e,
                                0x4b,
                                0x36,
                                0x53,
                                0x43,
                                0x65,
                                0x2f,
                                0x79,
                                0x4b,
                                0x47,
                                0x67,
                                0x45,
                                0x79,
                                0x76,
                                0x6f,
                                0x2f,
                                0x61,
                                0x66,
                                0x4e,
                                0x6d,
                                0x39,
                                0x30,
                                0x49,
                                0x74,
                                0x76,
                                0x0a,
                                0x31,
                                0x45,
                                0x36,
                                0x61,
                                0x69,
                                0x41,
                                0x79,
                                0x49,
                                0x4d,
                                0x73,
                                0x6d,
                                0x51,
                                0x43,
                                0x31,
                                0x4a,
                                0x4f,
                                0x6f,
                                0x56,
                                0x68,
                                0x2f,
                                0x65,
                                0x30,
                                0x71,
                                0x44,
                                0x47,
                                0x71,
                                0x70,
                                0x49,
                                0x56,
                                0x49,
                                0x37,
                                0x41,
                                0x2f,
                                0x4f,
                                0x73,
                                0x7a,
                                0x39,
                                0x74,
                                0x53,
                                0x68,
                                0x78,
                                0x44,
                                0x65,
                                0x52,
                                0x75,
                                0x5a,
                                0x46,
                                0x39,
                                0x2b,
                                0x67,
                                0x4d,
                                0x4d,
                                0x6e,
                                0x30,
                                0x68,
                                0x41,
                                0x4a,
                                0x6b,
                                0x62,
                                0x35,
                                0x52,
                                0x33,
                                0x4d,
                                0x78,
                                0x0a,
                                0x6f,
                                0x38,
                                0x58,
                                0x36,
                                0x6b,
                                0x44,
                                0x77,
                                0x61,
                                0x73,
                                0x7a,
                                0x48,
                                0x48,
                                0x76,
                                0x52,
                                0x55,
                                0x73,
                                0x66,
                                0x54,
                                0x66,
                                0x6b,
                                0x66,
                                0x57,
                                0x38,
                                0x50,
                                0x31,
                                0x51,
                                0x62,
                                0x48,
                                0x77,
                                0x6e,
                                0x4d,
                                0x78,
                                0x65,
                                0x53,
                                0x79,
                                0x70,
                                0x75,
                                0x30,
                                0x61,
                                0x49,
                                0x78,
                                0x77,
                                0x2b,
                                0x63,
                                0x38,
                                0x44,
                                0x6d,
                                0x7a,
                                0x74,
                                0x2b,
                                0x6c,
                                0x73,
                                0x37,
                                0x62,
                                0x6a,
                                0x32,
                                0x6d,
                                0x32,
                                0x36,
                                0x48,
                                0x38,
                                0x39,
                                0x4a,
                                0x68,
                                0x0a,
                                0x59,
                                0x6c,
                                0x63,
                                0x72,
                                0x68,
                                0x64,
                                0x33,
                                0x44,
                                0x6d,
                                0x2f,
                                0x37,
                                0x61,
                                0x68,
                                0x6c,
                                0x56,
                                0x66,
                                0x64,
                                0x35,
                                0x79,
                                0x4b,
                                0x77,
                                0x41,
                                0x57,
                                0x38,
                                0x76,
                                0x77,
                                0x32,
                                0x77,
                                0x57,
                                0x79,
                                0x45,
                                0x43,
                                0x56,
                                0x79,
                                0x37,
                                0x4c,
                                0x4c,
                                0x5a,
                                0x36,
                                0x63,
                                0x4b,
                                0x5a,
                                0x57,
                                0x57,
                                0x32,
                                0x6d,
                                0x5a,
                                0x47,
                                0x4b,
                                0x6a,
                                0x37,
                                0x7a,
                                0x75,
                                0x78,
                                0x6b,
                                0x56,
                                0x65,
                                0x39,
                                0x42,
                                0x2f,
                                0x4d,
                                0x44,
                                0x54,
                                0x75,
                                0x0a,
                                0x54,
                                0x6e,
                                0x39,
                                0x7a,
                                0x41,
                                0x67,
                                0x4d,
                                0x42,
                                0x41,
                                0x41,
                                0x45,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x4a,
                                0x4b,
                                0x6f,
                                0x5a,
                                0x49,
                                0x68,
                                0x76,
                                0x63,
                                0x4e,
                                0x41,
                                0x51,
                                0x45,
                                0x4c,
                                0x42,
                                0x51,
                                0x41,
                                0x44,
                                0x67,
                                0x67,
                                0x45,
                                0x42,
                                0x41,
                                0x4d,
                                0x4c,
                                0x70,
                                0x6f,
                                0x2b,
                                0x53,
                                0x58,
                                0x43,
                                0x46,
                                0x2b,
                                0x35,
                                0x73,
                                0x4d,
                                0x35,
                                0x68,
                                0x57,
                                0x62,
                                0x4a,
                                0x6d,
                                0x38,
                                0x77,
                                0x52,
                                0x64,
                                0x4e,
                                0x36,
                                0x45,
                                0x63,
                                0x0a,
                                0x4d,
                                0x48,
                                0x6a,
                                0x54,
                                0x33,
                                0x74,
                                0x61,
                                0x2b,
                                0x7a,
                                0x79,
                                0x74,
                                0x6d,
                                0x33,
                                0x6f,
                                0x79,
                                0x71,
                                0x59,
                                0x63,
                                0x53,
                                0x2f,
                                0x62,
                                0x53,
                                0x43,
                                0x56,
                                0x74,
                                0x30,
                                0x6a,
                                0x38,
                                0x65,
                                0x71,
                                0x72,
                                0x5a,
                                0x54,
                                0x33,
                                0x73,
                                0x63,
                                0x43,
                                0x77,
                                0x77,
                                0x69,
                                0x77,
                                0x53,
                                0x79,
                                0x32,
                                0x73,
                                0x37,
                                0x5a,
                                0x63,
                                0x65,
                                0x74,
                                0x35,
                                0x75,
                                0x6d,
                                0x6b,
                                0x46,
                                0x55,
                                0x48,
                                0x62,
                                0x36,
                                0x4a,
                                0x65,
                                0x6e,
                                0x30,
                                0x51,
                                0x0a,
                                0x6c,
                                0x58,
                                0x4b,
                                0x42,
                                0x6f,
                                0x61,
                                0x53,
                                0x47,
                                0x54,
                                0x57,
                                0x42,
                                0x4f,
                                0x5a,
                                0x62,
                                0x6b,
                                0x69,
                                0x55,
                                0x36,
                                0x4f,
                                0x36,
                                0x6d,
                                0x36,
                                0x52,
                                0x4c,
                                0x4d,
                                0x72,
                                0x4d,
                                0x6d,
                                0x62,
                                0x70,
                                0x32,
                                0x6b,
                                0x68,
                                0x4e,
                                0x61,
                                0x67,
                                0x36,
                                0x59,
                                0x71,
                                0x39,
                                0x70,
                                0x33,
                                0x73,
                                0x66,
                                0x73,
                                0x59,
                                0x7a,
                                0x38,
                                0x69,
                                0x45,
                                0x31,
                                0x38,
                                0x7a,
                                0x36,
                                0x43,
                                0x31,
                                0x76,
                                0x70,
                                0x75,
                                0x4b,
                                0x63,
                                0x39,
                                0x51,
                                0x54,
                                0x0a,
                                0x50,
                                0x51,
                                0x4c,
                                0x51,
                                0x65,
                                0x7a,
                                0x6c,
                                0x68,
                                0x77,
                                0x5a,
                                0x5a,
                                0x57,
                                0x52,
                                0x4e,
                                0x77,
                                0x6b,
                                0x43,
                                0x79,
                                0x4e,
                                0x52,
                                0x42,
                                0x6a,
                                0x69,
                                0x39,
                                0x4e,
                                0x37,
                                0x55,
                                0x2f,
                                0x75,
                                0x4f,
                                0x52,
                                0x4f,
                                0x49,
                                0x38,
                                0x64,
                                0x6b,
                                0x36,
                                0x4b,
                                0x48,
                                0x6e,
                                0x4d,
                                0x5a,
                                0x52,
                                0x32,
                                0x69,
                                0x52,
                                0x34,
                                0x65,
                                0x43,
                                0x53,
                                0x42,
                                0x32,
                                0x67,
                                0x74,
                                0x6b,
                                0x76,
                                0x68,
                                0x50,
                                0x65,
                                0x4c,
                                0x55,
                                0x58,
                                0x77,
                                0x58,
                                0x0a,
                                0x38,
                                0x4a,
                                0x79,
                                0x6d,
                                0x32,
                                0x51,
                                0x48,
                                0x58,
                                0x35,
                                0x43,
                                0x59,
                                0x37,
                                0x2f,
                                0x59,
                                0x4d,
                                0x66,
                                0x73,
                                0x34,
                                0x44,
                                0x30,
                                0x49,
                                0x38,
                                0x66,
                                0x70,
                                0x6a,
                                0x53,
                                0x4f,
                                0x65,
                                0x65,
                                0x52,
                                0x59,
                                0x33,
                                0x63,
                                0x6e,
                                0x4a,
                                0x76,
                                0x33,
                                0x37,
                                0x4c,
                                0x75,
                                0x51,
                                0x4c,
                                0x35,
                                0x72,
                                0x4a,
                                0x70,
                                0x75,
                                0x76,
                                0x49,
                                0x5a,
                                0x78,
                                0x46,
                                0x4a,
                                0x33,
                                0x6e,
                                0x56,
                                0x72,
                                0x37,
                                0x56,
                                0x2b,
                                0x44,
                                0x54,
                                0x4d,
                                0x72,
                                0x0a,
                                0x4e,
                                0x71,
                                0x4e,
                                0x45,
                                0x34,
                                0x69,
                                0x57,
                                0x48,
                                0x4d,
                                0x56,
                                0x58,
                                0x71,
                                0x63,
                                0x45,
                                0x62,
                                0x4d,
                                0x53,
                                0x2f,
                                0x59,
                                0x4a,
                                0x6a,
                                0x38,
                                0x34,
                                0x69,
                                0x63,
                                0x47,
                                0x65,
                                0x31,
                                0x70,
                                0x43,
                                0x55,
                                0x30,
                                0x31,
                                0x65,
                                0x49,
                                0x2f,
                                0x61,
                                0x33,
                                0x34,
                                0x72,
                                0x79,
                                0x53,
                                0x67,
                                0x55,
                                0x75,
                                0x2b,
                                0x33,
                                0x53,
                                0x43,
                                0x55,
                                0x55,
                                0x61,
                                0x58,
                                0x5a,
                                0x73,
                                0x2f,
                                0x2b,
                                0x51,
                                0x41,
                                0x3d,
                                0x0a,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x45,
                                0x4e,
                                0x44,
                                0x20,
                                0x43,
                                0x45,
                                0x52,
                                0x54,
                                0x49,
                                0x46,
                                0x49,
                                0x43,
                                0x41,
                                0x54,
                                0x45,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x0a
#ifdef CONFIG_MBEDTLS
                                ,
                                0x00
#endif
};

unsigned char server_key[] = { 0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x42,
                               0x45,
                               0x47,
                               0x49,
                               0x4e,
                               0x20,
                               0x52,
                               0x53,
                               0x41,
                               0x20,
                               0x50,
                               0x52,
                               0x49,
                               0x56,
                               0x41,
                               0x54,
                               0x45,
                               0x20,
                               0x4b,
                               0x45,
                               0x59,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x0a,
                               0x4d,
                               0x49,
                               0x49,
                               0x4a,
                               0x4b,
                               0x41,
                               0x49,
                               0x42,
                               0x41,
                               0x41,
                               0x4b,
                               0x43,
                               0x41,
                               0x67,
                               0x45,
                               0x41,
                               0x79,
                               0x31,
                               0x65,
                               0x71,
                               0x47,
                               0x4a,
                               0x69,
                               0x45,
                               0x61,
                               0x4e,
                               0x55,
                               0x76,
                               0x42,
                               0x57,
                               0x35,
                               0x72,
                               0x4b,
                               0x38,
                               0x77,
                               0x77,
                               0x69,
                               0x75,
                               0x4d,
                               0x72,
                               0x74,
                               0x4c,
                               0x67,
                               0x74,
                               0x74,
                               0x45,
                               0x65,
                               0x55,
                               0x31,
                               0x51,
                               0x4f,
                               0x30,
                               0x6e,
                               0x4d,
                               0x57,
                               0x6a,
                               0x59,
                               0x43,
                               0x4f,
                               0x34,
                               0x75,
                               0x36,
                               0x61,
                               0x31,
                               0x0a,
                               0x34,
                               0x58,
                               0x34,
                               0x6f,
                               0x75,
                               0x7a,
                               0x68,
                               0x57,
                               0x4e,
                               0x6a,
                               0x50,
                               0x47,
                               0x35,
                               0x31,
                               0x6f,
                               0x4a,
                               0x43,
                               0x76,
                               0x4b,
                               0x38,
                               0x78,
                               0x71,
                               0x58,
                               0x52,
                               0x33,
                               0x2f,
                               0x7a,
                               0x62,
                               0x79,
                               0x36,
                               0x66,
                               0x66,
                               0x48,
                               0x69,
                               0x42,
                               0x61,
                               0x4e,
                               0x68,
                               0x4d,
                               0x34,
                               0x4c,
                               0x6e,
                               0x6c,
                               0x78,
                               0x44,
                               0x30,
                               0x77,
                               0x4d,
                               0x31,
                               0x33,
                               0x36,
                               0x6d,
                               0x59,
                               0x77,
                               0x51,
                               0x54,
                               0x6a,
                               0x35,
                               0x33,
                               0x57,
                               0x36,
                               0x64,
                               0x4e,
                               0x2b,
                               0x0a,
                               0x6a,
                               0x33,
                               0x7a,
                               0x7a,
                               0x61,
                               0x4d,
                               0x7a,
                               0x78,
                               0x36,
                               0x4f,
                               0x55,
                               0x30,
                               0x56,
                               0x4e,
                               0x77,
                               0x4f,
                               0x68,
                               0x4d,
                               0x2b,
                               0x47,
                               0x67,
                               0x33,
                               0x76,
                               0x43,
                               0x70,
                               0x2f,
                               0x45,
                               0x37,
                               0x58,
                               0x6b,
                               0x57,
                               0x65,
                               0x4a,
                               0x50,
                               0x42,
                               0x4d,
                               0x4a,
                               0x62,
                               0x33,
                               0x52,
                               0x75,
                               0x62,
                               0x50,
                               0x76,
                               0x61,
                               0x33,
                               0x72,
                               0x4d,
                               0x73,
                               0x36,
                               0x62,
                               0x63,
                               0x4b,
                               0x6c,
                               0x6d,
                               0x36,
                               0x35,
                               0x30,
                               0x64,
                               0x4b,
                               0x64,
                               0x63,
                               0x65,
                               0x71,
                               0x0a,
                               0x32,
                               0x41,
                               0x37,
                               0x50,
                               0x71,
                               0x64,
                               0x4a,
                               0x4a,
                               0x74,
                               0x4f,
                               0x4d,
                               0x37,
                               0x56,
                               0x42,
                               0x48,
                               0x63,
                               0x73,
                               0x33,
                               0x34,
                               0x4f,
                               0x38,
                               0x33,
                               0x54,
                               0x68,
                               0x73,
                               0x78,
                               0x63,
                               0x46,
                               0x39,
                               0x37,
                               0x2f,
                               0x51,
                               0x31,
                               0x55,
                               0x54,
                               0x39,
                               0x43,
                               0x6c,
                               0x34,
                               0x34,
                               0x34,
                               0x59,
                               0x39,
                               0x6c,
                               0x49,
                               0x59,
                               0x49,
                               0x36,
                               0x30,
                               0x71,
                               0x38,
                               0x4e,
                               0x6e,
                               0x67,
                               0x36,
                               0x37,
                               0x49,
                               0x71,
                               0x47,
                               0x62,
                               0x5a,
                               0x47,
                               0x69,
                               0x73,
                               0x0a,
                               0x59,
                               0x6d,
                               0x63,
                               0x75,
                               0x5a,
                               0x66,
                               0x45,
                               0x4d,
                               0x55,
                               0x65,
                               0x59,
                               0x45,
                               0x79,
                               0x6e,
                               0x54,
                               0x52,
                               0x30,
                               0x42,
                               0x78,
                               0x36,
                               0x73,
                               0x45,
                               0x52,
                               0x45,
                               0x73,
                               0x4f,
                               0x51,
                               0x74,
                               0x47,
                               0x6c,
                               0x31,
                               0x62,
                               0x6a,
                               0x77,
                               0x72,
                               0x61,
                               0x4c,
                               0x6d,
                               0x30,
                               0x46,
                               0x43,
                               0x38,
                               0x42,
                               0x77,
                               0x6c,
                               0x6e,
                               0x4f,
                               0x55,
                               0x76,
                               0x78,
                               0x44,
                               0x34,
                               0x66,
                               0x5a,
                               0x2b,
                               0x43,
                               0x35,
                               0x4a,
                               0x73,
                               0x48,
                               0x62,
                               0x5a,
                               0x35,
                               0x54,
                               0x0a,
                               0x4b,
                               0x30,
                               0x46,
                               0x74,
                               0x73,
                               0x32,
                               0x65,
                               0x43,
                               0x2f,
                               0x71,
                               0x48,
                               0x4a,
                               0x48,
                               0x4c,
                               0x52,
                               0x73,
                               0x41,
                               0x6a,
                               0x4e,
                               0x70,
                               0x67,
                               0x66,
                               0x42,
                               0x71,
                               0x6c,
                               0x45,
                               0x6a,
                               0x47,
                               0x73,
                               0x74,
                               0x4e,
                               0x61,
                               0x64,
                               0x30,
                               0x79,
                               0x49,
                               0x48,
                               0x76,
                               0x49,
                               0x36,
                               0x39,
                               0x32,
                               0x4b,
                               0x79,
                               0x56,
                               0x54,
                               0x37,
                               0x56,
                               0x4b,
                               0x67,
                               0x56,
                               0x59,
                               0x42,
                               0x74,
                               0x39,
                               0x58,
                               0x6e,
                               0x4b,
                               0x36,
                               0x48,
                               0x41,
                               0x36,
                               0x66,
                               0x42,
                               0x0a,
                               0x4d,
                               0x78,
                               0x4b,
                               0x68,
                               0x31,
                               0x48,
                               0x54,
                               0x30,
                               0x37,
                               0x47,
                               0x42,
                               0x52,
                               0x71,
                               0x34,
                               0x44,
                               0x62,
                               0x4b,
                               0x73,
                               0x41,
                               0x76,
                               0x5a,
                               0x44,
                               0x73,
                               0x45,
                               0x7a,
                               0x6b,
                               0x61,
                               0x64,
                               0x67,
                               0x75,
                               0x6c,
                               0x53,
                               0x6a,
                               0x6d,
                               0x72,
                               0x6b,
                               0x57,
                               0x41,
                               0x44,
                               0x43,
                               0x53,
                               0x77,
                               0x6d,
                               0x58,
                               0x7a,
                               0x44,
                               0x4a,
                               0x49,
                               0x4f,
                               0x6c,
                               0x68,
                               0x78,
                               0x43,
                               0x76,
                               0x73,
                               0x57,
                               0x76,
                               0x4e,
                               0x4b,
                               0x4f,
                               0x70,
                               0x7a,
                               0x57,
                               0x6a,
                               0x0a,
                               0x31,
                               0x53,
                               0x7a,
                               0x75,
                               0x45,
                               0x51,
                               0x53,
                               0x57,
                               0x53,
                               0x38,
                               0x30,
                               0x46,
                               0x6d,
                               0x54,
                               0x58,
                               0x35,
                               0x55,
                               0x39,
                               0x4e,
                               0x6f,
                               0x2f,
                               0x6e,
                               0x45,
                               0x52,
                               0x6a,
                               0x4b,
                               0x6c,
                               0x78,
                               0x75,
                               0x44,
                               0x36,
                               0x37,
                               0x35,
                               0x67,
                               0x4c,
                               0x4e,
                               0x79,
                               0x30,
                               0x6c,
                               0x61,
                               0x63,
                               0x6b,
                               0x70,
                               0x73,
                               0x49,
                               0x48,
                               0x50,
                               0x5a,
                               0x36,
                               0x7a,
                               0x6f,
                               0x71,
                               0x53,
                               0x6c,
                               0x38,
                               0x4c,
                               0x68,
                               0x70,
                               0x5a,
                               0x7a,
                               0x78,
                               0x51,
                               0x67,
                               0x75,
                               0x0a,
                               0x56,
                               0x51,
                               0x72,
                               0x39,
                               0x62,
                               0x69,
                               0x4e,
                               0x45,
                               0x57,
                               0x77,
                               0x30,
                               0x62,
                               0x64,
                               0x53,
                               0x45,
                               0x44,
                               0x57,
                               0x2b,
                               0x63,
                               0x68,
                               0x6e,
                               0x41,
                               0x72,
                               0x7a,
                               0x71,
                               0x4b,
                               0x71,
                               0x62,
                               0x65,
                               0x54,
                               0x34,
                               0x38,
                               0x52,
                               0x74,
                               0x71,
                               0x46,
                               0x77,
                               0x54,
                               0x45,
                               0x44,
                               0x69,
                               0x6f,
                               0x48,
                               0x38,
                               0x73,
                               0x47,
                               0x47,
                               0x69,
                               0x43,
                               0x2b,
                               0x7a,
                               0x6a,
                               0x50,
                               0x31,
                               0x76,
                               0x59,
                               0x78,
                               0x44,
                               0x66,
                               0x6d,
                               0x32,
                               0x49,
                               0x69,
                               0x68,
                               0x0a,
                               0x41,
                               0x4f,
                               0x50,
                               0x74,
                               0x48,
                               0x6e,
                               0x45,
                               0x33,
                               0x78,
                               0x7a,
                               0x6b,
                               0x44,
                               0x4c,
                               0x41,
                               0x50,
                               0x4a,
                               0x76,
                               0x7a,
                               0x45,
                               0x61,
                               0x2f,
                               0x5a,
                               0x69,
                               0x61,
                               0x54,
                               0x69,
                               0x4d,
                               0x61,
                               0x30,
                               0x4f,
                               0x52,
                               0x32,
                               0x71,
                               0x74,
                               0x75,
                               0x30,
                               0x68,
                               0x54,
                               0x6a,
                               0x62,
                               0x34,
                               0x63,
                               0x7a,
                               0x58,
                               0x49,
                               0x36,
                               0x54,
                               0x79,
                               0x37,
                               0x78,
                               0x6b,
                               0x53,
                               0x4c,
                               0x45,
                               0x74,
                               0x44,
                               0x4f,
                               0x6a,
                               0x43,
                               0x61,
                               0x70,
                               0x53,
                               0x71,
                               0x74,
                               0x0a,
                               0x34,
                               0x45,
                               0x4b,
                               0x47,
                               0x67,
                               0x43,
                               0x69,
                               0x78,
                               0x7a,
                               0x63,
                               0x55,
                               0x35,
                               0x45,
                               0x36,
                               0x5a,
                               0x4d,
                               0x49,
                               0x4f,
                               0x56,
                               0x6a,
                               0x72,
                               0x66,
                               0x6a,
                               0x39,
                               0x70,
                               0x77,
                               0x67,
                               0x67,
                               0x2f,
                               0x66,
                               0x56,
                               0x31,
                               0x35,
                               0x30,
                               0x63,
                               0x31,
                               0x68,
                               0x6e,
                               0x6e,
                               0x56,
                               0x47,
                               0x75,
                               0x36,
                               0x51,
                               0x42,
                               0x30,
                               0x44,
                               0x72,
                               0x59,
                               0x4e,
                               0x73,
                               0x59,
                               0x50,
                               0x43,
                               0x44,
                               0x44,
                               0x50,
                               0x70,
                               0x4d,
                               0x43,
                               0x41,
                               0x77,
                               0x45,
                               0x41,
                               0x0a,
                               0x41,
                               0x51,
                               0x4b,
                               0x43,
                               0x41,
                               0x67,
                               0x45,
                               0x41,
                               0x74,
                               0x69,
                               0x33,
                               0x49,
                               0x65,
                               0x31,
                               0x6a,
                               0x4a,
                               0x36,
                               0x4a,
                               0x4a,
                               0x33,
                               0x47,
                               0x6b,
                               0x71,
                               0x66,
                               0x51,
                               0x68,
                               0x49,
                               0x69,
                               0x75,
                               0x34,
                               0x78,
                               0x6b,
                               0x4c,
                               0x2f,
                               0x6d,
                               0x44,
                               0x47,
                               0x53,
                               0x32,
                               0x34,
                               0x72,
                               0x6c,
                               0x41,
                               0x76,
                               0x6c,
                               0x50,
                               0x57,
                               0x4e,
                               0x4e,
                               0x69,
                               0x6c,
                               0x4b,
                               0x37,
                               0x50,
                               0x53,
                               0x6a,
                               0x70,
                               0x32,
                               0x38,
                               0x38,
                               0x56,
                               0x75,
                               0x42,
                               0x57,
                               0x0a,
                               0x66,
                               0x53,
                               0x46,
                               0x4f,
                               0x5a,
                               0x79,
                               0x42,
                               0x48,
                               0x55,
                               0x63,
                               0x50,
                               0x41,
                               0x56,
                               0x63,
                               0x6c,
                               0x69,
                               0x69,
                               0x32,
                               0x63,
                               0x6b,
                               0x46,
                               0x51,
                               0x5a,
                               0x46,
                               0x34,
                               0x39,
                               0x76,
                               0x67,
                               0x64,
                               0x75,
                               0x6f,
                               0x70,
                               0x50,
                               0x35,
                               0x6f,
                               0x57,
                               0x4c,
                               0x54,
                               0x70,
                               0x5a,
                               0x6c,
                               0x77,
                               0x67,
                               0x6c,
                               0x55,
                               0x6a,
                               0x6a,
                               0x6f,
                               0x76,
                               0x5a,
                               0x63,
                               0x51,
                               0x59,
                               0x56,
                               0x58,
                               0x57,
                               0x34,
                               0x66,
                               0x39,
                               0x30,
                               0x70,
                               0x4d,
                               0x52,
                               0x5a,
                               0x0a,
                               0x52,
                               0x2b,
                               0x74,
                               0x79,
                               0x51,
                               0x30,
                               0x55,
                               0x55,
                               0x7a,
                               0x50,
                               0x43,
                               0x51,
                               0x39,
                               0x32,
                               0x50,
                               0x2b,
                               0x4e,
                               0x6a,
                               0x44,
                               0x75,
                               0x6d,
                               0x37,
                               0x75,
                               0x4c,
                               0x77,
                               0x46,
                               0x52,
                               0x36,
                               0x4a,
                               0x4b,
                               0x59,
                               0x34,
                               0x4c,
                               0x45,
                               0x53,
                               0x46,
                               0x6b,
                               0x4b,
                               0x6e,
                               0x6f,
                               0x6c,
                               0x46,
                               0x77,
                               0x2b,
                               0x6a,
                               0x4d,
                               0x4c,
                               0x76,
                               0x72,
                               0x52,
                               0x34,
                               0x32,
                               0x47,
                               0x2b,
                               0x66,
                               0x54,
                               0x72,
                               0x4e,
                               0x63,
                               0x34,
                               0x50,
                               0x6c,
                               0x48,
                               0x6c,
                               0x0a,
                               0x4c,
                               0x32,
                               0x63,
                               0x57,
                               0x56,
                               0x47,
                               0x2f,
                               0x63,
                               0x61,
                               0x41,
                               0x50,
                               0x63,
                               0x71,
                               0x55,
                               0x70,
                               0x69,
                               0x6d,
                               0x2b,
                               0x31,
                               0x59,
                               0x72,
                               0x32,
                               0x72,
                               0x76,
                               0x55,
                               0x75,
                               0x51,
                               0x49,
                               0x51,
                               0x53,
                               0x33,
                               0x42,
                               0x6b,
                               0x48,
                               0x54,
                               0x45,
                               0x69,
                               0x6f,
                               0x7a,
                               0x2b,
                               0x33,
                               0x70,
                               0x74,
                               0x76,
                               0x65,
                               0x39,
                               0x68,
                               0x2b,
                               0x32,
                               0x4c,
                               0x77,
                               0x70,
                               0x57,
                               0x49,
                               0x42,
                               0x66,
                               0x55,
                               0x5a,
                               0x70,
                               0x58,
                               0x2b,
                               0x34,
                               0x56,
                               0x48,
                               0x0a,
                               0x49,
                               0x47,
                               0x6b,
                               0x51,
                               0x69,
                               0x63,
                               0x4b,
                               0x33,
                               0x35,
                               0x39,
                               0x68,
                               0x63,
                               0x49,
                               0x32,
                               0x68,
                               0x47,
                               0x6b,
                               0x71,
                               0x55,
                               0x62,
                               0x73,
                               0x36,
                               0x39,
                               0x49,
                               0x78,
                               0x4a,
                               0x4e,
                               0x59,
                               0x66,
                               0x70,
                               0x65,
                               0x32,
                               0x47,
                               0x5a,
                               0x31,
                               0x45,
                               0x51,
                               0x63,
                               0x63,
                               0x7a,
                               0x30,
                               0x53,
                               0x73,
                               0x48,
                               0x4e,
                               0x71,
                               0x57,
                               0x65,
                               0x77,
                               0x2b,
                               0x6f,
                               0x52,
                               0x63,
                               0x61,
                               0x69,
                               0x54,
                               0x6f,
                               0x77,
                               0x46,
                               0x76,
                               0x6f,
                               0x33,
                               0x68,
                               0x74,
                               0x0a,
                               0x36,
                               0x47,
                               0x78,
                               0x53,
                               0x6e,
                               0x71,
                               0x45,
                               0x57,
                               0x30,
                               0x37,
                               0x48,
                               0x30,
                               0x4b,
                               0x54,
                               0x4b,
                               0x59,
                               0x69,
                               0x6c,
                               0x6e,
                               0x5a,
                               0x69,
                               0x34,
                               0x58,
                               0x49,
                               0x57,
                               0x33,
                               0x48,
                               0x35,
                               0x30,
                               0x51,
                               0x61,
                               0x75,
                               0x61,
                               0x68,
                               0x62,
                               0x77,
                               0x48,
                               0x30,
                               0x75,
                               0x56,
                               0x73,
                               0x64,
                               0x32,
                               0x55,
                               0x39,
                               0x6f,
                               0x34,
                               0x6c,
                               0x37,
                               0x54,
                               0x38,
                               0x5a,
                               0x4d,
                               0x65,
                               0x34,
                               0x52,
                               0x50,
                               0x6d,
                               0x66,
                               0x39,
                               0x77,
                               0x46,
                               0x6e,
                               0x2f,
                               0x0a,
                               0x45,
                               0x7a,
                               0x34,
                               0x46,
                               0x74,
                               0x68,
                               0x62,
                               0x6e,
                               0x51,
                               0x4f,
                               0x57,
                               0x42,
                               0x6f,
                               0x31,
                               0x44,
                               0x78,
                               0x61,
                               0x42,
                               0x6d,
                               0x78,
                               0x39,
                               0x42,
                               0x66,
                               0x6e,
                               0x35,
                               0x6e,
                               0x43,
                               0x35,
                               0x49,
                               0x36,
                               0x52,
                               0x79,
                               0x72,
                               0x36,
                               0x58,
                               0x4d,
                               0x6e,
                               0x6e,
                               0x4a,
                               0x4a,
                               0x2b,
                               0x65,
                               0x41,
                               0x74,
                               0x53,
                               0x6a,
                               0x58,
                               0x53,
                               0x41,
                               0x56,
                               0x37,
                               0x2f,
                               0x36,
                               0x33,
                               0x43,
                               0x72,
                               0x70,
                               0x63,
                               0x42,
                               0x2b,
                               0x73,
                               0x42,
                               0x74,
                               0x46,
                               0x0a,
                               0x69,
                               0x7a,
                               0x46,
                               0x33,
                               0x79,
                               0x45,
                               0x51,
                               0x38,
                               0x72,
                               0x74,
                               0x57,
                               0x41,
                               0x43,
                               0x71,
                               0x78,
                               0x6a,
                               0x4d,
                               0x55,
                               0x50,
                               0x43,
                               0x33,
                               0x4a,
                               0x71,
                               0x39,
                               0x6c,
                               0x39,
                               0x33,
                               0x39,
                               0x38,
                               0x2f,
                               0x6a,
                               0x7a,
                               0x43,
                               0x70,
                               0x5a,
                               0x5a,
                               0x4c,
                               0x76,
                               0x7a,
                               0x34,
                               0x4e,
                               0x55,
                               0x6a,
                               0x6a,
                               0x74,
                               0x66,
                               0x4e,
                               0x68,
                               0x33,
                               0x69,
                               0x36,
                               0x44,
                               0x50,
                               0x36,
                               0x49,
                               0x68,
                               0x41,
                               0x4b,
                               0x31,
                               0x33,
                               0x54,
                               0x56,
                               0x37,
                               0x49,
                               0x0a,
                               0x34,
                               0x47,
                               0x34,
                               0x30,
                               0x62,
                               0x72,
                               0x5a,
                               0x68,
                               0x6d,
                               0x58,
                               0x53,
                               0x56,
                               0x4b,
                               0x42,
                               0x6e,
                               0x78,
                               0x47,
                               0x37,
                               0x44,
                               0x35,
                               0x69,
                               0x59,
                               0x36,
                               0x50,
                               0x62,
                               0x67,
                               0x56,
                               0x57,
                               0x48,
                               0x46,
                               0x44,
                               0x45,
                               0x6a,
                               0x50,
                               0x44,
                               0x77,
                               0x6f,
                               0x4a,
                               0x6b,
                               0x74,
                               0x4b,
                               0x31,
                               0x42,
                               0x50,
                               0x61,
                               0x64,
                               0x33,
                               0x71,
                               0x57,
                               0x66,
                               0x39,
                               0x34,
                               0x66,
                               0x6d,
                               0x74,
                               0x35,
                               0x79,
                               0x6b,
                               0x5a,
                               0x64,
                               0x2f,
                               0x74,
                               0x65,
                               0x71,
                               0x0a,
                               0x65,
                               0x52,
                               0x49,
                               0x45,
                               0x76,
                               0x55,
                               0x7a,
                               0x4a,
                               0x47,
                               0x35,
                               0x50,
                               0x46,
                               0x47,
                               0x77,
                               0x4f,
                               0x7a,
                               0x78,
                               0x56,
                               0x52,
                               0x48,
                               0x44,
                               0x4e,
                               0x38,
                               0x51,
                               0x51,
                               0x6d,
                               0x4e,
                               0x4a,
                               0x63,
                               0x43,
                               0x4a,
                               0x75,
                               0x79,
                               0x74,
                               0x77,
                               0x34,
                               0x44,
                               0x6e,
                               0x73,
                               0x78,
                               0x6f,
                               0x43,
                               0x38,
                               0x33,
                               0x69,
                               0x7a,
                               0x66,
                               0x68,
                               0x2b,
                               0x6e,
                               0x45,
                               0x71,
                               0x45,
                               0x50,
                               0x50,
                               0x51,
                               0x69,
                               0x44,
                               0x46,
                               0x6f,
                               0x54,
                               0x4c,
                               0x79,
                               0x44,
                               0x0a,
                               0x2b,
                               0x34,
                               0x56,
                               0x52,
                               0x67,
                               0x46,
                               0x42,
                               0x62,
                               0x36,
                               0x61,
                               0x69,
                               0x72,
                               0x56,
                               0x63,
                               0x79,
                               0x58,
                               0x57,
                               0x64,
                               0x72,
                               0x32,
                               0x30,
                               0x43,
                               0x64,
                               0x4f,
                               0x47,
                               0x67,
                               0x58,
                               0x6f,
                               0x42,
                               0x4d,
                               0x72,
                               0x4e,
                               0x42,
                               0x6c,
                               0x2b,
                               0x45,
                               0x36,
                               0x32,
                               0x4d,
                               0x59,
                               0x41,
                               0x65,
                               0x32,
                               0x71,
                               0x63,
                               0x36,
                               0x37,
                               0x63,
                               0x51,
                               0x59,
                               0x45,
                               0x43,
                               0x67,
                               0x67,
                               0x45,
                               0x42,
                               0x41,
                               0x4f,
                               0x39,
                               0x32,
                               0x58,
                               0x4e,
                               0x41,
                               0x46,
                               0x0a,
                               0x52,
                               0x41,
                               0x77,
                               0x5a,
                               0x79,
                               0x64,
                               0x7a,
                               0x59,
                               0x63,
                               0x68,
                               0x35,
                               0x45,
                               0x35,
                               0x65,
                               0x6a,
                               0x7a,
                               0x39,
                               0x54,
                               0x5a,
                               0x62,
                               0x48,
                               0x66,
                               0x65,
                               0x66,
                               0x34,
                               0x7a,
                               0x4e,
                               0x42,
                               0x48,
                               0x55,
                               0x2f,
                               0x6d,
                               0x56,
                               0x31,
                               0x76,
                               0x68,
                               0x38,
                               0x39,
                               0x64,
                               0x39,
                               0x4b,
                               0x6a,
                               0x53,
                               0x46,
                               0x2f,
                               0x4f,
                               0x69,
                               0x4c,
                               0x33,
                               0x45,
                               0x6e,
                               0x6f,
                               0x59,
                               0x78,
                               0x50,
                               0x6b,
                               0x48,
                               0x67,
                               0x55,
                               0x58,
                               0x79,
                               0x6e,
                               0x39,
                               0x41,
                               0x0a,
                               0x34,
                               0x43,
                               0x34,
                               0x75,
                               0x31,
                               0x72,
                               0x6c,
                               0x64,
                               0x5a,
                               0x36,
                               0x64,
                               0x77,
                               0x43,
                               0x56,
                               0x41,
                               0x62,
                               0x5a,
                               0x4a,
                               0x6e,
                               0x54,
                               0x38,
                               0x55,
                               0x46,
                               0x32,
                               0x6e,
                               0x4c,
                               0x52,
                               0x46,
                               0x4d,
                               0x58,
                               0x68,
                               0x61,
                               0x71,
                               0x79,
                               0x4a,
                               0x45,
                               0x6d,
                               0x54,
                               0x37,
                               0x6a,
                               0x43,
                               0x59,
                               0x52,
                               0x79,
                               0x37,
                               0x65,
                               0x72,
                               0x64,
                               0x37,
                               0x56,
                               0x4c,
                               0x39,
                               0x35,
                               0x67,
                               0x56,
                               0x68,
                               0x55,
                               0x4f,
                               0x73,
                               0x4a,
                               0x59,
                               0x77,
                               0x4c,
                               0x6d,
                               0x0a,
                               0x74,
                               0x59,
                               0x66,
                               0x63,
                               0x69,
                               0x6b,
                               0x30,
                               0x37,
                               0x51,
                               0x6d,
                               0x44,
                               0x53,
                               0x50,
                               0x56,
                               0x75,
                               0x47,
                               0x68,
                               0x56,
                               0x32,
                               0x4b,
                               0x65,
                               0x6b,
                               0x6e,
                               0x7a,
                               0x54,
                               0x61,
                               0x31,
                               0x4e,
                               0x53,
                               0x54,
                               0x55,
                               0x38,
                               0x76,
                               0x77,
                               0x51,
                               0x46,
                               0x2b,
                               0x77,
                               0x4b,
                               0x48,
                               0x69,
                               0x38,
                               0x36,
                               0x34,
                               0x64,
                               0x6d,
                               0x7a,
                               0x6b,
                               0x73,
                               0x6c,
                               0x59,
                               0x6e,
                               0x51,
                               0x71,
                               0x62,
                               0x46,
                               0x6f,
                               0x54,
                               0x56,
                               0x52,
                               0x5a,
                               0x74,
                               0x4e,
                               0x65,
                               0x0a,
                               0x72,
                               0x4c,
                               0x62,
                               0x36,
                               0x67,
                               0x36,
                               0x6e,
                               0x63,
                               0x77,
                               0x36,
                               0x4a,
                               0x57,
                               0x78,
                               0x39,
                               0x79,
                               0x65,
                               0x42,
                               0x30,
                               0x37,
                               0x56,
                               0x64,
                               0x70,
                               0x4a,
                               0x70,
                               0x36,
                               0x78,
                               0x39,
                               0x54,
                               0x59,
                               0x54,
                               0x2b,
                               0x48,
                               0x47,
                               0x6a,
                               0x33,
                               0x6b,
                               0x62,
                               0x35,
                               0x61,
                               0x63,
                               0x75,
                               0x49,
                               0x6e,
                               0x50,
                               0x2b,
                               0x6a,
                               0x67,
                               0x37,
                               0x47,
                               0x5a,
                               0x7a,
                               0x6b,
                               0x72,
                               0x48,
                               0x4a,
                               0x4d,
                               0x6e,
                               0x48,
                               0x4c,
                               0x77,
                               0x65,
                               0x46,
                               0x76,
                               0x62,
                               0x0a,
                               0x4e,
                               0x57,
                               0x5a,
                               0x66,
                               0x6c,
                               0x50,
                               0x66,
                               0x69,
                               0x41,
                               0x4e,
                               0x6d,
                               0x77,
                               0x4d,
                               0x38,
                               0x77,
                               0x4d,
                               0x52,
                               0x2b,
                               0x6b,
                               0x66,
                               0x50,
                               0x32,
                               0x76,
                               0x6f,
                               0x67,
                               0x47,
                               0x61,
                               0x6d,
                               0x4b,
                               0x43,
                               0x69,
                               0x65,
                               0x6f,
                               0x6a,
                               0x56,
                               0x61,
                               0x54,
                               0x69,
                               0x38,
                               0x76,
                               0x67,
                               0x71,
                               0x71,
                               0x6a,
                               0x78,
                               0x34,
                               0x55,
                               0x47,
                               0x50,
                               0x64,
                               0x35,
                               0x39,
                               0x36,
                               0x46,
                               0x4e,
                               0x46,
                               0x65,
                               0x69,
                               0x5a,
                               0x52,
                               0x76,
                               0x58,
                               0x4e,
                               0x6b,
                               0x0a,
                               0x30,
                               0x64,
                               0x42,
                               0x30,
                               0x41,
                               0x4b,
                               0x32,
                               0x51,
                               0x2f,
                               0x31,
                               0x32,
                               0x36,
                               0x53,
                               0x6c,
                               0x45,
                               0x43,
                               0x67,
                               0x67,
                               0x45,
                               0x42,
                               0x41,
                               0x4e,
                               0x6c,
                               0x69,
                               0x74,
                               0x64,
                               0x78,
                               0x48,
                               0x74,
                               0x74,
                               0x78,
                               0x68,
                               0x2f,
                               0x57,
                               0x71,
                               0x77,
                               0x46,
                               0x4b,
                               0x33,
                               0x35,
                               0x62,
                               0x63,
                               0x4f,
                               0x54,
                               0x58,
                               0x61,
                               0x68,
                               0x36,
                               0x50,
                               0x61,
                               0x70,
                               0x50,
                               0x64,
                               0x67,
                               0x2f,
                               0x37,
                               0x32,
                               0x50,
                               0x75,
                               0x4f,
                               0x6c,
                               0x33,
                               0x57,
                               0x74,
                               0x0a,
                               0x37,
                               0x57,
                               0x6e,
                               0x38,
                               0x41,
                               0x74,
                               0x36,
                               0x46,
                               0x49,
                               0x47,
                               0x51,
                               0x33,
                               0x58,
                               0x5a,
                               0x4f,
                               0x4f,
                               0x50,
                               0x66,
                               0x39,
                               0x76,
                               0x35,
                               0x48,
                               0x66,
                               0x71,
                               0x50,
                               0x70,
                               0x53,
                               0x6c,
                               0x4e,
                               0x56,
                               0x39,
                               0x33,
                               0x41,
                               0x58,
                               0x58,
                               0x61,
                               0x4f,
                               0x36,
                               0x49,
                               0x54,
                               0x7a,
                               0x77,
                               0x49,
                               0x45,
                               0x62,
                               0x38,
                               0x49,
                               0x47,
                               0x33,
                               0x69,
                               0x45,
                               0x4f,
                               0x74,
                               0x54,
                               0x4c,
                               0x77,
                               0x32,
                               0x39,
                               0x32,
                               0x4b,
                               0x55,
                               0x38,
                               0x6c,
                               0x4a,
                               0x0a,
                               0x4c,
                               0x6c,
                               0x38,
                               0x58,
                               0x70,
                               0x68,
                               0x4f,
                               0x6b,
                               0x56,
                               0x55,
                               0x72,
                               0x50,
                               0x6b,
                               0x7a,
                               0x47,
                               0x47,
                               0x36,
                               0x64,
                               0x66,
                               0x56,
                               0x4e,
                               0x70,
                               0x36,
                               0x49,
                               0x32,
                               0x68,
                               0x54,
                               0x70,
                               0x59,
                               0x4a,
                               0x49,
                               0x53,
                               0x77,
                               0x41,
                               0x55,
                               0x35,
                               0x48,
                               0x76,
                               0x4b,
                               0x70,
                               0x63,
                               0x39,
                               0x6f,
                               0x42,
                               0x30,
                               0x59,
                               0x4b,
                               0x68,
                               0x56,
                               0x4c,
                               0x66,
                               0x43,
                               0x2b,
                               0x69,
                               0x64,
                               0x61,
                               0x6b,
                               0x56,
                               0x43,
                               0x35,
                               0x66,
                               0x5a,
                               0x7a,
                               0x36,
                               0x0a,
                               0x7a,
                               0x46,
                               0x41,
                               0x6f,
                               0x32,
                               0x37,
                               0x46,
                               0x65,
                               0x6f,
                               0x49,
                               0x45,
                               0x64,
                               0x48,
                               0x74,
                               0x39,
                               0x32,
                               0x5a,
                               0x65,
                               0x36,
                               0x51,
                               0x33,
                               0x34,
                               0x4e,
                               0x4a,
                               0x67,
                               0x70,
                               0x56,
                               0x62,
                               0x67,
                               0x6d,
                               0x54,
                               0x30,
                               0x2b,
                               0x77,
                               0x74,
                               0x75,
                               0x75,
                               0x72,
                               0x71,
                               0x6f,
                               0x5a,
                               0x2f,
                               0x7a,
                               0x52,
                               0x74,
                               0x6b,
                               0x78,
                               0x34,
                               0x35,
                               0x77,
                               0x75,
                               0x71,
                               0x49,
                               0x33,
                               0x45,
                               0x2b,
                               0x54,
                               0x44,
                               0x61,
                               0x31,
                               0x53,
                               0x75,
                               0x71,
                               0x33,
                               0x0a,
                               0x34,
                               0x4f,
                               0x51,
                               0x73,
                               0x65,
                               0x32,
                               0x57,
                               0x63,
                               0x67,
                               0x6a,
                               0x7a,
                               0x53,
                               0x66,
                               0x64,
                               0x4c,
                               0x4a,
                               0x74,
                               0x54,
                               0x66,
                               0x79,
                               0x65,
                               0x4c,
                               0x31,
                               0x70,
                               0x34,
                               0x56,
                               0x68,
                               0x47,
                               0x79,
                               0x63,
                               0x78,
                               0x67,
                               0x2b,
                               0x4a,
                               0x45,
                               0x35,
                               0x48,
                               0x34,
                               0x6a,
                               0x69,
                               0x33,
                               0x7a,
                               0x35,
                               0x33,
                               0x46,
                               0x78,
                               0x72,
                               0x4d,
                               0x6e,
                               0x41,
                               0x30,
                               0x6d,
                               0x53,
                               0x45,
                               0x6c,
                               0x79,
                               0x45,
                               0x6a,
                               0x69,
                               0x38,
                               0x38,
                               0x78,
                               0x54,
                               0x47,
                               0x0a,
                               0x48,
                               0x43,
                               0x59,
                               0x47,
                               0x49,
                               0x6e,
                               0x4a,
                               0x70,
                               0x5a,
                               0x72,
                               0x2b,
                               0x51,
                               0x7a,
                               0x67,
                               0x50,
                               0x54,
                               0x7a,
                               0x57,
                               0x66,
                               0x35,
                               0x52,
                               0x34,
                               0x36,
                               0x6b,
                               0x30,
                               0x38,
                               0x47,
                               0x4b,
                               0x73,
                               0x6d,
                               0x56,
                               0x67,
                               0x6a,
                               0x31,
                               0x50,
                               0x32,
                               0x7a,
                               0x39,
                               0x4f,
                               0x65,
                               0x33,
                               0x61,
                               0x4d,
                               0x43,
                               0x67,
                               0x67,
                               0x45,
                               0x41,
                               0x48,
                               0x42,
                               0x6b,
                               0x64,
                               0x5a,
                               0x75,
                               0x4e,
                               0x58,
                               0x53,
                               0x72,
                               0x77,
                               0x7a,
                               0x37,
                               0x5a,
                               0x41,
                               0x51,
                               0x0a,
                               0x51,
                               0x2f,
                               0x44,
                               0x39,
                               0x73,
                               0x55,
                               0x6e,
                               0x2b,
                               0x2b,
                               0x66,
                               0x50,
                               0x54,
                               0x48,
                               0x6c,
                               0x31,
                               0x4b,
                               0x67,
                               0x5a,
                               0x63,
                               0x67,
                               0x59,
                               0x32,
                               0x47,
                               0x35,
                               0x32,
                               0x6e,
                               0x51,
                               0x32,
                               0x38,
                               0x70,
                               0x41,
                               0x6a,
                               0x52,
                               0x61,
                               0x70,
                               0x37,
                               0x4e,
                               0x4b,
                               0x5a,
                               0x45,
                               0x6f,
                               0x50,
                               0x39,
                               0x39,
                               0x73,
                               0x4c,
                               0x58,
                               0x52,
                               0x74,
                               0x2f,
                               0x4e,
                               0x45,
                               0x74,
                               0x59,
                               0x33,
                               0x64,
                               0x51,
                               0x45,
                               0x34,
                               0x4b,
                               0x73,
                               0x42,
                               0x46,
                               0x2f,
                               0x0a,
                               0x75,
                               0x69,
                               0x76,
                               0x78,
                               0x53,
                               0x38,
                               0x38,
                               0x4c,
                               0x44,
                               0x4f,
                               0x6e,
                               0x4c,
                               0x6f,
                               0x30,
                               0x7a,
                               0x52,
                               0x73,
                               0x6d,
                               0x31,
                               0x30,
                               0x45,
                               0x70,
                               0x56,
                               0x42,
                               0x41,
                               0x33,
                               0x4a,
                               0x64,
                               0x4d,
                               0x50,
                               0x33,
                               0x65,
                               0x2f,
                               0x67,
                               0x57,
                               0x6d,
                               0x57,
                               0x53,
                               0x72,
                               0x56,
                               0x55,
                               0x43,
                               0x6d,
                               0x75,
                               0x74,
                               0x65,
                               0x37,
                               0x6e,
                               0x57,
                               0x63,
                               0x7a,
                               0x75,
                               0x4b,
                               0x30,
                               0x62,
                               0x37,
                               0x41,
                               0x67,
                               0x67,
                               0x6b,
                               0x79,
                               0x6b,
                               0x38,
                               0x72,
                               0x0a,
                               0x79,
                               0x4d,
                               0x53,
                               0x69,
                               0x6f,
                               0x6e,
                               0x79,
                               0x30,
                               0x5a,
                               0x58,
                               0x64,
                               0x38,
                               0x52,
                               0x66,
                               0x55,
                               0x67,
                               0x70,
                               0x6a,
                               0x63,
                               0x74,
                               0x59,
                               0x65,
                               0x76,
                               0x51,
                               0x31,
                               0x68,
                               0x34,
                               0x46,
                               0x69,
                               0x42,
                               0x52,
                               0x7a,
                               0x6d,
                               0x54,
                               0x77,
                               0x58,
                               0x32,
                               0x55,
                               0x73,
                               0x30,
                               0x69,
                               0x64,
                               0x74,
                               0x74,
                               0x66,
                               0x4c,
                               0x67,
                               0x76,
                               0x35,
                               0x46,
                               0x75,
                               0x36,
                               0x33,
                               0x77,
                               0x35,
                               0x36,
                               0x34,
                               0x62,
                               0x57,
                               0x66,
                               0x67,
                               0x57,
                               0x30,
                               0x41,
                               0x0a,
                               0x48,
                               0x36,
                               0x70,
                               0x6a,
                               0x4a,
                               0x55,
                               0x58,
                               0x39,
                               0x77,
                               0x59,
                               0x68,
                               0x57,
                               0x73,
                               0x33,
                               0x4e,
                               0x75,
                               0x50,
                               0x57,
                               0x7a,
                               0x42,
                               0x4f,
                               0x6e,
                               0x30,
                               0x56,
                               0x33,
                               0x54,
                               0x46,
                               0x53,
                               0x7a,
                               0x71,
                               0x39,
                               0x78,
                               0x44,
                               0x2b,
                               0x71,
                               0x78,
                               0x68,
                               0x36,
                               0x75,
                               0x58,
                               0x6f,
                               0x38,
                               0x74,
                               0x4a,
                               0x57,
                               0x4e,
                               0x67,
                               0x59,
                               0x65,
                               0x33,
                               0x77,
                               0x77,
                               0x41,
                               0x30,
                               0x64,
                               0x44,
                               0x69,
                               0x74,
                               0x47,
                               0x6f,
                               0x58,
                               0x7a,
                               0x58,
                               0x4c,
                               0x0a,
                               0x74,
                               0x37,
                               0x39,
                               0x76,
                               0x4e,
                               0x49,
                               0x41,
                               0x30,
                               0x5a,
                               0x2b,
                               0x78,
                               0x63,
                               0x75,
                               0x73,
                               0x4b,
                               0x37,
                               0x58,
                               0x6c,
                               0x41,
                               0x63,
                               0x34,
                               0x6a,
                               0x64,
                               0x4b,
                               0x2f,
                               0x55,
                               0x75,
                               0x74,
                               0x5a,
                               0x4f,
                               0x67,
                               0x45,
                               0x51,
                               0x78,
                               0x57,
                               0x59,
                               0x73,
                               0x63,
                               0x6b,
                               0x37,
                               0x74,
                               0x55,
                               0x47,
                               0x38,
                               0x34,
                               0x78,
                               0x69,
                               0x42,
                               0x37,
                               0x73,
                               0x45,
                               0x6b,
                               0x6f,
                               0x38,
                               0x65,
                               0x75,
                               0x76,
                               0x76,
                               0x44,
                               0x39,
                               0x71,
                               0x32,
                               0x41,
                               0x61,
                               0x0a,
                               0x4e,
                               0x74,
                               0x74,
                               0x48,
                               0x49,
                               0x51,
                               0x4b,
                               0x43,
                               0x41,
                               0x51,
                               0x42,
                               0x44,
                               0x77,
                               0x30,
                               0x5a,
                               0x6e,
                               0x56,
                               0x52,
                               0x2b,
                               0x47,
                               0x55,
                               0x54,
                               0x46,
                               0x61,
                               0x71,
                               0x57,
                               0x71,
                               0x34,
                               0x31,
                               0x4a,
                               0x44,
                               0x48,
                               0x72,
                               0x30,
                               0x38,
                               0x35,
                               0x72,
                               0x6d,
                               0x6b,
                               0x38,
                               0x68,
                               0x71,
                               0x71,
                               0x4a,
                               0x7a,
                               0x76,
                               0x72,
                               0x54,
                               0x5a,
                               0x35,
                               0x36,
                               0x45,
                               0x2b,
                               0x32,
                               0x4f,
                               0x50,
                               0x62,
                               0x78,
                               0x52,
                               0x42,
                               0x34,
                               0x77,
                               0x4f,
                               0x32,
                               0x0a,
                               0x32,
                               0x5a,
                               0x39,
                               0x63,
                               0x32,
                               0x4c,
                               0x45,
                               0x77,
                               0x78,
                               0x2b,
                               0x4e,
                               0x54,
                               0x45,
                               0x66,
                               0x7a,
                               0x52,
                               0x2f,
                               0x7a,
                               0x48,
                               0x46,
                               0x41,
                               0x57,
                               0x61,
                               0x2b,
                               0x49,
                               0x76,
                               0x6f,
                               0x46,
                               0x79,
                               0x75,
                               0x44,
                               0x7a,
                               0x67,
                               0x77,
                               0x69,
                               0x48,
                               0x56,
                               0x66,
                               0x61,
                               0x32,
                               0x48,
                               0x55,
                               0x79,
                               0x55,
                               0x68,
                               0x59,
                               0x6f,
                               0x7a,
                               0x34,
                               0x2b,
                               0x4f,
                               0x38,
                               0x55,
                               0x67,
                               0x69,
                               0x58,
                               0x63,
                               0x64,
                               0x71,
                               0x2b,
                               0x4d,
                               0x72,
                               0x4b,
                               0x33,
                               0x0a,
                               0x73,
                               0x44,
                               0x37,
                               0x30,
                               0x36,
                               0x46,
                               0x5a,
                               0x4b,
                               0x68,
                               0x6c,
                               0x63,
                               0x52,
                               0x55,
                               0x68,
                               0x32,
                               0x51,
                               0x2b,
                               0x54,
                               0x4b,
                               0x32,
                               0x4e,
                               0x67,
                               0x77,
                               0x50,
                               0x56,
                               0x4c,
                               0x2f,
                               0x31,
                               0x36,
                               0x71,
                               0x61,
                               0x48,
                               0x5a,
                               0x5a,
                               0x75,
                               0x32,
                               0x65,
                               0x61,
                               0x33,
                               0x62,
                               0x33,
                               0x6e,
                               0x5a,
                               0x32,
                               0x41,
                               0x41,
                               0x42,
                               0x65,
                               0x52,
                               0x6f,
                               0x51,
                               0x47,
                               0x68,
                               0x42,
                               0x4e,
                               0x65,
                               0x52,
                               0x57,
                               0x34,
                               0x2b,
                               0x4f,
                               0x76,
                               0x34,
                               0x54,
                               0x0a,
                               0x59,
                               0x55,
                               0x31,
                               0x33,
                               0x59,
                               0x51,
                               0x50,
                               0x6a,
                               0x4f,
                               0x74,
                               0x76,
                               0x42,
                               0x70,
                               0x41,
                               0x2b,
                               0x46,
                               0x6d,
                               0x56,
                               0x48,
                               0x72,
                               0x51,
                               0x49,
                               0x5a,
                               0x6c,
                               0x43,
                               0x4f,
                               0x35,
                               0x43,
                               0x4d,
                               0x79,
                               0x36,
                               0x2f,
                               0x47,
                               0x32,
                               0x77,
                               0x56,
                               0x4b,
                               0x48,
                               0x62,
                               0x31,
                               0x4a,
                               0x75,
                               0x4d,
                               0x48,
                               0x63,
                               0x4f,
                               0x44,
                               0x33,
                               0x43,
                               0x4d,
                               0x70,
                               0x43,
                               0x6f,
                               0x6e,
                               0x45,
                               0x44,
                               0x44,
                               0x32,
                               0x36,
                               0x6a,
                               0x76,
                               0x51,
                               0x62,
                               0x49,
                               0x0a,
                               0x43,
                               0x4f,
                               0x46,
                               0x5a,
                               0x37,
                               0x4c,
                               0x43,
                               0x46,
                               0x73,
                               0x52,
                               0x71,
                               0x38,
                               0x43,
                               0x4a,
                               0x35,
                               0x4c,
                               0x45,
                               0x7a,
                               0x33,
                               0x69,
                               0x62,
                               0x4c,
                               0x50,
                               0x76,
                               0x4b,
                               0x50,
                               0x78,
                               0x51,
                               0x67,
                               0x6c,
                               0x41,
                               0x4f,
                               0x75,
                               0x37,
                               0x62,
                               0x44,
                               0x44,
                               0x74,
                               0x62,
                               0x79,
                               0x4c,
                               0x6d,
                               0x58,
                               0x49,
                               0x4a,
                               0x7a,
                               0x76,
                               0x51,
                               0x33,
                               0x65,
                               0x31,
                               0x30,
                               0x49,
                               0x31,
                               0x45,
                               0x77,
                               0x39,
                               0x53,
                               0x61,
                               0x56,
                               0x76,
                               0x59,
                               0x39,
                               0x65,
                               0x0a,
                               0x31,
                               0x62,
                               0x65,
                               0x79,
                               0x62,
                               0x37,
                               0x71,
                               0x4f,
                               0x31,
                               0x36,
                               0x44,
                               0x62,
                               0x73,
                               0x54,
                               0x75,
                               0x6c,
                               0x45,
                               0x43,
                               0x51,
                               0x4e,
                               0x2f,
                               0x2b,
                               0x79,
                               0x4e,
                               0x77,
                               0x74,
                               0x6b,
                               0x44,
                               0x34,
                               0x58,
                               0x69,
                               0x37,
                               0x41,
                               0x6f,
                               0x49,
                               0x42,
                               0x41,
                               0x41,
                               0x63,
                               0x73,
                               0x6f,
                               0x4f,
                               0x7a,
                               0x75,
                               0x50,
                               0x6d,
                               0x37,
                               0x35,
                               0x4a,
                               0x4f,
                               0x32,
                               0x42,
                               0x33,
                               0x76,
                               0x32,
                               0x45,
                               0x64,
                               0x2b,
                               0x37,
                               0x47,
                               0x4b,
                               0x31,
                               0x53,
                               0x63,
                               0x0a,
                               0x6c,
                               0x76,
                               0x56,
                               0x4e,
                               0x55,
                               0x33,
                               0x43,
                               0x7a,
                               0x30,
                               0x4e,
                               0x66,
                               0x4c,
                               0x50,
                               0x4a,
                               0x56,
                               0x79,
                               0x73,
                               0x56,
                               0x53,
                               0x48,
                               0x65,
                               0x67,
                               0x61,
                               0x53,
                               0x5a,
                               0x38,
                               0x33,
                               0x5a,
                               0x6f,
                               0x4e,
                               0x50,
                               0x68,
                               0x6d,
                               0x54,
                               0x42,
                               0x47,
                               0x62,
                               0x72,
                               0x56,
                               0x45,
                               0x72,
                               0x31,
                               0x62,
                               0x33,
                               0x42,
                               0x55,
                               0x59,
                               0x30,
                               0x6c,
                               0x6b,
                               0x46,
                               0x49,
                               0x4f,
                               0x6f,
                               0x33,
                               0x6d,
                               0x66,
                               0x30,
                               0x32,
                               0x6c,
                               0x37,
                               0x57,
                               0x48,
                               0x59,
                               0x0a,
                               0x78,
                               0x4d,
                               0x51,
                               0x38,
                               0x48,
                               0x63,
                               0x32,
                               0x61,
                               0x6e,
                               0x55,
                               0x38,
                               0x71,
                               0x64,
                               0x4f,
                               0x58,
                               0x76,
                               0x6f,
                               0x58,
                               0x62,
                               0x51,
                               0x34,
                               0x2f,
                               0x59,
                               0x59,
                               0x4b,
                               0x31,
                               0x57,
                               0x42,
                               0x76,
                               0x4b,
                               0x75,
                               0x2f,
                               0x43,
                               0x6c,
                               0x42,
                               0x53,
                               0x45,
                               0x63,
                               0x61,
                               0x4f,
                               0x39,
                               0x30,
                               0x62,
                               0x71,
                               0x79,
                               0x44,
                               0x73,
                               0x37,
                               0x33,
                               0x6d,
                               0x69,
                               0x46,
                               0x57,
                               0x2f,
                               0x43,
                               0x31,
                               0x54,
                               0x66,
                               0x78,
                               0x50,
                               0x58,
                               0x6e,
                               0x6b,
                               0x53,
                               0x0a,
                               0x54,
                               0x2b,
                               0x72,
                               0x4f,
                               0x4d,
                               0x6d,
                               0x77,
                               0x52,
                               0x51,
                               0x67,
                               0x4c,
                               0x46,
                               0x50,
                               0x6c,
                               0x35,
                               0x46,
                               0x41,
                               0x62,
                               0x48,
                               0x4f,
                               0x6b,
                               0x31,
                               0x41,
                               0x58,
                               0x5a,
                               0x45,
                               0x34,
                               0x46,
                               0x46,
                               0x47,
                               0x50,
                               0x75,
                               0x55,
                               0x62,
                               0x52,
                               0x74,
                               0x6b,
                               0x4f,
                               0x45,
                               0x72,
                               0x64,
                               0x77,
                               0x34,
                               0x74,
                               0x5a,
                               0x68,
                               0x53,
                               0x77,
                               0x66,
                               0x58,
                               0x74,
                               0x2f,
                               0x46,
                               0x41,
                               0x36,
                               0x2b,
                               0x32,
                               0x4c,
                               0x6e,
                               0x48,
                               0x79,
                               0x37,
                               0x38,
                               0x38,
                               0x0a,
                               0x58,
                               0x4f,
                               0x46,
                               0x62,
                               0x71,
                               0x30,
                               0x46,
                               0x4b,
                               0x6e,
                               0x63,
                               0x6e,
                               0x68,
                               0x32,
                               0x6a,
                               0x61,
                               0x2b,
                               0x64,
                               0x37,
                               0x65,
                               0x4e,
                               0x6c,
                               0x48,
                               0x77,
                               0x4c,
                               0x4b,
                               0x63,
                               0x53,
                               0x43,
                               0x34,
                               0x43,
                               0x46,
                               0x4e,
                               0x46,
                               0x4b,
                               0x51,
                               0x6d,
                               0x6c,
                               0x45,
                               0x68,
                               0x5a,
                               0x5a,
                               0x4a,
                               0x48,
                               0x63,
                               0x65,
                               0x6e,
                               0x2f,
                               0x42,
                               0x30,
                               0x6d,
                               0x7a,
                               0x72,
                               0x48,
                               0x6c,
                               0x35,
                               0x76,
                               0x53,
                               0x6c,
                               0x59,
                               0x79,
                               0x37,
                               0x50,
                               0x37,
                               0x73,
                               0x0a,
                               0x63,
                               0x32,
                               0x52,
                               0x34,
                               0x33,
                               0x54,
                               0x6c,
                               0x45,
                               0x41,
                               0x4d,
                               0x77,
                               0x72,
                               0x32,
                               0x4a,
                               0x30,
                               0x4c,
                               0x37,
                               0x58,
                               0x65,
                               0x34,
                               0x2b,
                               0x33,
                               0x45,
                               0x36,
                               0x31,
                               0x4f,
                               0x64,
                               0x43,
                               0x4f,
                               0x30,
                               0x46,
                               0x37,
                               0x4e,
                               0x46,
                               0x30,
                               0x76,
                               0x33,
                               0x66,
                               0x2f,
                               0x34,
                               0x5a,
                               0x6f,
                               0x4a,
                               0x49,
                               0x6d,
                               0x4c,
                               0x74,
                               0x4e,
                               0x7a,
                               0x4d,
                               0x4f,
                               0x31,
                               0x68,
                               0x69,
                               0x61,
                               0x51,
                               0x34,
                               0x69,
                               0x67,
                               0x3d,
                               0x0a,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x45,
                               0x4e,
                               0x44,
                               0x20,
                               0x52,
                               0x53,
                               0x41,
                               0x20,
                               0x50,
                               0x52,
                               0x49,
                               0x56,
                               0x41,
                               0x54,
                               0x45,
                               0x20,
                               0x4b,
                               0x45,
                               0x59,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x2d,
                               0x0a
#ifdef CONFIG_MBEDTLS
                               ,
                               0x00
#endif
};

unsigned char server_cert[] = { 0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x42,
                                0x45,
                                0x47,
                                0x49,
                                0x4e,
                                0x20,
                                0x43,
                                0x45,
                                0x52,
                                0x54,
                                0x49,
                                0x46,
                                0x49,
                                0x43,
                                0x41,
                                0x54,
                                0x45,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x0a,
                                0x4d,
                                0x49,
                                0x49,
                                0x45,
                                0x47,
                                0x7a,
                                0x43,
                                0x43,
                                0x41,
                                0x77,
                                0x4f,
                                0x67,
                                0x41,
                                0x77,
                                0x49,
                                0x42,
                                0x41,
                                0x67,
                                0x49,
                                0x44,
                                0x45,
                                0x41,
                                0x41,
                                0x44,
                                0x4d,
                                0x41,
                                0x30,
                                0x47,
                                0x43,
                                0x53,
                                0x71,
                                0x47,
                                0x53,
                                0x49,
                                0x62,
                                0x33,
                                0x44,
                                0x51,
                                0x45,
                                0x42,
                                0x43,
                                0x77,
                                0x55,
                                0x41,
                                0x4d,
                                0x45,
                                0x38,
                                0x78,
                                0x47,
                                0x7a,
                                0x41,
                                0x5a,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x6f,
                                0x54,
                                0x45,
                                0x6d,
                                0x78,
                                0x70,
                                0x0a,
                                0x59,
                                0x6e,
                                0x64,
                                0x6c,
                                0x59,
                                0x6e,
                                0x4e,
                                0x76,
                                0x59,
                                0x32,
                                0x74,
                                0x6c,
                                0x64,
                                0x48,
                                0x4d,
                                0x74,
                                0x64,
                                0x47,
                                0x56,
                                0x7a,
                                0x64,
                                0x44,
                                0x45,
                                0x53,
                                0x4d,
                                0x42,
                                0x41,
                                0x47,
                                0x41,
                                0x31,
                                0x55,
                                0x45,
                                0x42,
                                0x78,
                                0x4d,
                                0x4a,
                                0x57,
                                0x47,
                                0x6c,
                                0x68,
                                0x62,
                                0x32,
                                0x4a,
                                0x70,
                                0x64,
                                0x47,
                                0x46,
                                0x75,
                                0x4d,
                                0x51,
                                0x38,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x49,
                                0x45,
                                0x77,
                                0x5a,
                                0x55,
                                0x0a,
                                0x59,
                                0x57,
                                0x6c,
                                0x77,
                                0x5a,
                                0x57,
                                0x6b,
                                0x78,
                                0x43,
                                0x7a,
                                0x41,
                                0x4a,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x59,
                                0x54,
                                0x41,
                                0x6c,
                                0x52,
                                0x58,
                                0x4d,
                                0x43,
                                0x41,
                                0x58,
                                0x44,
                                0x54,
                                0x49,
                                0x79,
                                0x4d,
                                0x44,
                                0x63,
                                0x77,
                                0x4e,
                                0x6a,
                                0x45,
                                0x78,
                                0x4d,
                                0x6a,
                                0x55,
                                0x77,
                                0x4d,
                                0x31,
                                0x6f,
                                0x59,
                                0x44,
                                0x7a,
                                0x49,
                                0x77,
                                0x4e,
                                0x54,
                                0x41,
                                0x77,
                                0x4e,
                                0x7a,
                                0x45,
                                0x35,
                                0x4d,
                                0x54,
                                0x45,
                                0x79,
                                0x0a,
                                0x4e,
                                0x54,
                                0x41,
                                0x7a,
                                0x57,
                                0x6a,
                                0x42,
                                0x50,
                                0x4d,
                                0x51,
                                0x73,
                                0x77,
                                0x43,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x47,
                                0x45,
                                0x77,
                                0x4a,
                                0x55,
                                0x56,
                                0x7a,
                                0x45,
                                0x50,
                                0x4d,
                                0x41,
                                0x30,
                                0x47,
                                0x41,
                                0x31,
                                0x55,
                                0x45,
                                0x43,
                                0x42,
                                0x4d,
                                0x47,
                                0x56,
                                0x47,
                                0x46,
                                0x70,
                                0x63,
                                0x47,
                                0x56,
                                0x70,
                                0x4d,
                                0x52,
                                0x73,
                                0x77,
                                0x47,
                                0x51,
                                0x59,
                                0x44,
                                0x56,
                                0x51,
                                0x51,
                                0x4b,
                                0x45,
                                0x78,
                                0x4a,
                                0x73,
                                0x0a,
                                0x61,
                                0x57,
                                0x4a,
                                0x33,
                                0x5a,
                                0x57,
                                0x4a,
                                0x7a,
                                0x62,
                                0x32,
                                0x4e,
                                0x72,
                                0x5a,
                                0x58,
                                0x52,
                                0x7a,
                                0x4c,
                                0x58,
                                0x52,
                                0x6c,
                                0x63,
                                0x33,
                                0x51,
                                0x78,
                                0x45,
                                0x6a,
                                0x41,
                                0x51,
                                0x42,
                                0x67,
                                0x4e,
                                0x56,
                                0x42,
                                0x41,
                                0x4d,
                                0x54,
                                0x43,
                                0x57,
                                0x78,
                                0x76,
                                0x59,
                                0x32,
                                0x46,
                                0x73,
                                0x61,
                                0x47,
                                0x39,
                                0x7a,
                                0x64,
                                0x44,
                                0x43,
                                0x43,
                                0x41,
                                0x69,
                                0x49,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x4a,
                                0x4b,
                                0x6f,
                                0x5a,
                                0x49,
                                0x0a,
                                0x68,
                                0x76,
                                0x63,
                                0x4e,
                                0x41,
                                0x51,
                                0x45,
                                0x42,
                                0x42,
                                0x51,
                                0x41,
                                0x44,
                                0x67,
                                0x67,
                                0x49,
                                0x50,
                                0x41,
                                0x44,
                                0x43,
                                0x43,
                                0x41,
                                0x67,
                                0x6f,
                                0x43,
                                0x67,
                                0x67,
                                0x49,
                                0x42,
                                0x41,
                                0x4d,
                                0x74,
                                0x58,
                                0x71,
                                0x68,
                                0x69,
                                0x59,
                                0x68,
                                0x47,
                                0x6a,
                                0x56,
                                0x4c,
                                0x77,
                                0x56,
                                0x75,
                                0x61,
                                0x79,
                                0x76,
                                0x4d,
                                0x4d,
                                0x49,
                                0x72,
                                0x6a,
                                0x4b,
                                0x37,
                                0x53,
                                0x34,
                                0x4c,
                                0x62,
                                0x52,
                                0x48,
                                0x6c,
                                0x4e,
                                0x55,
                                0x44,
                                0x0a,
                                0x74,
                                0x4a,
                                0x7a,
                                0x46,
                                0x6f,
                                0x32,
                                0x41,
                                0x6a,
                                0x75,
                                0x4c,
                                0x75,
                                0x6d,
                                0x74,
                                0x65,
                                0x46,
                                0x2b,
                                0x4b,
                                0x4c,
                                0x73,
                                0x34,
                                0x56,
                                0x6a,
                                0x59,
                                0x7a,
                                0x78,
                                0x75,
                                0x64,
                                0x61,
                                0x43,
                                0x51,
                                0x72,
                                0x79,
                                0x76,
                                0x4d,
                                0x61,
                                0x6c,
                                0x30,
                                0x64,
                                0x2f,
                                0x38,
                                0x32,
                                0x38,
                                0x75,
                                0x6e,
                                0x33,
                                0x78,
                                0x34,
                                0x67,
                                0x57,
                                0x6a,
                                0x59,
                                0x54,
                                0x4f,
                                0x43,
                                0x35,
                                0x35,
                                0x63,
                                0x51,
                                0x39,
                                0x4d,
                                0x44,
                                0x4e,
                                0x64,
                                0x2b,
                                0x0a,
                                0x70,
                                0x6d,
                                0x4d,
                                0x45,
                                0x45,
                                0x34,
                                0x2b,
                                0x64,
                                0x31,
                                0x75,
                                0x6e,
                                0x54,
                                0x66,
                                0x6f,
                                0x39,
                                0x38,
                                0x38,
                                0x32,
                                0x6a,
                                0x4d,
                                0x38,
                                0x65,
                                0x6a,
                                0x6c,
                                0x4e,
                                0x46,
                                0x54,
                                0x63,
                                0x44,
                                0x6f,
                                0x54,
                                0x50,
                                0x68,
                                0x6f,
                                0x4e,
                                0x37,
                                0x77,
                                0x71,
                                0x66,
                                0x78,
                                0x4f,
                                0x31,
                                0x35,
                                0x46,
                                0x6e,
                                0x69,
                                0x54,
                                0x77,
                                0x54,
                                0x43,
                                0x57,
                                0x39,
                                0x30,
                                0x62,
                                0x6d,
                                0x7a,
                                0x37,
                                0x32,
                                0x74,
                                0x36,
                                0x7a,
                                0x4c,
                                0x4f,
                                0x6d,
                                0x0a,
                                0x33,
                                0x43,
                                0x70,
                                0x5a,
                                0x75,
                                0x75,
                                0x64,
                                0x48,
                                0x53,
                                0x6e,
                                0x58,
                                0x48,
                                0x71,
                                0x74,
                                0x67,
                                0x4f,
                                0x7a,
                                0x36,
                                0x6e,
                                0x53,
                                0x53,
                                0x62,
                                0x54,
                                0x6a,
                                0x4f,
                                0x31,
                                0x51,
                                0x52,
                                0x33,
                                0x4c,
                                0x4e,
                                0x2b,
                                0x44,
                                0x76,
                                0x4e,
                                0x30,
                                0x34,
                                0x62,
                                0x4d,
                                0x58,
                                0x42,
                                0x66,
                                0x65,
                                0x2f,
                                0x30,
                                0x4e,
                                0x56,
                                0x45,
                                0x2f,
                                0x51,
                                0x70,
                                0x65,
                                0x4f,
                                0x4f,
                                0x47,
                                0x50,
                                0x5a,
                                0x53,
                                0x47,
                                0x43,
                                0x4f,
                                0x74,
                                0x4b,
                                0x76,
                                0x0a,
                                0x44,
                                0x5a,
                                0x34,
                                0x4f,
                                0x75,
                                0x79,
                                0x4b,
                                0x68,
                                0x6d,
                                0x32,
                                0x52,
                                0x6f,
                                0x72,
                                0x47,
                                0x4a,
                                0x6e,
                                0x4c,
                                0x6d,
                                0x58,
                                0x78,
                                0x44,
                                0x46,
                                0x48,
                                0x6d,
                                0x42,
                                0x4d,
                                0x70,
                                0x30,
                                0x30,
                                0x64,
                                0x41,
                                0x63,
                                0x65,
                                0x72,
                                0x42,
                                0x45,
                                0x52,
                                0x4c,
                                0x44,
                                0x6b,
                                0x4c,
                                0x52,
                                0x70,
                                0x64,
                                0x57,
                                0x34,
                                0x38,
                                0x4b,
                                0x32,
                                0x69,
                                0x35,
                                0x74,
                                0x42,
                                0x51,
                                0x76,
                                0x41,
                                0x63,
                                0x4a,
                                0x5a,
                                0x7a,
                                0x6c,
                                0x4c,
                                0x38,
                                0x51,
                                0x0a,
                                0x2b,
                                0x48,
                                0x32,
                                0x66,
                                0x67,
                                0x75,
                                0x53,
                                0x62,
                                0x42,
                                0x32,
                                0x32,
                                0x65,
                                0x55,
                                0x79,
                                0x74,
                                0x42,
                                0x62,
                                0x62,
                                0x4e,
                                0x6e,
                                0x67,
                                0x76,
                                0x36,
                                0x68,
                                0x79,
                                0x52,
                                0x79,
                                0x30,
                                0x62,
                                0x41,
                                0x49,
                                0x7a,
                                0x61,
                                0x59,
                                0x48,
                                0x77,
                                0x61,
                                0x70,
                                0x52,
                                0x49,
                                0x78,
                                0x72,
                                0x4c,
                                0x54,
                                0x57,
                                0x6e,
                                0x64,
                                0x4d,
                                0x69,
                                0x42,
                                0x37,
                                0x79,
                                0x4f,
                                0x76,
                                0x64,
                                0x69,
                                0x73,
                                0x6c,
                                0x55,
                                0x2b,
                                0x31,
                                0x53,
                                0x6f,
                                0x46,
                                0x0a,
                                0x57,
                                0x41,
                                0x62,
                                0x66,
                                0x56,
                                0x35,
                                0x79,
                                0x75,
                                0x68,
                                0x77,
                                0x4f,
                                0x6e,
                                0x77,
                                0x54,
                                0x4d,
                                0x53,
                                0x6f,
                                0x64,
                                0x52,
                                0x30,
                                0x39,
                                0x4f,
                                0x78,
                                0x67,
                                0x55,
                                0x61,
                                0x75,
                                0x41,
                                0x32,
                                0x79,
                                0x72,
                                0x41,
                                0x4c,
                                0x32,
                                0x51,
                                0x37,
                                0x42,
                                0x4d,
                                0x35,
                                0x47,
                                0x6e,
                                0x59,
                                0x4c,
                                0x70,
                                0x55,
                                0x6f,
                                0x35,
                                0x71,
                                0x35,
                                0x46,
                                0x67,
                                0x41,
                                0x77,
                                0x6b,
                                0x73,
                                0x4a,
                                0x6c,
                                0x38,
                                0x77,
                                0x79,
                                0x53,
                                0x44,
                                0x70,
                                0x59,
                                0x0a,
                                0x63,
                                0x51,
                                0x72,
                                0x37,
                                0x46,
                                0x72,
                                0x7a,
                                0x53,
                                0x6a,
                                0x71,
                                0x63,
                                0x31,
                                0x6f,
                                0x39,
                                0x55,
                                0x73,
                                0x37,
                                0x68,
                                0x45,
                                0x45,
                                0x6c,
                                0x6b,
                                0x76,
                                0x4e,
                                0x42,
                                0x5a,
                                0x6b,
                                0x31,
                                0x2b,
                                0x56,
                                0x50,
                                0x54,
                                0x61,
                                0x50,
                                0x35,
                                0x78,
                                0x45,
                                0x59,
                                0x79,
                                0x70,
                                0x63,
                                0x62,
                                0x67,
                                0x2b,
                                0x75,
                                0x2b,
                                0x59,
                                0x43,
                                0x7a,
                                0x63,
                                0x74,
                                0x4a,
                                0x57,
                                0x6e,
                                0x4a,
                                0x4b,
                                0x62,
                                0x43,
                                0x42,
                                0x7a,
                                0x32,
                                0x65,
                                0x73,
                                0x36,
                                0x0a,
                                0x4b,
                                0x6b,
                                0x70,
                                0x66,
                                0x43,
                                0x34,
                                0x61,
                                0x57,
                                0x63,
                                0x38,
                                0x55,
                                0x49,
                                0x4c,
                                0x6c,
                                0x55,
                                0x4b,
                                0x2f,
                                0x57,
                                0x34,
                                0x6a,
                                0x52,
                                0x46,
                                0x73,
                                0x4e,
                                0x47,
                                0x33,
                                0x55,
                                0x68,
                                0x41,
                                0x31,
                                0x76,
                                0x6e,
                                0x49,
                                0x5a,
                                0x77,
                                0x4b,
                                0x38,
                                0x36,
                                0x69,
                                0x71,
                                0x6d,
                                0x33,
                                0x6b,
                                0x2b,
                                0x50,
                                0x45,
                                0x62,
                                0x61,
                                0x68,
                                0x63,
                                0x45,
                                0x78,
                                0x41,
                                0x34,
                                0x71,
                                0x42,
                                0x2f,
                                0x4c,
                                0x42,
                                0x68,
                                0x6f,
                                0x67,
                                0x76,
                                0x73,
                                0x0a,
                                0x34,
                                0x7a,
                                0x39,
                                0x62,
                                0x32,
                                0x4d,
                                0x51,
                                0x33,
                                0x35,
                                0x74,
                                0x69,
                                0x49,
                                0x6f,
                                0x51,
                                0x44,
                                0x6a,
                                0x37,
                                0x52,
                                0x35,
                                0x78,
                                0x4e,
                                0x38,
                                0x63,
                                0x35,
                                0x41,
                                0x79,
                                0x77,
                                0x44,
                                0x79,
                                0x62,
                                0x38,
                                0x78,
                                0x47,
                                0x76,
                                0x32,
                                0x59,
                                0x6d,
                                0x6b,
                                0x34,
                                0x6a,
                                0x47,
                                0x74,
                                0x44,
                                0x6b,
                                0x64,
                                0x71,
                                0x72,
                                0x62,
                                0x74,
                                0x49,
                                0x55,
                                0x34,
                                0x32,
                                0x2b,
                                0x48,
                                0x4d,
                                0x31,
                                0x79,
                                0x4f,
                                0x6b,
                                0x38,
                                0x75,
                                0x38,
                                0x5a,
                                0x0a,
                                0x45,
                                0x69,
                                0x78,
                                0x4c,
                                0x51,
                                0x7a,
                                0x6f,
                                0x77,
                                0x6d,
                                0x71,
                                0x55,
                                0x71,
                                0x72,
                                0x65,
                                0x42,
                                0x43,
                                0x68,
                                0x6f,
                                0x41,
                                0x6f,
                                0x73,
                                0x63,
                                0x33,
                                0x46,
                                0x4f,
                                0x52,
                                0x4f,
                                0x6d,
                                0x54,
                                0x43,
                                0x44,
                                0x6c,
                                0x59,
                                0x36,
                                0x33,
                                0x34,
                                0x2f,
                                0x61,
                                0x63,
                                0x49,
                                0x49,
                                0x50,
                                0x33,
                                0x31,
                                0x64,
                                0x65,
                                0x64,
                                0x48,
                                0x4e,
                                0x59,
                                0x5a,
                                0x35,
                                0x31,
                                0x52,
                                0x72,
                                0x75,
                                0x6b,
                                0x41,
                                0x64,
                                0x41,
                                0x36,
                                0x32,
                                0x44,
                                0x62,
                                0x0a,
                                0x47,
                                0x44,
                                0x77,
                                0x67,
                                0x77,
                                0x7a,
                                0x36,
                                0x54,
                                0x41,
                                0x67,
                                0x4d,
                                0x42,
                                0x41,
                                0x41,
                                0x45,
                                0x77,
                                0x44,
                                0x51,
                                0x59,
                                0x4a,
                                0x4b,
                                0x6f,
                                0x5a,
                                0x49,
                                0x68,
                                0x76,
                                0x63,
                                0x4e,
                                0x41,
                                0x51,
                                0x45,
                                0x4c,
                                0x42,
                                0x51,
                                0x41,
                                0x44,
                                0x67,
                                0x67,
                                0x45,
                                0x42,
                                0x41,
                                0x4b,
                                0x56,
                                0x76,
                                0x2f,
                                0x53,
                                0x43,
                                0x50,
                                0x4f,
                                0x67,
                                0x77,
                                0x50,
                                0x41,
                                0x59,
                                0x30,
                                0x47,
                                0x34,
                                0x37,
                                0x79,
                                0x63,
                                0x76,
                                0x55,
                                0x48,
                                0x67,
                                0x0a,
                                0x6b,
                                0x33,
                                0x44,
                                0x51,
                                0x67,
                                0x6d,
                                0x62,
                                0x78,
                                0x56,
                                0x54,
                                0x46,
                                0x46,
                                0x57,
                                0x51,
                                0x79,
                                0x72,
                                0x50,
                                0x36,
                                0x58,
                                0x76,
                                0x4b,
                                0x48,
                                0x4f,
                                0x6c,
                                0x33,
                                0x65,
                                0x5a,
                                0x55,
                                0x32,
                                0x52,
                                0x65,
                                0x4a,
                                0x78,
                                0x65,
                                0x54,
                                0x78,
                                0x43,
                                0x4d,
                                0x55,
                                0x4b,
                                0x63,
                                0x4e,
                                0x6c,
                                0x57,
                                0x34,
                                0x2b,
                                0x65,
                                0x4d,
                                0x32,
                                0x6f,
                                0x43,
                                0x5a,
                                0x37,
                                0x57,
                                0x31,
                                0x76,
                                0x69,
                                0x74,
                                0x61,
                                0x75,
                                0x70,
                                0x6e,
                                0x4f,
                                0x30,
                                0x0a,
                                0x7a,
                                0x4c,
                                0x57,
                                0x36,
                                0x47,
                                0x42,
                                0x46,
                                0x53,
                                0x56,
                                0x58,
                                0x55,
                                0x34,
                                0x54,
                                0x2b,
                                0x59,
                                0x5a,
                                0x63,
                                0x69,
                                0x49,
                                0x48,
                                0x6e,
                                0x78,
                                0x6b,
                                0x71,
                                0x6c,
                                0x48,
                                0x33,
                                0x58,
                                0x78,
                                0x63,
                                0x6b,
                                0x67,
                                0x7a,
                                0x4e,
                                0x56,
                                0x4c,
                                0x79,
                                0x57,
                                0x44,
                                0x41,
                                0x41,
                                0x4a,
                                0x6f,
                                0x61,
                                0x77,
                                0x32,
                                0x63,
                                0x2b,
                                0x58,
                                0x31,
                                0x45,
                                0x39,
                                0x42,
                                0x7a,
                                0x59,
                                0x62,
                                0x49,
                                0x54,
                                0x2b,
                                0x7a,
                                0x4d,
                                0x59,
                                0x6a,
                                0x5a,
                                0x0a,
                                0x31,
                                0x62,
                                0x59,
                                0x41,
                                0x61,
                                0x76,
                                0x79,
                                0x51,
                                0x4f,
                                0x6f,
                                0x4d,
                                0x50,
                                0x64,
                                0x2f,
                                0x31,
                                0x7a,
                                0x30,
                                0x64,
                                0x59,
                                0x6d,
                                0x49,
                                0x39,
                                0x46,
                                0x72,
                                0x77,
                                0x78,
                                0x5a,
                                0x32,
                                0x4f,
                                0x42,
                                0x6e,
                                0x76,
                                0x2b,
                                0x63,
                                0x58,
                                0x41,
                                0x72,
                                0x69,
                                0x30,
                                0x2f,
                                0x4a,
                                0x4d,
                                0x47,
                                0x54,
                                0x63,
                                0x7a,
                                0x58,
                                0x36,
                                0x66,
                                0x56,
                                0x67,
                                0x53,
                                0x45,
                                0x50,
                                0x47,
                                0x66,
                                0x48,
                                0x48,
                                0x63,
                                0x6f,
                                0x36,
                                0x53,
                                0x4b,
                                0x4a,
                                0x0a,
                                0x52,
                                0x5a,
                                0x57,
                                0x38,
                                0x56,
                                0x49,
                                0x39,
                                0x67,
                                0x49,
                                0x4f,
                                0x52,
                                0x75,
                                0x57,
                                0x68,
                                0x79,
                                0x39,
                                0x76,
                                0x78,
                                0x55,
                                0x57,
                                0x41,
                                0x43,
                                0x4a,
                                0x6f,
                                0x30,
                                0x4f,
                                0x6b,
                                0x4a,
                                0x44,
                                0x75,
                                0x55,
                                0x37,
                                0x2b,
                                0x57,
                                0x54,
                                0x61,
                                0x39,
                                0x65,
                                0x44,
                                0x66,
                                0x6a,
                                0x46,
                                0x2b,
                                0x62,
                                0x62,
                                0x68,
                                0x2b,
                                0x2f,
                                0x49,
                                0x73,
                                0x38,
                                0x36,
                                0x66,
                                0x72,
                                0x4c,
                                0x32,
                                0x67,
                                0x76,
                                0x38,
                                0x79,
                                0x39,
                                0x69,
                                0x4d,
                                0x55,
                                0x0a,
                                0x74,
                                0x32,
                                0x36,
                                0x37,
                                0x75,
                                0x58,
                                0x39,
                                0x52,
                                0x52,
                                0x64,
                                0x30,
                                0x46,
                                0x70,
                                0x69,
                                0x4b,
                                0x70,
                                0x2b,
                                0x70,
                                0x4b,
                                0x4d,
                                0x48,
                                0x6d,
                                0x50,
                                0x77,
                                0x47,
                                0x33,
                                0x70,
                                0x75,
                                0x6b,
                                0x78,
                                0x57,
                                0x64,
                                0x38,
                                0x76,
                                0x6b,
                                0x4f,
                                0x72,
                                0x67,
                                0x6a,
                                0x4a,
                                0x44,
                                0x46,
                                0x2b,
                                0x54,
                                0x56,
                                0x48,
                                0x67,
                                0x67,
                                0x4c,
                                0x31,
                                0x4a,
                                0x59,
                                0x58,
                                0x5a,
                                0x37,
                                0x45,
                                0x4a,
                                0x39,
                                0x79,
                                0x6a,
                                0x50,
                                0x64,
                                0x77,
                                0x3d,
                                0x0a,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x45,
                                0x4e,
                                0x44,
                                0x20,
                                0x43,
                                0x45,
                                0x52,
                                0x54,
                                0x49,
                                0x46,
                                0x49,
                                0x43,
                                0x41,
                                0x54,
                                0x45,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x2d,
                                0x0a
#ifdef CONFIG_MBEDTLS
                                ,
                                0x00
#endif
};

#ifndef BSC_NETWORK_IFACE
#define BSC_NETWORK_IFACE "127.0.0.1"
#endif

#define BACNET_WEBSOCKET_SERVER_PORT 39000
#define BACNET_WEBSOCKET_SERVER_PORT2 39001
#ifdef ZEPHYR_TEST
#define BACNET_WEBSOCKET_SERVER_ADDR CONFIG_NET_CONFIG_MY_IPV4_ADDR
#else
#define BACNET_WEBSOCKET_SERVER_ADDR "127.0.0.1"
#endif
#define BACNET_TIMEOUT 3
#define MAX_BVLC_LEN 1500
#define MAX_NDPU_LEN 1500
#define MAX_SERVER_SOCKETS BSC_CONF_SERVER_DIRECT_CONNECTIONS_MAX_NUM
#define MAX_CLIENT_SOCKETS BSC_CONF_CLIENT_CONNECTIONS_NUM
#define WAIT_EVENT_MS 500

// MbedTLS expects a key in DER format
#ifdef CONFIG_MBEDTLS
#define CLIENT_KEY client_key_der
#else
#define CLIENT_KEY client_key
#endif

typedef struct {
    BSC_HUB_CONNECTOR_EVENT ev;
    BSC_HUB_CONNECTOR_HANDLE h;
    void *user_arg;
    uint8_t pdu[MAX_BVLC_LEN];
    size_t pdu_len;
    BSC_EVENT *e;
} hubc_ev_t;

typedef struct {
    BSC_HUB_FUNCTION_EVENT ev;
    BSC_HUB_FUNCTION_HANDLE h;
    void *user_arg;
    BSC_EVENT *e;
} hubf_ev_t;

static void call_maintenance_timer(bool reset, int time_passed_ms)
{
    static int total_ms;
    if (reset) {
        total_ms = 0;
    }

    total_ms += time_passed_ms;

    if (total_ms >= 1000) {
        bsc_hub_connector_maintenance_timer(1);
        bsc_socket_maintenance_timer(1);
        total_ms = 0;
    }
}

static void wait_sec(int seconds)
{
    while (seconds >= 0) {
        bsc_wait(1);
        bsc_hub_connector_maintenance_timer(1);
        bsc_socket_maintenance_timer(1);
        seconds--;
    }
}

static hubc_ev_t hubc;
static hubf_ev_t hubf;

static void init_hubc_ev(hubc_ev_t *ev)
{
    memset(ev, 0, sizeof(*ev));
    ev->e = bsc_event_init();
    zassert_not_equal(ev->e, NULL, 0);
    ev->ev = -1;
}

static void deinit_hubc_ev(hubc_ev_t *ev)
{
    bsc_event_deinit(ev->e);
}

static bool wait_hubc_ev(
    hubc_ev_t *ev,
    BSC_HUB_CONNECTOR_EVENT wait_ev,
    BSC_HUB_CONNECTOR_HANDLE wait_h)
{
    call_maintenance_timer(1, 0);
    while (!bsc_event_timedwait(ev->e, WAIT_EVENT_MS)) {
        call_maintenance_timer(0, WAIT_EVENT_MS);
    }
    bws_dispatch_lock();
    if (ev->ev == wait_ev && ev->h == wait_h) {
        ev->ev = -1;
        // reset event if it was signalled while we were blocked in call
        // bws_dispatch_lock().
        // (in that case ev->ev contains code of last event.)
        // that's tricky but that allows to avoid using mutexes which are
        // platform specific in test code
        bsc_event_timedwait(ev->e, 1);
        bws_dispatch_unlock();
        return true;
    } else {
        bws_dispatch_unlock();
        return false;
    }
}

static void signal_hubc_ev(
    hubc_ev_t *e,
    BSC_HUB_CONNECTOR_EVENT ev,
    BSC_HUB_CONNECTOR_HANDLE h,
    void *user_arg,
    uint8_t *pdu,
    size_t pdu_len)
{
    e->ev = ev;
    e->h = h;
    e->user_arg = user_arg;

    zassert_equal(true, pdu_len <= MAX_BVLC_LEN, NULL);

    if (pdu) {
        memcpy(e->pdu, pdu, pdu_len);
        e->pdu_len = pdu_len;
    }
    bsc_event_signal(e->e);
}

static void init_hubf_ev(hubf_ev_t *ev)
{
    memset(ev, 0, sizeof(*ev));
    ev->e = bsc_event_init();
    zassert_not_equal(ev->e, NULL, 0);
    ev->ev = -1;
}

static void deinit_hubf_ev(hubf_ev_t *ev)
{
    bsc_event_deinit(ev->e);
}

static bool wait_hubf_ev(
    hubf_ev_t *ev,
    BSC_HUB_FUNCTION_EVENT wait_ev,
    BSC_HUB_FUNCTION_HANDLE wait_h)
{
    call_maintenance_timer(1, 0);
    while (!bsc_event_timedwait(ev->e, WAIT_EVENT_MS)) {
        call_maintenance_timer(0, WAIT_EVENT_MS);
    }

    bws_dispatch_lock();
    if (ev->ev == wait_ev && ev->h == wait_h) {
        ev->ev = -1;
        // reset event if it was signalled while we were blocked in call
        // bws_dispatch_lock().
        // (in that case ev->ev contains code of last event.)
        // that's tricky but that allows to avoid using mutexes which are
        // platform specific in test code
        bsc_event_timedwait(ev->e, 1);
        bws_dispatch_unlock();
        return true;
    } else {
        bws_dispatch_unlock();
        return false;
    }
}

static void signal_hubf_ev(
    hubf_ev_t *e,
    BSC_HUB_FUNCTION_EVENT ev,
    BSC_HUB_CONNECTOR_HANDLE h,
    void *user_arg)
{
    e->ev = ev;
    e->h = h;
    e->user_arg = user_arg;
    bsc_event_signal(e->e);
}

static void hub_connector_event(
    BSC_HUB_CONNECTOR_EVENT ev,
    BSC_HUB_CONNECTOR_HANDLE h,
    void *user_arg,
    uint8_t *pdu,
    size_t pdu_len,
    BVLC_SC_DECODED_MESSAGE *decoded_pdu)
{
    (void)decoded_pdu;
    bws_dispatch_lock();
    debug_printf(
        "hub_connector_event() ev = %p, ev->e = %p, ev->ev = %d, h = "
        "%p, user_arg = %p, pdu = "
        "%p, pdu_len = %d\n",
        &hubc, hubc.e, ev, h, user_arg, pdu, pdu_len);
    signal_hubc_ev(&hubc, ev, h, user_arg, pdu, pdu_len);
    bws_dispatch_unlock();
}

static void hub_function_event(
    BSC_HUB_FUNCTION_EVENT ev, BSC_HUB_FUNCTION_HANDLE h, void *user_arg)
{
    bws_dispatch_lock();
    debug_printf(
        "hub_function_event()  ev = %p, ev->e = %p, ev->ev = %d, h = "
        "%p, user_arg = %p\n",
        &hubf, hubf.e, ev, h, user_arg);
    signal_hubf_ev(&hubf, ev, h, user_arg);
    bws_dispatch_unlock();
}

static void test_hub_connector_url(bool primary)
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    BACNET_SC_UUID hubc_uuid2;
    BACNET_SC_VMAC_ADDRESS hubc_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubc_h2;
    char primary_url[128];
    char secondary_url[128];
    uint8_t buf[256];
    size_t len;
    uint8_t npdu[128];
    BVLC_SC_DECODED_MESSAGE message;
    BACNET_ERROR_CODE error;
    BACNET_ERROR_CLASS class;
    const char *err_desc;
    BACNET_SC_VMAC_ADDRESS broadcast_vmac;
    BACNET_SC_VMAC_ADDRESS non_existent_vmac;

    memset(&broadcast_vmac, 0xff, sizeof(broadcast_vmac));
    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubc_uuid, 0x3, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x4, sizeof(hubc_vmac));
    memset(&hubc_uuid2, 0x5, sizeof(hubc_uuid2));
    memset(&hubc_vmac2, 0x6, sizeof(hubc_vmac2));
    memset(npdu, 0x11, sizeof(npdu));

    if (primary) {
        sprintf(
            primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
            BACNET_WEBSOCKET_SERVER_PORT);
        sprintf(
            secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
            BACNET_WEBSOCKET_SERVER_PORT2);
    } else {
        sprintf(
            primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
            BACNET_WEBSOCKET_SERVER_PORT2);
        sprintf(
            secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
            BACNET_WEBSOCKET_SERVER_PORT);
    }

    init_hubc_ev(&hubc);
    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);
    zassert_equal(bsc_hub_function_started(hubf_h), true, 0);
    zassert_equal(bsc_hub_function_stopped(hubf_h), false, 0);
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    if (primary) {
        zassert_equal(
            wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true,
            0);
    } else {
        zassert_equal(
            wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_FAILOVER, hubc_h),
            true, 0);
    }
    zassert_equal(bsc_hub_connector_stopped(hubc_h), false, 0);
    if (primary) {
        zassert_equal(
            bsc_hub_connector_state(hubc_h),
            BACNET_SC_HUB_CONNECTOR_STATE_CONNECTED_TO_PRIMARY, 0);
    } else {
        zassert_equal(
            bsc_hub_connector_state(hubc_h),
            BACNET_SC_HUB_CONNECTOR_STATE_CONNECTED_TO_FAILOVER, 0);
    }

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid2, &hubc_vmac2, MAX_BVLC_LEN,
        MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid2, &hubc_h2);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    if (primary) {
        zassert_equal(
            wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h2),
            true, 0);
    } else {
        zassert_equal(
            wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_FAILOVER, hubc_h2),
            true, 0);
    }
    memset(&non_existent_vmac, 0x22, sizeof(non_existent_vmac));
    len = bvlc_sc_encode_encapsulated_npdu(
        buf, sizeof(buf), 666, NULL, &non_existent_vmac, npdu, sizeof(npdu));
    zassert_equal(len > 0, true, NULL);
    ret = bsc_hub_connector_send(hubc_h2, buf, len);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    len = bvlc_sc_encode_encapsulated_npdu(
        buf, sizeof(buf), 111, NULL, &hubc_vmac, npdu, sizeof(npdu));
    zassert_equal(len > 0, true, NULL);
    ret = bsc_hub_connector_send(hubc_h2, buf, len);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_RECEIVED, hubc_h), true, 0);
    ret = bvlc_sc_decode_message(
        hubc.pdu, hubc.pdu_len, &message, &error, &class, &err_desc);
    zassert_equal(ret, true, NULL);
    zassert_equal(
        sizeof(npdu), message.payload.encapsulated_npdu.npdu_len, NULL);
    ret = memcmp(npdu, message.payload.encapsulated_npdu.npdu, sizeof(npdu));
    zassert_equal(ret, 0, NULL);
    // now send broadcast message
    memset(npdu, 0x22, sizeof(npdu));
    len = bvlc_sc_encode_encapsulated_npdu(
        buf, sizeof(buf), 222, NULL, &broadcast_vmac, npdu, sizeof(npdu));
    zassert_equal(len > 0, true, NULL);
    ret = bsc_hub_connector_send(hubc_h2, buf, len);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_RECEIVED, hubc_h), true, 0);
    ret = bvlc_sc_decode_message(
        hubc.pdu, hubc.pdu_len, &message, &error, &class, &err_desc);
    zassert_equal(ret, true, NULL);
    zassert_equal(
        sizeof(npdu), message.payload.encapsulated_npdu.npdu_len, NULL);
    ret = memcmp(npdu, message.payload.encapsulated_npdu.npdu, sizeof(npdu));
    zassert_equal(ret, 0, NULL);
    zassert_equal(bsc_hub_connector_stopped(hubc_h), false, 0);
    if (primary) {
        zassert_equal(
            bsc_hub_connector_state(hubc_h),
            BACNET_SC_HUB_CONNECTOR_STATE_CONNECTED_TO_PRIMARY, 0);
    } else {
        zassert_equal(
            bsc_hub_connector_state(hubc_h),
            BACNET_SC_HUB_CONNECTOR_STATE_CONNECTED_TO_FAILOVER, 0);
    }
    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);
    bsc_hub_connector_stop(hubc_h2);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h2), true, 0);
    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    zassert_equal(bsc_hub_function_started(hubf_h), false, 0);
    zassert_equal(bsc_hub_function_stopped(hubf_h), true, 0);
    zassert_equal(bsc_hub_connector_stopped(hubc_h), true, 0);
    deinit_hubc_ev(&hubc);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_3, test_hub_connector_bad_primary_url)
#else
static void test_hub_connector_bad_primary_url(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    char primary_url[128];
    char secondary_url[128];

    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubc_uuid, 0x3, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x4, sizeof(hubc_vmac));

    sprintf(
        primary_url, "wsssdsdfsdf://sdsdf%s:sdfsdf%d",
        BACNET_WEBSOCKET_SERVER_ADDR, BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);

    init_hubc_ev(&hubc);
    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_FAILOVER, hubc_h), true,
        0);

    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);

    /* now all  same but without secondary url */
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, NULL,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, NULL);

    /* stop hub */

    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    deinit_hubc_ev(&hubc);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_4, test_hub_bad_params)
#else
static void test_hub_bad_params(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BACNET_SC_UUID hubc_uuid2;
    BACNET_SC_VMAC_ADDRESS hubc_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    BSC_HUB_FUNCTION_HANDLE hubc_h2;
    BSC_HUB_FUNCTION_HANDLE hubc_h3;
    char primary_url[2 * BSC_WSURL_MAX_LEN];
    char secondary_url[2 * BSC_WSURL_MAX_LEN];

    memset(&hubc_uuid, 0x3, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x4, sizeof(hubc_vmac));
    memset(&hubc_uuid2, 0x5, sizeof(hubc_uuid));
    memset(&hubc_vmac2, 0x6, sizeof(hubc_vmac));
    sprintf(
        primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT2);

    init_hubc_ev(&hubc);

    ret = bsc_hub_connector_start(
        NULL, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, 0);

    ret = bsc_hub_connector_start(
        NULL, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, 0);

    memset(primary_url, 0x22, sizeof(primary_url));
    primary_url[2 * BSC_WSURL_MAX_LEN - 1] = 0;
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, 0);

    sprintf(
        primary_url, "wsssdsdfsdf://sdsdf%s:sdfsdf%d",
        BACNET_WEBSOCKET_SERVER_ADDR, BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss23413r234://sdfsdfsdf%s:r234%2d",
        BACNET_WEBSOCKET_SERVER_ADDR, BACNET_WEBSOCKET_SERVER_PORT2);
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, 0);

    sprintf(
        primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);

    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT2);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_vmac, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac2, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_vmac2, &hubc_h2);
    zassert_equal(ret, BSC_SC_SUCCESS, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_h3, &hubc_h3);
    zassert_equal(ret, BSC_SC_NO_RESOURCES, 0);

    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);

    bsc_hub_connector_stop(hubc_h2);
    ret = bsc_hub_connector_send(
        hubc_h, (uint8_t *)&hubc_uuid, sizeof(hubc_uuid));
    zassert_equal(ret, BSC_SC_INVALID_OPERATION, 0);
    ret =
        bsc_hub_connector_send(NULL, (uint8_t *)&hubc_uuid, sizeof(hubc_uuid));
    zassert_equal(ret, BSC_SC_BAD_PARAM, 0);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h2), true, 0);
    deinit_hubc_ev(&hubc);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_1, test_hub_connector_primary_url)
#else
static void test_hub_connector_primary_url(void)
#endif
{
    test_hub_connector_url(true);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_2, test_hub_connector_secondary_url)
#else
static void test_hub_connector_secondary_url(void)
#endif
{
    test_hub_connector_url(false);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_5, test_hub_connector_reconnect)
#else
static void test_hub_connector_reconnect(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubf_uuid2;
    BACNET_SC_VMAC_ADDRESS hubf_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubf_h2;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    char primary_url[128];
    char secondary_url[128];

    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubf_uuid2, 0x3, sizeof(hubf_uuid2));
    memset(&hubf_vmac2, 0x4, sizeof(hubf_vmac2));
    memset(&hubc_uuid, 0x5, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x6, sizeof(hubc_vmac));

    sprintf(
        primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT2);

    init_hubc_ev(&hubc);
    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT2, BSC_NETWORK_IFACE,
        &hubf_uuid2, &hubf_vmac2, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h2);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h2), true, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true, 0);

    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_FAILOVER, hubc_h), true,
        0);

    bsc_hub_function_stop(hubf_h2);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h2), true, 0);

    wait_sec(BACNET_TIMEOUT);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true, 0);

    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);
    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, NULL,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true, 0);

    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    wait_sec(BACNET_TIMEOUT);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true, 0);

    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);
    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);

    deinit_hubc_ev(&hubc);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_6, test_hub_connector_duplicated_vmac)
#else
static void test_hub_connector_duplicated_vmac(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    char primary_url[128];
    char secondary_url[128];

    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubc_uuid, 0x3, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x2, sizeof(hubc_vmac));

    sprintf(
        primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT2);

    init_hubc_ev(&hubc);
    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_ERROR_DUPLICATED_VMAC, hubc_h), true,
        0);

    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_ERROR_DUPLICATED_VMAC, hubf_h), true,
        0);

    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);
    deinit_hubc_ev(&hubc);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_7, test_hub_function_bad_params)
#else
static void test_hub_function_bad_params(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubf_uuid2;
    BACNET_SC_VMAC_ADDRESS hubf_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubf_h2;
    BACNET_SC_UUID hubf_uuid3;
    BACNET_SC_VMAC_ADDRESS hubf_vmac3;
    BSC_HUB_FUNCTION_HANDLE hubf_h3;

    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubf_uuid2, 0x3, sizeof(hubf_uuid2));
    memset(&hubf_vmac2, 0x4, sizeof(hubf_vmac2));
    memset(&hubf_uuid3, 0x5, sizeof(hubf_uuid3));
    memset(&hubf_vmac3, 0x6, sizeof(hubf_vmac3));

    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        NULL, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_BAD_PARAM, NULL);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT + 1, BSC_NETWORK_IFACE,
        &hubf_uuid2, &hubf_vmac2, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h2);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h2), true, 0);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT + 2, BSC_NETWORK_IFACE,
        &hubf_uuid3, &hubf_vmac3, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h3);
    zassert_equal(ret, BSC_SC_NO_RESOURCES, NULL);
    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    bsc_hub_function_stop(hubf_h2);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h2), true, 0);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
ZTEST(hub_test_8, test_hub_function_duplicated_uuid)
#else
static void test_hub_function_duplicated_uuid(void)
#endif
{
    BSC_SC_RET ret;
    BACNET_SC_UUID hubf_uuid;
    BACNET_SC_VMAC_ADDRESS hubf_vmac;
    BSC_HUB_FUNCTION_HANDLE hubf_h;
    BACNET_SC_UUID hubf_uuid2;
    BACNET_SC_VMAC_ADDRESS hubf_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubf_h2;
    BACNET_SC_UUID hubc_uuid;
    BACNET_SC_VMAC_ADDRESS hubc_vmac;
    BSC_HUB_FUNCTION_HANDLE hubc_h;
    BACNET_SC_UUID hubc_uuid2;
    BACNET_SC_VMAC_ADDRESS hubc_vmac2;
    BSC_HUB_FUNCTION_HANDLE hubc_h2;
    char primary_url[128];
    char secondary_url[128];

    memset(&hubf_uuid, 0x1, sizeof(hubf_uuid));
    memset(&hubf_vmac, 0x2, sizeof(hubf_vmac));
    memset(&hubf_uuid2, 0x10, sizeof(hubf_uuid2));
    memset(&hubf_vmac2, 0x20, sizeof(hubf_vmac2));
    memset(&hubc_uuid, 0x3, sizeof(hubc_uuid));
    memset(&hubc_vmac, 0x4, sizeof(hubc_vmac));
    memset(&hubc_uuid2, 0x3, sizeof(hubc_uuid2));
    memset(&hubc_vmac2, 0x6, sizeof(hubc_vmac2));

    sprintf(
        primary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT);
    sprintf(
        secondary_url, "wss://%s:%d", BACNET_WEBSOCKET_SERVER_ADDR,
        BACNET_WEBSOCKET_SERVER_PORT2);

    init_hubc_ev(&hubc);
    init_hubf_ev(&hubf);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT, BSC_NETWORK_IFACE,
        &hubf_uuid, &hubf_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h), true, 0);

    ret = bsc_hub_function_start(
        ca_cert, sizeof(ca_cert), server_cert, sizeof(server_cert), server_key,
        sizeof(server_key), BACNET_WEBSOCKET_SERVER_PORT2, BSC_NETWORK_IFACE,
        &hubf_uuid2, &hubf_vmac2, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        hub_function_event, NULL, &hubf_h2);

    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STARTED, hubf_h2), true, 0);
    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid, &hubc_vmac, MAX_BVLC_LEN, MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid, &hubc_h);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);

    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h), true, 0);

    ret = bsc_hub_connector_start(
        ca_cert, sizeof(ca_cert), client_cert, sizeof(client_cert), CLIENT_KEY,
        sizeof(CLIENT_KEY), &hubc_uuid2, &hubc_vmac2, MAX_BVLC_LEN,
        MAX_NDPU_LEN,
        BACNET_TIMEOUT, // connect timeout
        BACNET_TIMEOUT, // heartbeat timeout
        BACNET_TIMEOUT, // disconnect timeout
        primary_url, secondary_url,
        BACNET_TIMEOUT, // reconnect timeout
        hub_connector_event, &hubc_uuid2, &hubc_h2);
    zassert_equal(ret, BSC_SC_SUCCESS, NULL);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_CONNECTED_PRIMARY, hubc_h2), true,
        0);
    bsc_hub_connector_stop(hubc_h);
    zassert_equal(wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h), true, 0);
    bsc_hub_connector_stop(hubc_h2);
    zassert_equal(
        wait_hubc_ev(&hubc, BSC_HUBC_EVENT_STOPPED, hubc_h2), true, 0);
    bsc_hub_function_stop(hubf_h);
    zassert_equal(wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h), true, 0);
    bsc_hub_function_stop(hubf_h2);
    zassert_equal(
        wait_hubf_ev(&hubf, BSC_HUBF_EVENT_STOPPED, hubf_h2), true, 0);
    deinit_hubc_ev(&hubc);
    deinit_hubf_ev(&hubf);
}

#if defined(CONFIG_ZTEST_NEW_API)
static void *suite_setup(void)
{
    setbuf(stdout, NULL);
    return NULL;
}

ZTEST_SUITE(hub_test_1, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_2, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_3, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_4, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_5, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_6, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_7, NULL, suite_setup, NULL, NULL, NULL);
ZTEST_SUITE(hub_test_8, NULL, suite_setup, NULL, NULL, NULL);
#else
void test_main(void)
{
    // setbuf(stdout, NULL);
    // Tests must not be run in parallel threads!
    // Thats why tests functions are in different suites.
    ztest_test_suite(
        hub_test_1, ztest_unit_test(test_hub_connector_primary_url));
    ztest_test_suite(
        hub_test_2, ztest_unit_test(test_hub_connector_secondary_url));
    ztest_test_suite(
        hub_test_3, ztest_unit_test(test_hub_connector_bad_primary_url));
    ztest_test_suite(hub_test_4, ztest_unit_test(test_hub_bad_params));
    ztest_test_suite(hub_test_5, ztest_unit_test(test_hub_connector_reconnect));
    ztest_test_suite(
        hub_test_6, ztest_unit_test(test_hub_connector_duplicated_vmac));
    ztest_test_suite(hub_test_7, ztest_unit_test(test_hub_function_bad_params));
    ztest_test_suite(
        hub_test_8, ztest_unit_test(test_hub_function_duplicated_uuid));

    ztest_run_test_suite(hub_test_1);
    ztest_run_test_suite(hub_test_2);
    ztest_run_test_suite(hub_test_3);
    ztest_run_test_suite(hub_test_4);
    ztest_run_test_suite(hub_test_5);
    ztest_run_test_suite(hub_test_6);
    ztest_run_test_suite(hub_test_7);
    ztest_run_test_suite(hub_test_8);
}
#endif
