#include "translate.h"

std::string Translate::Language= "en";
std::map<std::wstring,std::wstring> Translate::KeysRu = {
    {L"Get Element Content", L"\x041F\x043E\x043B\x0443\x0447\x0438\x0442\x044C \x041A\x043E\x0434 \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0430"},
    {L"Move", L"\x0414\x0432\x0438\x0433\x0430\x0442\x044C \x041C\x044B\x0448\x044C"},
    {L"Click", L"\x041A\x043B\x0438\x043A\x043D\x0443\x0442\x044C"},
    {L"Move And Click", L"\x0414\x0432\x0438\x0433\x0430\x0442\x044C \x041C\x044B\x0448\x044C \x0418 \x041A\x043B\x0438\x043A\x043D\x0443\x0442\x044C"},
    {L"Get Element Text", L"\x041F\x043E\x043B\x0443\x0447\x0438\x0442\x044C \x0422\x0435\x043A\x0441\x0442"},
    {L"Type Text", L"\x0412\x0432\x043E\x0434 \x0442\x0435\x043A\x0441\x0442\x0430"},
    {L"Execute Javascript On Element", L"\x0412\x044B\x043F\x043E\x043B\x043D\x0438\x0442\x044C Javascript \x041D\x0430 \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0435"},
    {L"Click On Element", L"\x041A\x043B\x0438\x043A\x043D\x0443\x0442\x044C \x041D\x0430 \x042D\x043B\x0435\x043C\x0435\x043D\x0442"},
    {L"Move On Element", L"\x0414\x0432\x0438\x0433\x0430\x0442\x044C \x041C\x044B\x0448\x044C \x041D\x0430\x0434 \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x043E\x043C"},
    {L"Move And Click On Element", L"\x0414\x0432\x0438\x0433\x0430\x0442\x044C \x041C\x044B\x0448\x044C \x0418 \x041A\x043B\x0438\x043A\x043D\x0443\x0442\x044C \x041D\x0430 \x042D\x043B\x0435\x043C\x0435\x043D\x0442"},
    {L"Clear Edit", L"\x041E\x0447\x0438\x0441\x0442\x0438\x0442\x044C \x041F\x043E\x043B\x0435"},
    {L"Is Element Exists", L"\x041F\x0440\x043E\x0432\x0435\x0440\x0438\x0442\x044C \x0421\x0443\x0449\x0435\x0441\x0442\x0432\x043E\x0432\x0430\x043D\x0438\x0435"},
    {L"Get Element Style", L"\x041F\x043E\x043B\x0443\x0447\x0438\x0442\x044C \x0421\x0442\x0438\x043B\x044C \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0430"},
    {L"Set Checkbox", L"\x0423\x0441\x0442\x0430\x043D\x043E\x0432\x0438\x0442\x044C \x0427\x0435\x043A\x0431\x043E\x043A\x0441"},
    {L"Scroll To Element", L"\x041F\x0440\x043E\x043A\x0440\x0443\x0442\x043A\x0430 \x041A \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0443"},
    {L"Set Combobox Value", L"\x0423\x0441\x0442\x0430\x043D\x043E\x0432\x0438\x0442\x044C \x0417\x043D\x0430\x0447\x0435\x043D\x0438\x0435 \x041A\x043E\x043C\x0431\x043E\x0431\x043E\x043A\x0441\x0430"},
    {L"Set Combobox Index", L"\x0423\x0441\x0442\x0430\x043D\x043E\x0432\x0438\x0442\x044C \x0418\x043D\x0434\x0435\x043A\x0441 \x041A\x043E\x043C\x0431\x043E\x0431\x043E\x043A\x0441\x0430"},
    {L"Set Combobox To Random", L"\x0412\x044B\x0431\x0440\x0430\x0442\x044C \x0421\x043B\x0443\x0447\x0430\x0439\x043D\x044B\x0439 \x042D\x043B\x0435\x043C\x0435\x043D\x0442 \x0418\x0437 \x041A\x043E\x043C\x0431\x043E\x0431\x043E\x043A\x0441\x0430"},
    {L"Get Element Attribute", L"\x041F\x043E\x043B\x0443\x0447\x0438\x0442\x044C \x0410\x0442\x0440\x0438\x0431\x0443\x0442 \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0430"},
    {L"Set Element Attribute", L"\x0423\x0441\x0442\x0430\x043D\x043E\x0432\x0438\x0442\x044C \x0410\x0442\x0440\x0438\x0431\x0443\x0442 \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0430"},
    {L"Solve Captcha", L"\x0420\x0435\x0448\x0438\x0442\x044C \x041A\x0430\x043F\x0447\x0443"},
    {L"Get Element Count", L"\x041F\x043E\x043B\x0443\x0447\x0438\x0442\x044C \x041A\x043E\x043B\x0438\x0447\x0435\x0441\x0442\x0432\x043E \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x043E\x0432"},
    {L"Start Loop", L"\x041D\x0430\x0447\x0430\x0442\x044C \x0426\x0438\x043A\x043B"},
    {L"Wait While Element Exists", L"\x0416\x0434\x0430\x0442\x044C \x041F\x043E\x044F\x0432\x043B\x0435\x043D\x0438\x044F \x042D\x043B\x0435\x043C\x0435\x043D\x0442\x0430"},
    {L"Inspect", L"\u0418\u0437\u0443\u0447\u0438\u0442\u044C"},
    {L"For Each Element", L"\u0414\u043B\u044F \u043A\u0430\u0436\u0434\u043E\u0433\u043E \u044D\u043B\u0435\u043C\u0435\u043D\u0442\u0430"},
    {L"Tabs", L"\u0412\u043A\u043B\u0430\u0434\u043A\u0438"},
    {L"Add New Tab", L"\u0414\u043E\u0431\u0430\u0432\u0438\u0442\u044C \u0412\u043A\u043B\u0430\u0434\u043A\u0443"},
    {L"Select Tab (", L"\u041F\u0435\u0440\u0435\u043A\u043B\u044E\u0447\u0438\u0442\u044C\u0441\u044F ("},
    {L"Remove Tab (", L"\u0417\u0430\u043A\u0440\u044B\u0442\u044C ("},
    {L"Drag", L"\u041D\u0430\u0447\u0430\u0442\u044C \u041F\u0435\u0440\u0435\u0442\u044F\u0433\u0438\u0432\u0430\u043D\u0438\u0435"},
    {L"Drop", L"\u0417\u0430\u043A\u043E\u043D\u0447\u0438\u0442\u044C \u041F\u0435\u0440\u0435\u0442\u044F\u0433\u0438\u0432\u0430\u043D\u0438\u0435"},
    {L"Drag On Element", L"\u041D\u0430\u0447\u0430\u0442\u044C \u041F\u0435\u0440\u0435\u0442\u044F\u0433\u0438\u0432\u0430\u043D\u0438\u0435 \u041D\u0430 \u042D\u043B\u0435\u043C\u0435\u043D\u0442\u0435"},
    {L"Drop On Element", L"\u0417\u0430\u043A\u043E\u043D\u0447\u0438\u0442\u044C \u041F\u0435\u0440\u0435\u0442\u044F\u0433\u0438\u0432\u0430\u043D\u0438\u0435 \u041D\u0430 \u042D\u043B\u0435\u043C\u0435\u043D\u0442\u0435"},
    {L"Screenshot", L"\u0421\u043A\u0440\u0438\u043D\u0448\u043E\u0442"},
    {L"Get Coordinates", L"\u041F\u043E\u043B\u0443\u0447\u0438\u0442\u044C \u041A\u043E\u043E\u0440\u0434\u0438\u043D\u0430\u0442\u044B"},
    {L"Use drag to find by image", L"\u0418\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0439\u0442\u0435 \u043F\u0435\u0440\u0435\u0442\u044F\u0433\u0438\u0432\u0430\u043D\u0438\u0435 \u0434\u043B\u044F \u043F\u043E\u0438\u0441\u043A\u0430 \u043F\u043E \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u044E"},
    {L"Use click to find by selector",L"\u0418\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0439\u0442\u0435 \u043A\u043B\u0438\u043A \u0434\u043B\u044F \u043F\u043E\u0438\u0441\u043A\u0430 \u043F\u043E \u0441\u0435\u043B\u0435\u043A\u0442\u043E\u0440\u0443"}
};



void Translate::SetLanguage(std::string lang)
{
    Translate::Language = lang;
}

std::wstring Translate::Tr(std::wstring key)
{

    if(Language == "en")
        return key;


    if(Language == "ru")
        return (KeysRu.count(key) == 0) ? key : KeysRu[key];

    return key;
}
