# Tutorials

Tutorials are split in two sections, "How-to" and "Compatibility". The first one focuses on Baal's capabilities and the
latter on how we integrate with other common frameworks such as Label Studio, HuggingFace or Lightning Flash.

??? example "CIFAR10 experiment code walkthrough using Baal"
    <p align="center">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/Q5U2GtsSqIU" title="Baal Walkthrough" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    </p>

## :material-file-tree: How to

* [Active learning in production (Image Classification)](../notebooks/production/baal_prod_cls.ipynb)
* [Active learning in production (Text Classification)](../notebooks/production/baal_prod_cls_nlp_hf.ipynb)
* [Deep Ensembles](../notebooks/deep_ensemble.ipynb)

## :material-file-tree: Compatibility

* [:material-link: Lightning Flash](https://devblog.pytorchlightning.ai/active-learning-made-simple-using-flash-and-baal-2216df6f872c)
* [Scikit-Learn](../notebooks/compatibility/sklearn_tutorial.ipynb)
* [Label Studio CV](./label-studio-cv.md)
* [Label Studio NLP](./label-studio-hf.md)