# Willow Playground

![Logo](assets/logos/128x128.png)

Willow-Playground provides examples on how to use [Willow](https://github.com/ba-st/Willow)
to develop a complete interactive web application.

[![Baseline Groups](https://github.com/ba-st/Willow-Playground/actions/workflows/loading-groups.yml/badge.svg)](https://github.com/ba-st/Willow-Playground/actions/workflows/loading-groups.yml)
[![Markdown Lint](https://github.com/ba-st/Willow-Playground/actions/workflows/markdown-lint.yml/badge.svg)](https://github.com/ba-st/Willow-Playground/actions/workflows/markdown-lint.yml)

[![GitHub release](https://img.shields.io/github/release/ba-st/Willow-Playground.svg)](https://github.com/ba-st/Willow-Playground/releases/latest)
[![Pharo 11](https://img.shields.io/badge/Pharo-11-informational)](https://pharo.org)

## Goals

- Present the different components and features of Willow
- Offer simple interactive applications, that are both useful are clear to understand

## Quick links

- [**Explore the docs**](docs/README.md)
- [Report a defect](https://github.com/ba-st/Willow-Playground/issues/new?labels=Type%3A+Defect)
- [Request a feature](https://github.com/ba-st/Willow-Playground/issues/new?labels=Type%3A+Feature)

## License

- The code is licensed under [MIT](LICENSE).
- The documentation is licensed under [CC BY-SA 4.0](http://creativecommons.org/licenses/by-sa/4.0/).

## Quick Start

- Load the latest [playground version](docs/how-to/how-to-load-in-pharo.md)
- Evaluate

  ```smalltalk
  Smalltalks2017Presentation start
  ```

- Or use the docker containers:

  ```bash
  docker run -p 8080:8080 ghrc.io/ba-st/willow-playground:release-candidate
  ```
  
- Go to [localhost:8080/willow101](http://localhost:8080/willow101) to find an
  interactive tutorial.

To learn how to use Willow, you can check the applications included in this repository:

- Live Documentation: start by browsing `WPLiveDocumentation`. Access the
  application at [localhost:8080/live-docs](http://localhost:8080/live-docs)
- Test Runner (Bootstrap 3): start by browsing `WPB3TestRunner`. Access the
  application at [localhost:8080/test-runner-bootstrap3](http://localhost:8080/test-runner-bootstrap3)
- Test Runner (Bootstrap 4): start by browsing `WPB4TestRunner`. Access the
  application at [localhost:8080/test-runner-bootstrap4](http://localhost:8080/test-runner-bootstrap4)

## Contributing

Check the [Contribution Guidelines](CONTRIBUTING.md)
