#!/usr/bin/env bash
export DB=Mysql
source Scripts/bootstrap.sh "$*"
cp -v docker/apache/site-default.conf docker/apache/site.conf
echo -e "
Set of default Test environment
==========================
  Find exports for local test development phase only in './Scripts/bootargs.sh')
  ";
echo -e "
Documented VARIABLES in docker-compose.yml
  DOCKER_OS_NAME: os: ['osx','linux']
  DOCKER_PHP_VERSION : php: <version>
  DB=['Mysql', 'Pgsql', 'Sqlite']

Required VARIABLES  in docker-compose.yml or Pod environment
  DATABASE_USER: <rw-user>
  DATABASE_PASSWORD: <user-password>
  TEST_DATABASE_USER: <database-rw-user>
  TEST_DATABASE_PASSWORD: <user-password>
  if [ DB='Mysql' ]; then
    TEST_MYSQL_SERVICE_HOST: <mysql-host>
  else if [ DB='Postgres' ]; then
    TEST_POSTGRES_SERVICE_HOST: <postgres-host>
  fi
optional environment VARIABLES in docker-compose.yml
  ADDITIONAL_PHP_INI='path to a php.ini settings file'
==========================
";
[ -n "$TEST_DATABASE_USER" ] && [ -n "$TEST_DATABASE_PASSWORD" ] && [[ (-n "$TEST_MYSQL_SERVICE_HOST") || (-n "$TEST_PGSQL_SERVICE_HOST") ]] || echo "Missing VARIABLES. Please review your settings !"
if [ -n "${ADDITIONAL_PHP_INI}" ]; then /usr/bin/env bash .travis/TravisCI-OSX-PHP/build/custom_php_ini.sh; fi
mkdir -p build/logs
echo -e "Database Unit Tests... DB=${DB}"
if [[ "${DOCKER_OS_NAME}" == "linux" ]]; then
  if [[ ${DOCKER_PHP_VERSION:0:3} == "7.2" ]]; then
    pear config-set preferred_state snapshot && yes "" | pecl install mcrypt ;
  fi;
  sudo locale-gen de_DE
  sudo locale-gen es_ES
fi;
if [[ ${DB} == 'Mysql' ]]; then mysql -v -e 'CREATE DATABASE IF NOT EXISTS cakephp_test;' -u "${DATABASE_USER}" --password="${DATABASE_PASSWORD}"; fi
if [[ ${DB} == 'Mysql' ]]; then mysql -v -e 'CREATE DATABASE IF NOT EXISTS cakephp_test2;' -u "${DATABASE_USER}" --password="${DATABASE_PASSWORD}"; fi
if [[ ${DB} == 'Mysql' ]]; then mysql -v -e 'CREATE DATABASE IF NOT EXISTS cakephp_test3;' -u "${DATABASE_USER}" --password="${DATABASE_PASSWORD}"; fi
if [[ ${DB} == 'Pgsql' ]]; then psql -c 'CREATE DATABASE cakephp_test;' -U postgres; fi
if [[ ${DB} == 'Pgsql' ]]; then psql -c 'CREATE SCHEMA test2;' -U postgres -d cakephp_test; fi
if [[ ${DB} == 'Pgsql' ]]; then psql -c 'CREATE SCHEMA test3;' -U postgres -d cakephp_test; fi
chmod -R 777 ./app/tmp
if [[ "${DOCKER_OS_NAME}" == "linux" ]]; then
  echo "extension = memcached.so" >> ~/.phpenv/versions/"$(phpenv version-name)"/etc/php.ini
  echo "yes" | pecl install apcu-5.1.3 || true
  echo -e "extension = apcu.so\napc.enable_cli=1" >> ~/.phpenv/versions/"$(phpenv version-name)"/etc/php.ini
  phpenv rehash
fi
set +H
echo "<?php
/** This is a source file generated by docker/configure.sh . Modify it from there. */
  class DATABASE_CONFIG {
  private \$identities = array(
    'Mysql' => array(
      'datasource' => 'Database/MysqlCms',
      'host' => '${TEST_MYSQL_SERVICE_HOST}',
      'login' => '${TEST_DATABASE_USER}',
      'password' => '${TEST_DATABASE_PASSWORD}'
    ),
    'Pgsql' => array(
      'datasource' => 'Database/PostgresCms',
      'host' => '${TEST_PGSQL_SERVICE_HOST}',
      'login' => '${TEST_DATABASE_USER}',
      'database' => 'cakephp_test',
      'schema' => array(
        'default' => 'public',
        'test' => 'public',
        'test2' => 'test2',
        'test_database_three' => 'test3'
      )
    ),
    'Sqlite' => array(
      'datasource' => 'Database/SqliteCms',
      'database' => array(
        'default' => ':memory:',
        'test' => ':memory:',
        'test2' => '/tmp/cakephp_test2.db',
        'test_database_three' => '/tmp/cakephp_test3.db'
      ),
    )
  );
  public \$default = array(
    'persistent' => false,
    'host' => '',
    'login' => '',
    'password' => '',
    'database' => 'cakephp_test',
    'prefix' => ''
  );
  public \$test = array(
    'persistent' => false,
    'host' => '',
    'login' => '',
    'password' => '',
    'database' => 'cakephp_test',
    'prefix' => ''
  );
  public \$test2 = array(
    'persistent' => false,
    'host' => '',
    'login' => '',
    'password' => '',
    'database' => 'cakephp_test2',
    'prefix' => ''
  );
  public \$test_database_three = array(
    'persistent' => false,
    'host' => '',
    'login' => '',
    'password' => '',
    'database' => 'cakephp_test3',
    'prefix' => ''
  );
  public function __construct() {
    \$db = 'Mysql';
    if (!empty(\$_SERVER['DB'])) {
      \$db = \$_SERVER['DB'];
    }
    foreach (array('default', 'test', 'test2', 'test_database_three') as \$source) {
      \$config = array_merge(\$this->{\$source}, \$this->identities[\$db]);
      if (is_array(\$config['database'])) {
        \$config['database'] = \$config['database'][\$source];
      }
      if (!empty(\$config['schema']) && is_array(\$config['schema'])) {
        \$config['schema'] = \$config['schema'][\$source];
      }
      \$this->{\$source} = \$config;
    }
  }
  }" > app/Config/database.php
  echo -e "${green}Unit Test was set up in app/Config/database.php${nc}"
