# Top Deep Learning Projects
A list of popular github projects related to deep learning (ranked by stars).

Last Update: 2020.07.09
| Project Name | Stars | Description |
| ------- | ------ | ------ |
|[tensorflow](https://github.com/tensorflow/tensorflow)|146k|An Open Source Machine Learning Framework for Everyone|
|[keras](https://github.com/keras-team/keras)|48.9k|Deep Learning for humans|
|[opencv](https://github.com/opencv/opencv)|46.1k|Open Source Computer Vision Library|
|[pytorch](https://github.com/pytorch/pytorch)|40k|Tensors and Dynamic neural networks in Python with strong GPU acceleration|
|[TensorFlow-Examples](https://github.com/aymericdamien/TensorFlow-Examples)|38.1k|TensorFlow Tutorial and Examples for Beginners (support TF v1 & v2)|
|[tesseract](https://github.com/tesseract-ocr/tesseract)|35.3k|Tesseract Open Source OCR Engine (main repository)|
|[face_recognition](https://github.com/ageitgey/face_recognition)|35.2k|The world's simplest facial recognition api for Python and the command line|
|[faceswap](https://github.com/deepfakes/faceswap)|31.4k|Deepfakes Software For All|
|[transformers](https://github.com/huggingface/transformers)|30.4k|🤗Transformers: State-of-the-art Natural Language Processing for Pytorch and TensorFlow 2.0.|
|[100-Days-Of-ML-Code](https://github.com/Avik-Jain/100-Days-Of-ML-Code)|29.1k|100 Days of ML Coding|
|[julia](https://github.com/JuliaLang/julia)|28.1k|The Julia Language: A fresh approach to technical computing.|
|[gold-miner](https://github.com/xitu/gold-miner)|26.6k|🥇掘金翻译计划，可能是世界最大最好的英译中技术社区，最懂读者和译者的翻译平台：|
|[awesome-scalability](https://github.com/binhnguyennus/awesome-scalability)|26.6k|The Patterns of Scalable, Reliable, and Performant Large-Scale Systems|
|[basics](https://github.com/madewithml/basics)|24.5k|📚 Learn ML with clean code, simplified math and illustrative visuals.|
|[bert](https://github.com/google-research/bert)|23.9k|TensorFlow code and pre-trained models for BERT|
|[funNLP](https://github.com/fighting41love/funNLP)|22.1k|(Machine Learning)NLP面试中常考到的知识点和代码实现、nlp4han:中文自然语言处理工具集(断句/分词/词性标注/组块/句法分析/语义分析/NER/N元语法/HMM/代词消解/情感分析/拼写检查、XLM：Face…|
|[xgboost](https://github.com/dmlc/xgboost)|19.4k|Scalable, Portable and Distributed Gradient Boosting (GBDT, GBRT or GBM) Library, for Python, R, Java, Scala, C++ and more. Runs on single machine, Hadoop, Spark, Flink and DataFlow|
|[Real-Time-Voice-Cloning](https://github.com/CorentinJ/Real-Time-Voice-Cloning)|18.4k|Clone a voice in 5 seconds to generate arbitrary speech in real-time|
|[d2l-zh](https://github.com/d2l-ai/d2l-zh)|17.9k|《动手学深度学习》：面向中文读者、能运行、可讨论。英文版即伯克利“深度学习导论”教材。|
|[openpose](https://github.com/CMU-Perceptual-Computing-Lab/openpose)|17.8k|OpenPose: Real-time multi-person keypoint detection library for body, face, hands, and foot estimation|
|[Coursera-ML-AndrewNg-Notes](https://github.com/fengdu78/Coursera-ML-AndrewNg-Notes)|17.7k|吴恩达老师的机器学习课程个人笔记|
|[DeepFaceLab](https://github.com/iperov/DeepFaceLab)|17.3k|DeepFaceLab is the leading software for creating deepfakes.|
|[pytorch-tutorial](https://github.com/yunjey/pytorch-tutorial)|17.3k|PyTorch Tutorial for Deep Learning Researchers|
|[Mask_RCNN](https://github.com/matterport/Mask_RCNN)|17.2k|Mask R-CNN for object detection and instance segmentation on Keras and TensorFlow|
|[spaCy](https://github.com/explosion/spaCy)|16.8k|💫 Industrial-strength Natural Language Processing (NLP) with Python and Cython|
|[NLP-progress](https://github.com/sebastianruder/NLP-progress)|16.2k|Repository to track the progress in Natural Language Processing (NLP), including the datasets and the current state-of-the-art for the most common NLP tasks.|
|[100-Days-Of-ML-Code](https://github.com/MLEveryday/100-Days-Of-ML-Code)|15.6k|100-Days-Of-ML-Code中文版|
|[cs-video-courses](https://github.com/Developer-Y/cs-video-courses)|14.9k|List of Computer Science courses with video lectures.|
|[WaveFunctionCollapse](https://github.com/mxgmn/WaveFunctionCollapse)|14.7k|Bitmap & tilemap generation from a single example with the help of ideas from quantum mechanics.|
|[lectures](https://github.com/oxford-cs-deepnlp-2017/lectures)|14.7k|Oxford Deep NLP 2017 course|
|[reinforcement-learning](https://github.com/dennybritz/reinforcement-learning)|14.7k|Implementation of Reinforcement Learning Algorithms. Python, OpenAI Gym, Tensorflow. Exercises and Solutions to accom…|
|[pwc](https://github.com/zziz/pwc)|14.7k|Papers with code. Sorted by stars. Updated weekly.|
|[TensorFlow-Course](https://github.com/machinelearningmindset/TensorFlow-Course)|14.6k|Simple and ready-to-use tutorials for TensorFlow|
|[DeepSpeech](https://github.com/mozilla/DeepSpeech)|14.4k|A TensorFlow implementation of Baidu's DeepSpeech architecture|
|[pumpkin-book](https://github.com/datawhalechina/pumpkin-book)|14k|《机器学习》（西瓜书）公式推导解析，在线阅读地址：https://datawhalechina.github.io/pumpkin-book|
|[tfjs](https://github.com/tensorflow/tfjs)|13.5k|A WebGL accelerated JavaScript library for training and deploying ML models.|
|[examples](https://github.com/pytorch/examples)|13.5k|A set of examples around pytorch in Vision, Text, Reinforcement Learning, etc.|
|[openface](https://github.com/cmusatyalab/openface)|13.5k|Face recognition with deep neural networks.|
|[Qix](https://github.com/ty4z2008/Qix)|13.3k|Machine Learning、Deep Learning、PostgreSQL、Distributed System、Node.Js、Golang|
|[spleeter](https://github.com/deezer/spleeter)|12.7k|Deezer source separation library including pretrained models.|
|[Virgilio](https://github.com/virgili0/Virgilio)|12.7k|Your new Mentor for Data Science E-Learning.|
|[nndl.github.io](https://github.com/nndl/nndl.github.io)|12.7k|《神经网络与深度学习》 邱锡鹏著 Neural Network and Deep Learning|
|[Screenshot-to-code](https://github.com/emilwallner/Screenshot-to-code)|12.7k|A neural network that transforms a design mock-up into a static website.|
|[pytorch-CycleGAN-and-pix2pix](https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix)|12.4k|Image-to-Image Translation in PyTorch|
|[pytorch-handbook](https://github.com/zergtant/pytorch-handbook)|11.9k|pytorch handbook是一本开源的书籍，目标是帮助那些希望和使用PyTorch进行深度学习开发和研究的朋友快速入门，其中包含的Pytorch教程全部通过测试保证可以成功运行|
|[gun](https://github.com/amark/gun)|11.9k|An open source cybersecurity protocol for syncing decentralized graph data.|
|[Paddle](https://github.com/PaddlePaddle/Paddle)|11.8k|PArallel Distributed Deep LEarning: Machine Learning Framework from Industrial Practice （『飞桨』核心框架，深度学习&机器学习高性能单机、分布式训…|
|[tensorflow-zh](https://github.com/jikexueyuanwiki/tensorflow-zh)|11.8k|谷歌全新开源人工智能系统TensorFlow官方文档中文版|
|[darknet](https://github.com/AlexeyAB/darknet)|11.4k|YOLOv4 - Neural Networks for Object Detection (Windows and Linux version of Darknet )|
|[learnopencv](https://github.com/spmallick/learnopencv)|11.4k|Learn OpenCV : C++ and Python Examples|
|[neural-networks-and-deep-learning](https://github.com/mnielsen/neural-networks-and-deep-learning)|11.3k|Code samples for my book "Neural Networks and Deep Learning"|
|[google-research](https://github.com/google-research/google-research)|11.2k|Google Research|
|[labelImg](https://github.com/tzutalin/labelImg)|11.2k|🖍️ LabelImg is a graphical image annotation tool and label object bounding boxes in images|
|[gensim](https://github.com/RaRe-Technologies/gensim)|11k|Topic Modelling for Humans|
|[pix2code](https://github.com/tonybeltramelli/pix2code)|10.9k|pix2code: Generating Code from a Graphical User Interface Screenshot|
|[facenet](https://github.com/davidsandberg/facenet)|10.8k|Face recognition using Tensorflow|
|[DeOldify](https://github.com/jantic/DeOldify)|10.7k|A Deep Learning based project for colorizing and restoring old images (and video!)|
|[python-machine-learning-book](https://github.com/rasbt/python-machine-learning-book)|10.7k|The "Python Machine Learning (1st edition)" book code repository and info resource|
|[stanford-cs-229-machine-learning](https://github.com/afshinea/stanford-cs-229-machine-learning)|10.6k|VIP cheatsheets for Stanford's CS 229 Machine Learning|
|[mmdetection](https://github.com/open-mmlab/mmdetection)|10.5k|OpenMMLab Detection Toolbox and Benchmark|
|[face-api.js](https://github.com/justadudewhohacks/face-api.js)|10.4k|JavaScript API for face detection and face recognition in the browser and nodejs with tensorflow.js|
|[Awesome-pytorch-list](https://github.com/bharathgs/Awesome-pytorch-list)|10.4k|A comprehensive list of pytorch related content on github,such as different models,implementations,helper libraries,t…|
|[nsfw_data_scraper](https://github.com/alex000kim/nsfw_data_scraper)|10.2k|Collection of scripts to aggregate image data for the purposes of training an NSFW Image Classifier|
|[convnetjs](https://github.com/karpathy/convnetjs)|10k|Deep Learning in Javascript. Train Convolutional Neural Networks (or ordinary ones) in your browser.|
|[CycleGAN](https://github.com/junyanz/CycleGAN)|9.8k|Software that can generate photos from paintings, turn horses into zebras, perform style transfer, and more.|
|[streamlit](https://github.com/streamlit/streamlit)|9.8k|Streamlit — The fastest way to build data apps in Python|
|[DeepCreamPy](https://github.com/deeppomf/DeepCreamPy)|9.7k|Decensoring Hentai with Deep Neural Networks|
|[stylegan](https://github.com/NVlabs/stylegan)|9.7k|StyleGAN - Official TensorFlow Implementation|
|[Dive-into-DL-PyTorch](https://github.com/ShusenTang/Dive-into-DL-PyTorch)|9.6k|本项目将《动手学深度学习》(Dive into Deep Learning)原书中的MXNet实现改为PyTorch实现。|
|[stanford-tensorflow-tutorials](https://github.com/chiphuyen/stanford-tensorflow-tutorials)|9.6k|This repository contains code examples for the Stanford's course: TensorFlow for Deep Learning Research.|
|[horovod](https://github.com/horovod/horovod)|9.6k|Distributed training framework for TensorFlow, Keras, PyTorch, and Apache MXNet.|
|[Deep-Learning-with-TensorFlow-book](https://github.com/dragen1860/Deep-Learning-with-TensorFlow-book)|9.4k|深度学习入门开源书，基于TensorFlow 2.0案例实战。Open source Deep Learning book, based on TensorFlow 2.0 framework.|
|[neural-doodle](https://github.com/alexjc/neural-doodle)|9.4k|Turn your two-bit doodles into fine artworks with deep neural networks, generate seamless textures from photos, transfer style from one image to another, perform example-based upscaling, but wait... there's more! (An implementation of Semantic Style Transfer.)|
|[caire](https://github.com/esimov/caire)|9.3k|Content aware image resize library|
|[fast-style-transfer](https://github.com/lengstrom/fast-style-transfer)|9.2k|TensorFlow CNN for fast style transfer ⚡🖥🎨🖼|
|[ncnn](https://github.com/Tencent/ncnn)|9.2k|ncnn is a high-performance neural network inference framework optimized for the mobile platform|
|[kubeflow](https://github.com/kubeflow/kubeflow)|9.1k|Machine Learning Toolkit for Kubernetes|
|[nltk](https://github.com/nltk/nltk)|9k|NLTK Source|
|[flair](https://github.com/flairNLP/flair)|9k|A very simple framework for state-of-the-art Natural Language Processing (NLP)|
|[ml-agents](https://github.com/Unity-Technologies/ml-agents)|9k|Unity Machine Learning Agents Toolkit|
|[allennlp](https://github.com/allenai/allennlp)|8.8k|An open-source NLP research library, built on PyTorch.|
|[botpress](https://github.com/botpress/botpress)|8.8k|🤖 The Conversational Platform with built-in language understanding (NLU), beautiful graphical interface and Dialog Manager (DM). Easily create chatbots and AI-based virtual assistants.|
|[the-gan-zoo](https://github.com/hindupuravinash/the-gan-zoo)|8.7k|A list of all named GANs!|
|[EffectiveTensorflow](https://github.com/vahidk/EffectiveTensorflow)|8.6k|TensorFlow tutorials and best practices.|
|[tfjs-core](https://github.com/tensorflow/tfjs-core)|8.5k|WebGL-accelerated ML // linear algebra // automatic differentiation for JavaScript.|
|[fairseq](https://github.com/pytorch/fairseq)|8.4k|Facebook AI Research Sequence-to-Sequence Toolkit written in Python.|
|[sonnet](https://github.com/deepmind/sonnet)|8.4k|TensorFlow-based neural network library|
|[mit-deep-learning-book-pdf](https://github.com/janishar/mit-deep-learning-book-pdf)|8.3k|MIT Deep Learning Book in PDF format (complete and parts) by Ian Goodfellow, Yoshua Bengio and Aaron Courville|
|[TensorFlow-Tutorials](https://github.com/Hvass-Labs/TensorFlow-Tutorials)|8.3k|TensorFlow Tutorials with YouTube Videos|
|[pytorch_geometric](https://github.com/rusty1s/pytorch_geometric)|8.2k|Geometric Deep Learning Extension Library for PyTorch|
|[tutorials](https://github.com/MorvanZhou/tutorials)|8.2k|机器学习相关教程|
|[fashion-mnist](https://github.com/zalandoresearch/fashion-mnist)|8k|A MNIST-like fashion product database. Benchmark 👉|
|[bert-as-service](https://github.com/hanxiao/bert-as-service)|7.9k|Mapping a variable-length sentence to a fixed-length vector using BERT model|
|[pix2pix](https://github.com/phillipi/pix2pix)|7.8k|Image-to-image translation with conditional adversarial nets|
|[mediapipe](https://github.com/google/mediapipe)|7.7k|MediaPipe is the simplest way for researchers and developers to build world-class ML solutions and applications for mobile, edge, cloud and the web.|
|[recommenders](https://github.com/microsoft/recommenders)|7.7k|Best Practices on Recommendation Systems|
|[mit-deep-learning](https://github.com/lexfridman/mit-deep-learning)|7.7k|Tutorials, assignments, and competitions for MIT Deep Learning related courses.|
|[pytorch-book](https://github.com/chenyuntc/pytorch-book)|7.6k|PyTorch tutorials and fun projects including neural talk, neural style, poem writing, anime generation (《深度学习框架PyTorch：入门与实战》)|
|[Winds](https://github.com/GetStream/Winds)|7.6k|A Beautiful Open Source RSS & Podcast App Powered by Getstream.io|
|[vid2vid](https://github.com/NVIDIA/vid2vid)|7.4k|Pytorch implementation of our method for high-resolution (e.g. 2048x1024) photorealistic video-to-video translation.|
|[Learn_Machine_Learning_in_3_Months](https://github.com/llSourcell/Learn_Machine_Learning_in_3_Months)|7.3k|This is the code for "Learn Machine Learning in 3 Months" by Siraj Raval on Youtube|
|[golearn](https://github.com/sjwhitworth/golearn)|7.3k|Machine Learning for Go|
|[Keras-GAN](https://github.com/eriklindernoren/Keras-GAN)|7.2k|Keras implementations of Generative Adversarial Networks.|
|[mlcourse.ai](https://github.com/Yorko/mlcourse.ai)|7k|Open Machine Learning Course|
|[faceai](https://github.com/vipstone/faceai)|7k|一款入门级的人脸、视频、文字检测以及识别的项目.|
|[pysc2](https://github.com/deepmind/pysc2)|6.9k|StarCraft II Learning Environment|
|[pretrained-models.pytorch](https://github.com/Cadene/pretrained-models.pytorch)|6.9k|Pretrained ConvNets for pytorch: NASNet, ResNeXt, ResNet, InceptionV4, InceptionResnetV2, Xception, DPN, etc.|
|[PyTorch-GAN](https://github.com/eriklindernoren/PyTorch-GAN)|6.7k|PyTorch implementations of Generative Adversarial Networks.|
|[vision](https://github.com/pytorch/vision)|6.7k|Datasets, Transforms and Models specific to Computer Vision|
|[nlp-tutorial](https://github.com/graykode/nlp-tutorial)|6.6k|Natural Language Processing Tutorial for Deep Learning Researchers|
|[bullet3](https://github.com/bulletphysics/bullet3)|6.6k|Bullet Physics SDK: real-time collision detection and multi-physics simulation for VR, games, visual effects, robotics,|
|[DCGAN-tensorflow](https://github.com/carpedm20/DCGAN-tensorflow)|6.6k|A tensorflow implementation of "Deep Convolutional Generative Adversarial Networks"|
|[tfjs-models](https://github.com/tensorflow/tfjs-models)|6.5k|Pretrained models for TensorFlow.js|
|[abu](https://github.com/bbfamily/abu)|6.5k|阿布量化交易系统(股票，期权，期货，比特币，机器学习) 基于python的开源量化交易，量化投资架构|
|[pytorch-lightning](https://github.com/PyTorchLightning/pytorch-lightning)|6.5k|The lightweight PyTorch wrapper for ML researchers. Scale your models. Write less boilerplate|
|[tensorboardX](https://github.com/lanpa/tensorboardX)|6.4k|tensorboard for pytorch (and chainer, mxnet, numpy, ...)|
|[machine-learning-course](https://github.com/machinelearningmindset/machine-learning-course)|6.4k|💬 Machine Learning Course with Python:|
|[guess](https://github.com/guess-js/guess)|6.3k|🔮 Libraries & tools for enabling Machine Learning driven user-experiences on the web|
|[pyro](https://github.com/pyro-ppl/pyro)|6.3k|Deep universal probabilistic programming with Python and PyTorch|
|[lab](https://github.com/deepmind/lab)|6.2k|A customisable 3D platform for agent-based AI research|
|[mml-book.github.io](https://github.com/mml-book/mml-book.github.io)|6.2k|Companion webpage to the book "Mathematics For Machine Learning"|
|[Interview](https://github.com/apachecn/Interview)|6.2k|Interview = 简历指南 + LeetCode + Kaggle|
|[tensorlayer](https://github.com/tensorlayer/tensorlayer)|6.2k|Deep Learning and Reinforcement Learning Library for Scientists and Engineers 🔥|
|[generative-models](https://github.com/wiseodd/generative-models)|6.1k|Collection of generative models, e.g. GAN, VAE in Pytorch and Tensorflow.|
|[machine-learning-yearning-cn](https://github.com/deeplearning-ai/machine-learning-yearning-cn)|6.1k|Machine Learning Yearning 中文版 - 《机器学习训练秘籍》 - Andrew Ng 著|
|[keras-yolo3](https://github.com/qqwweee/keras-yolo3)|6k|A Keras implementation of YOLOv3 (Tensorflow backend)|
|[BossSensor](https://github.com/Hironsan/BossSensor)|5.9k|Hide screen when boss is approaching.|
|[tensorflow2_tutorials_chinese](https://github.com/czy36mengfei/tensorflow2_tutorials_chinese)|5.9k|tensorflow2中文教程，持续更新(当前版本:tensorflow2.0)，tag: tensorflow 2.0 tutorials|
|[TensorFlow-Tutorials](https://github.com/nlintz/TensorFlow-Tutorials)|5.9k|Simple tutorials using Google's TensorFlow Framework|
|[argo](https://github.com/argoproj/argo)|5.9k|Argo Workflows: Get stuff done with Kubernetes.|
|[python-machine-learning-book-2nd-edition](https://github.com/rasbt/python-machine-learning-book-2nd-edition)|5.8k|The "Python Machine Learning (2nd edition)" book code repository and info resource|
|[dvc](https://github.com/iterative/dvc)|5.7k|🦉Data Version Control | Git for Data & Models|
|[EasyPR](https://github.com/liuruoze/EasyPR)|5.7k|An easy, flexible, and accurate plate recognition project for Chinese licenses in unconstrained situations.|
|[AdversarialNetsPapers](https://github.com/zhangqianhui/AdversarialNetsPapers)|5.6k|The classical paper list with code about generative adversarial nets|
|[tensorpack](https://github.com/tensorpack/tensorpack)|5.6k|A Neural Net Training Interface on TensorFlow, with focus on speed + flexibility|
|[photoprism](https://github.com/photoprism/photoprism)|5.6k|Personal Photo Management powered by Go and Google TensorFlow|
|[tensorflow_cookbook](https://github.com/nfmcclure/tensorflow_cookbook)|5.6k|Code for Tensorflow Machine Learning Cookbook|
|[albumentations](https://github.com/albumentations-team/albumentations)|5.6k|fast image augmentation library and easy to use wrapper around other libraries|
|[swift](https://github.com/tensorflow/swift)|5.6k|Swift for TensorFlow|
|[darkflow](https://github.com/thtrieu/darkflow)|5.6k|Translate darknet to tensorflow. Load trained weights, retrain/fine-tune using tensorflow, export constant graph def to mobile devices|
|[tensorflow_tutorials](https://github.com/pkmital/tensorflow_tutorials)|5.5k|From the basics to slightly more interesting applications of Tensorflow|
|[deep-learning-coursera](https://github.com/Kulbear/deep-learning-coursera)|5.5k|Deep Learning Specialization by Andrew Ng on Coursera.|
|[transferlearning](https://github.com/jindongwang/transferlearning)|5.5k|Everything about Transfer Learning and Domain Adaptation--迁移学习|
|[ML-NLP](https://github.com/NLP-LOVE/ML-NLP)|5.5k|此项目是机器学习(Machine Learning)、深度学习(Deep Learning)、NLP面试中常考到的知识点和代码实现，也是作为一个算法工程师必会的理论基础知识。|
|[nmt](https://github.com/tensorflow/nmt)|5.5k|TensorFlow Neural Machine Translation Tutorial|
|[faster-rcnn.pytorch](https://github.com/jwyang/faster-rcnn.pytorch)|5.5k|A faster pytorch implementation of faster r-cnn|
|[UGATIT](https://github.com/taki0112/UGATIT)|5.4k|Official Tensorflow implementation of U-GAT-IT: Unsupervised Generative Attentional Networks with Adaptive Layer-Inst…|
|[pandas-profiling](https://github.com/pandas-profiling/pandas-profiling)|5.4k|Create HTML profiling reports from pandas DataFrame objects|
|[deep-residual-networks](https://github.com/KaimingHe/deep-residual-networks)|5.4k|Deep Residual Learning for Image Recognition|
|[xlnet](https://github.com/zihangdai/xlnet)|5.3k|XLNet: Generalized Autoregressive Pretraining for Language Understanding|
|[leeml-notes](https://github.com/datawhalechina/leeml-notes)|5.2k|李宏毅《机器学习》笔记，在线阅读地址：https://datawhalechina.github.io/leeml-notes|
|[wav2letter](https://github.com/facebookresearch/wav2letter)|5.2k|Facebook AI Research's Automatic Speech Recognition Toolkit|
|[neural-style](https://github.com/anishathalye/neural-style)|5.2k|Neural style in TensorFlow! 🎨|
|[CVPR2020-Paper-Code-Interpretation](https://github.com/extreme-assistant/CVPR2020-Paper-Code-Interpretation)|5.2k|cvpr2020/cvpr2019／cvpr2018/cvpr2017 papers，极市团队整理|
|[TensorFlow-2.x-Tutorials](https://github.com/dragen1860/TensorFlow-2.x-Tutorials)|5.2k|TensorFlow 2.x version's Tutorials and Examples, including CNN, RNN, GAN, Auto-Encoders, FasterRCNN, GPT, BERT exampl…|
|[yolov3](https://github.com/ultralytics/yolov3)|5.2k|YOLOv3 in PyTorch > ONNX > CoreML > iOS|
|[cnn-text-classification-tf](https://github.com/dennybritz/cnn-text-classification-tf)|5.2k|Convolutional Neural Network for Text Classification in Tensorflow|
|[seq2seq](https://github.com/google/seq2seq)|5.2k|A general-purpose encoder-decoder framework for Tensorflow|
|[chineseocr_lite](https://github.com/ouyanghuiyu/chineseocr_lite)|5.1k|超轻量级中文ocr，支持竖排文字识别, 支持ncnn推理 , dbnet(1.7M) + crnn(6.3M) + anglenet(1.5M) 总模型仅10M|
|[featuretools](https://github.com/FeatureLabs/featuretools)|5k|An open source python library for automated feature engineering|
|[labelme](https://github.com/wkentaro/labelme)|5k|Image Polygonal Annotation with Python (polygon, rectangle, circle, line, point and image-level flag annotation).|
|[ImageAI](https://github.com/OlafenwaMoses/ImageAI)|5k|A python library built to empower developers to build applications and systems with self-contained Computer Vision capabilities|
|[nlp-recipes](https://github.com/microsoft/nlp-recipes)|5k|Natural Language Processing Best Practices & Examples|
|[have-fun-with-machine-learning](https://github.com/humphd/have-fun-with-machine-learning)|4.9k|An absolute beginner's guide to Machine Learning and Image Classification with Neural Networks|
|[eat_tensorflow2_in_30_days](https://github.com/lyhue1991/eat_tensorflow2_in_30_days)|4.9k|Tensorflow2.0 🍎🍊 is delicious, just eat it! 😋😋|
|[tensorflow-wavenet](https://github.com/ibab/tensorflow-wavenet)|4.9k|A TensorFlow implementation of DeepMind's WaveNet paper|
|[PyTorch-Tutorial](https://github.com/MorvanZhou/PyTorch-Tutorial)|4.9k|Build your neural network easy and fast|
|[stylegan2](https://github.com/NVlabs/stylegan2)|4.9k|StyleGAN2 - Official TensorFlow Implementation|
|[h2o-3](https://github.com/h2oai/h2o-3)|4.9k|Open Source Fast Scalable Machine Learning Platform For Smarter Applications: Deep Learning, Gradient Boosting & XGBo…|
|[awesome-machine-learning-on-source-code](https://github.com/src-d/awesome-machine-learning-on-source-code)|4.8k|Cool links & research papers related to Machine Learning applied to source code (MLonCode)|
|[Learning-to-See-in-the-Dark](https://github.com/cchen156/Learning-to-See-in-the-Dark)|4.8k|Learning to See in the Dark. CVPR 2018|
|[PyTorch-YOLOv3](https://github.com/eriklindernoren/PyTorch-YOLOv3)|4.8k|Minimal PyTorch implementation of YOLOv3|
|[first-order-model](https://github.com/AliaksandrSiarohin/first-order-model)|4.8k|This repository contains the source code for the paper First Order Motion Model for Image Animation|
|[models](https://github.com/PaddlePaddle/models)|4.8k|Pre-trained and Reproduced Deep Learning Models （『飞桨』官方模型库，包含多种学术前沿和工业场景验证的深度学习模型）|
|[smile](https://github.com/haifengl/smile)|4.8k|Statistical Machine Intelligence & Learning Engine|
|[keras-js](https://github.com/transcranial/keras-js)|4.7k|Run Keras models in the browser, with GPU support using WebGL|
|[carla](https://github.com/carla-simulator/carla)|4.7k|Open-source simulator for autonomous driving research.|
|[keras-rl](https://github.com/keras-rl/keras-rl)|4.7k|Deep Reinforcement Learning for Keras.|
|[useful-java-links](https://github.com/Vedenin/useful-java-links)|4.7k|A list of useful Java frameworks, libraries, software and hello worlds examples|
|[Awesome-CoreML-Models](https://github.com/likedan/Awesome-CoreML-Models)|4.7k|Largest list of models for Core ML (for iOS 11+)|
|[python-small-examples](https://github.com/jackzhenguo/python-small-examples)|4.7k|告别枯燥，致力于打造 Python 富有体系且实用的小例子、小案例。|
|[gcn](https://github.com/tkipf/gcn)|4.7k|Implementation of Graph Convolutional Networks in TensorFlow|
|[introduction_to_ml_with_python](https://github.com/amueller/introduction_to_ml_with_python)|4.7k|Notebooks and code for the book "Introduction to Machine Learning with Python"|
|[stargan](https://github.com/yunjey/stargan)|4.6k|StarGAN - Official PyTorch Implementation (CVPR 2018)|
|[pix2pixHD](https://github.com/NVIDIA/pix2pixHD)|4.6k|Synthesizing and manipulating 2048x1024 images with conditional GANs|
|[Data-Science-Wiki](https://github.com/Leo-G/Data-Science-Wiki)|4.6k|A wiki of DataScience, Statistics, Maths, R,Python, AI, Machine Learning, Automation, Devops Tools, Bash, Linux Tutor…|
|[MVision](https://github.com/Ewenwan/MVision)|4.6k|机器人视觉 移动机器人 VS-SLAM ORB-SLAM2 深度学习目标检测 yolov3 行为检测 opencv PCL 机器学习 无人驾驶|
|[cleverhans](https://github.com/tensorflow/cleverhans)|4.6k|An adversarial example library for constructing attacks, building defenses, and benchmarking both|
|[vaex](https://github.com/vaexio/vaex)|4.6k|Out-of-Core DataFrames for Python, ML, visualize and explore big tabular data at a billion rows per second 🚀|
|[Grokking-Deep-Learning](https://github.com/iamtrask/Grokking-Deep-Learning)|4.6k|this repository accompanies the book "Grokking Deep Learning"|
|[trax](https://github.com/google/trax)|4.5k|Trax — Deep Learning with Clear Code and Speed|
|[graph_nets](https://github.com/deepmind/graph_nets)|4.5k|Build Graph Nets in Tensorflow|
|[edward](https://github.com/blei-lab/edward)|4.5k|A probabilistic programming language in TensorFlow. Deep generative models, variational inference.|
|[TensorFlow-World](https://github.com/astorfi/TensorFlow-World)|4.5k|🌎 Simple and ready-to-use tutorials for TensorFlow|
|[imbalanced-learn](https://github.com/scikit-learn-contrib/imbalanced-learn)|4.5k|A Python Package to Tackle the Curse of Imbalanced Datasets in Machine Learning|
|[machine-learning-mindmap](https://github.com/dformoso/machine-learning-mindmap)|4.5k|A mindmap summarising Machine Learning concepts, from Data Analysis to Deep Learning.|
|[seq2seq-couplet](https://github.com/wb14123/seq2seq-couplet)|4.5k|Play couplet with seq2seq model. 用深度学习对对联。|
|[EfficientNet-PyTorch](https://github.com/lukemelas/EfficientNet-PyTorch)|4.4k|A PyTorch implementation of EfficientNet|
|[TensorFlow-Book](https://github.com/BinRoot/TensorFlow-Book)|4.4k|Accompanying source code for Machine Learning with TensorFlow. Refer to the book for step-by-step explanations.|
|[stanza](https://github.com/stanfordnlp/stanza)|4.4k|Official Stanford NLP Python Library for Many Human Languages|
|[amazon-dsstne](https://github.com/amzn/amazon-dsstne)|4.4k|Deep Scalable Sparse Tensor Network Engine (DSSTNE) is an Amazon developed library for building Deep Learning (DL) ma…|
|[cnn-explainer](https://github.com/poloclub/cnn-explainer)|4.4k|Learning Convolutional Neural Networks with Interactive Visualization.|
|[Realtime_Multi-Person_Pose_Estimation](https://github.com/ZheC/Realtime_Multi-Person_Pose_Estimation)|4.4k|Code repo for realtime multi-person pose estimation in CVPR'17 (Oral)|
|[stanford-cs-230-deep-learning](https://github.com/afshinea/stanford-cs-230-deep-learning)|4.3k|VIP cheatsheets for Stanford's CS 230 Deep Learning|
|[Real-Time-Person-Removal](https://github.com/jasonmayes/Real-Time-Person-Removal)|4.3k|Removing people from complex backgrounds in real time using TensorFlow.js in the web browser|
|[OpenNMT-py](https://github.com/OpenNMT/OpenNMT-py)|4.3k|Open Source Neural Machine Translation in PyTorch|
|[tensorflow_practice](https://github.com/princewen/tensorflow_practice)|4.3k|tensorflow实战练习，包括强化学习、推荐系统、nlp等|
|[pytorch-cnn-visualizations](https://github.com/utkuozbulak/pytorch-cnn-visualizations)|4.2k|Pytorch implementation of convolutional neural network visualization techniques|
|[tensorspace](https://github.com/tensorspace-team/tensorspace)|4.2k|Neural network 3D visualization framework, build interactive and intuitive model in browsers, support pre-trained deep …|
|[DeepLearningExamples](https://github.com/NVIDIA/DeepLearningExamples)|4.2k|Deep Learning Examples|
|[sketch-code](https://github.com/ashnkumar/sketch-code)|4.2k|Keras model to generate HTML code from hand-drawn website mockups. Implements an image captioning architecture to dra…|
|[deeplearning-papernotes](https://github.com/dennybritz/deeplearning-papernotes)|4.2k|Summaries and notes on Deep Learning research papers|
|[apex](https://github.com/NVIDIA/apex)|4.2k|A PyTorch Extension: Tools for easy mixed precision and distributed training in Pytorch|
|[AlphaPose](https://github.com/MVIG-SJTU/AlphaPose)|4.1k|Real-Time and Accurate Multi-Person Pose Estimation&Tracking System|
|[attention-is-all-you-need-pytorch](https://github.com/jadore801120/attention-is-all-you-need-pytorch)|4.1k|A PyTorch implementation of the Transformer model in "Attention is All You Need".|
|[nmap](https://github.com/nmap/nmap)|4.1k|Nmap - the Network Mapper. Github mirror of official SVN repository.|
|[Machine-learning-learning-notes](https://github.com/Vay-keen/Machine-learning-learning-notes)|4.1k|周志华《机器学习》又称西瓜书是一本较为全面的书籍，书中详细介绍了机器学习领域不同类型的算法(例如：监督学习、无监督学习、半监督学习、强化学习、集成降维、特征选择等)，记录了本人在学习过程中的理解思路与扩展知识点，希望对新人阅读西瓜书有…|
|[serenata-de-amor](https://github.com/okfn-brasil/serenata-de-amor)|4.1k|🕵 Artificial Intelligence for social control of public administration|
|[practical-pytorch](https://github.com/spro/practical-pytorch)|4.1k|DEPRECATED and not maintained - see official repo at https://github.com/pytorch/tutorials|
|[pytorch-image-models](https://github.com/rwightman/pytorch-image-models)|4.1k|PyTorch image models, scripts, pretrained weights -- (SE)ResNet/ResNeXT, DPN, EfficientNet, MixNet, MobileNet-V3/V2, MNASNet, Single-Path NAS, FBNet, and more|
|[face-alignment](https://github.com/1adrianb/face-alignment)|4k|🔥 2D and 3D Face alignment library build using pytorch|
|[learning-to-learn](https://github.com/deepmind/learning-to-learn)|4k|Learning to Learn in TensorFlow|
|[machine-learning-notes](https://github.com/roboticcam/machine-learning-notes)|4k|My continuously updated Machine Learning, Probabilistic Models and Deep Learning notes and demos (1500+ slides) 我不间断更…|
|[umap](https://github.com/lmcinnes/umap)|4k|Uniform Manifold Approximation and Projection|
|[DeepLearningZeroToAll](https://github.com/hunkim/DeepLearningZeroToAll)|4k|TensorFlow Basic Tutorial Labs|
|[gluon-cv](https://github.com/dmlc/gluon-cv)|4k|Gluon CV Toolkit|
|[pipeline](https://github.com/PipelineAI/pipeline)|4k|PipelineAI Kubeflow Distribution|
|[snorkel](https://github.com/snorkel-team/snorkel)|4k|A system for quickly generating training data with weak supervision|
|[DIGITS](https://github.com/NVIDIA/DIGITS)|4k|Deep Learning GPU Training System|
|[DenseNet](https://github.com/liuzhuang13/DenseNet)|4k|Densely Connected Convolutional Networks, In CVPR 2017 (Best Paper Award).|
|[awesome-project-ideas](https://github.com/NirantK/awesome-project-ideas)|4k|Curated list of Machine Learning, NLP, Vision, Recommender Systems Project Ideas|
|[tutorials](https://github.com/pytorch/tutorials)|4k|PyTorch tutorials.|
|[Deep-Learning-21-Examples](https://github.com/hzy46/Deep-Learning-21-Examples)|3.9k|《21个项目玩转深度学习———基于TensorFlow的实践详解》配套代码|
|[DeepLearningTutorials](https://github.com/lisa-lab/DeepLearningTutorials)|3.9k|Deep Learning Tutorial notes and code. See the wiki for more info.|
|[textgenrnn](https://github.com/minimaxir/textgenrnn)|3.9k|Easily train your own text-generating neural network of any size and complexity on any text dataset with a few lines …|
|[lucid](https://github.com/tensorflow/lucid)|3.8k|A collection of infrastructure and tools for research in neural network interpretability.|
|[nsfwjs](https://github.com/infinitered/nsfwjs)|3.8k|NSFW detection on the client-side via TensorFlow.js|
|[ssd.pytorch](https://github.com/amdegroot/ssd.pytorch)|3.8k|A PyTorch Implementation of Single Shot MultiBox Detector|
|[MachineLearning](https://github.com/wepe/MachineLearning)|3.8k|Basic Machine Learning and Deep Learning|
|[Tensorflow-Tutorial](https://github.com/MorvanZhou/Tensorflow-Tutorial)|3.8k|Tensorflow tutorial from basic to hard|
|[awesome-ml-for-cybersecurity](https://github.com/jivoi/awesome-ml-for-cybersecurity)|3.8k|Machine Learning for Cyber Security|
|[daily-paper-computer-vision](https://github.com/amusi/daily-paper-computer-vision)|3.8k|记录每天整理的计算机视觉/深度学习/机器学习相关方向的论文|
|[SSD-Tensorflow](https://github.com/balancap/SSD-Tensorflow)|3.8k|Single Shot MultiBox Detector in TensorFlow|
|[cvat](https://github.com/opencv/cvat)|3.8k|Powerful and efficient Computer Vision Annotation Tool (CVAT)|
|[deep-learning-roadmap](https://github.com/machinelearningmindset/deep-learning-roadmap)|3.8k|📡 All You Need to Know About Deep Learning - A kick-starter|
|[sqlflow](https://github.com/sql-machine-learning/sqlflow)|3.8k|Brings SQL and AI together.|
|[mmf](https://github.com/facebookresearch/mmf)|3.7k|A modular framework for vision & language multimodal research from Facebook AI Research (FAIR)|
|[tensorflow-docs](https://github.com/xitu/tensorflow-docs)|3.7k|TensorFlow 最新官方文档中文版|
|[iGAN](https://github.com/junyanz/iGAN)|3.7k|Interactive Image Generation via Generative Adversarial Networks|
|[CapsNet-Tensorflow](https://github.com/naturomics/CapsNet-Tensorflow)|3.7k|A Tensorflow implementation of CapsNet(Capsules Net) in paper Dynamic Routing Between Capsules|
|[Yet-Another-EfficientDet-Pytorch](https://github.com/zylo117/Yet-Another-EfficientDet-Pytorch)|3.6k|The pytorch re-implement of the official efficientdet with SOTA performance in real time and pretrained weights.|
|[pytorch-examples](https://github.com/jcjohnson/pytorch-examples)|3.6k|Simple examples to introduce PyTorch|
|[ML_for_Hackers](https://github.com/johnmyleswhite/ML_for_Hackers)|3.6k|Code accompanying the book "Machine Learning for Hackers"|
|[docs](https://github.com/tensorflow/docs)|3.6k|TensorFlow documentation|
|[tensorflow-generative-model-collections](https://github.com/hwalsuklee/tensorflow-generative-model-collections)|3.6k|Collection of generative models in Tensorflow|
|[DeepLearning.ai-Summary](https://github.com/mbadry1/DeepLearning.ai-Summary)|3.6k|This repository contains my personal notes and summaries on DeepLearning.ai specialization courses. I've enjoyed ever…|
|[BERT-pytorch](https://github.com/codertimo/BERT-pytorch)|3.6k|Google AI 2018 BERT pytorch implementation|
|[pwnagotchi](https://github.com/evilsocket/pwnagotchi)|3.5k|(⌐■_■) - Deep Reinforcement Learning instrumenting bettercap for WiFi pwning.|
|[HyperLPR](https://github.com/zeusees/HyperLPR)|3.5k|基于深度学习高性能中文车牌识别 High Performance Chinese License Plate Recognition Framework.|
|[deep-learning](https://github.com/udacity/deep-learning)|3.5k|Repo for the Deep Learning Nanodegree Foundations program.|
|[TensorFlowOnSpark](https://github.com/yahoo/TensorFlowOnSpark)|3.5k|TensorFlowOnSpark brings TensorFlow programs to Apache Spark clusters.|
|[BigDL](https://github.com/intel-analytics/BigDL)|3.5k|BigDL: Distributed Deep Learning Framework for Apache Spark|
|[AlgoWiki](https://github.com/vicky002/AlgoWiki)|3.5k|Repository which contains links and resources on different topics of Computer Science.|
|[examples](https://github.com/tensorflow/examples)|3.5k|TensorFlow examples|
|[tf-faster-rcnn](https://github.com/endernewton/tf-faster-rcnn)|3.4k|Tensorflow Faster RCNN for Object Detection|
|[tf-pose-estimation](https://github.com/ildoonet/tf-pose-estimation)|3.4k|Deep Pose Estimation implemented using Tensorflow with Custom Architectures for fast inference.|
|[awesome-machine-learning-cn](https://github.com/jobbole/awesome-machine-learning-cn)|3.4k|机器学习资源大全中文版，包括机器学习领域的框架、库以及软件|
|[metaflow](https://github.com/Netflix/metaflow)|3.4k|Build and manage real-life data science projects with ease.|
|[deep-reinforcement-learning](https://github.com/udacity/deep-reinforcement-learning)|3.3k|Repo for the Deep Reinforcement Learning Nanodegree program|
|[semantic-segmentation-pytorch](https://github.com/CSAILVision/semantic-segmentation-pytorch)|3.3k|Pytorch implementation for Semantic Segmentation/Scene Parsing on MIT ADE20K dataset|
|[gocv](https://github.com/hybridgroup/gocv)|3.3k|Go package for computer vision using OpenCV 4 and beyond.|
|[d2l-pytorch](https://github.com/dsgiitr/d2l-pytorch)|3.3k|This project reproduces the book Dive Into Deep Learning (www.d2l.ai), adapting the code from MXNet into PyTorch.|
|[Chinese-BERT-wwm](https://github.com/ymcui/Chinese-BERT-wwm)|3.3k|Pre-Training with Whole Word Masking for Chinese BERT（中文BERT-wwm系列模型）|
|[SmartCropper](https://github.com/pqpo/SmartCropper)|3.3k|🔥 A library for cropping image in a smart way that can identify the border and correct the cropped image. 智能图片裁剪框架。自动识别边框，手动调节选区，使用透视变换裁剪并矫正选区；适用于身份证，名片，文档等照片的裁剪。|
|[PyTorchZeroToAll](https://github.com/hunkim/PyTorchZeroToAll)|3.3k|Simple PyTorch Tutorials Zero to ALL!|
|[pyAudioAnalysis](https://github.com/tyiannak/pyAudioAnalysis)|3.3k|Python Audio Analysis Library: Feature Extraction, Classification, Segmentation and Applications|
|[InterpretableMLBook](https://github.com/MingchaoZhu/InterpretableMLBook)|3.3k|《可解释的机器学习--黑盒模型可解释性理解指南》，该书为《Interpretable Machine Learning》中文版|
|[snips-nlu](https://github.com/snipsco/snips-nlu)|3.3k|Snips Python library to extract meaning from text|
|[pyod](https://github.com/yzhao062/pyod)|3.3k|A Python Toolbox for Scalable Outlier Detection (Anomaly Detection)|
|[DeepLearning](https://github.com/Mikoto10032/DeepLearning)|3.2k|深度学习入门教程, 优秀文章, Deep Learning Tutorial|
|[vespa](https://github.com/vespa-engine/vespa)|3.2k|Vespa is an engine for low-latency computation over large data sets.|
|[deep-voice-conversion](https://github.com/andabi/deep-voice-conversion)|3.2k|Deep neural networks for voice conversion (voice style transfer) in Tensorflow|
|[lightfm](https://github.com/lyst/lightfm)|3.2k|A Python implementation of LightFM, a hybrid recommendation algorithm.|
|[machine-learning](https://github.com/udacity/machine-learning)|3.2k|Content for Udacity's Machine Learning curriculum|
|[skflow](https://github.com/tensorflow/skflow)|3.2k|Simplified interface for TensorFlow (mimicking Scikit Learn) for Deep Learning|
|[Tensorflow-Project-Template](https://github.com/MrGemy95/Tensorflow-Project-Template)|3.2k|A best practice for tensorflow project template architecture.|
|[EasyOCR](https://github.com/JaidedAI/EasyOCR)|3.2k|Ready-to-use OCR with 40+ languages supported including Chinese, Japanese, Korean and Thai|
|[text-classification-cnn-rnn](https://github.com/gaussic/text-classification-cnn-rnn)|3.1k|CNN-RNN中文文本分类，基于TensorFlow|
|[MachineLearning_Python](https://github.com/lawlite19/MachineLearning_Python)|3.1k|机器学习算法python实现|
|[imagededup](https://github.com/idealo/imagededup)|3.1k|😎 Finding duplicate images made easy!|
|[MatchZoo](https://github.com/NTMC-Community/MatchZoo)|3.1k|Facilitating the design, comparison and sharing of deep text matching models.|
|[transformer](https://github.com/Kyubyong/transformer)|3.1k|A TensorFlow Implementation of the Transformer: Attention Is All You Need|
|[tensorflow_poems](https://github.com/jinfagang/tensorflow_poems)|3.1k|中文古诗自动作诗机器人，屌炸天，基于tensorflow1.10 api，正在积极维护升级中，快star，保持更新！|
|[Deep-Learning-Roadmap](https://github.com/astorfi/Deep-Learning-Roadmap)|3.1k|📡 Organized Resources for Deep Learning Researchers and Developers|
|[label-studio](https://github.com/heartexlabs/label-studio)|3.1k|Label Studio is a multi-type data labeling and annotation tool with standardized output format|
|[ASRT_SpeechRecognition](https://github.com/nl8590687/ASRT_SpeechRecognition)|3.1k|A Deep-Learning-Based Chinese Speech Recognition System 基于深度学习的中文语音识别系统|
|[benchmark_results](https://github.com/foolwood/benchmark_results)|3.1k|Visual Tracking Paper List|
|[Machine-Learning](https://github.com/Jack-Cherish/Machine-Learning)|3k|⚡机器学习实战（Python3）：kNN、决策树、贝叶斯、逻辑回归、SVM、线性回归、树回归|
|[yolact](https://github.com/dbolya/yolact)|3k|A simple, fully convolutional model for real-time instance segmentation.|
|[trfl](https://github.com/deepmind/trfl)|3k|TensorFlow Reinforcement Learning|
|[pytorch-cifar](https://github.com/kuangliu/pytorch-cifar)|3k|95.16% on CIFAR10 with PyTorch|
|[sacred](https://github.com/IDSIA/sacred)|3k|Sacred is a tool to help you configure, organize, log and reproduce experiments developed at IDSIA.|
|[yolov5](https://github.com/ultralytics/yolov5)|3k|YOLOv5 in PyTorch > ONNX > CoreML > iOS|
|[Reinforcement-Learning](https://github.com/andri27-ts/Reinforcement-Learning)|3k|Learn Deep Reinforcement Learning in 60 days! Lectures & Code in Python. Reinforcement Learning + Deep Learning|
|[distiller](https://github.com/NervanaSystems/distiller)|3k|Neural Network Distiller by Intel AI Lab: a Python package for neural network compression research. https://nervanasy…|
|[FastMaskRCNN](https://github.com/CharlesShang/FastMaskRCNN)|3k|Mask RCNN in TensorFlow|
|[probability](https://github.com/tensorflow/probability)|3k|Probabilistic reasoning and statistical analysis in TensorFlow|
|[DeepVideoAnalytics](https://github.com/AKSHAYUBHAT/DeepVideoAnalytics)|2.9k|A distributed visual search and visual data analytics platform.|
|[tensorwatch](https://github.com/microsoft/tensorwatch)|2.9k|Debugging, monitoring and visualization for Python Machine Learning and Data Science|
|[darts](https://github.com/quark0/darts)|2.9k|Differentiable architecture search for convolutional and recurrent networks|
|[computervision-recipes](https://github.com/microsoft/computervision-recipes)|2.9k|Best Practices, code samples, and documentation for Computer Vision.|
|[text-detection-ctpn](https://github.com/eragonruan/text-detection-ctpn)|2.9k|text detection mainly based on ctpn model in tensorflow, id card detect, connectionist text proposal network|
|[tensorflow-windows-wheel](https://github.com/fo40225/tensorflow-windows-wheel)|2.9k|Tensorflow prebuilt binary for Windows|
|[tensorflow-yolov3](https://github.com/YunYang1994/tensorflow-yolov3)|2.9k|🔥 Pure tensorflow Implement of YOLOv3 with support to train your own dataset|
|[zhihu](https://github.com/NELSONZHAO/zhihu)|2.9k|This repo contains the source code in my personal column (https://zhuanlan.zhihu.com/zhaoyeyu), implemented using Python 3.6. Including Natural Language Processing and Computer Vision projects, such as text generation, machine translation, deep convolution GAN and other actual combat code.|
|[BERT-BiLSTM-CRF-NER](https://github.com/macanv/BERT-BiLSTM-CRF-NER)|2.9k|Tensorflow solution of NER task Using BiLSTM-CRF model with Google BERT Fine-tuning And private Server services|
|[TensorFlowSharp](https://github.com/migueldeicaza/TensorFlowSharp)|2.9k|TensorFlow API for .NET languages|
|[ignite](https://github.com/pytorch/ignite)|2.9k|High-level library to help with training and evaluating neural networks in PyTorch flexibly and transparently.|
|[tensorflow-tutorial](https://github.com/caicloud/tensorflow-tutorial)|2.9k|Example TensorFlow codes and Caicloud TensorFlow as a Service dev environment.|
|[100-Days-of-ML-Code-Chinese-Version](https://github.com/Avik-Jain/100-Days-of-ML-Code-Chinese-Version)|2.9k|Chinese Translation for Machine Learning Infographics|
|[deep-learning-papers-translation](https://github.com/SnailTyan/deep-learning-papers-translation)|2.9k|深度学习论文翻译，包括分类论文，检测论文等|
|[DMTK](https://github.com/microsoft/DMTK)|2.8k|Microsoft Distributed Machine Learning Toolkit|
|[caffe-tensorflow](https://github.com/ethereon/caffe-tensorflow)|2.8k|Caffe models in TensorFlow|
|[libpostal](https://github.com/openvenues/libpostal)|2.8k|A C library for parsing/normalizing street addresses around the world. Powered by statistical NLP and open geo data.|
|[pigo](https://github.com/esimov/pigo)|2.8k|Pure Go face detection, pupil/eyes localization and facial landmark points detection library|
|[mindsdb](https://github.com/mindsdb/mindsdb)|2.8k|Machine Learning in one line of code|
|[Tensorflow-Cookbook](https://github.com/taki0112/Tensorflow-Cookbook)|2.8k|Simple Tensorflow Cookbook for easy-to-use|
|[easy-tensorflow](https://github.com/easy-tensorflow/easy-tensorflow)|2.8k|Simple and comprehensive tutorials in TensorFlow|
|[DeepLearning](https://github.com/yusugomori/DeepLearning)|2.8k|Deep Learning (Python, C, C++, Java, Scala, Go)|
|[pytorch-yolo-v3](https://github.com/ayooshkathuria/pytorch-yolo-v3)|2.8k|A PyTorch implementation of the YOLO v3 object detection algorithm|
|[jukebox](https://github.com/openai/jukebox)|2.8k|Code for the paper "Jukebox: A Generative Model for Music"|
|[makegirlsmoe_web](https://github.com/makegirlsmoe/makegirlsmoe_web)|2.8k|Create Anime Characters with MakeGirlsMoe|
|[deep-learning-keras-tensorflow](https://github.com/leriomaggio/deep-learning-keras-tensorflow)|2.8k|Introduction to Deep Neural Networks with Keras and Tensorflow|
|[SiamMask](https://github.com/foolwood/SiamMask)|2.7k|[CVPR2019] Fast Online Object Tracking and Segmentation: A Unifying Approach|
|[tencent-ml-images](https://github.com/Tencent/tencent-ml-images)|2.7k|Largest multi-label image database; ResNet-101 model; 80.73% top-1 acc on ImageNet|
|[DALI](https://github.com/NVIDIA/DALI)|2.7k|A library containing both highly optimized building blocks and an execution engine for data pre-processing in deep le…|
|[shogun](https://github.com/shogun-toolbox/shogun)|2.7k|Shōgun|
|[optuna](https://github.com/optuna/optuna)|2.7k|A hyperparameter optimization framework|
|[Automatic_Speech_Recognition](https://github.com/zzw922cn/Automatic_Speech_Recognition)|2.7k|End-to-end Automatic Speech Recognition for Madarian and English in Tensorflow|
|[pytorch-semseg](https://github.com/meetshah1995/pytorch-semseg)|2.7k|Semantic Segmentation Architectures Implemented in PyTorch|
|[pygcn](https://github.com/tkipf/pygcn)|2.7k|Graph Convolutional Networks in PyTorch|
|[deep-learning-book](https://github.com/rasbt/deep-learning-book)|2.7k|Repository for "Introduction to Artificial Neural Networks and Deep Learning: A Practical Guide with Applications in …|
|[pointnet](https://github.com/charlesq34/pointnet)|2.7k|PointNet: Deep Learning on Point Sets for 3D Classification and Segmentation|
|[CVPR2020-Code](https://github.com/amusi/CVPR2020-Code)|2.7k|CVPR 2020 论文开源项目合集|
|[Detectron.pytorch](https://github.com/roytseng-tw/Detectron.pytorch)|2.7k|A pytorch implementation of Detectron. Both training from scratch and inferring directly from pretrained Detectron we…|
|[LSTM-Human-Activity-Recognition](https://github.com/guillaume-chevalier/LSTM-Human-Activity-Recognition)|2.6k|Human Activity Recognition example using TensorFlow on smartphone sensors dataset and an LSTM RNN. Classifying the type of movement amongst six activity categories - Guillaume Chevalier|
|[neural-style-tf](https://github.com/cysmith/neural-style-tf)|2.6k|TensorFlow (Python API) implementation of Neural Style|
|[Pytorch-UNet](https://github.com/milesial/Pytorch-UNet)|2.6k|PyTorch implementation of the U-Net for image semantic segmentation with high quality images|
|[kornia](https://github.com/kornia/kornia)|2.6k|Open Source Differentiable Computer Vision Library for PyTorch|
|[Ad-papers](https://github.com/wzhe06/Ad-papers)|2.6k|Papers on Computational Advertising|
|[deep-high-resolution-net.pytorch](https://github.com/leoxiaobin/deep-high-resolution-net.pytorch)|2.6k|The project is an official implementation of our CVPR2019 paper "Deep High-Resolution Representation Learning for Hum…|
|[VoTT](https://github.com/microsoft/VoTT)|2.6k|Visual Object Tagging Tool: An electron app for building end to end Object Detection Models from Images and Videos.|
|[espnet](https://github.com/espnet/espnet)|2.6k|End-to-End Speech Processing Toolkit|
|[ltp](https://github.com/HIT-SCIR/ltp)|2.6k|Language Technology Platform|
|[Learn_Deep_Learning_in_6_Weeks](https://github.com/llSourcell/Learn_Deep_Learning_in_6_Weeks)|2.6k|This is the Curriculum for "Learn Deep Learning in 6 Weeks" by Siraj Raval on Youtube|
|[keras-vis](https://github.com/raghakot/keras-vis)|2.6k|Neural network visualization toolkit for keras|
|[onnxruntime](https://github.com/microsoft/onnxruntime)|2.6k|ONNX Runtime: cross-platform, high performance ML inferencing and training accelerator|
|[3DDFA](https://github.com/cleardusk/3DDFA)|2.6k|The PyTorch improved version of TPAMI 2017 paper: Face Alignment in Full Pose Range: A 3D Total Solution.|
|[olivia](https://github.com/olivia-ai/olivia)|2.6k|💁‍♀️Your new best friend powered by an artificial neural network|
|[albert_zh](https://github.com/brightmart/albert_zh)|2.6k|A LITE BERT FOR SELF-SUPERVISED LEARNING OF LANGUAGE REPRESENTATIONS, 海量中文预训练ALBERT模型|
|[ai-deadlines](https://github.com/abhshkdz/ai-deadlines)|2.6k|⏰ AI conference deadline countdowns|
|[opencvsharp](https://github.com/shimat/opencvsharp)|2.5k|.NET Framework wrapper for OpenCV|
|[telegram-list](https://github.com/goq/telegram-list)|2.5k|List of telegram groups, channels & bots // Список интересных групп, каналов и ботов телеграма // Список чатов для программистов|
|[easy12306](https://github.com/zhaipro/easy12306)|2.5k|使用机器学习算法完成对12306验证码的自动识别|
|[rust](https://github.com/tensorflow/rust)|2.5k|Rust language bindings for TensorFlow|
|[miles-deep](https://github.com/ryanjay0/miles-deep)|2.5k|Deep Learning Porn Video Classifier/Editor with Caffe|
|[VisualDL](https://github.com/PaddlePaddle/VisualDL)|2.5k|Deep Learning Visualization Toolkit（『飞桨』深度学习可视化工具 ）|
|[SinGAN](https://github.com/tamarott/SinGAN)|2.5k|Official pytorch implementation of the paper: "SinGAN: Learning a Generative Model from a Single Natural Image"|
|[t81_558_deep_learning](https://github.com/jeffheaton/t81_558_deep_learning)|2.5k|Washington University (in St. Louis) Course T81-558: Applications of Deep Neural Networks|
|[training](https://github.com/cloud-annotations/training)|2.5k|🐝 Custom Object Detection and Classification Training|
|[PocketFlow](https://github.com/Tencent/PocketFlow)|2.5k|An Automatic Model Compression (AutoMC) framework for developing smaller and faster AI applications.|
|[autogluon](https://github.com/awslabs/autogluon)|2.5k|AutoGluon: AutoML Toolkit for Deep Learning|
|[simple-faster-rcnn-pytorch](https://github.com/chenyuntc/simple-faster-rcnn-pytorch)|2.5k|A simplified implemention of Faster R-CNN that replicate performance from origin paper|
|[MITIE](https://github.com/mit-nlp/MITIE)|2.5k|MITIE: library and tools for information extraction|
|[reinforcement-learning](https://github.com/rlcode/reinforcement-learning)|2.5k|Minimal and Clean Reinforcement Learning Examples|
|[ISLR-python](https://github.com/JWarmenhoven/ISLR-python)|2.4k|An Introduction to Statistical Learning (James, Witten, Hastie, Tibshirani, 2013): Python code|
|[EAST](https://github.com/argman/EAST)|2.4k|A tensorflow implementation of EAST text detector|
|[DeepNLP-models-Pytorch](https://github.com/DSKSD/DeepNLP-models-Pytorch)|2.4k|Pytorch implementations of various Deep NLP models in cs-224n(Stanford Univ)|
|[Machine-Learning-with-Python](https://github.com/susanli2016/Machine-Learning-with-Python)|2.4k|Python code for common Machine Learning Algorithms|
|[stanford_dl_ex](https://github.com/amaas/stanford_dl_ex)|2.4k|Programming exercises for the Stanford Unsupervised Feature Learning and Deep Learning Tutorial|
|[tensorflow-internals](https://github.com/horance-liu/tensorflow-internals)|2.4k|It is open source ebook about TensorFlow kernel and implementation mechanism.|
|[DeepLearning](https://github.com/MingchaoZhu/DeepLearning)|2.4k|Python for《Deep Learning》，该书为《深度学习》(花书) 数学推导、原理剖析与源码级别代码实现|
|[text](https://github.com/pytorch/text)|2.4k|Data loaders and abstractions for text and NLP|
|[ALAE](https://github.com/podgorskiy/ALAE)|2.4k|[CVPR2020] Adversarial Latent Autoencoders|
|[pytorch-summary](https://github.com/sksq96/pytorch-summary)|2.4k|Model summary in PyTorch similar to `model.summary()` in Keras|
|[pytorch-doc-zh](https://github.com/apachecn/pytorch-doc-zh)|2.4k|Pytorch 中文文档|
|[Deep_reinforcement_learning_Course](https://github.com/simoninithomas/Deep_reinforcement_learning_Course)|2.4k|Implementations from the free course Deep Reinforcement Learning with Tensorflow|
|[ML-Tutorial-Experiment](https://github.com/jiqizhixin/ML-Tutorial-Experiment)|2.4k|Coding the Machine Learning Tutorial for Learning to Learn|
|[pytorch-Deep-Learning](https://github.com/Atcold/pytorch-Deep-Learning)|2.4k|Deep Learning (with PyTorch)|
|[models](https://github.com/onnx/models)|2.4k|A collection of pre-trained, state-of-the-art models in the ONNX format|
|[book](https://github.com/PaddlePaddle/book)|2.4k|Deep Learning 101 with PaddlePaddle （『飞桨』深度学习框架入门教程）|
|[PyTorch_Tutorial](https://github.com/TingsongYu/PyTorch_Tutorial)|2.4k|《Pytorch模型训练实用教程》中配套代码|
|[Dive-into-DL-TensorFlow2.0](https://github.com/TrickyGo/Dive-into-DL-TensorFlow2.0)|2.4k|本项目将《动手学深度学习》(Dive into Deep Learning)原书中的MXNet实现改为TensorFlow 2.0实现，项目已得到李沐老师的同意|
|[Artificial-Intelligence-Deep-Learning-Machine-Learning-Tutorials](https://github.com/TarrySingh/Artificial-Intelligence-Deep-Learning-Machine-Learning-Tutorials)|2.4k|A comprehensive list of Deep Learning / Artificial Intelligence and Machine Learning tutorials - rapidly expanding in…|
|[segmentation_models](https://github.com/qubvel/segmentation_models)|2.4k|Segmentation models with pretrained backbones. Keras and TensorFlow Keras.|
|[Awesome-PyTorch-Chinese](https://github.com/INTERMT/Awesome-PyTorch-Chinese)|2.3k|【干货】史上最全的PyTorch学习资源汇总|
|[Flux.jl](https://github.com/FluxML/Flux.jl)|2.3k|Relax! Flux is the ML library that doesn't make you tensor|
|[weld](https://github.com/weld-project/weld)|2.3k|High-performance runtime for data analytics applications|
|[PyTorch-BigGraph](https://github.com/facebookresearch/PyTorch-BigGraph)|2.3k|Generate embeddings from large-scale graph-structured data.|
|[byteps](https://github.com/bytedance/byteps)|2.3k|A high performance and generic framework for distributed DNN training|
|[AI-Job-Notes](https://github.com/amusi/AI-Job-Notes)|2.3k|AI算法岗求职攻略（涵盖准备攻略、刷题指南、内推和AI公司清单等资料）|
|[luminoth](https://github.com/tryolabs/luminoth)|2.3k|⚠️ UNMAINTAINED. Deep Learning toolkit for Computer Vision.|
|[Alink](https://github.com/alibaba/Alink)|2.3k|Alink is the Machine Learning algorithm platform based on Flink, developed by the PAI team of Alibaba computing platf…|
|[introtodeeplearning](https://github.com/aamini/introtodeeplearning)|2.3k|Lab Materials for MIT 6.S191: Introduction to Deep Learning|
|[TensorFlow-and-DeepLearning-Tutorial](https://github.com/CreatCodeBuild/TensorFlow-and-DeepLearning-Tutorial)|2.3k|A TensorFlow & Deep Learning online course I taught in 2016|
|[srgan](https://github.com/tensorlayer/srgan)|2.3k|Photo-Realistic Single Image Super-Resolution Using a Generative Adversarial Network|
|[colorization](https://github.com/richzhang/colorization)|2.3k|Automatic colorization using deep neural networks. "Colorful Image Colorization." In ECCV, 2016.|
|[OpenNMT](https://github.com/OpenNMT/OpenNMT)|2.3k|Open Source Neural Machine Translation in Torch (deprecated)|
|[Super-SloMo](https://github.com/avinashpaliwal/Super-SloMo)|2.3k|PyTorch implementation of Super SloMo by Jiang et al.|
|[orange3](https://github.com/biolab/orange3)|2.3k|🍊 📊 💡 Orange: Interactive data analysis https://orange.biolab.si|
|[ENAS-pytorch](https://github.com/carpedm20/ENAS-pytorch)|2.3k|PyTorch implementation of "Efficient Neural Architecture Search via Parameters Sharing"|
|[3D-ResNets-PyTorch](https://github.com/kenshohara/3D-ResNets-PyTorch)|2.3k|3D ResNets for Action Recognition (CVPR 2018)|
|[pomegranate](https://github.com/jmschrei/pomegranate)|2.3k|Fast, flexible and easy to use probabilistic modelling in Python.|
|[Faster-RCNN_TF](https://github.com/smallcorgi/Faster-RCNN_TF)|2.3k|Faster-RCNN in Tensorflow|
|[datascience](https://github.com/r0f1/datascience)|2.3k|Curated list of Python resources for data science.|
|[deep-learning-from-scratch](https://github.com/oreilly-japan/deep-learning-from-scratch)|2.3k|『ゼロから作る Deep Learning』(O'Reilly Japan, 2016)|
|[covid-chestxray-dataset](https://github.com/ieee8023/covid-chestxray-dataset)|2.2k|We are building an open database of COVID-19 cases with chest X-ray or CT images.|
|[deepchem](https://github.com/deepchem/deepchem)|2.2k|Democratizing Deep-Learning for Drug Discovery, Quantum Chemistry, Materials Science and Biology|
|[awesome-learning-resources](https://github.com/lauragift21/awesome-learning-resources)|2.2k|🔥 Awesome list of resources on Web Development.|
|[omniscidb](https://github.com/omnisci/omniscidb)|2.2k|OmniSciDB (formerly MapD Core)|
|[tablesaw](https://github.com/jtablesaw/tablesaw)|2.2k|Java dataframe and visualization library|
|[Semantic-Segmentation-Suite](https://github.com/GeorgeSeif/Semantic-Segmentation-Suite)|2.2k|Semantic Segmentation Suite in TensorFlow. Implement, train, and test new Semantic Segmentation models easily!|
|[FCOS](https://github.com/tianzhi0549/FCOS)|2.2k|FCOS: Fully Convolutional One-Stage Object Detection (ICCV'19)|
|[spotlight](https://github.com/maciejkula/spotlight)|2.2k|Deep recommender models using PyTorch.|
|[datasets](https://github.com/tensorflow/datasets)|2.2k|TFDS is a collection of datasets ready to use with TensorFlow, Jax, ...|
|[Deep-Learning-for-Recommendation-Systems](https://github.com/robi56/Deep-Learning-for-Recommendation-Systems)|2.2k|This repository contains Deep Learning based articles , paper and repositories for Recommender Systems|
|[gluon-nlp](https://github.com/dmlc/gluon-nlp)|2.1k|NLP made easy|
|[dowhy](https://github.com/microsoft/dowhy)|2.1k|DoWhy is a Python library for causal inference that supports explicit modeling and testing of causal assumptions. DoWhy is based on a unified language for causal inference, combining causal graphical models and potential outcomes frameworks.|
|[keras-attention-mechanism](https://github.com/philipperemy/keras-attention-mechanism)|2.1k|Attention mechanism Implementation for Keras.|
|[Meta-Learning-Papers](https://github.com/floodsung/Meta-Learning-Papers)|2.1k|Meta Learning / Learning to Learn / One Shot Learning / Few Shot Learning|
|[tacotron](https://github.com/keithito/tacotron)|2.1k|A TensorFlow implementation of Google's Tacotron speech synthesis with pre-trained model (unofficial)|
|[machinelearninginaction](https://github.com/pbharrin/machinelearninginaction)|2.1k|Source Code for the book: Machine Learning in Action published by Manning|
|[BuildingMachineLearningSystemsWithPython](https://github.com/luispedro/BuildingMachineLearningSystemsWithPython)|2.1k|Source Code for the book Building Machine Learning Systems with Python|
|[CHINESE-OCR](https://github.com/xiaofengShi/CHINESE-OCR)|2.1k|[python3.6] 运用tf实现自然场景文字检测,keras/pytorch实现ctpn+crnn+ctc实现不定长场景文字OCR识别|
|[deepdetect](https://github.com/jolibrain/deepdetect)|2.1k|Deep Learning API and Server in C++11 support for Caffe, Caffe2, PyTorch,TensorRT, Dlib, NCNN, Tensorflow, XGBoost an…|
|[XLM](https://github.com/facebookresearch/XLM)|2.1k|PyTorch original implementation of Cross-lingual Language Model Pretraining.|
|[tensorflow-on-raspberry-pi](https://github.com/samjabrahams/tensorflow-on-raspberry-pi)|2.1k|TensorFlow for Raspberry Pi|
|[decaNLP](https://github.com/salesforce/decaNLP)|2.1k|The Natural Language Decathlon: A Multitask Challenge for NLP|
|[AlphaZero_Gomoku](https://github.com/junxiaosong/AlphaZero_Gomoku)|2.1k|An implementation of the AlphaZero algorithm for Gomoku (also called Gobang or Five in a Row)|
|[pytorch-beginner](https://github.com/L1aoXingyu/pytorch-beginner)|2.1k|pytorch tutorial for beginners|
|[tangent](https://github.com/google/tangent)|2.1k|Source-to-Source Debuggable Derivatives in Pure Python|
|[Person_reID_baseline_pytorch](https://github.com/layumi/Person_reID_baseline_pytorch)|2.1k|A tiny, friendly, strong pytorch implement of person re-identification baseline. Tutorial 👉https://github.com/layumi/…|
|[mmlspark](https://github.com/Azure/mmlspark)|2k|Microsoft Machine Learning for Apache Spark|
|[FATE](https://github.com/FederatedAI/FATE)|2k|An Industrial Level Federated Learning Framework|
|[text-to-image](https://github.com/paarthneekhara/text-to-image)|2k|Text to image synthesis using thought vectors|
|[pytorch-sentiment-analysis](https://github.com/bentrevett/pytorch-sentiment-analysis)|2k|Tutorials on getting started with PyTorch and TorchText for sentiment analysis.|
|[ELF](https://github.com/facebookresearch/ELF)|2k|An End-To-End, Lightweight and Flexible Platform for Game Research|
|[catalyst](https://github.com/catalyst-team/catalyst)|2k|Accelerated DL R&D|
|[neuralcoref](https://github.com/huggingface/neuralcoref)|2k|✨Fast Coreference Resolution in spaCy with Neural Networks|
|[DeepRL-Agents](https://github.com/awjuliani/DeepRL-Agents)|2k|A set of Deep Reinforcement Learning Agents implemented in Tensorflow.|
|[RL-Adventure](https://github.com/higgsfield/RL-Adventure)|2k|Pytorch Implementation of DQN / DDQN / Prioritized replay/ noisy networks/ distributional values/ Rainbow/ hierarchic…|
|[fe4ml-zh](https://github.com/apachecn/fe4ml-zh)|2k|📖 [译] 面向机器学习的特征工程|
|[lingvo](https://github.com/tensorflow/lingvo)|2k|Lingvo|
|[pytorch-generative-model-collections](https://github.com/znxlwm/pytorch-generative-model-collections)|2k|Collection of generative models in Pytorch version.|
|[ResNeSt](https://github.com/zhanghang1989/ResNeSt)|2k|ResNeSt: Split-Attention Networks|
|[TensorFlow-Tutorials](https://github.com/golbin/TensorFlow-Tutorials)|2k|텐서플로우를 기초부터 응용까지 단계별로 연습할 수 있는 소스 코드를 제공합니다|
|[MUNIT](https://github.com/NVlabs/MUNIT)|2k|Multimodal Unsupervised Image-to-Image Translation|
|[oneDNN](https://github.com/oneapi-src/oneDNN)|2k|oneAPI Deep Neural Network Library (oneDNN)|
|[deepvariant](https://github.com/google/deepvariant)|2k|DeepVariant is an analysis pipeline that uses a deep neural network to call genetic variants from next-generation DNA sequencing data.|
|[texar](https://github.com/asyml/texar)|2k|Toolkit for Machine Learning, Natural Language Processing, and Text Generation, in TensorFlow|
|[kaolin](https://github.com/NVIDIAGameWorks/kaolin)|2k|A PyTorch Library for Accelerating 3D Deep Learning Research|
|[Clairvoyant](https://github.com/anfederico/Clairvoyant)|2k|Software designed to identify and monitor social/historical cues for short term stock movement|
|[implicit](https://github.com/benfred/implicit)|2k|Fast Python Collaborative Filtering for Implicit Feedback Datasets|
|[DeepRL](https://github.com/ShangtongZhang/DeepRL)|2k|Modularized Implementation of Deep RL Algorithms in PyTorch|
|[lgo](https://github.com/yunabe/lgo)|2k|Interactive Go programming with Jupyter|
|[kcws](https://github.com/koth/kcws)|2k|Deep Learning Chinese Word Segment|
|[tensorflow-build-archived](https://github.com/lakshayg/tensorflow-build-archived)|2k|TensorFlow binaries supporting AVX, FMA, SSE|
|[dm_control](https://github.com/deepmind/dm_control)|2k|DeepMind's software stack for physics-based simulation and Reinforcement Learning environments, using MuJoCo.|
|[gpytorch](https://github.com/cornellius-gp/gpytorch)|2k|A highly efficient and modular implementation of Gaussian Processes in PyTorch|
|[Neural-Photo-Editor](https://github.com/ajbrock/Neural-Photo-Editor)|1.9k|A simple interface for editing natural photos with generative neural networks.|
|[alpha-zero-general](https://github.com/suragnair/alpha-zero-general)|1.9k|A clean implementation based on AlphaZero for any game in any framework + tutorial + Othello/Gobang/TicTacToe/Connect4|
|[tacotron2](https://github.com/NVIDIA/tacotron2)|1.9k|Tacotron 2 - PyTorch implementation with faster-than-realtime inference|
|[siamese-triplet](https://github.com/adambielski/siamese-triplet)|1.9k|Siamese and triplet networks with online pair/triplet mining in PyTorch|
|[awesome-quant](https://github.com/thuquant/awesome-quant)|1.9k|中国的Quant相关资源索引|
|[image-super-resolution](https://github.com/idealo/image-super-resolution)|1.9k|🔎 Super-scale your images and run experiments with Residual Dense and Adversarial Networks.|
|[generative_inpainting](https://github.com/JiahuiYu/generative_inpainting)|1.9k|DeepFill v1/v2 with Contextual Attention and Gated Convolution, CVPR 2018, and ICCV 2019 Oral|
|[code-of-learn-deep-learning-with-pytorch](https://github.com/L1aoXingyu/code-of-learn-deep-learning-with-pytorch)|1.9k|This is code of book "Learn Deep Learning with PyTorch"|
|[gpt-2-simple](https://github.com/minimaxir/gpt-2-simple)|1.9k|Python package to easily retrain OpenAI's GPT-2 text-generating model on new texts|
|[DeepInterests](https://github.com/Honlan/DeepInterests)|1.9k|深度有趣|
|[segmentation_models.pytorch](https://github.com/qubvel/segmentation_models.pytorch)|1.9k|Segmentation models with pretrained backbones. PyTorch.|
|[human-pose-estimation.pytorch](https://github.com/microsoft/human-pose-estimation.pytorch)|1.9k|The project is an official implement of our ECCV2018 paper "Simple Baselines for Human Pose Estimation and Tracking(h…|
|[BigGAN-PyTorch](https://github.com/ajbrock/BigGAN-PyTorch)|1.9k|The author's officially unofficial PyTorch BigGAN implementation.|
|[pytorch-playground](https://github.com/aaron-xichen/pytorch-playground)|1.9k|Base pretrained models and datasets in pytorch (MNIST, SVHN, CIFAR10, CIFAR100, STL10, AlexNet, VGG16, VGG19, ResNet, Inception, SqueezeNet)|
|[bertviz](https://github.com/jessevig/bertviz)|1.9k|Tool for visualizing attention in the Transformer model (BERT, GPT-2, Albert, XLNet, RoBERTa, CTRL, etc.)|
|[face.evoLVe.PyTorch](https://github.com/ZhaoJ9014/face.evoLVe.PyTorch)|1.9k|🔥🔥High-Performance Face Recognition Library on PyTorch🔥🔥|
|[Reco-papers](https://github.com/wzhe06/Reco-papers)|1.8k|Classic papers and resources on recommendation|
|[coach](https://github.com/NervanaSystems/coach)|1.8k|Reinforcement Learning Coach by Intel AI Lab enables easy experimentation with state of the art Reinforcement Learning algorithms|
|[sling](https://github.com/google/sling)|1.8k|SLING - A natural language frame semantics parser|
|[pytorch-deeplab-xception](https://github.com/jfzhang95/pytorch-deeplab-xception)|1.8k|DeepLab v3+ model in PyTorch. Support different backbones.|
|[mmskeleton](https://github.com/open-mmlab/mmskeleton)|1.8k|A OpenMMLAB toolbox for human pose estimation, skeleton-based action recognition, and action synthesis.|
|[sru](https://github.com/asappresearch/sru)|1.8k|Training RNNs as Fast as CNNs (https://arxiv.org/abs/1709.02755)|
|[pytorch-seq2seq](https://github.com/bentrevett/pytorch-seq2seq)|1.8k|Tutorials on implementing a few sequence-to-sequence (seq2seq) models with PyTorch and TorchText.|
|[Deep-Learning-Interview-Book](https://github.com/amusi/Deep-Learning-Interview-Book)|1.8k|深度学习面试宝典（含数学、机器学习、深度学习、计算机视觉、自然语言处理和SLAM等方向）|
|[pai](https://github.com/microsoft/pai)|1.8k|Resource scheduling and cluster management for AI|
|[AI-Blocks](https://github.com/MrNothing/AI-Blocks)|1.8k|A powerful and intuitive WYSIWYG interface that allows anyone to create Machine Learning models!|
|[scikit-optimize](https://github.com/scikit-optimize/scikit-optimize)|1.8k|Sequential model-based optimization with a `scipy.optimize` interface|
|[sequence_tagging](https://github.com/guillaumegenthial/sequence_tagging)|1.8k|Named Entity Recognition (LSTM + CRF) - Tensorflow|
|[zh-NER-TF](https://github.com/Determined22/zh-NER-TF)|1.8k|A very simple BiLSTM-CRF model for Chinese Named Entity Recognition 中文命名实体识别 (TensorFlow)|
|[donkeycar](https://github.com/autorope/donkeycar)|1.8k|Open source hardware and software platform to build a small scale self driving car.|
|[edge-connect](https://github.com/knazeri/edge-connect)|1.8k|EdgeConnect: Structure Guided Image Inpainting using Edge Prediction, ICCV 2019 https://arxiv.org/abs/1901.00212|
|[awd-lstm-lm](https://github.com/salesforce/awd-lstm-lm)|1.7k|LSTM and QRNN Language Model Toolkit for PyTorch|
|[pytorch-kaldi](https://github.com/mravanelli/pytorch-kaldi)|1.7k|pytorch-kaldi is a project for developing state-of-the-art DNN/RNN hybrid speech recognition systems. The DNN part is managed by pytorch, while feature extraction, label computation, and decoding are performed with the kaldi toolkit.|
|[Bender](https://github.com/xmartlabs/Bender)|1.7k|Easily craft fast Neural Networks on iOS! Use TensorFlow models. Metal under the hood.|
|[zi2zi](https://github.com/kaonashi-tyc/zi2zi)|1.7k|Learning Chinese Character style with conditional GAN|
|[automl-gs](https://github.com/minimaxir/automl-gs)|1.7k|Provide an input CSV and a target field to predict, generate a model + code to run it.|
|[stats](https://github.com/montanaflynn/stats)|1.7k|A well tested and comprehensive Golang statistics library package with no dependencies.|
|[ranking](https://github.com/tensorflow/ranking)|1.7k|Learning to Rank in TensorFlow|
|[mathAI](https://github.com/Roujack/mathAI)|1.7k|一个拍照做题程序。输入一张包含数学计算题的图片，输出识别出的数学计算式以及计算结果。This is a mathematic expression recognition project.|
|[spark-ml-source-analysis](https://github.com/endymecy/spark-ml-source-analysis)|1.7k|spark ml 算法原理剖析以及具体的源码实现分析|
|[video-object-removal](https://github.com/zllrunning/video-object-removal)|1.7k|Just draw a bounding box and you can remove the object you want to remove.|
|[datascience-pizza](https://github.com/PizzaDeDados/datascience-pizza)|1.7k|🍕 Repositório para juntar informações sobre materiais de estudo em análise de dados e áreas afins, empresas que trabalham com dados e dicionário de conceitos|
|[data-science-interviews](https://github.com/alexeygrigorev/data-science-interviews)|1.7k|Data science interview questions and answers|
|[yolov3-tf2](https://github.com/zzh8829/yolov3-tf2)|1.7k|YoloV3 Implemented in Tensorflow 2.0|
|[ComputeLibrary](https://github.com/ARM-software/ComputeLibrary)|1.7k|The ARM Computer Vision and Machine Learning library is a set of functions optimised for both ARM CPUs and GPUs using SIMD technologies.|
|[tacotron](https://github.com/Kyubyong/tacotron)|1.7k|A TensorFlow Implementation of Tacotron: A Fully End-to-End Text-To-Speech Synthesis Model|
|[DeepLearn](https://github.com/GauravBh1010tt/DeepLearn)|1.7k|Implementation of research papers on Deep Learning+ NLP+ CV in Python using Keras, Tensorflow and Scikit Learn.|
|[analytics-zoo](https://github.com/intel-analytics/analytics-zoo)|1.7k|Distributed Tensorflow, Keras and PyTorch on Apache Spark/Flink & Ray|
|[PyTorch-NLP](https://github.com/PetrochukM/PyTorch-NLP)|1.7k|Basic Utilities for PyTorch Natural Language Processing (NLP)|
|[captcha_break](https://github.com/ypwhs/captcha_break)|1.7k|验证码识别|
|[crnn](https://github.com/bgshih/crnn)|1.7k|Convolutional Recurrent Neural Network (CRNN) for image-based sequence recognition.|
|[DeblurGAN](https://github.com/KupynOrest/DeblurGAN)|1.7k|Image Deblurring using Generative Adversarial Networks|
|[robosat](https://github.com/mapbox/robosat)|1.6k|Semantic segmentation on aerial and satellite imagery. Extracts features such as: buildings, parking lots, roads, water, clouds|
|[pointnet2](https://github.com/charlesq34/pointnet2)|1.6k|PointNet++: Deep Hierarchical Feature Learning on Point Sets in a Metric Space|
|[AutonomousDrivingCookbook](https://github.com/microsoft/AutonomousDrivingCookbook)|1.6k|Scenarios, tutorials and demos for Autonomous Driving|
|[imgclsmob](https://github.com/osmr/imgclsmob)|1.6k|Sandbox for training convolutional networks for computer vision|
|[tf_unet](https://github.com/jakeret/tf_unet)|1.6k|Generic U-Net Tensorflow implementation for image segmentation|
|[torchsample](https://github.com/ncullen93/torchsample)|1.6k|High-Level Training, Data Augmentation, and Utilities for Pytorch|
|[nlp](https://github.com/huggingface/nlp)|1.6k|🤗nlp – Datasets and evaluation metrics for Natural Language Processing in NumPy, Pandas, PyTorch and TensorFlow|
|[hdbscan](https://github.com/scikit-learn-contrib/hdbscan)|1.6k|A high performance implementation of HDBSCAN clustering.|
|[m2cgen](https://github.com/BayesWitnesses/m2cgen)|1.6k|Transform ML models into a native code (Java, C, Python, Go, JavaScript, Visual Basic, C#, R, PowerShell, PHP, Dart, Haskell, Ruby) with zero dependencies|
|[fastNLP](https://github.com/fastnlp/fastNLP)|1.6k|fastNLP: A Modularized and Extensible NLP Framework. Currently still in incubation.|
|[keras-yolo2](https://github.com/experiencor/keras-yolo2)|1.6k|Easy training on custom dataset. Various backends (MobileNet and SqueezeNet) supported. A YOLO demo to detect raccoon run entirely in brower is accessible at https://git.io/vF7vI (not on Windows).|
|[Awesome-Chatbot](https://github.com/fendouai/Awesome-Chatbot)|1.6k|Awesome Chatbot Projects,Corpus,Papers,Tutorials.Chinese Chatbot =>:|
|[knockknock](https://github.com/huggingface/knockknock)|1.6k|🚪✊Knock Knock: Get notified when your training ends with only two additional lines of code|
|[MTBook](https://github.com/NiuTrans/MTBook)|1.6k|《机器翻译：统计建模与深度学习方法》肖桐 朱靖波 著 - Machine Translation: Statistical Modeling and Deep Learning Methods|
|[trains](https://github.com/allegroai/trains)|1.6k|TRAINS - Auto-Magical Experiment Manager & Version Control for AI - NOW WITH AUTO-MAGICAL DEVOPS!|
|[self-driving-car](https://github.com/ndrplz/self-driving-car)|1.6k|Udacity Self-Driving Car Engineer Nanodegree projects.|
|[cnn_captcha](https://github.com/nickliqian/cnn_captcha)|1.6k|use cnn recognize captcha by tensorflow. 本项目针对字符型图片验证码，使用tensorflow实现卷积神经网络，进行验证码识别。|
|[XLearning](https://github.com/Qihoo360/XLearning)|1.6k|AI on Hadoop|
|[Tacotron-2](https://github.com/Rayhane-mamah/Tacotron-2)|1.6k|DeepMind's Tacotron-2 Tensorflow implementation|
|[fast-wavenet](https://github.com/tomlepaine/fast-wavenet)|1.6k|Speedy Wavenet generation using dynamic programming ⚡|
|[spacy-course](https://github.com/ines/spacy-course)|1.6k|👩‍🏫 Advanced NLP with spaCy: A free online course|
|[gandissect](https://github.com/CSAILVision/gandissect)|1.6k|Pytorch-based tools for visualizing and understanding the neurons of a GAN. https://gandissect.csail.mit.edu/|
|[NCRFpp](https://github.com/jiesutd/NCRFpp)|1.6k|NCRF++, a Neural Sequence Labeling Toolkit. Easy use to any sequence labeling tasks (e.g. NER, POS, Segmentation). It includes character LSTM/CNN, word LSTM/CNN and softmax/CRF components.|
|[stargan-v2](https://github.com/clovaai/stargan-v2)|1.6k|StarGAN v2 - Official PyTorch Implementation (CVPR 2020)|
|[tinyflow](https://github.com/tqchen/tinyflow)|1.6k|Tutorial code on how to build your own Deep Learning System in 2k Lines|
|[UNIT](https://github.com/mingyuliutw/UNIT)|1.6k|Unsupervised Image-to-Image Translation|
|[ssd_keras](https://github.com/pierluigiferrari/ssd_keras)|1.6k|A Keras port of Single Shot MultiBox Detector|
|[cosin](https://github.com/chatopera/cosin)|1.5k|🌲 春松客服，多渠道智能客服系统，开源客服系统|
|[foolbox](https://github.com/bethgelab/foolbox)|1.5k|A Python toolbox to create adversarial examples that fool neural networks in PyTorch, TensorFlow, and JAX|
|[capsule-networks](https://github.com/gram-ai/capsule-networks)|1.5k|A PyTorch implementation of the NIPS 2017 paper "Dynamic Routing Between Capsules".|
|[flogo](https://github.com/TIBCOSoftware/flogo)|1.5k|Project Flogo is an open source ecosystem of opinionated event-driven capabilities to simplify building efficient & modern serverless functions, microservices & edge apps.|
|[lip-reading-deeplearning](https://github.com/astorfi/lip-reading-deeplearning)|1.5k|🔓 Lip Reading - Cross Audio-Visual Recognition using 3D Architectures|
|[hummingbird](https://github.com/microsoft/hummingbird)|1.5k|Hummingbird compiles trained ML models into tensor computation for faster inference.|
|[deep-rl-tensorflow](https://github.com/carpedm20/deep-rl-tensorflow)|1.5k|TensorFlow implementation of Deep Reinforcement Learning papers|
|[practical-machine-learning-with-python](https://github.com/dipanjanS/practical-machine-learning-with-python)|1.5k|Master the essential skills needed to recognize and solve complex real-world problems with Machine Learning and Deep Learning by leveraging the highly popular Python Machine Learning Eco-system.|
|[NeuroNER](https://github.com/Franck-Dernoncourt/NeuroNER)|1.5k|Named-entity recognition using neural networks. Easy-to-use and state-of-the-art results.|
|[wavenet_vocoder](https://github.com/r9y9/wavenet_vocoder)|1.5k|WaveNet vocoder|
|[awesome-hand-pose-estimation](https://github.com/xinghaochen/awesome-hand-pose-estimation)|1.5k|Awesome work on hand pose estimation/tracking|
|[mAP](https://github.com/Cartucho/mAP)|1.5k|mean Average Precision - This code evaluates the performance of your neural net for object recognition.|
|[agents](https://github.com/tensorflow/agents)|1.5k|TF-Agents is a library for Reinforcement Learning in TensorFlow|
|[CADL](https://github.com/pkmital/CADL)|1.5k|ARCHIVED: Contains historical course materials/Homework materials for the FREE MOOC course on "Creative Applications of Deep Learning w/ Tensorflow" #CADL|
|[tensorflow-DeepFM](https://github.com/ChenglongChen/tensorflow-DeepFM)|1.5k|Tensorflow implementation of DeepFM for CTR prediction.|
|[tensorflow-1.4-billion-password-analysis](https://github.com/philipperemy/tensorflow-1.4-billion-password-analysis)|1.5k|Deep Learning model to analyze a large corpus of clear text passwords.|
|[DAT8](https://github.com/justmarkham/DAT8)|1.5k|General Assembly's 2015 Data Science course in Washington, DC|
|[NeMo](https://github.com/NVIDIA/NeMo)|1.5k|NeMo: a toolkit for conversational AI|
|[Machine-Learning-Flappy-Bird](https://github.com/ssusnic/Machine-Learning-Flappy-Bird)|1.5k|Machine Learning for Flappy Bird using Neural Network and Genetic Algorithm|
|[ml-visuals](https://github.com/dair-ai/ml-visuals)|1.5k|Visuals contains figures and templates which you can reuse and customize to improve your scientific writing.|
|[GANimation](https://github.com/albertpumarola/GANimation)|1.5k|GANimation: Anatomically-aware Facial Animation from a Single Image (ECCV'18 Oral) [PyTorch]|
|[EagleEye](https://github.com/ThoughtfulDev/EagleEye)|1.5k|Stalk your Friends. Find their Instagram, FB and Twitter Profiles using Image Recognition and Reverse Image Search.|
|[PyTorch-Encoding](https://github.com/zhanghang1989/PyTorch-Encoding)|1.5k|A PyTorch CV Toolkit|
|[spark](https://github.com/dotnet/spark)|1.5k|.NET for Apache® Spark™ makes Apache Spark™ easily accessible to .NET developers.|
|[quiver](https://github.com/keplr-io/quiver)|1.5k|Interactive convnet features visualization for Keras|
|[MachineLearning](https://github.com/jindongwang/MachineLearning)|1.5k|一些关于机器学习的学习资料与研究介绍|
|[GAT](https://github.com/PetarV-/GAT)|1.5k|Graph Attention Networks (https://arxiv.org/abs/1710.10903)|
|[mt-dnn](https://github.com/namisan/mt-dnn)|1.4k|Multi-Task Deep Neural Networks for Natural Language Understanding|
|[deep-neuroevolution](https://github.com/uber-research/deep-neuroevolution)|1.4k|Deep Neuroevolution|
|[a-PyTorch-Tutorial-to-Object-Detection](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Object-Detection)|1.4k|SSD: Single Shot MultiBox Detector | a PyTorch Tutorial to Object Detection|
|[labelbox](https://github.com/Labelbox/labelbox)|1.4k|Labelbox is the fastest way to annotate data to build and ship computer vision applications.|
|[openvino](https://github.com/openvinotoolkit/openvino)|1.4k|OpenVINO™ Toolkit repository|
|[awesome-decision-tree-papers](https://github.com/benedekrozemberczki/awesome-decision-tree-papers)|1.4k|A collection of research papers on decision, classification and regression trees with implementations.|
|[project_alias](https://github.com/bjoernkarmann/project_alias)|1.4k|Alias is a teachable “parasite” that is designed to give users more control over their smart assistants, both when it comes to customisation and privacy. Through a simple app the user can train Alias to react on a custom wake-word/sound, and once trained, Alias can take control over your home assistant by activating it for you.|
|[data-science-question-answer](https://github.com/ShuaiW/data-science-question-answer)|1.4k|A repo for data science related questions and answers|
|[photo2cartoon](https://github.com/minivision-ai/photo2cartoon)|1.4k|人像卡通化探索项目 (photo-to-cartoon translation project)|
|[video2x](https://github.com/k4yt3x/video2x)|1.4k|A lossless video/GIF/image upscaler achieved with waifu2x, Anime4K, SRMD and RealSR. Started in Hack the Valley 2, 2018.|
|[Tengine](https://github.com/OAID/Tengine)|1.4k|Tengine is a lite, high performance, modular inference engine for embedded device|
|[cuml](https://github.com/rapidsai/cuml)|1.4k|cuML - RAPIDS Machine Learning Library|
|[BentoML](https://github.com/bentoml/BentoML)|1.4k|Model Serving Made Easy|
|[GANotebooks](https://github.com/tjwei/GANotebooks)|1.4k|wgan, wgan2(improved, gp), infogan, and dcgan implementation in lasagne, keras, pytorch|
|[MobileNet](https://github.com/Zehaos/MobileNet)|1.4k|MobileNet build with Tensorflow|
|[CRAFT-pytorch](https://github.com/clovaai/CRAFT-pytorch)|1.4k|Official implementation of Character Region Awareness for Text Detection (CRAFT)|
|[mlr](https://github.com/mlr-org/mlr)|1.4k|Machine Learning in R|
|[monodepth2](https://github.com/nianticlabs/monodepth2)|1.4k|Monocular depth estimation from a single image|
|[TensorKart](https://github.com/kevinhughes27/TensorKart)|1.4k|self-driving MarioKart with TensorFlow|
|[keras-contrib](https://github.com/keras-team/keras-contrib)|1.4k|Keras community contributions|
|[stellargraph](https://github.com/stellargraph/stellargraph)|1.4k|StellarGraph - Machine Learning on Graphs|
|[GDLnotes](https://github.com/ahangchen/GDLnotes)|1.4k|Google Deep Learning Notes（TensorFlow教程）|
|[pydensecrf](https://github.com/lucasb-eyer/pydensecrf)|1.4k|Python wrapper to Philipp Krähenbühl's dense (fully connected) CRFs with gaussian edge potentials.|
|[seldon-server](https://github.com/SeldonIO/seldon-server)|1.4k|Machine Learning Platform and Recommendation Engine built on Kubernetes|
|[chainercv](https://github.com/chainer/chainercv)|1.4k|ChainerCV: a Library for Deep Learning in Computer Vision|
|[tensorflow-nlp](https://github.com/zhedongzheng/tensorflow-nlp)|1.4k|Building blocks for NLP and Text Generation in TensorFlow 2.x / 1.x|
|[iOS_ML](https://github.com/alexsosn/iOS_ML)|1.4k|List of Machine Learning, AI, NLP solutions for iOS. The most recent version of this article can be found on my blog.|
|[tfgo](https://github.com/galeone/tfgo)|1.4k|Tensorflow + Go, the gopher way|
|[bi-att-flow](https://github.com/allenai/bi-att-flow)|1.4k|Bi-directional Attention Flow (BiDAF) network is a multi-stage hierarchical process that represents context at different levels of granularity and uses a bi-directional attention flow mechanism to achieve a query-aware context representation without early summarization.|
|[CoreML-in-ARKit](https://github.com/hanleyweng/CoreML-in-ARKit)|1.4k|Simple project to detect objects and display 3D labels above them in AR. This serves as a basic Template for an ARKit project to use CoreML.|
|[lightning](https://github.com/scikit-learn-contrib/lightning)|1.4k|Large-scale linear classification, regression and ranking in Python|
|[DeepFace](https://github.com/RiweiChen/DeepFace)|1.4k|Face analysis mainly based on Caffe. At this time, face analysis tasks like detection, alignment and recognition have been done.|
|[torch2trt](https://github.com/NVIDIA-AI-IOT/torch2trt)|1.4k|An easy to use PyTorch to TensorRT converter|
|[deepvoice3_pytorch](https://github.com/r9y9/deepvoice3_pytorch)|1.4k|PyTorch implementation of convolutional neural networks-based text-to-speech synthesis models|
|[sphereface](https://github.com/wy1iu/sphereface)|1.4k|Implementation for <SphereFace: Deep Hypersphere Embedding for Face Recognition> in CVPR'17.|
|[jeelizFaceFilter](https://github.com/jeeliz/jeelizFaceFilter)|1.4k|Javascript/WebGL lightweight face tracking library designed for augmented reality webcam filters. Features : multiple faces detection, rotation, mouth opening. Various integration examples are provided (Three.js, Babylon.js, FaceSwap, Canvas2D, CSS3D...).|
|[kaggle-web-traffic](https://github.com/Arturus/kaggle-web-traffic)|1.4k|1st place solution|
|[minimalRL](https://github.com/seungeunrho/minimalRL)|1.4k|Implementations of basic RL algorithms with minimal lines of codes! (pytorch based)|
|[Machine-Learning-Notes](https://github.com/Sophia-11/Machine-Learning-Notes)|1.4k|周志华《机器学习》手推笔记|
|[Gen.jl](https://github.com/probcomp/Gen.jl)|1.4k|A general-purpose probabilistic programming system with programmable inference|
|[faster_rcnn_pytorch](https://github.com/longcw/faster_rcnn_pytorch)|1.4k|Faster RCNN with PyTorch|
|[sod](https://github.com/symisc/sod)|1.4k|An Embedded Computer Vision & Machine Learning Library (CPU Optimized & IoT Capable)|
|[keras_to_tensorflow](https://github.com/amir-abdi/keras_to_tensorflow)|1.4k|General code to convert a trained keras model into an inference tensorflow model|
|[handtracking](https://github.com/victordibia/handtracking)|1.3k|Building a Real-time Hand-Detector using Neural Networks (SSD) on Tensorflow|
|[word-rnn-tensorflow](https://github.com/hunkim/word-rnn-tensorflow)|1.3k|Multi-layer Recurrent Neural Networks (LSTM, RNN) for word-level language models in Python using TensorFlow.|
|[TorchCraft](https://github.com/TorchCraft/TorchCraft)|1.3k|Connecting Torch to StarCraft|
|[AndroidTensorFlowMachineLearningExample](https://github.com/MindorksOpenSource/AndroidTensorFlowMachineLearningExample)|1.3k|Android TensorFlow MachineLearning Example (Building TensorFlow for Android)|
|[magnitude](https://github.com/plasticityai/magnitude)|1.3k|A fast, efficient universal vector embedding utility package.|
|[hackermath](https://github.com/amitkaps/hackermath)|1.3k|Introduction to Statistics and Basics of Mathematics for Data Science - The Hacker's Way|
|[pytorch-grad-cam](https://github.com/jacobgil/pytorch-grad-cam)|1.3k|PyTorch implementation of Grad-CAM|
|[grenade](https://github.com/HuwCampbell/grenade)|1.3k|Deep Learning in Haskell|
|[captcha_trainer](https://github.com/kerlomz/captcha_trainer)|1.3k|[验证码识别-训练] This project is based on CNN/ResNet/DenseNet+GRU/LSTM+CTC/CrossEntropy to realize verification code identification. This project is only for training the model.|
|[anago](https://github.com/Hironsan/anago)|1.3k|Bidirectional LSTM-CRF and ELMo for Named-Entity Recognition, Part-of-Speech Tagging and so on.|
|[mne-python](https://github.com/mne-tools/mne-python)|1.3k|MNE : Magnetoencephalography (MEG) and Electroencephalography (EEG) in Python|
|[eos](https://github.com/patrikhuber/eos)|1.3k|A lightweight 3D Morphable Face Model fitting library in modern C++14|
|[ngraph](https://github.com/NervanaSystems/ngraph)|1.3k|nGraph - open source C++ library, compiler and runtime for Deep Learning|
|[NSFWDetector](https://github.com/lovoo/NSFWDetector)|1.3k|A NSFW (aka porn) detector with CoreML|
|[open_nsfw_android](https://github.com/devzwy/open_nsfw_android)|1.3k|🔥🔥🔥色情图片离线识别，基于TensorFlow实现。识别只需20ms,可断网测试，成功率99%，调用只要一行代码，从雅虎的开源项目open_nsfw移植，该模型文件可用于iOS、java、C++等平台|
|[cs230-code-examples](https://github.com/cs230-stanford/cs230-code-examples)|1.3k|Code examples in pyTorch and Tensorflow for CS230|
|[pytorch-generative-adversarial-networks](https://github.com/devnag/pytorch-generative-adversarial-networks)|1.3k|A very simple generative adversarial network (GAN) in PyTorch|
|[forecasting](https://github.com/microsoft/forecasting)|1.3k|Time Series Forecasting Best Practices & Examples|
|[VIBE](https://github.com/mkocabas/VIBE)|1.3k|Official implementation of CVPR2020 paper "VIBE: Video Inference for Human Body Pose and Shape Estimation"|
|[bulbea](https://github.com/achillesrasquinha/bulbea)|1.3k|🐗 🐻 Deep Learning based Python Library for Stock Market Prediction and Modelling|
|[electra](https://github.com/google-research/electra)|1.3k|ELECTRA: Pre-training Text Encoders as Discriminators Rather Than Generators|
|[scattertext](https://github.com/JasonKessler/scattertext)|1.3k|Beautiful visualizations of how language differs among document types.|
|[talos](https://github.com/autonomio/talos)|1.3k|Hyperparameter Optimization for TensorFlow, Keras and PyTorch|
|[practicalAI-cn](https://github.com/MLEveryday/practicalAI-cn)|1.3k|AI实战-practicalAI 中文版|
|[impersonator](https://github.com/svip-lab/impersonator)|1.3k|PyTorch implementation of our ICCV 2019 paper: Liquid Warping GAN: A Unified Framework for Human Motion Imitation, Appearance Transfer and Novel View Synthesis|
|[gluon-ts](https://github.com/awslabs/gluon-ts)|1.3k|Probabilistic time series modeling in Python|
|[dcgan-completion.tensorflow](https://github.com/bamos/dcgan-completion.tensorflow)|1.3k|Image Completion with Deep Learning in TensorFlow|
|[EfficientDet.Pytorch](https://github.com/toandaominh1997/EfficientDet.Pytorch)|1.3k|Implementation EfficientDet: Scalable and Efficient Object Detection in PyTorch|
|[NeuronBlocks](https://github.com/microsoft/NeuronBlocks)|1.3k|NLP DNN Toolkit - Building Your NLP DNN Models Like Playing Lego|
|[yolo2-pytorch](https://github.com/longcw/yolo2-pytorch)|1.3k|YOLOv2 in PyTorch|
|[EmojiIntelligence](https://github.com/BilalReffas/EmojiIntelligence)|1.3k|Neural Network built in Apple Playground using Swift|
|[efficientnet](https://github.com/qubvel/efficientnet)|1.3k|Implementation of EfficientNet model. Keras and TensorFlow Keras.|
|[YOLOv3_TensorFlow](https://github.com/wizyoung/YOLOv3_TensorFlow)|1.3k|Complete YOLO v3 TensorFlow implementation. Support training on your own dataset.|
|[TensorFlow.NET](https://github.com/SciSharp/TensorFlow.NET)|1.3k|.NET Standard bindings for Google's TensorFlow for developing, training and deploying Machine Learning models in C#.|
|[pytextrank](https://github.com/DerwenAI/pytextrank)|1.3k|Python implementation of TextRank for phrase extraction and summarization of text documents|
|[infer](https://github.com/dotnet/infer)|1.3k|Infer.NET is a framework for running Bayesian inference in graphical models|
|[uda](https://github.com/google-research/uda)|1.3k|Unsupervised Data Augmentation (UDA)|
|[mmaction](https://github.com/open-mmlab/mmaction)|1.3k|An open-source toolbox for action understanding based on PyTorch|
|[spark-nlp](https://github.com/JohnSnowLabs/spark-nlp)|1.3k|State of the Art Natural Language Processing|
|[pytorch-semantic-segmentation](https://github.com/zijundeng/pytorch-semantic-segmentation)|1.3k|PyTorch for Semantic Segmentation|
|[Deep-Learning-Boot-Camp](https://github.com/QuantScientist/Deep-Learning-Boot-Camp)|1.2k|A community run, 5-day PyTorch Deep Learning Bootcamp|
|[pytorch-openai-transformer-lm](https://github.com/huggingface/pytorch-openai-transformer-lm)|1.2k|🐥A PyTorch implementation of OpenAI's finetuned transformer language model with a script to import the weights pre-trained by OpenAI|
|[hiddenlayer](https://github.com/waleedka/hiddenlayer)|1.2k|Neural network graphs and training metrics for PyTorch, Tensorflow, and Keras.|
|[PaddleHub](https://github.com/PaddlePaddle/PaddleHub)|1.2k|Toolkit for Pre-trained Model Application of PaddlePaddle（『飞桨』预训练模型应用工具 ）|
|[PhotographicImageSynthesis](https://github.com/CQFIO/PhotographicImageSynthesis)|1.2k|Photographic Image Synthesis with Cascaded Refinement Networks|
|[alpr-unconstrained](https://github.com/sergiomsilva/alpr-unconstrained)|1.2k|License Plate Detection and Recognition in Unconstrained Scenarios|
|[Deep-Image-Analogy](https://github.com/msracver/Deep-Image-Analogy)|1.2k|The source code of 'Visual Attribute Transfer through Deep Image Analogy'.|
|[spektral](https://github.com/danielegrattarola/spektral)|1.2k|Graph Neural Networks with Keras and Tensorflow 2.|
|[DeepAA](https://github.com/OsciiArt/DeepAA)|1.2k|make ASCII Art by Deep Learning|
|[vvedenie-mashinnoe-obuchenie](https://github.com/demidovakatya/vvedenie-mashinnoe-obuchenie)|1.2k|📝 Подборка ресурсов по машинному обучению|
|[OpenSeq2Seq](https://github.com/NVIDIA/OpenSeq2Seq)|1.2k|Toolkit for efficient experimentation with Speech Recognition, Text2Speech and NLP|
|[Forge](https://github.com/hollance/Forge)|1.2k|A neural network toolkit for Metal|
|[keras-yolo3](https://github.com/experiencor/keras-yolo3)|1.2k|Training and Detecting Objects with YOLO3|
|[NiftyNet](https://github.com/NifTK/NiftyNet)|1.2k|[unmaintained] An open-source convolutional neural networks platform for research in medical image analysis and image-guided therapy|
|[Awesome-TensorFlow-Chinese](https://github.com/fendouai/Awesome-TensorFlow-Chinese)|1.2k|Awesome-TensorFlow-Chinese，TensorFlow 中文资源精选，官方网站，安装教程，入门教程，视频教程，实战项目，学习路径。QQ群：167122861，公众号：磐创AI，微信群二维码：http://www.tensorflownews.com/|
|[StudyBook](https://github.com/changwookjun/StudyBook)|1.2k|Study E-Book(ComputerVision DeepLearning MachineLearning Math NLP Python ReinforcementLearning)|
|[awesome-semantic-segmentation-pytorch](https://github.com/Tramac/awesome-semantic-segmentation-pytorch)|1.2k|Semantic Segmentation on PyTorch (include FCN, PSPNet, Deeplabv3, Deeplabv3+, DANet, DenseASPP, BiSeNet, EncNet, DUNet, ICNet, ENet, OCNet, CCNet, PSANet, CGNet, ESPNet, LEDNet, DFANet)|
|[RFBNet](https://github.com/ruinmessi/RFBNet)|1.2k|Receptive Field Block Net for Accurate and Fast Object Detection, ECCV 2018|
|[GPflow](https://github.com/GPflow/GPflow)|1.2k|Gaussian processes in TensorFlow|
|[dlwpt-code](https://github.com/deep-learning-with-pytorch/dlwpt-code)|1.2k|Code for the book Deep Learning with PyTorch by Eli Stevens, Luca Antiga, and Thomas Viehmann.|
|[dlcv_for_beginners](https://github.com/frombeijingwithlove/dlcv_for_beginners)|1.2k|《深度学习与计算机视觉》配套代码|
|[Deep-Learning-with-PyTorch-Tutorials](https://github.com/dragen1860/Deep-Learning-with-PyTorch-Tutorials)|1.2k|深度学习与PyTorch入门实战视频教程 配套源代码和PPT|
|[DLTK](https://github.com/DLTK/DLTK)|1.2k|Deep Learning Toolkit for Medical Image Analysis|
|[FCN.tensorflow](https://github.com/shekkizh/FCN.tensorflow)|1.2k|Tensorflow implementation of Fully Convolutional Networks for Semantic Segmentation (http://fcn.berkeleyvision.org)|
|[facenet-pytorch](https://github.com/timesler/facenet-pytorch)|1.2k|Pretrained Pytorch face detection (MTCNN) and recognition (InceptionResnet) models|
|[h2o-tutorials](https://github.com/h2oai/h2o-tutorials)|1.2k|Tutorials and training material for the H2O Machine Learning Platform|
|[nlp-journey](https://github.com/msgi/nlp-journey)|1.2k|Documents, papers and codes related to Natural Language Processing, including Topic Model, Word Embedding, Named Entity Recognition, Text Classificatin, Text Generation, Text Similarity, Machine Translation)，etc. All codes are implemented intensorflow 2.0.|
|[object_detector_app](https://github.com/datitran/object_detector_app)|1.2k|Real-Time Object Recognition App with Tensorflow and OpenCV|
|[tnt](https://github.com/pytorch/tnt)|1.2k|Simple tools for logging and visualizing, loading and training|
|[tensorflow-deeplab-resnet](https://github.com/DrSleep/tensorflow-deeplab-resnet)|1.2k|DeepLab-ResNet rebuilt in TensorFlow|
|[reproducible-image-denoising-state-of-the-art](https://github.com/wenbihan/reproducible-image-denoising-state-of-the-art)|1.2k|Collection of popular and reproducible image denoising works.|
|[senet.pytorch](https://github.com/moskomule/senet.pytorch)|1.2k|PyTorch implementation of SENet|
|[pytorch-seq2seq](https://github.com/IBM/pytorch-seq2seq)|1.2k|An open source framework for seq2seq models in PyTorch.|
|[efficient_densenet_pytorch](https://github.com/gpleiss/efficient_densenet_pytorch)|1.2k|A memory-efficient implementation of DenseNets|
|[pytorch-retinanet](https://github.com/yhenon/pytorch-retinanet)|1.2k|Pytorch implementation of RetinaNet object detection.|
|[cakechat](https://github.com/lukalabs/cakechat)|1.2k|CakeChat: Emotional Generative Dialog System|
|[pytorch-fcn](https://github.com/wkentaro/pytorch-fcn)|1.2k|PyTorch Implementation of Fully Convolutional Networks. (Training code to reproduce the original result is available.)|
|[python-machine-learning-book-3rd-edition](https://github.com/rasbt/python-machine-learning-book-3rd-edition)|1.2k|The "Python Machine Learning (3rd edition)" book code repository|
|[tf-quant-finance](https://github.com/google/tf-quant-finance)|1.2k|High-performance TensorFlow library for quantitative finance.|
|[gnes](https://github.com/gnes-ai/gnes)|1.1k|GNES is Generic Neural Elastic Search, a cloud-native semantic search system based on deep neural network.|
|[Image-OutPainting](https://github.com/bendangnuksung/Image-OutPainting)|1.1k|🏖 Keras Implementation of Painting outside the box|
|[Fabrik](https://github.com/Cloud-CV/Fabrik)|1.1k|🏭 Collaboratively build, visualize, and design neural nets in browser|
|[attention-transfer](https://github.com/szagoruyko/attention-transfer)|1.1k|Improving Convolutional Networks via Attention Transfer (ICLR 2017)|
|[pytorch-cifar100](https://github.com/weiaicunzai/pytorch-cifar100)|1.1k|Practice on cifar100(ResNet, DenseNet, VGG, GoogleNet, InceptionV3, InceptionV4, Inception-ResNetv2, Xception, Resnet In Resnet, ResNext,ShuffleNet, ShuffleNetv2, MobileNet, MobileNetv2, SqueezeNet, NasNet, Residual Attention Network, SENet)|
|[MONAI](https://github.com/Project-MONAI/MONAI)|1.1k|AI Toolkit for Healthcare Imaging|
|[tensorrec](https://github.com/jfkirk/tensorrec)|1.1k|A TensorFlow recommendation algorithm and framework in Python.|
|[mleap](https://github.com/combust/mleap)|1.1k|MLeap: Deploy Spark Pipelines to Production|
|[noreward-rl](https://github.com/pathak22/noreward-rl)|1.1k|[ICML 2017] TensorFlow code for Curiosity-driven Exploration for Deep Reinforcement Learning|
|[PyTorchNLPBook](https://github.com/joosthub/PyTorchNLPBook)|1.1k|Code and data accompanying Natural Language Processing with PyTorch published by O'Reilly Media https://nlproc.info|
|[mtcnn](https://github.com/ipazc/mtcnn)|1.1k|MTCNN face detection implementation for TensorFlow, as a PIP package.|
|[WaveRNN](https://github.com/fatchord/WaveRNN)|1.1k|WaveRNN Vocoder + TTS|
|[UNet-family](https://github.com/ShawnBIT/UNet-family)|1.1k|Paper and implementation of UNet-related model.|
|[Awesome-pytorch-list-CNVersion](https://github.com/xavier-zy/Awesome-pytorch-list-CNVersion)|1.1k|Awesome-pytorch-list 翻译工作进行中......|
|[tensorflow-fcn](https://github.com/MarvinTeichmann/tensorflow-fcn)|1.1k|An Implementation of Fully Convolutional Networks in Tensorflow.|
|[BicycleGAN](https://github.com/junyanz/BicycleGAN)|1.1k|Toward Multimodal Image-to-Image Translation|
|[TensorFlow2.0-Examples](https://github.com/YunYang1994/TensorFlow2.0-Examples)|1.1k|🙄 Difficult algorithm, simple code.|
|[fast-autoaugment](https://github.com/kakaobrain/fast-autoaugment)|1.1k|Official Implementation of 'Fast AutoAugment' in PyTorch.|
|[fastai_deeplearn_part1](https://github.com/reshamas/fastai_deeplearn_part1)|1.1k|Notes for Fastai Deep Learning Course|
|[HyperGAN](https://github.com/HyperGAN/HyperGAN)|1.1k|Composable GAN framework with api and user interface|
|[home](https://github.com/apachecn/home)|1.1k|ApacheCN 开源组织：公告、介绍、成员、活动、交流方式|
|[tfx](https://github.com/tensorflow/tfx)|1.1k|TFX is an end-to-end platform for deploying production ML pipelines|
|[handwriting-synthesis](https://github.com/sjvasquez/handwriting-synthesis)|1.1k|Handwriting Synthesis with RNNs ✏️|
|[image-quality-assessment](https://github.com/idealo/image-quality-assessment)|1.1k|Convolutional Neural Networks to predict the aesthetic and technical quality of images.|
|[PerceptualSimilarity](https://github.com/richzhang/PerceptualSimilarity)|1.1k|Learned Perceptual Image Patch Similarity (LPIPS) metric. In CVPR, 2018.|
|[lanenet-lane-detection](https://github.com/MaybeShewill-CV/lanenet-lane-detection)|1.1k|Unofficial implemention of lanenet model for real time lane detection using deep neural network model https://maybeshewill-cv.github.io/lanenet-lane-detection/|
|[uTensor](https://github.com/uTensor/uTensor)|1.1k|TinyML AI inference library|
|[torchgan](https://github.com/torchgan/torchgan)|1.1k|Research Framework for easy and efficient training of GANs based on Pytorch|
|[merlin](https://github.com/CSTR-Edinburgh/merlin)|1.1k|This is now the official location of the Merlin project.|
|[CLUE](https://github.com/CLUEbenchmark/CLUE)|1k|中文语言理解基准测评 Chinese Language Understanding Evaluation Benchmark: datasets, baselines, pre-trained models, corpus and leaderboard|
|[tfjs-node](https://github.com/tensorflow/tfjs-node)|1k|TensorFlow powered JavaScript library for training and deploying ML models on Node.js.|
|[CycleGAN-TensorFlow](https://github.com/vanhuyz/CycleGAN-TensorFlow)|1k|An implementation of CycleGan using TensorFlow|
|[EffectivePyTorch](https://github.com/vahidk/EffectivePyTorch)|1k|PyTorch tutorials and best practices.|
|[hercules](https://github.com/src-d/hercules)|1k|Gaining advanced insights from Git repository history.|
|[AdvancedEAST](https://github.com/huoyijie/AdvancedEAST)|1k|AdvancedEAST is an algorithm used for Scene image text detect, which is primarily based on EAST, and the significant improvement was also made, which make long text predictions more accurate.|
|[one-pixel-attack-keras](https://github.com/Hyperparticle/one-pixel-attack-keras)|1k|Keras implementation of "One pixel attack for fooling deep neural networks" using differential evolution on Cifar10 and ImageNet|
|[CRNN_Chinese_Characters_Rec](https://github.com/Sierkinhane/CRNN_Chinese_Characters_Rec)|1k|(CRNN) Chinese Characters Recognition.|
|[hmtl](https://github.com/huggingface/hmtl)|1k|🌊HMTL: Hierarchical Multi-Task Learning - A State-of-the-Art neural network model for several NLP tasks based on PyTorch and AllenNLP|
|[rethinking-network-pruning](https://github.com/Eric-mingjie/rethinking-network-pruning)|1k|Rethinking the Value of Network Pruning (Pytorch) (ICLR 2019)|
|[pytorch-classification](https://github.com/bearpaw/pytorch-classification)|1k|Classification with PyTorch.|
|[a-PyTorch-Tutorial-to-Image-Captioning](https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Image-Captioning)|1k|Show, Attend, and Tell | a PyTorch Tutorial to Image Captioning|
|[reformer-pytorch](https://github.com/lucidrains/reformer-pytorch)|1k|Reformer, the efficient Transformer, in Pytorch|
|[pytorch-YOLOv4](https://github.com/Tianxiaomo/pytorch-YOLOv4)|1k|PyTorch ,ONNX and TensorRT implementation of YOLOv4|
|[FaceMaskDetection](https://github.com/AIZOOTech/FaceMaskDetection)|1k|开源人脸口罩检测模型和数据 Detect faces and determine whether people are wearing mask.|
|[gen-efficientnet-pytorch](https://github.com/rwightman/gen-efficientnet-pytorch)|1k|Pretrained EfficientNet, EfficientNet-Lite, MixNet, MobileNetV3 / V2, MNASNet A1 and B1, FBNet, Single-Path NAS|
|[open-reid](https://github.com/Cysu/open-reid)|1k|Open source person re-identification library in python|
|[wgan-gp](https://github.com/caogang/wgan-gp)|1k|A pytorch implementation of Paper "Improved Training of Wasserstein GANs"|

