/*

The following is a ZephJS Component Bundle and includes the ZephJS Library.
ZephJS is copyright 2018-PRESENT, by The Awesome Engineering Company, inc.
and is released publically under the MIT License. Any usage of the ZephJS
library must included this license heading, the copyright notice, and
a reference to the Zephjs website.

For more details about ZephJS, please visit https://zephjs.com

*/

(function () {
	'use strict';

	window.customElements&&window.ShadowRoot&&document.body.attachShadow||console.error("ZephJS is not supported by this browser. Please consult the Browser Support section of the ZephJS documentation for more details.");const $COMPONENTS=Symbol("components"),$CONTEXT=Symbol("context"),$CODE=Symbol("code"),$ELEMENT=Symbol("element"),$SHADOW=Symbol("shadow"),$OBSERVER=Symbol("observer"),$LISTENERS=Symbol("listeners"),$PROXY=Symbol("proxy");let CODE_CONTEXT=null,DEFINITION_METHODS=null,PENDING={},FIREREADY=null,READY=!1;const IDENTITY_FUNCTION=t=>t,check={not:{undefined:(t,e)=>{if(void 0===t)throw new Error("Undefined "+e+".")},null:(t,e)=>{if(null===t)throw new Error("Null "+e+".")},uon:(t,e)=>{check.not.undefined(t,e),check.not.null(t,e);},empty:(t,e)=>{if("string"==typeof t&&""===t)throw new Error("Empty "+e+".")}},type:(t,e,n)=>{if(typeof t!==e)throw new Error("Invalid "+n+"; must be a "+e+".")},string:(t,e)=>{check.type(t,"string",e);},posstr:(t,e)=>{check.not.uon(t,e),check.string(t,e),check.not.empty(t,e);},number:(t,e)=>{check.type(t,"number",e);},boolean:(t,e)=>{check.type(t,"string",e);},function:(t,e,n)=>{if(!(t instanceof Function))throw new Error("Invalid "+n+"; must be a Function.")},array:(t,e,n)=>{if(!(t instanceof Array))throw new Error("Invalid "+n+"; must be an Array.")}},utils={ready:()=>READY,tryprom:t=>(check.not.uon(t,"argument"),check.function(t,"argument"),new Promise((e,n)=>{try{t(e,n);}catch(t){return n(t)}})),exists:t=>null==t||""===t?Promise.resolve(!1):utils.tryprom(async e=>{(await fetch(t,{method:"HEAD"})).ok?e(!0):e(!1);}),fetch:t=>(check.not.uon(t,"url"),check.not.empty(t,"url"),utils.tryprom(async e=>{let n=await fetch(t);if(n.ok)return e(n);e(void 0);})),fetchText:t=>(check.not.uon(t,"url"),check.not.empty(t,"url"),utils.tryprom(async e=>{let n=await utils.fetch(t);n||e(void 0),e(await n.text());})),fetchBinary:t=>(check.not.uon(t,"url"),check.not.empty(t,"url"),utils.tryprom(async e=>{let n=await utils.fetch(t);n||e(void 0);let o=n.headers&&n.headers.get("Content-Type")||null;e({data:await n.arrayBuffer(),contentType:o});})),resolve:(t,e=document.URL)=>{if(check.not.uon(t,"url"),check.not.empty(t,"url"),!(t instanceof URL)&&"string"!=typeof t)throw new Error("Invalid url; must be a string or URL.");try{return "string"==typeof t&&t.startsWith("data:")?new URL(t):new URL(t,e)}catch(t){return null}},resolveName(t,e=document.URL,n=".js"){let o=""+t;return o.match(/^data:/)?Promise.resolve(new URL(t)):o.match(/^http:\/\/|^https:\/\/|^ftp:\/\/|^\.\/|^\.\.\//)?utils.tryprom(async o=>{let i=utils.resolve(t,e);if(await utils.exists(i))return o(i);if(await utils.exists(t))return o(t);if(n){let i=t+n,r=utils.resolve(i,e);if(await utils.exists(r))return o(r);if(await utils.exists(i))return o(i)}o(void 0);}):Promise.resolve(void 0)},parseDataURL(t){if(check.not.uon(t,"url"),!(t instanceof URL))throw new Error("Invalid url.");if("data:"!==t.protocol)return null;if(!t.href)return null;let e=t.href.match(/^data:([^;]+)(([^;]+;)?;base64)?,(.*)$/);return {contentType:e&&e[1]||"",data:e&&e[4]||null}}};class ZephComponent{constructor(t,e,n){check.posstr(t,"name"),check.posstr(t,"origin"),check.not.uon(n,"code"),check.function(n,"code");let o={};o.name=t,o.origin=e,this[$CODE]=n,this[$CONTEXT]=o,this[$ELEMENT]=null;}get context(){return this[$CONTEXT]}get name(){return this.context.name}get origin(){return this.context.origin}get code(){return this[$CODE]}get defined(){return !!this[$ELEMENT]}get customElementClass(){return this[$ELEMENT]}define(){return utils.tryprom(async t=>{let e=new ZephComponentExecution(this.context,this.code);if(await e.run(),await Promise.all(this.context.pending||[]),this.context.from){let t=ZephComponents.get(this.context.from);if(!t)throw new Error("Component '"+this.context.from+"' not found; inheritence by '"+this.context.name+"' is not possible.");await Promise.all(t.context.pending||[]),this[$CONTEXT]=extend({},t.context,this.context);}this[$ELEMENT]=ZephElementClass.generateClass(this.context),customElements.define(this.name,this[$ELEMENT]),(this.context.aliases||[]).forEach(t=>{customElements.define(t,class extends this[$ELEMENT]{constructor(){super();}});}),fire(this.context&&this.context.lifecycle&&this.context.lifecycle.init||[],this.name,this),t();})}}class ZephComponentExecution{constructor(t,e){check.not.uon(t,"context"),check.not.uon(e,"code"),check.function(e,"code"),this[$CONTEXT]=t,this[$CODE]=e;}run(){return utils.tryprom(async t=>{CODE_CONTEXT=this,await this[$CODE].bind(this)(DEFINITION_METHODS),CODE_CONTEXT=null,t();})}get context(){return this[$CONTEXT]}from(t){check.posstr(t,"fromTagName"),this.context.pending=this.context.pending||[],this.context.pending.push(ZephComponents.waitFor(t)),this.context.from=t;}alias(t){check.posstr(t,"aliasName"),this.context.aliases=this.context.aliases||new Set,this.context.aliases.add(t);}html(t,e={}){e=Object.assign({overwrite:!1,noRemote:!1},e||{});let n=utils.tryprom(async n=>{if(!e.noRemote){let e=await utils.resolveName(t,this.context.origin||document.URL.toString(),".html");e&&(t=await utils.fetchText(e));}let o=document.createElement("template");o.innerHTML=t,this.context.html=this.context.html||[],this.context.html.push({template:o,options:e}),n();});this.context.pending=this.context.pending||[],this.context.pending.push(n);}css(t,e={}){e=Object.assign({overwrite:!1,noRemote:!1},e||{});let n=utils.tryprom(async n=>{if(!e.noRemote){let e=await utils.resolveName(t,this.context.origin,".css");e&&(t=await utils.fetchText(e));}let o=document.createElement("template");o.innerHTML="<style>\n"+t+"\n</style>",this.context.css=this.context.css||[],this.context.css.push({template:o,options:e}),n();});this.context.pending=this.context.pending||[],this.context.pending.push(n);}asset(t,e,n={}){if(check.not.uon(t,"selector"),check.string(t,"selector"),check.not.empty(t,"selector"),check.not.uon(e,"content"),!(""+e).match(/^data:|^http:\/\/|^https:\/\/|^ftp:\/\/|^\.\/|^\.\.\//))throw new Error("Url must be a valid url (http, https, ftp), or a relative filename, or a data url.");n=Object.assign({target:"auto"},n||{});let o=utils.tryprom(async o=>{let i;(e=await utils.resolveName(e,this.context.origin,""))&&"data:"===e.protocol?i=utils.parseDataURL(e):(i=await utils.fetchBinary(e)).data=btoa([].reduce.call(new Uint8Array(i.data),(t,e)=>t+String.fromCharCode(e),"")),this.context.assets=this.context.assets||[],this.context.assets.push({selector:t,contentType:i&&i.contentType||null,data:i&&i.data||null,options:n}),o();});this.context.pending=this.context.pending||[],this.context.pending.push(o);}attribute(t,e){if(check.not.uon(t,"attributeName"),check.string(t),this.context.attributes=this.context.attributes||{},this.context.attributes[t])throw new Error("Attribute '"+t+"' already defined for custom element; cannot have multiple definitions.");this.context.attributes[t]={attributeName:t,initialValue:e};}property(t,e,n){if(check.not.uon(t,"propertyName"),check.string(t),this.context.properties=this.context.properties||{},this.context.properties[t])throw new Error("Property '"+t+"' already defined for custom element; cannot have multiple definitions.");this.context.properties[t]=Object.assign(this.context.properties[t]||{},{propertyName:t,initialValue:e,transformFunction:n,changes:[]});}binding(t,e,n,o){return this.bindingAt(".",t,e,n,o)}bindingAt(t,e,n,o,i){if(t&&e&&n&&void 0===o&&(o=e),check.not.uon(t,"sourceElement"),"string"!=typeof t&&!(t instanceof HTMLElement))throw new Error("Invalid sourceElement; must be a string or an instance of HTMLElement.");if(check.not.uon(e,"sourceName"),check.string(e,"sourceName"),!e.startsWith("$")&&!e.startsWith("@")&&!e.startsWith("."))throw new Error("Invalid sourceName; must start with a '$' or a '@' or a '.'.");if(check.not.uon(n,"targetElement"),"string"!=typeof n&&!(n instanceof HTMLElement))throw new Error("Invalid targetElement; must be a string or an instance of HTMLElement.");if(check.not.uon(o,"targetName"),check.string(o,"targetName"),!o.startsWith("$")&&!o.startsWith("@")&&!o.startsWith("."))throw new Error("Invalid targetName; must start with a '$' or a '@' or a '.'.");null==i&&(i=IDENTITY_FUNCTION),check.not.uon(i,"transformFunction"),check.function(i,"transformFunction");let r=t+":"+e+">"+n+":"+o;this.context.bindings=this.context.bindings||{},this.context.bindings[r]={source:{element:t,name:e},target:{element:n,name:o},transform:i};}onInit(t){check.not.uon(t,"listener"),check.function(t,"listener"),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.init=this.context.lifecycle.init||[],this.context.lifecycle.init.push(t);}onCreate(t){check.not.uon(t,"listener"),check.function(t,"listener"),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.create=this.context.lifecycle.create||[],this.context.lifecycle.create.push(t);}onAdd(t){check.not.uon(t,"listener"),check.function(t,"listener"),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.add=this.context.lifecycle.add||[],this.context.lifecycle.add.push(t);}onRemove(t){check.not.uon(t,"listener"),check.function(t,"listener"),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.remove=this.context.lifecycle.remove||[],this.context.lifecycle.remove.push(t);}onAdopt(t){check.not.uon(t,"listener"),check.function(t,"listener"),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.adopt=this.context.lifecycle.adopt||[],this.context.lifecycle.adopt.push(t);}onAttribute(t,e){check.not.uon(t,"attribute"),check.string(t,"attribute"),check.not.uon(e,"listener"),check.function(e,"listener"),this.context.observed=this.context.observed||[],this.context.observed.push(t),this.context.lifecycle=this.context.lifecycle||{},this.context.lifecycle.attributes=this.context.lifecycle.attributes||{},this.context.lifecycle.attributes[t]=this.context.lifecycle.attributes[t]||[],this.context.lifecycle.attributes[t].push(e);}onProperty(t,e){check.not.uon(t,"attribute"),check.string(t,"attribute"),check.not.uon(e,"listener"),check.function(e,"listener"),this.context.properties=this.context.properties||{},this.context.properties[t]||this.property(t,void 0),this.context.properties[t].changes.push(e);}onEvent(t,e){check.not.uon(t,"eventName"),check.string(t,"eventName"),check.not.uon(e,"listener"),check.function(e,"listener"),this.context.events=this.context.events||[],this.context.events.push({eventName:t,listener:e});}onEventAt(t,e,n){check.not.uon(e,"eventName"),check.string(e,"eventName"),check.not.uon(n,"listener"),check.function(n,"listener"),this.context.eventsAt=this.context.eventsAt||[],this.context.eventsAt.push({selector:t,eventName:e,listener:n});}}class ZephElementClass{static generateClass(t){let e=null,n=[];return class extends HTMLElement{static get observedAttributes(){return t&&t.observed||[]}constructor(){super();let o=this;this[$ELEMENT]=o;let i=this.shadowRoot||this.attachShadow({mode:"open"});this[$SHADOW]=i,(t.html||[]).forEach(t=>{let e=t.template;t.options.overwrite&&(i.innerHTML="");let n=document.importNode(e.content,!0);i.appendChild(n);});let r=[];(t.css||[]).forEach(t=>{let e=t.template;t.options.overwrite&&r.forEach(t=>{[...t.children].forEach(t=>{t.remove();});});let n=document.importNode(e.content,!0);r.push(n),i.appendChild(n);}),t.assets&&t.assets.forEach(t=>{let e=t.data,n=t.contentType,r="."===t.selector&&[o]||[...i.querySelectorAll(t.selector)]||[],s="data:"+n+";base64,"+e,c="url('"+s+"')",a=t.options&&t.options.target&&t.options.target.toLowerCase()||"auto",l=n.replace(/^([^\/]+)\/.*$/g,"$1");"image"!==l&&"style"===a&&(a="auto"),r.forEach(t=>{let e=t.tagName.toLowerCase();"image"!==l||"auto"!==a&&"style"!==a||"img"===e?"image"!==l||"auto"!==a&&"tag"!==a||"img"!==e?"video"===l&&"video"===e?t.setAttribute("src",s):"audio"===l&&"audio"===e&&t.setAttribute("src",s):t.setAttribute("src",s):t.style.backgroundImage=c;});}),n.push({element:o,shadow:i,context:t}),e||(e=setTimeout(()=>{let t=n;n=[],e=null,t.forEach(({element:t,shadow:e,context:n})=>{zephPopulateElement(t,e,n);});},0));}get element(){return this[$ELEMENT]}get content(){return this[$SHADOW]}connectedCallback(){fire(t&&t.lifecycle&&t.lifecycle.add||[],this,this.shadowRoot);}disconnectedCallback(){fire(t&&t.lifecycle&&t.lifecycle.remove||[],this,this.shadowRoot);}adoptedCallback(){fire(t&&t.lifecycle&&t.lifecycle.adopt||[],this,this.shadowRoot);}attributeChangedCallback(e,n,o){fire(t&&t.lifecycle&&t.lifecycle.attributes&&t.lifecycle.attributes[e]||[],n,o,this,this.shadowRoot);}}}}const zephPopulateElement=function(t,e,n){n.attributes&&Object.values(n.attributes).forEach(e=>{let n=t.hasAttribute(e.attributeName)?t.getAttribute(e.attributeName):e.initialValue;null==n?t.removeAttribute(e.attributeName):t.setAttribute(e.attributeName,e.transformFunction?e.transformFunction(n):n);}),n.properties&&Object.values(n.properties).forEach(n=>{let o=void 0!==t[n.propertyName]?t[n.propertyName]:n.initialValue;propetize(t,n.propertyName,{get:t=>t?t():o,set:(i,r)=>{i=n.transformFunction?n.transformFunction(i):i,r&&(i=r(i)),o=i,(n.changes||[]).forEach(o=>{o(n.propertyName,i,t,e);});}}),t[n.propertyName]=void 0===t[n.propertyName]?n.initialValue:t[n.propertyName];}),fireImmediately(n&&n.lifecycle&&n.lifecycle.create||[],t,e),n.bindings&&Object.keys(n.bindings).forEach(o=>{let i=n.bindings[o];if(!i)return;let r=i.source.element;"."===r?r=[t]:"string"==typeof r?r=[...e.querySelectorAll(r)]:r instanceof HTMLElement&&(r=[r]);let s=i.source.name,c=i.target.element;"."===c&&(c=t);let a=i.target.name,l=i.transform;r.forEach(o=>{let i;if(a.startsWith("@"))i=(t=>{let n=a.slice(1);t=l(t),(c instanceof HTMLElement&&[c]||[...e.querySelectorAll(c)]||[]).forEach(e=>{void 0===t?e.removeAttribute(n):e.getAttribute(n)!==t&&e.setAttribute(n,t);});});else if(a.startsWith("."))i=(t=>{let n=a.slice(1);t=l(t),(c instanceof HTMLElement&&[c]||[...e.querySelectorAll(c)]||[]).forEach(e=>{void 0===t?delete e[n]:e[n]!==t&&(e[n]=t);});});else{if("$"!==a)return void console.warn("Unable to handle binding to '"+a+"'; Must start with '@' or '$' or '.'.");i=(t=>{if(void 0===(t=l(t)))return;(c instanceof HTMLElement&&[c]||[...e.querySelectorAll(c)]||[]).forEach(e=>{e.textContent!==t&&(e.textContent=null==t?"":t);});});}o[$OBSERVER]||(o[$OBSERVER]=new ZephObserver(o),o[$OBSERVER].start());let r=o[$OBSERVER];if(s.startsWith("@")){let t=s.slice(1);if(o.hasAttribute(t)){let e=o.getAttribute(t);i(e,t,o);}r.addAttributeObserver(t,i);}else if(s.startsWith(".")){let o=s.slice(1);if(n.properties=n.properties||{},!n.properties[o]){n.properties[o]={propertyName:o,changes:[],value:t[o]};let i=n.properties[o];propetize(t,o,{get:t=>t?t():i.value,set:(n,o)=>{let r=i.transformFunction?i.transformFunction(n):n;o&&o(r),i.value=r,(i.changes||[]).forEach(n=>{n(i.propertyName,r,t,e);});}});}let r=n.properties[o];r.changes=r.changes||[],r.changes.push((t,e)=>{i(e);});}else{if("$"!==s)return void console.warn("Unable to handle binding to '"+a+"'; Must start with '@' or '$' or '.'.");{let t=o.textContent;i(t,null,o),r.addContentObserver(i);}}});}),n.events&&n.events.forEach(n=>{t.addEventListener(n.eventName,o=>{n.listener.call(t,o,t,e);});}),n.eventsAt&&n.eventsAt.forEach(n=>{[...e.querySelectorAll(n.selector)].forEach(o=>{o.addEventListener(n.eventName,i=>{n.listener.call(o,i,o,t,e);});});});};class ZephObserver{constructor(t){if(!t)throw new Error("Missing element.");if(!(t instanceof HTMLElement))throw new Error("Invalid element; must be an instance of HTMLElement.");this.element=t,this.attributes={},this.content=[],this.observer=new MutationObserver(this.handleMutation.bind(this));}addAttributeObserver(t,e){check.not.uon(t,"attribute"),check.string(t,"attribute"),check.not.uon(e,"handler"),check.function(e,"handler"),this.attributes[t]=this.attributes[t]||[],this.attributes[t].push(e);}removeAttributeObserver(t,e){check.not.uon(t,"attribute"),check.string(t,"attribute"),check.not.uon(e,"handler"),check.function(e,"handler"),this.attributes[t]&&(this.attributes[t]=this.attributes[t].filter(t=>t!==e),this.attributes[t].length<1&&delete this.attributes[t]);}removeAllAttributeObservers(t){if(t&&"string"!=typeof t)throw new Error("Invalid attribute; must be a string.");t?delete this.attributes[t]:this.attributes={};}addContentObserver(t){check.not.uon(t,"handler"),check.function(t,"handler"),this.content.push(t);}removeContentObserver(t){check.not.uon(t,"handler"),check.function(t,"handler"),this.content=this.content.filter(e=>e!==t);}removeAllContentObservers(){this.content=[];}start(){this.observer.observe(this.element,{attributes:!0,characterData:!0,childList:!0});}stop(){this.observer.disconnect();}handleMutation(t){t.forEach(t=>{"attributes"===t.type?this.handleAttributeMutation(t):this.handleContentMutation(t);});}handleAttributeMutation(t){let e=t.attributeName;if(!this.attributes[e]||this.attributes[e].length<1)return;let n=this.element.getAttribute(e);this.attributes[e].forEach(t=>{t(n,e,this.element);});}handleContentMutation(){if(this.content.length<1)return;let t=this.element.textContent;this.content.forEach(e=>{e(t,this.element);});}}class ZephComponentsClass{constructor(){this[$COMPONENTS]={},this[$PROXY]=new Proxy(this[$COMPONENTS],{has:(t,e)=>!!t[e],get:(t,e)=>t[e]||void 0,ownKeys:t=>Object.keys(t)}),this[$OBSERVER]=[];}get components(){return this[$PROXY]}get names(){return Object.keys(this[$COMPONENTS])}has(t){return check.posstr(t,"name"),!!this[$COMPONENTS][t]}get(t){return check.posstr(t,"name"),this[$COMPONENTS][t]}waitFor(t){return check.posstr(t,"name"),this[$COMPONENTS][t]?Promise.resolve():new Promise((e,n)=>{this[$OBSERVER].push({name:t,resolve:e,reject:n});})}define(t,e){if(check.posstr(t,"name"),check.not.uon(e,"code"),check.function(e,"code"),this[$COMPONENTS][t])throw new Error("Component already defined.");let n=document.URL.toString(),o=new Error;if(o.fileName&&(n=o.filename),o.stack){for(o=(o=o.stack.split(/\r\n|\n/g)).reverse();o.length>0;){let t=o.shift();if(t&&t.match(/\w+:/g)){o=t=(t=t.trim().replace(/^.*?(?=\w+:)/,"")).replace(/:\d+$|:\d+\)$|:\d+:\d+$|:\d+:\d+\)$/,"");break}}n=o;}return PENDING["component:"+n]=!0,document.dispatchEvent(new CustomEvent("zeph:component:loading",{bubbles:!1,detail:t})),utils.tryprom(async o=>{let i=new ZephComponent(t,n,e);this[$COMPONENTS][t]=i,await i.define(),this[$OBSERVER]=this[$OBSERVER].filter(e=>(e.name===t&&e.resolve(),e.name!==t)),delete PENDING["component:"+n],document.dispatchEvent(new CustomEvent("zeph:component:defined",{bubbles:!1,detail:{name:t,component:i}})),fireZephReady(),o(i);})}undefine(t){check.posstr(t,"name");let e=this[$COMPONENTS][t];e&&(delete this[$COMPONENTS][t],document.dispatchEvent(new CustomEvent("zeph:component:undefined",{bubbles:!1,detail:{name:t,component:e}})));}}class ZephService{constructor(){this[$LISTENERS]=new Map;}fire(t,...e){(this[$LISTENERS].get(t)||[]).forEach(n=>{setTimeout(()=>{n.apply(n,[t,...e]);},0);});}addEventListener(t,e){let n=this[$LISTENERS].get(t)||[];n.push(e),this[$LISTENERS].set(t,n);}removeEventListener(t,e){let n=this[$LISTENERS].get(t)||[];n=n.filter(t=>t!==e),this[$LISTENERS].set(t,n);}on(t,e){return this.addEventListener(t,e)}once(t,e){return this.addEventListner(t,(t,...n)=>{this.removeEventListener(t,e),e.apply(e,n);})}off(t,e){return this.removeEventListener(t,e)}}const extend=function t(e,...n){return null==e&&(e={}),n.forEach(n=>{Object.keys(n).forEach(o=>{let i=n[o],r=e[o];void 0!==i&&(null===i?e[o]=null:i instanceof Promise?e[o]=i:i instanceof Function?e[o]=i:i instanceof RegExp?e[o]=i:i instanceof Date?e[o]=new Date(i):i instanceof Array?e[o]=[].concat(r||[],i):e[o]="object"==typeof i?t(r,i):i);});}),e},fire=function(t,...e){(t=t&&!(t instanceof Array)&&[t]||t||[]).forEach(t=>{setTimeout(()=>t.apply(t,e),0);});},fireImmediately=function(t,...e){(t=t&&!(t instanceof Array)&&[t]||t||[]).forEach(t=>t.apply(t,e));},fireZephReady=function(){FIREREADY&&clearTimeout(FIREREADY),FIREREADY=setTimeout(()=>{Object.keys(PENDING).length<1&&(READY=!0,document.dispatchEvent(new CustomEvent("zeph:ready",{bubbles:!1})));},10);},getPropertyDescriptor=function(t,e){for(;;){if(null===t)return null;let n=Object.getOwnPropertyDescriptor(t,e);if(n)return n;t=Object.getPrototypeOf(t);}},propetize=function(t,e,n){check.not.uon(t,"object"),check.not.uon(e,"propertyName"),check.string(e,"propertyName"),check.not.uon(n,"descriptor");let o=getPropertyDescriptor(t,e),i=Object.assign({},o||{},n);return o&&n.get&&(delete i.value,delete i.writable,i.get=(()=>{let t=o.get||null;return n.get(t)})),o&&n.set&&(delete i.writable,i.set=(t=>{let e=o.set||null;return n.set(t,e)})),Object.defineProperty(t,e,i),i},contextCall=function(t){return check.posstr(t,"name"),{[t]:function(){if(!CODE_CONTEXT)throw new Error(t+"() may only be used within the ZephComponent.define() method.");return CODE_CONTEXT[t].apply(CODE_CONTEXT,arguments)}}[t]},from=contextCall("from"),alias=contextCall("alias"),html=contextCall("html"),css=contextCall("css"),asset=contextCall("asset"),attribute=contextCall("attribute"),property=contextCall("property"),bind=contextCall("binding"),bindAt=contextCall("bindingAt"),onInit=contextCall("onInit"),onCreate=contextCall("onCreate"),onAdd=contextCall("onAdd"),onRemove=contextCall("onRemove"),onAdopt=contextCall("onAdopt"),onAttribute=contextCall("onAttribute"),onProperty=contextCall("onProperty"),onEvent=contextCall("onEvent"),onEventAt=contextCall("onEventAt"),ZephComponents=new ZephComponentsClass;window.Zeph={ZephComponents:ZephComponents,ZephObserver:ZephObserver,ZephService:ZephService,ZephUtils:utils},DEFINITION_METHODS={from:from,alias:alias,html:html,css:css,asset:asset,attribute:attribute,property:property,bind:bind,bindAt:bindAt,onInit:onInit,onCreate:onCreate,onAdd:onAdd,onRemove:onRemove,onAdopt:onAdopt,onAttribute:onAttribute,onProperty:onProperty,onEvent:onEvent,onEventAt:onEventAt};

	// (c) 2018-present, The Awesome Engineering Company, https://awesomeneg.com

	ZephComponents.define("rating-stars",()=>{
		html(`<div class="stars">
	<div class="star">
		<img class="set" />
		<img class="unset" />
	</div>
	<div class="star">
		<img class="set" />
		<img class="unset" />
	</div>
	<div class="star">
		<img class="set" />
		<img class="unset" />
	</div>
	<div class="star">
		<img class="set" />
		<img class="unset" />
	</div>
	<div class="star">
		<img class="set" />
		<img class="unset" />
	</div>
</div>
`);
		css(`div {
	display: flex;
	flex-direction: row;
}

div > .star {
	flex: 0 0 auto;
	cursor: pointer;
	margin-right: 3px;
}

div > .star > .set {
	width: 0px;
}

div > .star > .unset {
	height: 20px;
	width: 0px;
}

div > .star[selected] > .set {
	width: 20px;
}

div > .star:not([selected]) > .unset {
	width: 20px;
}
`);

		asset(".set",`data:image/png;base64,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`);
		asset(".unset",`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwMi8yMC8xOZNFLMwAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzQGstOgAAAAvnByVld4nO3Wyw3DIBCEYXbplbPboRkXENFLOghZRB7O48xEyv9d7NugAVacLvs5bWnrvbfWaq2llAQAAAAAAAAAAIB/5S6Nt+ymzHczZQEjPAvzR/nCAma0poDYeJ9nz7LFMVibnuPce7qH2ljM0ho+b93iY5DfFrB8Dr02ILgExwYkd/DZgEmG8DFfEK/P//q7zhg4Nu+dYv9H6TGB4wUgyrfb/I+PIt/zY9dd/AoDAAAAAAAAAAAAAOBXXAFjRA1pL1exigAAAEhta0JG+t7K/gAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKaQzoQAAaNxta1RTeJztvUuTI0eSH56cbZL9IpuckWZltgdB/O/OdJNTxXzgSQ65KgCF6iLrgQHQZBXHRmV4dmO6u7qnXuwaGEwXfYG96aSjTpLpIF1kJpnpoMPqS+iqk76BDv9wj4jMiMjIzMgsAFXNyQZZCWTG8+ceHu4eHpG739YvZt91utNZf/5dZ3c6c+atTkO4dH63N525/X7ZGQ8n84OdxmRmzw/p5fvt5mTm2vPH2z28dja7k1nFnXe6T6bkcX2LlDDBf/P2zs7FrN4mfxobvdOZdccaWEPryGpbY+uYfJtaL+bbe7vkyV3y5Jg8caw18nRqvSEpXsw7zf0BFLmxhyVvkAZ74+q83tyGRtZ3Scsn5IL9qHc3MVG3hc+6j/FS38Gb9W/x0thjBWy28Henh4ladfzV6uBlj97stqezWnle79GHPVp6r0sr2aXl0cv2BrRyD1plz5v7znRWJRcXimnue3hpkZsuubj04sFlboTMX+uQsQrWBrl7Rn6vkW8vyLVvnZIno1Vi5lwRM2dZmN1jmG1ZJwSX19Yz8uzMGsdiU6TYjGOwsbXYDIcSNnYMNsMqxcZzU6PjFCk8fQpPn8JTpfBUKTzVebf9A6llMO922bW9T1Ar9ckN9sUMwI8ZgA3rFWGuVwRGwlqE6cSUIpikYETTLcWh2TdAU+G0ODQVTusvdnQihOWyBsJuu06fdOlVhPQ2g7SO43FqDRmgDxigXQLmhPBiweqQb+fk3ihx1GqxdCbFxY5bb5hx3PbTjtskjB6T+yfIblfEaMGzQQqE7OUgdD/ERTvk6XEWyabyj9FovNn8cz/EP5nRMZH7N5JzuEhvIjbPcNxQdD5i6AhPyK8eQWpKZsgXCSi5N1QGeSvCqYmSaPDW4uQuHKcPtTixsZceo2sfcU4MQiWKUIkiVDJE6EEEQmPy+8K6fCvnfEfWRksUphKFqU9h6lOY9LqmKUyBcH8bh1scM2Ubbnd8lF6Rif9shUpjrAo+LGac9W0KjU2hsSk0NoXGptDYEjT3GTQbhClOyNxeJ3/PASQG0G0GkBnjAEkFfMpFChA+TwSoWowBCG07AaLRFed+lyLkUoSKFKEiRahIDT4gq2TxQTfQXCE30mDI7eYeYa83hMnOqeEXj6R2DMYD6dQYlO4gznhWoUxlPmcG062ZgfkhA7NBGO4FumCe+u6GS4Upf0egnEIqCcpiiWLpDLh/pig7aGwK5jAOy0nfZNgizwpQltm4hdzpBq5bNYbSqzIz2nNGAZZpMXyPYfg9YcUzCb/KiOJXUeBThF6coQNZJfTcZKGX2dIxha7OfDj1K/GcXhByzKpDitl4QcqYHaeMuUsFLC1AdwSAXpLvr6xX8V5TxlaOZ+xdcOxi+sm0ZFOYcJYGoCZxLq3FjMqs2HXI0wFidxzLXk5tsfx1HQNSxOiej9EztHSGBIG+7zZ9X/bPGHEVQwZlfKKK5rhDBg9MgYbwlMeMryAzAISOU7N505CvOoSd3PGYfKmHhXw8Zpyj2iiuzpLXfWTcKF5Jw3FSzAAbnyIZW6H2sVDU2nxq7HK9A+ZIqoDwL+0610D4lw4TEekhbqA6B0Iv3vhUIQa+0cykCsaVYfqRW2Qu/D7D2BsVlwKyrIjUuUM/NZJZFGS9VoIrJdFgDt30YPrqccmlaNIBb4amMzbWTXx2dCda47WBs8Ylzg2yXOyQ+88TPGhVilaNooV6qzC87asarkWKFYUG+lBlGjDaJAAWrGUBWm4MWiVmvpLpjZr2NYpXmQFWZoiVGQNSdoMvg4myogSaXucxTvZmYKYzdGU7F+2tjEsjJrIyjKYB63mujvXKDEkGZBSOvrTkOBoz5W1/LMPy8NB6nmYUGwFpZprpkcTBDBJxsPDJGiUijmEOZEecf+iMFI0ol5AtDESARageLCEoQ52ierzYRTtDv4G9mIAEPZzl0JJ7naHYrYeX2OPB4j70x6hrP2M69zPUgk60C+w4MSA/2pKcpNNJSE5qVWvUhkxtkv5SwTOHinuJd3yICtYuztDPQ2CpfoGh1kPlxhghgZ6dQZlZGqOJ00agyXDWc6rjDKzXZBhGoxkxQacRhE5pbOI6XTGcde45DftZ3mPY7WtiYsBpCjohLDB3cem0zzzy8bj1tfaewUQMhlWMZ2/Yp7C5TLMZuoq5N2JaIDWVEuYQIi0peFWGXpXCN2ShRkMG4LCqzsjwpcO/hINmOv4XrkK2O2zW6XS4adMNW486UvxCr4Yzj/YU7cikldpKxogRo6mHaZmTvuLRYUxcHEgqZlHHxeWinhAltkhSYqsk5Cr7relE3sF5u9vtsHmc/Yb53JlQpJ1JItB3BZ43g7WfEVbUc5Jg9RTlnStJ3DRHmR5S3R0DQwfuthjaLYo2MjNit4GURJ6GsC/AsFg2xvCe7xRagazwRkayQrEYfVER63GMMIGKzAQqUiS9IUUSrx5eEUk65LViAaUwcCyi26Fom8qCuz68Z6jiQ7TYqckExt25fO3P6Y+vuvbH2LSksKk8g4E+2sWY62hw+eA3BZcD50x8lR0BVFT3Dxh+3yMbjpl7AwM8M6jvE4bjRMZx0l/QaL+qCqof6a7OHKJKlDh5+VaQ6iVPxvC2r9WbRHoo66e+Im+2Vg+unpR2kD/YUVZcyT2kDT/2PZqBjY5aFv/S2Rf41ab8qkTRmmNsZry7Va0LDlXXBSLMbXeP+99K5gDrlVZPx6wYehwVnKzzfXSYWHxlvVTWVFugOumgGxSliYiP8TQzUWxcPLK5zh+nl5VsQvd0yA2rekWpxjT+GnMh1cp0Kscpnbs36oF6xN0diikQDeL7lhiSEz/neDoGVNb1tca6Z5urmwhqGMRBMdmh6U84ikMT6IIo0i8e/UIVTmJvUoUTvqAyX7apxonzd4ePd6oupcP0EI3R+PlHHtRGC0FGvCmDOtBGOCkavHb+iZrEo5zE8ioFY0Wcxo1ZkuuasG/j2JpAxARsEtLB6JTYEC/LQ7yfYhYva2WjrZON1CGcJQ6KS0Z554vLRCNePbxSliuzKUWdt6NBCzTIPxFx2EdbMn40l7IuaqeYTKjNKBg5KVZtCXdqRzPcb7H7LXrfF4k4UVfYPF2hA5qLRhzPj6lpqYsne0LwO8a5+hx1cNVl0iJzNwRApXWZ6B13RjF63G/naO2gUVHymfS1KqYzNlfU1cnHrertSZSVHd/xERaNppDCcvkUtwAuHdLQMoanxbRWlf1QE63g1JvoyoLQUC84dTO6uuEt8EAx/hU9IBR90sFKiQrWcjrw32Xge1Yzw5JvJQ3fxkkIT1Y3Fa6t6HxLZra7lmsfU00+DU73/WnoGYYbgAN6HIoVUlErZ3UdOeZOZd8I8srpFyq5EZS0B/Mx18kfh3XyJOj4ZLRP7p/hglDSBiZHq1umk5Ilc1+mwm21ZD2Ir+8qE/iCeO1uMCaJKNxCK/HHpQOmnVZkwIZaZZxPKrJF46x0eP6SQfYd+nSHuLXpFLeUA7/BDt9CML+kn01ovJApktrJRBZ0CpJoXoenklSSzmNuII9twyBXnErYqrg4W7eZrSg5MFBjEnzsVdnFHhF3H0WQD3xvxiu0JZ+RCZ1Fw8Vz8uL2v8ThX9XG74JTRYDfTePHjOJkavl0w9p7EoIfCgi+QY9QAb1HqTHECMEUOxh8HIvJNlDm4yTAyDGYeNDpNqxoAmNwrRNv8C+cW9vMzIQu0jU4we5E//u8tdO8mLXE/bcTpEUXfXJTYYvSBGmwhwcGvETqPIl8wmjSooC0KCu2KEO1NhG0VqeJSTod+uwxvRzAZd4STTvaILbdF0w4pUnikyeRT7I1yaVNIpctv0Ufk/YM/QMoRkyqngnnKZz6Q3/IVthAgx9azwnb8uMqWlvfEeD3GrTwbfJ9qw0nsLToESs2/psLjxz+iJ2/As8O4Zl99XKcjEXwR/CvJUYnTFhc1hTdu+fYf5VuHYZemJXEJ9no5lG6eTnd0tDtQ0a3DkFmSHoLzpSnCvU+9GmkS/PEIE02ivYpRfs5RdNQ9K4/EsFnCFOnqFxPBH8if/Yk5lk2yhUp5Yo55bKMRUqBM9TjTzheyljUp3likOZK0tVxcpKmIWmgW/XxdK8gWHnCfNT8/pOI+9nIVaLkKuXUykKtNiqRQ2Ev+oQ5afn9JxH3s1GrQqlVyamVhVotRGTk48GpEtx/EnE/G7WqlFrVnFppqPUBo9Ym24v6GuWbqJx8wOijS/EkMUU2WtYoLWs5LdPQ8n1Gyzqurp76a/0TfyPTiT/q1LvZ6DSkdBrmdEpDpzu+cQdjhZ4KphrkwRPVIA+eZKPZiNJslNMsy6z2PcYajkOzWnD/ScT9bNQaU2qNc2plMbbbwXK9r+Pf9bVD8dmTmGfZKDehlJtIDbvvs9HYGlhNJMUzjCbgS7qcbdTnTxKeZ2ukwzy9cG06AqKtpiv98qRfRelXD0qdz7fQgZ2FTT8W2PScpDrEpWxcYuT3BHb1RB5ZD1hhYLv9/lx6WPJZbTQhj+WHNTWnys/LrGgBDJ8J6o8Y1JsYL4BrOxgvtIXxWCSXAHRZ1zbX9oZy2+x1t8qfOoNaxRnIT4s+OM64OCG/pKdl/rDcHw9tR35YKUUX7KgtUsn39jX/upmCj78ObvMSRmHU6PMbULPtgRs1JCZxM4CWdMuq5LoAvsMAhiegvYHADiAt6lpTqxTLjiJlPL9Lg1F1qHBi1X9aHrpjp6ztyHgyGgxHYcCvpwnXRY67jBzCYTjkWYLgI50ql8tRkqNqV23QZfSSo1ymmo5WckDGyiRKctCKIxi7Qv4zFHw3uvnXzQhU4IVVDW17YkQNF1EqRa5QznVBc49B00VxNcRtf+fWy+RRoraIsJn4MMRlQYPdfiSTQT612Opc4LFI2c9QMBsiN7Xt1z1vdfFYzQtl3tKCWPNqhHuj5EzRhU+UnBmUBt7AiYCxXA4LsEDOjMbw0YIAsq1qygM3uvnXxQYPGBtAJOMrDDI+s/bZNuCnyQLTrdn9Ui1qDtAqgFco57pBonOJb08lGbBxwqc0jxQhUrN1zphlVXJd8HJXlu/ACpxayRO2qr6EW2U2YZuUc10AfSjYGAO068/wpA6V+7Riz7a9qjqBBWKPTG+1fiVK7BFVpRwz+YWzVmKyOmqLjKT2jW7+dY+Yvwjn72areTHbbAnrmmOEaRsjmcHTVSd/L/DcUwrPzxE40G1e+vHgND3qOezw/81292LWbGzCn29RLa7jlpEzDOLpYkgdANpsfEeevmOR5kipN60JbhAFBXoXDzTatpos9d9ZM6uCT8uWQz625Vpr5PuQ3IFvcG+Eb6SrknsV8sTGTwlTVshfhzyBX3Op1rvC8V0bOEW/8Fv4VySPZ5WU9F2SFpyt+0Ry/JG2lqV/l7QPZMkpKUHO4+NJ2Ar2HBL8WJ6fQV+k1HdIDS/Q9zG2etYlXH3EXCUl21sSKjWM7WPUSulk4LM/S/2+9f8h8uyj5OzijqkR1qPLaQcfpXVBr9V+yCl/TbjqOUGzhW0c48R1wtq6T2jyguSmJyu9JKW8wsF8Qu6J/PKEpN+jO7tYLfcEfi4IHC3W/EFAc/8NVpDjlAgG3lZPyRH0igennVDXiE/RisIz9/Egs1PSx6g6bKWOgCeb7JCjPkbniJyp4v1A4JtdDFs9Y+9RmqItwutylFwiitukLroFZ8reLERz3WIm7Vhp5ybhi6fIp8/oHmUcGy+ILND37GOfY6k0OInsoZrzQzzT4EemI4I0GoW48Y7MjWTsTpS+0i1skoTT8vSIIKLj6Q9wHJ0ltEEYS5o2bLIT3gn9Ccf3UYIl9QTbAYI7hcx+n8nsFt2Im0vnpUtnNWUunXPpnEvnXDrHSecOxt0+zaXz0qVzKZfOuXTOpXMunQ2k8x1fOp9jS4CauYRetoQu5xI6l9C5hM4ldAoJLXikcwm9dAnt5BI6l9C5hM4ltIGEvssk9A/ISz+Qmp5abi6jly6ji7mMzmV0LqNzGZ1CixZkdC6hly6hvVxC5xI6l9C5hPYltKZHeeTdjZLZP5XIO2clMjvg51xm5zL7L01m55F3eeRdLp1z6ZxL55ssnfPIu1VJ559K5F0unXPpnEvn5UrnPPIuj7zLJXQuoXMJfdMldB55l0fe5RI6l9C5hL5pEjqPvMsj73IZncvoXEbfXBmdR97lkXe5hM4ldC6hr1dCN0lfgObCKFXWCRnPaaRzkrztE06uWUXyGZEWVxcib+PlidrvsuLZXZak4CgWJBwXNU4+lPqs53eYB1zNTMNzxUeMyGnpOaDBiK/GUCA853mkJaXU3PaAcVtwAOWRlOpt5L6+QpGfLve9Y1WWxHvFK/Peh4z3RLmpaqO3GfdBXDHRvvKYtUy6aDhK+KcfseatYITfD/iSjHGBj2+kLuoqdeS6aK6Lij1xAPnMErpDapmiVMoldC6hTST0KnSwDwK+tEa5jM5l9Fsuo8P+ggfS2CwgevRdkC8kK66LJU/xmZhjHT4ZrLgBseFs8rSG0nSMUriIeHEpDJZdn3wmRPJyuwtSV8nvCRkbI5J+vgIZkNR3sQV/Q/paJ3VMsAWUQ45IXSfIJTB+fiS/z/z2wfj4s1/Tu9j3AvyVSr1tjQx9A+9afWX2+RlBqaSkGSbwWlYuuS/tab6alV9ic+8EZ12YmyvkUyTpOX945NsAOWTkc3cV5/UJchLM1Vez8ksr4K5ozHI7Pw3v3ZVw5M/S852LPFUlvEbGFvIYyBuQQNn5Lk7HKq6Ax/TYpNVGyqm1keLCeDj7fG8+V0fPkfcJp46Iln6O9RWE3JT33hP3rWfguRHhrxLhHeC4GlofIPNGBHHVIqn6sglkIkjDEfkfNJTaSuZCuadLmvlSYX+PPD9H27BAtF1O39NMVLAJomOSBpCmVHAIgkUNFdxrpUJUn5evidwl8hpa8pL8PcJxex4TyymmPSG/BoYpx4Le7yjzh5jyqcXfV65P/THp1SuYjVA3PsIXXz3FcybUnH+FI1CWbx9F5pb7bZKXyi5di1W7YIQy9EyqT8ROV9uHEbXJSEbXxNOr9FQtp3COpP480PbHBP0HkeiLvdLlvK9pp8x9ZpjH16K2zxTDKEpFty8OiSS+0PUsmXv1CCq8lEpK3xHlVGabUZbQri+hSzdOQuv6m0vnXDrn0jmXzjdROjewBxdYblbp7BE5C/J1gPbwGGVUjdnQgeUMz6H9Nnr9bGbxgLVTQutmNdI53N/lS+f7wcjC0l5ZU7SzT+dbbUKqrXbvYnaw04DXnh7Syzy455ZK9C58UdeekPoLLfMe58OFt5SMiauXmYq77wqvxS0wTnqRSfsYoZXeZ7oEeKddjEWSPUPA831p3RC99xitNA55hoIVANh1OIqUTcvyDOmwWZTX5t3IVULdmsj7pB+vcR0DenXpS0Ang0fmlwTXE3/ti/mlrM9V39aCZN3Ql3XOjZN16ZBYvhR8gKsPYs1H2F6YQ499b2N4vW+g6UVkzlS88rH1GCXd51YXIwvOsWXQL2jnYjhk5HOIe+M4xKT/q7BdnrH5xoQbTjUtNcn5Ea7jGXKRNHc/Q0vuKFg7U3olxGxI3PcuoQycbToW5qMWzn00noCue2fxV04wQsUmHAOzC0ieCa6PBitkNlrDMOtcrzWs7/GSeCoB/Y+Y5OOnzBaYH3WDlPwa1pkyrRkBDVwctX0c4UNyLeIKtuiXKOEqkVlE0XIokdz7VVDllr9KSGkS/M4yChzybILWV9H32nP74yb5hIJeXgfGHyJ6XFYW+NPM81uJ4FZF7i0TpMoofSZszaqIFJighuxglEcJoz0g6g7snyqm6Ie04eXgHt9zsf5/gvNAMJ8MWMqjmPgLewVz48eR7QpHe9RC+o/KCfetHyw43+TlArigxnZhAN3Lvkbj4uiDHRoD5ALgkzJaTgPkgAnaUi7qQCADV8EF0b1ePv0+Imlo3TLtVK3jZwQPVdPR5fwTufatF5Kd9DOQbokyoIPW6xRzX536I5S9HkZtFHHec7H8KlIfrKESygCQsBOUAiOcKYsojScofYcrkgFxPV8+B/wc28nrT8sFv4jMnZUT7vgIFJCyJ9q463Rzr3uD515df69jFv7I2iLtOke7Y4rSexGjUFwVs/1VMe/GUSG59/Js/FRJLXI+HxHnfrzRz0mP1tEeiv6UV0L191nE2gnGUB/7+27lu+kpPUT6gY0HUWrU4qO7FMIWX+VaKa329fpQf0Bad4zx5PRJwY9ayzreZKlXvMFSL6nvYgt+iXNQkPYIV3FPcb/umWFU/nLmzl/EtGwRUiCufN3sXArNrnrOuy/fvdJMC7GlLv5fYhGCNdS7KyGe41Gp18Vz0b1ejb9nD1eWwA/HqbCB1kYheJJ55I8RTxvjfAfoZxsi0h7qu0M258LfEu754pHDYOOM0VICPXg1VIjq9SqsnT7WfURaz+uOGUnSSNTlPGdXdddCtM/1fYvuO5QjxPm5F48x16t8n6F1c95eou4SuFk7DVcRo38rIi4/aV8hWHslJY9JLL+6vpEUy6/W8dPZWaj62sx3Gsjnp+Q7C02kMD8fbg9HBmhauliMXBJflyQu5ZJ4xZI43a6q8J7PXBbnu7yTZPF7JM8L1L9HhJP4rjXxXhY/yARX8qi9OWQrPjVhvxTdwW0TKXq9O7jlni7fArpH2sHrC9stwDHcE+GFTu6EkX8Zkwv6Sa4G9P0YxwrF5QT5D3incEWqj3B1r4IzZQ2pXsYVnZpE9QGu9tYkqsP/E0y7mnVfk/7/FHnh5xhlc8n6SndLX5LvRUYN2DO46Wtju4glSu8rrEBUcYYZ48imfukqxgWIfukyxr94uPYPf+lvuI7w3mrWgcL9XYVfKg1NHijxCj3sG9R4ffQpreysjfi+3zRaiRoerGXRefq66FRbmWyN6/cqaPQLjFibWtTD3CU9nLJvoMGCtShS6XYQdbhk2lQIRSoYDVHBqAj4W8a5soTa0SpoE+7tKihyD7EfY/Q+2LJ8LwGPx2+jrn+GnPLMoqeagt1ygeNM7FEWrQRW38ZobU7QVof1kTHm4NTpoy5awXFis3MUXKa51sgTiF9aTTx+GiTS215RvoRbqA0NBcvToVbCfLdLiDj/Af+2N3oXs3pjZzqbTMr4b96ivyYTm/yb9w7qFzNK03eJdUal8zEp49uL2fftg+msas8fs2uv+8N05kCmbVJ2b7s5nVUmo+IEq+0dtBZT0HzzoH0xa+32SJJ5Y6cDl/YO/mpvYJ929qYzm1w6tJB2j/3eH5A0G+0deukOyM2NjQb+2mjipUuKGZOUTciwBYXa82/av5vOSkNy7dKf+/TShvxbrW24fNOFNH1y3aQ/e1DcN906/GrttCFHaw8at9XdgXs73SdwadLLTrcJl0Z3F7JtNrrQmb3DLvza6eKvx71dKORxj469Jo5f4LMf8YrxvfODFqY92MX29zpYHMkJl4PmBhbeOiAFWPO93eLFjPyZzspzvEzoxaEXW7mQawvSt0g353gh8mBzrwHX3sYOVtf+Hi4H0FBCmPoTrKdR78DdRn0D7zY38Fdz92K20+pNZvZ6ad7bb9MvnW12p77PvswbBwjhfHePVL+718Qy59u7CH57e4de4Pbforyt4NzosgjVCjulByzVEq6lrqENQ/dwVXB91UFrla+eErlCECetm2/vUEIdEqrtbBySUfLtFtx40kH+2WHq9PcE+AEO6D6qECfznR2EY7eL6XYbWExzG4nZ2AH5uQlFNr6F+5s7UNd8/t026d93NNF8HqrPZvW9H9RD6nSkumxalxNf11an7d/Y6iCD4/1277F/P1Eo1Nv+NHAHF0aPiJCjBtfUnwL+mjwBxy9MnW1y/w1THjbQLTYld+mU3sflvtG809yHyusbOFrrG4SVvXF1Xm9uA+fUd3eBR+u75HZ/Xu9uYqIuMmK9+xgvdQSjXv8WL409VsBmC393UETUW3V6Qbas79GbXTJCa+V5vVfHuz1aeq9LK9ml5dHLNg6jPWgVIeu+QwQWubhQTHPfw0uL3HTJxaUXDy43UZDWO22Umj1kg9Z+D/Dv7JFEjlNy3NKADM2DyWytSq6H5OrO240W9L7dhduV9ZJb9CrkFz5cd+xSteTN25vSw035YUt62JIf1kkj23XCoNtdFMv17g5sDG23G0D0dp1vD3X8PaPYWrc8IIKq25zMKutuxa0UCSV/IEXVf0D5VN/4AceYkN9bt2u2U6GllNdLVa9Uc1lhlYFDCyuv12q27ZQSCnNZYyrrZa/m8VKqA5c3ySnVKm4xqUlsw6vjrlfEcmoDj5fjeU7FTiynvO5Uba/Its9yhPqDIi/GLjuVUi2pGNYph4HjsXIGg1Kqcrz1qlMj8kNuzXBQTtWpCGxGg0oqjLWEGg+qErmTeIcks2tVz9HyzmRQkxhRzzukuAZwOkhRxunI4gNyCbN4u9MlP+ffbcJYWCfDct58gsIr4P39PSxEzK7n8ISygPXDZakMnlAIcL6mQSEaJhQDjK8pRmXvhFKA7zWlhLg7oRhg+3AxKnMnFAJcHy4kLS7A9OFS0pEIeD5cRgRnJ5QFLB+NcCr2JfZLb4OMkM19nGU2tnbpbbwrmDbvYrgQHooRsYx5G82tV/4i1+l8q9mTyoCjCWh40sjfGOqy0u5ZndCzQuilLOH8Tmx+2U38nnQkAl+2aAv3xNTvi4GPfj23/U0O55oWynnsiDyOcmTDHbZdmy+5nWmwu03MDmjlXogKnkIFWO5/E0rnh1Qqzm9YPgaXgro8S9tyovQOjF5YIHxJnj8NtfE91kb6lJb0mb+sWPAP1AtqLTDzHJZGIZDuGTOrCuheeoFmFt1Q7pH/X0dQ6j3WZ7HeRwn1Di0aGh/USMuYkus5bmAqoRtSqtOAP9RRoecIcAyovBnwdlRZYhqlpPl2t0sM9O0dJB7rOjGGv7uYfdPtns6+/9j63PrU+uqGfj4lrfuAjG9oY8Hw00C3zqUVHFlQsB4Suj6CUcnCS2gw9hBxewkWD9o+vyH3t9FyWjeurZCpjeoHrC+wx4I2n+KvMdpj9LCcUapWRbfxumlqQuvrbotJG7PSIvgEkojPkFcv8+2jNVzh/x4eFaBHpY/jA4JKTvE+TXnORsepxbfSD5kr7ozNIbSkNXK9FOYVKuvBQa/WPULHdZ+F5AQl0PlArHuCLaNtmmJw0hekHl7eGkmxj/pGwQqOXKF9CWaOAls44WUO0W9zhn0oYACS+GxqneBy9pi1G2j9kLTpJQvO6fo9W0fvDrjG15XaBZ3G+j2RhH8gUpGX1cOD0E4TWkznx2N0ohdws1MBg8sDCdVAT9KQLQs9ZX1ILplLO2gbbxMv+VRCIqqMU0aXEyH11AoO3x7is2OfZx5ifWPWD0rLRz4v6ajC2yXThnPJb/x7J+iJvJQ4kqPxa5Ie2vwc+/VrgQvXkAo/Mk6O6yVdZOP1n7GFDH2rFsUtDuGWgvUrLDl7KcUQz1GqJ/VYfcp7+coKXicr0jfodRe5D4L51giHgtb1lHzS8aYsfy6xVs4nnEdNOJS3iXNp2G7Jwg2mPL8oTnAXwgkliRPeZiqZSHpZprzAeeZs6WPWyyThxWei5D1GC2jAOIu2XJaptN18dn+btJBFaF492c+xkDLfJm0O/p/gSBlaQRgR8BUs3KvoPMRgERjfdN6kfDrDv+CB+BFzDQnvFYS0j9hznu4OqftzC16sARz4ElPxJ0O2nlWwPkHNbt16gcEWr6w/kjtfaNOJ5Yhp7lhwTJ8od78iz9vY2+c4A31ifamk1nilMFeH3T1n0s0xyutq87ravIJngeWS/EwJeRxNHrWeAdNrnrO7MjVaftDnMy3KE5RxydSYYIBMg9jH6VJHpRDbZULd4Lc5dTfIkxPkfUAvHXXVvObUvWSjzZy2PEc6ym7jDEXXivUjbYp1JlNLLsl0rIH0MKdFF7128PtVSkrIOc3pQLWW6Np0lAjypKNFF49sPcY5XT/OqJWbTAtId2TtWgcpU0elkFtmTttXqUZaB21OOlrG1p9TS1I1dzpZmo7Go0wU/gb1vT5r+ViL9R/JdxOqqWUlUuXf/uz1fzWnxl7V/tfpKMByGKHe/ebo35jizdKmQ7qBujHHBjSOLvr86aasCQZnjnztQ+X2cMq/Q1+zXGoi4v/uf5vj/f0v/tW/T4c3y3FT8e75JXPdEWYHPeL6tG8/5v+QAvN/SI35t2irjSNnbvF5Im7/ae1//Y9//Mgcu/8y/o//zyr84z/9z/8zHYJSPiMc/9s/+w//3RRHljYdjnUs58/W1NdeCqgrgo1+Tuby8xhp/dpQOwrXQblbV4+ZJpt+fqXaaDBL4kowKyeLXhtVkvm8m3bWzTLnNtGjGGW5HON2mGT6BaWYaz9jHHfm2g+3E7JYkXJeMwp0LbqFmh7jaEYFOU9a/fZHi67NRum3p9aFETXkktLZ9ScZLHvwl51ltOx53nTa6Di1NjpOSY8GbEWJHBdDQ0sjKCWZCrC1CbZ/meP/A6npFdtgeGz935QUCOc2o0HboltEX77zN+gZNaODmisNLWje6HHx2lBKieWkGRXpafLcOnnnXXaEw3Esv8bRRleKKY1orAfJ804zBY3kXOnkV0c6QFOHPxzUYEInuaRESt3657cat7669cWt+q1vzSl1629vfX3rX9767S07HW2kfEbUuFW4Zd8q3qqSVm6Y0kLJk44SPQsOLn0eM2LODD2ScknJY2YPuZZ6uvqp5pJDcvcC87zAfr14xyF/042aqDLMxswh5CQ5/g96DkzHjJorHaU2LXrQS5xP69iIUnJJYio5yiOOgnwV5itfWqbzB/Oc2hhUQzrGlZFMxyB3uhUAfb4kWt6x5ux6gloMjBUa4UKfz32KR68TbaB0Bxtnl9T51IpfKaL0uZmrRUL0qY/nwqNPNZQUom0N680YbZtqZL+da0I5DUUarm71J8ddtoTf1pWenI4iHVe7npNjH7/isIoVnpwG8TRY1apPTodFrARxeyhH9O1ZE1IjCnParXLFJ0f9Old3cvRXvZaTy5rrW7fJsb/+9Zgc/etcg8nRv7nrKn/p9DBfG3kb9vpcbc9U05L3WaurQVfbO/U27Zm6YHy4SzjxAF/Nsk/Q2SQcSnkVOPxLJeU2SRVO6QnjXlwPi9pBSF8/cWL1fdTlHViy5TlmuzGbFt2buY1Uout0ogwQ73c19W6QXw8t9ooKUmMwYvTyS5U8o8QWRKd6mLI+k76k77t/RGzK1oRpELzWRN75KbbJPFdadNK0YtF1yzQ2aYFZjrTtoHtIoMwftRQXW5CUNr7uuJVzM74bSSNCHutctpyhl5tHPDz0j18Ge/Apzlo7Fl1ZP8eyxniw8YlFj0UGL9Ql9uMRSX/K/OVQ9ydE2n0i9I/Xx9fpaX209t+z6zqL8npqwf7jNTx/QM1/5st8yG+20xR8xD9aBfFVUKzNtHReIq9DOttKqSkpViGpLtqb5B3e56hxQCRaE+V1n6D0iaWcq0bu/MFHUu5L1hrkvgfly/flumQKPWc5opDgFH3ua4j+CWUsZ3hm/FKydal+S/Pq96iLOtrnyo51sXZIE65dnW2/FLRqmidbrVejfehkOIE6srzilBiysf1VJD8MUSel0RD0qHd6wk4b9WN17HWEkYevuAql2BNSlEJPh8LTGaHdF6yF6+T7Z6R0GD+Xwt1LvDsPlXMilNMhSLsRvbexxCFpK7267Oqxa5FdS1J+Smf6atSCVbbiz+IwpWnUiQ2yzKN9Kiuzj22oBUfT2fx0oC+FWtdxfJnUOsS0ct7LFHkh7RpSUy6Dy7seyrvoMsJRcHI5sG74Emfw+LZ84lt0PLezIuwdCXvnCn13lHKy991dUd9dqe9upjbznOlQC8dvxpVGV6PhnKtTX6/kpVHrRsbPWxF+noSflxk/78r4ubGlpcOPyuG4c2v4aT3HzDekO5/mc/TZ0vmdt6y4IroUJboUU8vTsEwsppCrD5lkhTn0ESvrIaHQp+T3p4Q6n2s1sEdKbeacVJJ4qZiSl+QY7M+wxC+sQmKpacdkaUW0L0m0L11hLi2lnkvlvNlkAeS8sIQX3sTkDPwbOj2KntA1tIIzGl9b9MWa4XPMAp+smV7Fv40lHUa2P9pY8zO/b9nKDKj9CnVmfV0NKc1yagSK8tGq0x5trRQVT8nsW3HnXlI/4jOkDn9NUljjFUvkvvWHTIenf0+Ev3sLsn9Dp1QLNtAnfh8+MUY+qh5Zl6R1cG7vLLR0RyndnGuiS/dPhhbKXlzb/bOpQ6Vfve0BZ4tl09L3/NLpPfp9inO+3tcl7gKJsn+5Tc1e5KL1Im+gzKIejOi5RbQ8j5S2c2sXJPsa2tG/YZYuyOs1ycrl5dxBOXmCfM59E/pebKGfTl5hAVv+Ai15SP8S/VSPQnWAX4t6reSecLn8kDz/CiUKpPwtocGnqOPBr8/IJ4jaDJC+g/4Rk/kzu9z7Pan/D0JvZKzWMdUL5KoDLOfA4jrRMaMB0Ai+PSLykWtFj4xKPMQSD6USL/0SL2NKhJTgE35q0ZdqA3eJfFbH/c9vfNo9lNogljU3otaivBKLonecvpTT826CrIobN06i1pO11KvoPYuu01TzgZqp/46jIK73LLZNv7G4xs6/XUqUNeNjR/BimvOqmmt5aPM7i+D2eeLqVvx6rm4Va+jve13snBP2YDuZ64nDWu9pp6sRlIPXyXWAs3hwJ9DFHrJY2DO0+h0t7d743nDd00v21I7Nq396ietb4bW+kxvTCye2F46mF4u3H5ZnOyzPbliezSC2OZuVrJsBuP82Trqki4/QS5vXRCqNmEfHdHUtqpZti55H+UYjbcSVn0Wu7sjybFE16Nbr5VWERa4UBDV4C6zB09ZQXGANRW0NpQXWUIqcUcQaRFlbEqRjSZGjotS8jJTyaUt2FFmuK7kTsqNNSnaF+25km7OU7An3vYiS90JoUC0INJhtJlVkz3q4jOXZ/YHVL0te+SyNQL6F/ShBLJStjRZ2pChgWY8FXj2zuBcy2n+sy0vjLuSzSUSJH+S7ysiRJbtO46X7MC7JPSgl0HW5hyfgnUv/9yWZj36j0FW2JBfT5s9QPi6/zUG7ufetEKnRgc0M0a9RT49Q54J3i/wqppST2FJO/FIeCW0TPRSqjyTAjPtKqIVP/dTU2/EVufNIKmOZnnzqAVkVv80VOkbtJAjGtasd7d5PZLSvdtRE7ROI01oXoasuWlOVPfBBTTBSi5q5Q47hNNNyzOMgw77t51euRx9zF67J3P9gqqFn8TmY6uaqdr5IrVzVyxepj6sa+SI1cVUXX6QOrvPrXFX71nlZrqp3q5r3IjRuVedehK4tR7hePb5V1N7pavVRaB6Mj6NNP9/I5dNVevENk/T9ZedsnuXvMuOahdguGh3yFUMjiP+QyxbfqzhAuwF20I9xbuExzb+yeFQ1zyvKdlrPbwVKraF2p1sRUtvFY1jkeCb4BPYSjWMORySpqyTwbcw0iIKmhV8LNX6WuoWfGbVQjhuPa6Gu7j0ryjJ8qEVgTVvrI6KvPpR6umbxCDF5zeoR65dJ2/mvPX+06uzX1xr7VeUZWsK/YGv3cVRQI5Tk1f4gnRpPlhQ79gn7tRfSwOKjV46k+JUjJYJFpHPatYy02ttzS/YlLEePWYWuqPdqLtunuWyP5rL9mcv2Zi7bl7lsT+ay/JjL8mIuy4e5LA9mGv/lcn2J6TwRV5Hv4bKLStk8kjvQHHis9kOs5Wv0V/09+fYFfvsylJvrHeL8rc8rR25HpfkU59soPeHzlHqF2N4oXwWndr4+2vGthWWskF69bF1MpahhxWkvJjuYA72FSw3x+yp8Pmpduv27i9sPq8rLZXuZlufzWJ7HI+zvCGaRFlq4fcskFstcfsRFnyyvbiei7o7GelpM3bIMitIKlllzVJ/3YjSGxcgudb+++B2szofYBvBQhPdwP5JSy/KKfrhVrtv/HU69KGlsXmPf4icPPFSkknzikYpSgBWfu8OYfW3pdt2nwSy8Y395mKWpMx614HyqaNT493kk74nfr6556ncKptU19XsFb77Oqd91KHuE9LsL03qD/lJO33pi0ehZvucLsBnj2QaLOoPrbTp9i7bzcxx/wZlspygpjtl7xui5b8D/b3CfzqMI7XiMc98LIod4ziAHyEu5DjkKlup6LskBtvkbFncwT2gjt/H72BJoqerLhxY42AYHW9HHOZved/G+G9mfwIPwhp2Zccmub9jZGUFubsWLLRSjN06tPzGpG9x7jSsbtHQqYXi5ru+jDqe+9FNfCqmDSF0VMxr5Tykq7xcPdjbCjELP+QN06HlHplSP3lkgR3lQ3ChqMmZRJUBk6p9jy4n6nh4Lta8iOny3W/DmAxkrWtKpNRUkRzqszHr62qJvkD2Qfh3ir1OSY0g+B9Kvw8hTrmB/sXrSj1y7GI0jzscUySn2jM7t1CvE9yzLUcj0/bb89Ji+FeyRCdCn5aptkuOZYbdVuBX0RK6g7qiyeb95j/jsKNf4+4Q20FEn+sDFtnQT2/JrRJrKSHpKPc3PWyVrOV8h9b8MpblU0lxq0gScwi0Q/js67aGS9lCTNuAybh/z39FpD5W0h1p9Y+0GfmRdQ6fJZtMPFvVZzEmkq2xfE7kekAQdlctF0EbBT95HP1ZYmvKTTGBeB2kSd/7UTxs/+GyQfj/FE154VCXgRz1La4jVuXXGNFzRN7Oq9uk/1AO0hm0Kv8WR0ldseVaaZm3fiY8f1Hp84/A7McBPbPmq8dvz8Us6CfB68LuOT3T7OpId84VFNZNjK/5UmmW277rn2rj5N6xHZ/Mq6TThxUeqLi9OdXlRqsuLUX37Vmvk0vv++oHOu8EjKdaUGAMaU8Hv6qIKRmgLUf8jeBUDO79tbQvxanuavH2sZaqxfo/YryNmIb5h10tmFb5h10s2Nk40aIZPLpBTUA/mY8H+hXcD/tm3qjw8CVV36tIJ0uEVO0NpjO8xOMVRTU9ADuxN7tcU27LM/ezRlm/yiVJRp42Ed9B8RlAHfoK9NED/cARIwBOQ7usQV/w948i1CK4p4FzSD8Xr8hhE/X6hh9j2X6GH7O/Jky/8KMmvLHm3elyuI8x3xHxRvGYxujEcI/KZVYiovYBzZlDzEG2Ch4iaGI+hj1g1K/MUOU8sMyg3m1crbeTrG1+6xGMSYGuOy5ERMtElx6HD+YmXFDwR412/JrJA3TF24o9kuk9tDVdPaN2dyDbQ0fI5zvFRCNA0XEeW0QhTQW1NtFQTy9GVEpRxktB++vQhRiZTzHmP1rS55Z5FUwFa8HVMDx4xWW/W06D81/6IpXz6mV9OEqfw/Hx0XgrWS3Q/1fynSv1R+aPqP1Xqj2p/uP5kORDnsTWfhaPPPApGGMhgJ5VENUdYLz3NEeYRn6q3MngWUEAnG+Veuql6ST0KV+mnroTonroxPXVT9tRLSc+r9lRXQnRPvZieerE9pb94r1WtCrS9BsbenLJVFOqFF88O/OmuQsPOAJAB4Pt8SihA15uGKJ1d1JhLjD5D1LNeWvSNnlTb30YLeN24tsV4RzZw/1VBaPOpRfV4uoZ+gW1M06roNl43TWNoPZ/v9g4uZru2PZk567bteDVvvms7k5lNLi5eHJteHExScmtuhfyiz1x4tl6slivknkuzueSRM5832t2LWaPdu5gd7DTIHXt+CFd73ugdTsllv753OrOsea/XJtfbyh5wh9xvDkiy77a7A1qcX5K3btdsp0LLK6+Xql6p5poV60YX67IGVtbLBISI8u6R8sJOStZYR9fYEi3Vcdcrqct1o8tds9dLTrHsurR4116vVIuVck0u/h2rxCq4I3kF8LztmEYzKBygd6niVsONDkC05+zfd9utixkvbD7f6jQvZlv7B0Dyrf1DvHTJL69Mrof02tiZziaTMv4jOZqEY7aaO1DmVvNbeET4kvwjvx5fzMjf78jf+X63jm3pbsBl3m42SLWd7nTWn3/X2Z2S2ludhnDp/G5vOnP7/bIzHk7mB5QJGS9+v91Eyj/e7uG1s9klHODOO90nUHh9qwGtwDa0d3YuZvU2+dPY6CGiAwtOjmyjFQ1r6C/m23u75Mld8uSYPHGIXtcm99+Adj3vNPehY/WNPSx5gzTYG1fn9eY2NLK+S1o+IRfsR727iYm6LXzWfYyX+g7erH+Ll8YeK2Czhb87PUzUQnDqrQ5e9ujNbns6q5Xn9R592KOl97q0kl1aHr1sb0Ar96BV9ry570xnVXJxoZjmvoeXFrnpkotLLx5c5kbI/LUOGZTGx+gtWUO5PGUr76NVYuZcETNnWZjdY5ht4ZrNazJXwfrhOBabIsVmHIONrcVmOJSwsWOwGVYpNp6bGh2nSOHpU3j6FJ4qhadK4anOu+0fSC2DebfLru19glqpT26wL2YAfswAbKBz9BULAihIKUUwScGIpluKQ7NvgKbCaXFoKpzWX+zoRAiJiA1D2G3X6ZMuvYqQ3maQ1nE8Tq0hA/QBA7SLa2Cg7QWTV9Ko1WLpTIqLHbfeMOO47acdt0kYPUaf7ujqGC14NkiBkL0chO6HuGiHRqxenX+MRuPN5p/7If7JjI6J3L+RnMNFehOxeYbjhqLzEUNHeEJ+9Vj0zYsElNwbKoO8FeHUREk0eGtxcheO04danNjYS4/RtY84JwahEkWoRBEqGSL0IAIhiFW4sC7fyjnfkbXREoWpRGHqU5j6FCa9rmkKUyDc38bhFsdM2YbbHR8lODjwbIVKY6wKPixmnPVtCo1NobEpNDaFxqbQ2BI09xk0G9YU1yTq6CkmIDGAbjOAzBgHSCrgUy5SgPB5IkDVYgxAaNsJEI2uOPe7FCGXIlSkCBUpQkVq8AFZJYsPuoHmCrmRBkNuN/cwHoPGpCUxmqcdg/FAOjUGpTuIM55VKFOZz5nBdGtmYH7IwGxY9DVu4BTn7oZLhSl/R6CEV4fLVnOxRLF0Btw/U5QdNDYFcxiH5aRvMmyRZwUoy2zcQu50A9etGkPpVZkZ7TmjAMu0GL7HMPwewiQl/Cojil9FgU8RenGGDmSV0HOThV5mS8cUujrz4dSvxHN6Qcgxqw4pZuMFKWN2nDLmLhWwtADdEQCC2ORX1qt4ryljK8cz9i44djH9ZFqyKUw4SwNQkziX1mJGZVbsOha8+RKwO45lL6e2WP66jgEpYnTPx+gZWjqwqt333abvy/4ZI65iyKCMT1TRHHfI4IEp0BCe8pjxFWQGgNBxajZvGvJVh7CTOx6TL/WwkI/HjHNUG8XVWfK6j4wbxStpOE6KGWDjUyRjK9Q+Fopam0+NXa53wBxJFRD+pV3nGgj/0mEiIj3EDRYo/zLB+FQhBr7RzKQKxpVh+pFbZC78PsPYGxWXArKsiNS5Qz81klkUZL1Wgisl0WAO3fRg+upxyaVo0gFvhqYzNtZNfHZ0J1rjtYGzxiXODbJchMCC5wketCpFq0bRQr1VGN72VQ3XIsWKQgN9qDINGG0SAAvWsgAtNwatEjNfyfRGTfsaxavMACszxMqMASm7wZfBRFlRAk2v8xgnezMw0xm6sp2L9lbGpRETWRlG04D1PFfHemWGJAMyCkdfWnIcjZnytj+WYXl4aD1PM4qNgDQzzfRI4mAGiThY+GSNEhHHMAeyI84/dEaKRpRLyJZFX7xYoIfMKEOdonq82EU7Q7+BvZiABD2c5dCSe52h2K2Hl9jjweI+9Mcsou6FH1k3tk60C+w4MSA/2pKcpNNJSE5qVWvUhkxtkv5SwTOHinuJd4SAyV2coZ+HwFL9AkOth8qNMUICPTuDMrM0RhOnjUCT4aznVMcZWK/JMIxGM2KCTiMIndLYxHW6Yjjr3HMa9rO8x7Db18TE1DEgt48LzF1cOu0zj3w8bn2tvWcwEYNhFePZG/YpbC7TbIauYu6NmBZITaWEOYRISwpelaFXpfANWajRkAE4rKozMnzp8C/hoJmO/4WrkO0Om3U6HW7adMPWo44Uv9Cr4cyjTfcRJq3UVjJGjBhNPUzLnPQVjw5j4uJAUjGLOi4uF/WEKLFFkhJbJSFX2W9NJ/IOztvdbofN4+w3zOfOhCLtTBKBvivwvBms/Yywop6TBKunKO9cSeKmOcr0kOruGBg6cLfF0G5RtJGZEbsNpCTyNIR9AYbFsjGG93yn0ApkhTcykhWKxeiLiliPY4QJVGQmUJEi6Q0pknj18IpI0iGvFQsohYFjEd0ORdtUFtz14T1DFR+ixU5NJjDuzuVrf05/fNW1P8amJYVN5RkM9NEuxlxHg8sHvym4HDhn4qvsCKCiun/A8Pve6rOzVYY8wDOD+j5hOE5kHCf9BY32q6qg+pHu6swhqkSJk5dvBale8mQMb/tavUmkh7J+6ivyZmv14OpJaQf5gx1lxZXcQ9rwY9+jGdjoqGXxL519gV9tyq9KFK05xmbGu1vVuuBQdV0gwtx297j/rWQOsF5p9XTMiqHHUcHJOt9Hh4nFV9ZLZU21BaqTDrpBUZqI+BhPMxPFxsUjm+v8cXpZySZ0T4fcsKpXlGpM468xF1KtTKdynNK5e6MeqEfc3aGYAtEgvm+JITnxc46nY0BlXV9rrHu2ubqJoIZBHBSTHZr+hKM4NIEuiCL94tEvVOEk9iZVOOELKvNlm2qcOH93+Hin6lI6TA/RGI2ff+RBbbQQZMSbMqgDbYSTosFr55+oSTzKSSyvUjBWxGncmCW5rklfPDXBg6XOrKkORqfEhnhZHuL9FLN4WSsbbZ1spA7hLHFQXDLKO19cJhrx6uGVslyZTSnqvB0NWqBB/omIwz7d0RrLeaWsi9opJhNqMwpGTopVW8Kd2tEM91vsfove90UiTtQVNk9X6IDmohHH82NqWuriyZ7gWXN9Zon3Qy6TFp5xOk3tMtE77oxi9LjfztHaQaOi5DPpa1VMZ2yuqKuTj1vV25MoKzu+4yMsGk0hheVyflzxkiENLWN4WkxrVdkPNdEKTr2JriwIDfWCUzejqxveAg8U41/RA0LRJx2slKhgLacD/10Gvmc1Myz5VtLwbZyE8GR1U+Hais63ZGa7a7n2MdXk0+B035+Gnln0XQVwsowaK6SiVs7qOnLMncq+EeSV0y9UciMoaQ/mY66TPw7r5EnQ8cloH48/fWGwgcnR6pbppGTJ3JepcFstWQ/i67vKBL4gXrsbjEkiCrfoG4KXDph2WpEBG2qVcT6pyBaNs9Lh+UsG2Xfo0x1ar9hJD3QjOX1Vgj+/pJ9NaLyQKZLayUQWdAqSaF6Hp5JUks5jbiCPbcMgV5xK2Kq4OFu3ma0oOTBQYxJ87FXZxR4Rdx9FkA98b8YrtCWf4VuiThP3rDuL2/8Sh39VG78LThUBfjeNHzOKk6nl0w1r70kIfigg+AY9QgX0HqXGECMEU+xg8HEsJttAmY+TACPHYOJBp9uwogmMwbVOvMG/cG5tMzMTukjX4AS7E/3v89ZO82LWEvffTpAWXfTJTYUtShOkwR4eGPASqfMk8gmjSYsC0qKs2KIM1dpE0FodPDKl1enQZ4/p5QAu85Zo2tEGse2+YMIpTRKfPIl8kq1JLm0SuWz5LfrYGmKL6AEUIyZVz4TzFE79oT9kK2wv8LCn54Rt+XEVra3vCPB7DVr4Nvm+1YYTWFr0iBUb/82FRw5/xM5fgWeH8My+ejlOxiL4I/jXEqMTJiwua4ru3XPsv0o3fhJRmJXEJ9no5lG6eTnd0tDtQ0Y3OLR8aNGXLT1VqPehTyNdmicGabJRtE8p2s8pmoaid/2RCD5DmDpF5Xoi+BP5sycxz7JRrkgpV8wpl2UsNqSjFRleyljUp3likOZK0tVxcpKmIWmgW/XpWej+eueE+aj5/ScR97ORq0TJVcqplYVabYu+Ae2ZQq3g/pOI+9moVaHUquTUykKtFiIy8vHgVAnuP4m4n41aVUqtak6tNNT6gFFrk+1FpW8IE5WTDxh9dCmeJKbIRssapWUtp2UaWr7PaFnH1dVTf61/4m9kOvFHnXo3G52GlE7DnE5p6HTHN+5grNBTwVSDPHiiGuTBk2w0G1GajXKaZZnVvsdYw3FoVgvuP4m4n41aY0qtcU6tLMZ2O1iu93X8u752KD57EvMsG+UmlHITqWH3fTYaWwOradHXHY99n859n23U508SnmdrpMM8vXBtOgKiraYr/fKkX0XpV48etb2FDuwsbPqxwKbwWoJDXMrGJUZ+T2BXT+SR9YAVBrbb78+lhyWf1UYT8lh+WFNzqvy8zIoWwPCZoP6IQb2J8QK4toPxQlsYj0VyCUCXdW1zbW8ot81ed6v8qTOoVZyB/LTog+OMixPyS3pa5g/L/fHQduSHlVJ0wY7aIpV8b1/zr5sp+PjrWPRl1P4ojBp9fgNqtj1wo4bEJG4G0JJuWZVcF8B3GMD0fSSvUWAHkBZ1ralVimVHkTKe36XBqDpUOLHqPy0P3bFT1nZkPBkNhqMw4NfThOsix11GDuEwHPIsQfDRt0FESY6qXbVBl9FLjnKZajpayQEZK5MoyUErjmDsCvnPUPDd6OZfNyNQgRdWNbTtiRE1XESpFLlCOdcFzT0GTRfF1ZC9Mupl8ihRW0TYTHwY4rKgwW4/kskgn1psdS7wWKTsZyiYDZGb2vbrnre6eKzmhTJvaUGseTXCvVFypujCJ0rODEoDb+BEwMjfxaOXM6MxfLQggGyrmvLAjW7+dbHBA8YGEMn4CoOMz6x9tg34abLAdGt2v1SLmgO0CuAVyrlukOhc4ttTSQZsnPApzSNFiNRsnTNmWZVcF7zcleU7sAKnVvKEraov4VaZTdgm5VwXQB8KNsYA7fozPKlD5T6t2LNtr6pOYIHYI9NbrV+JEntEVSnHTH7hrJWYrI7aIiOpfaObf90j5i/C+bvZal7MNlvCuuYYYdrGSGbwdMHbgy/w3FMKz88RONBtXvrx4DQ96jns8P9NeFdks7EJf75FtbiOW0bOMIiniyF1AGiz8d0pvNWQNEdKvWlNcIMoKNC7eKDRttVkqf/OmlkVfFq2HPKxLddaI9+H5A58g3sjfCNdldyrkCc2e2cppKyQvw55Ar/mUq13heO7NnCKfuG38K9IHs8qKem7JC04W/eJ5PgjbS1L/y5pX5++gVvJ4+NJ2Ar2HBL8WJ6fQV+k1HdIDS/Q9zG2etYlXH3EXCUl21sSKjWM7WPUSulk4LM/S/2+9f8h8uyj5OzijqkR1qPLaQcfpXVBr9V+yCl/TbjqOUGzhW0c48R1wtq6T2jyAt9VDScrvSSlvMLBfELuifzyhKTfozu7WC33BH4uCBwt1vxBQHP/DVbsxZ1+Wz0lR9ArHpx2Ql0jPkUrCs/cx4PMTkkfo+qwlToCnmyyQ476GJ0jcqaK9wOBb3YxbPWMvUdpirYIr8tRcokobpO66BacKXuzEM11i5m0Y6Wdm4QvniKfPmNv3X1GI1Mievaxz7FUGpxE9lDN+SGeafAj0xFBGo1C3HhH5kYydidKX+kWNknCaXl6RBDR8fQHOI7OEtogjCVNGzbZCe/wctgWTjbhEan2BNsBgjuFzH6fyewW3YibS+elS2c1ZS6dc+mcS+dcOsdJ5w7G3T7NpfPSpXMpl865dM6lcy6dDaTzHV86n2NLgJq5hF62hC7nEjqX0LmEziV0CgkteKRzCb10Ce3kEjqX0LmEziW0gYS+yyT0D8hLP5CanlpuLqOXLqOLuYzOZXQuo3MZnUKLFmR0LqGXLqG9XELnEjqX0LmE9iW0pkd55N2Nktk/lcg7ZyUyO+DnXGbnMvsvTWbnkXd55F0unXPpnEvnmyyd88i7VUnnn0rkXS6dc+mcS+flSuc88i6PvMsldC6hcwl90yV0HnmXR97lEjqX0LmEvmkSOo+8yyPvchmdy+hcRt9cGZ1H3uWRd7mEziV0LqGvV0I3SV+A5sIoVdYJGc9ppHOSvO0TTq5ZRfIZkRZXFyJv4+WJ2u+y4tldlqTgKBYkHBc1Tj6U+qznd5gHXM1Mw3PFR4zIaek5oMGIr8ZQIDzneaQlpdTc9oBxW3AA5ZGU6m3kvr5CkZ8u971jVZbEe8Ur896HjPdEualqo7cZ90FcMdG+8pi1TLpoOEr4px+x5q1ghN8P+JKMcYGPb6Qu6ip15LporouKPXEA+cwSukNqmaJUyiV0LqFNJPQqdLAPAr60RrmMzmX0Wy6jw/6CB9LYLCB69F2QLyQrroslT/GZmGMdPhmsuAGx4WzytIbSdIxSuIh4cSkMll2ffCZE8nK7C1JXye8JGRsjkn6+AhmQ1HexBX9D+londUywBZRDjkhdJ8glMH5+JL/P/PbB+PizX9O72PcC/JVKvW2NDH0D71p9Zfb5GUGppKQZJvBaVi65L+1pvpqVX2Jz7wRnXZibK+RTJOk5f3jk2wA5ZORzdxXn9QlyEszVV7PySyvgrmjMcjs/De/dlXDkz9LznYs8VSW8RsYW8hjIG5BA2fkuTscqroDH9Nik1UbKqbWR4sJ4OPt8bz5XR8+R9wmnjoiWfo71FYTclPfeE/etZ+C5EeGvEuEd4LgaWh8g80YEcdUiqfqyCWQiSMMR+R80lNpK5kK5p0ua+VJhf488P0fbsEC0XU7f00xUsAmiY5IGkKZUcAiCRQ0V3GulQlSfl6+J3CXyGlrykvw9wnF7HhPLKaY9Ib8GhinHgt7vKPOHmPKpxd9Xrk/9MenVK5iNUDc+whdfPcVzJtScf4UjUJZvH0XmlvttkpfKLl2LVbtghDL0TKpPxE5X24cRtclIRtfE06v0VC2ncI6k/jzQ9scE/QeR6Iu90uW8r2mnzH1mmMfXorbPFMMoSkW3Lw6JJL7Q9SyZe/UIKryUSkrfEeVUZptRltCuL6FLN05C6/qbS+dcOufSOZfON1E6N7AHF1huVunsETkL8nWA9vAYZVSN2dCB5QzPof02ev1sZvGAtVNC62Y10jnc3+VL5/vByMLSXllTtLNP51ttQqqtdu9idrDTgNeeHtLLPLjnlkr0LnxR156Q+gst8x7nw4W3lIyJq5eZirvvCq/FLTBOepFJ+xihld5nugR4p12MRZI9Q8DzfWndEL33GK00DnmGghUA2HU4ipRNy/IM6bBZlNfm3chVQt2ayPukH69xHQN6delLQCeDR+aXBNcTf+2L+aWsz1Xf1oJk3dCXdc6Nk3XpkFi+FHyAqw9izUfYXphDj31vY3i9b6DpRWTOVLzysfUYJd3nVhcjC86xZdAvaOdiOGTkc4h74zjEpP+rsF2esfnGhBtONS01yfkRruMZcpE0dz9DS+4oWDtTeiXEbEjc9y6hDJxtOhbmoxbOfTSegK57Z/FXTjBCxSYcA7MLSJ4Jro8GK2Q2WsMw61yvNazv8ZJ4KgH9j5jk46fMFpgfdYOU/BrWmTKtGQENXBy1fRzhQ3It4gq26Jco4SqRWUTRciiR3PtVUOWWv0pIaRL8zjIKHPJsgtZX0ffac/vjJvmEgl5eB8YfInpcVhb408zzW4ngVkXuLROkyih9JmzNqogUmKCG7GCURwmjPSDqDuyfKqboh7Th5eAe33Ox/n+C80AwnwxYyqOY+At7BXPjx5HtCkd71EL6j8oJ960fLDjf5OUCuKDGdmEA3cu+RuPi6IMdGgPkAuCTMlpOA+SACdpSLupAIANXwQXRvV4+/T4iaWjdMu1UreNnBA9V09Hl/BO59q0Xkp30M5BuiTKgg9brFHNfnfojlL0eRm0Ucd5zsfwqUh+soRLKAJCwE5QCI5wpiyiNJyh9hyuSAXE9Xz4H/BzbyetPywW/iMydlRPu+AgUkLIn2rjrdHOve4PnXl1/r2MW/sjaIu06R7tjitJ7EaNQXBWz/VUx78ZRIbn38mz8VEktcj4fEed+vNHPSY/W0R6K/pRXQvX3WcTaCcZQH/v7buW76Sk9RPqBjQdRatTio7sUwhZf5Voprfb1+lB/QFp3jPHk9EnBj1rLOt5kqVe8wVIvqe9iC36Jc1CQ9ghXcU9xv+6ZYVT+cubOX8S0bBFSIK583excCs2ues67L9+90kwLsaUu/l9iEYI11LsrIZ7jUanXxXPRvV6Nv2cPV5bAD8epsIHWRiF4knnkjxFPG+N8B+hnGyLSHuq7Qzbnwt8S7vnikcNg44zRUgI9eDVUiOr1KqydPtZ9RFrP644ZSdJI1OU8Z1d110K0z/V9i+47lCPE+bkXjzHXq3yfoXVz3l6i7hK4WTsNVxGjfysiLj9pXyFYeyUlj0ksv7q+kRTLr9bx09lZqPrazHcayOen5DsLTaQwPx9uD0cGaFq6WIxcEl+XJC7lknjFkjjdrqrwns9cFue7vJNk8XskzwvUv0eEk/iuNfFeFj/IBFfyqL05ZCs+NWG/FN3BbRMper07uOWeLt8CukfawesL2y3AMdwT4YVO7oSRfxmTC/pJrgb0/RjHCsXlBPkPeKdwRaqPcHWvgjNlDalexhWdmkT1Aa721iSqw/8TTLuadV+T/v8UeeHnGGVzyfpKd0tfku9FRg3YM7jpa2O7iCVK7yusQFRxhhnjyKZ+6SrGBYh+6TLGv3i49g9/6W+4jvDeataBwv1dhV8qDU0eKPEKPewb1Hh99Cmt7KyN+L7fNFqJGh6sZdF5+rroVFuZbI3r9ypo9AuMWJta1MPcJT2csm+gwYK1KFLpdhB1uGTaVAhFKhgNUcGoCPhbxrmyhNrRKmgT7u0qKHIPsR9j9D7YsnwvAY/Hb6Ouf4ac8syip5qC3XKB40zsURatBFbfxmhtTtBWh/WRMebg1OmjLlrBcWKzcxRcprnWyBOIX1pNPH4aJBZle91CXWgo2J0OtRHm7Y3exaze2JnOJpMy/pu36K/JxCb/5r2D+sWMUvFdYo9ReXw83+1+ezH7vn0wnVXt+WN27XV/mM4cyLRNGKO33ZzOKpNRcYJV9Q5aiylovnnQvpi1dnskybyx04FLewd/tTdIcvJjbzqzyaVDC2n32O/9AUmz0d6hl+6A3NzYaOCvjSZeuqSYMUnZhAxbUKg9/6b9u+msNCTXLv25Ty9tyL/V2obLN11I0yfXTfqzB8V9063Dr9ZOG3K09qBxW90duLfTfQKXJr3sdJtwaXR3Idtmowud2Tvswq+dLv563NuFQh736Ghr4ogFzvoRrxjROz9oYdqDXWx/r4PFkZxwOWhuYOGtA1KANd/bLV7MyJ/prDzHy4ReHHqxlQu5tiB9i3RzjhciATb3GnDtbexgde3v4XIADSWEqT/Behr1Dtxt1DfwbnMDfzV3L2Y7rd5kZq+X5r39Nv3S2WZ36vvsy7xxgBDOd/dI9bt7TSxz3t7aQ6unbfVR0hWIPNreRYK0t3foBZL+La57gr0Cq3MDlAIVHP0jtFfHqEev4R7yCX5ziRyo4irUAGOaIDWZVwkVSIvnO4eEhDsbh2TIfLsF1TzpUGqyFaYdUsOlRc/ZIZTbQVx2KcV3G8h3zW2kamMHROcmFNf4Fh5v7pAKtjpt/8ZWB7kP77d7j/37iSO23val8h1cpzwiOFH7Z+pL5L8mT8APCzNZm9x/w+byDfRSTcldOsP2cfVtNO8096Hy+gYOpfoG4TNvXJ3Xm9tA1vruLjBQfZfc7s/r3U1M1EUuqXcf46WOYNTr3+KlsccK2Gzh7w6O33qrTi/IM/U9erNLhk+tPK/36ni3R0vvdWklu7Q8etlGHt+DVpHBte8QaUIuLhTT3Pfw0iI3XXJx6cWDy02UcvVOG0VaD9mgtd8D/Dt7JJHjlBy3NCDj5mAyW6uS6yG5uvN2owW9b3fhdmW95Ba9CvmFD9cdu1QtefP2pvRwU37Ykh625Id10sh2nTDodhdlZr27A/s02+0GEL1d57s1HX8LJ7bWLQ+IFOk2J7PKultxK0VCyR9IUfUfUHjUN34gA2su5vfW7ZrtVGgp5fVS1SvVXFZYZeDQwsrrtZptO6WEwlzWmMp62at5vJTqwOVNckq1iltMahLbf+q46xWxnNrA4+V4nlOxE8sprztV2yuy3awcof6gyIuxy06lVEsqhnXKYeB4rJzBoJSqHG+96tSI/JBbMxyUU3UqApvRoJIKYy2hxoOqRO4k3iHJ7FrVc7S8MxnUJEbU8w4prgGcDlKUcTqy+IBcwize7nTJz/l3mzAW1smwnDefoPAKeH9/DwsRs+s5PKEsYP1wWSqDJxQCnK9pUIiGCcUA42uKUdk7oRTge00pIe5OKAbYPlyMytwJhQDXhwtJiwswfbiUdCQCng+XEcHZCWUBy0cjnIp9iUHR2yAjZHMfZ5mNLdQqt3e3fM3kYL+FfaUXrGmNtZdccfYjA/gxu+LsV5Unv75L9GxWD69QMGPexcAgPP4iYsHyNhpWr/zlrNP5VrMnlQGHENBApJG/BdRlpd2zOqFnhdDrV8L5ndj8skP4PenwA75A0RbuianfF0Mc/Xpu+9sZzjUtlPPYEXkc5XCGO2xjNl9cO9Ngd5uYG9DKvRAVPIUKsLD/JpTOD55U3NywUAzOA3UhlrblROkduBdgKfAlef401Mb3WBvpU1rSZ/4CYsE/Oi+otcAMcVgEhZC5Z8ycKqAj6QWaV3TruEf+fx1BqfdYn8V6HyXUO7RoEHxQIy1jSq7nuFWphA5HqU4D/lBHhZ4jwAmg8mbA21FliWmUkubb3S4xzLd3kHis68QI/u5i9k23ezr7/mPrc+tT66sb+vmUtO4DMr6hjQXDTwMdOJdWcDhBwXpI6PoIRiULJKFh10PE7SUYU2hW/Ybc30ajbN24tkKmNqofMOzA1AvafIq/xmjq0WNxRqlaFd3G66apCa2vuy0mbcxKi+ATSCI+Q169zLeP1nCF/3t4KIAelT6ODwgfOcX7NOU5Gx2nFt80P2QuuDM2h9CS1sj1UphXqKwHV7xa9whd1H0WfBOUQOcDse4Jtoy2aYphSF+Qenh5ayTFPuobBSs4XIX2JZg5CmyJhJc5RJfQGfahgKFG4rOpdYIL12PWbqD1Q9KmlywMp+v3bB0dR+AEX1dqF3Qa6/dEEv6BSEVeVg+PPDtNaDGdH4/RXV7AbU0FDCMPJFQDnVRDtgD0lPUhuWQu7aBtvE285FMJiagyThldToTUUys4ZnuIz459nnmI9Y1ZPygtH/m8pKMKb5dMG84lv/HvQdoBLlEGHMnR+DVJD21+jv36tcCFa0iFHxknx/WSLqfx+s/YkoW+VYviFodwS8H6FZacvZRiiOco1ZN6rD7lvXxlBS+OFekb9LqL3Adhe2uEQ0/QPf00JW/K8ucSa+V8wnnUhEN5mziXhu2WLNxgyvOL4gR3IZxQkjjhbaaSiaSXZcoLnGfOlj5mvUwSXnwmSt5jtIAGjLNoy2WZStvNZ/e3SQtZhObVk/0cCynzbdLm4P8JjpShFQQMAV/BEr2KzkMMC4HxTedNyqcz/AseiB8x15DwXkFI+4g95+nukLo/t+AVGsCBLzEVfzJkS2UF6xPU7NatFxhW8cr6I7nzhTadWI6Y5o4FB/KJcvcr8ryNvX2OM9An1pdKao1XCnN12N1zJt0co7yuNq+rzSt4Flguyc+UkMfR5FHrGTC95jm7K1Oj5Yd3PtOiPEEZl0yNCYbCNIh9nC51VAqxXSbUDX6bU3eDPDlB3gf00lFXzWtO3Us22sxpy3Oko+w2zlB0GVo/0qZYZzK15JJMxxpID3NadNFrB79fpaSEnNOcDlRria5NR4kgTzpadPFw1mOc0/XjjFq5ybSAdEfWrnWQMnVUCrll5rR9lWqkddDmpKNlbP05tSRVc6eTpeloPMpE4W9Q3+uzlo+1WP+RfDehmlpWIlX+7c9e/1dzauxV7X+djgIshxHq3W+O/o0p3ixtOqQbqBtzbEDj6KLPn26/mmAY5sjXPlRuD6f8O/Q1y6UmIv7v/rc53t//4l/9+3R4sxw3Fe+eXzLXHWF20COuT/v2Y/4PKTD/h9SYf4u22jhy5hafJ+L2n9b+1//4x4/Msfsv4//4/6zCP/7T//w/0yEo5TPC8b/9s//w301xZGnT4VjHcv5sTX3tpYC6Itjo52QuP4+R1q8NtaNwHZS7dfWYabLp51eqjQazJK4Es3Ky6LVRJZnPu2ln3SxzbhM9ilGWyzFufEmmX1CKufYzxnFnrv1wOyGLFSnnNaNA16KbpemBjWZUkPOk1W9/tOjabJR+e2pdGFFDLimdXX+SwbIHf9lZRsue502njY5Ta6PjlPRowKaTyHExNLQ0glKSqQCbmGCjlzn+P5CaXrGthMfW/01JgXBuMxq0LboZ9OU7f4OeUTM6qLnS0ILmjR4Xrw2llFhOmlGRnibPrZN33mWHNRzH8mscbXSlmNKIxnqQPO80U9BIzpVOfnWkozJ1+MO2IBM6ySUlUurWP7/VuPXVrS9u1W99a06pW3976+tb//LWb2/Z6Wgj5TOixq3CLftW8VaVtHLDlBZKnnSU6FlwROnzmBFzZuiRlEtKHjN7yLXU09VPNZcckrsXmOcF9uvFOw75m27URJVhNmYOISfJ8X/Qc2A6ZtRc6Si1adEjXeJ8WsdGlJJLElPJUR5xFOSrMF/50jKdP5jn1MagGtIxroxkOga5060A6PMl0fKONWfXE9RiYKzQCBf6fO5TPHqdaAOlO9g4u6TOp1b8ShGlz81cLRKiT308Fx59qqGkEG1rWG/GaNtUI/vtXBPKaSjScHWrPznusiX8tq705HQU6bja9Zwc+/gVh1Ws8OQ0iKfBqlZ9cjosYiWI20M5om/PmpAaUZjTbpUrPjnq17m6k6O/6rWcXNZc37pNjv31r8fk6F/nGkyO/s1dV/lLp4f52sjbsNfnanummpa8z1pdDbra3qm3ac/UBePDXcKJB/gSln2CzibhUMqrwOFfKim3SapwSk8Y9+J6WNQOQvqiiROr76Mu78CSLc8x243ZtOjezG2kEl2nE2WAeL+rqXeD/HposQNRSY3BiNHLL1XyjBJbEJ3qYcr6TPqSvu/+i2VStiZMg+AFJvLOT7FN5rnSopOmFYuuW6axSQvMcqRtB91DAmX+qKW42IKktPF1x62cm/HdSBoR8ljnsuUMvdw84uGhf9Ay2INPcdbasejK+rlFj3mFQ4xPLHoAMnihLrEfj0j6U+Yvh7o/IdLuE6F/vD6+Tk/ro7X/nl3XWZTXUwv2H6/h+QNq/jNf5kN+s52m4CP+0SqIL31ibaal8xJ5HdLZVkpNSbEKSXXR3iTv8D5HjQMi0Zoor/sEpU8s5Vw1cucPPpJyX7LWIPc9KF++L9clU+g5yxGFBKfoc19D9E8oYznDM+OXkq1L9VuaV79HXdTRPld2rIu1Q5pw7eps+6WgVdM82Wq9Gu1DJ8MJ1JHlFafEkI3tryL5YYg6KY2GoIe60xN22qgfq2OvI4w8fJlVKMWekKIUejoUns4I7b5gLVwn3z8jpcP4uRTuXuLdeaicE6GcDkHajei9jSUOSVvp1WVXj12L7FqS8lM605egFqyyFX8WhylNo05skGUe7VNZmX1sQy04ms7mpwN9KdS6juPLpNYhppXzXqbIC2nXkJpyGVze9VDeRZcRjoKTy4F1w5c4g8e35RPfouO5nRVh70jYO1fou6OUk73v7or67kp9dzO1medMh1o4fjOuNLoaDedcnfp6JS+NWjcyft6K8PMk/LzM+HlXxs+NLS0dflQOx51bw0/rOWa+Id35NJ+jz5bO77xlxRXRpSjRpZhanoZlYjGFXH3IJCvMoY9YWQ8JhT4lvz8l1Plcq4E9Umoz56SSxEvFlLwkx2B/hiV+YRUSS007Jksron1Jon3pCnNpKfVcKufNJgsg54UlvNomJmfg39DpUfSErqEVnNH42qKv0AyfYxb4ZM30Kv5tLOkwsv3Rxpqf+X3LVmZA7VeoM+vrakhpllMjUJSPVp32aGulqHhKZt+KO/eS+hGfIXX4C5HCGq9YIvetP2Q6PP17IvzdW5D9GzqlWrCBPvH78Ikx8lH1yLokrYNze2ehpTtK6eZcE126fzK0UPbi2u6fTR0q/eptDzhbLJuWvueXTu/R71Oc8/W+LnEXSJT9y21q9o4YrRd5A2UW9WBEzy2i5XmktJ1buyDZ19CO/g2zdEFer0lWLi/nDsrJE+Rz7pvQ92IL/XTyCgvY8hdoyUP6l+inehSqA/xa1Gsl94TL5Yfk+VcoUSDlbwkNPkUdD359Rj5B1GaA9B30j5jMn9nl3u9J/X8QeiNjtY6pXiBXHWA5BxbXiY4ZDYBG8O0RkY9cK3pkVOIhlngolXjpl3gZUyKkBJ/wU4u+Phu4S+SzOu5/fuPT7qHUBrGsuRG1FuWVWBS94/SlnJ53E2RV3LhxErWerKVeRe9ZdJ2mmg/UTP13HAVxvWexbfqNxTV2/u1SoqwZHzuCF9OcV9Vcy0Ob31kEt88TV7fi13N1q1hDf9/rYuecsAfbyVxPHNZ6TztdjaAcvE6uA5zFgzuBLvaQxcKeodXvaGn3xveG655esqd2bF7900tc3wqv9Z3cmF44sb1wNL1YvP2wPNtheXbD8mwGsc3ZrGTdDMD9t3HSJV18hF7avCZSacQ8Oqara1G1bFv0PMo3GmkjrvwscnVHlmeLqkG3Xi+vIixypSCowVtgDZ62huICayhqaygtsIZS5Iwi1iDK2pIgHUuKHBWl5mWklE9bsqPIcl3JnZAdbVKyK9x3I9ucpWRPuO9FlLwXQoNqQaDBbDOpInvWw2Usz+4PrH5Z8spnaQTyLexHCWKhbG20sCNFAct6LPDqmcW9kNH+Y11eGnchn00iSvwg31VGjizZdRov3YdxSe5BKYGuyz08Ae9c+r8vyXz0G4WusiW5mDZ/hvJx+W0O2s29b4VIjQ5sZoh+jXp6hDoXvFvkVzGlnMSWcuKX8khom+ihUH0kAWbcV0ItfOqnpt6Or8idR1IZy/TkUw/IqvhtrtAxaidBMK5d7Wj3fiKjfbWjJmqfQJzWughdddGaquyBD2qCkVrUzB1yDKeZlmMeBxn2bT+/cj36mLtwTeb+B1MNPYvPwVQ3V7XzRWrlql6+SH1c1cgXqYmruvgidXCdX+eq2rfOy3JVvVvVvBehcas69yJ0bTnC9erxraL2Tlerj0LzYHwcbfr5Ri6frtKLb5ik7y87Z/Msf5cZ1yzEdtHokK8YGkH8h1y2+F7FAdoNsIN+jHMLj2n+lcWjqnleUbbTen4rUGoNtTvdipDaLh7DIsczwSewl2gcczgiSV0lgW9jpkEUNC38Wqjxs9Qt/MyohXLceFwLdXXvWVGW4UMtAmvaWh8RffWh1NM1i0eIyWtWj1i/TNrOf+35o1Vnv77W2K8qz9AS/gVbu4+jghqhJK/2B+nUeLKk2LFP2K+9kAYWH71yJMWvHCkRLCKd065lpNXenluyL2E5eswqdEW9V3PZPs1lezSX7c9ctjdz2b7MZXsyl+XHXJYXc1k+zGV5MNP4L5frS0znibiKfA+XXVTK5pHcgebAY7UfYi1fo7/q78m3L/Dbl6HcXO8Q5299XjlyOyrNpzjfRukJn6fUK8T2RvkqOLXz9dGOby0sY4X06mXrYipFDStOezHZwRzoLVxqiN9X4fNR69Lt313cflhVXi7by7Q8n8fyPB5hf0cwi7TQwu1bJrFY5vIjLvpkeXU7EXV3NNbTYuqWZVCUVrDMmqP6vBejMSxGdqn79cXvYHU+xDaAhyK8h/uRlFqWV/TDrXLd/u9w6kVJY/Ma+xY/eeChIpXkE49UlAKs+NwdxuxrS7frPg1m4R37y8MsTZ3xqAXnU0Wjxr/PI3lP/H51zVO/UzCtrqnfK3jzdU79rkPZI6TfXZjWG/SXcvrWE4tGz/I9X4DNGM82WNQZXG/T6Vu0nZ/j+AvOZDtFSXHM3jNGz30D/n+D+3QeRWjHY5z7XhA5xHMGOUBeynXIUbBU13NJDrDN37C4g3lCG7mN38eWQEtVXz60wME2ONiKPs7Z9L6L993I/gQehDfszIxLdn3Dzs4IcnMrXmyhGL1xav2JSd3g3mtc2aClUwnDy3V9H3U49aWf+lJIHUTqqpjRyH9KUXm/eLCzEWYUes4foEPPOzKlevTOAjnKg+JGUZMxiyoBIlP/HFtO1Pf0WKh9FdHhu92CNx/IWNGSTq2pIDnSYWXW09cWfYPsgfTrEH+dkhxD8jmQfh1GnnIF+4vVk37k2sVoHHE+pkhOsWd0bqdeIb5nWY5Cpu+35afH9K1gj0yAPi1XbZMczwy7rcKtoCdyBXVHlc37zXvEZ0e5xt8ntIGOOtEHLralm9iWXyPSVEbSU+ppft4qWcv5Cqn/ZSjNpZLmUpMm4BRugfDf0WkPlbSHmrQBl3H7mP+OTnuopD3U6htrN/Aj6xo6TTabfrCoz2JOIl1l+5rI9YAk6KhcLoI2Cn7yPvqxwtKUn2QC8zpIk7jzp37a+MFng/T7KZ7wwqMqAT/qWVpDrM6tM6bhir6ZVbVP/6EeoDVsU/gtjpS+Ysuz0jRr+058/KDW4xuH34kBfmLLV43fno9f0kmA14PfdXyi29eR7JgvLKqZHFvxp9Iss33XPdfGzb9hPTqbV0mnCS8+UnV5carLi1JdXozq27daI5fe99cPdN4NHkmxpsQY0JgKflcXVTBCW4j6H8GrGNj5bWtbiFfb0+TtYy1TjfV7xH4dMQvxDbteMqvwDbtesrFxokEzfHKBnIJ6MB8L9i+8G/DPvlXl4UmoulOXTpAOr9gZSmN8j8Epjmp6AnJgb3K/ptiWZe5nj7Z8k0+UijptJLyD5jOCOvAT7KUB+ocjQAKegHRfh7ji7xlHrkVwTQHnkn4oXpfHIOr3Cz3Etv8KPWR/T5584UdJfmXJu9Xjch1hviPmi+I1i9GN4RiRz6xCRO0FnDODmodoEzxE1MR4DH3EqlmZp8h5YplBudm8WmkjX9/40iUekwBbc1yOjJCJLjkOHc5PvKTgiRjv+jWRBeqOsRN/JNN9amu4ekLr7kS2gY6Wz3GOj0KApuE6soxGmApqa6KlmliOrpSgjJOE9tOnDzEymWLOe7SmzS33LJoK0IKvY3rwiMl6s54G5b/2Ryzl08/8cpI4hefno/NSsF6i+6nmP1Xqj8ofVf+pUn9U+8P1J8uBOI+t+SwcfeZRMMJABjupJKo5wnrpaY4wj/hUvZXBs4ACOtko99JN1UvqUbhKP3UlRPfUjempm7KnXkp6XrWnuhKie+rF9NSL7Sn9xXutalWg7TUw9uaUraJQL7x4duBPdxUadgaADADf51NCAbreNETp7KLGXGL0GaKe9dKib/Sk2v42WsDrxrUtxjuygfuvCkKbTy2qx9M19AtsY5pWRbfxumkaQ+v5fLd3cDHbte3JzFm3bcerefNd25nMbHJx8eLY9OJgkpJbcyvkF33mwrP1YrVcIfdcms0lj5z5vNHuXswa7d7F7GCnQe7Y80O42vNG73BKLvv1vdOZZc17vTa53lb2gDvkfnNAkn233R3Q4vySvHW7ZjsVWl55vVT1SjXXrFg3uliXNbCyXiYgRJR3j5QXdlKyxjq6xpZoqY67Xkldrhtd7pq9XnKKZdelxbv2eqVarJRrcvHvWCVWwR3JK4Dnbcc0mkHhAL1LFbcabnQAoj0n/7Z3ty5mO41v4efBfgvIfEgvtLUOLZBcv28fTGdOef6YXXvdH6azqj3vbe9czHrbzemsMum7peF83uxtXMzm+O+77dbFjLdzvrNxeDGrf7sFlT3p7MDNnb1d7OT3BLsB6Ry8yugSBvJ8Z2cHWr7bxXS7jR3I1aRFNXZInY3NHb/pmzu7WKVc33yrSVh5q/mYPNtqfgcp9rt1xKO7AZf5/w81HIxCibK6QQAAAL5ta0JTeJxdTssOgjAQ7M3f8BMAg+ARysOGrRqoEbyBsQlXTZqYzf67LSAH5zKTmZ3NyCo1WNR8RJ9a4Bo96ma6iUxjEO7pKJRGPwqozhuNjpvraA/S0rb0AoIODELSGUyrcrDxtQZHcJJvZBsGrGcf9mQvtmU+yWYKOdgSz12TV87IQRoUslyN9lxMm2b6W3hp7WzPo6MT/YNUcx8x9kgJ+1GJbMRIH4LYp0WH0dD/dB/s9qsO45AoU4lBWvAFp6ZfWSDtBFgAAAq1bWtCVPrOyv4Af1e6AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4nO2djZHbOAxGU0gaSSEpJI2kkBSSRlJIbpCbd/PuC0jJWa8d23gzntXqh6QIEqIAkPr5cxiGYRiGYRiGYRiGYXhJvn///tvvx48f/x27J1WOe5fh2fnw4cNvv69fv/6q99q+Z/1XOaoMw/uBvM/i9vCW/rm7to7Vbyd/rkdXDXs+fvzY1tVK/u7/bH/69OnX32/fvv388uXLf/qi9he1r/IpKi/O5RjnkU79XK7az7Hab/mTdp1baVpf1bFhz0rOnf4vOvl//vz51zb1T/8tuZQMkDkyYj/nVP7IFJnX/mwX9GvOJT+3E9oC5Rv27ORfMvL4r+jkzzHkQn+1DJFztRX3WeTHNeA+vjqGPgDKYz0x7NnJ/6z+T/l37wzoeeRef6stINfatiz9zFjJ33oA6PuVnnXD0HNN+SPXklVd6z5IX/eYwHn4WZLHdroh24n1jOVfbcRpDP9SdeL+c7QfXc1YnG0fp19n+ylZWd4pD/pt5l3XeSyXsqxt2iB6hjHJ6pphGIZhGIZheEUYx9+TR7DXp//zby/vWfLd+h5c6mu6NvWueITL6O1qB8/mZ0id8Jb2vruW9/Od/M/Y8Y98hnme93W+xC69lfz/hv7zFlz+9LNhz8Omjk0m/Xfp28MX5GvpI53PkPokP85d+QNN52+kjFyP/ci+LNsv7d/apZfytx/iUdtAyt9+Nh9zPyl9ic4suSAbbL7s55z0C9hnWCAj7HYF51HntA+T9me3HdoM90KemRby7uzZmV7K33X0qOOBrv8DdWi94L5tP459e12M0C5+yH3Qdl/3/0o763jnb8xnSvbr9Fldkt6z639AtukDLuyrKZnhb3F/Q5b8v5M/fd8+QMf7WJ/Azt+Y8ict/ADk08n/KL1XkT/P9vqbsrG8i/TF2xfn+t7pBvSJ2wm6xboYdv7GlL/P6+RPnMqZ9FL+nNf5w/527FtLP1tBfaU/Lf139u3ltdRt0dWR/X08R8hj5UuElb8xfYi8p3Xl8XjmTHreph4eVf7DMAzDMAzDUGNb7Jv8PD6/Z1w99oAZY78ftn3xs02+iwu9FX/D/MNnZ2fT6vzg1gnoDseE59zA9C1CXuvza19nP8zyoK9GP5yjs6sg/5Xd13YwfHzYjtAb2H89x6dIv1DG7ttn53Pst+Mvx2gf2JHxSQ3HdP3cfhfXe5Hy5/puXqd9gbbvWub4D7p5RJ7rl/PP7LfzNeiI6f/nWMl/pf9XdvD0padPHRsp7SL7sWMwzhzLdlngk9jFCwz/51ry73x+4LlfJS/PBSzO9H9wXIDLybl5zrDnWvIv0MnpOy94hhfW4c5z9fxf6Qa3OT//HatQzNyvNd27XO1bveN5fN7ZAhjD5/XEjTid1M/d+J9nAOT7v8vKsUx75D8MwzAMwzAM5xhf4GszvsDnhj60kuP4Ap8b29zGF/h65BqryfgCX4Od/McX+PxcU/7jC3w8rin/YnyBj8XK5ze+wGEYhmEYhmF4bi61lXTrhhxhfxI/bMT3XkPjld8RdmutrNi9I67g/dx+ZfuQ7in/tDM8M17XB9sbtrnCa/CsZGz5Y3/BJrdqSyubnOVvfyJl8vo8LuPKnmCbwepeKDN6zPLP9uh1Cp/BpmzbKza7+t92tO6bPJmG1xDDr4cNvms3Xf8vbNNjG1tg/U/a9vnQbn291+fymoSr7wuRR8rf646xBprXxHp0kBG4Xnbf5DIpfz87V23GcvU1nfwdb+Rj9h+zn/5Jeuw/+r6Yj5FP7vd6ePeMe7km2Mch+4VluXou/qn8u/2d/NMX1MUi0a/R7aR/9A253TH8FNbz5MHxR2fX/+17K9KPA7eSf9cebPt3PAH9PX1H3b3s2kbGqJBe+ikf9Z2Btux6SR1w5Ee/lfwLr+NL7ACs1pzOe8172cnfZcjvC/uaR5V/kTEy6cfbra/Pca+nmWl1bWYXl5M+vy6/1f7dfayuzevynK5+nmHsPwzDMAzDMAywmlt1tL+bK/A3+FN2cazD7+zm1q32ec6F5wodvT/egpF/j30YtqHlnBpY+ed37cW2kdp2zD/f5bDfqfD3RPD/gY/5WtuT8C1xL5Y/37PxPb/qPBHLzH62jJuHI/3f2eat/9nmuz6209lGa/+M2yJx/vh6sAFyrb9R6G8JOcbEcqYs+IjuraduzVlbOxztp2/mOgEpf0APuC1g16ct2DeL/Ch7zhux36+bU9Ltp936u0CvwrXl3/WfS+TvOR/o7vzWoL/JuJN/Pg86n27BM+kV5wpfW/9fKn/rbXSwY23sw0M+5HGk/1P+tI1Mk/gQxwg8sj/nEjxuoo/Rr24h/8I+Pffn3TzyvDbHfzv548er9HP89+j+3GEYhmEYhmEYhnvgeMuMmVzFf96K3fvqcB1457Y/MNeLvBcj/zWe3+D4eubH0Y+Zg2O/XaazsqF4Dl766myH8ryglQ/QxygT12b5sf86fh+fpsvT2aNeAWygaQ/Fbuc1Gjmvs6kXnlfHz363XDsU2z92/m6Ol+279ueSNmXMcqXf0f2/81ViU352+af+o16591UMTzdPKOl8Oyv5U8/pR/T8NHw/2GbtH7T/0Pe2Kj/Hco6X91d+zzLPb8VO/pbZn8p/pf9T/jn/135kjmGr55jn8u7Wh9zJ320USIs29uxtwFj/W//dSv6F/ZB+znMu4xLaA3mc0f+QbYM02bZP3O3vFXxCHv+tZPye8vf4L+f42QeY/sFiNf7byb/Ief7d+O9V5D8MwzAMwzAMwzAMwzAMwzAMwzAMwzC8LsRQFpd+DwQf/irWzjFAR1zin7/k3EvK8N4Q33JLWP+YtXMyf+KxKN+l8ue6jkrr7LcWujiUjownPuKSWEDilrwOzlGs+1H9GmKj4Npx9I6d8nd4iQvsYvcpk7/r7rhfykt8lY+Rds4XIN7cMeeO1U28NhBrCGWfZS0yx5vv+jX5nzmX8x0/S16ORbqkfok58s+xUe+xrlmu10a5OJbrfxEPTj/lfjs6PUo8l+/b3/6hLex0APG6xJJ5TkHeG8fpZ7v+Q/6OCVzh+0794ljKS+qXcykn6V5L/2dcfuLnMn2bNu191LO/t+HvKbke3G5dT7v7ct4dXhvM97Nqh36GIrfuex9w5rni+TI5d4A2lBzVL9AuHJ96LXbtOvsr/cf/o/OyTXveV5ce/Y/7Slm5r1r3rcrqtaJgJbeMDe3SpGw5j4W8EueV7Z62mRzVr88jT89VeivowVX/Pzvu/RP5c47n3GSafh528eBOt5uHRJ3nNyouWeerGyt2OtN5ZTv0+DjLfaZ+6f/dfIW3sivDkd6FTv45f6Pg3cB9lXtCxp4jdAav6ZjXeO6Q49Wtc49Yyb9rr4xTrB9W7Zv8L9Xnu3VKPW/qDEf9v/A8i9W7TCf/o7LzTKzyOg/kRF2yNtxqrGadmfJnTJjrBHqdL68r2L1be46Z3x26cvDdQ/RNrlnXcaZ+4ehbuxx7j3mLvKOu8s15GgljBch6Qb+n3vS79JHeO9Pud++Eq7GAxzmXrBN6yXN6V7+U+0iunPPs81aHYXgz/wCggvog4L8lowAADtdta0JU+s7K/gB/koEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHic7Z2NkRwpDIUdiBNxIA7EiTgQB+JEHMhe6eo+17tnSUDPz/5Yr2pqZ7tpEBII0IOel5fBYDAYDAaDwWAwGAwGg8HgP/z69evl58+ff3ziOveq5+JzpawAZfj3wf9R6fmK/jN8//795dOnT3984jr3Mnz58uXfzy6+ffv2O++wN2UE9PtHRtT7tJ6Vnk/1vwI20f6u9l/1Ufp2laaT1+3f+Z1dVPKs5ARdGr1epcuuZ+28ez5wauereuvsH+Vr33W5tG97HpoPeQWq/q95ZfWO+58/f/73e+gt0v348eP3vXiGuqgvC0Q6vR7pM0T+nibyiLy5F2WrXkgX1/V56qBpIy9PRx30evyNz6r/x9+vX7/+fu4KOvtzTWXR8iNNlM8zWZ8jPfcy+7sMUZ7bCJvH39CZponvjFtccz1FGp3zOLR9RT6kRxfIqelU7vigC9qyyh3XVB+qZy2f8X3X/vrMFaz8f1Zm1v/pf528gcz+6m+oU1Z37Bx6Vn3RLuKDL9A+qH6BPFZydrpAPsohP/cVVZ39+ZDPy98Z/+8xF7jF/ug8+iP17uSl/pX9fR3iwLbYPf5GWyB//vd+hqz0UdqLQvOhTpku8LcuK+2RuV5lf2TU5738TG8rW1zFLfanHWu77+QNZPZXf4fvzfoofd39j+o27nHd/SS+I7M/etA2lulC06nNaRfI7/bHP/JM/OUZzTeuIeMz7E9fUX3QnwF19e/qbxnfHJoemelb+j2epQ90a6XIi/v4TcD/kcbvISd9LwP1xodkutByMvnJX8dD+of/77Ko/DqXqfTpuh0MBoPBYDAYDDo495fdf83yb8E9uIQrOC3zNH3F257CY+XEpVjPZHGBe2JV/urZFZ/WcZiPwqnOrui44m3vIavGtqtnKs6q8h9VXHq3/Fv5tEdB5dY9E16nK3J18fx7tetMVuXV/P4J51WlPyn/Vj6t0pPzhs4p+h4F53iQhXycA1nprNKBxhW7Zx5pf/TjnFzFeWncXmPmVfrT8m/h0yo9EaMLwLPC8yHzyv7E7VQWlbPTWaUDtT9yZvJn/v/KHpoT+1ecl3PWyr1WHNlu+dT1Kp9W2R/uWPkj5RQ9/8xGyNz9f6oDz6uSf5crW6Eaq+BG9H7FeQVIq1xMl363/Fv5tM5P0oejjGgP9DWe3bW/jhme9lQHp/a/Fepv4BqUd698U2YXrvvcwdOflH8rn9bpKbO3zjsZF7TszEYB5RaztDs6eA3769jJx/fiKS+IT1POC3my61X6k/Jv4dMy3s5lA8opVmUzJ3eulOeRZ0dnmY4970r+rl6DwWAwGAwGg8EKxL6I+ZyCdSBrmFUsqksTc9sd/uce2JE1gG4eWeauLPcG52JYd3sMfwXiH6y/d9Ym3fr1mfsZM65R15SB+E6s8FFldtcfCY9dB6ivxre69q9nY0iv+sue5xnuab2d94p77pf0zEGmM57p9El/8ziGx2iz8nfyymTM0nXXd8vI9LiDVRxJ9+RX53GUg/A4re7V1+dJoz4HnSuXo/FA5eyUD3CZ9BxRxZ/h88hHY/5al6r8nfJcxqrM6vqOvMQbVcYTrOzfnbcEXczS+S/4Ou3/6MrPM2TnO8mrOmdCOchSnY3I9O98R1d+lZfu13cZqzKr6zvyZno8QcePkd+KZ+zsX+l/52wR+fqnyxd50P2Oz9L+nsXis/I9r52zhFWZ1fUdeTM9niAb/5Vb9DZf7fu52v8zXVX9X8vu7O8c9Kr/a95d/6/mf13/17KrMqvrO/Leav+Aji0+huGfdHzp+CuXaTX+q9xu/4Ce4avOn2e6Ws1ZfDz1MU55xax8RTf+a/qqzOr6jrz3sD/1rtb/ei9rm9zXPuQ8ms//PY3OkX1On83luxiBzoX5ngEZ/D7ldeVXea1krMqsrq/SZHocDAaDwWAwGAwq6NxcP1c4wEejksvXHx8Bz+ICWbv7HszVOoL90s9EFWer9mO+ZzyLC8z2MiuyuIDu2dX9/yfrV7UVsTa9nnFu2J97ngdy6HXnIne4PNJUa/TOLpke9FygcqSVvm7lG0/g++/VPlXsj5gTfmOHI1Q/o/Erruueefbve7xR+cIsjyxenXFGHS9Yxft2OLou1qlnE+HXM33tyLjiAk9Q+X/sjwx+biXjaFUH3kc0Dqfn+Chf+4VzbnxXfVRnJnheY+v0kyxG7f2Ftsf5FbDD0a24DvKr9LUr44oLPMHK/yMrfS/jVXc4Qs5SaF/Pyu/k0Xy7MzMhD22Wclw3VTmMberfKHvF0Z1wnZm+dmXc5QJ30Olb+6z6eK/rDkeo77XM+r+O313/37E/Zzv1LOdu39K9A9pvdzi6Xa6z0teV/q/P32J/9//I7uM/+sdPVum8Pfm4Wtlf887G/x37oyO/dmX8P+HodrnOTl9Xxv+ds44VqvW/ct5ZTIDr2m87jhD5sJ/OMbNnsjlwVl6VR7V+PplbX+HodrhOT7dT9x0ZnxUzGAwGg8FgMBi8f8Dn6NrvUbiSt75b4x7vvtfYwAl2ZX9PXBRrXjgA1pSPqAN2PAHrWmJ6uq+y2wdcAY7hFBpP7HCljq8FYha+biR+FvB9rL4Ox2/oepUzGPHRmA1tS+ML6KvjdlXGzv5dXrtptE66D97luFcdQfa7I7T3eI7rlKvpApHmat/KdMT17BwLcQuNszoHo7/PRT3QDXol1oXfcfkpQ2Px1VkBtUXF0e2kcZm0rsp5Ukf9LaErdQwoD0tcD/torFDTESel3Cpe2KGyv16v7K/xcdo9bRI9eXxL8/L4dsWrZfyJ21z9mHLIip00AbWfxx89jpvxe1fquPrdMdL7+wSdOz3dt+XyeBza6xNw+ztvQD76m5TImOkGVFzUjv0rHkOxkwY9Ku+Zyat8mL9H8EodT7hDyuUDV135lhV4jjEus5nvtaAPOV9Fn9CxqeINvf1W/XHH/gH1f8rjKXbSKOeo46DKkX3P7L9bR+UE8fkdd6icn+7HugId2/Tjey3ig2/0vRzcUx1k15Vfy57vzteDyv74MuXUHTtpVCafdyrfznf6h7eZkzoG1Aa6p8fHZ9ettpNT/k+h4wdzzOzeao/d6rrvJVqNW35fy69k6daut6TxsiudnNbx9LnMd13Z/zcYDAaDwWAw+Lug6xhdz9xrHtntSYx1kL4rZadMXasS787Wgu8Bb0Fej+ew7js9R1Khsz+cAOl27K+xFtY7PPcW9HmCtyBvFo8kTu4xG+e0iD0636VQ7lbjFQGedZ+jPLTHIDwmq/y/6jNLq3kTQ6m4GC8X+TSWoxxyxylpPbX+Ki98zo5ekF3LUblO0J0xcY5HuQiNpXc+w7l75ZXhCzxGqvXz843OwVb+n3KyMr1u2d5sb//Yjdinx3yxbbZvm7YCJ+JxYuyt7aLTi8vucp1gZX/s6mVmsf8Vj+g2CjAHqGx6kp9zQd5fsryrGLDuD9J4N7HW7LejKu5VfY3urVKuJfMZK724v0OuE6z8v9tf5wm32p9+SVz9UfbXfrFrf/wGeanPI1+3/2pvB35EeVXlD8CuXqr6nmA1/6OecIy6B+UW+2u57odvtT86pBzVy679yUPHDrW57nfZyQd/rvyfy+s+P9NLds/lOkG2/vN9RTq3yM5fq24cK3vR/nX/wz3sr/O/6txyoLOb93HNk77Ms10+Pv/LZNF9GCu9+PzP5Rp8TLyF9eLg9TD2/7sx/P5gMBgM7oVs/beKZYC39K75jmc6ha7XuvG2ip2eYFfX9ywzy0/jP6u9kQFdl74FXDn7UIH41+5+zVuwo2tP/wj7V/lp7EdjFX7GKeMIHcQtPJ4Od6a8Lv2PM3HMfZUP455/J3aqdfB3JFaxkqxuGpPRduHyKLJysrrC/7iuNY7vMqm9iFM7V7iLyv9rjF/PS9HPlPOtOEIvB93BnWj56EXP1aAflyeLOep3P39LO9J4OvJ4G/C6BTyW7HxAtg/bY7PEz72uFYen+Vb64HnixhUHu2N/9/9A25aOUx53zThCBxyV8nGuw+7/XfujFz2P6TIH9GyPQtNlNlZ9Zfb3uYieravyUv0ot9jpw8vh3glW/t9lyvZaVByh64Q03fsf72F/ZKKtZTIH3pL9K27xWfbP5n/4QvWXuo8Cn1RxhK5T/H/X/wO7/g7flOk8m8Pv+H+tWybPPfx/Zv+OW3yG//cP9fdzsHruUOcpGUfo5ejZwap9e1rXhc4zq7OZbjfFav4XcPtX87/Od2bldPbvuEW/d8/531vHvdc7g/eFsf9gbD8YDAaDwWAwGAwGg8FgMBgMBoPBYPD34RF70dn79JHBfhP/rPa9s8fS32kRYG9M9nmEPnVvqcPfaVxxiexL83x9/wjvANIP+zeeyVN2dTnNR/ft8ansr79jwr4j9tnpPrcsz2pv8K3yd3v11Yb6HhCH1hvdsodM+wT5PattV+jq8sgydV+k9o2s/zjYr5bl6Z9qb54/u9obsmt/3stE+vjf37Gh9n9tvIb9/XcH1D70ww7sI66gfanbyxbX9bdFOqzsT9uhTzs8/6z/c538eZeb7qHUfZsB2pu+a4l9fvqM7rHVfLVNkobvJzgZQ1QX/q6hrG8rqFtXnvqCzPaMvfiGVZnkqe/vUZn1/XIn9ve97lznf60n55J0nFRZuM939IrMei5E86U9qNxXfNPJfnE9X6G+AHmqvk273PHn2dkBzcf3lq/kx49r/gF0p+9iUz0y5vt8pdKxz3m0TtpffU+v7mXX+ZTmkb3bj/bg/fB0TOCcUzafcWBD/+3Mahxm/bQzliPL6dywsz961TEL/+ntSO2v/l33mpPnif31XCLtV8vM3l3l86zK/vxPO74yJ0C+7ONAfnRHG878Orqr/Krne+XddYHK/uo3AW0xixXomVFd31BXnR9W5xsy+1OujuV6Xc+lep/Scx+d/ZHJ29cz0MVdducWke6q3N14d9Ke9N062pc+2nmKwWDwofEPiCRqout3vRYAAAR5bWtCVPrOyv4Af6I2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4nO2aiW3rMBAFXUgaSSEpJI2kkBSSRlKIPzb4YzxsSNmxZPiaBwx0kOKxy0Mitd8rpZRSSimllFJK/df39/f+6+trSoXfg7Iel0z7EulfU1Wf3W435fPzc//6+vpzfst1px5V1i1Vvn95eTnYY+v0r630//v7+y9Kdax6P6P/afvP4P+ZPj4+ftoAcwFto64rjHbBdYXVkfgVzr1ZmnXMOLO0+rN1ThnSP6RXUD7KMUpzpIpXaVb/5/yR/V91S/BFH/+Jz7iIL3KczPmjwohf4ppnS5VXXdexnpnNRVke8mNsyvMsW6afVJxZG0i7VL7P4P8Otpv5/+3t7fCOiH14pvfHTCN9QZsgvNLinPZH/J5WHcs3vJeRXvd9PpNp0p66si3nHPjo/p9p5v/sO32eTEr4sOxY7SbHVMpQ9zP9VN4jr/TfqB1n/67wSh8f1vlsDiAeZeT9J+89itb4P4XNmG/p5/lugO2xYfbr7Jv0vXw3GI0V+T6a/T/HkPRVliXLO6vvEo+irfyPL/Ft9rWeTn8v6ONJjrXZ92bzUdaD/Hp7yPE802TM6TbpZJlu+Tvor9rK/6WyUb4Dlm37e3v3Ne0k/cD7BGnRpnjmFP9nPMYk8iLNXr4lPer8r5RSSimlnlOX2ufNdO9lL/nWlOsgl7BhfRvNvmv699RftfZ5tT+sOdSayWzNeo3S/31tI7/zR9/8S2shrJv082soyznqR/zjMbu/lN7oepbXLK1RvybubM1pVua/iv2y3PsjX9Y88pz2wjO5zp5tJPdeOWcNl3s5JrB3sya82zrLmeuJdY/1Ztaa+rpShfc61r1MK21Xx/QZkFdeox6nxHol90mXve6lMp+j7pdsb6P+z1obtmY/vms09le83Mct6COs860JP1Yv7JdjXv+3IfchEHsZdcy1yrRVptnzGtm3/xNBnNH9kf9HZT5Hff4/xf8Zf/b+kHbinL0Zjvgz/8lYE35qvfqcl3sC+HpUp/RBt09ez/LKsNE+E/ezP3OdeY/KfK628H/fRymfUKY8LzHWMX4yltGe14afUi/CGDf4jwAb074Qc233fx9zco/ymP/5fyLzKPX73f+zMp+rY/7PuR079H6SdS318Sl9g7+Iyzy2Vfgxu2cYtuT9OudhxnDiYue0NXud+DP3KI+Vg39r8SFtJ23KntnI/6Myn/MuyH5b1il9R9/OumKP0VhF3Eyv59f92fvBmnDCluqVYdSDuaT7N+fy0TcYz/fnRnn1MNpA34tMGxM/856Vufe1S2hpvUA9vvS/UkoppZRSSimllFJKXU07EREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREREZE75B+Hl45q2TuOnAAAAlxta0JU+s7K/gB/olwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHic7drNi01hAMfxYaaRmpWkaZLQLCaym6ZEGZTYsLQgY8GlJCVjg5IsxtuClCKJFFFCUco7ZWGvrG3lXxi/U4+6TUOnoXTP/Sw+3XNv59St73Of8/Lcnunp6Z4aNrRarfGosy/N0pvun+OF/l1pS+n/IDYZA12lL71vxfbYEff07yqj6f2hNB/I68dYZQx0jStpvaet96Fs34x5xkDjrUnjZ7GwrXV/tr/FMv0bZWl6rosDcSmex9fYOUvnI/nsbVyPE7G3HDsUfcZFRxlJrx/l+v5JnItjsTFWxvzf9FyRzzfHwTgbd+NTfIn1xkDHGEyr+3Em+v+y26kyb5gDOkt1fn8dx+fYrRo3J+NODGrfkQbL+fzoHH6/1TGvYpH2Ha26BnxXfst1j5nIvo+0b4zF6fgwttboua1cNy7XvlGq6/ldNZruzj43tG+caj4frdF1bZkr/vf35d96k6YDNbpWz3veR68x0BjVc93HM3qO5f3tuBYjM579V+f/Jfo3xni5D/w1Fi6Udf9qDWh/efZ/ue0+/2lex/RvjH1peTomy1rv5Ix7uwXZPh8v43BcjQn9G2MqLb+XNd6hP3QdLvNANf9f1L8xqv93rW7VX9+v1nqG9QcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZvETm/11FNmJ7NMAAAFTbWtCVPrOyv4Af6WFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4nO3W4WmDYBSGUQdxEQdxEBdxEAdxEQexvIELt6Yh/4oJ54FDm0/7601szlOSJEmSJEmSJEmSJEmSJEmSJEkf0XEc577vT+c5y7V397+6T/dvXddzHMdzmqbHz+wY/Sz31L11FsuyPF7HMAx/vod077JjlX2zYXatzfs9tX/VN7/+je5ftut7Vjnrn+V6nX37xtm/ul7T/ctzvu9f/9fneX7aP9fs/31l23ru1+/btv36zPfnv/2/r/oe1/er90Cu1Xf7nEXVnx3Xa5IkSZIkSZIkSfr3BgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA+EA/CvmsuFLaKmYAACoXbWtCVPrOyv4Af9TwAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4nO19K7jsKNb2kkgsEonEIpFIJBYZicQiI5FYJBIZiY2MjIyNLJl/Ufuc7p6e6fnU/9SIWnPpPlV71wmwLu+7LlTm5302ngDas5EtxtdGYIejwwJwXcUFawDfhX7D82Id4IEKEAG2ChvQniTBd92T2bGEwfHNfHP88UNvAJWb3UEr1XEztr5sTxUU4HidQOEo6TDwYbmvKz/3CRKg3FQspF+NA683gbhzXJ3b3s+YXkJsMSn8QxHzldIPDyvUa9so7kZ5TiI49ZZkUEPMXzkWyNI+TwYwJmyrNLiPSW0r/u7rbpB37ttHF49yxbD4jZngATxRqoNxCQ/RFAkrr5eyhUiTfQz6oa7BZaG3HX9xj7mufn6CWykuozVjg4k2LNb6uMXAwYJtDp4dBHVPoPjvqDlwXPjT/TwvGw8vP7z8t7hOxDoSnpNNwpsFcCm2FSAV9sScLRzVHjJwwCcPh3VLcWACvrTNX7fg2ubAH9UvuJn7Nvw0HTx+AIULtB43N1PqG4HH4U7d1UJR1+HW7fPrp6iUdU3g93uPjvs1yCUuQqZOyYoLGGs6GAlrm07AvG2BOdgP/OcCKqd1gVXFfDKohtklO9HvEYGbqx24XUbhYdeSKc8LqlJFJUhXYzBNZwPGPrv4KS90aWiTZpj11QnRuFiGPsrKHKgSy0XLxfLjKRWW1DwPLOk29nM0xeHAf9Y1m3rgYvA/pKJKH/Dg9lwbPBlPHE0lTyMoN+Q24DqnFj0Jnarq/dOLB1lBo/fCg0gNtqsIkEygczabzgNNg1jqyPlCY1idJseYSr0TdARluy7K9hL8qM8JMy4YamUolM8/1Dw/nS0x6SRwnU8BPQD9f3gUGhKMC//a/QkfXTxKdMKht1Znm5pgfEksPOS4lX3gRvMOUWpd0G8lW1Bh0f0BiDb9GFgSWb/NPOEXqj8QqFlvaACARp4X/DA2N+GBrR82Skbxl0db8IUFd3Ypms83Pywc5EB3jgqNBm5N4Mem3RNtzAXKaz4/9ejJTNpq7w+zFT2A3Q/aJXeDWohpekZUeAaBEPSEJBGBr2tQ9jibRbeQbfL4CWpBT5nx1Nf63oCrnhw+fv6ShuXc4NiGkboG6UI5+rXiCYYL1qQCOFWtq0scDkPDdrRqYusPTAvo5edDvALvgHmvBaEL5x6NO6RtF2oLUC7UBSCX+OPvRGvxFcLqd/6hVf9FwsKAM/TcqMGUkZWSOHjrVcCFSsr8uXMSj6MSiZ5chLMIDujJn44rOwZ9BwRzrRhGEOMdUSgeS0mt7vemWN2bhMaoCrkxC8v6/itLj/qo6GRYjB9dO0rEo47vYwiIeCSdp0TR17feDxCeohNYYGnXHiDsqOvREEBszI/7cm6wbSSBqMZe1znOhO96QkfPnqBRPRXGbmYQ5GuEROr2rGU7Cjyo/fgWYdP8Piy14qKem2rG72uHMEKfW3Ao9eIkvx0AuofHoJHb9sxw/TQMbssZy3FglFjGk/kJ+nbPtfboGNkuePVIboz7jW9yn0q+gM81rPHB4P9I4Bx1qYnx6uuHl48LZuCnFgzt19dh7BiVholbWhcZOj48x01ASqM58wL9AqziJNNxXRUBoQB9PUiFFgxrBND+M8bKGLrjr/npsrp0v1GTPX+CASwJN8bHBrXfu/3s6udzDcQ+kOOiM/i2797cNlum0WeVqJcMUkyN2I2qqPkRrT8XtygMjSZ33S43QyN+QnsIgl2v0wrX4pdV1FcCsgw3mdIxf2prfoJllGNHu79yFsvH+R/Q40TYLhsSPfTLS7Tc7usIxUDdV93HsU0SA/sw5YCQA+P77ejkvDDOXAba8nh/kPOuds9x305aogs+IwTGDYOEjOBCRZcJmaUplYK6JnnYQX105T9C++oLWextKMJXSXDhgcmx8oDxC7h8vTKXK+j94Fwyt/Yg7d4pkGzcOLfWdGwYBRzBQFouQr2Ao+8YBJVl8YWLjYNSU9/0gcaDbT5kmEmB6f5s/vTyJ04NYYZkxKJHM7kljYa8I6spP+i8zyQFAXMfHN8JA181PROy7Vkcx0JSIy1rInFHUC3QZRL+IudmrcEIwuEl1qktz5MzHjfq0OTMyDjUTTmZGYHPihmKLBus6ORfKm47SILB+sZFFkLGsYYd1mNsv374zu6x5w3LnVuDji9zYZ9nuEkVF0UIMuUsegPSMdoXdIEbOpJrTMbT587BBqHN7RzImQgP5aOLRynmHNR7EjfKb/DLxW5kqPik6Lfw4ZV7QHL1UJg+EMZrwneMa9e9vqELI7gPa1gXZnmREtZFx/eayEGpzULCOcJ1TRCw2940UD25XwTTbJKQxmdXj67Yh91OlRTVI5ZfbpmHR++kcANwCyxahR4S/1V1mzbIk/fDVqab07C45TBFS5E3Kny3/Rhdr3ud/Dc1Rlzp1La7+npR2BWgeiHhgscHCXUVSIA+7v/zpnVwmrLa9vVU2aO7bzNQKYj4tFvgXtU249ba8+NgIC2aZCYS4So9tiXEwMpmWZI8v16Sg9i3YF82najfyHxoHbjM6wUz2KE+gIQyIBlQuhD6cf/XNwcVz46zC/3VDvwsTnO+artGmT1CtYr8YAuo7YGzlUOn8vYEaY5VkikBUumQj0BMxd8G0q6Ei/+JHQK3x6dtYjwyE0ZIk1JxsLIcw7lGvR7l4/j3WBy6aY3kjrL1T22sR0H93RC39NJ9OrYqGr7LE3UMxGYF2DodQMqrUkiZLgPy2e+KsDbC8byxwzaOapDlAadj5kdPcE8tDRD6rTYdSBfS/frcyn9LnclK5ttVwM7sFjq6SseDvp2K/cl2PGd6juOM6ATxIPH/CDFGKnFtmS07kw1J8o0UADcNPwPeHuJP7ChZcg3ZZGXHCs/JRgbKFw3lmQnS+tGl/5ZyxdhIlhAfy8Fh7MfH26HopT4YxhAALKGVuK8z/4sbROxaCIu5RfHKxq4B0nFx8OzYN3AbgT+4g8iM3kusBpD3xSUOyKckgTsP4rw/Hv1RrHIYjTazcFADN2C8YZmGuOlePYQHhP3JUue2XxeG9ZmzKW2jhMc+wEQzIx7Cowy8XycN50n+wh3JrXUPzYtDwcotUo1uEGXjr4Szss/zH3NzlcDuTM/MPMitLxO14BtSKXxMdF8xu+nywTx19X1FCkTIemzC8SQUSNMRDivvTggdXxUy7L9zB2MB268t8nJIkVYuoBmzpYj0Gv/O1NaPJ4CR74yZhSh9C+BvCbLtOl3orKfbNqdGaGx3sYa8QIzSesZ7NrpQX5k/DAG2DUXrG9LdGNBos6L237mjg8N2ouZLqwwv+0LpIk3S/rJoO8DX8fH6F+cE0LGhb7/rKWdSAm0gwySsNb8sIJRFg3j8KD+qOhO2Z8BV67WFF0a8NJ6Z6sAgCejgFgjztd+5w0U0jIEGIZazcT8QbOSYB5D1Qa71DoifFll2tO5zOm1SHqooRwf/sFrfedpHcYQrdzARKU56+/bn4XWIWfQtxSaVp4/owCKiWRAJPSdJhv3OHYM48LfoGHu7mW2IG0wvfoS5jxmDwiH+j8f7/y7jQu+u4NjRzEE9qJ7457yxWZnLDHx6BPTwOmaJGyPCrH9vaLkyWGqB+Me8SXwx1thpMxNBKHz5p3YQZjHFAxOl1g1OS4CImkzAzasa2i6f69PrP9Jy2V3DcUJToF4jbxby/i5sgCUEegLi4oGLDa/E91nS435piOSUg1CuAIhxEB7rdSY3KIQFHPlVO0ICoZJsIHpG63jXjgazgaKLTZv3y/ILLHxQZgxW9dag9muCkSebTrr0YsyUL6EkRU6VuaoKSANB12ne+1ELPYJ1LR8vVOZRQUQ5k6Oo0mfV7Fft8OAlWVrvrlyAn9ph1KWk4zWQT61qcqgPy9Hxqfh1Ijnj1kLYenCDzKzWdmylrWw9C4MQjx4VybhZ7OjHeZ8V3L41dAP9habSEQvXbUWDgXqeK/yqHe9NG7G+iz6oTL9rxz2LcnIMNI0D+ezqp/wUL2f9D5pFwHIS/sB+UIYYpm5C31ugrlxnWxV7oauHkmcao+NZ2wN2Up9XJxuGhwp7RmWwbTHv3gGMewsC3Xe+BwNM/9U7kB03qCYkkef+ePpj2vjD0DCfC4GOnm7d9onz7SYR+tp1xUA1c0PoFEPVsW2c8R84SBiD42Vm8e+5xnQMks48UEpa//SOsECDj++Q+cjc/+gdobsWNJ1LfK6PI2AOF30XYZ9rEVJO4v+gJ5d+SVUhwmvyVwGAgUyMm1rX9USYBE5LlcGlBffMoVXjBgyjnM/E9/3dO7SaZ8wS70x+YShd5a/eIUJqdugo0Wbyx/Ufo7+59Fy380LlBX2SQXVI91KhpKARBs4CANVn6/eY7hpNH+4LqDw3hwxPi7c6yO3KW/dtNnXtdvaO3cc7M47mtT3I/O53Hemnd4xuHuj7r//4+o+XBKSkM3BL/s5NoqS2pYOoq3vzLgB0C64ioQPzbnSaGj8T4OuNZGnxsGLMQzaz8z2wykUJsxmgHq0e1Q6FLIClG9GuT8gKspz1MLlo/naHy0cXj5I7Hj267/VNViWlE/b3m8qqiHL8pwDA5MI0nUgYDR04cuTZ1AZL7I2AyXi67UEc9DrKMg3aEWXALqmsAdfdnzBOPGed6+SD+JkniKbK7s02o+mHJcHDR8wx1ta3bX3uoV5qrm7t0r3TU/0wDEN6AYvH7UxYhjP9nMhVg/aETTteBeL+XhV+WGOwvY6AAWEBGuh2A0dIBXUi4ecNMYrza07XS/1Ugj8siNnncoM97tyOhlh9NkNCEFc227sAkEbfF6hc7jOWbXs0IV05/+G7rdfcSjRu6RTYEzVK03OEd4LcXgyqRJ/3aKgPgo30jHr2gru2o9/9OP+V4BxQ65Rdl3qdF/DzujG2G3il4n4XAPy1SjgjY74lgc++E663Y0Z7ZPOXG93fAx26vW8d94hAd8UwiVFzUK/juRKaXxXMgc4gPwgzeUIyxJB7fL7/BTWzp7iHfcs+eHtxKGG/stvRgmGhPwWAjtD+UZMl8qfMbMGs9jT0gqTPgnhtV0nXhoBH7a+mQ+ga0vTsMRLqEpII2xJr11HW/YwzaUpoG9wsx/+A+uP6iRpLuppSiPfFxPCiFcTCyPbITwFg+sjnhcqyu4aPPCHzjVsQnrhOd9n0tmHE3Pi2olqAjsB4iVxSdHaaAdJeWkrt3WFcKAHKHshamVBFlo/r/+4gMYqa3qMFoWiO4Ped7HkGMPdTAJBMIch5Ds1RA1APzJ4Q7SNSQNOxJjSvYZ85EAInMskBnsSL4LZJFaxFxzhYyfhJctXECjSoE5YqeZ79Yh/Pf4vLvNMaLyOJDXiw3dHcO8YyUn4XAKqLAfXiGdbhTzfP7aJo75PVmFWO814Ip2sE9A27mqXjpyjkvqAspYifMhiH/Ncpz0MH9zoo2ZA7lxxRMz69/jThKfoliPnUYjbuF0I4Af1coBQfswBwtfWayeyrZTzquu1T6bkQkILY7Nor02pz8MRwjIS4CN8lPCYZdHszP4yjCKx8TgYpcDcRYpnUAn/u4+k/1GGkaeREE7VXbAh/khYBob3wiFiXnwLAWto+O3X4nSmka28DKSNX4cjNU5purmNSvXj0lHtbwHNYdjGkrDk1iRFfrBqsMEvpGPXBGIoRttWZN9o+ngBUcKE1h4u42bSkbBozpVP8Itid6kzuvYhYkOqF552rW+E1bfah+A4Mur9RAD0idX32kcZwz5gqeI1i9tWJuu7jl+MjaU0rs/lAu1ohkAn+t8+ufmrg0lmU3awVGJGhtNIkHj81ipWgbQZ06nWIXSCHJY5AjvfdhToONGg424O4mKG7dHXsFzPAO/oKzpFPpDFBL3KLvwS+mQUKG8YRz1IqNcDH+//L7GncJmojBFkeMjq6JFoIKGGtZOZA3z4negqeFAaE10wQrK+zrNsCF+uHtqm9NlqQ0cA4fGAbxjbdIgLljFgBMd9fgA96BScQDe5GLan3u9GP+z+w+lheAvILQTo/MQiiBzvYzGgvSxieVkIn9QcM/HZPbhIfGc8ERlPygrzJDPUGxqTqsO/M3lF7PWtoN5nAF03lr8B3WFH5cPxcdu/Nk85PL/+2LsX22vG5CvSNTjO3zUhLUvDJbIpLliKbcR0P8pQeiV5X3ASzaIG8MXd0+R7joAtoQAcCp6zRM/BlEh82/k58lpIXtsGpi0k7ee6P8z8fAzh0WwaDW+khkQv6pbUkLB/Orkytt2WWIo8FeqblJUnehkHqa9zMFxFS5GwhM3X6OODagXkT3+s/E1+eV8XpvSmDQWJD0vXp9U/5IXJ6v4RhoqQ1U7HNbtaXo7OIESPCFDz9NDN5j9w2IqoVoNJS/erR9N+DQ4GCUQTlvyY+uFuPvCMKQgBIzce933t2oWXgBddrT8PXVMlscSiPVUgD8M21aI8PDLvdlDgQuixAdLC19sjD1YJM23twCLQZlfwfiS/YKstMIo0UZF95DB/vf59rLDTuC0fMlv3RYkQ+LMHPLm9rEiL9RDuGfDeWWy4VHLVE1kPtF0GcnxHkI4lpx+bpbP/8r4nPn6FJ1qzQFvII4vPeH0S/cb1dK94YZUUJlfKWX6stLaCZg6YL2rBjqRybs+jngF74v6VM9BKYcbExfhHrEEOQ30OT/5T4nkOTOaGOCGdOjRHk8/3/+xqT9UjIBDhCFmto6uerSsGOI1qkLWD6VoFvp5lNy2EgOXIYERckABPu1boUA1otvGjza2jyHwofP0OTJLcJ+16W8XTEj/e/OWQokTgWUN2FXdq2mqPXd1sSogF3bBjpzzu1jGSV1G6X14b0b85Lq+iNZPkMSBqm3oQoRPqvha+foUlu/EnMIE3v4/xfKAD5gbwOGfAanJIY7vA1KTYSSC/29cxZzTGHuCCxUVLmjGsfLG7L1vtYSL2tBsqJ8A6Rg8rLPxQ+/xiaZGaTBAHnJjazf/z8vV5FfxVKlm2LEhSq6XTeyHulQ5e1m73MQ6wCY2C97tkwyoV2HjUdw8J4POSD81w5WQK33f9j4fvX0OR9MdowNiLXtCHWj/Of6znqZGw6J5YM+zFIIsE8SE62AiZdC8Q1z/aPNrY5xyEWSe0xOyKQyR747ll4Qc/XSy2XefV/bXxofx+aDGQcDaIiXfDP1//b67kIVbkuYWurZ2JidzI0rI2m/ZiDwGotuSBRDqrMwgBPZJYt1gTWwTpOihQJZEenl8ulTdn+pfHl+PehSQlW+Ec9s1f4fyEBcjbpm3fRSDPzsRi7FvvScCLxHdfbixcMAbmhgqMjZzYqeKU5H/CuhO9re0iQrjxXkKj2CO3cQhZR341P578PTVYEEfmFe0to9Z9ePMxGfxWJVw0dPOS1TMCGx/06dyR8sG9ZgJwtUV08E8qrzdoh4SHlnrn78EbPHnFAEH0zZqFS+CUdu5iNbxXEvw9NjqPQBnKvRPXy8f4PK8tOfOxZzVn8mY42/Wobl3IDMdExFWs0+PppJ1jJGfxmg1w63GWu3rz3INx+uVA5muXSMe3fjY+zCvYfhiY3jjhRoWFwZfXH8e+G6PaINSA5b3OmTdp5lwn1SwQt0dt1iqR1Fjnm3AdCZHg3SIdWmb7W2CamXw+or50hQ/KjbAEYZ0wOIP8wNImxf7d5U/cCpX18/nHZs95r0PDsAdn6zGKuczoBZronL9D8gsAOHeO8s0Ah/l0luYPceiPXPcRKpHPHYDOXf1cgZXo8jVBJR/IPQ5OCrvswqEDoNO3H+78LA9XeHvs1uAI1Z7WVeP9jju1Uv0f03PtVGfQjr1LUG0NDxj90ZHjHHPSG+ExgjMaBOKf16+lkZ3NU4j8PTTZ9LAwCX52akyAfllyCa9msBN74nmx0zoRsr3OgizptIjLX4zW3YgFlXF0IXPIMy5vc5Ht4Yd9Mb7mLUdN/bFB3SzeN7Ok/D03upYkAXmEs1R9f/mxiKNTAMYc/8b/rgwbt8w7PM5MdhN2MXjei2/Y68BCFy96Dw8NeunVzrM+acUK5OCrBjehogEd4jB+wWf4PQ5NtNQKDTX7te1MfZ8A5buiRUliWHUN9W/mrixefaAdPznRDm5cxI1cz6Acqmvs6O70mXxiHRxTb24K0JpxIfInd0ODB6DWCTJGJ/zw0yYPv8lxiBab7x/u/hhGXRD9dZk17VjYqglPkPIeb2dtlmY0wLKAhq9gNQbTL2L685/aF5KH2jEu4CJ9tpJxtncHG343DcoudvU/3b0OTraSa/LwyiQoIH/d/1uEjg8NwJyS0RpDLv0Ah0nswnhdWhBGmWVep2MJvZa0sqYonqotIJ7q/92Dncv0xzuLa6BWDI5rNvw9NUlOWGt0QE1m6j99/klpCHdBoxHyWeLK3SPNADTbbWXppVx9shHdRE8EMERzhfYJ5cQ8Xc+Ct7LMhYKuzH355I6ItTxjdC9WRqva3oUmiWJX3kG3WyxEUf7z+B/GozHnP8YHR9Z987/wqMG9AooEbXduTiV4oYFAPEcpx7avCg3a2rWVmtwHpz3buJ5pPQT1CgPsejIPdgnDk70OTSiMKvKgQDNaeno+n/3GV5jWxDVLRw+4XuoDrgXdWJu2FKQzUqYPZbkBwb++N57Jd3cx7M6x2tjoL+g4Yx/q1ht7DWZHozWYqYVfv0l+HJicKSmswbqWJoq9EuHjoj/t/C5RcL0iT3MzJRAzhdQPOcQ9allzajEcr5ZW1WAt/7FqlVD56JxE3+VGHgXERm4S5jr65yYztAiNL4lIu8i9Dk7sHVtbcZ8dR18isqOXp4/MfXAviEOxguLc/ZNzbFzF5s5TldU3bNsa1OFpYXTjD+F5whap3UesWRb7nDSYI74yHrTEWZnITUpoDwUtp+/Hn0CQQR6QWzhPT8NTdnJ2P28cB0JUYHoyv8GgzJ4HArsL4lLeTBsd7vBwUAbGaHh47O9Z+RqD2S+4zN9BrmhSWzHU8CHD2tWTKjuXoiCtDqH8ZmqQImQyNUuEPkfdNernGj+e/NxspbgDSgAip5gT21CBsRQMORx0bec1svYc6EsyR/0mN3u2Sbx+xQuw8QVyOjJpcNo9k8Oj9RqbgcR/gz6HJhVGJW+K1MTxrqO7dTsM+3v+XUyV864LO0JXvcwFUdcZsZcH1kmKaQX1BuOvm7RaezbT+MeP9GzDAQXsfyUv5k8qYGxTTurx0atEH8sfQZBZMST1yngkRD6JQUmfz+8fzX0xiuFKzo+kNxZ7rEGw/q+KQlJ4pIbDWW6uJRsLmCG/W5wt3aSYCa16UQ1YodEBw/Fcy0/eyDvN7aNJ4gUiXR1JusgTNiYxlEQRDYvp4BdSJsIGq6TZHwbOp9x2RrI1RhdZkMjdczNirZJxTkRvJPVy7RgKnZiq8MOmRHQPbowDcDk9QA5D6xzUocoRa35kTeFGREFoWPgilfkegQWUeTi314/n/aln03DeX0r5uO/puP9O5IlC3r3jSfRaHt5UaFhAdL+BO5PYYAN5XOt2KJrSX176G2Tp4IgzqraXRgxA7hsRS5xTtjpS5FwyBrmPkm4XRmfWx8dwV/fz9F0VsbUfCp2E9jwsXaAjyFsKoQkdf5nWFs9dZblrsq61GWXMg9FXptSIVek0bJss6y91HbrgBz3XtLvVEWIkag8k1WG4UHJrBofYCmzvefbbUqyVYTz+9fjIm+d3YHO64B0ZyamqiERiiHYU4iJsLeUHKxuQXKrFXEAkRobMTiYCp0hBJkNIRmPcEkzkvuad1gmIp9YFas2wYOusMc+G8DrkgOLIINcDASvWaPn7/abSBnIGQ0POYSTyQa53tDsK2DYjZpONeolPXeJpbi+gHstZzDoCtR0QXuOEWwOMohgAriZciRaO5s0hu1oZBX5vhXEawC1r5vdkZJdLMG4uSxNI/3v80YLUErKx3ndceX3vZN6EcHBK5ECL03TCrWe0G8a5Ak2Z9mKW2yf/nxVBFaq9tyNp2Ou9RyB4diL8E79Leck6+r1t3zPSdeuAq9rGKNRwIi2M/omofn//lGJSslGadN7W1lz9LX9EaUJ3RJywgc1oob1QNfJHqw5NcLSXq6JSS+2iEkux5g8H4xfPKXAljSy8XCcunWUfUu9qQ/oaNEtF6JmMiDCrHKCzf0X/c/7d57UWfcSiaeQeYW/W8shxxYOVhoDdYxLzd4H4Q/8H+pL5SrqXQL+bJe2iSaIXxzCKmZ/jDGhE9dwiYjvfdoPvVl4iKhD/60+n/zLaRdRJOHWh73GcXD/P6P3Rxqp6Ibe0s5aJ1olv3WcLz2m90/wahK/SAFCGraGba5y4yXezduT+HJpWcd0HhUoi0vkbDxL7rtr4RVWWtgqsHJf2dZM/LbAIbs2n4gYva/nH+l01zJuc2mVibdxYtJs4eFlntvoUzKKWtmUc5kax7Y9eBzNasx78PTebdO6Oirekcdt7w+oBugSKXzggB7WK1HbkpBL08g9e+zdzxh2Vf8DG2FR38nHDo6PfnfferMTH03UYjkd9ZWIOBcBWkcRQaXZfcc45/H5osW8IlKiYcoQaxQIMdRLxm88PSuUGH2Zlmc5QMvcssqIPePr/+M1nPHNSVFwg75zojaEVMrNedWwFST2SLyhFeR+maQY3LqWbfflkh/cvQ5EXl6hjxCG4Xtw70/DCvfsXgL6tBDt3ygQqWS+Vt94IBsRA+Xv/dV1micYYitQESE6XiPBgI0YZGirLO6ypjB7m9Ohp423eEfKTNnnetlyX9ZWhSZ7Dl2PoB5tzmZL8557T8zJWqy8N2njPAdg1EZ5mNaOc+Pj//8jPpiWifWURrkGdD4ygDyrkQwoOq1JWN9NdTyQG3hqzUnHzoDREyUcH8OTSpKPG9P09HFJVRMzSFDWbrY2OztlBvcANUgFlhg5ZXKKM+H8f/QK1041g0iGDwTEem2Z5wlQiLyYTjYe/jmsWwbB5cpFs5gmP7Mjbz4lUOfwxNNmYsuoryvMsAJ5sXpBGFBp5D0NbxNPhpPET3bgSy76Ej+Hj8l9CzDUh6Nee+D1uqCrJfqc/Bt+gbtFF0nMFtiXZOy0NfzPFgoId46NH84n4NTWIIDXMAFtcUUEV4u4bH2Ic74sD3Y1fBF4wqblwCmNY/mf+P1792gzpPCPWxM0Bmvh+DwtJSzybGZdvy9fMdFe/HbQWWW23ZnEMHhIfqNWYXKPwMTdbk1tlOaQO/jllY0HjQqBOl5tU9pzQKecRIGE+RPOSeMHyaj+d/HBMz9KXMEAjMW//2Qgk6f2QxkSJa2U8kK0t492nMkj3vc5jlSrj+gNRnpojIDAV+32lbUnonhhi8mgfGRxWeI692kZd92j6lP1d+cB+vc8+gP57/a7PeQffXS8NyxbXExc5rQJZJ8Hw+Xnjwc7g//VzV8GAsRBvo5PXMkgGpjLCO+zWvB+mdVwMXj9v8yV6jE+j453cLgETTGbVNB4jhFvhYZl84PCV8HgATOF/smYlwElDzMYaF4+6EV/7AbG3fg5iTimY/NJ79vLs6vfLMgQ+TX6PUlHYg+48d+03gO2ueOnDN1n+yHw7iHI1f1vnhc2rYjnF3XSRGh6N9HP+iFbt5qw3X1/ssYhgn1eiwTofO/j3Ub7n21vTUMCwK9ajH/7q74n6Wxk2LHoPE+wpZlVK0iaU04jYrIY+UfUB+dYdqsGN0nUPU+uD1UC7FWSj9eP/Xjo+gvdd6tT83EjDGV1hG3KO+bxsDjBu9t6+LM3oOi4GKgDAIf7AWrhDBYzioUqPqR7GiZx+bMOD2EwwCplSXVesa+PKEvbsEi513rSIvNLPe1o+P97++7kO+UWBbBXtPs5MEumPIbq9dlQO2K5V723ut57ze1c4LThEhgTOVgTyu3sdW7YLseXjpLCFDCuaZYrIuoOoIbGbW1+XB+CcOhNLBXCDXn87P7ePrZ3UsEM68t7iady0vFvTfM9ul+brx7U6w7eJYKJtjDYOO0+Jv9U0RRPCRc8oZomG3I/wjMHtjDcHIwPAltXVEV0NCAROlWoBB6c1aNrss2I/n+3j9CyhaJYextdjnd4DRwOGKSGIGaFRiMvn+PCT3xipjwLzmCG5r97OUX/fXkJXwq9D3vyN7RCtCEDyZIeLH/FMvvGf/A8OPYPg5lK0uXgddn4/Dn5nGQ+3MKz6Z7DPvgyuVBf01xutdpAZxnYeExHCmaicKcq85tbxGRMisKX46DOPoE7qflzlHbdzsk3gykqX5LT9zBpZyYUcieXZVs4FwYTtSDw8Cq+fj+PfEg5wXIMxBn1wmF/q5kwr/P40jxAfsbgnb7TDaZWWNvbSTZH5vknHltq2vIQAhx7JQXkgpPr5vtevIkS6uxLwIkdS2PUh5uxk3tFO0LU0CvQrhP97/9Dh5o2O2zhGZ36dxE4R83CMI3jUi+TLQkQuHbLVtI5f9VYnRyg677P1l/M6kzlaGzshiF02QFIOkzZgF92pBzGM3Br5aHwrkXT4LNL1nYvYKxBX98fVzCTJXUnMVS2cD7TbeCObnDSdzOHEfG3rxVFRblFKbW3fEAM0pSYuXOfg1eKWO3Fdq/doNI5Qhbk4relCSxNqUE+IJwUsQZ+Kywd5URYwsB8IBwfnH6z+zpXvpXlJ/qETdpT20BFKldV56w65jr5Kns8wHpSZEDrwEiSdpNzT4UxXLSr0c35SP7SZIpeZVqRtH4LscWxH7guFjcgjDzaaBijz6kouhHte/fh7+iTR92oUYnu1oorDOO6/88mxwQVrwtCWSWNRaFjt0rlE/hBOx9/cdDp7zeZnvazErxrN1NsIdW6upzNbohgzhRPWZYzS/xpza89DdKmSElUIjIX3e/2U+x3NhbWihuf/qRzNjXuce5pc4dTnzvLWVG+K4iN+Cz1XpeYeHQjtmCyJZkGk91kSnCz3K4hyCwTSR7YomoY6S3td8vkP9k9Izu8T3mmdd2H78/ptXZ2oGaFNJWFUOk5EiMUE1Rh5/cjQG1xJ7/OHc60Hkl+lsap93uFTwzuGW3XQ2PB3vL07BoCCNXPuk9fOrUqV0x/sOmGF8DMZpqMzNPolULppXbz4+/3iMlc+vvFm85sh757e3AG0sB0qye2dnfcl2finqXQ8X0eZzIT93+Oj3WJuJgebomB5Hl0awpWwhN46GVZzWfENu4RZm77OFOi5AbXElrsHoh5Sxf9z/01IGF3U/By6Wjzqv6GFC67zWuszMD0UjRxyDZyd5WKtE5f91h1NXuuSZx4pEKYyYMjHX0bUZiVa1iGFnV6zgUI6zsnGNveerz8iSzwsDzRZzlB8/f8K2lUDlZyIpqu2q56lzXNZU8uL0e94B6qtmM2f3iW8C0f7PHV4Qdzpe67wiAJXde7kYqmQjsxUYIc+GdOB9qSxuxnlXRkt2CI/ChFiUEjSWg3w8+41CKwSg6K7COIhpPY8tO7QIs1gJNRxsPS94bOrzjneVluX3HW6zXewgChngK1Pb07wse9WeAK8v0JTiVgCh+7srPDwN2MwIpK7AbyAen+Le5+jUh2VOcPleT//+FrzZ+Y5PdgtxUrYgoxN3SAFGM/vdgd89b/2PO/xgfmuSUs8Dd0Pfz+2ylHXCpuMZa6FqRZgTfPuJcc+pjtQUBIJLVizPC+DPKj/e//54a+HcfVGQeMFVuekTBpwvTdv83gPEwuGBPZ0LpNWwcP2+yuY954qQCB7OXnj6QhbLj/cX3tpLeKun00DwW5DyzkmZvtRZQl0WVKqm4p6QB5mP5//60UtxBckuAuG9gFDW23cb/7zD00FHXPSaV8LPi4HY4jn54w7PMlMes5flQVzok1lcnN95Pceo8Edq977M6cf11aLCTe5AGuKMdNSCtoR2A0R/vvyDDnrOK7LZzEIOxLpct5+s/LzD1ayF99nrNsvba5k2TP64yqbaUt9fcv1unWx8VUHPrxA8EQqiuct8prIhgrg7uhLBOJlfMdxn6XPejfnGQ5+H/7/kIAs+6lZCiX7mLLa5rhmgy5hf/yZmmeTVanDxL1fZ1I3Kd2EA+U8gvJqwSAwSM8nb+/6+AUlgmMjyddj5Fbv1uDHqzaTJ+7cIyM/3/3/lK1/5yle+8pWvfOUrX/nKV77yla985Stf+cpXvvKVr3zlK1/5yle+8pWvfOUrX/nKV77yla985Stf+cpXvvKVr3zlK1/5yle+8pWvfOUrX/nKV77yla985Stf+cpXvvKVr3zlK1/5yle+8pWvfOUrX/nKV77yla985Stf+cpXvvKVr3zlK1/5yle+8pWvfOUrX/nKV77yla985Stf+cpXvvKVr3zlK1/5yle+8hWA/wfdmhmZdymm9wAAMhBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+Cjx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDQuMi4yLWMwNjMgNTMuMzUxNzM1LCAyMDA4LzA3LzIyLTE4OjExOjEyICAgICAgICAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iPgogICAgICAgICA8eG1wOkNyZWF0b3JUb29sPkFkb2JlIEZpcmV3b3JrcyBDUzQ8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHhtcDpDcmVhdGVEYXRlPjIwMTktMDItMjBUMTc6NTA6NTFaPC94bXA6Q3JlYXRlRGF0ZT4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMTktMDMtMjVUMjI6MTY6NTlaPC94bXA6TW9kaWZ5RGF0ZT4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyI+CiAgICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2UvcG5nPC9kYzpmb3JtYXQ+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8+5XEV6QAAAeBJREFUOI2l1E9oz3Ecx/HHb5blhHZw2fwdsogcSLmg/DlJojgQze99QNbUcuGAUm6O75aDE1KKOImzknI0WrZi1mi18v/g5/D7bv22tv02e1++9f68vs/P69Pn9f6UKpWKmSoiFuAlRjJz34xiNNQTYE/xHY2I3fXEjXXcNeIYrqGEM3gxH4db0JaZj/EcrRHRPh/gCfRAZn7DXVyMiNKcgRGxCWvwoKbdg71one6/UqVSEREtWIGNWIcNBexKZt6ftNEFHMI7DOAT3uMDhkvlcnkEfRjEW3zB60Lcn5l/p3C/CquxFi1YWRhYXCqXy/eK3a5n5p/pjlKvIuIydjTiFJ6iEzf/A7QQ3YXb0w2Z+RPH0RYRXUX25lLnsAudmTnUAJk5hKs4iEtzcHcSO3EkM0eoiU1mfsRhbI6I/bOAHSjcdY3BJgAL6Ff0onkWBpvxJjP7a5tTBbu9gNarPiyZ3JwKuFQ1j/VqAMuK5228JtxoRCzHaDG3Y71tOIsfuIXezKxk5mBELFI9+vCUQNX0D9fAz6uO5BM04RkeRsSNIhmfVadkHFiqfbEjokN1lL6rRugRbo/dYkQ0qb6NW4u19XiVmXemc9iGjkJ8NDMHaxcz8ze6I6KtcL8dv2o1/wDd4qROmmHSqgAAAABJRU5ErkJggg==`);

		attribute("value","0");
		attribute("disabled",undefined);

		property("value",0);

		bind("@value",".",".value",(value)=>{
			value = parseInt(value);
			if (!value || isNaN(value)) value = 0;
			return value;
		});

		onProperty("value",(name,value,element,content)=>{
			update(element,content);
		});

		onEventAt("div.star","click",(event,selected,element,content)=>{
			if (element.hasAttribute("disabled")) {
				event.stopPropagation();
				event.preventDefault();
				return;
			}

			let value = [...content.querySelectorAll(".stars > div.star")].indexOf(selected)+1;
			if (element.hasAttribute("value") && parseInt(element.getAttribute("value"))===value) value = 0;

			element.setAttribute("value",value);
		});

		const update = (element,content)=>{
			let value = element.value;

			content.querySelectorAll(".stars > div.star").forEach((e,i)=>{
				e.removeAttribute("selected");
				if (value>i) e.setAttribute("selected","");
			});
		};
	});

}());
