<?php
/**
 * AVOLUTIONS
 *
 * Just another open source PHP framework.
 *
 * @copyright   Copyright (c) 2019 - 2021 AVOLUTIONS
 * @license     MIT License (https://avolutions.org/license)
 * @link        https://avolutions.org
 */

namespace Avolutions\Routing;

use Avolutions\Collection\CollectionInterface;
use Avolutions\Collection\CollectionTrait;

/**
 * RouteCollection class
 *
 * The RouteCollection contains all registered routes (Route objects).
 * The Router class will search in the RouteCollection for a matching route
 * for the Request.
 *
 * @author  Alexander Vogt <alexander.vogt@avolutions.org>
 * @since   0.1.0
 */
class RouteCollection implements CollectionInterface
{
    use CollectionTrait;

    /**
     * addRoute
     *
     * Adds a given Route object to the RouteCollection.
     *
     * @param Route $Route A Route object to add to the collection
     */
    public function addRoute(Route $Route)
    {
        $this->items[] = $Route;
    }

    /**
     * getAllByMethod
     *
     * Returns an array with all Routes of the RouteCollection filtered by the method.
     *
     * @param string $method Name of the method (GET|POST)
     *
     * @return array An array with all Routes of the RouteCollection filtered by the method
     */
    public function getAllByMethod(string $method): array
    {
        return array_values(
            array_filter(
                $this->items,
                function ($Route) use ($method) {
                    return $Route->method == $method;
                }
            )
        );
    }
}