# Contributing Guidelines for SearchTLD

## Introduction

Thank you for considering contributing to SearchTLD! These guidelines are designed to make the contribution process easy and effective for everyone involved.
Following these guidelines helps ensure a smooth collaboration and a better understanding of how to contribute to the project.

## Code of Conduct

Please make sure to adhere to the project's [Code of Conduct](https://github.com/avitld/SearchTLD/blob/main/CODE_OF_CONDUCT.md).
We value inclusivity and respect for all contributors.
Harassment and offensive behavior are not tolerated within our community.

## Getting Started

1. Familiarize yourself with the project's goals and objectives by reading the documentation and the README file.
2. Make sure that your contributions align with the project's vision and scope.

## How to Contribute

1. Fork the repository and create a new branch for your feature or bug fix.
2. Ensure your code is well-structured, easy to understand, and follows the coding style and guidelines of the project.
3. Clearly state the purpose of your changes in the commit message.
4. Make sure your code is thoroughly tested, and new tests are added for any new features.
5. Update relevant documentation, including README files or any other necessary documentation, to reflect your changes.

## Pull Requests

1. All contributions must be submitted via pull requests.
2. Provide a clear and concise description of the changes made in your pull request.
3. Ensure that your pull request can be easily merged without conflicts.
4. Respond to any feedback or comments promptly and make the necessary changes as requested.

## Licensing

1. All contributions must be compliant with the AGPL license.
2. Make sure you understand the implications of the AGPL license before contributing.

## Communication

1. Join the official communication channels for the project, such as the chat rooms available in Matrix and IRC chats.
2. Engage in discussions and provide constructive feedback on other contributors' ideas and suggestions.
3. Seek help from other contributors when needed.

## Issue Reporting

1. Report any issues or bugs through the issue tracker on the project's repository.
2. Clearly describe the problem and provide steps to reproduce it.

## Recognition

We appreciate all contributions to SearchTLD. All contributors will be recognized and acknowledged for their valuable input in the project.

These guidelines are subject to change, so please check back regularly for any updates. Thank you for your interest in contributing to SearchTLD!
