# Understanding Access Tokens and Refresh Tokens

Access tokens and refresh tokens play a pivotal role in securing access to resources and ensuring a seamless user experience. In this article, we'll delve into these two tokens, their significance, and the claims they provide.

## Access Tokens

### What is an Access Token?

Access tokens are short-lived, temporary credentials that grant access to specific resources or services within an application. These tokens are issued by AuthCompanion to ensure that users or applications have the required permissions to access protected resources/APIs.

### Claims in an Access Token

An access token includes several claims, which are pieces of information that provide essential details about the token and the user it represents. AuthC generates the following claims in the access token:

- `userid`: A unique identifier for the user.
- `name`: The user's name.
- `email`: The user's email address.
- `scope`: The level of access or permissions granted by the token. A value of Admin means the access token is for the AuthC administrator.
- `metadata`: Public claims that can be set using the user's access token. These claims can provide additional information about the user or the application, and their content may vary based on the specific use case.
- `app`: A private claim that can be set in the user's JWT issued after login. This claim is changeable only using the admin access token and is used for specific application-related purposes.
- `iat` (issued at): The timestamp indicating when the token was issued.
- `exp` (expiration): The timestamp indicating when the token will expire.

Access tokens default to a one-hour expiration time.

Access tokens are short-lived, usually with a relatively short expiration time to enhance security. When a user or application presents an access token to access a protected resource, the system checks the claims to determine if the requested action is allowed. If the access token is valid and the claims permit the action, access is granted. The application will also verify the signature - JWTs are signed by AuthC to ensure their integrity and authenticity. The application uses the key generated by AuthC to verify the signature.

## Refresh Tokens

### What is a Refresh Token?

While access tokens are short-lived, refresh tokens serve a different purpose. A refresh token is a long-lived credential that is used to obtain a new access token without the need for the user to re-enter their credentials. Refresh tokens are a crucial component of token-based authentication systems, ensuring a seamless user experience.

### Claims in a Refresh Token

Refresh tokens also include claims, and AuthC generates the following list fo claims:

- `userid`: A unique identifier for the user.
- `name`: The user's name or identifier.
- `email`: The user's email address.
- `scope`: The level of access or permissions granted.
- `iat` (issued at): The timestamp indicating when the refresh token was issued.
- `exp` (expiration): The timestamp indicating when the refresh token will expire. Refresh tokens typically default to a seven-day expiration time.
- `jti` (JWT ID): A unique identifier for the refresh token.

When a user's access token expires, applications can present the refresh token to AuthC and obtain a new access token without going through the full authentication process again. This mechanism ensures user convenience while maintaining security.

## Token Expiration

Token expiration is a critical aspect of access and refresh tokens. Access tokens typically default to a one-hour expiration time to limit their usability, while refresh tokens default to a seven-day expiration time. These default values strike a balance between security and user experience. However, in practice, you can configure token expiration times based on your application's specific security and usability requirements.
