# Contributing

Thank you for considering a contribution to AuthCompanion! :clap: :tada:

## What You Should Know

AuthCompanion is written in JavaScript using the
[Nodejs](https://nodejs.org/en/) runtime and the
[Fastify](https://www.fastify.io/) web framework. Fastify's
[plugin architecture](https://www.fastify.io/docs/latest/Reference/Plugins/) is
the best way to extend the AuthC server with your specific use cases.

::: tip Learn How To Setup A Development Environment:
[Getting Started >](../guide/gettingstarted.md)
:::

## Submitting PRs

We :heart: pull requests on Github and we're continually working to make it as
easy as possible for people to contribute to AuthC.

We prefer small pull requests with minimal code changes. The smaller they are
the easier they are to review and merge. A core team member will pick up your PR
and review it as soon as they can. They may ask for changes or reject your pull
request. This is not a reflection of you as an engineer or a person. Please
accept feedback graciously as we will also try to be sensitive when providing
it.

Although we generally accept PRs, they can be rejected for many reasons. We will
be as transparent as possible but it may simply be that you do not have the same
context, historical knowledge or information regarding the article roadmap that
the maintainers have. We value the time you take to put together any
contributions so we pledge to always be respectful of that time and will try to
be as open as possible so that you don't waste it. Be sure to submit an issue
with a feature request before making a PR so we can assist where we can.

## Conventional Commits

We use the
[Conventional Commits specification](https://www.conventionalcommits.org/en/v1.0.0/) -
a lightweight convention on top of commit messages. It provides an easy set of
rules for creating an explicit commit history; which makes it easier to write
automated tools on top of. This convention dovetails with
[SemVer](https://semver.org/), by describing the features, fixes, and breaking
changes made in commit messages.
