# HITRUST Threat Catalogue


| ID    | Type                        | Category           | Sub-Category         | Threat                                                       | Description                                                  |
| ----- | --------------------------- | ------------------ | -------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
|       | **Logical Threats**         | **Intentional**    | **Conflict**         |                                                              | Struggle  resulting from incompatible or opposing needs, drives, wishes, or external or  internal demands. |
| LIC1  | Logical  Threats            | Intentional        | Conflict             | Sabotage                                                     | Deliberate  actions aimed to cause disruption or damage to information and/or IT assets  for financial or personal gain. |
| LIC2  | Logical  Threats            | Intentional        | Conflict             | Terrorism                                                    | The  use of violence as a means to create terror among masses of people; or fear  to achieve a financial, political, religious, or ideological aim. |
| LIC3  | Logical  Threats            | Intentional        | Conflict             | Vandalism                                                    | Deliberate  destruction or damage to information and/or IT assets, but not for personal  gain. |
| LIC4  | Logical  Threats            | Intentional        | Conflict             | Warfare                                                      | Damage  to assets, facilities, and employees due to war or armed conflict. |
|       | **Logical  Threats**        | **Intentional**    | **Misappropriation** |                                                              | **Dishonestly  or unfairly taking for one's own use.**       |
| LIM1  | Logical  Threats            | Intentional        | Misappropriation     | Embezzlement                                                 | To  appropriate something, such as property, entrusted to one's care fraudulently  to one's own use. A form of theft through fraud. |
| LIM2  | Logical  Threats            | Intentional        | Misappropriation     | Extortion                                                    | The  act of obtaining money, property, or services from an organization through  coercion. A form of theft through use of force or intimidation to obtain  compliance. |
| LIM3  | Logical  Threats            | Intentional        | Misappropriation     | Fraud                                                        | Deliberate  deception to secure unfair or unlawful gain, or to deprive a victim of a  legal right. |
| LIM4  | Logical  Threats            | Intentional        | Misappropriation     | Theft                                                        | The  act of logically stealing and/or removing property with intent to deprive the  rightful owner of it. |
|       | **Logical  Threats**        | **Intentional**    | **Nefarious**        |                                                              | **Flagrant  breaching of time-honored laws and traditions of conduct.** |
| LIN1  | Logical  Threats            | Intentional        | Nefarious            | Abuse  of Authorizations                                     | Using  authorized access to perform illegitimate actions.    |
| LIN2  | Logical  Threats            | Intentional        | Nefarious            | Address  Space Hijacking                                     | The  illegitimate takeover of groups of IP addresses.        |
| LIN3  | Logical  Threats            | Intentional        | Nefarious            | Alteration  of Software                                      | Unauthorized  modifications to code or configuration data, attacking its integrity. |
| LIN4  | Logical  Threats            | Intentional        | Nefarious            | Anonymous  Proxies                                           | Access  of websites through chains of HTTP proxies (obfuscation), bypassing the  security mechanism(s). |
| LIN5  | Logical  Threats            | Intentional        | Nefarious            | Autonomous  System Hijacking                                 | Overtaking,  by the attacker, the ownership of a whole autonomous system and its prefixes,  despite origin validation. |
| LIN6  | Logical  Threats            | Intentional        | Nefarious            | Brute  Force                                                 | Unauthorized  access via systematically checking all possible keys or passwords until the  correct one is found. |
| LIN7  | Logical  Threats            | Intentional        | Nefarious            | Code  Injections                                             | Exploiting  bugs, design flaws, or configuration oversights in an operating system or  software application to gain elevated access to resources. |
| LIN8  | Logical  Threats            | Intentional        | Nefarious            | Command  Injection                                           | Execution  of arbitrary commands on the host operating system via a vulnerable  application. This attack differs from Code Injection, in that code injection  allows the attacker to add their own code that is then executed by the  application. In Command Injection, the attacker extends the default  functionality of the application, which executes system commands, without the  necessity of injecting code. Also known as "Remote Command  Execution." |
| LIN9  | Logical  Threats            | Intentional        | Nefarious            | Compromised  Credentials                                     | An  account/ID/username has been used or accessed by an unauthorized means. |
| LIN10 | Logical  Threats            | Intentional        | Nefarious            | Denial  of Service                                           | Service  unavailability due to a massive number of requests for services from a single  point. |
| LIN11 | Logical  Threats            | Intentional        | Nefarious            | Distributed  Denial of Service                               | Service  unavailability due to a massive number of requests for access to network  services from multiple malicious clients. |
| LIN12 | Logical  Threats            | Intentional        | Nefarious            | DNS  Spoofing                                                | Domain  name server cache poisoning or spoofing to divert traffic to malicious  servers. |
| LIN13 | Logical  Threats            | Intentional        | Nefarious            | Drive  By Download                                           | A  compromised website that has a user unintentionally download malware. |
| LIN14 | Logical  Threats            | Intentional        | Nefarious            | Elevated  Privileges                                         | Roles  or permissions with more than the normal level of access that, if  compromised, could allow a person to exploit the systems for personal gain or  illicit purpose. |
| LIN15 | Logical  Threats            | Intentional        | Nefarious            | Emission  Attacks                                            | Spying  on information through capturing emanations from operational equipment. |
| LIN16 | Logical  Threats            | Intentional        | Nefarious            | HTML  Script Injection                                       | A  type of injection in which malicious scripts are injected into otherwise  benign and trusted websites. |
| LIN17 | Logical  Threats            | Intentional        | Nefarious            | Information  Sharing                                         | The  deliberate sharing of information with unauthorized entities, such as  emailing sensitive information or file transfers. |
| LIN18 | Logical  Threats            | Intentional        | Nefarious            | IP  Spoofing                                                 | IP  spoofing is a method of attack under which incorrect IP addresses are used to  disguise the attackers’ identity to the system being attacked. |
| LIN19 | Logical  Threats            | Intentional        | Nefarious            | LDAP  Injection                                              | To  exploit web-based applications that construct LDAP statements based on user  input. |
| LIN20 | Logical  Threats            | Intentional        | Nefarious            | MAC  Spoofing                                                | An  attacker can change the Media Access Control (MAC) address of their device  and send Ethernet frames in the network segment with a different ID, which  can result in the possible circumvention of security mechanisms which are  based solely on the use of a MAC address. |
| LIN21 | Logical  Threats            | Intentional        | Nefarious            | Malicious  Code Execution                                    | Injection  of malicious code to extend the functionality of an application or  information system without having to execute commands. |
| LIN22 | Logical  Threats            | Intentional        | Nefarious            | Man  in the Middle                                           | A  type of eavesdropping attack that occurs when a malicious actor inserts  himself as a relay/proxy into a communication session between people or  systems. |
| LIN23 | Logical  Threats            | Intentional        | Nefarious            | Manipulation  of an Encryption Module                        | Modification  of an encryption module in order to read secret keys, change keys, or change  security parameters. |
| LIN24 | Logical  Threats            | Intentional        | Nefarious            | Manipulation  of Data                                        | The  modification of data with the intent to cause loss of integrity. |
| LIN25 | Logical  Threats            | Intentional        | Nefarious            | Masquerade/Pretexting                                        | Lying  or deceiving to pretend to be someone one is not.     |
| LIN26 | Logical  Threats            | Intentional        | Nefarious            | Message  Replay                                              | Threat  in which a valid data transmission is maliciously or fraudulently repeated or  delayed. |
| LIN27 | Logical  Threats            | Intentional        | Nefarious            | Misuse  of Audit Tools                                       | The  malicious use of network scanning tools to discover open and possibly unused  ports, protocols, and services as well as vulnerabilities. |
| LIN28 | Logical  Threats            | Intentional        | Nefarious            | Network  Intrusion                                           | Unauthorized  access to a network.                           |
| LIN29 | Logical  Threats            | Intentional        | Nefarious            | Network  Sniffing                                            | Identifying  information about a network to find security weaknesses. |
| LIN30 | Logical  Threats            | Intentional        | Nefarious            | Phishing                                                     | An  email fraud method in which the perpetrator sends out legitimate-looking  emails in an attempt to gather personal and financial information from  recipients. Typically, the messages appear to come from well-known and  trustworthy websites. |
| LIN31 | Logical  Threats            | Intentional        | Nefarious            | Quid  Pro Quo                                                | The  attacker promises to provide a benefit or service in the return of vital  access or details. |
| LIN32 | Logical  Threats            | Intentional        | Nefarious            | Ransomware                                                   | Infection  of a computer system or device by malware that restricts access to the system  and information while demanding that the user pays a ransom to remove the  restriction. |
| LIN33 | Logical  Threats            | Intentional        | Nefarious            | Remote  Access Trojan (RAT)                                  | Remote  administration capabilities, allowing an attacker to control the victim's  computer. |
| LIN34 | Logical  Threats            | Intentional        | Nefarious            | Repudiation  of Actions                                      | Intentional  data manipulation to repudiate action.          |
| LIN35 | Logical  Threats            | Intentional        | Nefarious            | Reverse  Engineering (RE)                                    | The  process by which a man-made object is deconstructed to reveal its design,  architecture, or to extract knowledge from the object. |
| LIN36 | Logical  Threats            | Intentional        | Nefarious            | Rogue  Access Points                                         | Unauthorized  access via unmanaged access points to an organization's managed network. |
| LIN37 | Logical  Threats            | Intentional        | Nefarious            | Rogue  Certificates                                          | Use  of rogue certificates that are valid certificates, by a legitimate  certificate authority, which are untrustworthy. |
| LIN38 | Logical  Threats            | Intentional        | Nefarious            | Rogue  Security Software                                     | Malicious  software that misleads users about their computer's security in order to  manipulate them. |
| LIN39 | Logical  Threats            | Intentional        | Nefarious            | Rootkits                                                     | A  set of software tools that enable an unauthorized user to gain control of a  computer system without being detected. |
| LIN40 | Logical  Threats            | Intentional        | Nefarious            | Routing  Table Manipulation                                  | Routing  network packets to IP addresses not intended by sender via unauthorized  manipulation of routing table. |
| LIN41 | Logical  Threats            | Intentional        | Nefarious            | Search  Engine Poisoning                                     | Deliberate  manipulation of search engine indexes to direct a user to malicious content  on falsified sites. |
| LIN42 | Logical  Threats            | Intentional        | Nefarious            | Server-Side  Includes (SSI) Injection                        | Allows  the exploitation of a web application by injecting scripts into HTML pages or  executing arbitrary codes remotely. |
| LIN43 | Logical  Threats            | Intentional        | Nefarious            | SPAM                                                         | Receiving  unsolicited, undesired, or illegal email messages. |
| LIN44 | Logical  Threats            | Intentional        | Nefarious            | Spear  Phishing                                              | Phishing  while tailoring the email to a specific audience.  |
| LIN45 | Logical  Threats            | Intentional        | Nefarious            | Spyware                                                      | Software  that aims to gather information about a person or organization without their  knowledge. |
| LIN46 | Logical  Threats            | Intentional        | Nefarious            | SQL  Injection                                               | Takes  advantage of the syntax of SQL to inject commands that can read or modify a  database, or compromise the meaning of the original query. |
| LIN47 | Logical  Threats            | Intentional        | Nefarious            | Trojan                                                       | Any  malicious computer program which misleads users of its true intent. |
| LIN48 | Logical  Threats            | Intentional        | Nefarious            | Unacceptable  Use                                            | Not  abiding by the rules defined as acceptable by the governing or owning  entity. |
| LIN49 | Logical  Threats            | Intentional        | Nefarious            | Unauthorized  Access                                         | Attaining  logical access without permission or approval.    |
| LIN50 | Logical  Threats            | Intentional        | Nefarious            | Unauthorized  Encryption                                     | Use  of an unauthorized (insecure) encryption module that can lead to a false  sense of protection for the  data that the encryption was meant to provide. |
| LIN51 | Logical  Threats            | Intentional        | Nefarious            | Unauthorized  Software Installation                          | The  intentional installation of unmanaged or unauthorized software. |
| LIN52 | Logical  Threats            | Intentional        | Nefarious            | Virus                                                        | A  computer program that can copy itself and infect a computer without  permission or knowledge of the user. A virus might corrupt or delete data on  a computer, use email programs to spread itself to other computers, or even  erase everything on a hard disk. |
| LIN53 | Logical  Threats            | Intentional        | Nefarious            | Vishing                                                      | A  form of fraud using voice over internet protocol in which individuals are  tricked into revealing unauthorized access to sensitive information. |
| LIN54 | Logical  Threats            | Intentional        | Nefarious            | War  Driving                                                 | The  act of locating and possibly exploiting wireless networks. Example: Access  Point Mapping. |
| LIN55 | Logical  Threats            | Intentional        | Nefarious            | Watering  Holes                                              | Malware  residing on the websites which a group often uses.  |
| LIN56 | Logical  Threats            | Intentional        | Nefarious            | Web  Spoofing                                                | Web  spoofing occurs when an attacker forges an existing website (i.e., an  attacker designs a fake website in such a way that it looks like the website  of a known organization). The attacker attempts to draw users to the website  with the objective of launching further attacks. |
| LIN57 | Logical  Threats            | Intentional        | Nefarious            | Whaling                                                      | A  form of spear phishing that targets senior management, executives, or  prominent individuals in order to gain access to sensitive information. |
| LIN58 | Logical  Threats            | Intentional        | Nefarious            | Wire  Tapping                                                | The  surreptitious electronic monitoring of Internet-based communications. |
| LIN59 | Logical  Threats            | Intentional        | Nefarious            | Worms                                                        | Self-propagating,  standalone malicious software.            |
|       | **Logical  Threats**        | **Unintentional**  | **Failure**          |                                                              | **Unexpected  system degradation or failure.**               |
| LUF1  | Logical  Threats            | Unintentional      | Failure              | Third-Party  Services                                        | Failure  or disruption of third-party services required for proper operation of  information systems. Example: Resources or Supporting Systems. |
| LUF2  | Logical  Threats            | Unintentional      | Failure              | Database  Systems                                            | A  database failure that may result in systems or applications not being  available, which can have a significant impact on business operations,  resulting in financial loss or potential brand damage. |
| LUF3  | Logical  Threats            | Unintentional      | Failure              | Network  Bandwidth                                           | When  the bandwidth of the network is insufficient, the transmission rate in the  network (and eventually the availability in the network) will be severely  limited to the organization's users, resulting in potential business  disruptions. |
| LUF4  | Logical  Threats            | Unintentional      | Failure              | Network  Routing                                             | The  process of selecting a path for traffic in a network, or between or across  multiple networks. |
| LUF5  | Logical  Threats            | Unintentional      | Failure              | Software/Code                                                | The  failure of programs and other operations used by a computer. |
| LUF6  | Logical  Threats            | Unintentional      | Failure              | Storage                                                      | The  retention of retrievable data on a computer or other electronic system;  memory. |
| LUF7  | Logical  Threats            | Unintentional      | Failure              | Virtual  Parts & Components                                  | The  failure/malfunction of virtual parts and components of IT hardware (e.g.  motherboard, CPU, RAM, video card, hard drive, power supply). Failure of  Virtual IT. |
|       | **Logical  Threats**        | **Unintentional**  | **Human**            |                                                              | **Human  oriented errors or mistakes.**                      |
| LUH1  | Logical  Threats            | Unintentional      | Human                | Data  Sharing/Leakage                                        | Unintentional  distribution of covered information to an unauthorized entity by an employee  or employees. |
| LUH2  | Logical  Threats            | Unintentional      | Human                | Improper  Data Modification                                  | Changing  of data and records (information) stored in devices and storage media. |
| LUH3  | Logical  Threats            | Unintentional      | Human                | Misclassifying  of Data                                      | Inappropriate/inadequate  labeling or classifying of Data media. |
| LUH4  | Logical  Threats            | Unintentional      | Human                | Mishandling  of Passwords                                    | Unintentional  mishandling of passwords, leading to leakage of covered information. |
|       | **Logical  Threats**        | **Unintentional**  | **Misuse**           | ****                                                         | **Use  in the wrong way or for the wrong purpose.**          |
| LUM1  | Logical  Threats            | Unintentional      | Misuse               | Certificate  Integrity Loss                                  | Loss  of integrity of certificates used for authorization services. |
| LUM2  | Logical  Threats            | Unintentional      | Misuse               | Compromised  Credentials                                     | An  account/ID/username has been used or accessed by an unauthorized means. |
| LUM3  | Logical  Threats            | Unintentional      | Misuse               | Data  Remanence                                              | Storage  media that retains stored information in a retrievable/intact manner longer  than desired (failure to totally erase). |
| LUM4  | Logical  Threats            | Unintentional      | Misuse               | Data  Storage Media Loss                                     | The  loss of data via the loss of a data storage medium      |
| LUM5  | Logical  Threats            | Unintentional      | Misuse               | Database  Integrity Loss                                     | Loss  of the integrity or consistency of a database that may result in the data  being incorrect or in a corrupt state and, as a result, may not be accessed  or processed correctly. |
| LUM6  | Logical  Threats            | Unintentional      | Misuse               | Elevated  Privileges                                         | Roles  or permissions thaty, if misused, could allow a person to exploit the systems  for his or her own gain or purpose. |
| LUM7  | Logical  Threats            | Unintentional      | Misuse               | Improperly  Designing Information Systems                    | Loss  due to improper IT asset or business processes design (inadequate  specifications of IT products, inadequate usability, insecure interfaces,  policy/procedure flows, design errors, and changes). |
| LUM8  | Logical  Threats            | Unintentional      | Misuse               | Improperly  Designing Network Infrastructure                 | Depending  on the requirements defined by the organization, a poorly-planned network  infrastructure may impact the confidentiality of data and the integrity of  the network, which may lead to unauthorized disclosure of sensitive  information to unauthorized users. |
| LUM9  | Logical  Threats            | Unintentional      | Misuse               | Inappropriate/Inadequate  Key Management                     | Management  of cryptographic keys in a cryptosystem. This includes dealing with the  generation, exchange, storage, use, crypto shredding (destruction), and  replacement of keys. |
| LUM10 | Logical  Threats            | Unintentional      | Misuse               | Insufficiently  or Inadequately Following Release Procedures | Inadequate  testing of new systems may result in possible errors in the hardware or  software undetected, may remain undetected, or may result in significant  disruption to IT operations or systems. |
| LUM11 | Logical  Threats            | Unintentional      | Misuse               | Lack  of (or Insufficient) Logging                           | Lack  of or insufficient logging may prevent the organization from determining  whether security specifications were violated or whether attacks were  attempted. Additionally, organizations may not be able to assess whether  logged information can be used for error analysis in the event of damage, and  for determining the causes of the damge, or for integrity tests. |
| LUM12 | Logical  Threats            | Unintentional      | Misuse               | Loss  Due to Unauthorized Storage                            | Loss  of records by improper/unauthorized use of storage devices. |
| LUM13 | Logical  Threats            | Unintentional      | Misuse               | Misuse  of Audit Tools                                       | The  malicious use of network scanning tools to discover open and possibly unused  ports, protocols, and services, as well as vulnerabilities. |
| LUM14 | Logical  Threats            | Unintentional      | Misuse               | Mobile  Device Applications Data Leakage                     | Leaking  covered information as a result of using mobile device applications. |
| LUM15 | Logical  Threats            | Unintentional      | Misuse               | System  Configuration Errors                                 | Information  leak/sharing/damage caused by misuse of information assets (lack of awareness  of application features) or wrong/improper information assets configuration  or management. |
| LUM16 | Logical  Threats            | Unintentional      | Misuse               | Unacceptable  Use                                            | A  violation of the set of rules applied by senior management or the  asset/resource owner of a network, website, or service, that restrict the  ways in which the network, website, or system may be used and sets guidelines  as to how it should be used. |
| LUM17 | Logical  Threats            | Unintentional      | Misuse               | Unmanaged  Data                                              | Does not allow for prescription of  information protection.  |
| LUM18 | Logical  Threats            | Unintentional      | Misuse               | Web  Applications Data Leakage                               | Leakage  of covered information when using web applications. |
|       | **Organizational  Threats** | **Compliance**     | **Contractual**      |                                                              | **Entities  or individuals seeking money or another specific performance rather than  criminal sanctions due to non-compliance of a legal contract.** |
| OCC1  | Organizational              | Compliance         | Contractual          | Civil                                                        | The  process of resolving a legal dispute between two or more parties (individuals  or business entities) who seek compensation for damages incurred or specific  performances that were not delivered. |
|       | **Organizational  Threats** | **Compliance**     | **Regulatory**       |                                                              | **Laws  that govern the conduct of an entity, individual, or organization and often  include penalties for violations.** |
| OCR1  | Organizational              | Compliance         | Regulatory           | Administrative                                               | Specifically  deals with the administrative agency's decision-making capabilities, as they  carry out laws passed by state and federal legislatures. Differs from regular  civil and criminal courts, and their authority is limited to making  administrative decisions. |
| OCR2  | Organizational              | Compliance         | Regulatory           | Civil                                                        | The  process of resolving a legal dispute between two or more parties (individuals  or business entities) who seek compensation for damages incurred or specific  performances that were not delivered. |
| OCR3  | Organizational              | Compliance         | Regulatory           | Criminal                                                     | Going  to trial in a criminal court to either prosecute or defend oneself in a  criminal matter. |
|       | **Organizational  Threats** | **Compliance**     | **Statutory**        |                                                              | **Law  enacted by legislation to govern entities.**          |
| OCS1  | Organizational              | Compliance         | Statutory            | Civil                                                        | The  process of resolving a legal dispute between two or more parties (individuals  or business entities) who seek compensation for damages incurred or specific  performances that were not delivered. |
| OCS2  | Organizational              | Compliance         | Statutory            | Criminal                                                     | Going  to trial in a criminal court to either prosecute or defend oneself in a  criminal matter. |
|       | **Physical  Threats**       | **Force  Majeure** | **Climatological**   |                                                              | **A  major adverse event resulting from natural processes of the  climate/temperature (e.g., extreme temperature, drought).** |
| PFC1  | Physical  Threats           | Force  Majeure     |                      | Drought                                                      | Prolonged  period of abnormally low rainfall and a shortage of water, causing damage to  assets. |
|       | **Physical  Threats**       | **Force  Majeure** | **Environmental**    |                                                              | **Local  conditions relating to the natural world.**         |
| PFE1  | Physical  Threats           | Force  Majeure     | Environmental        | Humidity                                                     | Water  vapor in the air that can collect as condensation, causing water damage to  assets. |
| PFE2  | Physical  Threats           | Force  Majeure     | Environmental        | Contaminants                                                 | The  collection of tiny foreign particles that can have an adverse effect on  assets. |
| PFE3  | Physical  Threats           | Force  Majeure     | Environmental        | Corrosion                                                    | Chemical  (i.e., gaseous or liquid) contaminants, causing corrosion of assets. |
|       | P**hysical  Threats**       | **Force  Majeure** | **Geological**       |                                                              | **A major adverse event resulting from natural  processes of the Earth (e.g., earthquake).** |
| PFG1  | Physical  Threats           | Force  Majeure     | Geological           | Avalanche                                                    | A  mass of snow, ice, and rocks falling rapidly down a mountainside, damaging  structures or assets in its path. |
| PFG2  | Physical  Threats           | Force  Majeure     | Geological           | Earthquake                                                   | Sudden  movement of a block of the Earth’s crust along a geological fault and  associated ground shaking with the potential to damage assets. |
| PFG3  | Physical  Threats           | Force  Majeure     | Geological           | Landslide                                                    | The  sliding down of a mass of earth or rock from a mountain or cliff, damaging  structures or assets in its path. |
| PFG4  | Physical  Threats           | Force  Majeure     | Geological           | Sinkhole                                                     | A  large hole that suddenly appears in the ground when the surface of the ground  is no longer supported, causing damage to anything resting on that surface. |
| PFG5  | Physical  Threats           | Force  Majeure     | Geological           | Volcano                                                      | Damage  of assets caused by eruption and lava.               |
| PFG6  | Physical  Threats           | Force  Majeure     | Geological           | Wildfires                                                    | An  uncontrolled or non-prescribed combustion of burning vegetation in a natural  setting with the potential to damage or disrupt. |
|       | **Physical  Threats**       | **Force  Majeure** | **Hydrological**     |                                                              | **A major adverse event resulting from natural  processes of the water (e.g., flooding).** |
| PFH1  | Physical  Threats           | Force  Majeure     | Hydrological         | Erosion                                                      | Eroding  of a surface by water, causing damage to structures and assets on the  surface. |
| PFH2  | Physical  Threats           | Force  Majeure     | Hydrological         | Flood                                                        | An  overflowing of a large amount of water beyond its normal confines, especially  over what is normally dry land causing damage to assets in the flood path. |
| PFH3  | Physical  Threats           | Force  Majeure     | Hydrological         | Tsunami                                                      | Damage  from a long, high sea wave caused by a underwater earthquake, landslide, or  other disturbance. |
|       | **Physical  Threats**       | **Force  Majeure** | **Meteorological**   |                                                              | **A major adverse event resulting from natural  processes of the weather (e.g., tornado, hurricane).** |
| PFM1  | Physical  Threats           | Force  Majeure     | Meteorological       | Blizzard                                                     | Severe  snowstorm with high winds and low visibility that can cause damage or  accessibility issues. |
| PFM2  | Physical  Threats           | Force  Majeure     | Meteorological       | Cyclonic  Storms                                             | Rapid  circulation of air around a low pressure center with destructive surrounding  weather, causing damage and accessibility issues. |
| PFM3  | Physical  Threats           | Force  Majeure     | Meteorological       | Hailstorm                                                    | A  storm that produces hail which reaches the surface, causing damage. |
| PFM4  | Physical  Threats           | Force  Majeure     | Meteorological       | Heat  Waves                                                  | A  prolonged period of abnormally hot weather that can impact people and  electronic systems. |
| PFM5  | Physical  Threats           | Force  Majeure     | Meteorological       | Ice  Storm                                                   | A  storm of freezing rain which can damage assets.           |
| PFM6  | Physical  Threats           | Force  Majeure     | Meteorological       | Lightning                                                    | Damage  of assets caused by a lightning strike (electrical overvoltage). |
|       | **Physical  Threats**       | **Intentional**    | **Conflict**         |                                                              | **Struggle  resulting from incompatible or opposing needs, drives, wishes, or external or  internal demands.** |
| PIC1  | Physical  Threats           | Intentional        | Conflict             | Arson                                                        | Intentionally  setting fire to assets, causing damage.       |
| PIC2  | Physical  Threats           | Intentional        | Conflict             | Large  Events                                                | Disruption  leading to adverse operations (i.e., demonstrations, riots, strikes, and  protests). |
| PIC3  | Physical  Threats           | Intentional        | Conflict             | Sabotage                                                     | Deliberately  destroy, damage, or obstruct (something), especially for political or  military advantage. |
| PIC4  | Physical  Threats           | Intentional        | Conflict             | Terrorism                                                    | The  use of intentionally indiscriminate violence as a means to create terror  among masses of people; or fear to achieve a financial, political,  religiousy, or ideological aim through physical violence. |
| PIC5  | Physical  Threats           | Intentional        | Conflict             | Vandalism                                                    | Action  involving deliberate destruction of or damage to property. |
| PIC6  | Physical  Threats           | Intentional        | Conflict             | Warfare                                                      | Damage  to assets, facilities, and employees due to physical war or armed conflict  (e.g., bombing). |
|       | **Physical  Threats**       | **Intentional**    | **Misappropriation** |                                                              | **Dishonestly  or unfairly taking for one's own use.**       |
| PIM1  | Physical  Threats           | Intentional        | Misappropriation     | Embezzlement                                                 | To  appropriate something, such as property entrusted to one's care, fraudulently  to one's own use. A form of theft through fraud. |
| PIM2  | Physical  Threats           | Intentional        | Misappropriation     | Extortion                                                    | The  act of obtaining money, property, or services from an organization through  coercion. A form of theft through use of force or intimidation to obtain  compliance. |
| PIM3  | Physical  Threats           | Intentional        | Misappropriation     | Fraud                                                        | Deliberate  deception to secure unfair or unlawful gain, or to deprive a victim of a  legal right. A form of theft through deception. |
| PIM4  | Physical  Threats           | Intentional        | Misappropriation     | Theft                                                        | The  act of physically stealing, taking, and removing property with intent to  deprive the rightful owner of it. |
|       | **Physical  Threats**       | **Intentional**    | **Nefarious**        |                                                              | **Flagrant  breaching of time-honored laws and traditions of conduct.** |
| PIN1  | Physical  Threats           | Intentional        | Nefarious            | Abuse  of Authority                                          | An  employee that applies their authority incorrectly, or oversteps their level  of authority. |
| PIN2  | Physical  Threats           | Intentional        | Nefarious            | Dumpster  Diving                                             | Searching  through discarded assets with the intent of personal gain and/or damage. |
| PIN3  | Physical  Threats           | Intentional        | Nefarious            | Information  Sharing                                         | The  deliberate sharing of non-public information with unauthorized entities, such  as physically giving sensitive documents. |
| PIN4  | Physical  Threats           | Intentional        | Nefarious            | Manipulation  of Hardware                                    | Unauthorized  changes to hardware devices, such as removing memory or hard drive. |
| PIN5  | Physical  Threats           | Intentional        | Nefarious            | Masquerade/Pretexting                                        | Lying  or deceiving to pretend to be someone one is not.     |
| PIN6  | Physical  Threats           | Intentional        | Nefarious            | Quid  Pro Quo                                                | The  attacker promises to provide a benefit or service in the return of vital  access or details. |
| PIN7  | Physical  Threats           | Intentional        | Nefarious            | Reverse  Engineering (RE)                                    | The  process by which a man-made object is deconstructed to reveal its design,  architecture, or to extract knowledge from the object. |
| PIN8  | Physical  Threats           | Intentional        | Nefarious            | Rogue  Hardware                                              | Manipulation  due to unauthorized hardware.                  |
| PIN9  | Physical  Threats           | Intentional        | Nefarious            | Tailgating                                                   | Unauthorized  access by someone else's means of access at their time of entry. |
| PIN10 | Physical  Threats           | Intentional        | Nefarious            | Unacceptable  Use                                            | Not  abiding by the rules defined as acceptable by the governing or owning  entity. |
| PIN11 | Physical  Threats           | Intentional        | Nefarious            | Unauthorized  Access                                         | Attaining  physical access without permission or approval.   |
|       | **Physical  Threats**       | **Unintentional**  | **Failure**          |                                                              | **Unexpected  system degradation or failure.**               |
| PUF1  | Physical  Threats           | Unintentional      | Failure              | Third-Party  Services                                        | Failure  or disruption of third-party services required for proper operation of  information systems. Example: Supplies or resources. |
| PUF2  | Physical  Threats           | Unintentional      | Failure              | Cable                                                        | Failure  of communications links due to problems with cable networks (e.g., Copper  & Fiber). |
| PUF3  | Physical  Threats           | Unintentional      | Failure              | Cross-talk                                                   | A  special form of line impairment, caused by currents and voltages of signals  transmitted over adjacent lines. This may result in the disclosure of  sensitive information. |
| PUF4  | Physical  Threats           | Unintentional      | Failure              | Electric  Power                                              | Power  failure with the potential to cause asset damage or unavailability. |
| PUF5  | Physical  Threats           | Unintentional      | Failure              | Equipment  Fire                                              | Unexpected  combustion of electronic equipment.              |
| PUF6  | Physical  Threats           | Unintentional      | Failure              | Heating,  Ventilation, and Air Conditioning (HVAC)           | Failure  to maintain atmospheric conditions for assets.      |
| PUF7  | Physical  Threats           | Unintentional      | Failure              | IT  Hardware                                                 | Failure  or malfunction of parts and components of IT hardware (e.g., motherboard,  CPU, RAM, video card, hard drive, power supply). |
| PUF8  | Physical  Threats           | Unintentional      | Failure              | Plumbing                                                     | Failure  of facility plumbing, including gas and water systems. |
| PUF9  | Physical  Threats           | Unintentional      | Failure              | Voltage                                                      | Fluctuations  in the supply voltage that can result in malfunctions and damage to IT  systems. |
| PUF10 | Physical  Threats           | Unintentional      | Failure              | Wireless                                                     | Failure  of communications links due to problems with wireless networks (e.g., radio  and RF). |
|       | **Physical  Threats**       | **Unintentional**  | **Human**            |                                                              | **Human  oriented errors or mistakes.**                      |
| PUH1  | Physical  Threats           | Unintentional      | Human                | Absence  of Personnel                                        | Unavailability  of key personnel, their competencies/skills, and knowledge. |
| PUH2  | Physical  Threats           | Unintentional      | Human                | Accidental  Damage                                           | Sudden  damage as a result of an unexpected and non-deliberate action. |
| PUH3  | Physical  Threats           | Unintentional      | Human                | Accidental  Fire                                             | Fire  unintentionally set by a human.                        |
| PUH4  | Physical  Threats           | Unintentional      | Human                | Loss  of IT Assets                                           | Accidently  or unintentionally losing any physical IT asset. |
| PUH5  | Physical  Threats           | Unintentional      | Human                | Mishandling  of Passwords                                    | Unintentional mishandling of passwords,  leading to leakage of covered information. |
| PUH6  | Physical  Threats           | Unintentional      | Human                | Unintentional  Information Sharing                           | Accidental  verbal disclosure of sensitive information by unauthorized individuals  overhearing. |
|       | **Physical  Threats**       | **Unintentional**  | **Misuse**           |                                                              | **Use  in the wrong way or for the wrong purpose.**          |
| PUM1  | Physical  Threats           | Unintentional      | Misuse               | Configuration  Errors                                        | Loss  of information due to errors in installation or system configuration. |
| PUM2  | Physical  Threats           | Unintentional      | Misuse               | Improperly  Designing Information Systems                    | Loss  due to improper IT asset or business processes design (inadequate  specifications of IT products, inadequate usability, insecure interfaces,  policy/procedure flows, design errors, and changes). |
| PUM3  | Physical  Threats           | Unintentional      | Misuse               | Improperly  Designing Network Infrastructure                 | Depending  on the requirements defined by the organization, a poorly planned network  infrastructure may impact the confidentiality of data and the integrity of  the network, which may lead to unauthorized disclosure of sensitive  information to unauthorized users. |
| PUM4  | Physical  Threats           | Unintentional      | Misuse               | Manipulation  of Hardware                                    | Unauthorized  changes to hardware devices such as removing memory or hard drive. |
| PUM5  | Physical  Threats           | Unintentional      | Misuse               | Rogue  Hardware                                              | Manipulation  due to unauthorized hardware.                  |
| PUM6  | Physical  Threats           | Unintentional      | Misuse               | Tailgating                                                   | Unauthorized  access by convenience or courtesy.             |
| PUM7  | Physical  Threats           | Unintentional      | Misuse               | Unacceptable  Use                                            | A  set of rules applied by senior management and/or the owner of the equipment,  information, and etc. may be used and sets guidelines as to how it should be  used. |
