
[![Join the chat at https://gitter.im/Incident-Playbook/community](https://badges.gitter.im/Incident-Playbook/community.svg)](https://gitter.im/Incident-Playbook/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)


If you have an idea for the project please start a [discusssion.](https://github.com/austinsonger/Incident-Playbook/discussions/new)

![](https://i.imgur.com/DLj8Enw.png)

### PURPOSE OF PROJECT

That this project will be created by the SOC/Incident Response Community

- Develop a Catalog of Incident Response Playbook for every MITRE Technique (Keep in mind it won't work for some tactics). 
- Develop a Catalog of Incident Response Playbook for uncommon incidents.
- Develop JSON Setup for Playbooks 
- Develop a Catalog of Exercise Scenarios that can be used for training purposes.
- Develop a Catalog of tools used for Incident Response `[Plus Reviews for the different tools]`.
- Develop a Catalog of Incident Response Automations. 
- Develop a Catalog of Checklists `[For Before, During, After Incidents]`. 
- Develop a Catalog of Roles that a organization can use, to build their own program.
- Develop a Catalog of Event Codes and API Actions that you can/will see in a SIEM Detections.
<!-- - Develop a Card Game based on MITRE Attack and the IR phases that help resolve it. -->
- Develop a Battle Card Book, that can be reference for immediate help during a incident. 

###  MITRE ATTACK



#### Tactic

##### Intial Access

- [X] [Playbook: T1133 - Unauthorized VPN and VDI Access](/Playbooks/MITRE-ATTACK/Initial%20Access/T1133-Unauthorized-VPN-and-VDI-Access.md)
- [X] [Playbook: T1189 - Drive By Compromise](/Playbooks/MITRE-ATTACK/Initial%20Access/T1189-Drive-By-Compromise.md)
- [X] [Playbook: T1566 - Phishing](/Playbooks/MITRE-ATTACK/Initial%20Access/T1566-Phishing-(T1566.001-T1566.002-T1566.003).md)

##### Collection

- [X] [Playbook: T1114 - Cloud Email Compromise](/Playbooks/MITRE-ATTACK/Collection/T1114-Cloud-Email-Compromise.md)

##### Credential Access

- [ ] [Playbook: T1110.003 - Password Spraying](/Playbooks/MITRE-ATTACK/Credential%20Access/T1110.003-Password%20Spraying.md)

##### Defense Evasion

- [X] [Playbook: T1055 - Process Injection](/Playbooks/MITRE-ATTACK/Defense%20Evasion/T1055-Process-Injection.md)

##### Persistence

- [X] [Playbook: T1053 - Scheduled Task/Job](/Playbooks/MITRE-ATTACK/Persistence/T1053-Scheduled-Task-Job.md)

##### Exfiltration

- [X] [Playbook: T1052.001 - Exfiltration over USB](/Playbooks/MITRE-ATTACK/Exfiltration/T1052.001%20-%20Exfiltration%20over%20USB.md)

##### Impact

- [ ] [Playbook: T1485 - Data Destruction](/Playbooks/MITRE-ATTACK/Impact/T1485-Data-Destruction.md)
- [X] [Playbook: T1486 - Data Encrypted for Impact Ransomware](/Playbooks/MITRE-ATTACK/Impact/T1486-Data-Encrypted-for-Impact-Ransomware.md)
- [ ] [Playbook: T1489 - Service Stop](/Playbooks/MITRE-ATTACK/Impact/T1489-Service-Stop.md)
- [X] [Playbook: T1491.002 - External Defacement](/Playbooks/MITRE-ATTACK/Impact/T1491-Defacement-(T1491.001%2CT1491.002).md#playbook-external-defacement)



---------------------
**For every pull request submitted a issue must also be created.** 
- Please Read [Creating a New Playbook](https://github.com/austinsonger/Cyber-Incident-Response-Playbooks/wiki/Creating-a-New-Playbook);
- Check the list of [MITRE Techniques](https://github.com/austinsonger/Cyber-Incident-Response-Playbooks/wiki/MITRE-Techniques) to choose from and create a new issue;
- Or you can just look at the list of issues that are ready to be worked on.

## Immediate Goals/Projects
-  Figure out how to Integrate [Atomic Red Team](https://github.com/redcanaryco/atomic-red-team/)

## Wiki
- [Creating a Playbook](https://github.com/austinsonger/Incident-Playbook/wiki/Creating-a-New-Playbook)
- [Combining Techniques Into One Playbook](https://github.com/austinsonger/Incident-Playbook/wiki/What-do-if-you-think-combining-techniques-into-one-playbook)
- [Incident Response Phases](https://github.com/austinsonger/Incident-Playbook/wiki/Incident-Response-Phases)


## Contributors
> Planning on Adding Photos later
- [Dominik Sigl](https://github.com/sn0b4ll)

## Sponsors

|SPONSORS|
|---|
|   |
|   |
|   |



