| ID                                                         | Technique or Sub-technique Name                              | Description                                                  |
| ---------------------------------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [T1020](https://attack.mitre.org/techniques/T1020)         | [Automated Exfiltration](https://attack.mitre.org/techniques/T1020) | Adversaries may exfiltrate data, such as sensitive documents, through the use of automated processing after being gathered during Collection. |
| [T1020.001](https://attack.mitre.org/techniques/T1020/001) | [Traffic Duplication](https://attack.mitre.org/techniques/T1020/001) | Adversaries may leverage traffic mirroring in order to automate data exfiltration over compromised network infrastructure. Traffic mirroring is a native feature for some network devices and used for network analysis and may be configured to duplicate traffic and forward to one or more destinations for analysis by a network analyzer or other monitoring device. |
| [T1030](https://attack.mitre.org/techniques/T1030)         | [Data Transfer Size Limits](https://attack.mitre.org/techniques/T1030) | An adversary may exfiltrate data in fixed size chunks instead of whole files or limit packet sizes below certain thresholds. This approach may be used to avoid triggering network data transfer threshold alerts. |
| [T1048](https://attack.mitre.org/techniques/T1048)         | [Exfiltration Over Alternative Protocol](https://attack.mitre.org/techniques/T1048) | Adversaries may steal data by exfiltrating it over a different protocol than that of the existing command and control channel. The data may also be sent to an alternate network location from the main command and control server. |
| [T1048.001](https://attack.mitre.org/techniques/T1048/001) | [Exfiltration Over Symmetric Encrypted Non-C2 Protocol](https://attack.mitre.org/techniques/T1048/001) | Adversaries may steal data by exfiltrating it over a symmetrically encrypted network protocol other than that of the existing command and control channel. The data may also be sent to an alternate network location from the main co |
| [T1048.002](https://attack.mitre.org/techniques/T1048/002) | [Exfiltration Over Asymmetric Encrypted Non-C2 Protocol](https://attack.mitre.org/techniques/T1048/002) | Adversaries may steal data by exfiltrating it over an asymmetrically encrypted network protocol other than that of the existing command and control channel. The data may also be sent to an alternate network location from the main command and control server. |
| [T1048.003](https://attack.mitre.org/techniques/T1048/003) | [Exfiltration Over Unencrypted/Obfuscated Non-C2 Protocol](https://attack.mitre.org/techniques/T1048/003) | Adversaries may steal data by exfiltrating it over an un-encrypted network protocol other than that of the existing command and control channel. The data may also be sent to an alternate network location from the main command and control server. |
| [T1041](https://attack.mitre.org/techniques/T1041)         | [Exfiltration Over C2 Channel](https://attack.mitre.org/techniques/T1041) | Adversaries may steal data by exfiltrating it over an existing command and control channel. Stolen data is encoded into the normal communications channel using the same protocol as command and control communications. |
| [T1011](https://attack.mitre.org/techniques/T1011)         | [Exfiltration Over Other Network Medium](https://attack.mitre.org/techniques/T1011) | Adversaries may attempt to exfiltrate data over a different network medium than the command and control channel. If the command and control network is a wired Internet connection, the exfiltration may occur, for example, over a WiFi connection, modem, cellular data connection, Bluetooth, or another radio frequency (RF) channel. |
| [T1011.001](https://attack.mitre.org/techniques/T1011/001) | [Exfiltration Over Bluetooth](https://attack.mitre.org/techniques/T1011/001) | Adversaries may attempt to exfiltrate data over Bluetooth rather than the command and control channel. If the command and control network is a wired Internet connection, an attacker may opt to exfiltrate data using a Bluetooth communication channel. |
| [T1052](https://attack.mitre.org/techniques/T1052)         | [Exfiltration Over Physical Medium](https://attack.mitre.org/techniques/T1052) | Adversaries may attempt to exfiltrate data via a physical medium, such as a removable drive. In certain circumstances, such as an air-gapped network compromise, exfiltration could occur via a physical medium or device introduced by a user. Such media could be an external hard drive, USB drive, cellular phone, MP3 player, or other removable storage and processing device. The physical medium or device could be used as the final exfiltration point or to hop between otherwise disconnected systems. |
| [T1052.001](https://attack.mitre.org/techniques/T1052/001) | [Exfiltration over USB](https://attack.mitre.org/techniques/T1052/001) | Adversaries may attempt to exfiltrate data over a USB connected physical device. In certain circumstances, such as an air-gapped network compromise, exfiltration could occur via a USB device introduced by a user. The USB device could be used as the final exfiltration point or to hop between otherwise disconnected systems. |
| [T1567](https://attack.mitre.org/techniques/T1567)         | [Exfiltration Over Web Service](https://attack.mitre.org/techniques/T1567) | Adversaries may use an existing, legitimate external Web service to exfiltrate data rather than their primary command and control channel. Popular Web services acting as an exfiltration mechanism may give a significant amount of cover due to the likelihood that hosts within a network are already communicating with them prior to compromise. Firewall rules may also already exist to permit traffic to these services. |
| [T1567.001](https://attack.mitre.org/techniques/T1567/001) | [Exfiltration to Code Repository](https://attack.mitre.org/techniques/T1567/001) | Adversaries may exfiltrate data to a code repository rather than over their primary command and control channel. Code repositories are often accessible via an API (ex: https://api.github.com). Access to these APIs are often over HTTPS, which gives the adversary an additional level of protection. |
| [T1567.002](https://attack.mitre.org/techniques/T1567/002) | [Exfiltration to Cloud Storage](https://attack.mitre.org/techniques/T1567/002) | Adversaries may exfiltrate data to a cloud storage service rather than over their primary command and control channel. Cloud storage services allow for the storage, edit, and retrieval of data from a remote cloud storage server over the Internet. |
| [T1029](https://attack.mitre.org/techniques/T1029)         | [Scheduled Transfer](https://attack.mitre.org/techniques/T1029) | Adversaries may schedule data exfiltration to be performed only at certain times of day or at certain intervals. This could be done to blend traffic patterns with normal activity or availability. |
| [T1537](https://attack.mitre.org/techniques/T1537)         | [Transfer Data to Cloud Account](https://attack.mitre.org/techniques/T1537) | Adversaries may exfiltrate data by transferring the data, including backups of cloud environments, to another cloud account they control on the same service to avoid typical file transfers/downloads and network-based exfiltration detection. |

