# Incidents
- Adversary (Lookup)
- Affected Software (Lookup)
- Affected Systems (Lookup)
- Affected Users (Lookup)
- Attack Techniques (Lookup)
- Emails (Lookup)
- Related Incidents (Lookup)
- Events (Lookup)
- Mitigations (Lookup)
- Use Cases/Plays (Lookup)
- Work Log (Lookup)
- Resolutions (Lookup)
- Owner (Lookup)
- Date Activity Started
- Date Activity Stopped
- Date Client Notified
- Date Closed
- Closed By
- Date Reported
- Reported By
- Date Reviewed
- Reviewed by
- Date Last Updated
- Last updated by
- Date Created
- Created By
- Title
- Executive Summary
- Internal Comments
- Origination
  - Threat Hunting
  - SIEM Correlation
  - Alarm from EDR
  - Alarm from AV
  - Alarm from IDS/IPS
  - Reported by Internal User
  - Reported by Third Party
  - Reported by Adversary
  - Threat Hunting
  - Audit
- Origination Details
- External Related IDs
- Priority
  - Emergency
  - High
  - Medium
  - Low
- Outcome
  - True Positive
  - False Positive
  - Benign
  - Indeterminate
- Root Cause
  - Training/Awareness
  - Policy Violation
  - Missing Patch
  - Zero Day
  - Configuration Weakness
  - Power Failure
  - Hardware Failure
  - Software Failure
  - Sabotage
- Scope of Compromise
  - Initial Access
  - Execution
  - Persistence
  - Privilege Escalation
  - Defense Evasion
  - Credential Access
  - Discovery
  - Lateral Movement
  - Collection
  - Command and Control
  - Exfiltration
  - Impact
  - No Compromise
- Status
  - New
  - In Progress
  - Closed
  - Pending
  - On Hold
  - Cancelled
  - Duplicate
- Escalation Level
  - Level 1
  - Level 2
  - Level 3
  - External
- Attachments
- Change Log
- Containment Method(s) Taken
  - Isolation via Host Firewall
  - Isolation via Firewall Appliance
  - Isolation via EDR
  - Isolation via Physical Disconnect
  - Isolation via ISP
  - Account Disablement
  - System Disablement

# Adversary
- IP
- Hostname
- Domain Name
- Aliases
- Date Last Observed

# Affected Software
- Vendor
- Product
- Version
- Date Last Observed

# Affected Systems
- MAC(s)
- IP(s)
- Hostname
- User (Lookup)
- Location
- Operating System
- Operating System Version

# Affected Users
- Name
- Email
- Phone
- Username

# Attack Techniques
- ID
- Name
- URL

# Emails
- Subject
- Sender
- Recipients
- Body
- Attachments
- Date Sent
- Header

# Events
- Raw Message
- [Parsed fields as available]

# Use Cases/Plays
- Title
- Link

# Work Log
- Owner (Lookup)
- Date and Time of Work
- Title
- Details

# Mitigations
- Title
- Description

# Owner
- Username
- Full Name