# vue3-element-admin-ts

🎉 基于 Vite 3.0 + Vue 3.0 + Vue-Router 4.0 + Vuex 4.0 + element-plus + typescript 的后台管理系统

## 简介

[vue3-element-admin](https://au1996.github.io/vue3-element-admin-ts) 是一个后台前端解决方案，它基于 [vue3](https://v3.cn.vuejs.org/guide/migration/introduction.html) 和 [element-plus](https://element-plus.gitee.io/#/zh-CN)实现。它使用了最新的前端技术栈，vite + vue3 + typescript ，提供最基础的框架模型，可以帮助你快速搭建企业级中后台产品原型。 PS：我是参考 [@PanJiaChen](https://github.com/PanJiaChen) 开发维护的 [vue-element-admin](https://github.com/PanJiaChen/vue-element-admin)， 十分感谢大佬对开源社区做出的贡献 :)

- [在线预览](https://au1996.github.io/vue3-element-admin-ts)
- [国内访问](https://au1996.gitee.io/vue3-element-admin-ts)

## 前序准备

你需要在本地安装 [node](http://nodejs.org/) 和 [git](https://git-scm.com/)。本项目技术栈基于 [ES2015+](http://es6.ruanyifeng.com/)、[vue3](https://v3.cn.vuejs.org/)、[vuex](https://next.vuex.vuejs.org/)、[vue-router](https://next.router.vuejs.org/) 、[vite](https://cn.vitejs.dev/) 、[axios](https://github.com/axios/axios) 和 [element-plus](https://element-plus.gitee.io/#/zh-CN)，提前了解和学习这些知识会对使用本项目有很大的帮助。

## 开发

```bash
# 克隆项目
git clone https://github.com/au1996/vue3-element-admin-ts.git

# 进入项目目录
cd vue3-element-admin-ts

# 安装依赖
npm install

# 建议修改为 taobao 源解决下载速度慢的问题
npm config set registry https://registry.npm.taobao.org/

# 启动服务
npm run dev
```

## 发布

```bash
# 构建生产环境
npm run build
```

## 其它

```bash
# eslint代码格式检查
npm run lint:js

# stylelint代码样式检查
npm run lint:css
```

## 浏览器支持

本地开发推荐使用`Chrome`浏览器,在火狐浏览器进行开发相对卡顿。

支持现代浏览器, 不支持 IE

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt=" Edge" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>IE | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt=" Edge" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Safari |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                             not support                                                                                              |                                                                                            last 2 versions                                                                                             |                                                                                                  last 2 versions                                                                                                  |                                                                                                last 2 versions                                                                                                |                                                                                                last 2 versions                                                                                                |

更多浏览器可以查看 [Can I Use Es Module](https://caniuse.com/?search=ES%20Module)

[JavaScript 版本传送门](https://github.com/au1996/vue3-element-admin)

## License

[MIT](https://github.com/au1996/vue3-element-admin-ts/blob/master/LICENSE)

Copyright (c) 2021 雪月欧巴
