# My Web API Template

### Starter template for all sorts of REST APIs with ASP.NET Core

This is my opinionated, constantly work in progress, starter template, for building REST APIs.  

**This template is for you if** you just want to get started with coding, want a already thought out project structure, that is quite simple and fast to learn, and works on smaller and bigger projects just fine.

## Details

### Technologies, frameworks and libraries
- Programming language: C#
- Framework: ASP.NET Core 7 (always the latest version)
- Database: SQL Server (also possible to use other databases)
- ORM: Entity Framework
- Testing: XUnit, Moq & FluentAssertions
  
### Architecture, features and patterns
- [X] Single process application (monolithic)
- [X] Clean/Onion Architecture
- [X] Follows the most usual REST API principles
- [X] Code structure that handles the most typical use cases with scaling in mind
- [X] Swagger/OpenAPI with UI
- [X] Development/QA/Production configurations
- [X] Database seeding
- [X] Global error handling
- [X] Model mapping
- [X] Validations
- [X] Comprehensive tests (functional, integration and unit tests)
- [X] Logging
- [X] Repository pattern
- [X] Docker support
- [ ] ..and more in [backlog](https://github.com/attuo/MyWebAPITemplate/projects)

### Template folder structure

```
app                               -> App and related files
 ├─> src                          -> App source
 │   ├─> Web                      -> Entry point for API - runnable project
 │   │   ├─> Controllers          -> API endpoints
 │   │   ├─> Extensions           -> Extension methods
 │   │   ├─> Interfaces           -> Web project's interfaces
 │   │   ├─> Mappers              -> Model mappers
 │   │   ├─> Middlewares          -> Middlewares (e.g. global error handling)
 │   │   |─> Models               -> Models in and out of API
 │   │   ├─> Settings             -> Options pattern for App (e.g. connection strings)
 │   │   ├─> Validators           -> Model validation rules
 │   │   ├── Program.cs           -> START
 │   │   └── Startup.cs           -> START
 │   ├─> Core                     -> Holds business logic
 │   │   ├─> Dtos                 -> Data-transfer-object (used for business logic)
 │   │   ├─> Entities             -> Entity Framework entities for database 
 │   │   ├─> Interfaces           -> Core project's interfaces
 │   │   ├─> Mappers              -> Dto and Entity mappers
 │   │   ├─> Services             -> Business logic services
 │   └─> Infrastructure           -> Data access and external services 
 │       ├─> Database             -> Database access
 │       │   ├─> Configurations   -> Entity Framework table configurations
 │       │   ├─> Migrations       -> Entity Framework autogenerated migrations
 │       │   ├─> Repositories     -> Repository pattern
 │       │   ├── AppDbContext.cs  -> Base context
 │       │   ├── AppSeed.cs       -> Database seeding
 │       │   └── EfRepository.cs  -> Base repository
 │       └─> ExternalServices     -> Services that access external services (e.g. ext. email service)
 └─> tests                        -> App tests
     ├── FunctionalTests          -> Endpoint tests etc.
     │   ├─> Tests                -> All tests
     │   └─> Utils                -> Utility functions (e.g. test database setup)
     ├── IntegrationTests         -> Database tests etc.
     │   ├─> Tests                -> All tests
     │   ├─> Utils                -> Utilities functions (e.g. test database setup)
     ├── UnitTests                -> Application logic tests etc.  
     │   ├─> Tests                -> All tests
     │   ├─> Utils                -> Utility functions 
     └── Shared                   -> Model builders and other shared functions for tests
```


## Usage
### On Windows
1. Download latest .NET SDK (https://dotnet.microsoft.com/download)
2. When running **first time** - Initialize database
    * ```ps 
      dotnet tool install --global dotnet-ef
      dotnet ef database update -c ApplicationDbContext -p ./src/Infrastructure/Infrastructure.csproj -s ./src/Web/Web.csproj
      ```
3. Launch
    * Option 1. Launch on **Visual Studio** 
        1. Open with `MyWebAPITemplate.sln`
        2. Press `F5` or `Debug/Start Debugging`
    * Option 2. Launch on **CLI**
        1. ```ps 
           dotnet run -p ./src/Web/
           ```
4. Navigate to https://localhost:5001/swagger/index.html

### Cross-platform with Docker (in progress)
  1. Currently possible only with in-memory  

### New database migrations
When you need to create a new migration (when you change the database schema), then run this command to tell Entity Framework to handle the needed schema changes for database.
  ```ps
  dotnet ef migrations add NewMigrationNameHere --context ApplicationDbContext -p ./src/Infrastructure/Infrastructure.csproj -s ./src/Web/Web.csproj -o Database/Migrations
  ```

## Motivation 

This project started as my way to handle the information flow of everything that needs to be done when building APIs with single monolithic manner. There are so many things to remember and there are vast amount of choices to be made. Therefore, I made this template, for myself, to store all the practices that I have found practical and I hope this template might also help someone else to learn a thing or two.

In this template, I have collected my knowledge of API building in a practical format. The architectural preferences, library selections and other choices are made, based on best practices, popularity and my own opinionated preferences. The purpose of this template, is to provide a good basic example on how to build Rest APIs with ASP.NET that are scalable, easy to mantain and contain necessary configurations and other goodies. This template is inspired by [Microsoft eShopOnWeb reference application](https://github.com/dotnet-architecture/eShopOnWeb) and many others.

### Goals
- To improve the template every time I find something useful, or I come up with a new better way to handle some part of the program.
- To only use concepts or technologies that I have already used in some of my previous projects, so I know if those are worth it. This project is not for tinkering all the experimental stuff, there are other projects for that :) 
- To keep the structure simple, but not too simple. This project structure might seem a bit overkill for TODO app, but the structure is here to show one way to handle code structure on bigger projects. The code structure should be able to handle larger systems with larger amount of code and features.
- To keep the template as "monolithic", because I think this might be best way to start a new project. Read more [here](https://www.martinfowler.com/bliki/MonolithFirst.html)
- To be opinionated, but I always think  to be ready to change anything if there is better way of doing

## Contributing and license
This project is [MIT](https://choosealicense.com/licenses/mit/) licensed - So feel free to use it anyway you like. Suggestions and help are welcomed. 🙂

