import { createIcon } from '@chakra-ui/react'

export const AllPagesIcon = createIcon({
  displayName: 'AllPagesIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M5.27143 3.85714C5.27143 2.75257 6.16686 1.85714 7.27143 1.85714H9.89163C10.4522 1.85714 10.9871 2.09243 11.3659 2.50569L12.6029 3.85509C12.941 4.22395 13.1286 4.70615 13.1286 5.20654V10.1429C13.1286 11.2474 12.2331 12.1429 11.1286 12.1429H7.27143C6.16686 12.1429 5.27143 11.2474 5.27143 10.1429V3.85714ZM3 3.49999C3 3.22385 3.22386 2.99999 3.5 2.99999C3.77614 2.99999 4 3.22385 4 3.49999V10.5C4 10.7761 3.77614 11 3.5 11C3.22386 11 3 10.7761 3 10.5V3.49999ZM1.5 3.99999C1.22386 3.99999 1 4.22385 1 4.49999V9.49999C1 9.77613 1.22386 9.99999 1.5 9.99999C1.77614 9.99999 2 9.77613 2 9.49999V4.49999C2 4.22385 1.77614 3.99999 1.5 3.99999Z" fill="currentColor" /></>
  ),
});

export const ArchiveIcon = createIcon({
  displayName: 'ArchiveIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M1.84479 3.61578C1.84479 3.26726 2.12732 2.98473 2.47583 2.98473H11.5242C11.8727 2.98473 12.1552 3.26726 12.1552 3.61578V4.1813C12.1552 4.52981 11.8727 4.81234 11.5242 4.81234H10.295H3.70505H2.47583C2.12732 4.81234 1.84479 4.52981 1.84479 4.1813V3.61578ZM2.47583 1.98473C1.57503 1.98473 0.844788 2.71498 0.844788 3.61578V4.1813C0.844788 4.92029 1.33624 5.54449 2.01014 5.7449L2.45665 11.103C2.5271 11.9484 3.23378 12.5986 4.08206 12.5986H9.91795C10.7662 12.5986 11.4729 11.9484 11.5434 11.103L11.9899 5.7449C12.6638 5.54449 13.1552 4.92029 13.1552 4.1813V3.61578C13.1552 2.71498 12.425 1.98473 11.5242 1.98473H2.47583ZM3.4532 11.02L3.01923 5.81234H3.70505H10.295H10.9808L10.5468 11.02C10.5196 11.347 10.2461 11.5986 9.91795 11.5986H4.08206C3.75386 11.5986 3.48045 11.347 3.4532 11.02Z" fill="currentColor" /></>
  ),
});

export const InboxIcon = createIcon({
  displayName: 'InboxIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M3.72706 8.5H3V10C3 10.5523 3.44772 11 4 11H10C10.5523 11 11 10.5523 11 10V8.5H10.2729C10.2696 8.5 10.2665 8.50167 10.2646 8.50445L9.56446 9.5547C9.37899 9.8329 9.06676 10 8.73241 10H5.26759C4.93324 10 4.62101 9.8329 4.43554 9.5547L3.73538 8.50445C3.73352 8.50167 3.7304 8.5 3.72706 8.5ZM11 7.5H10.2729C9.93525 7.5 9.61989 7.66877 9.43257 7.94975L8.73241 9H5.26759L4.56743 7.94975C4.38011 7.66877 4.06475 7.5 3.72706 7.5H3V4C3 3.44772 3.44772 3 4 3H10C10.5523 3 11 3.44772 11 4V7.5ZM12 7.5V4C12 2.89543 11.1046 2 10 2H4C2.89543 2 2 2.89543 2 4V7.5V8V8.5V10C2 11.1046 2.89543 12 4 12H10C11.1046 12 12 11.1046 12 10V8.5V8V7.5Z" fill="currentColor" />
  ),
});

export const ArrowAngleUpLeftIcon = createIcon({
  displayName: 'ArrowAngleUpLeftIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M6.18689 1.97977C5.99162 1.78451 5.67504 1.78451 5.47978 1.97977L3.14645 4.31311C2.95118 4.50837 2.95118 4.82495 3.14645 5.02021L5.47978 7.35355C5.67504 7.54881 5.99162 7.54881 6.18689 7.35355C6.38215 7.15829 6.38215 6.8417 6.18689 6.64644L4.70711 5.16666H6.91667C8.29738 5.16666 9.41667 6.28595 9.41667 7.66666V11.6667C9.41667 11.9428 9.64052 12.1667 9.91667 12.1667C10.1928 12.1667 10.4167 11.9428 10.4167 11.6667V7.66666C10.4167 5.73366 8.84966 4.16666 6.91667 4.16666H4.70711L6.18689 2.68688C6.38215 2.49162 6.38215 2.17504 6.18689 1.97977Z" fill="currentColor" /></>
  ),
});

export const ArrowAngleUpRightIcon = createIcon({
  displayName: 'ArrowAngleUpRightIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M7.81312 1.97977C8.00839 1.78451 8.32497 1.78451 8.52023 1.97977L10.8536 4.31311C11.0488 4.50837 11.0488 4.82495 10.8536 5.02021L8.52023 7.35355C8.32497 7.54881 8.00839 7.54881 7.81312 7.35355C7.61786 7.15829 7.61786 6.8417 7.81312 6.64644L9.2929 5.16666H7.08334C5.70263 5.16666 4.58334 6.28595 4.58334 7.66666V11.6667C4.58334 11.9428 4.35949 12.1667 4.08334 12.1667C3.8072 12.1667 3.58334 11.9428 3.58334 11.6667V7.66666C3.58334 5.73366 5.15035 4.16666 7.08334 4.16666H9.2929L7.81312 2.68688C7.61786 2.49162 7.61786 2.17504 7.81312 1.97977Z" fill="currentColor" /></>
  ),
});

export const ArrowLeftIcon = createIcon({
  displayName: 'ArrowLeftIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M3.96311 3.84644C4.15837 3.65118 4.47495 3.65118 4.67022 3.84644C4.86548 4.04171 4.86548 4.35829 4.67022 4.55355L2.72377 6.5H11.9583C12.2345 6.5 12.4583 6.72385 12.4583 7C12.4583 7.27614 12.2345 7.5 11.9583 7.5H2.72377L4.67022 9.44644C4.86548 9.64171 4.86548 9.95829 4.67022 10.1536C4.47495 10.3488 4.15837 10.3488 3.96311 10.1536L1.16311 7.35355C0.967847 7.15829 0.967847 6.84171 1.16311 6.64644L3.96311 3.84644Z" fill="currentColor" /></>
  ),
});

export const ArrowLeftOnBoxIcon = createIcon({
  displayName: 'ArrowLeftOnBoxIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M7.91665 2.75H4.33331C3.78103 2.75 3.33331 3.19772 3.33331 3.75V10.25C3.33331 10.8023 3.78103 11.25 4.33331 11.25H7.91665C8.46893 11.25 8.91665 10.8023 8.91665 10.25V9.58317C8.94442 9.41787 8.94442 9.2488 8.91665 9.08349V8.5H9.91665V10.25C9.91665 11.3546 9.02122 12.25 7.91665 12.25H4.33331C3.22874 12.25 2.33331 11.3546 2.33331 10.25V3.75C2.33331 2.64543 3.22874 1.75 4.33331 1.75H7.91665C9.02121 1.75 9.91665 2.64543 9.91665 3.75V5.5H8.91665V4.91651C8.94442 4.7512 8.94442 4.58213 8.91665 4.41682V3.75C8.91665 3.19772 8.46893 2.75 7.91665 2.75ZM6.64643 4.89645C6.84169 4.70118 7.15827 4.70118 7.35353 4.89645C7.5488 5.09171 7.5488 5.40829 7.35353 5.60355L6.45709 6.5H12.1041C12.3803 6.5 12.6041 6.72386 12.6041 7C12.6041 7.27614 12.3803 7.5 12.1041 7.5H6.45709L7.35353 8.39645C7.5488 8.59171 7.5488 8.90829 7.35353 9.10355C7.15827 9.29882 6.84169 9.29882 6.64643 9.10355L4.89643 7.35355C4.70116 7.15829 4.70116 6.84171 4.89643 6.64645L6.64643 4.89645Z" fill="currentColor" /></>
  ),
});

export const ArrowLeftOnBoxFillIcon = createIcon({
  displayName: 'ArrowLeftOnBoxFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M1.45835 3.75C1.45835 2.64543 2.35379 1.75 3.45835 1.75H7.04169C8.14626 1.75 9.04169 2.64543 9.04169 3.75V6.5H11.2292C11.5053 6.5 11.7292 6.72386 11.7292 7C11.7292 7.27614 11.5053 7.5 11.2292 7.5H9.04169V10.25C9.04169 11.3546 8.14626 12.25 7.04169 12.25H3.45836C2.35379 12.25 1.45835 11.3546 1.45835 10.25V3.75ZM9.04169 7.5H5.58213L6.47857 8.39645C6.67384 8.59171 6.67384 8.90829 6.47857 9.10355C6.28331 9.29882 5.96673 9.29882 5.77147 9.10355L4.02147 7.35355C3.82621 7.15829 3.82621 6.84171 4.02147 6.64645L5.77147 4.89645C5.96673 4.70118 6.28331 4.70118 6.47857 4.89645C6.67384 5.09171 6.67384 5.40829 6.47857 5.60355L5.58213 6.5H9.04169V7.5Z" fill="currentColor" /></>
  ),
});

export const ArrowRightIcon = createIcon({
  displayName: 'ArrowRightIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M10.0369 3.84644C9.84161 3.65118 9.52503 3.65118 9.32977 3.84644C9.13451 4.04171 9.13451 4.35829 9.32977 4.55355L11.2762 6.5H2.04166C1.76551 6.5 1.54166 6.72385 1.54166 7C1.54166 7.27614 1.76551 7.5 2.04166 7.5H11.2762L9.32977 9.44644C9.13451 9.64171 9.13451 9.95829 9.32977 10.1536C9.52503 10.3488 9.84161 10.3488 10.0369 10.1536L12.8369 7.35355C13.0321 7.15829 13.0321 6.84171 12.8369 6.64644L10.0369 3.84644Z" fill="currentColor" /></>
  ),
});

export const ArrowRightOnBoxIcon = createIcon({
  displayName: 'ArrowRightOnBoxIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M6.08333 2.75H9.66667C10.219 2.75 10.6667 3.19772 10.6667 3.75V10.25C10.6667 10.8023 10.219 11.25 9.66667 11.25H6.08333C5.53105 11.25 5.08333 10.8023 5.08333 10.25V9.58317C5.05556 9.41787 5.05556 9.2488 5.08333 9.08349V8.5H4.08333V10.25C4.08333 11.3546 4.97876 12.25 6.08333 12.25H9.66667C10.7712 12.25 11.6667 11.3546 11.6667 10.25V3.75C11.6667 2.64543 10.7712 1.75 9.66667 1.75H6.08333C4.97877 1.75 4.08333 2.64543 4.08333 3.75V5.5H5.08333V4.91651C5.05556 4.7512 5.05556 4.58213 5.08333 4.41682V3.75C5.08333 3.19772 5.53105 2.75 6.08333 2.75ZM7.35355 4.89645C7.15829 4.70118 6.84171 4.70118 6.64645 4.89645C6.45118 5.09171 6.45118 5.40829 6.64645 5.60355L7.54289 6.5H1.89583C1.61969 6.5 1.39583 6.72386 1.39583 7C1.39583 7.27614 1.61969 7.5 1.89583 7.5H7.54289L6.64645 8.39645C6.45118 8.59171 6.45118 8.90829 6.64645 9.10355C6.84171 9.29882 7.15829 9.29882 7.35355 9.10355L9.10355 7.35355C9.29881 7.15829 9.29881 6.84171 9.10355 6.64645L7.35355 4.89645Z" fill="currentColor" /></>
  ),
});

export const ArrowRightOnBoxFillIcon = createIcon({
  displayName: 'ArrowRightOnBoxFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M11.6666 3.75C11.6666 2.64543 10.7712 1.75 9.66665 1.75H6.08331C4.97875 1.75 4.08331 2.64543 4.08331 3.75V6.5H1.89581C1.61967 6.5 1.39581 6.72386 1.39581 7C1.39581 7.27614 1.61967 7.5 1.89581 7.5H4.08331V10.25C4.08331 11.3546 4.97874 12.25 6.08331 12.25H9.66665C10.7712 12.25 11.6666 11.3546 11.6666 10.25V3.75ZM4.08331 7.5H7.54287L6.64643 8.39645C6.45116 8.59171 6.45116 8.90829 6.64643 9.10355C6.84169 9.29882 7.15827 9.29882 7.35353 9.10355L9.10353 7.35355C9.2988 7.15829 9.2988 6.84171 9.10353 6.64645L7.35353 4.89645C7.15827 4.70118 6.84169 4.70118 6.64643 4.89645C6.45116 5.09171 6.45116 5.40829 6.64643 5.60355L7.54287 6.5H4.08331V7.5Z" fill="currentColor" /></>
  ),
});

export const BellIcon = createIcon({
  displayName: 'BellIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M6.27488 2.70116L5.91481 2.84856C4.85925 3.28065 4.11861 4.31742 4.11861 5.5248V6.94792C4.11861 7.58361 3.91668 8.20287 3.54195 8.71637L2.49294 10.1539L11.5247 10.1539L10.4756 8.71622C10.1009 8.20272 9.89896 7.58345 9.89896 6.94776V5.5248C9.89896 4.31742 9.15832 3.28065 8.10276 2.84856L7.74269 2.70116L7.57691 2.34917C7.48297 2.1497 7.26934 2 7.00878 2C6.74822 2 6.5346 2.1497 6.44066 2.34917L6.27488 2.70116ZM11.233 11.1539H9.06479H4.9366H2.76839H2.49294C1.6749 11.1539 1.20294 10.2252 1.68516 9.56437L2.73417 8.12689C2.98399 7.78456 3.11861 7.37172 3.11861 6.94792V5.5248C3.11861 3.89755 4.11772 2.50365 5.53597 1.9231C5.7926 1.3782 6.35557 1 7.00878 1C7.662 1 8.22497 1.3782 8.4816 1.92309C9.89984 2.50365 10.899 3.89755 10.899 5.5248V6.94776C10.899 7.37156 11.0336 7.7844 11.2834 8.12673L12.3325 9.56437C12.8147 10.2252 12.3428 11.1539 11.5247 11.1539H11.233ZM8.99328 12.1539C9.0176 12.1287 9.04144 12.103 9.06479 12.0769H7.0007H4.9366C4.95995 12.103 4.98379 12.1287 5.00811 12.1539C5.51172 12.6755 6.21832 13 7.0007 13C7.78308 13 8.48968 12.6755 8.99328 12.1539Z" fill="currentColor" />
  ),
});

export const BellFillIcon = createIcon({
  displayName: 'BellFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M7.0088 1C6.30115 1 5.69127 1.40972 5.41326 2.00001C3.87682 2.62895 2.79444 4.139 2.79444 5.90186V7.49792C2.79444 7.92172 2.65982 8.33456 2.41 8.67689L1.14487 10.4105C0.662657 11.0713 1.13462 12 1.95265 12H12.0651C12.8831 12 13.3551 11.0713 12.8728 10.4105L11.6076 8.67672C11.3578 8.33438 11.2232 7.92154 11.2232 7.49775V5.90186C11.2232 4.139 10.1408 2.62895 8.60434 2.00001C8.32633 1.40972 7.71645 1 7.0088 1ZM7.00002 14C6.11152 14 5.31323 13.6137 4.76391 13H9.23613C8.68681 13.6137 7.88852 14 7.00002 14Z" fill="currentColor" /></>
  ),
});

export const BlockIcon = createIcon({
  displayName: 'BlockIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M11.4167 8.91667H2.58334C2.03106 8.91667 1.58334 8.46896 1.58334 7.91667V6.08334C1.58334 5.53105 2.03106 5.08334 2.58334 5.08334H11.4167C11.969 5.08334 12.4167 5.53105 12.4167 6.08334V7.91667C12.4167 8.46895 11.969 8.91667 11.4167 8.91667ZM0.583344 6.08334C0.583344 4.97877 1.47877 4.08334 2.58334 4.08334H11.4167C12.5212 4.08334 13.4167 4.97877 13.4167 6.08334V7.91667C13.4167 9.02124 12.5212 9.91667 11.4167 9.91667H2.58334C1.47877 9.91667 0.583344 9.02124 0.583344 7.91667V6.08334ZM3.50001 8.16667C4.14434 8.16667 4.66668 7.64433 4.66668 7C4.66668 6.35567 4.14434 5.83334 3.50001 5.83334C2.85568 5.83334 2.33334 6.35567 2.33334 7C2.33334 7.64433 2.85568 8.16667 3.50001 8.16667Z" fill="currentColor" /></>
  ),
});

export const TextIcon = createIcon({
  displayName: 'TextIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M2.33333 2.33333C2.01117 2.33333 1.75 2.5945 1.75 2.91666C1.75 3.23883 2.01117 3.49999 2.33333 3.49999H5.25V11.0833C5.25 11.4055 5.51117 11.6667 5.83333 11.6667C6.1555 11.6667 6.41667 11.4055 6.41667 11.0833V3.49999H9.33333C9.6555 3.49999 9.91667 3.23883 9.91667 2.91666C9.91667 2.5945 9.6555 2.33333 9.33333 2.33333H5.83333H2.33333ZM8.75 6.41666C8.75 6.0945 9.01117 5.83333 9.33333 5.83333H10V5.24999C10 4.97385 10.2239 4.74999 10.5 4.74999C10.7761 4.74999 11 4.97385 11 5.24999V5.83333H11.6667C11.9888 5.83333 12.25 6.0945 12.25 6.41666C12.25 6.73883 11.9888 6.99999 11.6667 6.99999H11V9.78461C11 10.2257 11.3576 10.5833 11.7987 10.5833H12C12.2761 10.5833 12.5 10.8072 12.5 11.0833C12.5 11.3595 12.2761 11.5833 12 11.5833H11.7987C10.8053 11.5833 10 10.778 10 9.78461V6.99999H9.33333C9.01117 6.99999 8.75 6.73883 8.75 6.41666Z" fill="currentColor" />
    </>
  ),
});

export const BlockAddIcon = createIcon({
  displayName: 'BlockAddIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M2.58334 8.91667H7.6618C7.61045 9.14455 7.58334 9.38161 7.58334 9.625C7.58334 9.72332 7.58777 9.82061 7.59642 9.91667H2.58334C1.47877 9.91667 0.583344 9.02124 0.583344 7.91667V6.08334C0.583344 4.97877 1.47877 4.08334 2.58334 4.08334H11.4167C12.5212 4.08334 13.4167 4.97877 13.4167 6.08334V7.77987C13.1534 7.40595 12.8122 7.09081 12.4167 6.85804V6.08334C12.4167 5.53105 11.969 5.08334 11.4167 5.08334H2.58334C2.03106 5.08334 1.58334 5.53105 1.58334 6.08334V7.91667C1.58334 8.46896 2.03106 8.91667 2.58334 8.91667ZM3.50001 8.16667C4.14434 8.16667 4.66668 7.64433 4.66668 7C4.66668 6.35567 4.14434 5.83334 3.50001 5.83334C2.85568 5.83334 2.33334 6.35567 2.33334 7C2.33334 7.64433 2.85568 8.16667 3.50001 8.16667ZM13.4167 9.625C13.4167 11.0747 12.2414 12.25 10.7917 12.25C9.34193 12.25 8.16668 11.0747 8.16668 9.625C8.16668 8.17525 9.34193 7 10.7917 7C12.2414 7 13.4167 8.17525 13.4167 9.625ZM10.5 8.16667V9.33334H9.33334V9.91667H10.5V11.0833H11.0833V9.91667H12.25V9.33334H11.0833V8.16667H10.5Z" fill="currentColor" /></>
  ),
});

export const BlockEmbedIcon = createIcon({
  displayName: 'BlockEmbedIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M3.05373 3.36836C1.71252 5.60371 1.71252 8.3963 3.05373 10.6316C3.14641 10.7861 3.14883 10.9785 3.06008 11.1352C2.97133 11.292 2.80512 11.3889 2.62498 11.3889C2.43955 11.3889 2.27769 11.2879 2.19137 11.138C0.665018 8.58734 0.666641 5.40319 2.19623 2.85387L3.05373 3.36836ZM8.02958 10.6316C9.37079 8.3963 9.37079 5.60371 8.02958 3.36836L8.88708 2.85387C10.4167 5.40319 10.4183 8.58735 8.89195 11.138C8.80562 11.2879 8.64376 11.3889 8.45833 11.3889C8.27819 11.3889 8.11198 11.292 8.02323 11.1352C7.93448 10.9785 7.93691 10.7861 8.02958 10.6316ZM10.9463 10.6316C12.2875 8.3963 12.2875 5.60371 10.9463 3.36836L11.8037 2.85387C13.3333 5.40319 13.335 8.58734 11.8086 11.138C11.7223 11.2879 11.5604 11.3889 11.375 11.3889C11.1949 11.3889 11.0287 11.292 10.9399 11.1352C10.8511 10.9785 10.8536 10.7861 10.9463 10.6316ZM5.97041 10.6316C4.6292 8.3963 4.6292 5.60371 5.97041 3.36836L5.11292 2.85387C3.58333 5.40319 3.5817 8.58735 5.10805 11.138C5.19438 11.2879 5.35623 11.3889 5.54167 11.3889C5.7218 11.3889 5.88801 11.292 5.97677 11.1352C6.06552 10.9785 6.06309 10.7861 5.97041 10.6316Z" fill="currentColor" /></>
  ),
});

export const BlockFillIcon = createIcon({
  displayName: 'BlockFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M2.58334 4.08334C1.47877 4.08334 0.583344 4.97877 0.583344 6.08334V7.91667C0.583344 9.02124 1.47877 9.91667 2.58334 9.91667H11.4167C12.5212 9.91667 13.4167 9.02124 13.4167 7.91667V6.08334C13.4167 4.97877 12.5212 4.08334 11.4167 4.08334H2.58334ZM3.50001 8.16667C4.14434 8.16667 4.66668 7.64433 4.66668 7C4.66668 6.35567 4.14434 5.83334 3.50001 5.83334C2.85568 5.83334 2.33334 6.35567 2.33334 7C2.33334 7.64433 2.85568 8.16667 3.50001 8.16667Z" fill="currentColor" /></>
  ),
});

export const BlockFillAddIcon = createIcon({
  displayName: 'BlockFillAddIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M2.58333 4.08333C1.47876 4.08333 0.583333 4.97877 0.583333 6.08333V7.91667C0.583333 9.02124 1.47876 9.91667 2.58333 9.91667H7.59641C7.58776 9.8206 7.58333 9.72332 7.58333 9.625C7.58333 7.85309 9.01975 6.41667 10.7917 6.41667C11.8768 6.41667 12.836 6.95534 13.4167 7.77987V6.08333C13.4167 4.97876 12.5212 4.08333 11.4167 4.08333H2.58333ZM3.5 8.16667C4.14433 8.16667 4.66667 7.64433 4.66667 7C4.66667 6.35567 4.14433 5.83333 3.5 5.83333C2.85567 5.83333 2.33333 6.35567 2.33333 7C2.33333 7.64433 2.85567 8.16667 3.5 8.16667ZM13.4167 9.625C13.4167 11.0747 12.2414 12.25 10.7917 12.25C9.34192 12.25 8.16667 11.0747 8.16667 9.625C8.16667 8.17525 9.34192 7 10.7917 7C12.2414 7 13.4167 8.17525 13.4167 9.625ZM10.5 8.16667V9.33333H9.33333V9.91667H10.5V11.0833H11.0833V9.91667H12.25V9.33333H11.0833V8.16667H10.5Z" fill="currentColor" /></>
  ),
});

export const BookmarkIcon = createIcon({
  displayName: 'BookmarkIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M9.75 2H4.25C4.11193 2 4 2.11193 4 2.25V11.4423L5.89779 9.3864C6.49174 8.74296 7.50826 8.74297 8.10221 9.38641L10 11.4424V2.25C10 2.11193 9.88807 2 9.75 2ZM4.25 1C3.55964 1 3 1.55964 3 2.25V12.7212C3 13.1763 3.55868 13.3948 3.8674 13.0603L6.6326 10.0647C6.83058 9.85021 7.16942 9.85021 7.3674 10.0647L10.1326 13.0603C10.4413 13.3948 11 13.1763 11 12.7212V2.25C11 1.55964 10.4404 1 9.75 1H4.25Z" fill="currentColor" /></>
  ),
});

export const BookmarkFillIcon = createIcon({
  displayName: 'BookmarkFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path d="M3 2.25C3 1.55964 3.55964 1 4.25 1H9.75C10.4404 1 11 1.55964 11 2.25V12.7212C11 13.1763 10.4413 13.3948 10.1326 13.0603L7.3674 10.0647C7.16942 9.85021 6.83058 9.85021 6.6326 10.0647L3.8674 13.0603C3.55868 13.3948 3 13.1763 3 12.7212V2.25Z" fill="currentColor" /></>
  ),
});

export const BulletIcon = createIcon({
  displayName: 'BulletIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path d="M7 8.75C7.9665 8.75 8.75 7.9665 8.75 7C8.75 6.0335 7.9665 5.25 7 5.25C6.0335 5.25 5.25 6.0335 5.25 7C5.25 7.9665 6.0335 8.75 7 8.75Z" fill="currentColor" /></>
  ),
});

export const CalendarIcon = createIcon({
  displayName: 'CalendarIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM3 5V10.5C3 10.7761 3.22386 11 3.5 11H10.5C10.7761 11 11 10.7761 11 10.5V5C11 4.44772 10.5523 4 10 4H4C3.44772 4 3 4.44772 3 5Z" fill="currentColor" /></>
  ),
});

export const CalendarBookmarkIcon = createIcon({
  displayName: 'CalendarBookmarkIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4 1.5C4 1.22386 4.22386 0.999998 4.5 0.999998C4.77614 0.999998 5 1.22386 5 1.5V2H9V1.5C9 1.22386 9.22386 0.999998 9.5 0.999998C9.77614 0.999998 10 1.22386 10 1.5V2H10.5C11.3284 2 12 2.67157 12 3.5V10.5C12 11.3284 11.3284 12 10.5 12H3.5C2.67157 12 2 11.3284 2 10.5V3.5C2 2.67157 2.67157 2 3.5 2H4V1.5ZM3 10.5V5C3 4.44772 3.44772 4 4 4H6.85103C6.72008 4.2453 6.64586 4.52544 6.64586 4.82292V6.30332C6.64586 7.19422 7.723 7.64039 8.35296 7.01042L8.45836 6.90503L8.56375 7.01042C9.19371 7.64039 10.2709 7.19422 10.2709 6.30332V4.82292C10.2709 4.52633 10.1971 4.24697 10.0669 4.0022C10.588 4.0366 11 4.47018 11 5V10.5C11 10.7761 10.7761 11 10.5 11H3.5C3.22386 11 3 10.7761 3 10.5ZM7.64586 4.82292C7.64586 4.40871 7.98164 4.07292 8.39586 4.07292H8.52086C8.93507 4.07292 9.27086 4.40871 9.27086 4.82292V6.30332L9.16546 6.19792C8.77494 5.8074 8.14177 5.8074 7.75125 6.19792L7.64586 6.30332V4.82292Z" fill="currentColor" /></>
  ),
});

export const CalendarBookmarkFillIcon = createIcon({
  displayName: 'CalendarBookmarkFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67158 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM8.39584 3.07292C7.42934 3.07292 6.64584 3.85642 6.64584 4.82292V6.30331C6.64584 7.19421 7.72298 7.64038 8.35294 7.01042L8.45834 6.90502L8.56373 7.01042C9.19369 7.64038 10.2708 7.19421 10.2708 6.30331V4.82292C10.2708 3.85642 9.48733 3.07292 8.52084 3.07292H8.39584ZM7.64584 4.82292C7.64584 4.4087 7.98162 4.07292 8.39584 4.07292H8.52084C8.93505 4.07292 9.27084 4.4087 9.27084 4.82292V6.30331L9.16544 6.19792C8.77492 5.80739 8.14175 5.80739 7.75123 6.19792L7.64584 6.30331V4.82292Z" fill="currentColor" /></>
  ),
});

export const CalendarCheckmarkIcon = createIcon({
  displayName: 'CalendarCheckmarkIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM3 5V10.5C3 10.7761 3.22386 11 3.5 11H10.5C10.7761 11 11 10.7761 11 10.5V5C11 4.44772 10.5523 4 10 4H4C3.44772 4 3 4.44772 3 5Z" fill="currentColor" /><path fillRule="evenodd" clipRule="evenodd" d="M9.35224 5.20533C9.538 5.001 9.85422 4.98594 10.0585 5.1717C10.2629 5.35745 10.2779 5.67367 10.0922 5.878L6.6894 9.62106C6.59464 9.7253 6.46031 9.78472 6.31943 9.78472C6.17856 9.78472 6.04423 9.7253 5.94946 9.62106L4.24808 7.74953C4.06232 7.5452 4.07738 7.22898 4.28171 7.04322C4.48604 6.85747 4.80226 6.87253 4.98802 7.07686L6.31943 8.54142L9.35224 5.20533Z" fill="currentColor" /></>
  ),
});

export const CalendarCheckmarkFillIcon = createIcon({
  displayName: 'CalendarCheckmarkFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM10.0586 5.1717C9.85423 4.98594 9.53801 5.001 9.35225 5.20533L6.31944 8.54142L4.98803 7.07686C4.80227 6.87253 4.48605 6.85747 4.28172 7.04322C4.07739 7.22898 4.06233 7.5452 4.24809 7.74953L5.94947 9.62106C6.04424 9.7253 6.17857 9.78472 6.31944 9.78472C6.46032 9.78472 6.59465 9.7253 6.68941 9.62106L10.0922 5.878C10.2779 5.67367 10.2629 5.35745 10.0586 5.1717Z" fill="currentColor" /></>
  ),
});

export const CalendarCircleFillIcon = createIcon({
  displayName: 'CalendarCircleFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM6.60155 4.56963C6.87012 4.50542 7.0358 4.23565 6.97159 3.96708C6.90738 3.6985 6.63761 3.53283 6.36904 3.59704C4.63348 4.01194 3.58333 5.29715 3.58333 6.53333C3.58333 7.61117 4.17782 8.44772 4.93832 8.99534C5.69294 9.53872 6.65328 9.83333 7.51471 9.83333C9.28653 9.83333 10.4167 8.57944 10.4167 7.23333C10.4167 6.6586 10.1622 5.94758 9.72898 5.42396C9.28396 4.88613 8.56985 4.46536 7.68966 4.72942C7.42516 4.80877 7.27507 5.08751 7.35442 5.35201C7.43377 5.6165 7.71251 5.7666 7.97701 5.68725C8.34682 5.5763 8.67437 5.71804 8.95852 6.06146C9.25443 6.41909 9.41667 6.90806 9.41667 7.23333C9.41667 7.98722 8.77504 8.83333 7.51471 8.83333C6.86005 8.83333 6.10471 8.60294 5.52266 8.18383C4.9465 7.76895 4.58333 7.2055 4.58333 6.53333C4.58333 5.86951 5.19986 4.90472 6.60155 4.56963Z" fill="currentColor" /></>
  ),
});

export const CalendarEditIcon = createIcon({
  displayName: 'CalendarEditIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM3 5V10.5C3 10.7761 3.22386 11 3.5 11H10.5C10.7761 11 11 10.7761 11 10.5V5C11 4.44772 10.5523 4 10 4H4C3.44772 4 3 4.44772 3 5Z" fill="currentColor" /><path fillRule="evenodd" clipRule="evenodd" d="M9.60313 5.89896C9.85683 5.64525 9.85683 5.23391 9.60313 4.98021C9.34942 4.7265 8.93808 4.7265 8.68437 4.98021L8.34279 5.32179L9.26154 6.24055L9.60313 5.89896ZM8.55443 6.94765L7.63568 6.0289L5.03215 8.63244L4.39687 10.1865L5.9509 9.55119L8.55443 6.94765Z" fill="currentColor" /></>
  ),
});

export const CalendarEditFillIcon = createIcon({
  displayName: 'CalendarEditFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4.50002 0.999998C4.22388 0.999998 4.00002 1.22386 4.00002 1.5V2H3.50002C2.67159 2 2.00002 2.67157 2.00002 3.5V10.5C2.00002 11.3284 2.67159 12 3.50002 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77616 0.999998 9.50002 0.999998C9.22388 0.999998 9.00002 1.22386 9.00002 1.5V2H5.00002V1.5C5.00002 1.22386 4.77616 0.999998 4.50002 0.999998ZM9.60314 4.98021C9.85685 5.23391 9.85685 5.64525 9.60314 5.89896L9.26156 6.24055L8.34281 5.32179L8.68439 4.98021C8.9381 4.7265 9.34944 4.7265 9.60314 4.98021ZM7.6357 6.0289L8.55445 6.94765L5.95091 9.55119L4.39689 10.1865L5.03216 8.63244L7.6357 6.0289Z" fill="currentColor" /></>
  ),
});

export const CalendarFillIcon = createIcon({
  displayName: 'CalendarFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4 1.5C4 1.22386 4.22386 0.999998 4.5 0.999998C4.77614 0.999998 5 1.22386 5 1.5V2H9V1.5C9 1.22386 9.22386 0.999998 9.5 0.999998C9.77614 0.999998 10 1.22386 10 1.5V2H10.5C11.3284 2 12 2.67157 12 3.5V10.5C12 11.3284 11.3284 12 10.5 12H3.5C2.67157 12 2 11.3284 2 10.5V3.5C2 2.67157 2.67157 2 3.5 2H4V1.5Z" fill="currentColor" /></>
  ),
});

export const CalendarNowIcon = createIcon({
  displayName: 'CalendarNowIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M4 1.5C4 1.22386 4.22386 0.999998 4.5 0.999998C4.77614 0.999998 5 1.22386 5 1.5V2H9V1.5C9 1.22386 9.22386 0.999998 9.5 0.999998C9.77614 0.999998 10 1.22386 10 1.5V2H10.5C11.3284 2 12 2.67157 12 3.5V10.5C12 11.3284 11.3284 12 10.5 12H3.5C2.67157 12 2 11.3284 2 10.5V3.5C2 2.67157 2.67157 2 3.5 2H4V1.5ZM3 10.5V5C3 4.44772 3.44772 4 4 4H10C10.5523 4 11 4.44772 11 5V10.5C11 10.7761 10.7761 11 10.5 11H3.5C3.22386 11 3 10.7761 3 10.5ZM6.70143 5.98702C6.97041 5.9245 7.13777 5.65578 7.07526 5.38681C7.01274 5.11783 6.74402 4.95047 6.47505 5.01298C5.06178 5.34146 4.16667 6.37076 4.16667 7.40556C4.16667 8.29528 4.67208 8.97652 5.29765 9.41446C5.91838 9.84902 6.70524 10.0833 7.41177 10.0833C8.86674 10.0833 9.83334 9.07565 9.83334 7.95C9.83334 7.47122 9.61765 6.89176 9.25577 6.46657C8.88081 6.02598 8.27382 5.67708 7.52667 5.895C7.26158 5.97232 7.10935 6.2499 7.18667 6.515C7.26399 6.7801 7.54158 6.93232 7.80667 6.855C8.05952 6.78125 8.28587 6.86986 8.49424 7.11468C8.7157 7.3749 8.83334 7.72878 8.83334 7.95C8.83334 8.45768 8.38252 9.08333 7.41177 9.08333C6.90544 9.08333 6.31975 8.90931 5.87115 8.59526C5.42738 8.28459 5.16667 7.87694 5.16667 7.40556C5.16667 6.96257 5.6049 6.24188 6.70143 5.98702Z" fill="currentColor" /></>
  ),
});

export const RightSidebarIcon = createIcon({
  displayName: 'RightSidebarIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M10.8333 2.75H3.16666C2.61437 2.75 2.16666 3.19772 2.16666 3.75V10.25C2.16666 10.8023 2.61437 11.25 3.16666 11.25H10.8333C11.3856 11.25 11.8333 10.8023 11.8333 10.25V3.75C11.8333 3.19772 11.3856 2.75 10.8333 2.75ZM3.16666 1.75C2.06209 1.75 1.16666 2.64543 1.16666 3.75V10.25C1.16666 11.3546 2.06209 12.25 3.16666 12.25H10.8333C11.9379 12.25 12.8333 11.3546 12.8333 10.25V3.75C12.8333 2.64543 11.9379 1.75 10.8333 1.75H3.16666Z" fill="currentColor" />
      <rect x="7" y="3.5" width="4" height="7" rx="0.5" fill="currentColor" />
    </>
  ),
});

export const RightSidebarAddIcon = createIcon({
  displayName: 'RightSidebarAddIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M10.8333 2.75H3.16668C2.61439 2.75 2.16668 3.19772 2.16668 3.75V10.25C2.16668 10.8023 2.61439 11.25 3.16668 11.25H8.19918C8.25002 11.6055 8.35913 11.9421 8.51652 12.25H3.16668C2.06211 12.25 1.16668 11.3546 1.16668 10.25V3.75C1.16668 2.64543 2.06211 1.75 3.16668 1.75H10.8333C11.9379 1.75 12.8333 2.64543 12.8333 3.75V7.93316C12.5255 7.77577 12.1888 7.66667 11.8333 7.61582V3.75C11.8333 3.19772 11.3856 2.75 10.8333 2.75ZM8.17977 10.5C8.31596 8.98872 9.50014 7.77963 11 7.60502V4C11 3.72386 10.7762 3.5 10.5 3.5H7.50002C7.22388 3.5 7.00002 3.72386 7.00002 4V10C7.00002 10.2761 7.22388 10.5 7.50002 10.5H8.17977ZM14 10.7917C14 12.2414 12.8248 13.4167 11.375 13.4167C9.92527 13.4167 8.75002 12.2414 8.75002 10.7917C8.75002 9.34192 9.92527 8.16667 11.375 8.16667C12.8248 8.16667 14 9.34192 14 10.7917ZM11.0834 9.33333V10.5H9.91669V11.0833H11.0834V12.25H11.6667V11.0833H12.8334V10.5H11.6667V9.33333H11.0834Z" fill="currentColor" />
  ),
});

export const MenuIcon = createIcon({
  displayName: 'MenuIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M1.75 3.5C1.75 3.17783 2.01117 2.91666 2.33333 2.91666H11.6667C11.9888 2.91666 12.25 3.17783 12.25 3.5C12.25 3.82216 11.9888 4.08333 11.6667 4.08333H2.33333C2.01117 4.08333 1.75 3.82216 1.75 3.5ZM1.75 7C1.75 6.67783 2.01117 6.41666 2.33333 6.41666H11.6667C11.9888 6.41666 12.25 6.67783 12.25 7C12.25 7.32216 11.9888 7.58333 11.6667 7.58333H2.33333C2.01117 7.58333 1.75 7.32216 1.75 7ZM2.33333 9.91666C2.01117 9.91666 1.75 10.1778 1.75 10.5C1.75 10.8222 2.01117 11.0833 2.33333 11.0833H11.6667C11.9888 11.0833 12.25 10.8222 12.25 10.5C12.25 10.1778 11.9888 9.91666 11.6667 9.91666H2.33333Z" fill="currentColor" />
  ),
});

export const HelpIcon = createIcon({
  displayName: 'HelpIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M6.99999 11.8333C9.66937 11.8333 11.8333 9.66937 11.8333 7C11.8333 4.33062 9.66937 2.16666 6.99999 2.16666C4.33061 2.16666 2.16666 4.33062 2.16666 7C2.16666 9.66937 4.33061 11.8333 6.99999 11.8333ZM6.99999 12.8333C10.2217 12.8333 12.8333 10.2217 12.8333 7C12.8333 3.77834 10.2217 1.16666 6.99999 1.16666C3.77833 1.16666 1.16666 3.77834 1.16666 7C1.16666 10.2217 3.77833 12.8333 6.99999 12.8333ZM6.39983 8.58522V8.6714H7.50353V8.58522C7.50573 8.35101 7.53336 8.15435 7.58639 7.99526C7.64163 7.83396 7.72559 7.69365 7.83828 7.57433C7.95318 7.45502 8.10012 7.34012 8.27909 7.22964C8.48238 7.10811 8.65804 6.97001 8.80608 6.81534C8.95413 6.66067 9.06792 6.4839 9.14747 6.28503C9.22922 6.08617 9.2701 5.86079 9.2701 5.6089C9.2701 5.23548 9.1795 4.91288 8.99832 4.6411C8.81934 4.36711 8.56855 4.15609 8.24595 4.00805C7.92556 3.86 7.55435 3.78598 7.13231 3.78598C6.74563 3.78598 6.3921 3.85669 6.07171 3.9981C5.75353 4.13952 5.49721 4.35164 5.30277 4.63447C5.11053 4.91729 5.00889 5.26862 4.99784 5.68844H6.17777C6.18882 5.48074 6.23964 5.3095 6.33023 5.17471C6.42303 5.03772 6.53904 4.93608 6.67824 4.86979C6.81966 4.80129 6.9688 4.76704 7.12568 4.76704C7.29582 4.76704 7.44939 4.8024 7.58639 4.8731C7.72559 4.94381 7.83607 5.04324 7.91782 5.1714C7.99958 5.29956 8.04046 5.45091 8.04046 5.62547C8.04046 5.78014 8.00952 5.92045 7.94765 6.0464C7.88579 6.17014 7.80072 6.28282 7.69245 6.38447C7.58639 6.4839 7.46596 6.5756 7.33118 6.65956C7.13452 6.78109 6.9677 6.91477 6.8307 7.0606C6.69371 7.20423 6.58765 7.39425 6.51252 7.63068C6.43961 7.86711 6.40204 8.18529 6.39983 8.58522ZM6.46281 10.5275C6.60643 10.6689 6.77767 10.7396 6.97654 10.7396C7.10911 10.7396 7.22954 10.7075 7.33781 10.6435C7.44829 10.5772 7.53667 10.4888 7.60296 10.3783C7.67145 10.2678 7.7057 10.1452 7.7057 10.0104C7.7057 9.81155 7.63279 9.64141 7.48695 9.5C7.34333 9.35858 7.17319 9.28788 6.97654 9.28788C6.77767 9.28788 6.60643 9.35858 6.46281 9.5C6.31918 9.64141 6.24737 9.81155 6.24737 10.0104C6.24737 10.2137 6.31918 10.386 6.46281 10.5275Z" fill="currentColor" />
  ),
});

export const HelpFillIcon = createIcon({
  displayName: 'HelpFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M6.99999 12.8333C10.2217 12.8333 12.8333 10.2217 12.8333 7C12.8333 3.77834 10.2217 1.16666 6.99999 1.16666C3.77833 1.16666 1.16666 3.77834 1.16666 7C1.16666 10.2217 3.77833 12.8333 6.99999 12.8333ZM6.39984 8.41856V8.50473H7.50353V8.41856C7.50574 8.18434 7.53336 7.98769 7.58639 7.8286C7.64163 7.6673 7.72559 7.52699 7.83828 7.40767C7.95318 7.28835 8.10012 7.17345 8.2791 7.06297C8.48238 6.94144 8.65804 6.80334 8.80609 6.64867C8.95413 6.494 9.06792 6.31723 9.14747 6.11837C9.22922 5.9195 9.2701 5.69413 9.2701 5.44223C9.2701 5.06881 9.17951 4.74621 8.99832 4.47443C8.81934 4.20044 8.56855 3.98942 8.24595 3.84138C7.92556 3.69334 7.55435 3.61932 7.13232 3.61932C6.74564 3.61932 6.3921 3.69002 6.07171 3.83144C5.75353 3.97285 5.49722 4.18497 5.30277 4.4678C5.11054 4.75063 5.0089 5.10195 4.99785 5.52178H6.17777C6.18882 5.31408 6.23964 5.14283 6.33023 5.00805C6.42304 4.87105 6.53904 4.76941 6.67825 4.70312C6.81966 4.63462 6.96881 4.60038 7.12569 4.60038C7.29583 4.60038 7.44939 4.63573 7.58639 4.70644C7.72559 4.77714 7.83607 4.87658 7.91783 5.00473C7.99958 5.13289 8.04046 5.28425 8.04046 5.4588C8.04046 5.61348 8.00953 5.75379 7.94766 5.87973C7.88579 6.00347 7.80072 6.11616 7.69245 6.2178C7.58639 6.31723 7.46597 6.40893 7.33118 6.4929C7.13453 6.61442 6.9677 6.7481 6.83071 6.89394C6.69371 7.03756 6.58765 7.22759 6.51253 7.46401C6.43961 7.70044 6.40205 8.01862 6.39984 8.41856ZM6.46281 10.3608C6.60643 10.5022 6.77768 10.5729 6.97654 10.5729C7.10912 10.5729 7.22954 10.5409 7.33781 10.4768C7.44829 10.4105 7.53667 10.3221 7.60296 10.2116C7.67146 10.1012 7.70571 9.97853 7.70571 9.84375C7.70571 9.64488 7.63279 9.47474 7.48696 9.33333C7.34333 9.19192 7.17319 9.12121 6.97654 9.12121C6.77768 9.12121 6.60643 9.19192 6.46281 9.33333C6.31919 9.47474 6.24737 9.64488 6.24737 9.84375C6.24737 10.047 6.31919 10.2194 6.46281 10.3608Z" fill="currentColor" />
  ),
});

export const ChatBubbleIcon = createIcon({
  displayName: 'ChatBubbleIcon',
  viewBox: '0 0 14 14',
  path: (
    <path d="M4.93691 11.9798L5.29046 12.3333L4.93691 11.9798ZM3.13165 9.73333L2.95914 10.2026L3.13165 9.73333ZM1.66669 5.33333C1.66669 3.95262 2.78598 2.83333 4.16669 2.83333V1.83333C2.23369 1.83333 0.666687 3.40034 0.666687 5.33333H1.66669ZM1.66669 6.91667V5.33333H0.666687V6.91667H1.66669ZM3.30415 9.26403C2.3477 8.91245 1.66669 7.99345 1.66669 6.91667H0.666687C0.666687 8.42605 1.62189 9.71107 2.95914 10.2026L3.30415 9.26403ZM4.58335 11.6262V10.8886H3.58335V11.6262H4.58335ZM4.58335 11.6262H4.58335H3.58335C3.58335 12.5171 4.6605 12.9633 5.29046 12.3333L4.58335 11.6262ZM6.35357 9.85601L4.58335 11.6262L5.29046 12.3333L7.06068 10.5631L6.35357 9.85601ZM9.83335 9.41667H7.41423V10.4167H9.83335V9.41667ZM12.3334 6.91666C12.3334 8.29738 11.2141 9.41667 9.83335 9.41667V10.4167C11.7664 10.4167 13.3334 8.84966 13.3334 6.91666H12.3334ZM12.3334 5.33333V6.91666H13.3334V5.33333H12.3334ZM9.83335 2.83333C11.2141 2.83333 12.3334 3.95262 12.3334 5.33333H13.3334C13.3334 3.40033 11.7663 1.83333 9.83335 1.83333V2.83333ZM4.16669 2.83333H9.83335V1.83333H4.16669V2.83333ZM7.06068 10.5631C7.15445 10.4693 7.28163 10.4167 7.41423 10.4167V9.41667C7.01641 9.41667 6.63488 9.5747 6.35357 9.85601L7.06068 10.5631ZM2.95914 10.2026C3.36415 10.3515 3.58335 10.6411 3.58335 10.8886H4.58335C4.58335 10.0529 3.91596 9.48892 3.30415 9.26403L2.95914 10.2026Z" fill="currentColor" />
  ),
});

export const ChatBubbleFillIcon = createIcon({
  displayName: 'ChatBubbleFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M4.16667 1.83333C2.23367 1.83333 0.666667 3.40034 0.666667 5.33334V6.91667C0.666667 8.42605 1.62187 9.71107 2.95912 10.2026C3.36413 10.3515 3.58333 10.6411 3.58333 10.8886V11.6262C3.58333 12.5171 4.66048 12.9633 5.29044 12.3333L7.06066 10.5631C7.15443 10.4693 7.28161 10.4167 7.41421 10.4167H9.83333C11.7663 10.4167 13.3333 8.84966 13.3333 6.91667V5.33333C13.3333 3.40034 11.7663 1.83333 9.83333 1.83333H4.16667Z" fill="currentColor" />
  ),
});

export const CheckmarkIcon = createIcon({
  displayName: 'CheckmarkIcon',
  viewBox: '0 0 14 14',
  path: (
    <><path fillRule="evenodd" clipRule="evenodd" d="M11.2967 3.16366C11.4824 2.95933 11.7987 2.94428 12.003 3.13003C12.2073 3.31578 12.2224 3.63201 12.0366 3.83634L6.2033 10.253C6.10854 10.3572 5.9742 10.4167 5.83333 10.4167C5.69245 10.4167 5.55812 10.3572 5.46336 10.253L2.54669 7.04467C2.36094 6.84034 2.37599 6.52412 2.58032 6.33836C2.78465 6.15261 3.10088 6.16767 3.28663 6.372L5.83333 9.17336L11.2967 3.16366Z" fill="currentColor" /></>
  ),
});

export const ChevronLeftIcon = createIcon({
  displayName: 'ChevronLeftIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M8.39646 1.97977C8.59172 1.78451 8.9083 1.78451 9.10356 1.97977C9.29883 2.17504 9.29883 2.49162 9.10356 2.68688L4.79045 6.99999L9.10356 11.3131C9.29883 11.5084 9.29883 11.825 9.10356 12.0202C8.9083 12.2155 8.59172 12.2155 8.39646 12.0202L3.72979 7.35355C3.53453 7.15829 3.53453 6.8417 3.72979 6.64644L8.39646 1.97977Z" fill="currentColor" />
  ),
});

export const ChevronRightIcon = createIcon({
  displayName: 'ChevronRightIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M5.60354 1.97977C5.40828 1.78451 5.0917 1.78451 4.89644 1.97977C4.70117 2.17504 4.70117 2.49162 4.89644 2.68688L9.20955 6.99999L4.89644 11.3131C4.70117 11.5084 4.70117 11.825 4.89644 12.0202C5.0917 12.2155 5.40828 12.2155 5.60354 12.0202L10.2702 7.35355C10.4655 7.15829 10.4655 6.8417 10.2702 6.64644L5.60354 1.97977Z" fill="currentColor" />
  ),
});

export const EllipsisHorizontalCircleIcon = createIcon({
  displayName: 'EllipsisHorizontalCircleIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M7.00002 11.8333C9.6694 11.8333 11.8334 9.66937 11.8334 7C11.8334 4.33062 9.6694 2.16666 7.00002 2.16666C4.33064 2.16666 2.16669 4.33062 2.16669 7C2.16669 9.66937 4.33064 11.8333 7.00002 11.8333ZM7.00002 12.8333C10.2217 12.8333 12.8334 10.2217 12.8334 7C12.8334 3.77834 10.2217 1.16666 7.00002 1.16666C3.77836 1.16666 1.16669 3.77834 1.16669 7C1.16669 10.2217 3.77836 12.8333 7.00002 12.8333ZM4.2778 6.06944C3.76387 6.06944 3.34724 6.48607 3.34724 7C3.34724 7.51393 3.76387 7.93055 4.2778 7.93055C4.79173 7.93055 5.20835 7.51393 5.20835 7C5.20835 6.48607 4.79173 6.06944 4.2778 6.06944ZM7.00002 6.06944C6.48609 6.06944 6.06947 6.48607 6.06947 7C6.06947 7.51393 6.48609 7.93055 7.00002 7.93055C7.51395 7.93055 7.93058 7.51393 7.93058 7C7.93058 6.48607 7.51395 6.06944 7.00002 6.06944ZM9.72224 6.06944C9.20831 6.06944 8.79169 6.48607 8.79169 7C8.79169 7.51393 9.20831 7.93055 9.72224 7.93055C10.2362 7.93055 10.6528 7.51393 10.6528 7C10.6528 6.48607 10.2362 6.06944 9.72224 6.06944Z" fill="currentColor" />
  ),
});

export const SettingsIcon = createIcon({
  displayName: 'SettingsIcon',
  viewBox: '0 0 14 14',
  path: (
    <path d="M1.44305 3.79166L1.87606 4.04166L1.44305 3.79166ZM3.48028 3.38257L3.26805 3.83529L3.48028 3.38257ZM2.10738 5.76051L1.82142 6.17067L1.82142 6.17067L2.10738 5.76051ZM2.36921 6.25244H2.86921V6.25244L2.36921 6.25244ZM2.36921 7.74748L2.86921 7.74748V7.74748H2.36921ZM2.10738 8.23941L2.39333 8.64957L2.39333 8.64956L2.10738 8.23941ZM1.44298 10.2083L1.00997 10.4583H1.00997L1.44298 10.2083ZM3.48023 10.6174L3.268 10.1647H3.268L3.48023 10.6174ZM4.03717 10.6366L3.78717 11.0696H3.78717L4.03717 10.6366ZM5.33203 11.3842L5.08203 11.8172H5.08203L5.33203 11.3842ZM5.62713 11.8569L5.12895 11.8995L5.12895 11.8995L5.62713 11.8569ZM8.37295 11.8569L7.87476 11.8143V11.8143L8.37295 11.8569ZM8.66805 11.3842L8.41805 10.9512L8.41805 10.9512L8.66805 11.3842ZM9.96286 10.6366L9.71286 10.2036H9.71286L9.96286 10.6366ZM10.5198 10.6174L10.3076 11.0701L10.3076 11.0702L10.5198 10.6174ZM12.557 10.2083L12.124 9.95833L12.557 10.2083ZM11.8927 8.23949L11.6067 8.64964H11.6067L11.8927 8.23949ZM11.6309 6.25236H12.1309V6.25236L11.6309 6.25236ZM11.8927 5.76043L11.6067 5.35028V5.35028L11.8927 5.76043ZM12.557 3.79163L12.124 4.04163V4.04163L12.557 3.79163ZM10.5197 3.38253L10.732 3.83526L10.732 3.83526L10.5197 3.38253ZM9.96281 3.36332L9.71281 3.79634L9.71281 3.79634L9.96281 3.36332ZM8.66805 2.61579L8.91805 2.18278L8.91805 2.18278L8.66805 2.61579ZM8.37294 2.14307L7.87476 2.18565V2.18565L8.37294 2.14307ZM7.00004 0.583336V1.08334V0.583336ZM5.62713 2.14308L5.12895 2.10051V2.10051L5.62713 2.14308ZM5.33203 2.6158L5.08203 2.18279L5.08203 2.18279L5.33203 2.6158ZM4.03722 3.36336L3.78722 2.93035L3.78722 2.93035L4.03722 3.36336ZM8.85235 8.06943L8.41933 7.81943L8.41933 7.81943L8.85235 8.06943ZM8.06946 5.14765L7.81946 5.58066V5.58066L8.06946 5.14765ZM5.93057 8.85231L6.18057 8.4193V8.4193L5.93057 8.85231ZM5.14768 5.93054L4.71467 5.68054L5.14768 5.93054ZM1.87606 4.04166C2.10769 3.64047 2.20815 3.57322 2.28127 3.55316C2.3807 3.52588 2.62467 3.5337 3.26805 3.83529L3.6925 2.92984C3.05429 2.63067 2.50355 2.45523 2.0167 2.58879C1.50356 2.72957 1.2262 3.16725 1.01003 3.54166L1.87606 4.04166ZM2.39334 5.35036C1.81045 4.94397 1.6817 4.73659 1.65561 4.63684C1.63642 4.56348 1.64443 4.44286 1.87606 4.04166L1.01003 3.54166C0.793866 3.91608 0.553501 4.37512 0.688156 4.88991C0.81591 5.37831 1.24322 5.76755 1.82142 6.17067L2.39334 5.35036ZM2.86921 6.25244C2.86921 5.88331 2.6815 5.55127 2.39334 5.35036L1.82142 6.17067C1.85616 6.19489 1.86921 6.22793 1.86921 6.25244L2.86921 6.25244ZM2.86921 7.74748V6.25244H1.86921V7.74748H2.86921ZM2.39333 8.64956C2.6815 8.44866 2.86921 8.11661 2.86921 7.74748L1.86921 7.74748C1.86921 7.77199 1.85616 7.80503 1.82142 7.82925L2.39333 8.64956ZM1.876 9.9583C1.64436 9.55709 1.63635 9.43647 1.65555 9.36311C1.68164 9.26336 1.81041 9.05597 2.39333 8.64957L1.82142 7.82925C1.24319 8.23238 0.815867 8.62163 0.688101 9.11003C0.553431 9.62482 0.793801 10.0839 1.00997 10.4583L1.876 9.9583ZM3.268 10.1647C2.62461 10.4663 2.38064 10.4741 2.28121 10.4468C2.20809 10.4267 2.10763 10.3595 1.876 9.9583L1.00997 10.4583C1.22614 10.8327 1.5035 11.2704 2.01665 11.4112C2.50349 11.5447 3.05424 11.3693 3.69245 11.0701L3.268 10.1647ZM4.28717 10.2036C3.96749 10.019 3.58608 10.0156 3.268 10.1647L3.69245 11.0701C3.7308 11.0521 3.76594 11.0574 3.78717 11.0696L4.28717 10.2036ZM5.58203 10.9512L4.28717 10.2036L3.78717 11.0696L5.08203 11.8172L5.58203 10.9512ZM6.12532 11.8143C6.09541 11.4643 5.9017 11.1357 5.58203 10.9512L5.08203 11.8172C5.10326 11.8295 5.12534 11.8573 5.12895 11.8995L6.12532 11.8143ZM7.00004 12.9167C6.53678 12.9167 6.42831 12.8633 6.37437 12.81C6.30104 12.7375 6.18582 12.5223 6.12532 11.8143L5.12895 11.8995C5.18896 12.6018 5.3124 13.1665 5.67149 13.5213C6.04998 13.8953 6.56771 13.9167 7.00004 13.9167V12.9167ZM7.87476 11.8143C7.81426 12.5223 7.69904 12.7375 7.62571 12.81C7.57177 12.8633 7.4633 12.9167 7.00004 12.9167V13.9167C7.43238 13.9167 7.95011 13.8953 8.32859 13.5213C8.68768 13.1665 8.81112 12.6018 8.87113 11.8995L7.87476 11.8143ZM8.41805 10.9512C8.09838 11.1357 7.90467 11.4643 7.87476 11.8143L8.87113 11.8995C8.87474 11.8573 8.89682 11.8295 8.91805 11.8172L8.41805 10.9512ZM9.71286 10.2036L8.41805 10.9512L8.91805 11.8172L10.2129 11.0696L9.71286 10.2036ZM10.732 10.1647C10.4139 10.0156 10.0325 10.0191 9.71286 10.2036L10.2129 11.0696C10.2341 11.0574 10.2692 11.0522 10.3076 11.0701L10.732 10.1647ZM12.124 9.95833C11.8924 10.3595 11.7919 10.4268 11.7188 10.4468C11.6194 10.4741 11.3754 10.4663 10.732 10.1647L10.3076 11.0702C10.9458 11.3693 11.4965 11.5448 11.9834 11.4112C12.4965 11.2704 12.7739 10.8327 12.9901 10.4583L12.124 9.95833ZM11.6067 8.64964C12.1896 9.05603 12.3184 9.26341 12.3445 9.36315C12.3637 9.43651 12.3557 9.55713 12.124 9.95833L12.9901 10.4583C13.2062 10.0839 13.4466 9.62487 13.3119 9.11009C13.1842 8.62169 12.7569 8.23245 12.1787 7.82933L11.6067 8.64964ZM11.1309 7.74756C11.1309 8.11668 11.3186 8.44873 11.6067 8.64964L12.1787 7.82933C12.1439 7.80511 12.1309 7.77207 12.1309 7.74756H11.1309ZM11.1309 6.25236V7.74756H12.1309V6.25236H11.1309ZM11.6067 5.35028C11.3186 5.55119 11.1309 5.88323 11.1309 6.25236L12.1309 6.25236C12.1309 6.22785 12.1439 6.19481 12.1787 6.17058L11.6067 5.35028ZM12.124 4.04163C12.3556 4.44282 12.3636 4.56345 12.3444 4.63681C12.3183 4.73654 12.1896 4.94391 11.6067 5.35028L12.1787 6.17059C12.7568 5.76748 13.1841 5.37824 13.3119 4.88985C13.4465 4.37507 13.2062 3.91604 12.99 3.54163L12.124 4.04163ZM10.732 3.83526C11.3754 3.53366 11.6193 3.52585 11.7187 3.55312C11.7919 3.57318 11.8923 3.64043 12.124 4.04163L12.99 3.54163C12.7738 3.16722 12.4965 2.72953 11.9833 2.58876C11.4965 2.45519 10.9457 2.63063 10.3075 2.92981L10.732 3.83526ZM9.71281 3.79634C10.0325 3.9809 10.4139 3.98436 10.732 3.83526L10.3075 2.9298C10.2692 2.94778 10.234 2.94257 10.2128 2.93031L9.71281 3.79634ZM8.41805 3.0488L9.71281 3.79634L10.2128 2.93031L8.91805 2.18278L8.41805 3.0488ZM7.87476 2.18565C7.90467 2.53566 8.09837 2.86424 8.41805 3.0488L8.91805 2.18278C8.89682 2.17052 8.87473 2.1427 8.87113 2.1005L7.87476 2.18565ZM7.00004 1.08334C7.4633 1.08334 7.57177 1.13671 7.6257 1.19001C7.69904 1.26247 7.81426 1.47767 7.87476 2.18565L8.87113 2.1005C8.81111 1.39821 8.68767 0.833535 8.32859 0.4787C7.9501 0.104696 7.43237 0.0833357 7.00004 0.0833359V1.08334ZM6.12532 2.18565C6.18582 1.47767 6.30104 1.26247 6.37437 1.19001C6.42831 1.13671 6.53678 1.08334 7.00004 1.08334V0.0833359C6.56771 0.0833358 6.04998 0.104696 5.67149 0.4787C5.3124 0.833536 5.18896 1.39822 5.12895 2.10051L6.12532 2.18565ZM5.58203 3.04881C5.90171 2.86425 6.09541 2.53566 6.12532 2.18565L5.12895 2.10051C5.12534 2.14271 5.10326 2.17053 5.08203 2.18279L5.58203 3.04881ZM4.28722 3.79637L5.58203 3.04881L5.08203 2.18279L3.78722 2.93035L4.28722 3.79637ZM3.26805 3.83529C3.58613 3.9844 3.96754 3.98094 4.28722 3.79637L3.78722 2.93035C3.76599 2.9426 3.73085 2.94782 3.6925 2.92984L3.26805 3.83529ZM9.28536 8.31943C10.0141 7.05727 9.58162 5.44335 8.31946 4.71464L7.81946 5.58066C8.60333 6.03323 8.8719 7.03556 8.41933 7.81943L9.28536 8.31943ZM5.68057 9.28533C6.94273 10.014 8.55665 9.58159 9.28536 8.31943L8.41933 7.81943C7.96677 8.6033 6.96444 8.87187 6.18057 8.4193L5.68057 9.28533ZM4.71467 5.68054C3.98596 6.9427 4.41841 8.55662 5.68057 9.28533L6.18057 8.4193C5.3967 7.96674 5.12813 6.96441 5.5807 6.18054L4.71467 5.68054ZM8.31946 4.71464C7.0573 3.98593 5.44338 4.41838 4.71467 5.68054L5.5807 6.18054C6.03326 5.39667 7.03559 5.1281 7.81946 5.58066L8.31946 4.71464Z" fill="currentColor" />
  ),
});

export const ContrastIcon = createIcon({
  displayName: 'ContrastIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M12 7C12 9.76142 9.76142 12 7 12C4.23858 12 2 9.76142 2 7C2 4.23858 4.23858 2 7 2C9.76142 2 12 4.23858 12 7ZM13 7C13 10.3137 10.3137 13 7 13C3.68629 13 1 10.3137 1 7C1 3.68629 3.68629 1 7 1C10.3137 1 13 3.68629 13 7ZM7 7.36364C8.42191 7.36364 9.84382 7.50659 10.9463 7.65699C10.9816 7.44324 11 7.22376 11 7C11 4.79086 9.20914 3 7 3C4.79086 3 3 4.79086 3 7C3 7.22376 3.01837 7.44324 3.0537 7.65699C4.15618 7.50659 5.57809 7.36364 7 7.36364Z" fill="currentColor" />
  ),
});

export const GraphIcon = createIcon({
  displayName: 'GraphIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M12.25 4.95833C12.25 6.73025 10.8136 8.16667 9.04169 8.16667C7.26977 8.16667 5.83335 6.73025 5.83335 4.95833C5.83335 3.18642 7.26977 1.75 9.04169 1.75C10.8136 1.75 12.25 3.18642 12.25 4.95833ZM5.25002 8.45833C5.25002 9.58592 4.33594 10.5 3.20835 10.5C2.08077 10.5 1.16669 9.58592 1.16669 8.45833C1.16669 7.33075 2.08077 6.41667 3.20835 6.41667C4.33594 6.41667 5.25002 7.33075 5.25002 8.45833ZM7.58335 12.25C8.22769 12.25 8.75002 11.7277 8.75002 11.0833C8.75002 10.439 8.22769 9.91667 7.58335 9.91667C6.93902 9.91667 6.41669 10.439 6.41669 11.0833C6.41669 11.7277 6.93902 12.25 7.58335 12.25Z" fill="currentColor" />
  ),
});

export const InfoIcon = createIcon({
  displayName: 'InfoIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M7 12C9.76142 12 12 9.76142 12 7C12 4.23858 9.76142 2 7 2C4.23858 2 2 4.23858 2 7C2 9.76142 4.23858 12 7 12ZM7 13C10.3137 13 13 10.3137 13 7C13 3.68629 10.3137 1 7 1C3.68629 1 1 3.68629 1 7C1 10.3137 3.68629 13 7 13ZM6.39313 5.63636V9.99999H7.60335V5.63636H6.39313ZM6.53801 4.89488C6.6668 5.0142 6.82116 5.07386 7.00108 5.07386C7.18101 5.07386 7.33441 5.0142 7.46131 4.89488C7.5901 4.77367 7.65449 4.62878 7.65449 4.46022C7.65449 4.29356 7.5901 4.15056 7.46131 4.03124C7.33441 3.91003 7.18101 3.84943 7.00108 3.84943C6.82116 3.84943 6.6668 3.91003 6.53801 4.03124C6.41112 4.15056 6.34767 4.29356 6.34767 4.46022C6.34767 4.62878 6.41112 4.77367 6.53801 4.89488Z" fill="currentColor" />
  ),
});

export const InfoFillIcon = createIcon({
  displayName: 'InfoFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M13 7C13 10.3137 10.3137 13 7 13C3.68629 13 1 10.3137 1 7C1 3.68629 3.68629 1 7 1C10.3137 1 13 3.68629 13 7ZM6.39313 5.63636V9.99999H7.60335V5.63636H6.39313ZM6.53801 4.89488C6.6668 5.0142 6.82116 5.07386 7.00108 5.07386C7.18101 5.07386 7.33441 5.0142 7.46131 4.89488C7.5901 4.77367 7.65449 4.62878 7.65449 4.46022C7.65449 4.29356 7.5901 4.15056 7.46131 4.03124C7.33441 3.91003 7.18101 3.84943 7.00108 3.84943C6.82116 3.84943 6.6668 3.91003 6.53801 4.03124C6.41112 4.15056 6.34767 4.29356 6.34767 4.46022C6.34767 4.62878 6.41112 4.77367 6.53801 4.89488Z" fill="currentColor" />
  ),
});

export const TimeNowIcon = createIcon({
  displayName: 'TimeNowIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M11.8334 7C11.8334 9.66938 9.6694 11.8333 7.00002 11.8333C4.33064 11.8333 2.16669 9.66938 2.16669 7C2.16669 4.33062 4.33064 2.16667 7.00002 2.16667C9.6694 2.16667 11.8334 4.33062 11.8334 7ZM12.8334 7C12.8334 10.2217 10.2217 12.8333 7.00002 12.8333C3.77836 12.8333 1.16669 10.2217 1.16669 7C1.16669 3.77834 3.77836 1.16667 7.00002 1.16667C10.2217 1.16667 12.8334 3.77834 12.8334 7ZM7.50002 4.66667C7.50002 4.39052 7.27616 4.16667 7.00002 4.16667C6.72388 4.16667 6.50002 4.39052 6.50002 4.66667V7V7.20711L6.64647 7.35355L8.1048 8.81189C8.30006 9.00715 8.61665 9.00715 8.81191 8.81189C9.00717 8.61662 9.00717 8.30004 8.81191 8.10478L7.50002 6.79289V4.66667Z" fill="currentColor" />
  ),
});

export const TrashIcon = createIcon({
  displayName: 'TrashIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M5.24998 2.28776C5.24998 1.82968 5.62133 1.45833 6.07941 1.45833H7.92055C8.37863 1.45833 8.74998 1.82968 8.74998 2.28776C8.74998 2.40784 8.72446 2.52197 8.67855 2.625H11.2291C11.4708 2.625 11.6666 2.82088 11.6666 3.0625C11.6666 3.30413 11.4708 3.5 11.2291 3.5H11.0833V11.3333C11.0833 12.1618 10.4117 12.8333 9.58331 12.8333H4.41665C3.58822 12.8333 2.91665 12.1618 2.91665 11.3333V3.5H2.77081C2.52919 3.5 2.33331 3.30413 2.33331 3.0625C2.33331 2.82088 2.52919 2.625 2.77081 2.625H5.32141C5.2755 2.52197 5.24998 2.40784 5.24998 2.28776ZM5.00001 5.125C5.20711 5.125 5.37501 5.29289 5.37501 5.5V10.5C5.37501 10.7071 5.20711 10.875 5.00001 10.875C4.7929 10.875 4.62501 10.7071 4.62501 10.5V5.5C4.62501 5.29289 4.7929 5.125 5.00001 5.125ZM7.37501 5.5C7.37501 5.29289 7.20711 5.125 7.00001 5.125C6.7929 5.125 6.62501 5.29289 6.62501 5.5V10.5C6.62501 10.7071 6.7929 10.875 7.00001 10.875C7.20711 10.875 7.37501 10.7071 7.37501 10.5V5.5ZM9.37501 5.5C9.37501 5.29289 9.20711 5.125 9.00001 5.125C8.7929 5.125 8.62501 5.29289 8.62501 5.5V10.5C8.62501 10.7071 8.7929 10.875 9.00001 10.875C9.20711 10.875 9.37501 10.7071 9.37501 10.5V5.5Z" fill="currentColor" />
  ),
});

export const TemplateIcon = createIcon({
  displayName: 'TemplateIconIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M2.99997 4C2.99997 2.89543 3.8954 2 4.99997 2H9.99997C11.1045 2 12 2.89543 12 4V9C12 10.1046 11.1045 11 9.99997 11H4.99997C3.8954 11 2.99997 10.1046 2.99997 9V4ZM4.49997 4.625C4.49997 4.30283 4.76114 4.04167 5.0833 4.04167H7.99997C8.32214 4.04167 8.5833 4.30283 8.5833 4.625C8.5833 4.94717 8.32214 5.20833 7.99997 5.20833H5.0833C4.76114 5.20833 4.49997 4.94717 4.49997 4.625ZM4.49997 6.52083C4.49997 6.27921 4.69584 6.08333 4.93747 6.08333H9.8958C10.1374 6.08333 10.3333 6.27921 10.3333 6.52083C10.3333 6.76246 10.1374 6.95833 9.8958 6.95833H4.93747C4.69585 6.95833 4.49997 6.76246 4.49997 6.52083ZM4.93747 7.54167C4.69584 7.54167 4.49997 7.73754 4.49997 7.97917C4.49997 8.22079 4.69584 8.41667 4.93747 8.41667H8.72914C8.97076 8.41667 9.16664 8.22079 9.16664 7.97917C9.16664 7.73754 8.97076 7.54167 8.72914 7.54167H4.93747ZM1.99997 5C1.99997 4.91539 2.00522 4.83201 2.01542 4.75016C1.39271 5.29986 0.999969 6.10407 0.999969 7V10C0.999969 11.6569 2.34312 13 3.99997 13H6.99997C7.8959 13 8.70011 12.6073 9.24981 11.9845C9.16796 11.9947 9.08458 12 8.99997 12H6.99997H3.99997C2.8954 12 1.99997 11.1046 1.99997 10V7V5Z" fill="currentColor" />
  ),
});

export const CalendarTomorrowFillIcon = createIcon({
  displayName: 'CalendarTomorrowFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM7.98811 5.24645C8.18338 5.05118 8.49996 5.05118 8.69522 5.24645L10.0952 6.64645C10.2905 6.84171 10.2905 7.15829 10.0952 7.35355L8.69522 8.75355C8.49996 8.94882 8.18338 8.94882 7.98811 8.75355C7.79285 8.55829 7.79285 8.24171 7.98811 8.04645L8.53456 7.5H4.52083C4.24469 7.5 4.02083 7.27614 4.02083 7C4.02083 6.72386 4.24469 6.5 4.52083 6.5H8.53456L7.98811 5.95355C7.79285 5.75829 7.79285 5.44171 7.98811 5.24645Z" fill="currentColor" />
  ),
});

export const CalendarTomorrowIcon = createIcon({
  displayName: 'CalendarTomorrowIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M8.69522 5.82978C8.49996 5.63452 8.18338 5.63452 7.98812 5.82978C7.79285 6.02504 7.79285 6.34162 7.98812 6.53689L8.53456 7.08333H4.52084C4.24469 7.08333 4.02084 7.30719 4.02084 7.58333C4.02084 7.85948 4.24469 8.08333 4.52084 8.08333H8.53456L7.98812 8.62978C7.79285 8.82504 7.79285 9.14162 7.98812 9.33689C8.18338 9.53215 8.49996 9.53215 8.69522 9.33689L10.0952 7.93689C10.2905 7.74162 10.2905 7.42504 10.0952 7.22978L8.69522 5.82978Z" fill="currentColor" />
      <path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM3 5V10.5C3 10.7761 3.22386 11 3.5 11H10.5C10.7761 11 11 10.7761 11 10.5V5C11 4.44772 10.5523 4 10 4H4C3.44772 4 3 4.44772 3 5Z" fill="currentColor" />
    </>
  ),
});


export const CalendarYesterdayIcon = createIcon({
  displayName: 'CalendarYesterdayIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M5.42148 5.82978C5.61674 5.63452 5.93332 5.63452 6.12859 5.82978C6.32385 6.02504 6.32385 6.34162 6.12859 6.53689L5.58214 7.08333H9.59586C9.87201 7.08333 10.0959 7.30719 10.0959 7.58333C10.0959 7.85947 9.87201 8.08333 9.59586 8.08333H5.58214L6.12859 8.62978C6.32385 8.82504 6.32385 9.14162 6.12859 9.33689C5.93332 9.53215 5.61674 9.53215 5.42148 9.33689L4.02148 7.93689C3.82622 7.74162 3.82622 7.42504 4.02148 7.22978L5.42148 5.82978Z" fill="currentColor" />
      <path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM3 5V10.5C3 10.7761 3.22386 11 3.5 11H10.5C10.7761 11 11 10.7761 11 10.5V5C11 4.44772 10.5523 4 10 4H4C3.44772 4 3 4.44772 3 5Z" fill="currentColor" />
    </>
  ),
});

export const CalendarYesterdayFillIcon = createIcon({
  displayName: 'CalendarYesterdayFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M4.5 0.999998C4.22386 0.999998 4 1.22386 4 1.5V2H3.5C2.67157 2 2 2.67157 2 3.5V10.5C2 11.3284 2.67157 12 3.5 12H10.5C11.3284 12 12 11.3284 12 10.5V3.5C12 2.67157 11.3284 2 10.5 2H10V1.5C10 1.22386 9.77614 0.999998 9.5 0.999998C9.22386 0.999998 9 1.22386 9 1.5V2H5V1.5C5 1.22386 4.77614 0.999998 4.5 0.999998ZM6.01189 5.24645C5.81662 5.05118 5.50004 5.05118 5.30478 5.24645L3.90478 6.64645C3.70952 6.84171 3.70952 7.15829 3.90478 7.35355L5.30478 8.75355C5.50004 8.94882 5.81662 8.94882 6.01189 8.75355C6.20715 8.55829 6.20715 8.24171 6.01189 8.04645L5.46544 7.5H9.47917C9.75531 7.5 9.97917 7.27614 9.97917 7C9.97917 6.72386 9.75531 6.5 9.47917 6.5H5.46544L6.01189 5.95355C6.20715 5.75829 6.20715 5.44171 6.01189 5.24645Z" fill="currentColor" />
  ),
});

export const SearchIcon = createIcon({
  displayName: 'SearchIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M10.0833 6.41667C10.0833 8.44171 8.44171 10.0833 6.41667 10.0833C4.39162 10.0833 2.75 8.44171 2.75 6.41667C2.75 4.39162 4.39162 2.75 6.41667 2.75C8.44171 2.75 10.0833 4.39162 10.0833 6.41667ZM9.34858 10.0475C8.54733 10.6953 7.52731 11.0833 6.41667 11.0833C3.83934 11.0833 1.75 8.994 1.75 6.41667C1.75 3.83934 3.83934 1.75 6.41667 1.75C8.994 1.75 11.0833 3.83934 11.0833 6.41667C11.0833 7.52236 10.6988 8.53825 10.0562 9.33788L12.2876 11.2904C12.4954 11.4722 12.5165 11.7881 12.3346 11.9959C12.1528 12.2037 11.8369 12.2248 11.6291 12.043L9.34858 10.0475Z" fill="currentColor" />
  ),
});

export const ColonIcon = createIcon({
  displayName: 'ColonIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M8.45835 4.08333C8.45835 4.88875 7.80544 5.54167 7.00002 5.54167C6.19461 5.54167 5.54169 4.88875 5.54169 4.08333C5.54169 3.27792 6.19461 2.625 7.00002 2.625C7.80544 2.625 8.45835 3.27792 8.45835 4.08333ZM8.45835 9.91667C8.45835 10.7221 7.80544 11.375 7.00002 11.375C6.19461 11.375 5.54169 10.7221 5.54169 9.91667C5.54169 9.11125 6.19461 8.45833 7.00002 8.45833C7.80544 8.45833 8.45835 9.11125 8.45835 9.91667Z" fill="currentColor" />

  ),
});

export const DashIcon = createIcon({
  displayName: 'DashIcon',
  viewBox: '0 0 14 14',
  path: (
    <rect x="3.5" y="5.97917" width="7" height="2.04167" rx="1.02083" fill="currentColor" />
  ),
});

export const ChevronUpIcon = createIcon({
  displayName: 'ChevronUpIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M12.0202 8.39644C12.2155 8.5917 12.2155 8.90829 12.0202 9.10355C11.8249 9.29881 11.5084 9.29881 11.3131 9.10355L6.99999 4.79043L2.68688 9.10355C2.49162 9.29881 2.17503 9.29881 1.97977 9.10355C1.78451 8.90829 1.78451 8.5917 1.97977 8.39644L6.64644 3.72977C6.8417 3.53451 7.15828 3.53451 7.35354 3.72977L12.0202 8.39644Z" fill="currentColor" />
    </>
  ),
});

export const ChevronDownIcon = createIcon({
  displayName: 'ChevronDownIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M1.97979 5.60356C1.78453 5.4083 1.78453 5.09171 1.97979 4.89645C2.17505 4.70119 2.49163 4.70119 2.6869 4.89645L7.00001 9.20957L11.3131 4.89645C11.5084 4.70119 11.825 4.70119 12.0202 4.89645C12.2155 5.09171 12.2155 5.4083 12.0202 5.60356L7.35356 10.2702C7.1583 10.4655 6.84172 10.4655 6.64646 10.2702L1.97979 5.60356Z" fill="currentColor" />
    </>
  ),
});

export const XmarkIcon = createIcon({
  displayName: 'XmarkIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M3.84934 3.14222C3.65408 2.94696 3.3375 2.94696 3.14224 3.14222C2.94697 3.33748 2.94697 3.65407 3.14224 3.84933L6.29291 7L3.14224 10.1507C2.94698 10.3459 2.94698 10.6625 3.14224 10.8578C3.3375 11.053 3.65408 11.053 3.84934 10.8578L7.00001 7.70711L10.1507 10.8578C10.3459 11.053 10.6625 11.053 10.8578 10.8578C11.0531 10.6625 11.0531 10.3459 10.8578 10.1507L7.70712 7L10.8578 3.84933C11.0531 3.65407 11.0531 3.33748 10.8578 3.14222C10.6625 2.94696 10.3459 2.94696 10.1507 3.14222L7.00001 6.29289L3.84934 3.14222Z" fill="currentColor" />
    </>
  ),
});

export const PencilIcon = createIcon({
  displayName: 'PencilIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M11.4625 4.1125C11.8974 3.67758 11.8974 2.97242 11.4625 2.5375C11.0276 2.10258 10.3224 2.10258 9.8875 2.5375L9.30192 3.12308L10.8769 4.69808L11.4625 4.1125ZM10.1698 5.40518L8.59482 3.83018L3.62654 8.79846L2.5375 11.4625L5.20154 10.3735L10.1698 5.40518Z" fill="currentColor" />
    </>
  ),
});

export const CheckmarkCircleFillIcon = createIcon({
  displayName: 'CheckmarkCircleFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M7 13C10.3137 13 13 10.3137 13 7C13 3.68629 10.3137 1 7 1C3.68629 1 1 3.68629 1 7C1 10.3137 3.68629 13 7 13ZM9.83634 4.88003C9.63201 4.69428 9.31578 4.70933 9.13003 4.91366L5.75 8.6317L4.24497 6.97616C4.05922 6.77183 3.74299 6.75678 3.53866 6.94253C3.33433 7.12828 3.31928 7.44451 3.50503 7.64884L5.38003 9.71134C5.47479 9.81557 5.60913 9.875 5.75 9.875C5.89087 9.875 6.02521 9.81557 6.11997 9.71134L9.86997 5.58634C10.0557 5.38201 10.0407 5.06578 9.83634 4.88003Z" fill="currentColor" />
    </>
  ),
});

export const ExclamationCircleFillIcon = createIcon({
  displayName: 'ExclamationCircleFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M7.00002 12.8333C10.2217 12.8333 12.8334 10.2217 12.8334 7.00001C12.8334 3.77834 10.2217 1.16667 7.00002 1.16667C3.77836 1.16667 1.16669 3.77834 1.16669 7.00001C1.16669 10.2217 3.77836 12.8333 7.00002 12.8333ZM7.7103 8.50474L7.81967 3.71213H6.537L6.64306 8.50474H7.7103ZM6.65963 10.3608C6.80326 10.5022 6.9756 10.5729 7.17668 10.5729C7.30925 10.5729 7.42968 10.5409 7.53795 10.4768C7.64843 10.4105 7.73681 10.3221 7.8031 10.2117C7.8716 10.1012 7.90584 9.97854 7.90584 9.84375C7.90584 9.64489 7.83293 9.47475 7.68709 9.33334C7.54347 9.19192 7.37333 9.12122 7.17668 9.12122C6.9756 9.12122 6.80326 9.19192 6.65963 9.33334C6.51822 9.47475 6.44751 9.64489 6.44751 9.84375C6.44751 10.047 6.51822 10.2194 6.65963 10.3608Z" fill="currentColor" />
    </>
  ),
});

export const PageIcon = createIcon({
  displayName: 'PageIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M10 12H4C3.44772 12 3 11.5523 3 11V3C3 2.44772 3.44772 2 4 2H8.17157C8.43679 2 8.69114 2.10536 8.87868 2.29289L10.7071 4.12132C10.8946 4.30886 11 4.56321 11 4.82843V11C11 11.5523 10.5523 12 10 12ZM2 3C2 1.89543 2.89543 1 4 1H8.17157C8.70201 1 9.21071 1.21071 9.58579 1.58579L11.4142 3.41421C11.7893 3.78929 12 4.29799 12 4.82843V11C12 12.1046 11.1046 13 10 13H4C2.89543 13 2 12.1046 2 11V3ZM5.24999 4.66667C5.57216 4.66667 5.83332 4.4055 5.83332 4.08333C5.83332 3.76117 5.57216 3.5 5.24999 3.5C4.92782 3.5 4.66666 3.76117 4.66666 4.08333C4.66666 4.4055 4.92782 4.66667 5.24999 4.66667ZM5.24999 7.58333C5.57216 7.58333 5.83332 7.32217 5.83332 7C5.83332 6.67783 5.57216 6.41667 5.24999 6.41667C4.92782 6.41667 4.66666 6.67783 4.66666 7C4.66666 7.32217 4.92782 7.58333 5.24999 7.58333ZM5.83332 9.91667C5.83332 10.2388 5.57216 10.5 5.24999 10.5C4.92782 10.5 4.66666 10.2388 4.66666 9.91667C4.66666 9.5945 4.92782 9.33333 5.24999 9.33333C5.57216 9.33333 5.83332 9.5945 5.83332 9.91667Z" fill="currentColor" />
    </>
  ),
});

export const PauseIcon = createIcon({
  displayName: 'PauseIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M4.49581 2.5C4.49581 2.22385 4.71966 2 4.99581 2C5.27195 2 5.49581 2.22385 5.49581 2.5L5.49579 11.5C5.49579 11.7761 5.27193 12 4.99579 12C4.71965 12 4.49579 11.7761 4.49579 11.5L4.49581 2.5ZM9.49999 2.5C9.49999 2.22385 9.27614 2 8.99999 2C8.72385 2 8.49999 2.22385 8.49999 2.5V11.5C8.49999 11.7761 8.72385 12 8.99999 12C9.27614 12 9.49999 11.7761 9.49999 11.5V2.5Z" fill="currentColor" />
  ),
});

export const SquareIcon = createIcon({
  displayName: 'SquareIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M10 3H4C3.44772 3 3 3.44772 3 4V10C3 10.5523 3.44772 11 4 11H10C10.5523 11 11 10.5523 11 10V4C11 3.44772 10.5523 3 10 3ZM4 2C2.89543 2 2 2.89543 2 4V10C2 11.1046 2.89543 12 4 12H10C11.1046 12 12 11.1046 12 10V4C12 2.89543 11.1046 2 10 2H4Z" fill="currentColor" />
  ),
});

export const PageAddIcon = createIcon({
  displayName: 'PageAddIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M4 12H7.54649C7.82366 12.411 8.19351 12.7543 8.62606 13H4C2.89543 13 2 12.1046 2 11V3C2 1.89543 2.89543 1 4 1H8.17157C8.70201 1 9.21071 1.21071 9.58579 1.58579L11.4142 3.41421C11.7893 3.78929 12 4.29799 12 4.82843V7.54648C11.699 7.34351 11.3618 7.19023 11 7.09841V4.82843C11 4.56321 10.8946 4.30886 10.7071 4.12132L8.87868 2.29289C8.69114 2.10536 8.43679 2 8.17157 2H4C3.44772 2 3 2.44772 3 3V11C3 11.5523 3.44772 12 4 12ZM5.25001 4.66667C5.57217 4.66667 5.83334 4.4055 5.83334 4.08333C5.83334 3.76117 5.57217 3.5 5.25001 3.5C4.92784 3.5 4.66667 3.76117 4.66667 4.08333C4.66667 4.4055 4.92784 4.66667 5.25001 4.66667ZM5.25001 7.58333C5.57217 7.58333 5.83334 7.32217 5.83334 7C5.83334 6.67783 5.57217 6.41667 5.25001 6.41667C4.92784 6.41667 4.66667 6.67783 4.66667 7C4.66667 7.32217 4.92784 7.58333 5.25001 7.58333ZM5.83334 9.91667C5.83334 10.2388 5.57217 10.5 5.25001 10.5C4.92784 10.5 4.66667 10.2388 4.66667 9.91667C4.66667 9.5945 4.92784 9.33333 5.25001 9.33333C5.57217 9.33333 5.83334 9.5945 5.83334 9.91667ZM12.8333 10.2083C12.8333 11.6581 11.6581 12.8333 10.2083 12.8333C8.75859 12.8333 7.58334 11.6581 7.58334 10.2083C7.58334 8.75859 8.75859 7.58334 10.2083 7.58334C11.6581 7.58334 12.8333 8.75859 12.8333 10.2083ZM9.91667 8.75V9.91667H8.75001V10.5H9.91667V11.6667H10.5V10.5H11.6667V9.91667H10.5V8.75H9.91667Z" fill="currentColor" />
    </>
  ),
});

export const PageFillIcon = createIcon({
  displayName: 'PageFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M4 1C2.89543 1 2 1.89543 2 3V11C2 12.1046 2.89543 13 4 13H10C11.1046 13 12 12.1046 12 11V4.82843C12 4.29799 11.7893 3.78929 11.4142 3.41421L9.58579 1.58579C9.21071 1.21071 8.70201 1 8.17157 1H4ZM5.24996 4.66666C5.57213 4.66666 5.83329 4.4055 5.83329 4.08333C5.83329 3.76116 5.57213 3.5 5.24996 3.5C4.92779 3.5 4.66663 3.76116 4.66663 4.08333C4.66663 4.4055 4.92779 4.66666 5.24996 4.66666ZM5.24996 7.58333C5.57213 7.58333 5.83329 7.32216 5.83329 7C5.83329 6.67783 5.57213 6.41666 5.24996 6.41666C4.92779 6.41666 4.66663 6.67783 4.66663 7C4.66663 7.32216 4.92779 7.58333 5.24996 7.58333ZM5.83329 9.91666C5.83329 10.2388 5.57213 10.5 5.24996 10.5C4.92779 10.5 4.66663 10.2388 4.66663 9.91666C4.66663 9.5945 4.92779 9.33333 5.24996 9.33333C5.57213 9.33333 5.83329 9.5945 5.83329 9.91666Z" fill="currentColor" />
    </>
  ),
});

export const PersonIcon = createIcon({
  displayName: 'PersonIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M7.00002 6.43749C8.24266 6.43749 9.25002 5.44413 9.25002 4.21875C9.25002 2.99337 8.24266 2 7.00002 2C5.75738 2 4.75002 2.99337 4.75002 4.21875C4.75002 5.44413 5.75738 6.43749 7.00002 6.43749ZM4.5569 7.42361C3.69705 7.42361 3 8.12065 3 8.9805C3 10.389 3.93895 11.6683 5.33252 11.8728C6.4861 12.0421 7.5142 12.0425 8.66818 11.8733C10.0616 11.6689 11 10.3894 11 8.98109C11 8.12092 10.3027 7.42361 9.44252 7.42361H4.5569Z" fill="currentColor" />
    </>
  ),
});

export const CheckboxIcon = createIcon({
  displayName: 'CheckboxIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M4 3H10C10.5523 3 11 3.44772 11 4V10C11 10.5523 10.5523 11 10 11H4C3.44772 11 3 10.5523 3 10V4C3 3.44772 3.44772 3 4 3ZM2 4C2 2.89543 2.89543 2 4 2H10C11.1046 2 12 2.89543 12 4V10C12 11.1046 11.1046 12 10 12H4C2.89543 12 2 11.1046 2 10V4ZM10.003 4.63003C9.79867 4.44428 9.48245 4.45933 9.2967 4.66366L6.33333 7.92336L5.03664 6.497C4.85088 6.29267 4.53466 6.27761 4.33033 6.46336C4.126 6.64912 4.11094 6.96534 4.2967 7.16967L5.96336 9.003C6.05812 9.10724 6.19246 9.16667 6.33333 9.16667C6.47421 9.16667 6.60854 9.10724 6.7033 9.003L10.0366 5.33634C10.2224 5.13201 10.2073 4.81578 10.003 4.63003Z" fill="currentColor" />
    </>
  ),
});

export const HTMLEmbedIcon = createIcon({
  displayName: 'HTMLEmbedIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M8.07653 3.5822C8.12193 3.30981 7.93792 3.0522 7.66553 3.0068C7.39315 2.96141 7.13553 3.14542 7.09014 3.4178L5.92347 10.4178C5.87807 10.6902 6.06208 10.9478 6.33447 10.9932C6.60685 11.0386 6.86447 10.8546 6.90986 10.5822L8.07653 3.5822ZM10.541 3.22265C10.3878 2.99288 10.0774 2.93079 9.84765 3.08397C9.61789 3.23715 9.5558 3.54758 9.70897 3.77735L11.8574 7L9.70897 10.2226C9.5558 10.4524 9.61789 10.7628 9.84765 10.916C10.0774 11.0692 10.3878 11.0071 10.541 10.7773L12.8744 7.27735C12.9863 7.1094 12.9863 6.8906 12.8744 6.72265L10.541 3.22265ZM3.95897 3.22265C4.11215 2.99289 4.42259 2.9308 4.65235 3.08397C4.88211 3.23715 4.9442 3.54759 4.79103 3.77735L2.64259 7L4.79103 10.2226C4.9442 10.4524 4.88211 10.7628 4.65235 10.916C4.42259 11.0692 4.11215 11.0071 3.95897 10.7773L1.62564 7.27735C1.51367 7.1094 1.51367 6.8906 1.62564 6.72265L3.95897 3.22265Z" fill="currentColor" />
    </>
  ),
});

export const YoutubeIcon = createIcon({
  displayName: 'YoutubeIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path d="M5.83332 8.75L8.86082 7L5.83332 5.25V8.75ZM12.5767 4.1825C12.6525 4.45666 12.705 4.82416 12.74 5.29083C12.7808 5.7575 12.7983 6.16 12.7983 6.51L12.8333 7C12.8333 8.2775 12.74 9.21666 12.5767 9.8175C12.4308 10.3425 12.0925 10.6808 11.5675 10.8267C11.2933 10.9025 10.7917 10.955 10.0217 10.99C9.26332 11.0308 8.56916 11.0483 7.92749 11.0483L6.99999 11.0833C4.55582 11.0833 3.03332 10.99 2.43249 10.8267C1.90749 10.6808 1.56916 10.3425 1.42332 9.8175C1.34749 9.54333 1.29499 9.17583 1.25999 8.70916C1.21916 8.2425 1.20166 7.84 1.20166 7.49L1.16666 7C1.16666 5.7225 1.25999 4.78333 1.42332 4.1825C1.56916 3.6575 1.90749 3.31916 2.43249 3.17333C2.70666 3.0975 3.20832 3.045 3.97832 3.01C4.73666 2.96916 5.43082 2.95166 6.07249 2.95166L6.99999 2.91666C9.44416 2.91666 10.9667 3.01 11.5675 3.17333C12.0925 3.31916 12.4308 3.6575 12.5767 4.1825Z" fill="currentColor" />
    </>
  ),
});

export const LinkIcon = createIcon({
  displayName: 'LinkIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M10 5H9C8.72386 5 8.5 4.77614 8.5 4.5V4.5C8.5 4.22386 8.72386 4 9 4L10 4C11.6569 4 13 5.34315 13 7C13 8.65685 11.6569 10 10 10H9C8.72386 10 8.5 9.77614 8.5 9.5V9.5C8.5 9.22386 8.72386 9 9 9H10C11.1046 9 12 8.10457 12 7C12 5.89543 11.1046 5 10 5ZM5 4C5.27614 4 5.5 4.22386 5.5 4.5V4.5C5.5 4.77614 5.27614 5 5 5H4C2.89543 5 2 5.89543 2 7C2 8.10457 2.89543 9 4 9H5C5.27614 9 5.5 9.22386 5.5 9.5V9.5C5.5 9.77614 5.27614 10 5 10H4C2.34315 10 1 8.65685 1 7C1 5.34315 2.34315 4 4 4H5ZM4 7C4 7.27614 4.22386 7.5 4.5 7.5H9.5C9.77614 7.5 10 7.27614 10 7C10 6.72386 9.77614 6.5 9.5 6.5H4.5C4.22386 6.5 4 6.72386 4 7Z" fill="currentColor" />
    </>
  ),
});

export const UnlinkIcon = createIcon({
  displayName: 'UnlinkIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M8.5 4.5C8.5 4.77614 8.72386 5 9 5L10 5C11.1046 5 12 5.89543 12 7C12 8.10457 11.1046 9 10 9H9C8.72386 9 8.5 9.22386 8.5 9.5V9.5C8.5 9.77614 8.72386 10 9 10H10C11.6569 10 13 8.65685 13 7C13 5.34315 11.6569 4 10 4L9 4C8.72386 4 8.5 4.22386 8.5 4.5V4.5ZM5 5C5.27614 5 5.5 4.77614 5.5 4.5V4.5C5.5 4.22386 5.27614 4 5 4H4C2.34315 4 1 5.34315 1 7C1 8.65685 2.34315 10 4 10H5C5.27614 10 5.5 9.77614 5.5 9.5V9.5C5.5 9.22386 5.27614 9 5 9H4C2.89543 9 2 8.10457 2 7C2 5.89543 2.89543 5 4 5H5Z" fill="currentColor" />
    </>
  ),
});

export const EllipsisHorizontalIcon = createIcon({
  displayName: 'EllipsisHorizontalIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M2.33335 8.16667C2.97769 8.16667 3.50002 7.64433 3.50002 7C3.50002 6.35567 2.97769 5.83334 2.33335 5.83334C1.68902 5.83334 1.16669 6.35567 1.16669 7C1.16669 7.64433 1.68902 8.16667 2.33335 8.16667ZM8.16669 7C8.16669 7.64433 7.64435 8.16667 7.00002 8.16667C6.35569 8.16667 5.83335 7.64433 5.83335 7C5.83335 6.35567 6.35569 5.83334 7.00002 5.83334C7.64435 5.83334 8.16669 6.35567 8.16669 7ZM12.8334 7C12.8334 7.64433 12.311 8.16667 11.6667 8.16667C11.0224 8.16667 10.5 7.64433 10.5 7C10.5 6.35567 11.0224 5.83334 11.6667 5.83334C12.311 5.83334 12.8334 6.35567 12.8334 7Z" fill="currentColor" />
    </>
  ),
});

export const PlusIcon = createIcon({
  displayName: 'PlusIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fillRule="evenodd" clipRule="evenodd" d="M1.83331 6.99999C1.83331 6.72385 2.05717 6.49999 2.33331 6.49999L6.49998 6.49999V2.33333C6.49998 2.05719 6.72383 1.83333 6.99998 1.83333C7.27612 1.83333 7.49998 2.05719 7.49998 2.33333V6.49999H11.6666C11.9428 6.49999 12.1666 6.72385 12.1666 6.99999C12.1666 7.27614 11.9428 7.49999 11.6666 7.49999L7.49998 7.49999V11.6667C7.49998 11.9428 7.27612 12.1667 6.99998 12.1667C6.72384 12.1667 6.49998 11.9428 6.49998 11.6667V7.49999H2.33331C2.05717 7.49999 1.83331 7.27614 1.83331 6.99999Z" fill="currentColor" />
    </>
  ),
});

export const ExpandIcon = createIcon({
  displayName: 'ExpandIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M9 1.5C9 1.22386 9.22386 1 9.5 1H12.5C12.7761 1 13 1.22386 13 1.5V4.5C13 4.77614 12.7761 5 12.5 5C12.2239 5 12 4.77614 12 4.5V2.7071L9.35355 5.35355C9.15829 5.54882 8.8417 5.54882 8.64644 5.35355C8.45118 5.15829 8.45118 4.84171 8.64644 4.64645L11.2929 2H9.5C9.22386 2 9 1.77614 9 1.5ZM2.7071 12H4.5C4.77614 12 5 12.2239 5 12.5C5 12.7761 4.77614 13 4.5 13H1.5C1.22386 13 1 12.7761 1 12.5V9.5C1 9.22386 1.22386 9 1.5 9C1.77614 9 2 9.22386 2 9.5V11.2929L5.14644 8.14645C5.3417 7.95118 5.65829 7.95118 5.85355 8.14645C6.04881 8.34171 6.04881 8.65829 5.85355 8.85355L2.7071 12Z" fill="currentColor" />

  ),
});

export const ContractIcon = createIcon({
  displayName: 'ContractIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M9 2.5V4.29289L11.6464 1.64645C11.8417 1.45118 12.1583 1.45118 12.3536 1.64645C12.5488 1.84171 12.5488 2.15829 12.3536 2.35355L9.70711 5H11.5C11.7761 5 12 5.22386 12 5.5C12 5.77614 11.7761 6 11.5 6H8.5C8.22386 6 8 5.77614 8 5.5V2.5C8 2.22386 8.22386 2 8.5 2C8.77614 2 9 2.22386 9 2.5ZM1.64645 11.6464C1.45118 11.8417 1.45118 12.1583 1.64645 12.3536C1.84171 12.5488 2.15829 12.5488 2.35355 12.3536L5.00001 9.7071V11.5C5.00001 11.7761 5.22386 12 5.50001 12C5.77615 12 6.00001 11.7761 6.00001 11.5V8.5C6.00001 8.22386 5.77615 8 5.50001 8H2.50001C2.22386 8 2.00001 8.22386 2.00001 8.5C2.00001 8.77614 2.22386 9 2.50001 9H4.29289L1.64645 11.6464Z" fill="currentColor" />
  ),
});

export const CopyTextIcon = createIcon({
  displayName: 'CopyTextIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M11 2H5C4.44772 2 4 2.44772 4 3V9C4 9.55229 4.44772 10 5 10H11C11.5523 10 12 9.55229 12 9V3C12 2.44772 11.5523 2 11 2ZM5 1C3.89543 1 3 1.89543 3 3C1.89543 3 1 3.89543 1 5V11C1 12.1046 1.89543 13 3 13H9C10.1046 13 11 12.1046 11 11C12.1046 11 13 10.1046 13 9V3C13 1.89543 12.1046 1 11 1H5ZM2 5C2 4.44772 2.44772 4 3 4V9C3 10.1046 3.89543 11 5 11H10C10 11.5523 9.55229 12 9 12H3C2.44772 12 2 11.5523 2 11V5ZM5.75 3.5C5.33579 3.5 5 3.83579 5 4.25C5 4.66421 5.33579 5 5.75 5H8.25C8.66421 5 9 4.66421 9 4.25C9 3.83579 8.66421 3.5 8.25 3.5H5.75ZM5.5 6C5.22386 6 5 6.22386 5 6.5C5 6.77614 5.22386 7 5.5 7H10.5C10.7761 7 11 6.77614 11 6.5C11 6.22386 10.7761 6 10.5 6H5.5ZM5 8.5C5 8.22386 5.22386 8 5.5 8H9C9.27614 8 9.5 8.22386 9.5 8.5C9.5 8.77614 9.27614 9 9 9H5.5C5.22386 9 5 8.77614 5 8.5Z" fill="currentColor" />
  ),
});

export const CopyTextFillIcon = createIcon({
  displayName: 'CopyTextFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M3 3C3 1.89543 3.89543 1 5 1H11C12.1046 1 13 1.89543 13 3V9C13 10.1046 12.1046 11 11 11C11 12.1046 10.1046 13 9 13H3C1.89543 13 1 12.1046 1 11V5C1 3.89543 1.89543 3 3 3ZM5 11H10C10 11.5523 9.55229 12 9 12H3C2.44772 12 2 11.5523 2 11V5C2 4.44772 2.44772 4 3 4V9C3 10.1046 3.89543 11 5 11ZM5.75 3.5C5.33579 3.5 5 3.83579 5 4.25C5 4.66421 5.33579 5 5.75 5H8.25C8.66421 5 9 4.66421 9 4.25C9 3.83579 8.66421 3.5 8.25 3.5H5.75ZM5.5 6C5.22386 6 5 6.22386 5 6.5C5 6.77614 5.22386 7 5.5 7H10.5C10.7761 7 11 6.77614 11 6.5C11 6.22386 10.7761 6 10.5 6H5.5ZM5 8.5C5 8.22386 5.22386 8 5.5 8H9C9.27614 8 9.5 8.22386 9.5 8.5C9.5 8.77614 9.27614 9 9 9H5.5C5.22386 9 5 8.77614 5 8.5Z" fill="currentColor" />
  ),
});

export const CopyIcon = createIcon({
  displayName: 'CopyIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M5 2H11C11.5523 2 12 2.44772 12 3V9C12 9.55229 11.5523 10 11 10H5C4.44772 10 4 9.55229 4 9V3C4 2.44772 4.44772 2 5 2ZM3 3C3 1.89543 3.89543 1 5 1H11C12.1046 1 13 1.89543 13 3V9C13 10.1046 12.1046 11 11 11C11 12.1046 10.1046 13 9 13H3C1.89543 13 1 12.1046 1 11V5C1 3.89543 1.89543 3 3 3ZM3 4C2.44772 4 2 4.44772 2 5V11C2 11.5523 2.44772 12 3 12H9C9.55229 12 10 11.5523 10 11H5C3.89543 11 3 10.1046 3 9V4Z" fill="currentColor" />
  ),
});

export const CopyFillIcon = createIcon({
  displayName: 'CopyFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M5 1C3.89543 1 3 1.89543 3 3C1.89543 3 1 3.89543 1 5V11C1 12.1046 1.89543 13 3 13H9C10.1046 13 11 12.1046 11 11C12.1046 11 13 10.1046 13 9V3C13 1.89543 12.1046 1 11 1H5ZM10 11H5C3.89543 11 3 10.1046 3 9V4C2.44772 4 2 4.44772 2 5V11C2 11.5523 2.44772 12 3 12H9C9.55229 12 10 11.5523 10 11Z" fill="currentColor" />
  ),
});

export const CopyRefIcon = createIcon({
  displayName: 'CopyRefIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M11 2H5C4.44772 2 4 2.44772 4 3V9C4 9.55229 4.44772 10 5 10H11C11.5523 10 12 9.55229 12 9V3C12 2.44772 11.5523 2 11 2ZM5 1C3.89543 1 3 1.89543 3 3C1.89543 3 1 3.89543 1 5V11C1 12.1046 1.89543 13 3 13H9C10.1046 13 11 12.1046 11 11C12.1046 11 13 10.1046 13 9V3C13 1.89543 12.1046 1 11 1H5ZM2 5C2 4.44772 2.44772 4 3 4V9C3 10.1046 3.89543 11 5 11H10C10 11.5523 9.55229 12 9 12H3C2.44772 12 2 11.5523 2 11V5ZM10.3037 4.07608C10.1617 3.83929 9.85454 3.76251 9.61775 3.90459C9.38096 4.04666 9.30418 4.35379 9.44625 4.59058C9.53107 4.73194 9.60202 4.87894 9.65914 5.02972L9.6609 5.03429L9.66259 5.03887C9.77801 5.34685 9.83606 5.67088 9.83664 5.99511L9.83667 6L9.83664 6.00489C9.83606 6.32912 9.77801 6.65315 9.66259 6.96113L9.6609 6.96571L9.65914 6.97027C9.60202 7.12106 9.53107 7.26806 9.44625 7.40942C9.30418 7.64621 9.38096 7.95334 9.61775 8.09541C9.85454 8.23749 10.1617 8.1607 10.3037 7.92391C10.4194 7.7312 10.5162 7.53055 10.5943 7.32456L10.5966 7.3183L10.599 7.31207C10.7567 6.89136 10.8358 6.449 10.8366 6.00667L10.8366 6L10.8366 5.99333C10.8358 5.551 10.7567 5.10864 10.599 4.68793L10.5966 4.68169L10.5943 4.67544C10.5162 4.46944 10.4194 4.2688 10.3037 4.07608ZM5.69625 4.07608C5.83832 3.83929 6.14545 3.76251 6.38224 3.90459C6.61903 4.04666 6.69581 4.35379 6.55374 4.59058C6.46892 4.73194 6.39798 4.87894 6.34085 5.02972L6.33909 5.03429L6.3374 5.03887C6.22198 5.34685 6.16393 5.67088 6.16336 5.99511L6.16332 6L6.16336 6.00489C6.16393 6.32912 6.22198 6.65315 6.3374 6.96113L6.33909 6.96571L6.34085 6.97027C6.39798 7.12106 6.46892 7.26806 6.55374 7.40942C6.69581 7.64621 6.61903 7.95334 6.38224 8.09541C6.14545 8.23749 5.83832 8.1607 5.69625 7.92391C5.58062 7.7312 5.48375 7.53056 5.40571 7.32456L5.40339 7.3183L5.401 7.31207C5.24333 6.89136 5.16415 6.449 5.16336 6.00667L5.16339 6L5.16336 5.99333C5.16415 5.551 5.24333 5.10864 5.401 4.68793L5.40339 4.6817L5.40571 4.67544C5.48375 4.46944 5.58062 4.2688 5.69625 4.07608Z" fill="currentColor" />
  ),
});

export const CopyRefFillIcon = createIcon({
  displayName: 'CopyRefFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M3 3C3 1.89543 3.89543 1 5 1H11C12.1046 1 13 1.89543 13 3V9C13 10.1046 12.1046 11 11 11C11 12.1046 10.1046 13 9 13H3C1.89543 13 1 12.1046 1 11V5C1 3.89543 1.89543 3 3 3ZM5 11H10C10 11.5523 9.55229 12 9 12H3C2.44772 12 2 11.5523 2 11V5C2 4.44772 2.44772 4 3 4V9C3 10.1046 3.89543 11 5 11ZM10.3037 4.07608C10.1617 3.83929 9.85454 3.76251 9.61775 3.90459C9.38096 4.04666 9.30418 4.35379 9.44625 4.59058C9.53107 4.73194 9.60202 4.87894 9.65914 5.02972L9.6609 5.03429L9.66259 5.03887C9.77801 5.34685 9.83606 5.67088 9.83664 5.99511L9.83667 6L9.83664 6.00489C9.83606 6.32912 9.77801 6.65315 9.66259 6.96113L9.6609 6.96571L9.65914 6.97027C9.60202 7.12106 9.53107 7.26806 9.44625 7.40942C9.30418 7.64621 9.38096 7.95334 9.61775 8.09541C9.85454 8.23749 10.1617 8.1607 10.3037 7.92391C10.4194 7.7312 10.5162 7.53055 10.5943 7.32456L10.5966 7.3183L10.599 7.31207C10.7567 6.89136 10.8358 6.449 10.8366 6.00667L10.8366 6L10.8366 5.99333C10.8358 5.551 10.7567 5.10864 10.599 4.68793L10.5966 4.68169L10.5943 4.67544C10.5162 4.46944 10.4194 4.2688 10.3037 4.07608ZM5.69625 4.07608C5.83832 3.83929 6.14545 3.76251 6.38224 3.90459C6.61903 4.04666 6.69581 4.35379 6.55374 4.59058C6.46892 4.73194 6.39798 4.87894 6.34085 5.02972L6.33909 5.03429L6.3374 5.03887C6.22198 5.34685 6.16393 5.67088 6.16336 5.99511L6.16332 6L6.16336 6.00489C6.16393 6.32912 6.22198 6.65315 6.3374 6.96113L6.33909 6.96571L6.34085 6.97027C6.39798 7.12106 6.46892 7.26806 6.55374 7.40942C6.69581 7.64621 6.61903 7.95334 6.38224 8.09541C6.14545 8.23749 5.83832 8.1607 5.69625 7.92391C5.58062 7.7312 5.48375 7.53056 5.40571 7.32456L5.40339 7.3183L5.401 7.31207C5.24333 6.89136 5.16415 6.449 5.16336 6.00667L5.16339 6L5.16336 5.99333C5.16415 5.551 5.24333 5.10864 5.401 4.68793L5.40339 4.6817L5.40571 4.67544C5.48375 4.46944 5.58062 4.2688 5.69625 4.07608Z" fill="currentColor" />
  ),
});

export const ChevronDownVariableIcon = createIcon({
  displayName: 'ChevronDownVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fill="none" strokeWidth={1} d="M2.33331 5.25L6.99998 9.91667L11.6666 5.25" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
  ),
});

export const ArrowRightVariableIcon = createIcon({
  displayName: 'ArrowRightVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fill="none" d="M9.2 4.2L12 7M12 7L9.2 9.8M12 7L2.5 7" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
  ),
});

export const XmarkVariableIcon = createIcon({
  displayName: 'XmarkVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fill="none" d="M10.5042 3.49577L7.00002 7M3.4958 10.5042L7.00002 7M7.00002 7L3.4958 3.49577M7.00002 7L10.5042 10.5042" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
  ),
});

export const CheckmarkVariableIcon = createIcon({
  displayName: 'CheckmarkVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fill="none" d="M11.6667 3.5L5.83332 9.91667L2.91666 6.70833" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
  ),
});

export const PauseVariableIcon = createIcon({
  displayName: 'PauseVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <>
      <path fill="none" d="M9 2.5V11.5" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
      <path fill="none" d="M4.99581 2.5L4.9958 11.5" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" />
    </>
  ),
});

export const ControlsIcon = createIcon({
  displayName: 'ControlsIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M3.79166 2.75H10.2083C11.1058 2.75 11.8333 3.47754 11.8333 4.375C11.8333 5.27246 11.1058 6 10.2083 6H3.79166C2.8942 6 2.16666 5.27246 2.16666 4.375C2.16666 3.47754 2.89419 2.75 3.79166 2.75ZM1.16666 4.375C1.16666 2.92525 2.34191 1.75 3.79166 1.75H10.2083C11.6581 1.75 12.8333 2.92525 12.8333 4.375C12.8333 5.82475 11.6581 7 10.2083 7H3.79166C2.34191 7 1.16666 5.82475 1.16666 4.375ZM2.47916 4.375C2.47916 3.65013 3.06678 3.0625 3.79166 3.0625C4.51653 3.0625 5.10416 3.65013 5.10416 4.375C5.10416 5.09987 4.51653 5.6875 3.79166 5.6875C3.06678 5.6875 2.47916 5.09987 2.47916 4.375ZM3.79166 7.58333C2.34191 7.58333 1.16666 8.75859 1.16666 10.2083C1.16666 11.6581 2.34191 12.8333 3.79166 12.8333H10.2083C11.6581 12.8333 12.8333 11.6581 12.8333 10.2083C12.8333 8.75859 11.6581 7.58333 10.2083 7.58333H3.79166ZM10.2083 8.89583C9.48345 8.89583 8.89582 9.48346 8.89582 10.2083C8.89582 10.9332 9.48345 11.5208 10.2083 11.5208C10.9332 11.5208 11.5208 10.9332 11.5208 10.2083C11.5208 9.48346 10.9332 8.89583 10.2083 8.89583Z" fill="currentColor" />
  ),
})

export const FilterIcon = createIcon({
  displayName: 'FilterIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M1 4.5C1 4.22386 1.22386 4 1.5 4H12.5C12.7761 4 13 4.22386 13 4.5C13 4.77614 12.7761 5 12.5 5H1.5C1.22386 5 1 4.77614 1 4.5ZM3 7.5C3 7.22386 3.22386 7 3.5 7H10.5C10.7761 7 11 7.22386 11 7.5C11 7.77614 10.7761 8 10.5 8H3.5C3.22386 8 3 7.77614 3 7.5ZM4.5 10C4.22386 10 4 10.2239 4 10.5C4 10.7761 4.22386 11 4.5 11H9.5C9.77614 11 10 10.7761 10 10.5C10 10.2239 9.77614 10 9.5 10H4.5Z" fill="currentColor" />
  ),
})

export const FilterVariableIcon = createIcon({
  displayName: 'FilterVariableIcon',
  viewBox: '0 0 14 14',
  path: (
    <path d="M1.5 4.5H12.5M10.5 7.5H3.5M4.5 10.5H9.5" stroke="currentColor" strokeLinecap="round" />
  ),
})

export const FilterCircleIcon = createIcon({
  displayName: 'FilterCircleIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M13 7C13 10.3137 10.3137 13 7 13C3.68629 13 1 10.3137 1 7C1 3.68629 3.68629 1 7 1C10.3137 1 13 3.68629 13 7ZM12 7C12 9.76142 9.76142 12 7 12C4.23858 12 2 9.76142 2 7C2 4.23858 4.23858 2 7 2C9.76142 2 12 4.23858 12 7ZM3.85714 5.07143C3.581 5.07143 3.35714 5.29529 3.35714 5.57143C3.35714 5.84757 3.581 6.07143 3.85714 6.07143H10.1429C10.419 6.07143 10.6429 5.84757 10.6429 5.57143C10.6429 5.29529 10.419 5.07143 10.1429 5.07143H3.85714ZM5 6.78571C4.72386 6.78571 4.5 7.00957 4.5 7.28571C4.5 7.56186 4.72386 7.78571 5 7.78571H9C9.27614 7.78571 9.5 7.56186 9.5 7.28571C9.5 7.00957 9.27614 6.78571 9 6.78571H5ZM5.57143 8.5C5.29529 8.5 5.07143 8.72386 5.07143 9C5.07143 9.27614 5.29529 9.5 5.57143 9.5H8.42857C8.70471 9.5 8.92857 9.27614 8.92857 9C8.92857 8.72386 8.70471 8.5 8.42857 8.5H5.57143Z" fill="currentColor" />
  ),
})

export const FilterCircleFillIcon = createIcon({
  displayName: 'FilterCircleFillIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M7 13C10.3137 13 13 10.3137 13 7C13 3.68629 10.3137 1 7 1C3.68629 1 1 3.68629 1 7C1 10.3137 3.68629 13 7 13ZM3.07143 4.71429C2.79529 4.71429 2.57143 4.93814 2.57143 5.21428C2.57143 5.49043 2.79529 5.71428 3.07143 5.71428H10.9286C11.2047 5.71428 11.4286 5.49043 11.4286 5.21428C11.4286 4.93814 11.2047 4.71429 10.9286 4.71429H3.07143ZM4.5 6.85714C4.22386 6.85714 4 7.081 4 7.35714C4 7.63328 4.22386 7.85714 4.5 7.85714H9.5C9.77614 7.85714 10 7.63328 10 7.35714C10 7.081 9.77614 6.85714 9.5 6.85714H4.5ZM5.21429 9C4.93814 9 4.71429 9.22386 4.71429 9.5C4.71429 9.77614 4.93814 10 5.21429 10H8.78572C9.06186 10 9.28572 9.77614 9.28572 9.5C9.28572 9.22386 9.06186 9 8.78572 9H5.21429Z" fill="currentColor" />
  ),
})

export const GraphChildIcon = createIcon({
  displayName: 'GraphChildIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M3.5 4C3.77614 4 4 3.77614 4 3.5C4 3.22386 3.77614 3 3.5 3C3.22386 3 3 3.22386 3 3.5C3 3.77614 3.22386 4 3.5 4ZM4 4.91465C4.5826 4.70873 5 4.15311 5 3.5C5 2.67157 4.32843 2 3.5 2C2.67157 2 2 2.67157 2 3.5C2 4.15311 2.4174 4.70873 3 4.91465V8.5C3 9.88071 4.11929 11 5.5 11H9.08535C9.29127 11.5826 9.84689 12 10.5 12C11.3284 12 12 11.3284 12 10.5C12 9.67157 11.3284 9 10.5 9C9.84689 9 9.29127 9.4174 9.08535 10H5.5C4.67157 10 4 9.32843 4 8.5V4.91465ZM10.5 11C10.7761 11 11 10.7761 11 10.5C11 10.2239 10.7761 10 10.5 10C10.2239 10 10 10.2239 10 10.5C10 10.7761 10.2239 11 10.5 11Z" fill="currentColor" />
  ),
})

export const UnreadIcon = createIcon({
  displayName: 'UnreadIcon',
  viewBox: '0 0 14 14',
  path: (
    <path fillRule="evenodd" clipRule="evenodd" d="M10.5 6C11.8807 6 13 4.88071 13 3.5C13 2.11929 11.8807 1 10.5 1C9.11929 1 8 2.11929 8 3.5C8 4.88071 9.11929 6 10.5 6ZM12 10V6.66318C11.6891 6.81085 11.3531 6.91405 11 6.96456V10C11 10.5523 10.5523 11 10 11H4C3.44772 11 3 10.5523 3 10V4C3 3.44772 3.44772 3 4 3H7.03544C7.08595 2.64693 7.18915 2.31085 7.33682 2H4C2.89543 2 2 2.89543 2 4V10C2 11.1046 2.89543 12 4 12H10C11.1046 12 12 11.1046 12 10Z" fill="currentColor" />
  ),
})

export const EditIcon = PencilIcon
