import { Button, Input, NotSupported } from 'components';
import run, { hasSupport } from '../../apis/url-api';

function UrlApi() {
  if (!hasSupport) {
    return <NotSupported />;
  }

  return (
    <div>
      <label htmlFor="js-url--input">Enter a URL:</label>
      <Input
        type="text"
        id="js-url--input"
        placeholder="Enter a URL"
        defaultValue="http://www.example.com/something?hello=hey#myhash"
      />

      <Button className="tw-mt-3" onClick={run}>
        Parse URL
      </Button>

      <div
        className="
          tw-shadow
          tw-overflow-hidden
          tw-border-b
          tw-border-gray-200
          sm:tw-rounded-lg
          tw-mt-4
        "
      >
        <table
          className="
            tw-w-full
            tw-min-w-full
            tw-divide-y
            tw-divide-gray-200
          "
        >
          <thead className="tw-bg-gray-100">
            <tr>
              <th
                scope="col"
                className="
                  tw-px-6
                  tw-py-3
                  tw-text-left
                  tw-text-xs
                  tw-font-medium
                  tw-text-gray-500
                  tw-uppercase
                  tw-tracking-wider
                "
              >
                Property
              </th>
              <th
                scope="col"
                className="
                  tw-px-6
                  tw-py-3
                  tw-text-left
                  tw-text-xs
                  tw-font-medium
                  tw-text-gray-500
                  tw-uppercase
                  tw-tracking-wider
                "
              >
                Value
              </th>
            </tr>
          </thead>

          <tbody
            className="
            tw-bg-white
              tw-divide-y
              tw-divide-gray-200
            "
          >
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Hash
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--hash"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Host
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
               "
              >
                <span
                  id="js-url--host"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Hostname
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--hostname"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Href
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--href"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Origin
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--origin"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Pathname
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--pathname"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Protocol
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--protocol"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Search
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-url--search"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  -
                </span>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  );
}

export default UrlApi;
