import { FaLocationArrow } from 'react-icons/fa';

import { Button, Tag, NotSupported } from 'components';

import run, { hasSupport } from '../../apis/geolocation';

function Geolocation() {
  if (!hasSupport()) {
    return <NotSupported />;
  }

  return (
    <div
      className="
        tw-flex
        tw-flex-col
        tw-items-start
      "
    >
      <Button leftIcon={<FaLocationArrow />} onClick={run}>
        Get my location
      </Button>

      <div
        className="
          tw-shadow
          tw-overflow-hidden
          tw-border-b 
          tw-border-gray-200
          sm:tw-rounded-lg
          tw-mt-4
        "
      >
        <table
          className="
            tw-w-full
            tw-min-w-full
            tw-divide-y
            tw-divide-gray-200
          "
        >
          <thead className="tw-bg-gray-100">
            <tr>
              <th
                scope="col"
                className="
                  tw-px-6
                  tw-py-3
                  tw-text-left
                  tw-text-xs
                  tw-font-medium
                  tw-text-gray-500
                  tw-uppercase
                  tw-tracking-wider
                "
              >
                Property
              </th>
              <th
                scope="col"
                className="
                  tw-px-6
                  tw-py-3
                  tw-text-left
                  tw-text-xs
                  tw-font-medium
                  tw-text-gray-500
                  tw-uppercase
                  tw-tracking-wider
                "
              >
                Value
              </th>
            </tr>
          </thead>
          <tbody
            className="
            tw-bg-white
              tw-divide-y
              tw-divide-gray-200
            "
          >
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Latitude
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <span
                  id="js-geolocation--latitude"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Unknow
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Logintude
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
               "
              >
                <span
                  id="js-geolocation--longitude"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Unknow
                </span>
              </td>
            </tr>
            <tr>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Accurate
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
               "
              >
                <span
                  id="js-geolocation--accuracy"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Unknow
                </span>
              </td>
            </tr>
            <tr className="tw-bg-gray-50">
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
                "
              >
                <div
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  Opengraph
                </div>
              </td>
              <td
                className="
                  tw-px-6
                  tw-py-4
                  tw-whitespace-nowrap
               "
              >
                <span
                  id="js-geolocation--longitude"
                  className="
                    tw-text-sm
                    tw-text-gray-900
                  "
                >
                  <Tag
                    id="js-geolocation--opengraph"
                    as="a"
                    href=""
                    rel="noopener noreferrer"
                    target="_blank"
                  >
                    open in new tab
                  </Tag>
                </span>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  );
}

export default Geolocation;
