# 🔌 WEB APIS PLAYGROUND

<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->

[![All Contributors](https://img.shields.io/badge/all_contributors-27-orange.svg?style=flat-square)](#contributors-)

<!-- ALL-CONTRIBUTORS-BADGE:END -->

The `Web APIs Playground` is a project to showcase the JavaScript Web APIs with examples and demonstrations. Client-side JavaScript APIs provides wrapper functions for many low-level tasks like,

- Device Hardware Interactions
- Client-side storage interactions
- 3D Graphics, WebGL
- Notifications
- Audio, Video
- and many, many more.

Please [follow this link](https://developer.mozilla.org/en-US/docs/Web/API) to know about different Web APIs and their usages.

# 🔥 The App

> [https://webapis-playground.vercel.app](https://webapis-playground.vercel.app)

# 🎯 Vision and Mission of this Playground

The primary mission is to provide working examples of the JavaScript web APIs with simple demonstration that can be accessed using browsers on different devices. It may help many beginners to this topic in understanding how to code and use the Web APIs.

# 🏗️ How to ADD a new DEMO?

[Here is a step-by-step guide](./HOW-TO-ADD-DEMO.md) to help you add a new demo.

# ⚒️ It's developed using Next.js

This project is developed using `Next.js`. If you have implemented a similar project using JavaScript or any other frameworks like `React`, `Angular`, `Vue`, please create an issue to include them in the README.

# 🤲 Want to Motivate?

Who doesn't need motivation? Please give the project a star(⭐) and/or share it in your dev circle.

## Many Thanks to all the `Stargazers` who has supported this project with stars(⭐)

[![Stargazers repo roster for @atapas/webapis-playground](https://reporoster.com/stars/atapas/webapis-playground)](https://github.com/atapas/webapis-playground/stargazers)

# 🏃‍♀️ How to Run the project locally

To run the project locally,

- Please clone it.
- Browse to the project directory.
- Install dependencies
- Use Node **16.x.x** or [Node Version Switcher](https://github.com/jasongin/nvs)

```bash
npm install
# Or
yarn install
```

- Run the application locally

```bash
npm run dev
# Or
yarn dev
```

- Open the browser and navigate to `http://localhost:3000`

# 🚀 What's Included?

So far, it includes the following examples:

1. 📂 File System API
1. 📺 FullScreen API
1. 📋 Clipboard API
1. 📡 Broadcast
1. 📷 Image Capture
1. 📶 Network Info
1. 🧐 Resize Observer
1. 💳 Payment Request
1. 📳 Vibration API
1. 🔋 Battery API
1. 🐢 Drag and Drop
1. ⚓ Geolocation API
1. 🖼️ Picture in Picture
1. 💻 Screen Capture
1. ✍️ CSS Font Loading
1. 🎙️ Web Speech API
1. 🎨 Canvas API
1. 👆 Pointer Capture API
1. 🌐 URL API
1. 🗒️ Selection API
1. 📃 Page Visibility API
1. 💬 WebRTC

# 🤝 Open Source

This project is open source and open for contributions. If you are looking for any examples and demonstrations that are missing, please [open an issue from here](https://github.com/atapas/webapis-playground/issues). You can also contribute to the source code by adding an example, improving the code and providing suggestions.

# 🤝 Contributing to `playground`

Any kind of positive contribution is welcome! Please help us to grow by contributing to the project.

If you wish to contribute, you can work on any issues [listed here](https://github.com/atapas/webapis-playground/issues) or create one on your own. After adding your code, please send us a Pull Request.

> Please read [`CONTRIBUTING`](CONTRIBUTING.md) for details on our [`CODE OF CONDUCT`](CODE_OF_CONDUCT.md), and the process for submitting pull requests to us.

# 🙏 Support

We all need support and motivation. `WebAPIs Playground` is not an exception. Please give this project a ⭐️ to encourage and show that you liked it.

If you found the app helpful, consider supporting us with a coffee.

<a href="https://www.buymeacoffee.com/greenroots">
    <img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" height="50px">
</a>

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center"><a href="https://usman-s.me"><img src="https://avatars.githubusercontent.com/u/51731966?v=4?s=100" width="100px;" alt="Max Programming"/><br /><sub><b>Max Programming</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=max-programming" title="Code">💻</a></td>
      <td align="center"><a href="https://tapasadhikary.com"><img src="https://avatars.githubusercontent.com/u/3633137?v=4?s=100" width="100px;" alt="Tapas Adhikary"/><br /><sub><b>Tapas Adhikary</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=atapas" title="Code">💻</a></td>
      <td align="center"><a href="http://niteshseram.in"><img src="https://avatars.githubusercontent.com/u/51370246?v=4?s=100" width="100px;" alt="Nitesh Seram"/><br /><sub><b>Nitesh Seram</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=niteshseram" title="Code">💻</a> <a href="#a11y-niteshseram" title="Accessibility">️️️️♿️</a> <a href="https://github.com/atapas/webapis-playground/issues?q=author%3Aniteshseram" title="Bug reports">🐛</a></td>
      <td align="center"><a href="https://wsameer.github.io/v1/"><img src="https://avatars.githubusercontent.com/u/8468992?v=4?s=100" width="100px;" alt="Sameer Waskar"/><br /><sub><b>Sameer Waskar</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=wsameer" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/omriattiya"><img src="https://avatars.githubusercontent.com/u/26112374?v=4?s=100" width="100px;" alt="Omri Attiya"/><br /><sub><b>Omri Attiya</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=omriattiya" title="Code">💻</a></td>
      <td align="center"><a href="https://tiger-yash.github.io/"><img src="https://avatars.githubusercontent.com/u/74406801?v=4?s=100" width="100px;" alt="Yash Raj"/><br /><sub><b>Yash Raj</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=tiger-yash" title="Code">💻</a></td>
      <td align="center"><a href="https://rehansattar.now.sh/"><img src="https://avatars.githubusercontent.com/u/26999472?v=4?s=100" width="100px;" alt="Rehan  Sattar"/><br /><sub><b>Rehan  Sattar</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=rehan-sattar" title="Code">💻</a> <a href="https://github.com/atapas/webapis-playground/issues?q=author%3Arehan-sattar" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://ahsanayaz.com"><img src="https://avatars.githubusercontent.com/u/9844254?v=4?s=100" width="100px;" alt="Muhammad Ahsan Ayaz"/><br /><sub><b>Muhammad Ahsan Ayaz</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=AhsanAyaz" title="Code">💻</a></td>
      <td align="center"><a href="http://koustov.com"><img src="https://avatars.githubusercontent.com/u/7145967?v=4?s=100" width="100px;" alt="Koustov"/><br /><sub><b>Koustov</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/issues?q=author%3Akoustov" title="Bug reports">🐛</a> <a href="https://github.com/atapas/webapis-playground/commits?author=koustov" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/aanchal-fatwani"><img src="https://avatars.githubusercontent.com/u/63228776?v=4?s=100" width="100px;" alt="Aanchal"/><br /><sub><b>Aanchal</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=aanchal-fatwani" title="Code">💻</a></td>
      <td align="center"><a href="https://abhikhatri67.github.io/"><img src="https://avatars.githubusercontent.com/u/15958423?v=4?s=100" width="100px;" alt="Abhishek Khatri"/><br /><sub><b>Abhishek Khatri</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=abhikhatri67" title="Code">💻</a></td>
      <td align="center"><a href="https://www.avneesh.tech/"><img src="https://avatars.githubusercontent.com/u/76690419?v=4?s=100" width="100px;" alt="Avneesh Agarwal"/><br /><sub><b>Avneesh Agarwal</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=avneesh0612" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/kvnal"><img src="https://avatars.githubusercontent.com/u/72142540?v=4?s=100" width="100px;" alt="Kunal Singh"/><br /><sub><b>Kunal Singh</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=kvnal" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/rzhekova"><img src="https://avatars.githubusercontent.com/u/35401262?v=4?s=100" width="100px;" alt="Rosie Z"/><br /><sub><b>Rosie Z</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=rzhekova" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://github.com/mverissimo"><img src="https://avatars.githubusercontent.com/u/371844?v=4?s=100" width="100px;" alt="Matheus Verissimo"/><br /><sub><b>Matheus Verissimo</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=mverissimo" title="Code">💻</a></td>
      <td align="center"><a href="http://abiolaesther.me"><img src="https://avatars.githubusercontent.com/u/49586787?v=4?s=100" width="100px;" alt="Abiola"/><br /><sub><b>Abiola</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=Abiola-Farounbi" title="Code">💻</a></td>
      <td align="center"><a href="http://linkedin.com/in/emitdutcher"><img src="https://avatars.githubusercontent.com/u/27447016?v=4?s=100" width="100px;" alt="Emit"/><br /><sub><b>Emit</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=develemit" title="Code">💻</a></td>
      <td align="center"><a href="http://tmo.codes"><img src="https://avatars.githubusercontent.com/u/44333523?v=4?s=100" width="100px;" alt="Tyler Morales "/><br /><sub><b>Tyler Morales </b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=tyler-morales" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/chosunosu"><img src="https://avatars.githubusercontent.com/u/49362226?v=4?s=100" width="100px;" alt="chosunosu"/><br /><sub><b>chosunosu</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/issues?q=author%3Achosunosu" title="Bug reports">🐛</a></td>
      <td align="center"><a href="https://webplatform.news"><img src="https://avatars.githubusercontent.com/u/716405?v=4?s=100" width="100px;" alt="Šime Vidas"/><br /><sub><b>Šime Vidas</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/issues?q=author%3Asimevidas" title="Bug reports">🐛</a></td>
      <td align="center"><a href="https://www.linkedin.com/in/vaibhav-agr/"><img src="https://avatars.githubusercontent.com/u/78676331?v=4?s=100" width="100px;" alt="Vaibhav Agrawal"/><br /><sub><b>Vaibhav Agrawal</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=vaibhav-if" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://bharati-portfolio.netlify.app/"><img src="https://avatars.githubusercontent.com/u/51514137?v=4?s=100" width="100px;" alt="Bharati Subramanian"/><br /><sub><b>Bharati Subramanian</b></sub></a><br /><a href="#design-bharati-21" title="Design">🎨</a></td>
      <td align="center"><a href="https://github.com/Sukhseerat-Kaur"><img src="https://avatars.githubusercontent.com/u/54837213?v=4?s=100" width="100px;" alt="Sukhseerat Kaur"/><br /><sub><b>Sukhseerat Kaur</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/issues?q=author%3ASukhseerat-Kaur" title="Bug reports">🐛</a></td>
      <td align="center"><a href="https://github.com/richardnikolas"><img src="https://avatars.githubusercontent.com/u/20261986?v=4?s=100" width="100px;" alt="Richard Nikolas"/><br /><sub><b>Richard Nikolas</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=richardnikolas" title="Code">💻</a></td>
      <td align="center"><a href="https://kvarunkk.github.io/Portfolio_Official/"><img src="https://avatars.githubusercontent.com/u/98093422?v=4?s=100" width="100px;" alt="Varun"/><br /><sub><b>Varun</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=kVarunkk" title="Code">💻</a></td>
      <td align="center"><a href="https://supminn-neog.netlify.app/"><img src="https://avatars.githubusercontent.com/u/30731236?v=4?s=100" width="100px;" alt="Supriya M"/><br /><sub><b>Supriya M</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=supminn" title="Code">💻</a></td>
      <td align="center"><a href="https://williamssam.netlify.app/"><img src="https://avatars.githubusercontent.com/u/68322437?v=4?s=100" width="100px;" alt="Williams Samuel"/><br /><sub><b>Williams Samuel</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=williamssam" title="Code">💻</a></td>
      <td align="center"><a href="https://github.com/raveenita"><img src="https://avatars.githubusercontent.com/u/17017573?v=4" width="100px;" alt="Geovana S. Ribeiro (Raveenita)"/><br /><sub><b>Geovana S. Ribeiro</b></sub></a><br /><a href="https://github.com/atapas/webapis-playground/commits?author=raveenita" title="Code">💻</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
