# Summary

[Introduction](README.md)

# Asterinas Kernel

* [Getting Started](kernel/README.md)
* [Advanced Build and Test Instructions](kernel/advanced-instructions.md)
    * [Intel TDX](kernel/intel_tdx.md)
* [The Framekernel Architecture](kernel/the-framekernel-architecture.md)
* [Linux Compatibility](kernel/linux-compatibility.md)
* [Roadmap](kernel/roadmap.md)

# Asterinas OSTD

* [An Overview of OSTD](ostd/README.md)
* [Example: Writing a Kernel in 100 Lines of Safe Rust](ostd/a-100-line-kernel.md)
* [Example: Writing a Driver in 100 Lines of Safe Rust]()
* [Soundness Analysis]()

# Asterinas OSDK

* [OSDK User Guide](osdk/guide/README.md)
    * [Why OSDK](osdk/guide/why.md)
    * [Creating an OS Project](osdk/guide/create-project.md)
    * [Testing or Running an OS Project](osdk/guide/run-project.md)
    * [Working in a Workspace](osdk/guide/work-in-workspace.md)
    * [Advanced Topics](osdk/guide/advanced_topics.md)
        * [Intel TDX](osdk/guide/intel-tdx.md)
* [OSDK User Reference](osdk/reference/README.md)
    * [Commands](osdk/reference/commands/README.md)
        * [cargo osdk new](osdk/reference/commands/new.md)
        * [cargo osdk build](osdk/reference/commands/build.md)
        * [cargo osdk run](osdk/reference/commands/run.md)
        * [cargo osdk test](osdk/reference/commands/test.md)
        * [cargo osdk debug](osdk/reference/commands/debug.md)
    * [Manifest](osdk/reference/manifest.md)

# How to Contribute

* [Before You Contribute]()
* [Code Organization]()
* [Style Guidelines]()
    * [General Guidelines]() 
    * [Rust Guidelines](to-contribute/style-guidelines/rust-guidelines.md) 
    * [Git Guidelines]() 
* [Boterinas](to-contribute/boterinas.md)
* [Community]()
* [Code of Conduct]()

# Request for Comments (RFC)

* [RFC Overview]()
    * [RFC-0001: RFC Process]()
    * [RFC-0002: Operating System Development Kit (OSDK)]()
