# The class `LLM_model` defines methods for generating text and describing images using the Ollama
# API.
import ollama
from io import BytesIO
from flet import *


# The `LLM_model` class defines methods for generating text responses using Ollama models based on
# prompts and describing images with additional context using language models.
class LLM_model():
    def __init__(self , llm: ollama ):
        super().__init__()
        
        self.model = 'prompt:latest'
        self.llava_model = 'pocket_llava:latest'
        self.respo = ''

        
        
        
        
    def generate(self, prompt)  -> str:
        """
        The function `generate` takes a prompt as input, uses the Ollama model to generate a response, and
        returns the generated response as a string.
        
        :param prompt: The `generate` method takes a prompt as input and uses it to generate a response
        using the `ollama` model specified in the `self.model` attribute. The response is generated in a
        streaming manner (`stream=True`). The generated response is stored in the `self.resp` attribute and
        then returned
        :return: The `generate` method is returning the response generated by the `ollama.generate` function
        based on the provided prompt.
        """
        self.respo = ollama.generate(
            model=  self.model,
            prompt= prompt,
            stream= True
        )
        return self.respo
    
    def Image_describe(self, image , prompt) -> str:
        """
        This Python function `Image_describe` takes an image and a prompt as input, generates a description
        of the image using a language model, and returns the description as a string.
        
        :param image: The `image` parameter in the `Image_describe` method is the image file that you want
        to describe. It is passed as an input to the method for processing and generating a description
        based on the image content
        :param prompt: The `prompt` parameter in the `Image_describe` method is a string that contains
        details or instructions for generating a description of the image. It is used in the OpenAI's GPT-3
        model to provide context or additional information for generating a description based on the image
        provided
        :return: The `Image_describe` method returns a string that contains a description generated by the
        `ollama` model based on the input image and prompt provided.
        """
        img_bytes =self.read_image(image)
        
        self.describe = ollama.generate(
            model= self.llava_model,
            prompt= f'with details in this photo give me stable diffusion prompt with this details : {prompt}',
            stream=True,
            images=[img_bytes],
        ) 
        return self.describe
    


    def read_image(self, file_path):
        """
        The `read_image` function reads an image file in binary mode and returns the image bytes.
        
        :param file_path: The `file_path` parameter in the `read_image` function is a string that represents
        the path to the image file that you want to read. This function reads the image file in binary mode
        and returns the bytes of the image data
        :return: The function `read_image` reads an image file in binary mode and returns the bytes of the
        image.
        """
        with open(file_path, "rb") as file:
            image_bytes = file.read()
        return image_bytes

