# ReadMe Creator Using LLM

[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

Welcome to the ReadMe Creator! This tool simplifies the process of generating interactive README files.

## Features

- Quickly create README templates.
- Customize templates with user-friendly prompts.
- Generate interactive and visually appealing README files.

## Getting Started

1. Clone this repository:

```bash
git clone https://github.com/ashishpatel26/readme-creator-with-LLM.git
cd readme-creator
```

2. Install the required dependencies:

```bash
pip install -r requirements.txt
```

3. Set up your OpenAI API key by exporting it as an environment variable:

```bash
export OPEN_AI_KEY=your_openai_key_here

```

## Usage

Run the following command to start the ReadMe creator:

```bash
python src/readme_creator.py
```

Follow the prompts to customize your README template. The tool will generate an interactive README.md file in the root directory.

## Examples

Check out the `examples/` directory for pre-designed README templates and their corresponding output.

## Contributing

We welcome contributions! Feel free to submit pull requests.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
