# macOS and iOS Security Related Tools [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

[![Test](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/test.yaml/badge.svg)](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/test.yaml)
[![Lint Markdown](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-markdown.yaml/badge.svg)](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-markdown.yaml)
[![Lint Shell scripts](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-shell-script.yaml/badge.svg)](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-shell-script.yaml)
[![Lint YAML](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-yaml.yaml/badge.svg)](https://github.com/ashishb/osx-and-ios-security-awesome/actions/workflows/lint-yaml.yaml)

## Contents

- [macOS and iOS Security Related Tools](#macos-and-ios-security-related-tools--)
   - [Contents](#contents)
   - [macOS Security](#macos-security)
   - [iOS Security](#ios-security)
   - [iOS Jailbreaks](#ios-jailbreaks)
      - [Other Awesome Lists](#other-awesome-lists)
   - [License](#license)

## macOS Security

1. [OSX collector](https://github.com/Yelp/OSXCollector) - Forensic analysis.
1. [OSX auditor](https://github.com/jipegit/OSXAuditor) - Forensic analysis.
1. [mac_apt](https://github.com/ydkhatri/mac_apt) - macOS Artifact Parsing Tool for forensic analysis.
1. [MIDAS](https://github.com/etsy/MIDAS) - macOS Intrusion Detection Analysis System.
1. [Santa](https://github.com/google/santa) - Binary whitelisting/blacklisting system.
1. [Masochist](https://github.com/squiffy/Masochist) - Framework for creating XNU based rootkits.
1. [Class-dump](http://stevenygard.com/projects/class-dump/) - Command-line utility to dump Objective-C runtime information.
1. [Mach inject](https://github.com/rentzsch/mach_inject) - Inter process code injection for macOS.
1. [Task vaccine](https://github.com/rodionovd/task_vaccine) - Similar to mach inject.
1. [Hopper](http://www.hopperapp.com/) - Hopper disassembler (not free).
1. [Mach-O diff](https://github.com/samdmarshall/machodiff) - Mach-o diffing tool.
1. [Mac4n6](https://github.com/pstirparo/mac4n6) - A collection of macOS and iOS forensic artifacts.
1. [XGuardian scanner](https://github.com/openscanner/XGuardian) - Security Scanner for macOS.
1. [Crashwalk](https://github.com/bnagy/crashwalk) - Bucket and triage on-disk crashes
1. [PassiveFuzzFrameworks](https://github.com/SilverMoonSecurity/PassiveFuzzFrameworkOSX)
1. [osquery](https://github.com/facebook/osquery) - Cross-platform tool for data collection and forensic analysis.
1. [stronghold](https://github.com/alichtman/stronghold) - Easily configure macOS security settings from the terminal.
1. [BlockBlock](https://objective-see.com/products/blockblock.html) - BlockBlock continually monitors common persistence locations and displays an alert whenever a persistent component is added to the OS.
1. [Dylib Hijack Scanner](https://objective-see.com/products/dhs.html) - Simple utility that will scan your computer for applications that are either susceptible to dylib hijacking or have been hijacked.
1. [KextViewer](https://objective-see.com/products/kextviewr.html) - View all modules on that are loaded in the OS kernel.
1. [KnockKnock](https://objective-see.com/products/knockknock.html) - See what's persistently installed on your Mac.
1. [LinkLiar](http://halo.github.io/LinkLiar) -  Link-Layer MAC spoofing GUI for macOS.
1. [LockDown](https://objective-see.com/products/lockdown.html) - Open-source tool for El Capitan that audits and remediates security configuration settings.
1. [MalwareBytes](https://www.malwarebytes.com/mac-download/) - Malwarebytes crushes the growing threat of Mac malware, so you are protected and your machine keeps running silky smooth. Cybersecurity smart enough for the Mac.
1. [OverSight](https://objective-see.com/products/oversight.html) - Monitor mic and webcam, alerting you when the internal mic is activated, or whenever a process accesses the webcam.
1. [RansomWhere?](https://objective-see.com/products/ransomwhere.html) - Ransomware Detection.
1. [TaskExplorer](https://objective-see.com/products/taskexplorer.html) - Explore all processes running on your Mac with TaskExplorer.
1. [What's Your Sign?](https://objective-see.com/products/whatsyoursign.html) - Adds menu item to Finder.app to display the cryptographic signing information for any file.
1. [FSMonitor](http://fsmonitor.com/) - Monitor all changes in the file system.
1. [Pareto Security](https://github.com/paretoSecurity/pareto-mac/) - A MenuBar app to automatically audit your Mac for basic security hygiene.
1. [Mana Security](https://github.com/manasecurity/mana-security-app) - Vulnerability Management app for individuals. It helps to keep macOS and installed applications updated.
1. [swiftGuard](https://github.com/Lennolium/swiftGuard) - Lightweight App that safeguards your System's USB Ports from any Unauthorized Access and performs various Counter-Measures.
1. [Pareto Security](https://paretosecurity.app/) - A MenuBar app to automatically audit your Mac for basic security hygiene.

## iOS Security

A collection of ios security related resources

1. [IDB](https://github.com/dmayer/idb) - iOS App Security Assessment Tool
1. [iRET](https://github.com/S3Jensen/iRET) - iOS Reverse Engineering Toolkit
1. [DVIA](http://damnvulnerableiosapp.com/) - Damn Vulnerable iOS App for learning
1. [DVIA v2](https://github.com/prateek147/DVIA-v2) - Damn Vulnerable iOS App v2 for learning
1. [LibiMobileDevice](https://github.com/libimobiledevice/libimobiledevice) - A cross-platform protocol library to communicate with iOS devices
1. [Needle](https://github.com/mwrlabs/needle) - iOS App Pentesting Tool
1. [imobax](https://github.com/Siguza/imobax) - iOS Mobile Backup Extractor
1. [iMessage Fuzzing](https://github.com/googleprojectzero/iOS-messaging-tools) - iMessage fuzzing tools from Google's Project Zero
1. [Themis](https://github.com/cossacklabs/themis) - a multi-platform programming library for solving typical data security tasks: secure data storage, secure messaging, zero-knowledge proof authentication, etc. Recommended by OWASP MASVS.
1. [NowSecure Lab Automated](https://www.nowsecure.com/blog/2016/09/19/announcing-nowsecure-lab-automated/) - Enterprise tool for mobile app security testing both iOS and Android mobile apps. Lab Automated features dynamic and static analysis on real devices in the cloud to return results in minutes.
1. ~~[AppCritique](https://appcritique.boozallen.com) - iOS App Security Assessment Tool~~

## iOS Jailbreaks

1. [CFW Guide](https://ios.cfw.guide) - A complete iOS jailbreaking guide, from stock to jailbroken.
1. [Dopamine](https://ellekit.space/dopamine) - Rootless Jailbreak for iOS 15.0 - 16.6.1, A8 - A16, and M1 - M2.
1. [Nathanlr](https://nathan4s.lol/nathanlr/nathanlr.tipa) - Rootless Semi-Jailbreak for 16.5.1-16.6.1.
1. [Taurine](https://taurine.app) - Rootful Jailbreak for iOS 14.0 - 14.8.1.
1. [Odyssey](https://theodyssey.dev) - Rootful Jailbreak for iOS 13.0 - 13.7.
1. [Chimera](https://chimera.coolstar.org) - Rootful Jailbreak for iOS 12 — 12.5.7.
1. [Electra](https://coolstar.org/electra) - Rootful Jailbreak for 11.0 – 11.4.1.
1. [TotallyNotSpyware](https://totally.not.spyware.lol) - Rootful Jailbreak for iOS 10.0 - 10.3.3 64-bit devices.
1. [kok3shi9all](https://kok3shidoll.web.app/kok3shi9.html) Rootful Jailbreak for 9.3.2 - 9.3.6, as well as 64-bit devices on 9.2 - 9.3.1.
1. [PhoenixPwn](https://phoenixpwn.com) - Rootful Jailbreak for 9.3.5 32-bit devices.

### Other Awesome Lists

Other amazingly awesome lists can be found in the
[awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness) list.

---

## License

[![Creative Commons License](https://licensebuttons.net/l/by-sa/4.0/88x31.png)](https://creativecommons.org/licenses/by-sa/4.0/)

This work is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International License](https://creativecommons.org/licenses/by-sa/4.0/).
