# Real Estate Project - CampusX

<p align="center">
<img src="https://raw.githubusercontent.com/arv-anshul/campusx-real-estate/main/assets/house_with_garden.png" height="100px">
<img src="https://raw.githubusercontent.com/arv-anshul/campusx-real-estate/main/assets/house_buildings.png" height="100px">
<img src="https://raw.githubusercontent.com/arv-anshul/campusx-real-estate/main/assets/house.png" height="100px">
</p>

> [!IMPORTANT]
>
> **Disclaimer:** I used 99acres.com data in this project and I used those data for educational purpose only.

### Features

- **Price Prediction** system for different types of properties like _Residential Apartments, Rental Apartment, Independent Floors, Independent Houses, Residential Houses._
- **Analytics Page** which shows some interesting insights regarding the Real Estate of a particular City of India or a Locality of that City.
- You can **Add a New City** _(for example: **Your City**)_ on the website and then you can make price prediction and get analytics on your city data.
- You can **Download Resources** which are being used in the project like datasets and ML models. And if you want the project's code you can get it [here](https://github.com/arv-anshul/campusx-real-estate).

## Tech Stack

|                 Tech | Stack                       |
| -------------------: | :-------------------------- |
| Programming Language | Python                      |
|      Version Control | Git & GitHub                |
|        Data Analysis | Pandas, Numpy               |
|        Visualization | Matplotlib, Seaborn, Plotly |
|     Machine Learning | Scikit-Learn                |
|   Frontend & Backend | Streamlit                   |
|                Extra | Pydantic                    |

## Installation

1. Clone this repo in your local system.
2. **Create a virtual environment** and install the requirements of this project using below command:

```sh
pip install -r requirements.txt
```

3. Run the streamlit app.

```sh
streamlit run Real_Estate_Project.py
```

## Acknowledgements

- [99acres.com](https://99acres.com/): I used this website to gather the data for this project.
- [@arv-anshul/99acres-scrape](https://github.com/arv-anshul/99acres-scrape): Used this Streamlit web-app to scrape data from 99acres.com website.
- [CampusX DSMP](https://learnwith.campusx.com): I take inspirations and follow this course's **Capstone Project**.

## License

[MIT](https://choosealicense.com/licenses/mit/)
