import {Identifier} from './scalars'
import { gql } from '@apollo/client';
import * as Apollo from '@apollo/client';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
const defaultOptions = {} as const;
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  Any: any;
  AnyInput: any;
  DateTime: any;
  GenericScalar: any;
  Identifier: Identifier;
  QString: any;
  SearchQuery: any;
  UUID: any;
};

export type Agent = {
  __typename?: 'Agent';
  /** If this Agent is blocked, it will not be used for provision, nor will it be able to provide */
  blocked: Scalars['Boolean'];
  clientId: Scalars['String'];
  id: Scalars['ID'];
  installedAt: Scalars['DateTime'];
  instanceId: Scalars['String'];
  /** This providers Name */
  name: Scalars['String'];
  /** The Instance this Agent is running on */
  onInstance: Scalars['String'];
  /** Is this Provision bound to a certain Agent? */
  provisions: Array<Provision>;
  /** The provide might be limited to a instance like ImageJ belonging to a specific person. Is nullable for backend users */
  registry?: Maybe<Registry>;
  /** The Status of this Agent */
  status: AgentStatus;
  /** The associated registry for this Template */
  templates: Array<Template>;
  /** The Channel we are listening to */
  unique: Scalars['String'];
};

export type AgentEvent = {
  __typename?: 'AgentEvent';
  created?: Maybe<Agent>;
  deleted?: Maybe<Scalars['ID']>;
  updated?: Maybe<Agent>;
};

/** An enumeration. */
export enum AgentStatus {
  /** Active */
  Active = 'ACTIVE',
  /** Disconnected */
  Disconnected = 'DISCONNECTED',
  /** Just kicked */
  Kicked = 'KICKED',
  /** Complete Vanilla Scenario after a forced restart of */
  Vanilla = 'VANILLA'
}

/** An enumeration. */
export enum AgentStatusInput {
  /** Active */
  Active = 'ACTIVE',
  /** Disconnected */
  Disconnected = 'DISCONNECTED',
  /** Just kicked */
  Kicked = 'KICKED',
  /** Complete Vanilla Scenario after a forced restart of */
  Vanilla = 'VANILLA'
}

export type Annotation = {
  /** The name of the annotation */
  kind?: Maybe<Scalars['String']>;
};

export type AnnotationInput = {
  /** The annotation of this annotation */
  annotations?: InputMaybe<Array<InputMaybe<AnnotationInput>>>;
  /** The value of this annotation */
  args?: InputMaybe<Scalars['String']>;
  /** The attribute to check */
  attribute?: InputMaybe<Scalars['String']>;
  /** A hook for the app to call */
  hook?: InputMaybe<Scalars['String']>;
  /** The kind of annotation */
  kind: AnnotationKind;
  /** The max of this annotation (Value Range) */
  max?: InputMaybe<Scalars['Float']>;
  /** The min of this annotation (Value Range) */
  min?: InputMaybe<Scalars['Float']>;
  /** The name of this annotation */
  name?: InputMaybe<Scalars['String']>;
  /** The predicate of this annotation (IsPredicate) */
  predicate?: InputMaybe<IsPredicateType>;
};

/** The kind of annotation */
export enum AnnotationKind {
  AttributePredicate = 'AttributePredicate',
  CustomAnnotation = 'CustomAnnotation',
  IsPredicate = 'IsPredicate',
  ValueRange = 'ValueRange'
}

export type AppRepository = Repository & {
  __typename?: 'AppRepository';
  /** The Associated App */
  app?: Maybe<LokApp>;
  /** Id of the Repository */
  id: Scalars['ID'];
  installedAt: Scalars['DateTime'];
  /** The Name of the Repository */
  name?: Maybe<Scalars['String']>;
  nodes?: Maybe<Array<Maybe<Node>>>;
  type: RepositoryType;
  /** A world-unique identifier */
  unique: Scalars['String'];
};


export type AppRepositoryNodesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};

export type Assignation = {
  __typename?: 'Assignation';
  /** The app is this assignation */
  app?: Maybe<LokApp>;
  args?: Maybe<Array<Maybe<Scalars['Any']>>>;
  /** The Assignations parent */
  children: Array<Assignation>;
  context?: Maybe<Scalars['GenericScalar']>;
  createdAt: Scalars['DateTime'];
  /** The creator is this assignation */
  creator?: Maybe<User>;
  id: Scalars['ID'];
  kwargs?: Maybe<Scalars['GenericScalar']>;
  log?: Maybe<Array<Maybe<AssignationLog>>>;
  /** The Assignations parent */
  parent?: Maybe<Assignation>;
  /** The progress of this assignation */
  progress?: Maybe<Scalars['Int']>;
  /** Which Provision did we end up being assigned to */
  provision?: Maybe<Provision>;
  /** The Unique identifier of this Assignation considering its parent */
  reference: Scalars['String'];
  /** Which reservation are we assigning to */
  reservation?: Maybe<Reservation>;
  returns?: Maybe<Array<Maybe<Scalars['Any']>>>;
  /** Current lifecycle of Assignation */
  status: AssignationStatus;
  /** Clear Text status of the Assignation as for now */
  statusmessage: Scalars['String'];
  updatedAt: Scalars['DateTime'];
  /** This Assignation app */
  waiter?: Maybe<Waiter>;
};


export type AssignationLogArgs = {
  createdAt?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  level?: InputMaybe<LogLevelInput>;
  o?: InputMaybe<Scalars['String']>;
};

export type AssignationEvent = {
  __typename?: 'AssignationEvent';
  log?: Maybe<AssignationLogEvent>;
};

export type AssignationLog = {
  __typename?: 'AssignationLog';
  /** The reservation this log item belongs to */
  assignation: Assignation;
  createdAt: Scalars['DateTime'];
  id: Scalars['ID'];
  level: AssignationLogLevel;
  message?: Maybe<Scalars['String']>;
};

export type AssignationLogEvent = {
  __typename?: 'AssignationLogEvent';
  level?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
};

/** An enumeration. */
export enum AssignationLogLevel {
  /** Cancel Level */
  Cancel = 'CANCEL',
  /** CRITICAL Level */
  Critical = 'CRITICAL',
  /** DEBUG Level */
  Debug = 'DEBUG',
  /** Done Level */
  Done = 'DONE',
  /** ERROR Level */
  Error = 'ERROR',
  /** Event Level (only handled by plugins) */
  Event = 'EVENT',
  /** INFO Level */
  Info = 'INFO',
  /** YIELD Level */
  Return = 'RETURN',
  /** WARN Level */
  Warn = 'WARN',
  /** YIELD Level */
  Yield = 'YIELD'
}

/** An enumeration. */
export enum AssignationStatus {
  /** Acknowledged */
  Acknowledged = 'ACKNOWLEDGED',
  /** Was able to assign to a pod */
  Assigned = 'ASSIGNED',
  /** Bound */
  Bound = 'BOUND',
  /** Assinment is beeing cancelled */
  Cancel = 'CANCEL',
  /** Cancelling (Assingment is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Assignment has been cancelled. */
  Cancelled = 'CANCELLED',
  /** Critical Error (No Retries available) */
  Critical = 'CRITICAL',
  /** Denied (Assingment was rejected) */
  Denied = 'DENIED',
  /** Assignment has finished */
  Done = 'DONE',
  /** Error (Retrieable) */
  Error = 'ERROR',
  /** Pending */
  Pending = 'PENDING',
  /** Progress (Assignment has current Progress) */
  Progress = 'PROGRESS',
  /** Received (Assignment was received by an agent) */
  Received = 'RECEIVED',
  /** Assignation Returned (Only for Functions) */
  Returned = 'RETURNED',
  /** Assignment yielded a value (only for Generators) */
  Yield = 'YIELD'
}

/** An enumeration. */
export enum AssignationStatusInput {
  /** Acknowledged */
  Acknowledged = 'ACKNOWLEDGED',
  /** Was able to assign to a pod */
  Assigned = 'ASSIGNED',
  /** Bound */
  Bound = 'BOUND',
  /** Assinment is beeing cancelled */
  Cancel = 'CANCEL',
  /** Cancelling (Assingment is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Assignment has been cancelled. */
  Cancelled = 'CANCELLED',
  /** Critical Error (No Retries available) */
  Critical = 'CRITICAL',
  /** Denied (Assingment was rejected) */
  Denied = 'DENIED',
  /** Assignment has finished */
  Done = 'DONE',
  /** Error (Retrieable) */
  Error = 'ERROR',
  /** Pending */
  Pending = 'PENDING',
  /** Progress (Assignment has current Progress) */
  Progress = 'PROGRESS',
  /** Received (Assignment was received by an agent) */
  Received = 'RECEIVED',
  /** Assignation Returned (Only for Functions) */
  Returned = 'RETURNED',
  /** Assignment yielded a value (only for Generators) */
  Yield = 'YIELD'
}

export type AssignationsEvent = {
  __typename?: 'AssignationsEvent';
  create?: Maybe<Assignation>;
  delete?: Maybe<Scalars['ID']>;
  update?: Maybe<Assignation>;
};

/** A predicate that checks if an atribute fullfills a certain condition  */
export type AttributePredicate = Annotation & {
  __typename?: 'AttributePredicate';
  /** The annotations for this attribute */
  annotations?: Maybe<Array<Maybe<Annotation>>>;
  /** The attribute to check */
  attribute: Scalars['String'];
  /** The name of the annotation */
  kind?: Maybe<Scalars['String']>;
};

export type Binds = {
  __typename?: 'Binds';
  /** The clients of this bind */
  clients?: Maybe<Array<Maybe<LokClient>>>;
  /** The templates of this bind */
  templates?: Maybe<Array<Maybe<Template>>>;
};

export type BoolWidget = Widget & {
  __typename?: 'BoolWidget';
  kind: Scalars['String'];
};

export type ChangePermissionsResult = {
  __typename?: 'ChangePermissionsResult';
  message?: Maybe<Scalars['String']>;
  success?: Maybe<Scalars['Boolean']>;
};

export type ChildPort = {
  __typename?: 'ChildPort';
  /** The annotations of this port */
  annotations?: Maybe<Array<Maybe<Annotation>>>;
  /** Description of the Widget */
  assignWidget?: Maybe<Widget>;
  /** The child */
  child?: Maybe<ChildPort>;
  default?: Maybe<Scalars['Any']>;
  /** The corresponding Model */
  identifier?: Maybe<Scalars['Identifier']>;
  /** the type of input */
  kind: PortKind;
  /** Is this argument nullable */
  nullable: Scalars['Boolean'];
  /** A return widget */
  returnWidget?: Maybe<ReturnWidget>;
  /** The scope of this port */
  scope: Scope;
  /** The varients of this port (only for unions) */
  variants?: Maybe<Array<Maybe<ChildPort>>>;
};

export type ChildPortInput = {
  /** The annotations of this argument */
  annotations?: InputMaybe<Array<InputMaybe<AnnotationInput>>>;
  /** The child of this argument */
  assignWidget?: InputMaybe<WidgetInput>;
  /** The child port */
  child?: InputMaybe<ChildPortInput>;
  /** The identifier */
  identifier?: InputMaybe<Scalars['Identifier']>;
  /** The type of this port */
  kind?: InputMaybe<PortKindInput>;
  /** The name of this port */
  name?: InputMaybe<Scalars['String']>;
  /** Is this argument nullable */
  nullable: Scalars['Boolean'];
  /** The child of this argument */
  returnWidget?: InputMaybe<ReturnWidgetInput>;
  /** The scope of this port */
  scope: Scope;
  /** The varients of this port (only for union) */
  variants?: InputMaybe<Array<InputMaybe<ChildPortInput>>>;
};

export type Choice = {
  __typename?: 'Choice';
  description?: Maybe<Scalars['String']>;
  label: Scalars['String'];
  value: Scalars['GenericScalar'];
};

export type ChoiceInput = {
  description?: InputMaybe<Scalars['String']>;
  label: Scalars['String'];
  value: Scalars['AnyInput'];
};

export type ChoiceReturnWidget = ReturnWidget & {
  __typename?: 'ChoiceReturnWidget';
  /** A list of choices */
  choices?: Maybe<Array<Maybe<Choice>>>;
  kind: Scalars['String'];
};

export type ChoiceWidget = Widget & {
  __typename?: 'ChoiceWidget';
  /** A list of choices */
  choices?: Maybe<Array<Maybe<Choice>>>;
  kind: Scalars['String'];
};

export type Collection = {
  __typename?: 'Collection';
  definedAt: Scalars['DateTime'];
  /** A description for the Collection */
  description: Scalars['String'];
  id: Scalars['ID'];
  /** The name of this Collection */
  name: Scalars['String'];
  /** The nodes this collection has */
  nodes?: Maybe<Array<Maybe<Node>>>;
};


export type CollectionNodesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};

export type ColorWidget = Widget & {
  __typename?: 'ColorWidget';
  kind: Scalars['String'];
  /** A start date */
  startDate?: Maybe<Scalars['String']>;
};

/**
 * A comment
 *
 * A comment is a user generated comment on a commentable object. A comment can be a reply to another comment or a top level comment.
 * Comments can be nested to any depth. A comment can be edited and deleted by the user that created it.
 */
export type Comment = {
  __typename?: 'Comment';
  /** Comments that are replies to this comment */
  children?: Maybe<Array<Maybe<Comment>>>;
  /** The content type of the commentable object */
  contentType?: Maybe<CommentableModels>;
  createdAt: Scalars['DateTime'];
  /** The descendents of the comment (this referes to the Comment Tree) */
  descendents?: Maybe<Array<Maybe<Descendent>>>;
  id: Scalars['ID'];
  mentions: Array<User>;
  objectId: Scalars['Int'];
  parent?: Maybe<Comment>;
  resolved?: Maybe<Scalars['DateTime']>;
  resolvedBy?: Maybe<User>;
  text: Scalars['String'];
  user: User;
};


/**
 * A comment
 *
 * A comment is a user generated comment on a commentable object. A comment can be a reply to another comment or a top level comment.
 * Comments can be nested to any depth. A comment can be edited and deleted by the user that created it.
 */
export type CommentChildrenArgs = {
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
};

/** A node in the comment tree */
export type CommentNode = {
  children?: Maybe<Array<Maybe<Descendent>>>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
};

export enum CommentableModels {
  FacadeAgent = 'FACADE_AGENT',
  FacadeApprepository = 'FACADE_APPREPOSITORY',
  FacadeAssignation = 'FACADE_ASSIGNATION',
  FacadeAssignationlog = 'FACADE_ASSIGNATIONLOG',
  FacadeCollection = 'FACADE_COLLECTION',
  FacadeMirrorrepository = 'FACADE_MIRRORREPOSITORY',
  FacadeNode = 'FACADE_NODE',
  FacadeProtocol = 'FACADE_PROTOCOL',
  FacadeProvision = 'FACADE_PROVISION',
  FacadeProvisionlog = 'FACADE_PROVISIONLOG',
  FacadeRegistry = 'FACADE_REGISTRY',
  FacadeRepository = 'FACADE_REPOSITORY',
  FacadeReservation = 'FACADE_RESERVATION',
  FacadeReservationlog = 'FACADE_RESERVATIONLOG',
  FacadeStructure = 'FACADE_STRUCTURE',
  FacadeTemplate = 'FACADE_TEMPLATE',
  FacadeTestcase = 'FACADE_TESTCASE',
  FacadeTestresult = 'FACADE_TESTRESULT',
  FacadeWaiter = 'FACADE_WAITER'
}

export type CreateMirrorReturn = {
  __typename?: 'CreateMirrorReturn';
  created?: Maybe<Scalars['Boolean']>;
  repo?: Maybe<MirrorRepository>;
};

export type CustomAnnotation = Annotation & {
  __typename?: 'CustomAnnotation';
  /** The arguments for this annotation */
  args?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** The hook for this annotation */
  hook: Scalars['String'];
  /** The name of the annotation */
  kind?: Maybe<Scalars['String']>;
};

export type CustomReturnWidget = ReturnWidget & {
  __typename?: 'CustomReturnWidget';
  /** A hook for the app to call */
  hook?: Maybe<Scalars['String']>;
  kind: Scalars['String'];
  /** A hook for the app to call */
  ward?: Maybe<Scalars['String']>;
};

export type CustomWidget = Widget & {
  __typename?: 'CustomWidget';
  /** A hook for the ward to call */
  hook?: Maybe<Scalars['String']>;
  kind: Scalars['String'];
  /** A ward for the app to call */
  ward?: Maybe<Scalars['String']>;
};

export type DateWidget = Widget & {
  __typename?: 'DateWidget';
  kind: Scalars['String'];
  /** A start date */
  startDate?: Maybe<Scalars['String']>;
};

/** A definition for a template */
export type DefinitionInput = {
  /** The Args */
  args: Array<InputMaybe<PortInput>>;
  collections?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  /** A description for the Node */
  description?: InputMaybe<Scalars['String']>;
  idempotent?: InputMaybe<Scalars['Boolean']>;
  /** The Interfaces this node provides makes sense of the metadata */
  interfaces: Array<InputMaybe<Scalars['String']>>;
  /** The nodes this is a test for */
  isTestFor?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** The variety */
  kind: NodeKindInput;
  /** The name of this template */
  name: Scalars['String'];
  portGroups: Array<InputMaybe<PortGroupInput>>;
  pure?: InputMaybe<Scalars['Boolean']>;
  /** The Returns */
  returns: Array<InputMaybe<PortInput>>;
};

export type DeleteAgentReturn = {
  __typename?: 'DeleteAgentReturn';
  id?: Maybe<Scalars['String']>;
};

export type DeleteNodeReturn = {
  __typename?: 'DeleteNodeReturn';
  id?: Maybe<Scalars['String']>;
};

export type DeleteRepoReturn = {
  __typename?: 'DeleteRepoReturn';
  id?: Maybe<Scalars['String']>;
};

export type DeleteTestCaseResult = {
  __typename?: 'DeleteTestCaseResult';
  id?: Maybe<Scalars['String']>;
};

export type Dependency = {
  __typename?: 'Dependency';
  /** The condition of the dependency */
  condition: LogicalCondition;
  /** The key of the port (null should be self) */
  key?: Maybe<Scalars['String']>;
  value: Scalars['GenericScalar'];
};

export type DependencyInput = {
  /** The condition of the dependency */
  condition: LogicalCondition;
  /** The key of the port, defaults to self */
  key?: InputMaybe<Scalars['String']>;
  value: Scalars['AnyInput'];
};

export type DescendendInput = {
  /** Is this a bold leaf? */
  bold?: InputMaybe<Scalars['Boolean']>;
  children?: InputMaybe<Array<InputMaybe<DescendendInput>>>;
  /** Is this a code leaf? */
  code?: InputMaybe<Scalars['Boolean']>;
  /** Is this a italic leaf? */
  italic?: InputMaybe<Scalars['Boolean']>;
  /** The text of the leaf */
  text?: InputMaybe<Scalars['String']>;
  /** The type of the descendent */
  typename?: InputMaybe<Scalars['String']>;
  /** The user that is mentioned */
  user?: InputMaybe<Scalars['String']>;
};

/** A descendent of a node in the comment tree */
export type Descendent = {
  typename?: Maybe<Scalars['String']>;
};

export type Effect = {
  __typename?: 'Effect';
  /** The dependencies of this effect */
  dependencies?: Maybe<Array<Maybe<Dependency>>>;
  /** The condition of the dependency */
  kind: EffectKind;
  message?: Maybe<Scalars['String']>;
};

export type EffectInput = {
  /** The dependencies of this effect */
  dependencies?: InputMaybe<Array<InputMaybe<DependencyInput>>>;
  /** The condition of the dependency */
  kind: EffectKind;
  message?: InputMaybe<Scalars['String']>;
};

export enum EffectKind {
  Crazy = 'CRAZY',
  Hidden = 'HIDDEN',
  Highlight = 'HIGHLIGHT',
  Warn = 'WARN'
}

export type Group = {
  __typename?: 'Group';
  id: Scalars['ID'];
  name: Scalars['String'];
  permissions: Array<Permission>;
  /** The groups this user belongs to. A user will get all permissions granted to each of their groups. */
  userSet: Array<User>;
};

export type GroupAssignment = {
  __typename?: 'GroupAssignment';
  /** A query that returns an image path */
  group: Group;
  permissions: Array<Maybe<Scalars['String']>>;
};

export type GroupAssignmentInput = {
  group: Scalars['ID'];
  permissions: Array<InputMaybe<Scalars['String']>>;
};

export type ImageReturnWidget = ReturnWidget & {
  __typename?: 'ImageReturnWidget';
  kind: Scalars['String'];
  /** A query that returns an image path */
  query?: Maybe<Scalars['String']>;
  /** A hook for the app to call */
  ward?: Maybe<Scalars['String']>;
};

export type IntWidget = Widget & {
  __typename?: 'IntWidget';
  kind: Scalars['String'];
  /** A Complex description */
  query?: Maybe<Scalars['String']>;
};

export type IsPredicate = Annotation & {
  __typename?: 'IsPredicate';
  /** The name of the annotation */
  kind?: Maybe<Scalars['String']>;
  /** The arguments for this annotation */
  predicate: IsPredicateType;
};

export enum IsPredicateType {
  Digit = 'DIGIT',
  Higher = 'HIGHER',
  Lower = 'LOWER'
}

/** A leaf in the comment tree. Representations some sort of text */
export type Leaf = Descendent & {
  __typename?: 'Leaf';
  /** Is this a bold leaf? */
  bold?: Maybe<Scalars['Boolean']>;
  /** Is this a code leaf? */
  code?: Maybe<Scalars['Boolean']>;
  /** Is this a italic leaf? */
  italic?: Maybe<Scalars['Boolean']>;
  /** The text of the leaf */
  text?: Maybe<Scalars['String']>;
  typename?: Maybe<Scalars['String']>;
};

export type LinkWidget = Widget & {
  __typename?: 'LinkWidget';
  kind: Scalars['String'];
  /** A Complex description */
  linkbuilder?: Maybe<Scalars['String']>;
};

/** An enumeration. */
export enum LogLevelInput {
  /** Cancel Level */
  Cancel = 'CANCEL',
  /** CRITICAL Level */
  Critical = 'CRITICAL',
  /** DEBUG Level */
  Debug = 'DEBUG',
  /** Done Level */
  Done = 'DONE',
  /** ERROR Level */
  Error = 'ERROR',
  /** Event Level (only handled by plugins) */
  Event = 'EVENT',
  /** INFO Level */
  Info = 'INFO',
  /** YIELD Level */
  Return = 'RETURN',
  /** WARN Level */
  Warn = 'WARN',
  /** YIELD Level */
  Yield = 'YIELD'
}

export enum LogicalCondition {
  In = 'IN',
  Is = 'IS',
  IsNot = 'IS_NOT'
}

export type LokApp = {
  __typename?: 'LokApp';
  /** The Associated App */
  apprepositorySet: Array<AppRepository>;
  /** The app is this assignation */
  assignationSet: Array<Assignation>;
  id: Scalars['ID'];
  identifier: Scalars['String'];
  lokclientSet: Array<LokClient>;
  /** This provision creator */
  provisionSet: Array<Provision>;
  /** The Associated App */
  registrySet: Array<Registry>;
  /** This Reservations app */
  reservationSet: Array<Reservation>;
  version: Scalars['String'];
};

export type LokClient = {
  __typename?: 'LokClient';
  app: LokApp;
  clientId: Scalars['String'];
  grantType: LokClientGrantType;
  id: Scalars['ID'];
  iss: Scalars['String'];
  name: Scalars['String'];
  registrySet: Array<Registry>;
};

/** An enumeration. */
export enum LokClientGrantType {
  /** Authorization Code */
  AuthorizationCode = 'AUTHORIZATION_CODE',
  /** Backend (Client Credentials) */
  ClientCredentials = 'CLIENT_CREDENTIALS',
  /** Implicit Grant */
  Implicit = 'IMPLICIT',
  /** Password */
  Password = 'PASSWORD',
  /** Django Session */
  Session = 'SESSION'
}

/** A mention in the comment tree. This  is a reference to another user on the platform */
export type MentionDescendent = CommentNode & Descendent & {
  __typename?: 'MentionDescendent';
  children?: Maybe<Array<Maybe<Descendent>>>;
  typename?: Maybe<Scalars['String']>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
  /** The user that is mentioned */
  user: User;
};

export type MentionEvent = {
  __typename?: 'MentionEvent';
  create?: Maybe<Comment>;
  deleted?: Maybe<Scalars['ID']>;
  update?: Maybe<Comment>;
};

export type MessageInput = {
  data: Scalars['AnyInput'];
  kind: MessageKind;
  reference: Scalars['String'];
  text: Scalars['String'];
};

export enum MessageKind {
  Assign = 'ASSIGN',
  Cancel = 'CANCEL',
  Tell = 'TELL',
  Terminate = 'TERMINATE'
}

export type MirrorRepository = Repository & {
  __typename?: 'MirrorRepository';
  /** Id of the Repository */
  id: Scalars['ID'];
  installedAt: Scalars['DateTime'];
  /** The Name of the Repository */
  name?: Maybe<Scalars['String']>;
  nodes?: Maybe<Array<Maybe<Node>>>;
  type: RepositoryType;
  /** A world-unique identifier */
  unique: Scalars['String'];
  updatedAt: Scalars['DateTime'];
  url?: Maybe<Scalars['String']>;
};


export type MirrorRepositoryNodesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};

/** The root Mutation */
export type Mutation = {
  __typename?: 'Mutation';
  ack?: Maybe<Assignation>;
  assign?: Maybe<Assignation>;
  /** Kick an agent (only signed in users) */
  blockAgent?: Maybe<Agent>;
  /** Kick an agent (only signed in users) */
  bounceAgent?: Maybe<Agent>;
  /** Creates a Sample */
  changePermissions?: Maybe<ChangePermissionsResult>;
  /**
   * Create an Comment
   *
   *     This mutation creates a comment. It takes a commentable_id and a commentable_type.
   *     If this is the first comment on the commentable, it will create a new comment thread.
   *     If there is already a comment thread, it will add the comment to the thread (by setting
   *     it's parent to the last parent comment in the thread).
   *
   *     CreateComment takes a list of Descendents, which are the comment tree. The Descendents
   *     are a recursive structure, where each Descendent can have a list of Descendents as children.
   *     The Descendents are either a Leaf, which is a text node, or a MentionDescendent, which is a
   *     reference to another user on the platform.
   *
   *     Please convert your comment tree to a list of Descendents before sending it to the server.
   *     TODO: Add a converter from a comment tree to a list of Descendents.
   *
   *
   *     (only signed in users)
   */
  createComment?: Maybe<Comment>;
  /** Create Repostiory */
  createMirror?: Maybe<CreateMirrorReturn>;
  createTemplate?: Maybe<Template>;
  /** Create Repostiory */
  createTestCase?: Maybe<TestCase>;
  /** Create Test Result */
  createTestResult?: Maybe<TestResult>;
  /** Deletes an agent (only signed in users) */
  deleteAgent?: Maybe<DeleteAgentReturn>;
  /** Create an experiment (only signed in users) */
  deleteNode?: Maybe<DeleteNodeReturn>;
  /**
   * Delete TestCase
   *
   *     This mutation deletes an TestCase and returns the deleted TestCase.
   */
  deleteTestCase?: Maybe<DeleteTestCaseResult>;
  /** Create an experiment (only signed in users) */
  deleterepo?: Maybe<DeleteRepoReturn>;
  /** Kick an agent (only signed in users) */
  kickAgent?: Maybe<Agent>;
  link?: Maybe<Provision>;
  /** Scan allows you to add Datapoints to your Arnheim Schema, this is only available to Admin users */
  provide?: Maybe<Provision>;
  purgeNodes?: Maybe<PurgeNodesReturn>;
  /**
   * Reply to an Comment
   *
   *     This mutation creates a comment. It takes a commentable_id and a commentable_type.
   *     If this is the first comment on the commentable, it will create a new comment thread.
   *     If there is already a comment thread, it will add the comment to the thread (by setting
   *     it's parent to the last parent comment in the thread).
   *
   *     CreateComment takes a list of Descendents, which are the comment tree. The Descendents
   *     are a recursive structure, where each Descendent can have a list of Descendents as children.
   *     The Descendents are either a Leaf, which is a text node, or a MentionDescendent, which is a
   *     reference to another user on the platform.
   *
   *     Please convert your comment tree to a list of Descendents before sending it to the server.
   *     TODO: Add a converter from a comment tree to a list of Descendents.
   *
   *
   *     (only signed in users)
   */
  replyTo?: Maybe<Comment>;
  reserve?: Maybe<Reservation>;
  /** Create Repostiory */
  resetAgents?: Maybe<ResetAgentsReturn>;
  /** Create Repostiory */
  resetAssignations?: Maybe<ResetAssignationsReturn>;
  /** Create Repostiory */
  resetNodes?: Maybe<ResetNodesReturn>;
  /** Create Repostiory */
  resetProvisions?: Maybe<ResetProvisionsReturn>;
  /** Create Repostiory */
  resetRepository?: Maybe<ResetRepositoryReturn>;
  /** Create Repostiory */
  resetReservations?: Maybe<ResetReservationsReturn>;
  /**
   * Create an Comment
   *
   *     This mutation resolves a comment. By resolving a comment, it will be marked as resolved,
   *     and the user that resolved it will be set as the resolver.
   *
   *     (only signed in users)
   */
  resolveComment?: Maybe<Comment>;
  slate?: Maybe<Array<Maybe<Scalars['ID']>>>;
  tell?: Maybe<Tell>;
  unassign?: Maybe<Assignation>;
  unlink?: Maybe<Provision>;
  unprovide?: Maybe<UnprovideReturn>;
  unreserve?: Maybe<UnreserveResult>;
  /** Create an experiment (only signed in users) */
  updateMirror?: Maybe<UpdateMirrorReturn>;
};


/** The root Mutation */
export type MutationAckArgs = {
  assignation: Scalars['ID'];
};


/** The root Mutation */
export type MutationAssignArgs = {
  args?: InputMaybe<Array<InputMaybe<Scalars['AnyInput']>>>;
  cached?: InputMaybe<Scalars['Boolean']>;
  log?: InputMaybe<Scalars['Boolean']>;
  parent?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
  reservation: Scalars['ID'];
};


/** The root Mutation */
export type MutationBlockAgentArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationBounceAgentArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationChangePermissionsArgs = {
  groupAssignments?: InputMaybe<Array<InputMaybe<GroupAssignmentInput>>>;
  object: Scalars['ID'];
  type: SharableModels;
  userAssignments?: InputMaybe<Array<InputMaybe<UserAssignmentInput>>>;
};


/** The root Mutation */
export type MutationCreateCommentArgs = {
  descendents: Array<InputMaybe<DescendendInput>>;
  object: Scalars['ID'];
  parent?: InputMaybe<Scalars['ID']>;
  type: CommentableModels;
};


/** The root Mutation */
export type MutationCreateMirrorArgs = {
  name: Scalars['String'];
  url: Scalars['String'];
};


/** The root Mutation */
export type MutationCreateTemplateArgs = {
  definition: DefinitionInput;
  extensions?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  imitate?: InputMaybe<Scalars['ID']>;
  instanceId: Scalars['ID'];
  interface: Scalars['String'];
  params?: InputMaybe<Scalars['GenericScalar']>;
  policy?: InputMaybe<Scalars['GenericScalar']>;
};


/** The root Mutation */
export type MutationCreateTestCaseArgs = {
  description?: InputMaybe<Scalars['String']>;
  isBenchmark?: InputMaybe<Scalars['Boolean']>;
  key: Scalars['String'];
  name: Scalars['String'];
  node: Scalars['ID'];
};


/** The root Mutation */
export type MutationCreateTestResultArgs = {
  case: Scalars['ID'];
  passed: Scalars['Boolean'];
  result?: InputMaybe<Scalars['String']>;
  template: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteAgentArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteNodeArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteTestCaseArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleterepoArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationKickAgentArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationLinkArgs = {
  provision: Scalars['ID'];
  reservation: Scalars['ID'];
};


/** The root Mutation */
export type MutationProvideArgs = {
  params?: InputMaybe<Scalars['GenericScalar']>;
  template: Scalars['ID'];
};


/** The root Mutation */
export type MutationPurgeNodesArgs = {
  app?: InputMaybe<Scalars['String']>;
};


/** The root Mutation */
export type MutationReplyToArgs = {
  descendents: Array<InputMaybe<DescendendInput>>;
  parent: Scalars['ID'];
};


/** The root Mutation */
export type MutationReserveArgs = {
  allowAutoRequest?: InputMaybe<Scalars['Boolean']>;
  binds?: InputMaybe<ReserveBindsInput>;
  hash?: InputMaybe<Scalars['String']>;
  imitate?: InputMaybe<Scalars['ID']>;
  instanceId: Scalars['ID'];
  node?: InputMaybe<Scalars['ID']>;
  params?: InputMaybe<ReserveParamsInput>;
  persist?: InputMaybe<Scalars['Boolean']>;
  provision?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
  template?: InputMaybe<Scalars['ID']>;
  title?: InputMaybe<Scalars['String']>;
};


/** The root Mutation */
export type MutationResetAssignationsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
};


/** The root Mutation */
export type MutationResetNodesArgs = {
  exclude?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
};


/** The root Mutation */
export type MutationResetProvisionsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
};


/** The root Mutation */
export type MutationResetReservationsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
};


/** The root Mutation */
export type MutationResolveCommentArgs = {
  id: Scalars['ID'];
  imitate?: InputMaybe<Scalars['ID']>;
};


/** The root Mutation */
export type MutationSlateArgs = {
  identifier: Scalars['String'];
};


/** The root Mutation */
export type MutationTellArgs = {
  message: MessageInput;
  reservation: Scalars['ID'];
};


/** The root Mutation */
export type MutationUnassignArgs = {
  assignation?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
};


/** The root Mutation */
export type MutationUnlinkArgs = {
  provision: Scalars['ID'];
  reservation: Scalars['ID'];
  safe?: InputMaybe<Scalars['Boolean']>;
};


/** The root Mutation */
export type MutationUnprovideArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Mutation */
export type MutationUnreserveArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationUpdateMirrorArgs = {
  id: Scalars['ID'];
};

export type Node = {
  __typename?: 'Node';
  args?: Maybe<Array<Maybe<Port>>>;
  /** The collections this Node belongs to */
  collections: Array<Collection>;
  createdAt: Scalars['DateTime'];
  /** A description for the Node */
  description: Scalars['String'];
  /** The hash of the Node (completely unique) */
  hash: Scalars['String'];
  id: Scalars['ID'];
  /** Is this function pure. e.g can we cache the result? */
  idempotent: Scalars['Boolean'];
  /** Beautiful images for beautiful Nodes */
  image?: Maybe<Scalars['String']>;
  interfaces?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** The nodes this node tests */
  isTestFor?: Maybe<Array<Maybe<Node>>>;
  /** Function, generator? Check async Programming Textbook */
  kind: NodeKind;
  meta?: Maybe<Scalars['GenericScalar']>;
  /** The cleartext name of this Node */
  name: Scalars['String'];
  /** The port groups */
  portGroups?: Maybe<Array<Maybe<PortGroup>>>;
  /** The tests of its node */
  protocols?: Maybe<Array<Maybe<Protocol>>>;
  /** Is this function pure. e.g can we cache the result? */
  pure: Scalars['Boolean'];
  /** The node this reservation connects */
  reservations: Array<Reservation>;
  returns?: Maybe<Array<Maybe<Port>>>;
  /** The scope of this port */
  scope: NodeScope;
  templates?: Maybe<Array<Maybe<Template>>>;
  /** The node this test belongs to */
  testcases: Array<TestCase>;
  /** The tests of its node */
  tests?: Maybe<Array<Maybe<Node>>>;
};


export type NodeIsTestForArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};


export type NodeProtocolsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  name?: InputMaybe<Scalars['String']>;
};


export type NodeTemplatesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  interface?: InputMaybe<Scalars['String']>;
  name?: InputMaybe<Scalars['String']>;
  node?: InputMaybe<Scalars['ID']>;
  nodeDescription?: InputMaybe<Scalars['String']>;
  nodeName?: InputMaybe<Scalars['String']>;
  package?: InputMaybe<Scalars['String']>;
  providable?: InputMaybe<Scalars['Boolean']>;
  scopes?: InputMaybe<Array<InputMaybe<NodeScope>>>;
  search?: InputMaybe<Scalars['String']>;
};


export type NodeTestsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};

export type NodeEvent = {
  __typename?: 'NodeEvent';
  created?: Maybe<Node>;
  deleted?: Maybe<Scalars['ID']>;
  updated?: Maybe<Node>;
};

/** An enumeration. */
export enum NodeKind {
  /** Function */
  Function = 'FUNCTION',
  /** Generator */
  Generator = 'GENERATOR'
}

/** An enumeration. */
export enum NodeKindInput {
  /** Function */
  Function = 'FUNCTION',
  /** Generator */
  Generator = 'GENERATOR'
}

export enum NodeScope {
  BridgeGlobalToLocal = 'BRIDGE_GLOBAL_TO_LOCAL',
  BridgeLocalToGlobal = 'BRIDGE_LOCAL_TO_GLOBAL',
  Global = 'GLOBAL',
  Local = 'LOCAL'
}

/** A paragraph in the comment tree. This paragraph contains other nodes (list nodes) */
export type ParagraphDescendent = CommentNode & Descendent & {
  __typename?: 'ParagraphDescendent';
  children?: Maybe<Array<Maybe<Descendent>>>;
  /** The size of the paragraph */
  size?: Maybe<Scalars['String']>;
  typename?: Maybe<Scalars['String']>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
};

/**
 * A Permission object
 *
 * This object represents a permission in the system. Permissions are
 * used to control access to different parts of the system. Permissions
 * are assigned to groups and users. A user has access to a part of the
 * system if the user is a member of a group that has the permission
 * assigned to it.
 */
export type Permission = {
  __typename?: 'Permission';
  codename: Scalars['String'];
  groupSet: Array<Group>;
  id: Scalars['ID'];
  name: Scalars['String'];
  /** Unique ID for this permission */
  unique: Scalars['String'];
  /** Specific permissions for this user. */
  userSet: Array<User>;
};

export type PermissionsOfReturn = {
  __typename?: 'PermissionsOfReturn';
  available?: Maybe<Array<Maybe<Permission>>>;
  groupAssignments?: Maybe<Array<Maybe<GroupAssignment>>>;
  userAssignments?: Maybe<Array<Maybe<UserAssignment>>>;
};

/** A Port */
export type Port = {
  __typename?: 'Port';
  /** The annotations of this port */
  annotations?: Maybe<Array<Maybe<Annotation>>>;
  /** Description of the Widget */
  assignWidget?: Maybe<Widget>;
  /** The child */
  child?: Maybe<ChildPort>;
  default?: Maybe<Scalars['Any']>;
  /** A description for this Port */
  description?: Maybe<Scalars['String']>;
  /** The effects of this port */
  effects?: Maybe<Array<Maybe<Effect>>>;
  /** The port groups */
  groups?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** The corresponding Model */
  identifier?: Maybe<Scalars['Identifier']>;
  key: Scalars['String'];
  /** the type of input */
  kind: PortKind;
  label?: Maybe<Scalars['String']>;
  nullable: Scalars['Boolean'];
  /** A return widget */
  returnWidget?: Maybe<ReturnWidget>;
  /** The scope of this port */
  scope: Scope;
  /** The varients of this port (only for unions) */
  variants?: Maybe<Array<Maybe<ChildPort>>>;
};

export type PortDemandInput = {
  at?: InputMaybe<Scalars['Int']>;
  child?: InputMaybe<PortDemandInput>;
  identifier?: InputMaybe<Scalars['String']>;
  key?: InputMaybe<Scalars['String']>;
  kind?: InputMaybe<PortKindInput>;
  nullable?: InputMaybe<Scalars['Boolean']>;
  variants?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
};

export type PortGroup = {
  __typename?: 'PortGroup';
  hidden?: Maybe<Scalars['Boolean']>;
  key: Scalars['String'];
};

export type PortGroupInput = {
  /** Is this port group hidden */
  hidden?: InputMaybe<Scalars['Boolean']>;
  /** The key of the port group */
  key: Scalars['String'];
};

export type PortInput = {
  /** The annotations of this argument */
  annotations?: InputMaybe<Array<InputMaybe<AnnotationInput>>>;
  /** The child of this argument */
  assignWidget?: InputMaybe<WidgetInput>;
  /** The child of this argument */
  child?: InputMaybe<ChildPortInput>;
  /** The key of the arg */
  default?: InputMaybe<Scalars['Any']>;
  /** The description of this argument */
  description?: InputMaybe<Scalars['String']>;
  /** The dependencies of this port */
  effects?: InputMaybe<Array<InputMaybe<EffectInput>>>;
  /** The port group of this argument */
  groups?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** The identifier */
  identifier?: InputMaybe<Scalars['Identifier']>;
  /** The key of the arg */
  key: Scalars['String'];
  /** The type of this argument */
  kind: PortKindInput;
  /** The name of this argument */
  label?: InputMaybe<Scalars['String']>;
  /** The name of this argument */
  name?: InputMaybe<Scalars['String']>;
  /** Is this argument nullable */
  nullable: Scalars['Boolean'];
  /** The child of this argument */
  returnWidget?: InputMaybe<ReturnWidgetInput>;
  /** The scope of this port */
  scope: Scope;
  /** The varients of this port (only for union) */
  variants?: InputMaybe<Array<InputMaybe<ChildPortInput>>>;
};

export enum PortKind {
  Bool = 'BOOL',
  Date = 'DATE',
  Dict = 'DICT',
  Float = 'FLOAT',
  Int = 'INT',
  List = 'LIST',
  String = 'STRING',
  Structure = 'STRUCTURE',
  Union = 'UNION'
}

export enum PortKindInput {
  Bool = 'BOOL',
  Date = 'DATE',
  Dict = 'DICT',
  Float = 'FLOAT',
  Int = 'INT',
  List = 'LIST',
  String = 'STRING',
  Structure = 'STRUCTURE',
  Union = 'UNION'
}

export type Protocol = {
  __typename?: 'Protocol';
  /** A description for the Protocol */
  description: Scalars['String'];
  id: Scalars['ID'];
  /** The name of this Protocol */
  name: Scalars['String'];
  /** The protocols this Node implements (e.g. Predicate) */
  nodes: Array<Node>;
};

export type Provision = {
  __typename?: 'Provision';
  /** Access Strategy for this Provision */
  access: ProvisionAccess;
  /** Is this Provision bound to a certain Agent? */
  agent?: Maybe<Agent>;
  /** This provision creator */
  app?: Maybe<LokApp>;
  assignations?: Maybe<Array<Maybe<Assignation>>>;
  /** Was this Reservation caused by a Provision? */
  causedReservations: Array<Reservation>;
  context?: Maybe<Scalars['GenericScalar']>;
  createdAt: Scalars['DateTime'];
  /** This provision creator */
  creator?: Maybe<User>;
  /** Is the connection to this Provision lost? */
  dropped: Scalars['Boolean'];
  extensions?: Maybe<Scalars['GenericScalar']>;
  id: Scalars['ID'];
  log?: Maybe<Array<Maybe<ProvisionLog>>>;
  /** The Deployment Mode for this Provisions */
  mode: ProvisionMode;
  params?: Maybe<ProvisionParams>;
  /** The Unique identifier of this Provision */
  reference: Scalars['String'];
  /** Reservation that created this provision (if we were auto created) */
  reservation?: Maybe<Reservation>;
  /** The Provisions this reservation connects */
  reservations: Array<Reservation>;
  /** Current lifecycle of Provision */
  status: ProvisionStatus;
  /** Clear Text status of the Provision as for now */
  statusmessage: Scalars['String'];
  template: Template;
  /** A Short Hand Way to identify this reservation for you */
  title?: Maybe<Scalars['String']>;
  /** A Unique identifier for this Topic */
  unique: Scalars['UUID'];
  updatedAt: Scalars['DateTime'];
};


export type ProvisionAssignationsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  o?: InputMaybe<Scalars['String']>;
  parent?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
  reservation?: InputMaybe<Scalars['ID']>;
  reservationReference?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
};


export type ProvisionLogArgs = {
  createdAt?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  level?: InputMaybe<LogLevelInput>;
  o?: InputMaybe<Scalars['String']>;
};

/** An enumeration. */
export enum ProvisionAccess {
  /** Everyone can link to this Topic */
  Everyone = 'EVERYONE',
  /** This Topic is Only Accessible linkable for its creating User */
  Exclusive = 'EXCLUSIVE'
}

export type ProvisionEvent = {
  __typename?: 'ProvisionEvent';
  log?: Maybe<ProvisionLogEvent>;
};

export type ProvisionLog = {
  __typename?: 'ProvisionLog';
  createdAt: Scalars['DateTime'];
  id: Scalars['ID'];
  level: ProvisionLogLevel;
  message?: Maybe<Scalars['String']>;
  /** The provision this log item belongs to */
  provision: Provision;
};

export type ProvisionLogEvent = {
  __typename?: 'ProvisionLogEvent';
  level?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
};

/** An enumeration. */
export enum ProvisionLogLevel {
  /** Cancel Level */
  Cancel = 'CANCEL',
  /** CRITICAL Level */
  Critical = 'CRITICAL',
  /** DEBUG Level */
  Debug = 'DEBUG',
  /** Done Level */
  Done = 'DONE',
  /** ERROR Level */
  Error = 'ERROR',
  /** Event Level (only handled by plugins) */
  Event = 'EVENT',
  /** INFO Level */
  Info = 'INFO',
  /** YIELD Level */
  Return = 'RETURN',
  /** WARN Level */
  Warn = 'WARN',
  /** YIELD Level */
  Yield = 'YIELD'
}

/** An enumeration. */
export enum ProvisionMode {
  /** Debug Mode (Node might be constantly evolving) */
  Debug = 'DEBUG',
  /** Production Mode (Node might be constantly evolving) */
  Production = 'PRODUCTION'
}

export type ProvisionParams = {
  __typename?: 'ProvisionParams';
  autoUnprovide?: Maybe<Scalars['Boolean']>;
};

/** An enumeration. */
export enum ProvisionStatus {
  /** Active (Provision is currently active) */
  Active = 'ACTIVE',
  /** Bound (Provision was bound to an Agent) */
  Bound = 'BOUND',
  /** Cancelling (Provisions is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Cancelled (Provision was cancelled by the User and will no longer create Topics) */
  Cancelled = 'CANCELLED',
  /** Critical (Provision resulted in an critical system error) */
  Critical = 'CRITICAL',
  /** Denied (Provision was rejected for this User) */
  Denied = 'DENIED',
  /** Ended (Provision was cancelled by the Platform and will no longer create Topics) */
  Ended = 'ENDED',
  /** Error (Reservation was not able to be performed (See StatusMessage) */
  Error = 'ERROR',
  /** Inactive (Provision is currently not active) */
  Inactive = 'INACTIVE',
  /** Lost (Subscribers to this Topic have lost their connection) */
  Lost = 'LOST',
  /** Pending (Request has been created and waits for its initial creation) */
  Pending = 'PENDING',
  /** Providing (Request has been send to its Agent and waits for Result */
  Providing = 'PROVIDING',
  /** Reconnecting (We are trying to Reconnect to this Topic) */
  Reconnecting = 'RECONNECTING'
}

/** An enumeration. */
export enum ProvisionStatusInput {
  /** Active (Provision is currently active) */
  Active = 'ACTIVE',
  /** Bound (Provision was bound to an Agent) */
  Bound = 'BOUND',
  /** Cancelling (Provisions is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Cancelled (Provision was cancelled by the User and will no longer create Topics) */
  Cancelled = 'CANCELLED',
  /** Critical (Provision resulted in an critical system error) */
  Critical = 'CRITICAL',
  /** Denied (Provision was rejected for this User) */
  Denied = 'DENIED',
  /** Lost (Subscribers to this Topic have lost their connection) */
  Disconnected = 'DISCONNECTED',
  /** Ended (Provision was cancelled by the Platform and will no longer create Topics) */
  Ended = 'ENDED',
  /** Error (Reservation was not able to be performed (See StatusMessage) */
  Error = 'ERROR',
  /** Inactive (Provision is currently not active) */
  Inactive = 'INACTIVE',
  /** Pending (Request has been created and waits for its initial creation) */
  Pending = 'PENDING',
  /** Providing (Request has been send to its Agent and waits for Result */
  Providing = 'PROVIDING',
  /** Reconnecting (We are trying to Reconnect to this Topic) */
  Reconnecting = 'RECONNECTING'
}

export type ProvisionsEvent = {
  __typename?: 'ProvisionsEvent';
  create?: Maybe<Provision>;
  delete?: Maybe<Scalars['ID']>;
  update?: Maybe<Provision>;
};

export type PurgeNodesReturn = {
  __typename?: 'PurgeNodesReturn';
  ids?: Maybe<Array<Maybe<Scalars['String']>>>;
};

/** The root Query */
export type Query = {
  __typename?: 'Query';
  agent?: Maybe<Agent>;
  agents?: Maybe<Array<Maybe<Agent>>>;
  allnodes?: Maybe<Array<Maybe<Node>>>;
  allprovisions?: Maybe<Array<Maybe<Provision>>>;
  allrepositories?: Maybe<Array<Maybe<Repository>>>;
  allreservations?: Maybe<Array<Maybe<Reservation>>>;
  assignation?: Maybe<Assignation>;
  assignations?: Maybe<Array<Maybe<Assignation>>>;
  collection?: Maybe<Collection>;
  collections?: Maybe<Array<Maybe<Collection>>>;
  comment?: Maybe<Comment>;
  /**
   * Comments for a specific object
   *
   *     This query returns all comments for a specific object. The object is
   *     specified by the `model` and `id` arguments. The `model` argument is
   *     a string that is the name of the model. The `id` argument is the id of
   *     the object.
   *
   *     You can only query for comments for objects that you have access to.
   *
   *
   */
  commentsfor?: Maybe<Array<Maybe<Comment>>>;
  demandednodes?: Maybe<Array<Maybe<Node>>>;
  hello?: Maybe<Scalars['String']>;
  linkableprovisions?: Maybe<Array<Maybe<Provision>>>;
  me?: Maybe<User>;
  myagents?: Maybe<Array<Maybe<Agent>>>;
  mymentions?: Maybe<Array<Maybe<Comment>>>;
  myprovisions?: Maybe<Array<Maybe<Provision>>>;
  myrepositories?: Maybe<Array<Maybe<Repository>>>;
  myrequests?: Maybe<Array<Maybe<Assignation>>>;
  myreservations?: Maybe<Array<Maybe<Reservation>>>;
  /**
   * Asss
   *
   *     Is A query for all of these specials in the world
   *
   */
  mytemplatefor?: Maybe<Template>;
  mytodos?: Maybe<Array<Maybe<Assignation>>>;
  /**
   * Asss
   *
   *     Is A query for all of these specials in the world
   *
   */
  node?: Maybe<Node>;
  permissionsFor?: Maybe<Array<Maybe<Permission>>>;
  permissionsOf?: Maybe<PermissionsOfReturn>;
  provision?: Maybe<Provision>;
  provisions?: Maybe<Array<Maybe<Provision>>>;
  registries?: Maybe<Array<Maybe<Registry>>>;
  registry?: Maybe<Registry>;
  repository?: Maybe<Repository>;
  requests?: Maybe<Array<Maybe<Assignation>>>;
  reservableTemplates?: Maybe<Array<Maybe<Template>>>;
  reservation?: Maybe<Reservation>;
  reservations?: Maybe<Array<Maybe<Reservation>>>;
  structure?: Maybe<Structure>;
  structures?: Maybe<Array<Maybe<Structure>>>;
  template?: Maybe<Template>;
  templates?: Maybe<Array<Maybe<Template>>>;
  testcase?: Maybe<TestCase>;
  testcases?: Maybe<Array<Maybe<TestCase>>>;
  testresult?: Maybe<TestResult>;
  testresults?: Maybe<Array<Maybe<TestResult>>>;
  todos?: Maybe<Array<Maybe<Assignation>>>;
  user?: Maybe<User>;
  /** Get a list of users */
  users?: Maybe<Array<Maybe<User>>>;
  void?: Maybe<Scalars['String']>;
};


/** The root Query */
export type QueryAgentArgs = {
  client?: InputMaybe<Scalars['ID']>;
  id?: InputMaybe<Scalars['ID']>;
  instance?: InputMaybe<Scalars['ID']>;
  sub?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryAgentsArgs = {
  app?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  registry?: InputMaybe<Scalars['ID']>;
  search?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AgentStatusInput>>>;
};


/** The root Query */
export type QueryAllnodesArgs = {
  argTypes?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  collections?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  interfaces?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  protocolNames?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  protocols?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  repository?: InputMaybe<Scalars['ID']>;
  restrict?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  scopes?: InputMaybe<Array<InputMaybe<NodeScope>>>;
  search?: InputMaybe<Scalars['String']>;
  templated?: InputMaybe<Scalars['Boolean']>;
  type?: InputMaybe<NodeKindInput>;
};


/** The root Query */
export type QueryAllprovisionsArgs = {
  agent?: InputMaybe<Scalars['ID']>;
  client?: InputMaybe<Scalars['ID']>;
  clientId?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  status?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
};


/** The root Query */
export type QueryAssignationArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryAssignationsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  o?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  parent?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
  reservation?: InputMaybe<Scalars['ID']>;
  reservationReference?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
};


/** The root Query */
export type QueryCollectionArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryCollectionsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
  search?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryCommentArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryCommentsforArgs = {
  deep?: InputMaybe<Scalars['Boolean']>;
  id?: InputMaybe<Scalars['ID']>;
  model: CommentableModels;
};


/** The root Query */
export type QueryDemandednodesArgs = {
  inputPortDemands?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
  outputPortDemands?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
};


/** The root Query */
export type QueryLinkableprovisionsArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryMyagentsArgs = {
  app?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  registry?: InputMaybe<Scalars['ID']>;
  search?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AgentStatusInput>>>;
};


/** The root Query */
export type QueryMyprovisionsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
};


/** The root Query */
export type QueryMyrequestsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  latest?: InputMaybe<Scalars['Boolean']>;
  limit?: InputMaybe<Scalars['Int']>;
  onlyMine?: InputMaybe<Scalars['Boolean']>;
};


/** The root Query */
export type QueryMyreservationsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
};


/** The root Query */
export type QueryMytemplateforArgs = {
  hash?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
  instanceId: Scalars['ID'];
};


/** The root Query */
export type QueryMytodosArgs = {
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  limit?: InputMaybe<Scalars['Int']>;
};


/** The root Query */
export type QueryNodeArgs = {
  assignation?: InputMaybe<Scalars['ID']>;
  hash?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
  q?: InputMaybe<Scalars['QString']>;
  reservation?: InputMaybe<Scalars['ID']>;
  template?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryPermissionsForArgs = {
  model: SharableModels;
  name?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryPermissionsOfArgs = {
  id: Scalars['ID'];
  model: SharableModels;
};


/** The root Query */
export type QueryProvisionArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryProvisionsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
  instanceId?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryRegistriesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  unique?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryRegistryArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryRepositoryArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryRequestsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  instanceId: Scalars['String'];
};


/** The root Query */
export type QueryReservableTemplatesArgs = {
  hash?: InputMaybe<Scalars['String']>;
  node?: InputMaybe<Scalars['ID']>;
  template?: InputMaybe<Scalars['ID']>;
  templateParams?: InputMaybe<Array<InputMaybe<TemplateParamInput>>>;
};


/** The root Query */
export type QueryReservationArgs = {
  id?: InputMaybe<Scalars['ID']>;
  provision?: InputMaybe<Scalars['ID']>;
  reference?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryReservationsArgs = {
  exclude?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  inputPortDemands?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
  instanceId: Scalars['String'];
  nodeInterfaces?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  outputPortDemands?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
  templateParams?: InputMaybe<Array<InputMaybe<TemplateParamInput>>>;
};


/** The root Query */
export type QueryStructureArgs = {
  id?: InputMaybe<Scalars['ID']>;
  identifier?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryTemplateArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryTemplatesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  interface?: InputMaybe<Scalars['String']>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  node?: InputMaybe<Scalars['ID']>;
  nodeDescription?: InputMaybe<Scalars['String']>;
  nodeName?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  package?: InputMaybe<Scalars['String']>;
  providable?: InputMaybe<Scalars['Boolean']>;
  scopes?: InputMaybe<Array<InputMaybe<NodeScope>>>;
  search?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryTestcaseArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryTestcasesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  key?: InputMaybe<Scalars['String']>;
  limit?: InputMaybe<Scalars['Int']>;
  node?: InputMaybe<Scalars['ID']>;
  offset?: InputMaybe<Scalars['Int']>;
  search?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryTestresultArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryTestresultsArgs = {
  case?: InputMaybe<Scalars['ID']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  key?: InputMaybe<Scalars['String']>;
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
  search?: InputMaybe<Scalars['String']>;
  template?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryTodosArgs = {
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  identifier?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryUserArgs = {
  email?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryUsersArgs = {
  email?: InputMaybe<Scalars['String']>;
  search?: InputMaybe<Scalars['String']>;
  username?: InputMaybe<Scalars['String']>;
};

export type QueryWidget = Widget & {
  __typename?: 'QueryWidget';
  kind: Scalars['String'];
  /** A Complex description */
  query?: Maybe<Scalars['String']>;
};

export type Registry = {
  __typename?: 'Registry';
  /** The provide might be limited to a instance like ImageJ belonging to a specific person. Is nullable for backend users */
  agents: Array<Agent>;
  /** The Associated App */
  app?: Maybe<LokApp>;
  client: LokClient;
  id: Scalars['ID'];
  /** @deprecated Will be replaced in the future */
  name?: Maybe<Scalars['String']>;
  /** The Associatsed App */
  user?: Maybe<User>;
  /** The provide might be limited to a instance like ImageJ belonging to a specific person. Is nullable for backend users */
  waiters: Array<Waiter>;
};

export type Repository = {
  /** Id of the Repository */
  id: Scalars['ID'];
  /** The Name of the Repository */
  name?: Maybe<Scalars['String']>;
  nodes?: Maybe<Array<Maybe<Node>>>;
};


export type RepositoryNodesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  package?: InputMaybe<Scalars['String']>;
};

/** An enumeration. */
export enum RepositoryType {
  /** Repository that is hosted by an App */
  App = 'APP',
  /** Repository mirrors online Repository */
  Mirror = 'MIRROR'
}

export type Reservation = {
  __typename?: 'Reservation';
  /** Allow automatic requests for this reservation */
  allowAutoRequest: Scalars['Boolean'];
  /** This Reservations app */
  app?: Maybe<LokApp>;
  /** Which reservation are we assigning to */
  assignations: Array<Assignation>;
  binds?: Maybe<Binds>;
  /** Callback */
  callback?: Maybe<Scalars['String']>;
  /** The channel of this Reservation */
  channel: Scalars['String'];
  createdAt: Scalars['DateTime'];
  /** Reservation that created this provision (if we were auto created) */
  createdProvisions: Array<Provision>;
  /** This Reservations creator */
  creator?: Maybe<User>;
  /** Is this reservation happy? (aka: does it have as many linked provisions as desired */
  happy: Scalars['Boolean'];
  /** The hash of the Reservation */
  hash: Scalars['String'];
  id: Scalars['ID'];
  log?: Maybe<Array<Maybe<ReservationLog>>>;
  /** The node this reservation connects */
  node: Node;
  params?: Maybe<ReserveParams>;
  /** Provider */
  progress?: Maybe<Scalars['String']>;
  /** Was this Reservation caused by a Provision? */
  provision?: Maybe<Provision>;
  /** The Provisions this reservation connects */
  provisions: Array<Provision>;
  /** The Unique identifier of this Assignation */
  reference: Scalars['String'];
  /** Current lifecycle of Reservation */
  status: ReservationStatus;
  /** Clear Text status of the Provision as for now */
  statusmessage: Scalars['String'];
  /** The template this reservation connects */
  template?: Maybe<Template>;
  /** A Short Hand Way to identify this reservation for you */
  title?: Maybe<Scalars['String']>;
  updatedAt: Scalars['DateTime'];
  /** Is this reservation viable? (aka: does it have as many linked provisions as minimal */
  viable: Scalars['Boolean'];
  /** This Reservations app */
  waiter: Waiter;
};


export type ReservationLogArgs = {
  createdAt?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  level?: InputMaybe<LogLevelInput>;
  o?: InputMaybe<Scalars['String']>;
};

export type ReservationEvent = {
  __typename?: 'ReservationEvent';
  log?: Maybe<ReservationLogEvent>;
};

export type ReservationLog = {
  __typename?: 'ReservationLog';
  createdAt: Scalars['DateTime'];
  id: Scalars['ID'];
  level: ReservationLogLevel;
  message?: Maybe<Scalars['String']>;
  /** The reservation this log item belongs to */
  reservation: Reservation;
};

export type ReservationLogEvent = {
  __typename?: 'ReservationLogEvent';
  level?: Maybe<Scalars['String']>;
  message?: Maybe<Scalars['String']>;
};

/** An enumeration. */
export enum ReservationLogLevel {
  /** Cancel Level */
  Cancel = 'CANCEL',
  /** CRITICAL Level */
  Critical = 'CRITICAL',
  /** DEBUG Level */
  Debug = 'DEBUG',
  /** Done Level */
  Done = 'DONE',
  /** ERROR Level */
  Error = 'ERROR',
  /** Event Level (only handled by plugins) */
  Event = 'EVENT',
  /** INFO Level */
  Info = 'INFO',
  /** YIELD Level */
  Return = 'RETURN',
  /** WARN Level */
  Warn = 'WARN',
  /** YIELD Level */
  Yield = 'YIELD'
}

/** An enumeration. */
export enum ReservationStatus {
  /** Active (Reservation is active and accepts assignments */
  Active = 'ACTIVE',
  /** Cancelling (Reervation is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Cancelled (Reservation was cancelled by user and is no longer active) */
  Cancelled = 'CANCELLED',
  /** Critical (Reservation failed with an Critical Error) */
  Critical = 'CRITICAL',
  /** Disconnect (State of provisions this reservation connects to have changed and require Retouring) */
  Disconnect = 'DISCONNECT',
  /** Disconnect (State of provisions this reservation connects to have changed and require Retouring) */
  Disconnected = 'DISCONNECTED',
  /** Ended (Reservation was ended by the the Platform and is no longer active) */
  Ended = 'ENDED',
  /** Error (Reservation was not able to be performed (See StatusMessage) */
  Error = 'ERROR',
  /** SHould signal that this reservation is non viable (has less linked provisions than minimalInstances) */
  NonViable = 'NON_VIABLE',
  /** Providing (Reservation required the provision of a new worker) */
  Providing = 'PROVIDING',
  /** Rerouting (State of provisions this reservation connects to have changed and require Retouring) */
  Rerouting = 'REROUTING',
  /** Routing (Reservation has been requested but no Topic found yet) */
  Routing = 'ROUTING',
  /** Waiting (We are waiting for any assignable Topic to come online) */
  Waiting = 'WAITING'
}

/** An enumeration. */
export enum ReservationStatusInput {
  /** Active (Reservation is active and accepts assignments */
  Active = 'ACTIVE',
  /** Cancelling (Reervation is currently being cancelled) */
  Canceling = 'CANCELING',
  /** Cancelled (Reservation was cancelled by user and is no longer active) */
  Cancelled = 'CANCELLED',
  /** Critical (Reservation failed with an Critical Error) */
  Critical = 'CRITICAL',
  /** Disconnect (State of provisions this reservation connects to have changed and require Retouring) */
  Disconnect = 'DISCONNECT',
  /** Disconnect (State of provisions this reservation connects to have changed and require Retouring) */
  Disconnected = 'DISCONNECTED',
  /** Ended (Reservation was ended by the the Platform and is no longer active) */
  Ended = 'ENDED',
  /** Error (Reservation was not able to be performed (See StatusMessage) */
  Error = 'ERROR',
  /** SHould signal that this reservation is non viable (has less linked provisions than minimalInstances) */
  NonViable = 'NON_VIABLE',
  /** Providing (Reservation required the provision of a new worker) */
  Providing = 'PROVIDING',
  /** Rerouting (State of provisions this reservation connects to have changed and require Retouring) */
  Rerouting = 'REROUTING',
  /** Routing (Reservation has been requested but no Topic found yet) */
  Routing = 'ROUTING',
  /** Waiting (We are waiting for any assignable Topic to come online) */
  Waiting = 'WAITING'
}

export type ReservationsEvent = {
  __typename?: 'ReservationsEvent';
  create?: Maybe<Reservation>;
  delete?: Maybe<Scalars['ID']>;
  update?: Maybe<Reservation>;
};

export type ReserveBindsInput = {
  /** The clients that we are allowed to use */
  clients: Array<InputMaybe<Scalars['ID']>>;
  /** The templates that we are allowed to use */
  templates: Array<InputMaybe<Scalars['ID']>>;
};

export type ReserveParams = {
  __typename?: 'ReserveParams';
  /** Autoproviding */
  autoProvide?: Maybe<Scalars['Boolean']>;
  /** Autounproviding */
  autoUnprovide?: Maybe<Scalars['Boolean']>;
  /** The desired amount of Instances */
  desiredInstances?: Maybe<Scalars['Int']>;
  /** The minimal amount of Instances */
  minimalInstances?: Maybe<Scalars['Int']>;
  /** Registry thar are allowed */
  registries?: Maybe<Array<Maybe<Scalars['ID']>>>;
  /** Templates that can be selected */
  templates?: Maybe<Array<Maybe<Scalars['ID']>>>;
};

export type ReserveParamsInput = {
  /** Agents that are allowed */
  agents?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  /** Do you want to autoprovide */
  autoProvide?: InputMaybe<Scalars['Boolean']>;
  /** Do you want to auto_unprovide */
  autoUnprovide?: InputMaybe<Scalars['Boolean']>;
  /** The desired amount of Instances */
  desiredInstances: Scalars['Int'];
  /** The minimal amount of Instances */
  minimalInstances: Scalars['Int'];
  /** Registry thar are allowed */
  registries?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  /** Templates that can be selected */
  templates?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
};

export type ResetAgentsReturn = {
  __typename?: 'ResetAgentsReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ResetAssignationsReturn = {
  __typename?: 'ResetAssignationsReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ResetNodesReturn = {
  __typename?: 'ResetNodesReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ResetProvisionsReturn = {
  __typename?: 'ResetProvisionsReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ResetRepositoryReturn = {
  __typename?: 'ResetRepositoryReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ResetReservationsReturn = {
  __typename?: 'ResetReservationsReturn';
  ok?: Maybe<Scalars['Boolean']>;
};

export type ReturnWidget = {
  kind: Scalars['String'];
};

export type ReturnWidgetInput = {
  /** The dependencies of this port */
  choices?: InputMaybe<Array<InputMaybe<ChoiceInput>>>;
  /** A hook for the app to call */
  hook?: InputMaybe<Scalars['String']>;
  /** type */
  kind: ReturnWidgetKind;
  /** Do we have a possible */
  query?: InputMaybe<Scalars['String']>;
  /** A hook for the app to call */
  ward?: InputMaybe<Scalars['String']>;
};

/** The kind of return widget */
export enum ReturnWidgetKind {
  ChoiceReturnWidget = 'ChoiceReturnWidget',
  CustomReturnWidget = 'CustomReturnWidget',
  ImageReturnWidget = 'ImageReturnWidget'
}

export enum Scope {
  Global = 'GLOBAL',
  Local = 'LOCAL'
}

export type SearchWidget = Widget & {
  __typename?: 'SearchWidget';
  kind: Scalars['String'];
  /** A Complex description */
  query: Scalars['String'];
  /** A ward for the app to call */
  ward: Scalars['String'];
};

/** Sharable Models are models that can be shared amongst users and groups. They representent the models of the DB */
export enum SharableModels {
  FacadeAgent = 'FACADE_AGENT',
  FacadeApprepository = 'FACADE_APPREPOSITORY',
  FacadeAssignation = 'FACADE_ASSIGNATION',
  FacadeAssignationlog = 'FACADE_ASSIGNATIONLOG',
  FacadeCollection = 'FACADE_COLLECTION',
  FacadeMirrorrepository = 'FACADE_MIRRORREPOSITORY',
  FacadeNode = 'FACADE_NODE',
  FacadeProtocol = 'FACADE_PROTOCOL',
  FacadeProvision = 'FACADE_PROVISION',
  FacadeProvisionlog = 'FACADE_PROVISIONLOG',
  FacadeRegistry = 'FACADE_REGISTRY',
  FacadeRepository = 'FACADE_REPOSITORY',
  FacadeReservation = 'FACADE_RESERVATION',
  FacadeReservationlog = 'FACADE_RESERVATIONLOG',
  FacadeStructure = 'FACADE_STRUCTURE',
  FacadeTemplate = 'FACADE_TEMPLATE',
  FacadeTestcase = 'FACADE_TESTCASE',
  FacadeTestresult = 'FACADE_TESTRESULT',
  FacadeWaiter = 'FACADE_WAITER',
  LokLokapp = 'LOK_LOKAPP',
  LokLokclient = 'LOK_LOKCLIENT',
  LokLokuser = 'LOK_LOKUSER'
}

export type SliderWidget = Widget & {
  __typename?: 'SliderWidget';
  kind: Scalars['String'];
  /** A Complex description */
  max?: Maybe<Scalars['Float']>;
  /** A Complex description */
  min?: Maybe<Scalars['Float']>;
  /** A Complex description */
  step?: Maybe<Scalars['Float']>;
};

export type StringWidget = Widget & {
  __typename?: 'StringWidget';
  /** Whether to display as paragraph */
  asParagraph?: Maybe<Scalars['Boolean']>;
  kind: Scalars['String'];
  /** A placeholder to display */
  placeholder?: Maybe<Scalars['String']>;
};

export type Structure = {
  __typename?: 'Structure';
  extenders?: Maybe<Scalars['GenericScalar']>;
  id: Scalars['ID'];
  /** A unique identifier for this Model accross the Platform */
  identifier: Scalars['String'];
  repository?: Maybe<Repository>;
};

/** The root Subscriptions */
export type Subscription = {
  __typename?: 'Subscription';
  agentsEvent?: Maybe<AgentEvent>;
  assignation?: Maybe<AssignationEvent>;
  /**
   * My Mentions
   *
   *     Returns an event of a new mention for the user if the user
   *     was mentioned in a comment.
   *
   */
  mymentions?: Maybe<MentionEvent>;
  myprovisions?: Maybe<ProvisionsEvent>;
  myrequests?: Maybe<AssignationsEvent>;
  myreservations?: Maybe<ReservationsEvent>;
  mytodos?: Maybe<TodoEvent>;
  nodeEvent?: Maybe<Node>;
  nodes?: Maybe<NodeEvent>;
  provision?: Maybe<ProvisionEvent>;
  provisions?: Maybe<ProvisionsEvent>;
  requests?: Maybe<AssignationsEvent>;
  reservation?: Maybe<ReservationEvent>;
  reservations?: Maybe<ReservationsEvent>;
  templates?: Maybe<TemplateEvent>;
  todos?: Maybe<TodoEvent>;
  waiter?: Maybe<WaiterEvent>;
};


/** The root Subscriptions */
export type SubscriptionAgentsEventArgs = {
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionAssignationArgs = {
  id: Scalars['ID'];
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionMyrequestsArgs = {
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionMyreservationsArgs = {
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionNodeEventArgs = {
  id: Scalars['ID'];
};


/** The root Subscriptions */
export type SubscriptionNodesArgs = {
  interface?: InputMaybe<Scalars['String']>;
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionProvisionArgs = {
  id: Scalars['ID'];
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionProvisionsArgs = {
  identifier: Scalars['String'];
};


/** The root Subscriptions */
export type SubscriptionRequestsArgs = {
  instanceId: Scalars['String'];
};


/** The root Subscriptions */
export type SubscriptionReservationArgs = {
  id: Scalars['ID'];
  level?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionReservationsArgs = {
  instanceId: Scalars['String'];
  provision?: InputMaybe<Scalars['String']>;
};


/** The root Subscriptions */
export type SubscriptionTemplatesArgs = {
  templateParams?: InputMaybe<Array<InputMaybe<TemplateParamInput>>>;
};


/** The root Subscriptions */
export type SubscriptionTodosArgs = {
  instanceId: Scalars['String'];
};


/** The root Subscriptions */
export type SubscriptionWaiterArgs = {
  level?: InputMaybe<Scalars['String']>;
};

export type Tell = {
  __typename?: 'Tell';
  reference?: Maybe<Scalars['String']>;
};

export type Template = {
  __typename?: 'Template';
  /** The associated registry for this Template */
  agent: Agent;
  createdAt: Scalars['DateTime'];
  /** Who created this template on this instance */
  creator?: Maybe<User>;
  /** The extentions of this template */
  extensions?: Maybe<Array<Maybe<Scalars['String']>>>;
  id: Scalars['ID'];
  /** Interface (think Function) */
  interface: Scalars['String'];
  /** A name for this Template */
  name: Scalars['String'];
  /** The node this template is implementatig */
  node: Node;
  params?: Maybe<Scalars['GenericScalar']>;
  policy?: Maybe<Scalars['GenericScalar']>;
  provisions?: Maybe<Array<Maybe<Provision>>>;
  /** The template this reservation connects */
  reservations: Array<Reservation>;
  testresults: Array<TestResult>;
  updatedAt: Scalars['DateTime'];
};


export type TemplateProvisionsArgs = {
  agent?: InputMaybe<Scalars['ID']>;
  client?: InputMaybe<Scalars['ID']>;
  clientId?: InputMaybe<Scalars['String']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  status?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
};

export type TemplateEvent = {
  __typename?: 'TemplateEvent';
  created?: Maybe<Template>;
  deleted?: Maybe<Scalars['ID']>;
  updated?: Maybe<Template>;
};

export type TemplateField = {
  __typename?: 'TemplateField';
  /** A short description of the field */
  description: Scalars['String'];
  /** The key of the field */
  key: Scalars['String'];
  /** The parent key (if nested) */
  parent?: Maybe<Scalars['String']>;
  /** The type of the field */
  type: Scalars['String'];
};

export type TemplateFieldInput = {
  /** A short description of the field */
  description?: InputMaybe<Scalars['String']>;
  /** The key of the field */
  key: Scalars['String'];
  /** The parent key (if nested) */
  parent?: InputMaybe<Scalars['String']>;
  /** The key of the field */
  type: Scalars['String'];
};

export type TemplateParamInput = {
  key: Scalars['String'];
  value?: InputMaybe<Scalars['GenericScalar']>;
};

export type TemplateWidget = Widget & {
  __typename?: 'TemplateWidget';
  fields: Array<Maybe<TemplateField>>;
  kind: Scalars['String'];
};

export type TestCase = {
  __typename?: 'TestCase';
  createdAt: Scalars['DateTime'];
  description?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  isBenchmark: Scalars['Boolean'];
  key?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  /** The node this test belongs to */
  node: Node;
  results: Array<TestResult>;
};

export type TestResult = {
  __typename?: 'TestResult';
  case: TestCase;
  createdAt: Scalars['DateTime'];
  id: Scalars['ID'];
  passed: Scalars['Boolean'];
  result?: Maybe<Scalars['GenericScalar']>;
  template: Template;
};

export type TodoEvent = {
  __typename?: 'TodoEvent';
  create?: Maybe<Assignation>;
  delete?: Maybe<Scalars['ID']>;
  update?: Maybe<Assignation>;
};

export type UnprovideReturn = {
  __typename?: 'UnprovideReturn';
  id: Scalars['ID'];
};

export type UnreserveResult = {
  __typename?: 'UnreserveResult';
  id: Scalars['ID'];
};

export type UpdateMirrorReturn = {
  __typename?: 'UpdateMirrorReturn';
  id?: Maybe<Scalars['String']>;
};

/** A reflection on the real User */
export type User = {
  __typename?: 'User';
  /** The creator is this assignation */
  assignationSet: Array<Assignation>;
  /** The associated color for this user */
  color?: Maybe<Scalars['String']>;
  comments: Array<Comment>;
  dateJoined: Scalars['DateTime'];
  email: Scalars['String'];
  firstName: Scalars['String'];
  /** The groups this user belongs to. A user will get all permissions granted to each of their groups. */
  groups: Array<Group>;
  id: Scalars['ID'];
  /** Designates whether this user should be treated as active. Unselect this instead of deleting accounts. */
  isActive: Scalars['Boolean'];
  /** Designates whether the user can log into this admin site. */
  isStaff: Scalars['Boolean'];
  /** Designates that this user has all permissions without explicitly assigning them. */
  isSuperuser: Scalars['Boolean'];
  iss?: Maybe<Scalars['String']>;
  lastLogin?: Maybe<Scalars['DateTime']>;
  lastName: Scalars['String'];
  mentionedIn: Array<Comment>;
  /** The name of the user */
  name?: Maybe<Scalars['String']>;
  password: Scalars['String'];
  /** This provision creator */
  provisionSet: Array<Provision>;
  /** The Associatsed App */
  registrySet: Array<Registry>;
  /** This Reservations creator */
  reservationSet: Array<Reservation>;
  resolvedComments: Array<Comment>;
  /** The sub of the user */
  sub?: Maybe<Scalars['String']>;
  /** Who created this template on this instance */
  templateSet: Array<Template>;
  /** Specific permissions for this user. */
  userPermissions: Array<Permission>;
  /** Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
  username: Scalars['String'];
};

export type UserAssignment = {
  __typename?: 'UserAssignment';
  permissions: Array<Maybe<Scalars['String']>>;
  /** A query that returns an image path */
  user: User;
};

export type UserAssignmentInput = {
  permissions: Array<InputMaybe<Scalars['String']>>;
  /** The user id */
  user: Scalars['String'];
};

export type ValueRange = Annotation & {
  __typename?: 'ValueRange';
  /** The name of the annotation */
  kind?: Maybe<Scalars['String']>;
  /** The maximum value */
  max: Scalars['Float'];
  /** The minimum value */
  min: Scalars['Float'];
};

export type Waiter = {
  __typename?: 'Waiter';
  /** This Assignation app */
  assignations: Array<Assignation>;
  clientId: Scalars['String'];
  id: Scalars['ID'];
  identifier: Scalars['String'];
  installedAt: Scalars['DateTime'];
  /** This waiters Name */
  name: Scalars['String'];
  /** The provide might be limited to a instance like ImageJ belonging to a specific person. Is nullable for backend users */
  registry?: Maybe<Registry>;
  /** This Reservations app */
  reservations: Array<Reservation>;
  /** The Status of this Waiter */
  status: WaiterStatus;
  /** The Channel we are listening to */
  unique: Scalars['String'];
};

export type WaiterEvent = {
  __typename?: 'WaiterEvent';
  created?: Maybe<Waiter>;
  deleted?: Maybe<Scalars['ID']>;
  updated?: Maybe<Waiter>;
};

/** An enumeration. */
export enum WaiterStatus {
  /** Active */
  Active = 'ACTIVE',
  /** Disconnected */
  Disconnected = 'DISCONNECTED',
  /** Complete Vanilla Scenario after a forced restart of */
  Vanilla = 'VANILLA'
}

export type Widget = {
  kind: Scalars['String'];
};

export type WidgetInput = {
  /** Is this a paragraph */
  asParagraph?: InputMaybe<Scalars['Boolean']>;
  /** The dependencies of this port */
  choices?: InputMaybe<Array<InputMaybe<ChoiceInput>>>;
  /** The fields of this widget (onbly on TemplateWidget) */
  fields?: InputMaybe<Array<InputMaybe<TemplateFieldInput>>>;
  /** A hook for the app to call */
  hook?: InputMaybe<Scalars['String']>;
  /** type */
  kind: WidgetKind;
  /** Max value for slider widget */
  max?: InputMaybe<Scalars['Float']>;
  /** Min value for slider widget */
  min?: InputMaybe<Scalars['Float']>;
  /** Placeholder for any widget */
  placeholder?: InputMaybe<Scalars['String']>;
  /** Do we have a possible */
  query?: InputMaybe<Scalars['SearchQuery']>;
  /** Step value for slider widget */
  step?: InputMaybe<Scalars['Float']>;
  /** A ward for the app to call */
  ward?: InputMaybe<Scalars['String']>;
};

/** The kind of widget */
export enum WidgetKind {
  BoolWidget = 'BoolWidget',
  ChoiceWidget = 'ChoiceWidget',
  ColorWidget = 'ColorWidget',
  CustomWidget = 'CustomWidget',
  DateWidget = 'DateWidget',
  IntWidget = 'IntWidget',
  LinkWidget = 'LinkWidget',
  QueryWidget = 'QueryWidget',
  SearchWidget = 'SearchWidget',
  SliderWidget = 'SliderWidget',
  StringWidget = 'StringWidget',
  TemplateWidget = 'TemplateWidget'
}

/** One possible value for a given Enum. Enum values are unique values, not a placeholder for a string or numeric value. However an Enum value is returned in a JSON response as a string. */
export type __EnumValue = {
  __typename?: '__EnumValue';
  name: Scalars['String'];
  description?: Maybe<Scalars['String']>;
  isDeprecated: Scalars['Boolean'];
  deprecationReason?: Maybe<Scalars['String']>;
};

/** Object and Interface types are described by a list of Fields, each of which has a name, potentially a list of arguments, and a return type. */
export type __Field = {
  __typename?: '__Field';
  name: Scalars['String'];
  description?: Maybe<Scalars['String']>;
  args: Array<__InputValue>;
  type: __Type;
  isDeprecated: Scalars['Boolean'];
  deprecationReason?: Maybe<Scalars['String']>;
};


/** Object and Interface types are described by a list of Fields, each of which has a name, potentially a list of arguments, and a return type. */
export type __FieldArgsArgs = {
  includeDeprecated?: InputMaybe<Scalars['Boolean']>;
};

/** Arguments provided to Fields or Directives and the input fields of an InputObject are represented as Input Values which describe their type and optionally a default value. */
export type __InputValue = {
  __typename?: '__InputValue';
  name: Scalars['String'];
  description?: Maybe<Scalars['String']>;
  type: __Type;
  /** A GraphQL-formatted string representing the default value for this input value. */
  defaultValue?: Maybe<Scalars['String']>;
  isDeprecated: Scalars['Boolean'];
  deprecationReason?: Maybe<Scalars['String']>;
};

/**
 * The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
 *
 * Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByUrl`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
 */
export type __Type = {
  __typename?: '__Type';
  kind: __TypeKind;
  name?: Maybe<Scalars['String']>;
  description?: Maybe<Scalars['String']>;
  specifiedByUrl?: Maybe<Scalars['String']>;
  fields?: Maybe<Array<__Field>>;
  interfaces?: Maybe<Array<__Type>>;
  possibleTypes?: Maybe<Array<__Type>>;
  enumValues?: Maybe<Array<__EnumValue>>;
  inputFields?: Maybe<Array<__InputValue>>;
  ofType?: Maybe<__Type>;
};


/**
 * The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
 *
 * Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByUrl`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
 */
export type __TypeFieldsArgs = {
  includeDeprecated?: InputMaybe<Scalars['Boolean']>;
};


/**
 * The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
 *
 * Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByUrl`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
 */
export type __TypeEnumValuesArgs = {
  includeDeprecated?: InputMaybe<Scalars['Boolean']>;
};


/**
 * The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.
 *
 * Depending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByUrl`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.
 */
export type __TypeInputFieldsArgs = {
  includeDeprecated?: InputMaybe<Scalars['Boolean']>;
};

/** An enum describing what kind of type a given `__Type` is. */
export enum __TypeKind {
  /** Indicates this type is a scalar. */
  Scalar = 'SCALAR',
  /** Indicates this type is an object. `fields` and `interfaces` are valid fields. */
  Object = 'OBJECT',
  /** Indicates this type is an interface. `fields`, `interfaces`, and `possibleTypes` are valid fields. */
  Interface = 'INTERFACE',
  /** Indicates this type is a union. `possibleTypes` is a valid field. */
  Union = 'UNION',
  /** Indicates this type is an enum. `enumValues` is a valid field. */
  Enum = 'ENUM',
  /** Indicates this type is an input object. `inputFields` is a valid field. */
  InputObject = 'INPUT_OBJECT',
  /** Indicates this type is a list. `ofType` is a valid field. */
  List = 'LIST',
  /** Indicates this type is a non-null. `ofType` is a valid field. */
  NonNull = 'NON_NULL'
}

export type ListAgentFragment = { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null };

export type DetailAgentFragment = { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, name: string, templates: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }> };

export type PostmanAssignationFragment = { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null };

export type DetailAssignationFragment = { __typename?: 'Assignation', returns?: Array<any | null> | null, id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, parent?: { __typename?: 'Assignation', id: string, reservation?: { __typename?: 'Reservation', id: string, node: { __typename?: 'Node', id: string, name: string } } | null } | null, provision?: { __typename?: 'Provision', status: ProvisionStatus, id: string, reference: string, createdAt: any, params?: { __typename?: 'ProvisionParams', autoUnprovide?: boolean | null } | null, agent?: { __typename?: 'Agent', name: string } | null, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null } | null, reservation?: { __typename?: 'Reservation', id: string, reference: string, status: ReservationStatus, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string, interfaces?: Array<string | null> | null, meta?: any | null, kind: NodeKind, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string } | null } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, log?: Array<{ __typename?: 'AssignationLog', message?: string | null, level: AssignationLogLevel } | null> | null };

export type ListAssignationFragment = { __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null };

export type ListCollectionFragment = { __typename: 'Collection', id: string, name: string, description: string };

export type CollectionFragment = { __typename?: 'Collection', name: string, description: string, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null };

export type LeafFragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type Node_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Node_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type NodeFragment = Node_MentionDescendent_Fragment | Node_ParagraphDescendent_Fragment;

export type LevelDownParagraphFragment = { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null };

export type LevelDownMentionFragment = { __typename?: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } };

type LevelDownDescendent_Leaf_Fragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type LevelDownDescendent_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent' };

type LevelDownDescendent_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', typename: 'ParagraphDescendent' };

export type LevelDownDescendentFragment = LevelDownDescendent_Leaf_Fragment | LevelDownDescendent_MentionDescendent_Fragment | LevelDownDescendent_ParagraphDescendent_Fragment;

export type MentionFragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type ParagraphFragment = { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Descendent_Leaf_Fragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type Descendent_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Descendent_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type DescendentFragment = Descendent_Leaf_Fragment | Descendent_MentionDescendent_Fragment | Descendent_ParagraphDescendent_Fragment;

export type SubthreadCommentFragment = { __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null };

export type ListCommentFragment = { __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null };

export type MentionCommentFragment = { __typename?: 'Comment', id: string, createdAt: any, resolved?: any | null, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', id: string, sub?: string | null }>, resolvedBy?: { __typename?: 'User', sub?: string | null } | null };

export type DetailCommentFragment = { __typename?: 'Comment', id: string, resolved?: any | null, createdAt: any, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', sub?: string | null }> };

export type DetailNodeFragment = { __typename?: 'Node', name: string, description: string, kind: NodeKind, hash: string, id: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope, collections: Array<{ __typename?: 'Collection', id: string, name: string }>, templates?: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null };

export type NodeListItemFragment = { __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope };

export type MiniNodeFragment = { __typename?: 'Node', name: string, description: string, kind: NodeKind, id: string, meta?: any | null, hash: string, scope: NodeScope };

export type CompleteNodeFragment = { __typename?: 'Node', name: string, hash: string, description: string, scope: NodeScope, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null };

export type UserAssignmentFragment = { __typename?: 'UserAssignment', permissions: Array<string | null>, user: { __typename?: 'User', id: string, sub?: string | null, username: string, email: string } };

export type GroupAssignmentFragment = { __typename?: 'GroupAssignment', permissions: Array<string | null>, group: { __typename?: 'Group', name: string } };

export type IntWidgetFragment = { __typename?: 'IntWidget', kind: string };

export type StringWidgetFragment = { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null };

export type BoolWidgetFragment = { __typename?: 'BoolWidget', kind: string };

export type SliderWidgetFragment = { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null };

export type SearchWidgetFragment = { __typename: 'SearchWidget', kind: string, query: string, ward: string };

export type CustomWidgetFragment = { __typename: 'CustomWidget', kind: string, hook?: string | null };

export type ChoiceWidgetFragment = { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null };

export type LinkWidgetFragment = { __typename?: 'LinkWidget', kind: string, linkbuilder?: string | null };

export type ChildPortNestedFragment = { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null };

export type ChildPortFragment = { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null };

export type DependencyFragment = { __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any };

export type EffectFragment = { __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null };

type InputWidget_BoolWidget_Fragment = { __typename: 'BoolWidget', kind: string };

type InputWidget_ChoiceWidget_Fragment = { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null };

type InputWidget_ColorWidget_Fragment = { __typename: 'ColorWidget', kind: string };

type InputWidget_CustomWidget_Fragment = { __typename: 'CustomWidget', kind: string, hook?: string | null };

type InputWidget_DateWidget_Fragment = { __typename: 'DateWidget', kind: string };

type InputWidget_IntWidget_Fragment = { __typename: 'IntWidget', kind: string };

type InputWidget_LinkWidget_Fragment = { __typename: 'LinkWidget', kind: string };

type InputWidget_QueryWidget_Fragment = { __typename: 'QueryWidget', kind: string };

type InputWidget_SearchWidget_Fragment = { __typename: 'SearchWidget', kind: string, query: string, ward: string };

type InputWidget_SliderWidget_Fragment = { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null };

type InputWidget_StringWidget_Fragment = { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null };

type InputWidget_TemplateWidget_Fragment = { __typename: 'TemplateWidget', kind: string };

export type InputWidgetFragment = InputWidget_BoolWidget_Fragment | InputWidget_ChoiceWidget_Fragment | InputWidget_ColorWidget_Fragment | InputWidget_CustomWidget_Fragment | InputWidget_DateWidget_Fragment | InputWidget_IntWidget_Fragment | InputWidget_LinkWidget_Fragment | InputWidget_QueryWidget_Fragment | InputWidget_SearchWidget_Fragment | InputWidget_SliderWidget_Fragment | InputWidget_StringWidget_Fragment | InputWidget_TemplateWidget_Fragment;

export type PortFragment = { __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null };

export type ImageReturnWidgetFragment = { __typename: 'ImageReturnWidget', query?: string | null, kind: string, ward?: string | null };

export type CustomReturnWidgetFragment = { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null };

export type ChoiceReturnWidgetFragment = { __typename: 'ChoiceReturnWidget', choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null };

type ReturnWidget_ChoiceReturnWidget_Fragment = { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null };

type ReturnWidget_CustomReturnWidget_Fragment = { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null };

type ReturnWidget_ImageReturnWidget_Fragment = { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null };

export type ReturnWidgetFragment = ReturnWidget_ChoiceReturnWidget_Fragment | ReturnWidget_CustomReturnWidget_Fragment | ReturnWidget_ImageReturnWidget_Fragment;

export type PortsFragment = { __typename?: 'Node', args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null };

export type PostmanProvisionFragment = { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string };

export type DetailProvisionFragment = { __typename?: 'Provision', mode: ProvisionMode, createdAt: any, statusmessage: string, status: ProvisionStatus, id: string, reference: string, params?: { __typename?: 'ProvisionParams', autoUnprovide?: boolean | null } | null, agent?: { __typename?: 'Agent', name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, template: { __typename?: 'Template', id: string, extensions?: Array<string | null> | null, params?: any | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null, meta?: any | null }, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }, creator?: { __typename?: 'User', email: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, causedReservations: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, assignations?: Array<{ __typename?: 'Assignation', id: string, reference: string, status: AssignationStatus, creator?: { __typename?: 'User', email: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null } | null> | null, reservations: Array<{ __typename?: 'Reservation', title?: string | null, id: string, reference: string, status: ReservationStatus, node: { __typename?: 'Node', name: string }, waiter: { __typename?: 'Waiter', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, log?: Array<{ __typename?: 'ProvisionLog', message?: string | null, level: ProvisionLogLevel, createdAt: any } | null> | null };

export type ListProvisionFragment = { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> };

export type ProvisionLogFragment = { __typename?: 'ProvisionLog', message?: string | null, level: ProvisionLogLevel, createdAt: any };

export type RegistryFragment = { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null };

type ListRepository_AppRepository_Fragment = { __typename: 'AppRepository', id: string, name?: string | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null };

type ListRepository_MirrorRepository_Fragment = { __typename: 'MirrorRepository', id: string, url?: string | null, name?: string | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null };

export type ListRepositoryFragment = ListRepository_AppRepository_Fragment | ListRepository_MirrorRepository_Fragment;

export type AppRepositoryFragment = { __typename?: 'AppRepository', id: string, name?: string | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null };

export type MirrorRepositoryFragment = { __typename?: 'MirrorRepository', id: string, url?: string | null, name?: string | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null };

export type DetailAppRepositoryFragment = { __typename?: 'AppRepository', installedAt: any, app?: { __typename?: 'LokApp', version: string, identifier: string } | null };

export type DetailMirrorRepositoryFragment = { __typename?: 'MirrorRepository', url?: string | null };

type DetailRepository_AppRepository_Fragment = { __typename?: 'AppRepository', name?: string | null, installedAt: any, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null };

type DetailRepository_MirrorRepository_Fragment = { __typename?: 'MirrorRepository', name?: string | null, url?: string | null, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null };

export type DetailRepositoryFragment = DetailRepository_AppRepository_Fragment | DetailRepository_MirrorRepository_Fragment;

export type PostmanReservationFragment = { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string };

export type DetailReservationFragment = { __typename?: 'Reservation', allowAutoRequest: boolean, channel: string, title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string, params?: { __typename?: 'ReserveParams', autoProvide?: boolean | null, autoUnprovide?: boolean | null, minimalInstances?: number | null, desiredInstances?: number | null } | null, binds?: { __typename?: 'Binds', clients?: Array<{ __typename?: 'LokClient', id: string, name: string, clientId: string } | null> | null, templates?: Array<{ __typename?: 'Template', id: string, name: string, interface: string } | null> | null } | null, provision?: { __typename?: 'Provision', reference: string, id: string, access: ProvisionAccess, status: ProvisionStatus, creator?: { __typename?: 'User', id: string, username: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null } | null, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null }, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, scope: NodeScope, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, template?: { __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }>, log?: Array<{ __typename?: 'ReservationLog', message?: string | null, level: ReservationLogLevel } | null> | null, creator?: { __typename?: 'User', email: string } | null };

export type NodeReservationFragment = { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, scope: NodeScope, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null }, template?: { __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }> };

export type ListReservationFragment = { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } };

export type DetailStructureFragment = { __typename?: 'Structure', id: string, identifier: string };

export type ListStructureFragment = { __typename?: 'Structure', id: string, identifier: string };

export type ListTemplateFragment = { __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } };

export type DetailTemplateFragment = { __typename?: 'Template', id: string, extensions?: Array<string | null> | null, params?: any | null, interface: string, creator?: { __typename?: 'User', email: string } | null, node: { __typename?: 'Node', name: string, description: string, kind: NodeKind, hash: string, id: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope, collections: Array<{ __typename?: 'Collection', id: string, name: string }>, templates?: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null }, testresults: Array<{ __typename?: 'TestResult', id: string, result?: any | null, passed: boolean, case: { __typename?: 'TestCase', id: string, description?: string | null, key?: string | null, name?: string | null, node: { __typename?: 'Node', name: string } } }>, agent: { __typename?: 'Agent', id: string, instanceId: string, registry?: { __typename?: 'Registry', id: string } | null }, provisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type ReservableTemplateFragment = { __typename?: 'Template', id: string, name: string, interface: string, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string }, agent: { __typename?: 'Agent', status: AgentStatus, id: string, instanceId: string, registry?: { __typename?: 'Registry', id: string, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, user?: { __typename?: 'User', username: string, sub?: string | null } | null } | null }, provisions?: Array<{ __typename?: 'Provision', id: string, status: ProvisionStatus } | null> | null };

export type DisplayTemplateFragment = { __typename?: 'Template', id: string, name: string, interface: string, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string, description: string } };

export type ListTestResultFragment = { __typename?: 'TestResult', id: string, result?: any | null, passed: boolean, case: { __typename?: 'TestCase', id: string, description?: string | null, key?: string | null, name?: string | null, node: { __typename?: 'Node', name: string } } };

export type ResetAgentsMutationVariables = Exact<{ [key: string]: never; }>;


export type ResetAgentsMutation = { __typename?: 'Mutation', resetAgents?: { __typename?: 'ResetAgentsReturn', ok?: boolean | null } | null };

export type ResetProvisionsMutationVariables = Exact<{ [key: string]: never; }>;


export type ResetProvisionsMutation = { __typename?: 'Mutation', resetProvisions?: { __typename?: 'ResetProvisionsReturn', ok?: boolean | null } | null };

export type ResetReservationsMutationVariables = Exact<{ [key: string]: never; }>;


export type ResetReservationsMutation = { __typename?: 'Mutation', resetReservations?: { __typename?: 'ResetReservationsReturn', ok?: boolean | null } | null };

export type ResetAssignationsMutationVariables = Exact<{ [key: string]: never; }>;


export type ResetAssignationsMutation = { __typename?: 'Mutation', resetAssignations?: { __typename?: 'ResetAssignationsReturn', ok?: boolean | null } | null };

export type ResetNodesMutationVariables = Exact<{ [key: string]: never; }>;


export type ResetNodesMutation = { __typename?: 'Mutation', resetNodes?: { __typename?: 'ResetNodesReturn', ok?: boolean | null } | null };

export type DeleteAgentMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteAgentMutation = { __typename?: 'Mutation', deleteAgent?: { __typename?: 'DeleteAgentReturn', id?: string | null } | null };

export type KickAgentMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type KickAgentMutation = { __typename?: 'Mutation', kickAgent?: { __typename?: 'Agent', id: string } | null };

export type BounceAgentMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type BounceAgentMutation = { __typename?: 'Mutation', bounceAgent?: { __typename?: 'Agent', id: string } | null };

export type TemplateMutationVariables = Exact<{
  interface: Scalars['String'];
  definition: DefinitionInput;
  instanceId: Scalars['ID'];
}>;


export type TemplateMutation = { __typename?: 'Mutation', createTemplate?: { __typename?: 'Template', id: string } | null };

export type CreateCommentMutationVariables = Exact<{
  id: Scalars['ID'];
  model: CommentableModels;
  descendents: Array<InputMaybe<DescendendInput>>;
  parent?: InputMaybe<Scalars['ID']>;
}>;


export type CreateCommentMutation = { __typename?: 'Mutation', createComment?: { __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null } | null };

export type ReplyToMutationVariables = Exact<{
  descendents: Array<InputMaybe<DescendendInput>>;
  parent: Scalars['ID'];
}>;


export type ReplyToMutation = { __typename?: 'Mutation', replyTo?: { __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null } | null };

export type ResolveCommentMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type ResolveCommentMutation = { __typename?: 'Mutation', resolveComment?: { __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null } | null };

export type DeleteNodeMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteNodeMutation = { __typename?: 'Mutation', deleteNode?: { __typename?: 'DeleteNodeReturn', id?: string | null } | null };

export type PurgeNodesMutationVariables = Exact<{ [key: string]: never; }>;


export type PurgeNodesMutation = { __typename?: 'Mutation', purgeNodes?: { __typename?: 'PurgeNodesReturn', ids?: Array<string | null> | null } | null };

export type ChangePermissionsMutationVariables = Exact<{
  type: SharableModels;
  object: Scalars['ID'];
  userAssignments?: InputMaybe<Array<InputMaybe<UserAssignmentInput>>>;
  groupAssignments?: InputMaybe<Array<InputMaybe<GroupAssignmentInput>>>;
}>;


export type ChangePermissionsMutation = { __typename?: 'Mutation', changePermissions?: { __typename?: 'ChangePermissionsResult', success?: boolean | null } | null };

export type AcknowledgeMutationVariables = Exact<{
  assignation: Scalars['ID'];
}>;


export type AcknowledgeMutation = { __typename?: 'Mutation', ack?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null };

export type AssignMutationVariables = Exact<{
  reservation: Scalars['ID'];
  args: Array<InputMaybe<Scalars['AnyInput']>>;
}>;


export type AssignMutation = { __typename?: 'Mutation', assign?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null };

export type LinkMutationVariables = Exact<{
  reservation: Scalars['ID'];
  provision: Scalars['ID'];
}>;


export type LinkMutation = { __typename?: 'Mutation', link?: { __typename?: 'Provision', reference: string } | null };

export type UnlinkMutationVariables = Exact<{
  reservation: Scalars['ID'];
  provision: Scalars['ID'];
  safe?: InputMaybe<Scalars['Boolean']>;
}>;


export type UnlinkMutation = { __typename?: 'Mutation', unlink?: { __typename?: 'Provision', reference: string } | null };

export type ProvideMutationVariables = Exact<{
  template: Scalars['ID'];
}>;


export type ProvideMutation = { __typename?: 'Mutation', provide?: { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string } | null };

export type ReserveMutationVariables = Exact<{
  instanceId: Scalars['ID'];
  node?: InputMaybe<Scalars['ID']>;
  hash?: InputMaybe<Scalars['String']>;
  template?: InputMaybe<Scalars['ID']>;
  params?: InputMaybe<ReserveParamsInput>;
  binds?: InputMaybe<ReserveBindsInput>;
  title?: InputMaybe<Scalars['String']>;
  imitate?: InputMaybe<Scalars['ID']>;
  allowAutoRequest?: InputMaybe<Scalars['Boolean']>;
}>;


export type ReserveMutation = { __typename?: 'Mutation', reserve?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string } | null };

export type UnassignMutationVariables = Exact<{
  assignation: Scalars['ID'];
}>;


export type UnassignMutation = { __typename?: 'Mutation', unassign?: { __typename?: 'Assignation', id: string } | null };

export type UnprovideMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type UnprovideMutation = { __typename?: 'Mutation', unprovide?: { __typename?: 'UnprovideReturn', id: string } | null };

export type UnreserveMutationVariables = Exact<{
  reservation: Scalars['ID'];
}>;


export type UnreserveMutation = { __typename?: 'Mutation', unreserve?: { __typename?: 'UnreserveResult', id: string } | null };

export type UpdateMirrorMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type UpdateMirrorMutation = { __typename?: 'Mutation', updateMirror?: { __typename?: 'UpdateMirrorReturn', id?: string | null } | null };

export type DeleteRepoMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteRepoMutation = { __typename?: 'Mutation', deleterepo?: { __typename?: 'DeleteRepoReturn', id?: string | null } | null };

export type CreateMirrorMutationVariables = Exact<{
  url: Scalars['String'];
  name: Scalars['String'];
}>;


export type CreateMirrorMutation = { __typename?: 'Mutation', createMirror?: { __typename?: 'CreateMirrorReturn', created?: boolean | null, repo?: { __typename: 'MirrorRepository', id: string, url?: string | null, name?: string | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null } | null } | null };

export type AgentsQueryVariables = Exact<{
  app?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AgentStatusInput>>>;
}>;


export type AgentsQuery = { __typename?: 'Query', agents?: Array<{ __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null> | null };

export type MyAgentsQueryVariables = Exact<{
  app?: InputMaybe<Scalars['String']>;
  status?: InputMaybe<Array<InputMaybe<AgentStatusInput>>>;
}>;


export type MyAgentsQuery = { __typename?: 'Query', myagents?: Array<{ __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null> | null };

export type DetailAgentQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailAgentQuery = { __typename?: 'Query', agent?: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, name: string, templates: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }> } | null };

export type PortAgentQueryVariables = Exact<{
  clientId: Scalars['ID'];
  instanceId: Scalars['ID'];
}>;


export type PortAgentQuery = { __typename?: 'Query', agent?: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, name: string, templates: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }> } | null };

export type AgentOptionsQueryVariables = Exact<{
  registry?: InputMaybe<Scalars['ID']>;
  search?: InputMaybe<Scalars['String']>;
}>;


export type AgentOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Agent', value: string, label: string } | null> | null };

export type DetailAssignationQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailAssignationQuery = { __typename?: 'Query', assignation?: { __typename?: 'Assignation', returns?: Array<any | null> | null, id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, parent?: { __typename?: 'Assignation', id: string, reservation?: { __typename?: 'Reservation', id: string, node: { __typename?: 'Node', id: string, name: string } } | null } | null, provision?: { __typename?: 'Provision', status: ProvisionStatus, id: string, reference: string, createdAt: any, params?: { __typename?: 'ProvisionParams', autoUnprovide?: boolean | null } | null, agent?: { __typename?: 'Agent', name: string } | null, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null } | null, reservation?: { __typename?: 'Reservation', id: string, reference: string, status: ReservationStatus, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string, interfaces?: Array<string | null> | null, meta?: any | null, kind: NodeKind, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string } | null } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, log?: Array<{ __typename?: 'AssignationLog', message?: string | null, level: AssignationLogLevel } | null> | null } | null };

export type ReferencedAssignationsQueryVariables = Exact<{
  reference: Scalars['String'];
  parent?: InputMaybe<Scalars['ID']>;
}>;


export type ReferencedAssignationsQuery = { __typename?: 'Query', assignations?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, parent?: { __typename?: 'Assignation', id: string, reservation?: { __typename?: 'Reservation', id: string, node: { __typename?: 'Node', id: string, name: string } } | null } | null, provision?: { __typename?: 'Provision', status: ProvisionStatus, id: string, reference: string, createdAt: any, params?: { __typename?: 'ProvisionParams', autoUnprovide?: boolean | null } | null, agent?: { __typename?: 'Agent', name: string } | null, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null } | null, reservation?: { __typename?: 'Reservation', id: string, reference: string, status: ReservationStatus, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string, interfaces?: Array<string | null> | null, meta?: any | null, kind: NodeKind, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string } | null } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, creator?: { __typename?: 'User', email: string, sub?: string | null } | null, log?: Array<{ __typename?: 'AssignationLog', message?: string | null, level: AssignationLogLevel } | null> | null } | null> | null };

export type NodeAssignationsQueryVariables = Exact<{
  reference: Scalars['String'];
  parent: Scalars['ID'];
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  order?: InputMaybe<Scalars['String']>;
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
}>;


export type NodeAssignationsQuery = { __typename?: 'Query', assignations?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null> | null };

export type RequestsQueryVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type RequestsQuery = { __typename?: 'Query', requests?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null> | null };

export type MyRequestsQueryVariables = Exact<{ [key: string]: never; }>;


export type MyRequestsQuery = { __typename?: 'Query', myrequests?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null> | null };

export type RequestsHistoryQueryVariables = Exact<{
  limit?: InputMaybe<Scalars['Int']>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
}>;


export type RequestsHistoryQuery = { __typename?: 'Query', myrequests?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null> | null };

export type FilteredAssignationsQueryVariables = Exact<{
  exclude?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<AssignationStatusInput>>>;
  limit?: InputMaybe<Scalars['Int']>;
}>;


export type FilteredAssignationsQuery = { __typename?: 'Query', myrequests?: Array<{ __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null> | null };

export type CollectionsQueryVariables = Exact<{
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
}>;


export type CollectionsQuery = { __typename?: 'Query', collections?: Array<{ __typename: 'Collection', id: string, name: string, description: string } | null> | null };

export type CollectionQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type CollectionQuery = { __typename?: 'Query', collection?: { __typename?: 'Collection', name: string, description: string, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null } | null };

export type SearchCollectionsQueryVariables = Exact<{
  search?: InputMaybe<Scalars['String']>;
  values?: InputMaybe<Array<Scalars['ID']>>;
}>;


export type SearchCollectionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Collection', value: string, label: string } | null> | null };

export type CommentsForQueryVariables = Exact<{
  id: Scalars['ID'];
  model: CommentableModels;
}>;


export type CommentsForQuery = { __typename?: 'Query', commentsfor?: Array<{ __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null } | null> | null };

export type MyMentionsQueryVariables = Exact<{ [key: string]: never; }>;


export type MyMentionsQuery = { __typename?: 'Query', mymentions?: Array<{ __typename?: 'Comment', id: string, createdAt: any, resolved?: any | null, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', id: string, sub?: string | null }>, resolvedBy?: { __typename?: 'User', sub?: string | null } | null } | null> | null };

export type DetailCommentQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailCommentQuery = { __typename?: 'Query', comment?: { __typename?: 'Comment', id: string, resolved?: any | null, createdAt: any, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', sub?: string | null }> } | null };

export type ArgPortTypesQueryVariables = Exact<{ [key: string]: never; }>;


export type ArgPortTypesQuery = { __typename?: 'Query', args?: { __typename?: '__Type', possibleTypes?: Array<{ __typename?: '__Type', value?: string | null, label?: string | null }> | null } | null };

export type KwargPortTypesQueryVariables = Exact<{ [key: string]: never; }>;


export type KwargPortTypesQuery = { __typename?: 'Query', kwargs?: { __typename?: '__Type', possibleTypes?: Array<{ __typename?: '__Type', value?: string | null, label?: string | null }> | null } | null };

export type ReturnPortTypesQueryVariables = Exact<{ [key: string]: never; }>;


export type ReturnPortTypesQuery = { __typename?: 'Query', returns?: { __typename?: '__Type', possibleTypes?: Array<{ __typename?: '__Type', value?: string | null, label?: string | null }> | null } | null };

export type StructureOptionsQueryVariables = Exact<{ [key: string]: never; }>;


export type StructureOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Structure', value: string, label: string } | null> | null };

export type DetailNodeQueryVariables = Exact<{
  id?: InputMaybe<Scalars['ID']>;
  hash?: InputMaybe<Scalars['String']>;
  reservation?: InputMaybe<Scalars['ID']>;
  template?: InputMaybe<Scalars['ID']>;
  assignation?: InputMaybe<Scalars['ID']>;
}>;


export type DetailNodeQuery = { __typename?: 'Query', node?: { __typename?: 'Node', name: string, description: string, kind: NodeKind, hash: string, id: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope, collections: Array<{ __typename?: 'Collection', id: string, name: string }>, templates?: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null } | null };

export type MiniNodeByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type MiniNodeByIdQuery = { __typename?: 'Query', node?: { __typename?: 'Node', name: string, description: string, kind: NodeKind, id: string, meta?: any | null, hash: string, scope: NodeScope } | null };

export type NodesQueryVariables = Exact<{
  search?: InputMaybe<Scalars['String']>;
  interfaces?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  collections?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  restrict?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  templated?: InputMaybe<Scalars['Boolean']>;
  scopes?: InputMaybe<Array<InputMaybe<NodeScope>>>;
}>;


export type NodesQuery = { __typename?: 'Query', allnodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null };

export type RespositoryNodesQueryVariables = Exact<{
  repository?: InputMaybe<Scalars['ID']>;
}>;


export type RespositoryNodesQuery = { __typename?: 'Query', allnodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null };

export type AssignNodeQueryVariables = Exact<{
  id?: InputMaybe<Scalars['ID']>;
}>;


export type AssignNodeQuery = { __typename?: 'Query', node?: { __typename?: 'Node', name: string, hash: string, description: string, scope: NodeScope, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null } | null };

export type PermissionOptionsQueryVariables = Exact<{
  model: SharableModels;
  search?: InputMaybe<Scalars['String']>;
}>;


export type PermissionOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Permission', label: string, value: string } | null> | null };

export type PermissionsOfQueryVariables = Exact<{
  model: SharableModels;
  id: Scalars['ID'];
}>;


export type PermissionsOfQuery = { __typename?: 'Query', permissionsOf?: { __typename?: 'PermissionsOfReturn', available?: Array<{ __typename?: 'Permission', name: string } | null> | null, options?: Array<{ __typename?: 'Permission', label: string, value: string } | null> | null, groupAssignments?: Array<{ __typename?: 'GroupAssignment', permissions: Array<string | null>, group: { __typename?: 'Group', name: string } } | null> | null, userAssignments?: Array<{ __typename?: 'UserAssignment', permissions: Array<string | null>, user: { __typename?: 'User', id: string, sub?: string | null, username: string, email: string } } | null> | null } | null };

export type UnfoldProvenanceQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type UnfoldProvenanceQuery = { __typename?: 'Query', assignation?: { __typename?: 'Assignation', id: string, createdAt: any, children: Array<{ __typename?: 'Assignation', id: string, createdAt: any }> } | null };

export type DetailProvisionQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailProvisionQuery = { __typename?: 'Query', provision?: { __typename?: 'Provision', mode: ProvisionMode, createdAt: any, statusmessage: string, status: ProvisionStatus, id: string, reference: string, params?: { __typename?: 'ProvisionParams', autoUnprovide?: boolean | null } | null, agent?: { __typename?: 'Agent', name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, template: { __typename?: 'Template', id: string, extensions?: Array<string | null> | null, params?: any | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null, meta?: any | null }, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }, creator?: { __typename?: 'User', email: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, causedReservations: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, assignations?: Array<{ __typename?: 'Assignation', id: string, reference: string, status: AssignationStatus, creator?: { __typename?: 'User', email: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null } | null> | null, reservations: Array<{ __typename?: 'Reservation', title?: string | null, id: string, reference: string, status: ReservationStatus, node: { __typename?: 'Node', name: string }, waiter: { __typename?: 'Waiter', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } }>, log?: Array<{ __typename?: 'ProvisionLog', message?: string | null, level: ProvisionLogLevel, createdAt: any } | null> | null } | null };

export type MyProvisionsQueryVariables = Exact<{ [key: string]: never; }>;


export type MyProvisionsQuery = { __typename?: 'Query', myprovisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type ProvisionsQueryVariables = Exact<{ [key: string]: never; }>;


export type ProvisionsQuery = { __typename?: 'Query', provisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type FilteredProvisionsQueryVariables = Exact<{
  exclude?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ProvisionStatusInput>>>;
}>;


export type FilteredProvisionsQuery = { __typename?: 'Query', myprovisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type AgentProvisionsQueryVariables = Exact<{
  agent: Scalars['ID'];
}>;


export type AgentProvisionsQuery = { __typename?: 'Query', allprovisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type LinkableProvisionsQueryVariables = Exact<{
  reservation: Scalars['ID'];
}>;


export type LinkableProvisionsQuery = { __typename?: 'Query', linkableprovisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type LinkableProvisionsOptionsQueryVariables = Exact<{
  reservation: Scalars['ID'];
}>;


export type LinkableProvisionsOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Provision', value: string, label: string } | null> | null };

export type ClientProvisionsQueryVariables = Exact<{
  clientId: Scalars['String'];
}>;


export type ClientProvisionsQuery = { __typename?: 'Query', allprovisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null };

export type RegistryOptionsQueryVariables = Exact<{
  search?: InputMaybe<Scalars['String']>;
}>;


export type RegistryOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Registry', label: string, value: string } | null> | null };

export type RepositoriesQueryVariables = Exact<{ [key: string]: never; }>;


export type RepositoriesQuery = { __typename?: 'Query', allrepositories?: Array<{ __typename: 'AppRepository', id: string, name?: string | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null } | { __typename: 'MirrorRepository', id: string, url?: string | null, name?: string | null, nodes?: Array<{ __typename?: 'Node', scope: NodeScope, id: string, name: string } | null> | null } | null> | null };

export type DetailRepositoryQueryVariables = Exact<{
  id?: InputMaybe<Scalars['ID']>;
}>;


export type DetailRepositoryQuery = { __typename?: 'Query', repository?: { __typename?: 'AppRepository', name?: string | null, installedAt: any, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null } | { __typename?: 'MirrorRepository', name?: string | null, url?: string | null, nodes?: Array<{ __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null> | null } | null };

export type DetailReservationQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailReservationQuery = { __typename?: 'Query', reservation?: { __typename?: 'Reservation', allowAutoRequest: boolean, channel: string, title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string, params?: { __typename?: 'ReserveParams', autoProvide?: boolean | null, autoUnprovide?: boolean | null, minimalInstances?: number | null, desiredInstances?: number | null } | null, binds?: { __typename?: 'Binds', clients?: Array<{ __typename?: 'LokClient', id: string, name: string, clientId: string } | null> | null, templates?: Array<{ __typename?: 'Template', id: string, name: string, interface: string } | null> | null } | null, provision?: { __typename?: 'Provision', reference: string, id: string, access: ProvisionAccess, status: ProvisionStatus, creator?: { __typename?: 'User', id: string, username: string } | null, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null } | null, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null }, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, scope: NodeScope, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, template?: { __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }>, log?: Array<{ __typename?: 'ReservationLog', message?: string | null, level: ReservationLogLevel } | null> | null, creator?: { __typename?: 'User', email: string } | null } | null, linkableprovisions?: Array<{ __typename?: 'Provision', id: string, template: { __typename?: 'Template', agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', app?: { __typename?: 'LokApp', identifier: string, version: string } | null, user?: { __typename?: 'User', id: string, email: string } | null } | null } } } | null> | null };

export type ProvisionReferenceReservationQueryVariables = Exact<{
  provision: Scalars['ID'];
  reference: Scalars['String'];
}>;


export type ProvisionReferenceReservationQuery = { __typename?: 'Query', reservation?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, scope: NodeScope, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null }, template?: { __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null, provisions: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> }> } | null };

export type MyReservationsQueryVariables = Exact<{ [key: string]: never; }>;


export type MyReservationsQuery = { __typename?: 'Query', myreservations?: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null };

export type ReservationsQueryVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type ReservationsQuery = { __typename?: 'Query', reservations?: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null };

export type DeployReservationsQueryVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type DeployReservationsQuery = { __typename?: 'Query', reservations?: Array<{ __typename?: 'Reservation', id: string, status: ReservationStatus, title?: string | null, waiter: { __typename?: 'Waiter', clientId: string }, node: { __typename?: 'Node', id: string, name: string, description: string }, provisions: Array<{ __typename?: 'Provision', agent?: { __typename?: 'Agent', clientId: string } | null }> } | null> | null };

export type ThisFilteredReservationsQueryVariables = Exact<{
  exclude?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  nodeInterfaces?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  templateParams?: InputMaybe<Array<InputMaybe<TemplateParamInput>>>;
  inputPortDemands?: InputMaybe<Array<InputMaybe<PortDemandInput>>>;
  instanceId: Scalars['String'];
}>;


export type ThisFilteredReservationsQuery = { __typename?: 'Query', reservations?: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null };

export type FilteredReservationsQueryVariables = Exact<{
  exclude?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
  filter?: InputMaybe<Array<InputMaybe<ReservationStatusInput>>>;
}>;


export type FilteredReservationsQuery = { __typename?: 'Query', myreservations?: Array<{ __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null };

export type DetailStructureQueryVariables = Exact<{
  identifier?: InputMaybe<Scalars['String']>;
}>;


export type DetailStructureQuery = { __typename?: 'Query', structure?: { __typename?: 'Structure', id: string, identifier: string } | null };

export type StructuresQueryVariables = Exact<{ [key: string]: never; }>;


export type StructuresQuery = { __typename?: 'Query', structures?: Array<{ __typename?: 'Structure', id: string, identifier: string } | null> | null };

export type TemplatesQueryVariables = Exact<{
  active?: InputMaybe<Scalars['Boolean']>;
  package?: InputMaybe<Scalars['String']>;
  interface?: InputMaybe<Scalars['String']>;
  node?: InputMaybe<Scalars['ID']>;
}>;


export type TemplatesQuery = { __typename?: 'Query', templates?: Array<{ __typename?: 'Template', id: string, name: string, node: { __typename?: 'Node', id: string, name: string } } | null> | null };

export type AssignableTemplatesQueryVariables = Exact<{
  node?: InputMaybe<Scalars['ID']>;
}>;


export type AssignableTemplatesQuery = { __typename?: 'Query', templates?: Array<{ __typename?: 'Template', id: string, name: string, node: { __typename?: 'Node', id: string, name: string }, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, user?: { __typename?: 'User', username: string } | null } | null } } | null> | null };

export type ReservableTemplatesQueryVariables = Exact<{
  node?: InputMaybe<Scalars['ID']>;
  templateParams?: InputMaybe<Array<InputMaybe<TemplateParamInput>>>;
  hash?: InputMaybe<Scalars['String']>;
  template?: InputMaybe<Scalars['ID']>;
}>;


export type ReservableTemplatesQuery = { __typename?: 'Query', reservableTemplates?: Array<{ __typename?: 'Template', id: string, name: string, interface: string, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string }, agent: { __typename?: 'Agent', status: AgentStatus, id: string, instanceId: string, registry?: { __typename?: 'Registry', id: string, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, user?: { __typename?: 'User', username: string, sub?: string | null } | null } | null }, provisions?: Array<{ __typename?: 'Provision', id: string, status: ProvisionStatus } | null> | null } | null> | null };

export type HashReservableTemplatesQueryVariables = Exact<{
  hash: Scalars['String'];
}>;


export type HashReservableTemplatesQuery = { __typename?: 'Query', reservableTemplates?: Array<{ __typename?: 'Template', id: string, name: string, interface: string, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string }, agent: { __typename?: 'Agent', status: AgentStatus, id: string, instanceId: string, registry?: { __typename?: 'Registry', id: string, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', id: string, version: string, identifier: string } | null, user?: { __typename?: 'User', username: string, sub?: string | null } | null } | null }, provisions?: Array<{ __typename?: 'Provision', id: string, status: ProvisionStatus } | null> | null } | null> | null };

export type DetailTemplateQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailTemplateQuery = { __typename?: 'Query', template?: { __typename?: 'Template', id: string, extensions?: Array<string | null> | null, params?: any | null, interface: string, creator?: { __typename?: 'User', email: string } | null, node: { __typename?: 'Node', name: string, description: string, kind: NodeKind, hash: string, id: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope, collections: Array<{ __typename?: 'Collection', id: string, name: string }>, templates?: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null }, testresults: Array<{ __typename?: 'TestResult', id: string, result?: any | null, passed: boolean, case: { __typename?: 'TestCase', id: string, description?: string | null, key?: string | null, name?: string | null, node: { __typename?: 'Node', name: string } } }>, agent: { __typename?: 'Agent', id: string, instanceId: string, registry?: { __typename?: 'Registry', id: string } | null }, provisions?: Array<{ __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null> | null } | null };

export type TemplateOptionsQueryVariables = Exact<{
  node: Scalars['ID'];
}>;


export type TemplateOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Template', value: string, label: string, node: { __typename?: 'Node', id: string, name: string } } | null> | null };

export type SearchTemplateOptionsQueryVariables = Exact<{
  node: Scalars['ID'];
  search?: InputMaybe<Scalars['String']>;
}>;


export type SearchTemplateOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'Template', value: string, label: string, node: { __typename?: 'Node', id: string, name: string } } | null> | null };

export type NodeTemplatesQueryVariables = Exact<{
  search?: InputMaybe<Scalars['String']>;
  scopes?: InputMaybe<Array<InputMaybe<NodeScope>>>;
}>;


export type NodeTemplatesQuery = { __typename?: 'Query', templates?: Array<{ __typename?: 'Template', id: string, name: string, interface: string, node: { __typename?: 'Node', scope: NodeScope, id: string, name: string, description: string } } | null> | null };

export type UserOptionsQueryVariables = Exact<{
  search?: InputMaybe<Scalars['String']>;
}>;


export type UserOptionsQuery = { __typename?: 'Query', options?: Array<{ __typename?: 'User', value: string, label: string } | null> | null };

export type MeQueryVariables = Exact<{ [key: string]: never; }>;


export type MeQuery = { __typename?: 'Query', me?: { __typename?: 'User', id: string, email: string } | null };

export type UserQueryVariables = Exact<{
  email?: InputMaybe<Scalars['String']>;
}>;


export type UserQuery = { __typename?: 'Query', user?: { __typename?: 'User', id: string, username: string, email: string } | null };

export type AgentsEventSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type AgentsEventSubscription = { __typename?: 'Subscription', agentsEvent?: { __typename?: 'AgentEvent', deleted?: string | null, created?: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, updated?: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null } | null };

export type WatchAssignationSubscriptionVariables = Exact<{
  id: Scalars['ID'];
}>;


export type WatchAssignationSubscription = { __typename?: 'Subscription', assignation?: { __typename?: 'AssignationEvent', log?: { __typename?: 'AssignationLogEvent', message?: string | null, level?: string | null } | null } | null };

export type WatchMyRequestsSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type WatchMyRequestsSubscription = { __typename?: 'Subscription', myrequests?: { __typename?: 'AssignationsEvent', delete?: string | null, create?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null, update?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null } | null };

export type WatchRequestsSubscriptionVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type WatchRequestsSubscription = { __typename?: 'Subscription', requests?: { __typename?: 'AssignationsEvent', delete?: string | null, create?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null, update?: { __typename?: 'Assignation', id: string, status: AssignationStatus, statusmessage: string, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, returns?: Array<any | null> | null } | null } | null };

export type WatchMyTodosSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type WatchMyTodosSubscription = { __typename?: 'Subscription', mytodos?: { __typename?: 'TodoEvent', delete?: string | null, create?: { __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null, update?: { __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null } | null };

export type WatchTodosSubscriptionVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type WatchTodosSubscription = { __typename?: 'Subscription', todos?: { __typename?: 'TodoEvent', delete?: string | null, create?: { __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null, update?: { __typename?: 'Assignation', returns?: Array<any | null> | null, statusmessage: string, id: string, status: AssignationStatus, args?: Array<any | null> | null, kwargs?: any | null, reference: string, progress?: number | null, reservation?: { __typename?: 'Reservation', id: string, title?: string | null, node: { __typename?: 'Node', id: string, name: string, interfaces?: Array<string | null> | null }, template?: { __typename?: 'Template', interface: string, agent: { __typename?: 'Agent', id: string, instanceId: string, status: AgentStatus, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null } | null } | null };

export type NodesEventSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type NodesEventSubscription = { __typename?: 'Subscription', nodes?: { __typename?: 'NodeEvent', deleted?: string | null, updated?: { __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null, created?: { __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null } | null };

export type AssignNodeEventSubscriptionVariables = Exact<{
  id: Scalars['ID'];
}>;


export type AssignNodeEventSubscription = { __typename?: 'Subscription', nodeEvent?: { __typename?: 'Node', name: string, hash: string, description: string, scope: NodeScope, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null } | null };

export type DetailNodeEventSubscriptionVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DetailNodeEventSubscription = { __typename?: 'Subscription', nodeEvent?: { __typename?: 'Node', name: string, description: string, kind: NodeKind, hash: string, id: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope, collections: Array<{ __typename?: 'Collection', id: string, name: string }>, templates?: Array<{ __typename?: 'Template', id: string, interface: string, agent: { __typename?: 'Agent', registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null> | null, isTestFor?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, tests?: Array<{ __typename?: 'Node', id: string, name: string } | null> | null, protocols?: Array<{ __typename?: 'Protocol', id: string, name: string } | null> | null, args?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, label?: string | null, nullable: boolean, description?: string | null, scope: Scope, kind: PortKind, identifier?: Identifier | null, default?: any | null, groups?: Array<string | null> | null, effects?: Array<{ __typename: 'Effect', kind: EffectKind, message?: string | null, dependencies?: Array<{ __typename?: 'Dependency', key?: string | null, condition: LogicalCondition, value: any } | null> | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, annotations?: Array<{ __typename?: 'AttributePredicate' } | { __typename?: 'CustomAnnotation' } | { __typename?: 'IsPredicate' } | { __typename?: 'ValueRange', min: number, max: number } | null> | null } | null> | null, portGroups?: Array<{ __typename?: 'PortGroup', key: string, hidden?: boolean | null } | null> | null } | null };

export type WatchInterfaceSubscriptionVariables = Exact<{
  interface?: InputMaybe<Scalars['String']>;
}>;


export type WatchInterfaceSubscription = { __typename?: 'Subscription', nodes?: { __typename?: 'NodeEvent', deleted?: string | null, updated?: { __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null, created?: { __typename?: 'Node', id: string, name: string, kind: NodeKind, hash: string, description: string, interfaces?: Array<string | null> | null, meta?: any | null, scope: NodeScope } | null } | null };

export type WatchProvisionSubscriptionVariables = Exact<{
  id: Scalars['ID'];
}>;


export type WatchProvisionSubscription = { __typename?: 'Subscription', provision?: { __typename?: 'ProvisionEvent', log?: { __typename?: 'ProvisionLogEvent', message?: string | null, level?: string | null } | null } | null };

export type WatchProvisionsSubscriptionVariables = Exact<{
  identifier: Scalars['String'];
}>;


export type WatchProvisionsSubscription = { __typename?: 'Subscription', provisions?: { __typename?: 'ProvisionsEvent', delete?: string | null, create?: { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null, update?: { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null } | null };

export type WatchMyProvisionsSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type WatchMyProvisionsSubscription = { __typename?: 'Subscription', myprovisions?: { __typename?: 'ProvisionsEvent', delete?: string | null, create?: { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null, update?: { __typename?: 'Provision', statusmessage: string, status: ProvisionStatus, id: string, reference: string, template: { __typename?: 'Template', id: string, interface: string, extensions?: Array<string | null> | null }, agent?: { __typename?: 'Agent', id: string, name: string, instanceId: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } | null, reservations: Array<{ __typename?: 'Reservation', id: string, reference: string, creator?: { __typename?: 'User', username: string } | null, app?: { __typename?: 'LokApp', version: string, identifier: string } | null }> } | null } | null };

export type WatchReservationSubscriptionVariables = Exact<{
  id: Scalars['ID'];
}>;


export type WatchReservationSubscription = { __typename?: 'Subscription', reservation?: { __typename?: 'ReservationEvent', log?: { __typename?: 'ReservationLogEvent', message?: string | null, level?: string | null } | null } | null };

export type WatchReservationsSubscriptionVariables = Exact<{
  instanceId: Scalars['String'];
}>;


export type WatchReservationsSubscription = { __typename?: 'Subscription', reservations?: { __typename?: 'ReservationsEvent', delete?: string | null, create?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string } | null, update?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, id: string, reference: string, statusmessage: string } | null } | null };

export type WatchMyReservationsSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type WatchMyReservationsSubscription = { __typename?: 'Subscription', myreservations?: { __typename?: 'ReservationsEvent', delete?: string | null, create?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null, update?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null, returns?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null> | null, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null } | null> | null }, waiter: { __typename?: 'Waiter', id: string, registry?: { __typename?: 'Registry', name?: string | null, client: { __typename?: 'LokClient', clientId: string }, app?: { __typename?: 'LokApp', version: string, identifier: string } | null, user?: { __typename?: 'User', sub?: string | null, username: string } | null } | null } } | null } | null };

export type WatchReservationsOnProvisionSubscriptionVariables = Exact<{
  instanceId: Scalars['String'];
  provision: Scalars['String'];
}>;


export type WatchReservationsOnProvisionSubscription = { __typename?: 'Subscription', reservations?: { __typename?: 'ReservationsEvent', delete?: string | null, create?: { __typename?: 'Reservation', title?: string | null, status: ReservationStatus, statusmessage: string, id: string, reference: string, allowAutoRequest: boolean, node: { __typename?: 'Node', id: string, kind: NodeKind, name: string, hash: string, description: string, interfaces?: Array<string | null> | null, args?: Array<{ __typename: 'Port', key: string, kind: PortKind, identifier?: Identifier | null, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, nullable: boolean, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, child?: { __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | { __typename: 'CustomReturnWidget', kind: string, hook?: string | null, ward?: string | null } | { __typename: 'ImageReturnWidget', kind: string, query?: string | null, ward?: string | null } | null } | null, variants?: Array<{ __typename?: 'ChildPort', kind: PortKind, identifier?: Identifier | null, scope: Scope, assignWidget?: { __typename: 'BoolWidget', kind: string } | { __typename: 'ChoiceWidget', kind: string, choices?: Array<{ __typename?: 'Choice', value: any, label: string, description?: string | null } | null> | null } | { __typename: 'ColorWidget', kind: string } | { __typename: 'CustomWidget', kind: string, hook?: string | null } | { __typename: 'DateWidget', kind: string } | { __typename: 'IntWidget', kind: string } | { __typename: 'LinkWidget', kind: string } | { __typename: 'QueryWidget', kind: string } | { __typename: 'SearchWidget', kind: string, query: string, ward: string } | { __typename: 'SliderWidget', kind: string, min?: number | null, max?: number | null, step?: number | null } | { __typename: 'StringWidget', kind: string, placeholder?: string | null, asParagraph?: boolean | null } | { __typename: 'TemplateWidget', kind: string } | null, returnWidget?: { __typename: 'ChoiceReturnWidget', kind: string, choices?: Array<{ __typename?: 'Choice', label: string, value: any, description?: string | null } | null> | null } | 