import { gql } from '@apollo/client';
import * as Apollo from '@apollo/client';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
const defaultOptions = {} as const;
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  Any: any;
  DateTime: any;
  EventValue: any;
  GenericScalar: any;
  ImageFile: any;
};

export type ArgNode = FlowNode & FlowNodeCommons & {
  __typename?: 'ArgNode';
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

/**
 * A filter node that utilizes
 * a call to the associated rekuest node
 * to filter a stream based on a predicate
 * (the rekuest node must return a boolean)
 */
export type ArkitektFilterNode = FlowNode & FlowNodeCommons & RetriableNode & {
  __typename?: 'ArkitektFilterNode';
  allowLocal: Scalars['Boolean'];
  assignTimeout: Scalars['Float'];
  binds?: Maybe<Binds>;
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  hash: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  kind: Scalars['String'];
  mapStrategy: MapStrategy;
  maxRetries: Scalars['Int'];
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  reserveTimeout: Scalars['Float'];
  retryDelay: Scalars['Int'];
  typename: Scalars['String'];
  yieldTimeout: Scalars['Float'];
};

/**
 * A map node that utilizes
 * a call to the associated rekuest node
 * run a task
 */
export type ArkitektNode = FlowNode & FlowNodeCommons & RetriableNode & {
  __typename?: 'ArkitektNode';
  allowLocal: Scalars['Boolean'];
  assignTimeout: Scalars['Float'];
  binds?: Maybe<Binds>;
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  hash: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  kind: Scalars['String'];
  mapStrategy: MapStrategy;
  maxRetries: Scalars['Int'];
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  reserveTimeout: Scalars['Float'];
  retryDelay: Scalars['Int'];
  typename: Scalars['String'];
  yieldTimeout: Scalars['Float'];
};

export type Binds = {
  __typename?: 'Binds';
  clients?: Maybe<Array<Maybe<Scalars['String']>>>;
  templates?: Maybe<Array<Maybe<Scalars['String']>>>;
};

export type BindsInput = {
  clients?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  templates?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
};

export type ChangePermissionsResult = {
  __typename?: 'ChangePermissionsResult';
  message?: Maybe<Scalars['String']>;
  success?: Maybe<Scalars['Boolean']>;
};

export type ChildPortInput = {
  /** Description of the Widget */
  assignWidget?: InputMaybe<WidgetInput>;
  child?: InputMaybe<ChildPortInput>;
  /** The identifier */
  identifier?: InputMaybe<Scalars['String']>;
  /** The type of this argument */
  kind: StreamKind;
  nullable?: InputMaybe<Scalars['Boolean']>;
  /** A return widget */
  returnWidget?: InputMaybe<ReturnWidgetInput>;
  /** The scope of this argument */
  scope: Scope;
  variants?: InputMaybe<Array<InputMaybe<ChildPortInput>>>;
};

export type Choice = {
  __typename?: 'Choice';
  label: Scalars['String'];
  value: Scalars['Any'];
};

export type ChoiceInput = {
  label: Scalars['String'];
  value: Scalars['Any'];
};

/**
 * A comment
 *
 * A comment is a user generated comment on a commentable object. A comment can be a reply to another comment or a top level comment.
 * Comments can be nested to any depth. A comment can be edited and deleted by the user that created it.
 */
export type Comment = {
  __typename?: 'Comment';
  /** Comments that are replies to this comment */
  children?: Maybe<Array<Maybe<Comment>>>;
  /** The content type of the commentable object */
  contentType?: Maybe<CommentableModels>;
  createdAt: Scalars['DateTime'];
  /** The descendents of the comment (this referes to the Comment Tree) */
  descendents?: Maybe<Array<Maybe<Descendent>>>;
  id: Scalars['ID'];
  mentions: Array<User>;
  objectId: Scalars['Int'];
  parent?: Maybe<Comment>;
  resolved?: Maybe<Scalars['DateTime']>;
  resolvedBy?: Maybe<User>;
  text: Scalars['String'];
  user: User;
};


/**
 * A comment
 *
 * A comment is a user generated comment on a commentable object. A comment can be a reply to another comment or a top level comment.
 * Comments can be nested to any depth. A comment can be edited and deleted by the user that created it.
 */
export type CommentChildrenArgs = {
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
};

/** A node in the comment tree */
export type CommentNode = {
  children?: Maybe<Array<Maybe<Descendent>>>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
};

export enum CommentableModels {
  FlowCondition = 'FLOW_CONDITION',
  FlowConditionevent = 'FLOW_CONDITIONEVENT',
  FlowConditionsnapshot = 'FLOW_CONDITIONSNAPSHOT',
  FlowFlow = 'FLOW_FLOW',
  FlowReactivetemplate = 'FLOW_REACTIVETEMPLATE',
  FlowRun = 'FLOW_RUN',
  FlowRunevent = 'FLOW_RUNEVENT',
  FlowRunlog = 'FLOW_RUNLOG',
  FlowSnapshot = 'FLOW_SNAPSHOT',
  FlowWorkspace = 'FLOW_WORKSPACE'
}

export type Condition = {
  __typename?: 'Condition';
  createdAt: Scalars['DateTime'];
  createdBy?: Maybe<User>;
  createdWhile?: Maybe<Scalars['String']>;
  events: Array<ConditionEvent>;
  flow?: Maybe<Flow>;
  id: Scalars['ID'];
  latestSnapshot?: Maybe<ConditionSnapshot>;
  pinned?: Maybe<Scalars['Boolean']>;
  /** The users that have pinned the position */
  pinnedBy: Array<User>;
  provision?: Maybe<Scalars['String']>;
  snapshotInterval?: Maybe<Scalars['Int']>;
  snapshots: Array<ConditionSnapshot>;
};

export type ConditionEvent = {
  __typename?: 'ConditionEvent';
  condition?: Maybe<Condition>;
  createdAt: Scalars['DateTime'];
  id: Scalars['ID'];
  snapshot: Array<ConditionSnapshot>;
  source?: Maybe<Scalars['String']>;
  state: ContractStatus;
  value: Scalars['String'];
};

export type ConditionEvents = {
  __typename?: 'ConditionEvents';
  create?: Maybe<ConditionEvent>;
  deleted?: Maybe<Scalars['ID']>;
  update?: Maybe<ConditionEvent>;
};

export type ConditionSnapshot = {
  __typename?: 'ConditionSnapshot';
  condition?: Maybe<Condition>;
  createdAt: Scalars['DateTime'];
  events: Array<ConditionEvent>;
  id: Scalars['ID'];
  status?: Maybe<Scalars['String']>;
};

/** Scope of the Port */
export enum ContractStatus {
  Active = 'ACTIVE',
  Inactive = 'INACTIVE'
}

export type DeleteConditionReturn = {
  __typename?: 'DeleteConditionReturn';
  id: Scalars['ID'];
};

export type DeleteConditionSnapshotReturn = {
  __typename?: 'DeleteConditionSnapshotReturn';
  id: Scalars['ID'];
};

export type DeleteFlowReturn = {
  __typename?: 'DeleteFlowReturn';
  id?: Maybe<Scalars['ID']>;
};

export type DeleteRunReturn = {
  __typename?: 'DeleteRunReturn';
  id: Scalars['ID'];
};

export type DeleteSnapshotReturn = {
  __typename?: 'DeleteSnapshotReturn';
  id: Scalars['ID'];
};

export type DeleteWorkspaceReturn = {
  __typename?: 'DeleteWorkspaceReturn';
  id?: Maybe<Scalars['ID']>;
};

export type DescendendInput = {
  /** Is this a bold leaf? */
  bold?: InputMaybe<Scalars['Boolean']>;
  children?: InputMaybe<Array<InputMaybe<DescendendInput>>>;
  /** Is this a code leaf? */
  code?: InputMaybe<Scalars['Boolean']>;
  /** Is this a italic leaf? */
  italic?: InputMaybe<Scalars['Boolean']>;
  /** The text of the leaf */
  text?: InputMaybe<Scalars['String']>;
  /** The type of the descendent */
  typename?: InputMaybe<Scalars['String']>;
  /** The user that is mentioned */
  user?: InputMaybe<Scalars['String']>;
};

/** A descendent of a node in the comment tree */
export type Descendent = {
  typename?: Maybe<Scalars['String']>;
};

export type EdgeInput = {
  id: Scalars['String'];
  source: Scalars['String'];
  sourceHandle: Scalars['String'];
  stream?: InputMaybe<Array<InputMaybe<StreamItemInput>>>;
  target: Scalars['String'];
  targetHandle: Scalars['String'];
  typename: Scalars['String'];
};

export type Event = {
  __typename?: 'Event';
  create?: Maybe<RunEvent>;
  deleted?: Maybe<Scalars['ID']>;
  update?: Maybe<RunEvent>;
};

/** Event Type for the Event Operator */
export enum EventTypeInput {
  /** COMPLETE (Value is none) */
  Complete = 'COMPLETE',
  /** Error (Value represent Exception) */
  Error = 'ERROR',
  /** NEXT (Value represent Item) */
  Next = 'NEXT',
  /** UNKNOWN (Should never be used) */
  Unknown = 'UNKNOWN'
}

export type FancyEdge = FlowEdge & FlowEdgeCommons & {
  __typename?: 'FancyEdge';
  id: Scalars['String'];
  source: Scalars['String'];
  sourceHandle: Scalars['String'];
  stream: Array<Maybe<StreamItem>>;
  target: Scalars['String'];
  targetHandle: Scalars['String'];
  typename: Scalars['String'];
};

export type Flow = {
  __typename?: 'Flow';
  /** Is this a brittle flow? aka. should the flow fail on any exception? */
  brittle: Scalars['Boolean'];
  conditions: Array<Condition>;
  createdAt: Scalars['DateTime'];
  createdBy?: Maybe<User>;
  createdWhile?: Maybe<Scalars['String']>;
  creator?: Maybe<User>;
  description?: Maybe<Scalars['String']>;
  edges?: Maybe<Scalars['GenericScalar']>;
  graph: FlowGraph;
  hash: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  nodes?: Maybe<Scalars['GenericScalar']>;
  pinned?: Maybe<Scalars['Boolean']>;
  /** The users that have pinned the position */
  pinnedBy: Array<User>;
  position?: Maybe<Array<Maybe<Scalars['Int']>>>;
  restrict?: Maybe<Scalars['GenericScalar']>;
  runs: Array<Run>;
  screenshot?: Maybe<Scalars['String']>;
  version: Scalars['String'];
  workspace?: Maybe<Workspace>;
  zoom?: Maybe<Scalars['Float']>;
};

export type FlowEdge = {
  id: Scalars['String'];
  source: Scalars['String'];
  sourceHandle: Scalars['String'];
  target: Scalars['String'];
  targetHandle: Scalars['String'];
  typename: Scalars['String'];
};

export type FlowEdgeCommons = {
  stream: Array<Maybe<StreamItem>>;
};

export type FlowGraph = {
  __typename?: 'FlowGraph';
  args: Array<Maybe<Port>>;
  edges: Array<Maybe<FlowEdge>>;
  globals: Array<Maybe<Global>>;
  nodes: Array<Maybe<FlowNode>>;
  position?: Maybe<Array<Maybe<Scalars['Int']>>>;
  returns: Array<Maybe<Port>>;
  zoom?: Maybe<Scalars['Float']>;
};

export type FlowNode = {
  id: Scalars['String'];
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

export type FlowNodeCommons = {
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
};

export type Global = {
  __typename?: 'Global';
  port: Port;
  toKeys: Array<Maybe<Scalars['String']>>;
};

export type GlobalInput = {
  port: PortInput;
  toKeys: Array<InputMaybe<Scalars['String']>>;
};

export type GraphInput = {
  args: Array<InputMaybe<PortInput>>;
  edges: Array<InputMaybe<EdgeInput>>;
  globals: Array<InputMaybe<GlobalInput>>;
  nodes: Array<InputMaybe<NodeInput>>;
  returns: Array<InputMaybe<PortInput>>;
  zoom?: InputMaybe<Scalars['Float']>;
};

export type GraphNode = FlowNode & FlowNodeCommons & {
  __typename?: 'GraphNode';
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  hash: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

export type Group = {
  __typename?: 'Group';
  id: Scalars['ID'];
  name: Scalars['String'];
  permissions: Array<Permission>;
  /** The groups this user belongs to. A user will get all permissions granted to each of their groups. */
  userSet: Array<User>;
};

export type GroupAssignment = {
  __typename?: 'GroupAssignment';
  /** A query that returns an image path */
  group: Group;
  permissions: Array<Maybe<Scalars['String']>>;
};

export type GroupAssignmentInput = {
  group: Scalars['ID'];
  permissions: Array<InputMaybe<Scalars['String']>>;
};

export type KwargNode = FlowNode & FlowNodeCommons & {
  __typename?: 'KwargNode';
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

export type LabeledEdge = FlowEdge & FlowEdgeCommons & {
  __typename?: 'LabeledEdge';
  id: Scalars['String'];
  source: Scalars['String'];
  sourceHandle: Scalars['String'];
  stream: Array<Maybe<StreamItem>>;
  target: Scalars['String'];
  targetHandle: Scalars['String'];
  typename: Scalars['String'];
};

/** A leaf in the comment tree. Representations some sort of text */
export type Leaf = Descendent & {
  __typename?: 'Leaf';
  /** Is this a bold leaf? */
  bold?: Maybe<Scalars['Boolean']>;
  /** Is this a code leaf? */
  code?: Maybe<Scalars['Boolean']>;
  /** Is this a italic leaf? */
  italic?: Maybe<Scalars['Boolean']>;
  /** The text of the leaf */
  text?: Maybe<Scalars['String']>;
  typename?: Maybe<Scalars['String']>;
};

export type LocalNode = FlowNode & FlowNodeCommons & RetriableNode & {
  __typename?: 'LocalNode';
  allowLocal: Scalars['Boolean'];
  assignTimeout: Scalars['Float'];
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  hash: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  interface: Scalars['String'];
  kind: Scalars['String'];
  mapStrategy: MapStrategy;
  maxRetries: Scalars['Int'];
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  retryDelay: Scalars['Int'];
  retrySleepMs: Scalars['Int'];
  typename: Scalars['String'];
  yieldTimeout: Scalars['Float'];
};

/** Maping Strategy for the Map Operator */
export enum MapStrategy {
  AsCompleted = 'AS_COMPLETED',
  Map = 'MAP',
  Ordered = 'ORDERED'
}

/** A mention in the comment tree. This  is a reference to another user on the platform */
export type MentionDescendent = CommentNode & Descendent & {
  __typename?: 'MentionDescendent';
  children?: Maybe<Array<Maybe<Descendent>>>;
  typename?: Maybe<Scalars['String']>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
  /** The user that is mentioned */
  user: User;
};

export type MentionEvent = {
  __typename?: 'MentionEvent';
  create?: Maybe<Comment>;
  deleted?: Maybe<Scalars['ID']>;
  update?: Maybe<Comment>;
};

/** The root Mutation */
export type Mutation = {
  __typename?: 'Mutation';
  alog?: Maybe<RunLog>;
  /** Creates a Sample */
  changePermissions?: Maybe<ChangePermissionsResult>;
  /**
   * Create an Comment
   *
   *     This mutation creates a comment. It takes a commentable_id and a commentable_type.
   *     If this is the first comment on the commentable, it will create a new comment thread.
   *     If there is already a comment thread, it will add the comment to the thread (by setting
   *     it's parent to the last parent comment in the thread).
   *
   *     CreateComment takes a list of Descendents, which are the comment tree. The Descendents
   *     are a recursive structure, where each Descendent can have a list of Descendents as children.
   *     The Descendents are either a Leaf, which is a text node, or a MentionDescendent, which is a
   *     reference to another user on the platform.
   *
   *     Please convert your comment tree to a list of Descendents before sending it to the server.
   *     TODO: Add a converter from a comment tree to a list of Descendents.
   *
   *
   *     (only signed in users)
   */
  createComment?: Maybe<Comment>;
  createCondition?: Maybe<Condition>;
  createConditionSnapshot?: Maybe<ConditionSnapshot>;
  deleteCondition?: Maybe<DeleteConditionReturn>;
  deleteConditionSnapshot?: Maybe<DeleteConditionSnapshotReturn>;
  deleteFlow?: Maybe<DeleteFlowReturn>;
  deleteRun?: Maybe<DeleteRunReturn>;
  deleteSnapshot?: Maybe<DeleteSnapshotReturn>;
  deleteWorkspace?: Maybe<DeleteWorkspaceReturn>;
  drawvanilla?: Maybe<Workspace>;
  importflow?: Maybe<Workspace>;
  /**
   * Pin Condition
   *
   *     This mutation pins an Runs and returns the pinned Run.
   */
  pinCondition?: Maybe<Condition>;
  /**
   * Pin Run
   *
   *     This mutation pins an Runs and returns the pinned Run.
   */
  pinFlow?: Maybe<Flow>;
  /**
   * Pin Run
   *
   *     This mutation pins an Runs and returns the pinned Run.
   */
  pinRun?: Maybe<Run>;
  /**
   * Pin Run
   *
   *     This mutation pins an Runs and returns the pinned Run.
   */
  pinWorkspace?: Maybe<Workspace>;
  /**
   * Reply to an Comment
   *
   *     This mutation creates a comment. It takes a commentable_id and a commentable_type.
   *     If this is the first comment on the commentable, it will create a new comment thread.
   *     If there is already a comment thread, it will add the comment to the thread (by setting
   *     it's parent to the last parent comment in the thread).
   *
   *     CreateComment takes a list of Descendents, which are the comment tree. The Descendents
   *     are a recursive structure, where each Descendent can have a list of Descendents as children.
   *     The Descendents are either a Leaf, which is a text node, or a MentionDescendent, which is a
   *     reference to another user on the platform.
   *
   *     Please convert your comment tree to a list of Descendents before sending it to the server.
   *     TODO: Add a converter from a comment tree to a list of Descendents.
   *
   *
   *     (only signed in users)
   */
  replyTo?: Maybe<Comment>;
  /**
   * Create an Comment
   *
   *     This mutation resolves a comment. By resolving a comment, it will be marked as resolved,
   *     and the user that resolved it will be set as the resolver.
   *
   *     (only signed in users)
   */
  resolveComment?: Maybe<Comment>;
  snapshot?: Maybe<Snapshot>;
  start?: Maybe<Run>;
  trace?: Maybe<ConditionEvent>;
  track?: Maybe<RunEvent>;
  updateworkspace?: Maybe<Workspace>;
};


/** The root Mutation */
export type MutationAlogArgs = {
  message: Scalars['String'];
  run: Scalars['ID'];
};


/** The root Mutation */
export type MutationChangePermissionsArgs = {
  groupAssignments?: InputMaybe<Array<InputMaybe<GroupAssignmentInput>>>;
  object: Scalars['ID'];
  type: SharableModels;
  userAssignments?: InputMaybe<Array<InputMaybe<UserAssignmentInput>>>;
};


/** The root Mutation */
export type MutationCreateCommentArgs = {
  descendents: Array<InputMaybe<DescendendInput>>;
  object: Scalars['ID'];
  parent?: InputMaybe<Scalars['ID']>;
  type: CommentableModels;
};


/** The root Mutation */
export type MutationCreateConditionArgs = {
  flow: Scalars['ID'];
  provision: Scalars['ID'];
  snapshotInterval?: InputMaybe<Scalars['Int']>;
};


/** The root Mutation */
export type MutationCreateConditionSnapshotArgs = {
  condition: Scalars['ID'];
  events: Array<InputMaybe<Scalars['ID']>>;
};


/** The root Mutation */
export type MutationDeleteConditionArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteConditionSnapshotArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteFlowArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteRunArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteSnapshotArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDeleteWorkspaceArgs = {
  id: Scalars['ID'];
};


/** The root Mutation */
export type MutationDrawvanillaArgs = {
  brittle?: InputMaybe<Scalars['Boolean']>;
  name?: InputMaybe<Scalars['String']>;
  restrict?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
};


/** The root Mutation */
export type MutationImportflowArgs = {
  graph?: InputMaybe<GraphInput>;
  name?: InputMaybe<Scalars['String']>;
};


/** The root Mutation */
export type MutationPinConditionArgs = {
  id: Scalars['ID'];
  pin: Scalars['Boolean'];
};


/** The root Mutation */
export type MutationPinFlowArgs = {
  id: Scalars['ID'];
  pin: Scalars['Boolean'];
};


/** The root Mutation */
export type MutationPinRunArgs = {
  id: Scalars['ID'];
  pin: Scalars['Boolean'];
};


/** The root Mutation */
export type MutationPinWorkspaceArgs = {
  id: Scalars['ID'];
  pin: Scalars['Boolean'];
};


/** The root Mutation */
export type MutationReplyToArgs = {
  descendents: Array<InputMaybe<DescendendInput>>;
  parent: Scalars['ID'];
};


/** The root Mutation */
export type MutationResolveCommentArgs = {
  id: Scalars['ID'];
  imitate?: InputMaybe<Scalars['ID']>;
};


/** The root Mutation */
export type MutationSnapshotArgs = {
  events: Array<InputMaybe<Scalars['ID']>>;
  run: Scalars['ID'];
  t: Scalars['Int'];
};


/** The root Mutation */
export type MutationStartArgs = {
  assignation: Scalars['ID'];
  flow: Scalars['ID'];
  snapshotInterval?: InputMaybe<Scalars['Int']>;
};


/** The root Mutation */
export type MutationTraceArgs = {
  condition: Scalars['ID'];
  source: Scalars['String'];
  state: ContractStatus;
  value?: InputMaybe<Scalars['String']>;
};


/** The root Mutation */
export type MutationTrackArgs = {
  causedBy: Array<InputMaybe<Scalars['Int']>>;
  handle: Scalars['String'];
  run: Scalars['ID'];
  source: Scalars['String'];
  t: Scalars['Int'];
  type: EventTypeInput;
  value?: InputMaybe<Scalars['EventValue']>;
};


/** The root Mutation */
export type MutationUpdateworkspaceArgs = {
  brittle?: InputMaybe<Scalars['Boolean']>;
  graph?: InputMaybe<GraphInput>;
  id: Scalars['ID'];
  screenshot?: InputMaybe<Scalars['ImageFile']>;
};

export type NodeInput = {
  allowLocal?: InputMaybe<Scalars['Boolean']>;
  assignTimeout?: InputMaybe<Scalars['Float']>;
  binds?: InputMaybe<BindsInput>;
  constream: Array<InputMaybe<Array<InputMaybe<PortInput>>>>;
  defaults?: InputMaybe<Scalars['GenericScalar']>;
  description?: InputMaybe<Scalars['String']>;
  extra?: InputMaybe<Scalars['GenericScalar']>;
  hash?: InputMaybe<Scalars['String']>;
  id: Scalars['String'];
  implementation?: InputMaybe<ReactiveImplementationModelInput>;
  instream: Array<InputMaybe<Array<InputMaybe<PortInput>>>>;
  interface?: InputMaybe<Scalars['String']>;
  kind?: InputMaybe<Scalars['String']>;
  mapStrategy?: InputMaybe<MapStrategy>;
  maxRetries?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  outstream: Array<InputMaybe<Array<InputMaybe<PortInput>>>>;
  parentNode?: InputMaybe<Scalars['ID']>;
  position: PositionInput;
  reserveTimeout?: InputMaybe<Scalars['Float']>;
  retryDelay?: InputMaybe<Scalars['Int']>;
  typename: Scalars['String'];
  yieldTimeout?: InputMaybe<Scalars['Float']>;
};

/** A paragraph in the comment tree. This paragraph contains other nodes (list nodes) */
export type ParagraphDescendent = CommentNode & Descendent & {
  __typename?: 'ParagraphDescendent';
  children?: Maybe<Array<Maybe<Descendent>>>;
  /** The size of the paragraph */
  size?: Maybe<Scalars['String']>;
  typename?: Maybe<Scalars['String']>;
  untypedChildren?: Maybe<Scalars['GenericScalar']>;
};

/**
 * A Permission object
 *
 * This object represents a permission in the system. Permissions are
 * used to control access to different parts of the system. Permissions
 * are assigned to groups and users. A user has access to a part of the
 * system if the user is a member of a group that has the permission
 * assigned to it.
 */
export type Permission = {
  __typename?: 'Permission';
  codename: Scalars['String'];
  groupSet: Array<Group>;
  id: Scalars['ID'];
  name: Scalars['String'];
  /** Unique ID for this permission */
  unique: Scalars['String'];
  /** Specific permissions for this user. */
  userSet: Array<User>;
};

export type PermissionsOfReturn = {
  __typename?: 'PermissionsOfReturn';
  available?: Maybe<Array<Maybe<Permission>>>;
  groupAssignments?: Maybe<Array<Maybe<GroupAssignment>>>;
  userAssignments?: Maybe<Array<Maybe<UserAssignment>>>;
};

export type Port = {
  __typename?: 'Port';
  assignWidget?: Maybe<Widget>;
  child?: Maybe<PortChild>;
  default?: Maybe<Scalars['Any']>;
  description?: Maybe<Scalars['String']>;
  identifier?: Maybe<Scalars['String']>;
  key: Scalars['String'];
  kind: StreamKind;
  label?: Maybe<Scalars['String']>;
  /** The key of the arg */
  nullable: Scalars['Boolean'];
  returnWidget?: Maybe<ReturnWidget>;
  scope: Scope;
  variants?: Maybe<Array<Maybe<PortChild>>>;
};

export type PortChild = {
  __typename?: 'PortChild';
  /** Description of the Widget */
  assignWidget?: Maybe<Widget>;
  child?: Maybe<PortChild>;
  identifier?: Maybe<Scalars['String']>;
  kind: StreamKind;
  nullable: Scalars['Boolean'];
  /** A return widget */
  returnWidget?: Maybe<ReturnWidget>;
  scope: Scope;
  variants?: Maybe<Array<Maybe<PortChild>>>;
};

export type PortInput = {
  /** The child of this argument */
  assignWidget?: InputMaybe<WidgetInput>;
  /** The child of this argument */
  child?: InputMaybe<ChildPortInput>;
  /** The key of the arg */
  default?: InputMaybe<Scalars['Any']>;
  /** The description of this argument */
  description?: InputMaybe<Scalars['String']>;
  /** The identifier */
  identifier?: InputMaybe<Scalars['String']>;
  /** The key of the arg */
  key: Scalars['String'];
  /** The type of this argument */
  kind: StreamKind;
  /** The name of this argument */
  label?: InputMaybe<Scalars['String']>;
  /** The name of this argument */
  name?: InputMaybe<Scalars['String']>;
  /** Is this argument nullable */
  nullable: Scalars['Boolean'];
  /** The child of this argument */
  returnWidget?: InputMaybe<ReturnWidgetInput>;
  /** The scope of this argument */
  scope: Scope;
  variants?: InputMaybe<Array<InputMaybe<ChildPortInput>>>;
};

export type Position = {
  __typename?: 'Position';
  x: Scalars['Int'];
  y: Scalars['Int'];
};

export type PositionInput = {
  x: Scalars['Float'];
  y: Scalars['Float'];
};

/** The root Query */
export type Query = {
  __typename?: 'Query';
  comment?: Maybe<Comment>;
  /**
   * Comments for a specific object
   *
   *     This query returns all comments for a specific object. The object is
   *     specified by the `model` and `id` arguments. The `model` argument is
   *     a string that is the name of the model. The `id` argument is the id of
   *     the object.
   *
   *     You can only query for comments for objects that you have access to.
   *
   *
   */
  commentsfor?: Maybe<Array<Maybe<Comment>>>;
  condition?: Maybe<Condition>;
  conditionEventsBetween?: Maybe<Array<Maybe<ConditionEvent>>>;
  conditionSnapshot?: Maybe<ConditionSnapshot>;
  conditionSnapshots?: Maybe<Array<Maybe<ConditionSnapshot>>>;
  conditions?: Maybe<Array<Maybe<Condition>>>;
  eventsBetween?: Maybe<Array<Maybe<RunEvent>>>;
  flow?: Maybe<Flow>;
  flows?: Maybe<Array<Maybe<Flow>>>;
  hello?: Maybe<Scalars['String']>;
  me?: Maybe<User>;
  myconditions?: Maybe<Array<Maybe<Condition>>>;
  myflows?: Maybe<Array<Maybe<Flow>>>;
  mymentions?: Maybe<Array<Maybe<Comment>>>;
  myruns?: Maybe<Array<Maybe<Run>>>;
  myworkspaces?: Maybe<Array<Maybe<Workspace>>>;
  permissionsFor?: Maybe<Array<Maybe<Permission>>>;
  permissionsOf?: Maybe<PermissionsOfReturn>;
  reactivetemplate?: Maybe<ReactiveTemplate>;
  reactivetemplates?: Maybe<Array<Maybe<ReactiveTemplate>>>;
  run?: Maybe<Run>;
  runLogs?: Maybe<Array<Maybe<RunLog>>>;
  runs?: Maybe<Array<Maybe<Run>>>;
  snapshot?: Maybe<Snapshot>;
  snapshots?: Maybe<Array<Maybe<Snapshot>>>;
  user?: Maybe<User>;
  /** Get a list of users */
  users?: Maybe<Array<Maybe<User>>>;
  void?: Maybe<Scalars['String']>;
  workspace?: Maybe<Workspace>;
  workspaces?: Maybe<Array<Maybe<Workspace>>>;
};


/** The root Query */
export type QueryCommentArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryCommentsforArgs = {
  deep?: InputMaybe<Scalars['Boolean']>;
  id?: InputMaybe<Scalars['ID']>;
  model: CommentableModels;
};


/** The root Query */
export type QueryConditionArgs = {
  id?: InputMaybe<Scalars['ID']>;
  provision?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryConditionEventsBetweenArgs = {
  condition: Scalars['ID'];
  max?: InputMaybe<Scalars['DateTime']>;
  min?: InputMaybe<Scalars['DateTime']>;
};


/** The root Query */
export type QueryConditionSnapshotArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryConditionSnapshotsArgs = {
  condition?: InputMaybe<Scalars['ID']>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
};


/** The root Query */
export type QueryConditionsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
};


/** The root Query */
export type QueryEventsBetweenArgs = {
  max?: InputMaybe<Scalars['Int']>;
  min?: InputMaybe<Scalars['Int']>;
  run: Scalars['ID'];
};


/** The root Query */
export type QueryFlowArgs = {
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryFlowsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
  workspace?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryMyconditionsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
};


/** The root Query */
export type QueryMyflowsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
  workspace?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryMyrunsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
};


/** The root Query */
export type QueryMyworkspacesArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
  search?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryPermissionsForArgs = {
  model: SharableModels;
  name?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryPermissionsOfArgs = {
  id: Scalars['ID'];
  model: SharableModels;
};


/** The root Query */
export type QueryReactivetemplateArgs = {
  id?: InputMaybe<Scalars['ID']>;
  implementation?: InputMaybe<ReactiveImplementationModelInput>;
};


/** The root Query */
export type QueryReactivetemplatesArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  name?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryRunArgs = {
  assignation?: InputMaybe<Scalars['ID']>;
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryRunLogsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  run?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryRunsArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
};


/** The root Query */
export type QuerySnapshotArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QuerySnapshotsArgs = {
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  run?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryUserArgs = {
  email?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
};


/** The root Query */
export type QueryUsersArgs = {
  email?: InputMaybe<Scalars['String']>;
  search?: InputMaybe<Scalars['String']>;
  username?: InputMaybe<Scalars['String']>;
};


/** The root Query */
export type QueryWorkspaceArgs = {
  id: Scalars['ID'];
};


/** The root Query */
export type QueryWorkspacesArgs = {
  createdAfter?: InputMaybe<Scalars['DateTime']>;
  createdAt?: InputMaybe<Scalars['DateTime']>;
  createdBefore?: InputMaybe<Scalars['DateTime']>;
  createdDay?: InputMaybe<Scalars['DateTime']>;
  createdWhile?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  ids?: InputMaybe<Array<InputMaybe<Scalars['ID']>>>;
  limit?: InputMaybe<Scalars['Int']>;
  name?: InputMaybe<Scalars['String']>;
  offset?: InputMaybe<Scalars['Int']>;
  order?: InputMaybe<Scalars['String']>;
  pinned?: InputMaybe<Scalars['Boolean']>;
  search?: InputMaybe<Scalars['String']>;
};

/** An enumeration. */
export enum ReactiveImplementationModelInput {
  /** ADD (Add a number to the data) */
  Add = 'ADD',
  /** ALL (establish if all values are Trueish) */
  All = 'ALL',
  /** AND (AND condition) */
  And = 'AND',
  /** BUFFER_COMPLETE (Buffer values until complete is retrieved) */
  BufferComplete = 'BUFFER_COMPLETE',
  /** BUFFER_UNTIL (Buffer values until signal is send) */
  BufferUntil = 'BUFFER_UNTIL',
  /** CHUNK (Chunk the data) */
  Chunk = 'CHUNK',
  /** COMBINELATEST (Combine values with latest value from each stream) */
  Combinelatest = 'COMBINELATEST',
  /** DELAY (Delay the data) */
  Delay = 'DELAY',
  /** DELAY_UNTIL (Delay the data until signal is send) */
  DelayUntil = 'DELAY_UNTIL',
  /** DIVIDE (Divide the data with a number) */
  Divide = 'DIVIDE',
  /** ENSURE (Ensure the data (discards None in the stream)) */
  Ensure = 'ENSURE',
  /** FILTER (Filter the data of a union) */
  Filter = 'FILTER',
  /** FOREACH (Foreach element in list) */
  Foreach = 'FOREACH',
  /** GATE (Gate the data, first value is gated, second is gate) */
  Gate = 'GATE',
  /** IF (If condition is met) */
  If = 'IF',
  /** MODULO (Modulo the data with a number) */
  Modulo = 'MODULO',
  /** MULTIPLY (Multiply the data with a number) */
  Multiply = 'MULTIPLY',
  /** OMIT (Omit the data) */
  Omit = 'OMIT',
  /** POWER (Power the data with a number) */
  Power = 'POWER',
  /** PREFIX (Prefix the data with a string) */
  Prefix = 'PREFIX',
  /** SPLIT (Split the data) */
  Split = 'SPLIT',
  /** SUBTRACT (Subtract a number from the data) */
  Subtract = 'SUBTRACT',
  /** SUFFIX (Suffix the data with a string) */
  Suffix = 'SUFFIX',
  /** TO_LIST (Convert to list) */
  ToList = 'TO_LIST',
  /** WITHLATEST (Combine a leading value with the latest value) */
  Withlatest = 'WITHLATEST',
  /** ZIP (Zip the data) */
  Zip = 'ZIP'
}

export type ReactiveNode = FlowNode & FlowNodeCommons & {
  __typename?: 'ReactiveNode';
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  id: Scalars['String'];
  implementation: ReactiveImplementationModelInput;
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

export type ReactiveTemplate = {
  __typename?: 'ReactiveTemplate';
  constants?: Maybe<Array<Maybe<Port>>>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  implementation: ReactiveImplementationModelInput;
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
};

export type RetriableNode = {
  maxRetries: Scalars['Int'];
  retryDelay: Scalars['Int'];
};

export type ReturnNode = FlowNode & FlowNodeCommons & {
  __typename?: 'ReturnNode';
  constants?: Maybe<Scalars['GenericScalar']>;
  constream: Array<Maybe<Array<Maybe<Port>>>>;
  defaults?: Maybe<Scalars['GenericScalar']>;
  description: Scalars['String'];
  id: Scalars['String'];
  instream: Array<Maybe<Array<Maybe<Port>>>>;
  name: Scalars['String'];
  outstream: Array<Maybe<Array<Maybe<Port>>>>;
  parentNode?: Maybe<Scalars['ID']>;
  position: Position;
  typename: Scalars['String'];
};

export type ReturnWidget = {
  __typename?: 'ReturnWidget';
  /** The dependencies of this port */
  choices?: Maybe<Array<Maybe<Choice>>>;
  /** The dependencies of this port */
  dependencies?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** type */
  kind: Scalars['String'];
  /** Do we have a possible */
  query?: Maybe<Scalars['String']>;
};

export type ReturnWidgetInput = {
  /** The dependencies of this port */
  choices?: InputMaybe<Array<InputMaybe<ChoiceInput>>>;
  /** A hook for the app to call */
  hook?: InputMaybe<Scalars['String']>;
  /** type */
  kind: Scalars['String'];
  /** Do we have a possible */
  query?: InputMaybe<Scalars['String']>;
  /** A ward for the app to call */
  ward?: InputMaybe<Scalars['String']>;
};

export type Run = {
  __typename?: 'Run';
  assignation?: Maybe<Scalars['String']>;
  createdAt: Scalars['DateTime'];
  createdBy?: Maybe<User>;
  createdWhile?: Maybe<Scalars['String']>;
  events: Array<RunEvent>;
  flow?: Maybe<Flow>;
  id: Scalars['ID'];
  latestSnapshot?: Maybe<Snapshot>;
  logs: Array<RunLog>;
  pinned?: Maybe<Scalars['Boolean']>;
  /** The users that have pinned the position */
  pinnedBy: Array<User>;
  snapshotInterval?: Maybe<Scalars['Int']>;
  snapshots: Array<Snapshot>;
  status?: Maybe<Scalars['String']>;
};

export type RunEvent = {
  __typename?: 'RunEvent';
  causedBy?: Maybe<Array<Maybe<Scalars['Int']>>>;
  createdAt: Scalars['DateTime'];
  handle: Scalars['String'];
  id: Scalars['ID'];
  run?: Maybe<Run>;
  snapshot: Array<Snapshot>;
  source: Scalars['String'];
  t: Scalars['Int'];
  type: RunEventType;
  value?: Maybe<Scalars['EventValue']>;
};

/** An enumeration. */
export enum RunEventType {
  /** COMPLETE (Value is none) */
  Complete = 'COMPLETE',
  /** Error (Value represent Exception) */
  Error = 'ERROR',
  /** NEXT (Value represent Item) */
  Next = 'NEXT',
  /** UNKNOWN (Should never be used) */
  Unknown = 'UNKNOWN'
}

export type RunLog = {
  __typename?: 'RunLog';
  id: Scalars['ID'];
  log?: Maybe<Scalars['String']>;
  node: Scalars['String'];
  run?: Maybe<Run>;
};

/** Scope of the Port */
export enum Scope {
  Global = 'GLOBAL',
  Local = 'LOCAL'
}

/** Sharable Models are models that can be shared amongst users and groups. They representent the models of the DB */
export enum SharableModels {
  FlowCondition = 'FLOW_CONDITION',
  FlowConditionevent = 'FLOW_CONDITIONEVENT',
  FlowConditionsnapshot = 'FLOW_CONDITIONSNAPSHOT',
  FlowFlow = 'FLOW_FLOW',
  FlowReactivetemplate = 'FLOW_REACTIVETEMPLATE',
  FlowRun = 'FLOW_RUN',
  FlowRunevent = 'FLOW_RUNEVENT',
  FlowRunlog = 'FLOW_RUNLOG',
  FlowSnapshot = 'FLOW_SNAPSHOT',
  FlowWorkspace = 'FLOW_WORKSPACE'
}

export type Snapshot = {
  __typename?: 'Snapshot';
  createdAt: Scalars['DateTime'];
  events: Array<RunEvent>;
  id: Scalars['ID'];
  run?: Maybe<Run>;
  status?: Maybe<Scalars['String']>;
  t: Scalars['Int'];
};

export type StreamItem = {
  __typename?: 'StreamItem';
  child?: Maybe<StreamItemChild>;
  identifier?: Maybe<Scalars['String']>;
  key: Scalars['String'];
  kind: StreamKind;
  nullable: Scalars['Boolean'];
  scope: Scope;
  variants?: Maybe<Array<Maybe<StreamItemChild>>>;
};

export type StreamItemChild = {
  __typename?: 'StreamItemChild';
  child?: Maybe<StreamItemChild>;
  identifier?: Maybe<Scalars['String']>;
  kind: StreamKind;
  nullable: Scalars['Boolean'];
  scope: Scope;
  variants?: Maybe<Array<Maybe<StreamItemChild>>>;
};

export type StreamItemChildInput = {
  child?: InputMaybe<StreamItemChildInput>;
  identifier?: InputMaybe<Scalars['String']>;
  kind: StreamKind;
  nullable: Scalars['Boolean'];
  /** The scope of this argument */
  scope: Scope;
  variants?: InputMaybe<Array<InputMaybe<StreamItemChildInput>>>;
};

export type StreamItemInput = {
  child?: InputMaybe<StreamItemChildInput>;
  identifier?: InputMaybe<Scalars['String']>;
  key: Scalars['String'];
  kind: StreamKind;
  nullable: Scalars['Boolean'];
  /** The scope of this argument */
  scope: Scope;
  variants?: InputMaybe<Array<InputMaybe<StreamItemChildInput>>>;
};

export enum StreamKind {
  Bool = 'BOOL',
  Dict = 'DICT',
  Enum = 'ENUM',
  Float = 'FLOAT',
  Int = 'INT',
  List = 'LIST',
  String = 'STRING',
  Structure = 'STRUCTURE',
  Union = 'UNION',
  Unset = 'UNSET'
}

/** The root Subscriptions */
export type Subscription = {
  __typename?: 'Subscription';
  conditionevents?: Maybe<ConditionEvents>;
  events?: Maybe<Event>;
  /**
   * My Mentions
   *
   *     Returns an event of a new mention for the user if the user
   *     was mentioned in a comment.
   *
   */
  mymentions?: Maybe<MentionEvent>;
};


/** The root Subscriptions */
export type SubscriptionConditioneventsArgs = {
  id: Scalars['ID'];
};


/** The root Subscriptions */
export type SubscriptionEventsArgs = {
  id: Scalars['ID'];
};

/** A reflection on the real User */
export type User = {
  __typename?: 'User';
  /** The associated color for this user */
  color?: Maybe<Scalars['String']>;
  comments: Array<Comment>;
  conditionCreatedBy: Array<Condition>;
  dateJoined: Scalars['DateTime'];
  email: Scalars['String'];
  firstName: Scalars['String'];
  flowCreatedBy: Array<Flow>;
  flowSet: Array<Flow>;
  /** The groups this user belongs to. A user will get all permissions granted to each of their groups. */
  groups: Array<Group>;
  id: Scalars['ID'];
  /** Designates whether this user should be treated as active. Unselect this instead of deleting accounts. */
  isActive: Scalars['Boolean'];
  /** Designates whether the user can log into this admin site. */
  isStaff: Scalars['Boolean'];
  /** Designates that this user has all permissions without explicitly assigning them. */
  isSuperuser: Scalars['Boolean'];
  iss?: Maybe<Scalars['String']>;
  lastLogin?: Maybe<Scalars['DateTime']>;
  lastName: Scalars['String'];
  mentionedIn: Array<Comment>;
  /** The name of the user */
  name?: Maybe<Scalars['String']>;
  password: Scalars['String'];
  /** The users that have pinned the position */
  pinnedConditions: Array<Condition>;
  /** The users that have pinned the position */
  pinnedFlows: Array<Flow>;
  /** The users that have pinned the position */
  pinnedRuns: Array<Run>;
  /** The users that have pinned the position */
  pinnedWorkspaces: Array<Workspace>;
  resolvedComments: Array<Comment>;
  runCreatedBy: Array<Run>;
  /** The sub of the user */
  sub?: Maybe<Scalars['String']>;
  /** Specific permissions for this user. */
  userPermissions: Array<Permission>;
  /** Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
  username: Scalars['String'];
  workspaceCreatedBy: Array<Workspace>;
  workspaceSet: Array<Workspace>;
};

export type UserAssignment = {
  __typename?: 'UserAssignment';
  permissions: Array<Maybe<Scalars['String']>>;
  /** A query that returns an image path */
  user: User;
};

export type UserAssignmentInput = {
  permissions: Array<InputMaybe<Scalars['String']>>;
  /** The user id */
  user: Scalars['String'];
};

export type Widget = {
  __typename?: 'Widget';
  /** Is this a paragraph */
  asParagraph?: Maybe<Scalars['Boolean']>;
  /** The dependencies of this port */
  choices?: Maybe<Array<Maybe<Choice>>>;
  /** The dependencies of this port */
  dependencies?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** A hook for the app to call */
  hook?: Maybe<Scalars['String']>;
  /** type */
  kind: Scalars['String'];
  /** Max value for int widget */
  max?: Maybe<Scalars['Float']>;
  /** Max value for int widget */
  min?: Maybe<Scalars['Float']>;
  /** Placeholder for any widget */
  placeholder?: Maybe<Scalars['String']>;
  /** Do we have a possible */
  query?: Maybe<Scalars['String']>;
  /** Max value for int widget */
  step?: Maybe<Scalars['Float']>;
  /** A hook for the app to call */
  ward?: Maybe<Scalars['String']>;
};

export type WidgetInput = {
  /** Is this a paragraph */
  asParagraph?: InputMaybe<Scalars['Boolean']>;
  /** The dependencies of this port */
  choices?: InputMaybe<Array<InputMaybe<ChoiceInput>>>;
  /** The dependencies of this port */
  dependencies?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** A hook for the app to call */
  hook?: InputMaybe<Scalars['String']>;
  /** type */
  kind: Scalars['String'];
  /** Max value for int widget */
  max?: InputMaybe<Scalars['Float']>;
  /** Max value for int widget */
  min?: InputMaybe<Scalars['Float']>;
  /** Placeholder for any widget */
  placeholder?: InputMaybe<Scalars['String']>;
  /** Do we have a possible */
  query?: InputMaybe<Scalars['String']>;
  /** Max value for int widget */
  step?: InputMaybe<Scalars['Float']>;
  /** A ward for the app to call */
  ward?: InputMaybe<Scalars['String']>;
};

export type Workspace = {
  __typename?: 'Workspace';
  createdAt: Scalars['DateTime'];
  createdBy?: Maybe<User>;
  createdWhile?: Maybe<Scalars['String']>;
  creator?: Maybe<User>;
  flows: Array<Flow>;
  id: Scalars['ID'];
  /** The latest flow */
  latestFlow?: Maybe<Flow>;
  name?: Maybe<Scalars['String']>;
  pinned?: Maybe<Scalars['Boolean']>;
  /** The users that have pinned the position */
  pinnedBy: Array<User>;
  restrict: Array<Maybe<Scalars['String']>>;
};

export type LeafFragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type Node_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Node_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type NodeFragment = Node_MentionDescendent_Fragment | Node_ParagraphDescendent_Fragment;

export type LevelDownParagraphFragment = { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null };

export type LevelDownMentionFragment = { __typename?: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } };

type LevelDownDescendent_Leaf_Fragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type LevelDownDescendent_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent' };

type LevelDownDescendent_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', typename: 'ParagraphDescendent' };

export type LevelDownDescendentFragment = LevelDownDescendent_Leaf_Fragment | LevelDownDescendent_MentionDescendent_Fragment | LevelDownDescendent_ParagraphDescendent_Fragment;

export type MentionFragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type ParagraphFragment = { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Descendent_Leaf_Fragment = { __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' };

type Descendent_MentionDescendent_Fragment = { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

type Descendent_ParagraphDescendent_Fragment = { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null };

export type DescendentFragment = Descendent_Leaf_Fragment | Descendent_MentionDescendent_Fragment | Descendent_ParagraphDescendent_Fragment;

export type SubthreadCommentFragment = { __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null };

export type ListCommentFragment = { __typename?: 'Comment', resolved?: any | null, id: string, createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null };

export type MentionCommentFragment = { __typename?: 'Comment', id: string, createdAt: any, resolved?: any | null, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', id: string, sub?: string | null }>, resolvedBy?: { __typename?: 'User', sub?: string | null } | null };

export type DetailCommentFragment = { __typename?: 'Comment', id: string, resolved?: any | null, createdAt: any, objectId: number, contentType?: CommentableModels | null, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null, resolvedBy?: { __typename?: 'User', sub?: string | null } | null, children?: Array<{ __typename?: 'Comment', createdAt: any, user: { __typename?: 'User', sub?: string | null }, parent?: { __typename?: 'Comment', id: string } | null, descendents?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null }, children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | { __typename?: 'ParagraphDescendent', size?: string | null, typename: 'ParagraphDescendent', children?: Array<{ __typename?: 'Leaf', bold?: boolean | null, italic?: boolean | null, code?: boolean | null, text?: string | null, typename: 'Leaf' } | { __typename?: 'MentionDescendent', typename: 'MentionDescendent', user: { __typename?: 'User', sub?: string | null } } | { __typename?: 'ParagraphDescendent', size?: string | null, untypedChildren?: any | null, typename: 'ParagraphDescendent' } | null> | null } | null> | null } | null> | null, mentions: Array<{ __typename?: 'User', sub?: string | null }> };

export type ConditionSnapshotFragment = { __typename?: 'ConditionSnapshot', id: string, status?: string | null, condition?: { __typename?: 'Condition', id: string, provision?: string | null } | null, events: Array<{ __typename?: 'ConditionEvent', id: string, source?: string | null, createdAt: any, value: string, state: ContractStatus }> };

export type ListConditionSnapshotFragment = { __typename?: 'ConditionSnapshot', id: string, condition?: { __typename?: 'Condition', id: string, provision?: string | null } | null };

export type ConditionFragment = { __typename?: 'Condition', id: string, provision?: string | null, createdAt: any, snapshots: Array<{ __typename?: 'ConditionSnapshot', id: string, status?: string | null, createdAt: any }>, latestSnapshot?: { __typename?: 'ConditionSnapshot', createdAt: any, events: Array<{ __typename?: 'ConditionEvent', id: string, source?: string | null, createdAt: any, value: string, state: ContractStatus }> } | null, flow?: { __typename: 'Flow', id: string, restrict?: any | null, name: string, screenshot?: string | null, createdAt: any, graph: { __typename?: 'FlowGraph', nodes: Array<{ __typename: 'ArgNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'ArkitektFilterNode', id: string, typename: string, parentNode?: string | null, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'ArkitektNode', id: string, typename: string, parentNode?: string | null, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'GraphNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'KwargNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'LocalNode', id: string, typename: string, parentNode?: string | null, interface: string, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'ReactiveNode', id: string, typename: string, parentNode?: string | null, implementation: ReactiveImplementationModelInput, defaults?: any | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | { __typename: 'ReturnNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> } | null>, edges: Array<{ __typename: 'FancyEdge', id: string, source: string, sourceHandle: string, target: string, targetHandle: string, typename: string, stream: Array<{ __typename?: 'StreamItem', key: string, kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null> | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null> | null } | null> | null } | null> } | { __typename: 'LabeledEdge', id: string, source: string, sourceHandle: string, target: string, targetHandle: string, typename: string, stream: Array<{ __typename?: 'StreamItem', key: string, kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null> | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', kind: StreamKind, identifier?: string | null, scope: Scope, nullable: boolean, child?: { __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null, variants?: Array<{ __typename?: 'StreamItemChild', scope: Scope, kind: StreamKind, nullable: boolean, identifier?: string | null } | null> | null } | null> | null } | null> } | null>, globals: Array<{ __typename?: 'Global', toKeys: Array<string | null>, port: { __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } } | null>, args: Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null>, returns: Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> }, workspace?: { __typename?: 'Workspace', id: string } | null } | null };

export type ListConditionFragment = { __typename?: 'Condition', id: string, provision?: string | null, createdAt: any, flow?: { __typename?: 'Flow', id: string, name: string, workspace?: { __typename?: 'Workspace', name?: string | null } | null } | null };

export type ConditionEventFragment = { __typename?: 'ConditionEvent', id: string, source?: string | null, createdAt: any, value: string, state: ContractStatus };

type FlowNodeCommons_ArgNode_Fragment = { __typename?: 'ArgNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_ArkitektFilterNode_Fragment = { __typename?: 'ArkitektFilterNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_ArkitektNode_Fragment = { __typename?: 'ArkitektNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_GraphNode_Fragment = { __typename?: 'GraphNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_KwargNode_Fragment = { __typename?: 'KwargNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_LocalNode_Fragment = { __typename?: 'LocalNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_ReactiveNode_Fragment = { __typename?: 'ReactiveNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNodeCommons_ReturnNode_Fragment = { __typename?: 'ReturnNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type FlowNodeCommonsFragment = FlowNodeCommons_ArgNode_Fragment | FlowNodeCommons_ArkitektFilterNode_Fragment | FlowNodeCommons_ArkitektNode_Fragment | FlowNodeCommons_GraphNode_Fragment | FlowNodeCommons_KwargNode_Fragment | FlowNodeCommons_LocalNode_Fragment | FlowNodeCommons_ReactiveNode_Fragment | FlowNodeCommons_ReturnNode_Fragment;

type RetriableNode_ArkitektFilterNode_Fragment = { __typename?: 'ArkitektFilterNode', maxRetries: number, retryDelay: number };

type RetriableNode_ArkitektNode_Fragment = { __typename?: 'ArkitektNode', maxRetries: number, retryDelay: number };

type RetriableNode_LocalNode_Fragment = { __typename?: 'LocalNode', maxRetries: number, retryDelay: number };

export type RetriableNodeFragment = RetriableNode_ArkitektFilterNode_Fragment | RetriableNode_ArkitektNode_Fragment | RetriableNode_LocalNode_Fragment;

export type ArkitektNodeFragment = { __typename: 'ArkitektNode', hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type ArkitektFilterNodeFragment = { __typename: 'ArkitektFilterNode', hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type LocalNodeFragment = { __typename: 'LocalNode', interface: string, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type ReactiveNodeFragment = { __typename: 'ReactiveNode', implementation: ReactiveImplementationModelInput, defaults?: any | null, constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type WidgetFragment = { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null };

export type ReturnWidgetFragment = { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null };

export type PortChildNestedFragment = { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null };

export type PortChildFragment = { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null };

export type PortFragment = { __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null };

export type ArgNodeFragment = { __typename: 'ArgNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type KwargNodeFragment = { __typename: 'KwargNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type ReturnNodeFragment = { __typename: 'ReturnNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

export type GraphNodeFragment = { __typename: 'GraphNode', constants?: any | null, name: string, description: string, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_ArgNode_Fragment = { __typename: 'ArgNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_ArkitektFilterNode_Fragment = { __typename: 'ArkitektFilterNode', id: string, typename: string, parentNode?: string | null, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_ArkitektNode_Fragment = { __typename: 'ArkitektNode', id: string, typename: string, parentNode?: string | null, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, reserveTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, binds?: { __typename?: 'Binds', clients?: Array<string | null> | null, templates?: Array<string | null> | null } | null, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_GraphNode_Fragment = { __typename: 'GraphNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_KwargNode_Fragment = { __typename: 'KwargNode', id: string, typename: string, parentNode?: string | null, constants?: any | null, name: string, description: string, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null> };

type FlowNode_LocalNode_Fragment = { __typename: 'LocalNode', id: string, typename: string, parentNode?: string | null, interface: string, hash: string, kind: string, defaults?: any | null, mapStrategy: MapStrategy, allowLocal: boolean, assignTimeout: number, yieldTimeout: number, maxRetries: number, constants?: any | null, name: string, description: string, retryDelay: number, position: { __typename?: 'Position', x: number, y: number }, instream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, outstream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null> | null } | null> | null>, constream: Array<Array<{ __typename?: 'Port', key: string, label?: string | null, identifier?: string | null, scope: Scope, kind: StreamKind, description?: string | null, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', scope: Scope, identifier?: string | null, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, child?: { __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, scope: Scope, kind: StreamKind, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: boolean | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null, returnWidget?: { __typename?: 'ReturnWidget', kind: string, query?: string | null, choices?: Array<{ __typename?: 'Choice', value: any, label: string } | null> | null } | null } | null> | null } | null> | null } | null, variants?: Array<{ __typename?: 'PortChild', identifier?: string | null, kind: StreamKind, scope: Scope, nullable: boolean, assignWidget?: { __typename?: 'Widget', kind: string, query?: string | null, hook?: string | null, ward?: string | null, min?: number | null, step?: number | null, placeholder?: string | null, max?: number | null, asParagraph?: b