﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.Extensions.Logging;
using MongoDB.Driver;
using RawCMS.Library.DataModel;

namespace RawCMS.Library.Service
{
    public class MongoService
    {
        private readonly MongoSettings _settings;
        private readonly ILogger logger;
        private readonly MongoClient client;

        public MongoService(MongoSettings settings, ILogger logger)
        {
            this.logger = logger;
            _settings = settings;
            client = new MongoClient(_settings.ConnectionString);
            if (string.IsNullOrEmpty(_settings.DBName))
            {
                MongoUrl url = MongoUrl.Create(_settings.ConnectionString);

                _settings.DBName = url.DatabaseName;
            }
        }

        public MongoClient GetClient()
        {
            return client;
        }

        public IMongoDatabase GetDatabase()
        {
            return GetClient().GetDatabase(_settings.DBName);
        }

        public IMongoCollection<T> GetCollection<T>(string name)
        {
            return GetClient().GetDatabase(_settings.DBName).GetCollection<T>(name);
        }
    }
}