﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Jint;
using Newtonsoft.Json.Linq;
using RawCMS.Library.JavascriptClient;
using RawCMS.Library.Service;
using System;
using System.Collections.Generic;

namespace RawCMS.Library.Lambdas
{
    public abstract class JsDispatcher : DataProcessLambda
    {
        public override string Name => "JsDispatcher";

        public override string Description => "JsDispatcher";

        protected readonly EntityService entityService;

        private readonly CRUDService crudService;

        public JsDispatcher(EntityService entityService, CRUDService crudService)
        {
            {
                this.entityService = entityService;
                this.crudService = crudService;
            }
        }

        public override void Execute(string collection, ref JObject item, ref Dictionary<string, object> dataContext)
        {
            var eventName = Stage.ToString().Replace("Operation", string.Empty) + Operation.ToString();
            var settings = this.entityService.GetByName(collection);

            if (settings != null)
            {
                var eventScript = settings.Events?[eventName];

                if (eventScript != null &&
                    !string.IsNullOrEmpty(Convert.ToString(eventScript)))
                {
                    Dictionary<string, object> input = item.ToObject<Dictionary<string, object>>();
                    Engine engine = new Engine((x) => { x.AllowClr(typeof(JavascriptRestClient).Assembly); x.AllowClr(typeof(JavascriptRestClientRequest).Assembly); });
                    engine.SetValue("RAWCMSRestClient", Jint.Runtime.Interop.TypeReference.CreateTypeReference(engine, typeof(JavascriptRestClient)));
                    engine.SetValue("RAWCMSRestClientRequest", Jint.Runtime.Interop.TypeReference.CreateTypeReference(engine, typeof(JavascriptRestClientRequest)));
                    engine.SetValue("RAWCMSCrudService", crudService);

                    engine.SetValue("item", input);
                    engine.Execute(eventScript.ToString());
                    item = JObject.FromObject(input);
                }
            }
        }
    }
}