﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Newtonsoft.Json.Linq;
using RawCMS.Library.Core;
using RawCMS.Library.Schema;
using RawCMS.Library.Service;
using System.Collections.Generic;
using System.Linq;

namespace RawCMS.Library.Lambdas
{
    public class EntityValidation : SchemaValidationLambda
    {
        public override string Name => "Entity Validation";

        public override string Description => "Provide generic entity validation, based on configuration";

        private readonly AppEngine appEngine;
        private readonly CRUDService service;
        private readonly EntityService entityService;

        public EntityValidation(AppEngine appEngine, CRUDService service, EntityService entityService)
        {
            this.appEngine = appEngine;
            this.service = service;
            this.entityService = entityService;
        }

        public override List<Error> Validate(JObject input, string collection)
        {
            List<Error> errors = new List<Error>();
            var settings = entityService.GetByName(collection);
            if (settings != null)
            {
                //do validation!

                if (!settings.AllowNonMappedFields)
                {
                    foreach (JProperty field in input.Properties())
                    {
                        if (field.Name.StartsWith("_")) continue; //TODO: Add a list of default fields and make it editable by plugin

                        if (!settings.FieldSettings.Any(x => x.Name == field.Name))
                        {
                            errors.Add(new Error()
                            {
                                Code = "Forbidden Field",
                                Title = $"Field {field.Name} not in allowed field list",
                            });
                        }
                    }
                }

                foreach (Field field in settings.FieldSettings)
                {
                    if (field.Name.StartsWith("_")) continue; // TODO: Handle properly with metadata
                    errors.AddRange(ValidateField(field, input, collection));
                }
            }

            return errors;
        }

        private IEnumerable<Error> ValidateField(Field field, JObject input, string collection)
        {
            List<Error> errors = new List<Error>();

            if (field.Required && input[field.Name] == null)
            {
                errors.Add(new Error()
                {
                    Code = "REQUIRED",
                    Title = "Field " + field.Name + " is required"
                });
            }

            var typeValidator = this.entityService.GetTypeValidator(field.Type);
            foreach (var validator in typeValidator)
            {
                errors.AddRange(validator.Validate(input, field));
            }
            return errors;
        }
    }
}