﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Newtonsoft.Json.Linq;
using RawCMS.Library.Core.Enum;
using System.Collections.Generic;

namespace RawCMS.Library.Lambdas
{
    public abstract class DataProcessLambda : Lambda
    {
        public abstract PipelineStage Stage { get; }
        public abstract DataOperation Operation { get; }

        public abstract void Execute(string collection, ref JObject item, ref Dictionary<string, object> dataContext);
    }

    public abstract class PostSaveLambda : DataProcessLambda
    {
        public override PipelineStage Stage => PipelineStage.PostOperation;
        public override DataOperation Operation => DataOperation.Write;
    }

    public abstract class PreSaveLambda : DataProcessLambda
    {
        public override PipelineStage Stage => PipelineStage.PreOperation;
        public override DataOperation Operation => DataOperation.Write;
    }

    public abstract class PostDeleteLambda : DataProcessLambda
    {
        public override PipelineStage Stage => PipelineStage.PostOperation;
        public override DataOperation Operation => DataOperation.Delete;
    }

    public abstract class PreDeleteLambda : DataProcessLambda
    {
        public override PipelineStage Stage => PipelineStage.PreOperation;
        public override DataOperation Operation => DataOperation.Delete;
    }
}