﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using RestSharp;
using System;

namespace RawCMS.Library.JavascriptClient
{
    public class JavascriptRestClient
    {
        public ILogger logger { get; private set; }

        public JavascriptRestClient()
        {
        }

        public JavascriptRestClientMessage<JObject> Execute(JavascriptRestClientRequest javascriptRequest)
        {
            JavascriptRestClientMessage<JObject> response = new JavascriptRestClientMessage<JObject>(new JObject());
            IRestResponse restResponse = null;

            RestClient client = new RestClient(javascriptRequest.Url);
            Method reqMethod = Method.GET;
            if (!Enum.TryParse(javascriptRequest.Method, true, out reqMethod))
            {
                // log error method...
            }

            RestRequest request = new RestRequest()
            {
                //request headers type
                RequestFormat = DataFormat.Json,
                Method = reqMethod
            };

            // set the request header
            if (javascriptRequest.Header != null)
            {
                foreach (var el in javascriptRequest.Header)
                {
                    request.AddHeader(el.Key, el.Value);
                }
            }

            //add parameters to request
            request.Parameters.Clear();
            if (javascriptRequest.QueryParams != null)
            {
                foreach (var el in javascriptRequest.QueryParams)
                {
                    request.AddParameter(el.Key, el.Value);
                }
            }

            if (!string.IsNullOrEmpty(javascriptRequest.Body))
            {
                request.AddJsonBody(javascriptRequest.Body);
            }

            // TODO: add logging
            //var uri = client.BuildUri(request);
            //logger.LogDebug($"request URI: {uri.AbsoluteUri}");

            try
            {
                restResponse = client.Execute(request);
            }
            catch (Exception untrapped)
            {
                //TODO: log here
                response.Errors.Add(new Library.Core.Error()
                {
                    Code = "UNEXPEXTED",
                    Title = "JavascriptRestClient produces an unexpexted error",
                    Description = untrapped.Message,
                });
            }
            //make the API request and get a response

            response.Data = Newtonsoft.Json.JsonConvert.DeserializeObject<JObject>(restResponse.Content);
            return response;
        }

        //public string getText()
        //{
        //    return "text";
        //}
        //public static string getStaticText()
        //{
        //    return "static text";
        //}
    }
}