﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.Extensions.Configuration;
using System;

namespace RawCMS.Library.DataModel
{
    public class MongoSettings
    {
        public string ConnectionString { get; set; }
        public string DBName { get; set; }

        public static MongoSettings GetMongoSettings(IConfigurationRoot configuration)
        {
            var envConnectionString = Environment.GetEnvironmentVariable("MongoSettings:ConnectionString") ?? Environment.GetEnvironmentVariable("MongoSettingsConnectionString") ?? configuration["MongoSettings:ConnectionString"];
            var envDBName = Environment.GetEnvironmentVariable("MongoSettings:DBName") ?? Environment.GetEnvironmentVariable("MongoSettingsDBName") ?? configuration["MongoSettings:DBName"];

            MongoSettings instance = new MongoSettings
            {
                ConnectionString = envConnectionString,
                DBName = envDBName
            };
            return instance;
        }
    }
}