﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using RawCMS.Client.BLL.CommandLineParser;
using RawCMS.Client.BLL.Interfaces;
using RawCMS.Client.BLL.Model;
using RestSharp;

namespace RawCMS.Client.BLL.Services
{
    public class TokenService : ITokenService
    {
        private readonly ILoggerService _loggerService;
        private readonly IRawCmsService _rawCmsService;

        public TokenService(ILoggerService loggerService, IRawCmsService rawCmsService)
        {
            _loggerService = loggerService;
            _rawCmsService = rawCmsService;
        }

        public string GetToken(LoginOptions opts)
        {
            //string baseUrl = ClientConfig.GetValue<string>("BaseUrl");

            string url = $"{opts.ServerUrl}/connect/token";

            _loggerService.Debug($"Server url: {url}");

            if (!_rawCmsService.Ping(url))
            {
                _loggerService.Error("host not found.");
                return string.Empty;
            }

            //create RestSharp client and POST request object
            RestClient client = new RestClient(url);
            RestRequest request = new RestRequest(Method.POST);

            //add GetToken() API method parameters
            request.Parameters.Clear();
            request.AddParameter("grant_type", "password");

            request.AddParameter("username", opts.Username);
            request.AddParameter("password", opts.Password);

            request.AddParameter("client_id", opts.ClientId);
            request.AddParameter("client_secret", opts.ClientSecret);
            request.AddParameter("scoope", "openid");

            //make the API request and get the response
            IRestResponse response = client.Execute(request);
            TokenResponse res = Newtonsoft.Json.JsonConvert.DeserializeObject<TokenResponse>(response.Content);
            if (response.IsSuccessful)
            {
                _loggerService.Debug("Success response token");
                return res.access_token;
            }
            else
            {
                _loggerService.Warn("Unable to get valid token.");
                throw new ExceptionToken(res.error, res.error_description);
            }
        }
    }
}