﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using RawCMS.Client.BLL.Interfaces;
using System;

namespace RawCMS.Client.BLL.Services
{
    public class LoggerService : ILoggerService
    {
        private readonly ILogger<LoggerService> _logger;

        private bool _verbose { get; set; }

        private bool _pretty { get; set; }

        public ILogger<LoggerService> Log
        {
            get
            {
                return _logger;
            }
        }

        public LoggerService(ILogger<LoggerService> logger)
        {
            _logger = logger;
        }

        public void SetPretty(bool pretty)
        {
            _pretty = true;
        }

        public void SetVerbose(bool verbose)
        {
            _verbose = verbose;
            if (_verbose)
            {
                _logger.LogInformation("verbose mode enabled.");
            }
        }

        public void Info(string message)
        {
            _logger.LogInformation(message);
        }

        public void Info(string message, object[] args)
        {
            _logger.LogInformation(message, args);
        }

        public void Debug(string message)
        {
            _logger.LogDebug(message);
        }

        public void Debug(string message, object[] args)
        {
            _logger.LogDebug(message, args);
        }

        public void Warn(string message)
        {
            _logger.LogWarning(message);
        }

        public void Warn(string message, object[] args)
        {
            _logger.LogWarning(message, args);
        }

        public void Error(string message)
        {
            _logger.LogError(message);
        }

        public void Error(string message, Exception e)
        {
            _logger.LogError(e, message);
        }

        public void Trace(string message, object[] args)
        {
            _logger.LogTrace(message, args);
        }

        public void Trace(string message)
        {
            _logger.LogTrace(message);
        }

        public void Fatal(string message, object[] args)
        {
            _logger.LogCritical(message, args);
        }

        public void Fatal(string message)
        {
            _logger.LogCritical(message);
        }

        public void Response(string contentResponse)
        {
            _logDataCall(contentResponse, "Response");
        }

        public void Request(string contentRequest)
        {
            _logDataCall(contentRequest, "Request");
        }

        internal void _logDataCall(string content, string direction)
        {
            string ret = content;

            if (string.IsNullOrEmpty(ret))
            {
                Debug($"{direction} has no data.");
                return;
            }

            if (_pretty)
            {
                try
                {
                    object obj = JsonConvert.DeserializeObject(content);
                    ret = JsonConvert.SerializeObject(obj, Formatting.Indented);
                }
                catch (Exception e)
                {
                    Warn($"error parsing reponse: {e.Message}");
                }
            }

            Debug(string.Format("\n------------- {0} -------------\n\n{1}\n\n-------------------------------------\n", direction, ret));
        }
    }
}