﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using CommandLine;

namespace RawCMS.Client.BLL.CommandLineParser
{
    [Verb("list", HelpText = "List data from collection. Type list for more help.")]
    public class ListOptions
    {
        [Verb("users", HelpText = "users collections")]
        public class UsersOptions
        {
            [Option("id", Required = false, HelpText = "get user by id")]
            public string Id { get; set; }
        }

        [Option('v', "verbose", Default = false, HelpText = "Prints all messages to standard output.")]
        public bool Verbose { get; set; }

        [Option('p', "pretty", Default = false, HelpText = "Format JSON output.")]
        public bool Pretty { get; set; }

        [Option('c', "collection", Required = true, HelpText = "Collection where to do the operation.")]
        public string Collection { get; set; }

        [Option('i', "id", Required = false, HelpText = "Element id to get.")]
        public string Id { get; set; }

        [Option('s', "page-size", Required = false, HelpText = "Page Size, default 10")]
        public int PageSize { get; set; }

        [Option('n', "page-number", Required = false, HelpText = "Page Number, default 1")]
        public int PageNumber { get; set; }

        [Option('r', "raw-query", Required = false, HelpText = "Raw query.")]
        public string RawQuery { get; set; }
    }
}