﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using GraphQL;
using GraphQL.Types;
using Newtonsoft.Json.Linq;
using RawCMS.Library.Schema;
using RawCMS.Library.Service;
using RawCMS.Plugins.GraphQL.Classes;
using System;
using System.Collections.Generic;
using System.Linq;
using FieldType = GraphQL.Types.FieldType;

namespace RawCMS.Plugins.GraphQL.Types
{
    public class JObjectRawType : ObjectGraphType<object>
    {
        private GraphQLService _graphQLService { get; set; }
        private CollectionSchema _collectionSchema { get; set; }
        private EntityService _entityService { get; set; }
        private GraphQLQuery _query { get; set; }

        public JObjectRawType(GraphQLQuery query, GraphQLService graphQLService, CollectionSchema collectionSchema, EntityService entityService)
        {
            _query = query;
            _graphQLService = graphQLService;
            _collectionSchema = collectionSchema;
            _entityService = entityService;

            Name = collectionSchema.CollectionName;
            var fields = entityService.GetTypes();

            foreach (Field field in collectionSchema.FieldSettings)
            {
                BuildGraphField(field);
            }

            TableArgs.Add(new QueryArgument<IntGraphType> { Name = "pageNumber" });
            TableArgs.Add(new QueryArgument<IntGraphType> { Name = "pageSize" });
            TableArgs.Add(new QueryArgument<StringGraphType> { Name = "rawQuery" });
        }

        private void BuildGraphField(Field field)
        {
            Type graphQLType;
            var f = _entityService.GetTypes().FirstOrDefault(x => x.TypeName == field.Type);

            if (f?.GraphType == FieldGraphType.Relation)
            {
                var collectionName = field.Options["Collection"].Value<string>();
                var fieldType = _query.Fields.FirstOrDefault(x => x.Name == collectionName);
                if (fieldType == null)
                {
                    //Add related collection not registred on schema
                    var relatedObject = _entityService.GetCollectionSchemas().FirstOrDefault(x => x.CollectionName == collectionName);
                    var type = new JObjectRawType(_query, _graphQLService, relatedObject, _entityService);
                    var listType = new ListGraphType(type);

                    fieldType = new FieldType
                    {
                        Name = collectionName,
                        Type = listType.GetType(),
                        ResolvedType = listType,
                        Resolver = new JObjectFieldResolver(_graphQLService, _entityService),
                        Arguments = new QueryArguments(
                            type.TableArgs
                        )
                    };

                    _query.AddField(fieldType);
                }

                var subType = fieldType.GetType();
                var subresolvedType = fieldType.ResolvedType;
                //if (!field.Options["Multiple"].Value<bool>())
                //{
                //    var relatedObject = _entityService.GetCollectionSchemas().FirstOrDefault(x => x.CollectionName == collectionName);
                //    subresolvedType = new JObjectRawType(_query, _graphQLService, relatedObject, _entityService);
                //    subType = subresolvedType.GetType();
                //}

                var subField = new FieldType
                {
                    Name = fieldType.Name,
                    Type = subType,
                    ResolvedType = subresolvedType,
                    Resolver = new NameFieldResolver(),
                    Arguments = fieldType.Arguments
                };

                AddField(subField);

                foreach (var arg in fieldType.Arguments.Where(x => !(new string[] { "pageNumber", "pageSize", "rawQuery", "_id" }.Contains(x.Name))).ToList())
                {
                    arg.Name = $"{collectionName}_{arg.Name}";
                    TableArgs.Add(arg);
                }
            }
            else
            {
                //graphQLType = (ResolveFieldMetaType(field.BaseType)).GetGraphTypeFromType(!field.Required);
                graphQLType = (ResolveFieldMetaType(f?.GraphType ?? FieldGraphType.String)).GetGraphTypeFromType(true);
                FieldType columnField = Field(
                graphQLType,
                field.Name);

                columnField.Resolver = new NameFieldResolver();
                FillArgs(field.Name, graphQLType);
            }
        }

        public QueryArguments TableArgs
        {
            get; set;
        }

        private IDictionary<FieldGraphType, Type> _fieldTypeToSystemType;

        protected IDictionary<FieldGraphType, Type> FieldTypeToSystemType
        {
            get
            {
                if (_fieldTypeToSystemType == null)
                {
                    _fieldTypeToSystemType = new Dictionary<FieldGraphType, Type>
                    {
                        { FieldGraphType.Boolean, typeof(bool) },
                        { FieldGraphType.Date, typeof(DateTime) },
                        { FieldGraphType.Float, typeof(float) },
                        { FieldGraphType.Id, typeof(Guid) },
                        { FieldGraphType.Int, typeof(int) },
                        { FieldGraphType.String, typeof(string) },
                        { FieldGraphType.BigInt, typeof(Int64) },
                        { FieldGraphType.Byte, typeof(byte) },
                        { FieldGraphType.DateTimeOffset, typeof(DateTimeOffset) },
                        { FieldGraphType.Decimal, typeof(decimal) },
                        { FieldGraphType.Long, typeof(long) },
                        { FieldGraphType.SByte, typeof(sbyte) },
                        { FieldGraphType.Short, typeof(short) },
                        { FieldGraphType.TimeSpanSeconds, typeof(TimeSpan) },
                        { FieldGraphType.Relation, typeof(JObject) }
                    };
                }

                return _fieldTypeToSystemType;
            }
        }

        private Type ResolveFieldMetaType(FieldGraphType type)
        {
            if (FieldTypeToSystemType.ContainsKey(type))
            {
                return FieldTypeToSystemType[type];
            }

            return typeof(string);
        }

        private void FillArgs(string name, Type graphType)
        {
            if (TableArgs == null)
            {
                TableArgs = new QueryArguments(
                    new QueryArgument(graphType)
                    {
                        Name = name
                    }
                );
            }
            else
            {
                TableArgs.Add(new QueryArgument(graphType) { Name = name });
            }
        }
    }
}