﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using GraphiQl;
using GraphQL;
using GraphQL.Http;
using GraphQL.Types;
using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using RawCMS.Library.Core;
using RawCMS.Library.Core.Interfaces;
using RawCMS.Plugins.GraphQL.Classes;

namespace RawCMS.Plugins.GraphQL
{
    public class GraphQLPlugin : RawCMS.Library.Core.Extension.Plugin, IConfigurablePlugin<GraphQLSettings>
    {
        public override string Name => "GraphQL";

        public override string Description => "Add GraphQL CMS capabilities";

        public override void ConfigureServices(IServiceCollection services)
        {
            //services.AddSingleton<IDependencyResolver>(s => new FuncDependencyResolver(s.GetRequiredService));
            services.AddSingleton<IDocumentExecuter, DocumentExecuter>();
            services.AddSingleton<IDocumentWriter, DocumentWriter>();
            services.AddScoped<ISchema, GraphQLSchema>();
            services.AddScoped<GraphQLQuery>();
            services.AddSingleton<GraphQLService>();
            Logger.LogInformation("GraphQL plugin loaded");
        }

        public override void Configure(IApplicationBuilder app)
        {
            app.UseGraphiQl(config.GraphiQLPath, config.Path);
        }

        private IConfigurationRoot configuration;

        public override void Setup(IConfigurationRoot configuration)
        {
            this.configuration = configuration;
        }

        private readonly AppEngine appEngine;
        private readonly GraphQLSettings config;

        public GraphQLPlugin(AppEngine appEngine, GraphQLSettings config, ILogger logger) : base(appEngine, logger)
        {
            this.appEngine = appEngine;
            this.config = config;
        }

        public override void ConfigureMvc(IMvcBuilder builder)
        {
        }
    }
}