﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using GraphQL.Types;
using Newtonsoft.Json.Linq;
using RawCMS.Library.Service;
using RawCMS.Plugins.GraphQL.Types;
using System.Linq;

namespace RawCMS.Plugins.GraphQL.Classes
{
    public class GraphQLQuery : ObjectGraphType<JObject>
    {
        public GraphQLQuery(GraphQLService graphQLService, EntityService entityService)
        {
            Name = "Query";
            var schemas = entityService.GetCollectionSchemas();
            foreach (var metaColl in schemas)
            {
                if (Fields.Count(x => x.Name == metaColl.CollectionName) == 0)
                {
                    JObjectRawType type = new JObjectRawType(this, graphQLService, metaColl, entityService);
                    ListGraphType listType = new ListGraphType(type);

                    AddField(new FieldType
                    {
                        Name = metaColl.CollectionName,
                        Type = listType.GetType(),
                        ResolvedType = listType,
                        Resolver = new JObjectFieldResolver(graphQLService, entityService),
                        Arguments = new QueryArguments(
                            type.TableArgs
                        )
                    });
                }
            }
        }
    }
}