﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json.Linq;
using RawCMS.Library.Core.Enum;
using RawCMS.Library.Lambdas;
using RawCMS.Library.Service;
using RawCMS.Plugins.Core.Model;
using System;
using System.Collections.Generic;

namespace RawCMS.Plugins.Core.Lambdas.CRUDSecurity
{
    public abstract class GenericSecurity : DataProcessLambda
    {
        private readonly IHttpContextAccessor _httpContextAccessor;

        protected readonly EntityService entityService;

        public GenericSecurity(EntityService entityService, IHttpContextAccessor httpContextAccessor)
        {
            _httpContextAccessor = httpContextAccessor;
            this.entityService = entityService;
        }

        public void CheckGeneric(string collection, DataOperation operation)
        {
            var settings = this.entityService.GetByName(collection);
            if (settings != null)
            {
                if (settings.PluginConfiguration.TryGetValue("Security", out JObject jObject))
                {
                    CollectionSecurityInfo secinfo = jObject.ToObject<CollectionSecurityInfo>();
                    if (secinfo.AllowedRoleMap != null)
                    {
                        if (secinfo.AllowedRoleMap.TryGetValue(operation.ToString(), out List<string> allowedRoles))
                        {
                            foreach (string role in allowedRoles)
                            {
                                if (_httpContextAccessor.HttpContext.User.IsInRole(role))
                                {
                                    return;
                                }
                            }
                        }
                        throw new Exception("Forbidden");
                    }
                }
            }
        }
    }
}