﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Newtonsoft.Json.Linq;
using RawCMS.Library.Lambdas;
using RawCMS.Library.Service;
using RawCMS.Plugins.Core.Stores;
using System.Collections.Generic;

namespace RawCMS.Plugins.Core.Data
{
    public class UserPresaveLambda : PreSaveLambda
    {
        public override string Name => "User Presave lambda";

        public override string Description => "provide normalized name and prevent password change";

        private CRUDService service;

        public override void Execute(string collection, ref JObject item, ref Dictionary<string, object> dataContext)
        {
            if (collection == "_users")
            {
                if (item.ContainsKey("UserName"))
                {
                    item["NormalizedUserName"] = RawUserStore.NormalizeString(item["UserName"].Value<string>());
                }
                if (item.ContainsKey("Email"))
                {
                    item["NormalizedEmail"] = RawUserStore.NormalizeString(item["Email"].Value<string>());
                }
                if (item.ContainsKey("NewPassword"))
                {
                    dataContext["NewPassword"] = item["NewPassword"].Value<string>();
                    item.Remove("NewPassword");
                }
                if (item.ContainsKey("PasswordHash"))
                {
                    item.Remove("PasswordHash");
                }
            }
        }

        public void SetCRUDService(CRUDService service)
        {
            this.service = service;
        }
    }
}