﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using RawCMS.Library.Core;
using RawCMS.Library.Core.Attributes;
using RawCMS.Library.Core.Exceptions;
using RawCMS.Library.DataModel;
using RawCMS.Library.Service;
using RawCMS.Plugins.Core.Model;
using System;
using System.Collections.Generic;

namespace RawCMS.Plugins.Core.Controllers
{
    [Authorize(AuthenticationSchemes = "Bearer")]
    [Route("api/[controller]")]
    [ParameterValidator("collection", "_(.*)", true)]
    public class CRUDController : Controller
    {
        private readonly CRUDService service;

        public CRUDController(AppEngine manager, CRUDService service)
        {
            this.service = service;
        }

        // GET api/CRUD/{collection}
        [HttpGet("{collection}")]
        public RestMessage<ItemList> Get(string collection, string rawQuery = null, string[] expando = null, int pageNumber = 1, int pageSize = 20, string sort = "")
        {
            var sortValue = Newtonsoft.Json.JsonConvert.DeserializeObject<List<SortOption>>(sort);
            // CRUDService service = new CRUDService(new MongoService(new MongoSettings() { }));
            ItemList result = service.Query(collection, new Library.DataModel.DataQuery()
            {
                PageNumber = pageNumber,
                PageSize = pageSize,
                RawQuery = rawQuery,
                Sort = sortValue,
                Expando = new List<string>(expando)
            });

            return new RestMessage<ItemList>(result);
        }

        // GET api/CRUD/{collection}/5
        [HttpGet("{collection}/{id}")]
        public RestMessage<JObject> Get(string collection, string id)
        {
            JObject data = service.Get(collection, id);
            return new RestMessage<JObject>(data);
        }

        // POST api/CRUD/{collection}
        [HttpPost("{collection}")]
        public RestMessage<JObject> Post(string collection, [FromBody]JObject value, bool omitPayload = false)
        {
            RestMessage<JObject> response = new RestMessage<JObject>(new JObject());
            try
            {
                var added = service.Insert(collection, value);
                if (omitPayload)
                {
                    response.Data["_id"] = added["_id"];
                }
                else
                {
                    response.Data = added;
                }
                return response;
            }
            catch (ValidationException err)
            {
                response.Errors = err.Errors;
            }
            catch (Exception untrapped)
            {
                //TODO: log here
                response.Errors.Add(new Library.Core.Error()
                {
                    Code = "UNEXPEXTED",
                    Title = $"{collection} produces an unexpexted error",
                    Description = untrapped.Message,
                });
            }
            return response;
        }

        // PUT api/CRUD/{collection}/5
        [HttpPut("{collection}/{id}")]
        public RestMessage<JObject> Put(string collection, string id, [FromBody]JObject value, bool omitPayload = false)
        {
            RestMessage<JObject> response = new RestMessage<JObject>(new JObject());
            try
            {
                value["_id"] = id;
                var updated = service.Update(collection, value, true);
                if (!omitPayload)
                {
                    response.Data = updated;
                }
                return response;
            }
            catch (ValidationException err)
            {
                response.Errors = err.Errors;
            }
            catch (Exception untrapped)
            {
                //TODO: log here
                response.Errors.Add(new Library.Core.Error()
                {
                    Code = "UNEXPEXTED",
                    Title = $"{collection} produces an unexpexted error",
                    Description = untrapped.Message,
                });
            }
            return response;
        }

        // PUT api/CRUD/{collection}/5
        [HttpPatch("{collection}/{id}")]
        public RestMessage<JObject> Patch(string collection, string id, [FromBody]JObject value, bool omitPayload = false)
        {
            RestMessage<JObject> response = new RestMessage<JObject>(new JObject());
            try
            {
                value["_id"] = id;
                var updated = service.Update(collection, value, false);
                if (!omitPayload)
                {
                    response.Data = updated;
                }
                return response;
            }
            catch (ValidationException err)
            {
                response.Errors = err.Errors;
            }
            catch (Exception untrapped)
            {
                //TODO: log here
                response.Errors.Add(new Library.Core.Error()
                {
                    Code = "UNEXPEXTED",
                    Title = $"{collection} produces an unexpexted error",
                    Description = untrapped.Message,
                });
            }
            return response;
        }

        // DELETE api/CRUD/{collection}/5
        [HttpDelete("{collection}/{id}")]
        public RestMessage<bool> Delete(string collection, string id)
        {
            RestMessage<bool> response = new RestMessage<bool>(false);
            try
            {
                bool result = service.Delete(collection, id);
                response.Data = true;
                return response;
            }
            catch (ValidationException err)
            {
                response.Errors = err.Errors;
            }
            catch (Exception untrapped)
            {
                //TODO: log here
                response.Errors.Add(new Library.Core.Error()
                {
                    Code = "UNEXPEXTED",
                    Title = $"{collection} produces an unexpexted error",
                    Description = untrapped.Message,
                });
            }
            return response;
        }
    }
}