﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using IdentityServer4.Services;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Identity;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.IdentityModel.Logging;
using RawCMS.Library.Core;
using RawCMS.Library.Core.Interfaces;
using RawCMS.Library.Service;
using RawCMS.Plugins.Core.Configuration;
using RawCMS.Plugins.Core.Extensions;
using RawCMS.Plugins.Core.Handlers;
using RawCMS.Plugins.Core.Model;
using RawCMS.Plugins.Core.Stores;
using System.Collections.Generic;

namespace RawCMS.Plugins.Core
{
    public class AuthPlugin : RawCMS.Library.Core.Extension.Plugin, IConfigurablePlugin<AuthConfig>
    {
        public override string Name => "Authorization";

        public override string Description => "Add authorizaton capabilities";

        private readonly AuthConfig config;
        private AppEngine appEngine;

        public AuthPlugin(AppEngine appEngine, AuthConfig config, ILogger logger) : base(appEngine, logger)
        {
            this.appEngine = appEngine;
            this.config = config;
            Logger.LogInformation("Authorization plugin loaded");
        }

        public override void ConfigureServices(IServiceCollection services)
        {
            IdentityModelEventSource.ShowPII = true;

            // all singleton works on CI/docker env but not on local
            //services.AddSingleton<IUserStore<IdentityUser>, RawUserStore>();
            //services.AddSingleton<IUserPasswordStore<IdentityUser>, RawUserStore>();
            //services.AddSingleton<IPasswordValidator<IdentityUser>, RawUserStore>();
            //services.AddSingleton<IUserClaimStore<IdentityUser>, RawUserStore>();
            //services.AddSingleton<IPasswordHasher<IdentityUser>, RawUserStore>();
            //services.AddSingleton<IProfileService, RawUserStore>();
            //services.AddSingleton<IUserClaimsPrincipalFactory<IdentityUser>, RawClaimsFactory>();

            // this works on local
            services.AddScoped<IUserStore<IdentityUser>, RawUserStore>();
            services.AddScoped<IUserPasswordStore<IdentityUser>, RawUserStore>();
            services.AddScoped<IPasswordValidator<IdentityUser>, RawUserStore>();
            services.AddScoped<IUserClaimStore<IdentityUser>, RawUserStore>();
            services.AddScoped<IPasswordHasher<IdentityUser>, RawUserStore>();
            services.AddScoped<IProfileService, RawUserStore>();
            services.AddScoped<IUserClaimsPrincipalFactory<IdentityUser>, RawClaimsFactory>();

            services.AddScoped<RawRoleStore>();
            services.AddScoped<IRoleStore<IdentityRole>, RawRoleStore>();
            services.AddIdentity<IdentityUser, IdentityRole>();

            // configure identity server with in-memory stores, keys, clients and scopes
            services.AddIdentityServer()
            .AddDeveloperSigningCredential()
            .AddInMemoryPersistedGrants()
            .AddInMemoryIdentityResources(this.config.GetIdentityResources())
            .AddInMemoryApiResources(config.GetApiResources())
            .AddInMemoryClients(config.GetClients())
            .AddAspNetIdentity<IdentityUser>()
            .AddProfileServiceCustom();

            //if (config.Mode == OAuthMode.External)
            //{
            //    OAuth2IntrospectionOptions options = new OAuth2IntrospectionOptions
            //    {
            //        //base - address of your identityserver
            //        Authority = config.Authority,
            //        ClientSecret = config.ClientSecret,
            //        ClientId = config.ClientId,
            //        BasicAuthenticationHeaderStyle = IdentityModel.Client.BasicAuthenticationHeaderStyle.Rfc2617
            //    };
            //    if (!string.IsNullOrWhiteSpace(config.IntrospectionEndpoint))
            //    {
            //        options.IntrospectionEndpoint = config.IntrospectionEndpoint;
            //    }
            //    options.TokenTypeHint = "Bearer";
            //    if (!string.IsNullOrWhiteSpace(config.TokenTypeHint))
            //    {
            //        options.TokenTypeHint = config.TokenTypeHint;
            //    }

            //    options.Validate();

            //    services.AddAuthentication(OAuth2IntrospectionDefaults.AuthenticationScheme)
            //        .AddOAuth2Introspection(x =>
            //        {
            //            x = options;
            //        });
            //}
            //else
            //{
            //}

            var schemeList = new List<string> { "Bearer" };
            var authBuilder = services.AddAuthentication();

            //rawcms providers
            authBuilder = authBuilder.AddScheme<RawIdentityServerAuthenticationOptions, RawLocalAccessTokenValidationHandler>("Bearer", (o) =>
                 {
                     o.AdminApiKey = this.config.RawCMSProvider.AdminApiKey;
                     o.ApiKey = this.config.RawCMSProvider.ApiKey;
                 });

            if (this.config.ExternalProviders != null && this.config.ExternalProviders.Count > 0)
            {
                var crudService = services.BuildServiceProvider().GetService<CRUDService>();

                foreach (var provider in this.config.ExternalProviders)
                {
                    //TODO: add multiple authintication schema type
                    authBuilder = authBuilder.AddJwtProvider(provider, crudService);
                    schemeList.Add(provider.SchemaName);
                }
            }

            //.AddJwtBearer("Auth0Bis", x =>
            //{
            //    x.Authority = "https://dev-t61xkx2b.eu.auth0.com";
            //    x.Audience = "http://localhost:1111";
            //    x.TokenValidationParameters = new Microsoft.IdentityModel.Tokens.TokenValidationParameters
            //    {
            //        RoleClaimType = "permissions"
            //    };
            //    x.Events = new JwtBearerEvents
            //    {
            //        OnTokenValidated = async ctx =>
            //        {
            //            var accessToken = ctx.SecurityToken as JwtSecurityToken;
            //            if (accessToken != null)
            //            {
            //                var client = new HttpClient();
            //                var request = new HttpRequestMessage
            //                {
            //                    Method = HttpMethod.Post,
            //                    RequestUri = new Uri("https://dev-t61xkx2b.eu.auth0.com/userinfo")
            //                };
            //                request.Headers.Authorization = new AuthenticationHeaderValue("bearer", accessToken.RawData);
            //                request.Headers.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

            //                var message = await client.SendAsync(request);
            //                if (message.IsSuccessStatusCode)
            //                {
            //                    var response = await message.Content.ReadAsStringAsync();
            //                    var userInfo = JsonConvert.DeserializeObject<JObject>(response);
            //                    if (ctx.Principal.Identity is ClaimsIdentity identity)
            //                    {
            //                        foreach (var cl in userInfo.Properties())
            //                        {
            //                            if (identity.Claims.Where(y => y.Type == cl.Name).Count() == 0)
            //                            {
            //                                identity.AddClaim(new Claim(cl.Name, cl.Value.Value<string>()));
            //                            }
            //                        }
            //                        string perm = ctx.Principal.FindFirstValue("permissions");
            //                        var claimRole = identity.Claims.Where(y => y.Type == ClaimTypes.Role).FirstOrDefault() ?? new Claim(ClaimTypes.Role, string.Empty);
            //                        identity.AddClaim(new Claim(ClaimTypes.Role, string.Join(',', claimRole.Value, perm)));
            //                    }
            //                }
            //            }
            //        }
            //    };

            //    x.Validate();
            //})
            //.AddScheme<RawIdentityServerAuthenticationOptions, RawLocalAccessTokenValidationHandler>("Bearer", (o) =>
            //{
            //    o.AdminApiKey = this.config.AdminApiKey;
            //    o.ApiKey = this.config.ApiKey;
            //})
            // .AddScheme<RawIdentityServerAuthenticationOptions, RawLocalAccessTokenValidationHandler>("ApiKey", (o) =>
            // {
            //     o.AdminApiKey = this.config.AdminApiKey;
            //     o.ApiKey = this.config.ApiKey;
            // });

            services.AddAuthorization(options =>
            {
                var policyBuilder = new AuthorizationPolicyBuilder()
                    .RequireAuthenticatedUser()
                    .AddAuthenticationSchemes(schemeList.ToArray())
                    .Build();

                options.DefaultPolicy = policyBuilder;
                options.AddPolicy("rawCms", policyBuilder);
            });
        }

        public override void Configure(IApplicationBuilder app)
        {
            app.UseIdentityServer();
            app.UseAuthentication();
        }

        public override void ConfigureMvc(IMvcBuilder builder)
        {
        }

        public override void Setup(IConfigurationRoot configuration)
        {
        }
    }
}