﻿//******************************************************************************
// <copyright file="license.md" company="RawCMS project  (https://github.com/arduosoft/RawCMS)">
// Copyright (c) 2019 RawCMS project  (https://github.com/arduosoft/RawCMS)
// RawCMS project is released under GPL3 terms, see LICENSE file on repository root at  https://github.com/arduosoft/RawCMS .
// </copyright>
// <author>Daniele Fontani, Emanuele Bucarelli, Francesco Mina'</author>
// <autogenerated>true</autogenerated>
//******************************************************************************
using Microsoft.AspNetCore.Http;
using RawCMS.Plugins.ApiGateway.Classes.Settings;
using RawCMS.Plugins.ApiGateway.Interfaces;
using System;
using System.Threading.Tasks;

namespace RawCMS.Plugins.ApiGateway.Classes.Balancer.Policy
{
    public abstract class BalancerPolicy
    {
        public ApiGatewayConfig Config { get; private set; }

        public BalancerPolicy(ApiGatewayConfig config)
        {
            Config = config;
        }

        public abstract string Name { get; }

        public bool IsEnable(HttpContext context)
        {
            var vhost = context.Items["bal-vhost"] as BalancerOption;
            return vhost != null && string.Compare(vhost.Policy, Name, StringComparison.InvariantCultureIgnoreCase) == 0;
        }

        public abstract Task<object> Execute(BalancerData balancerData, HttpContext context, RawHandler handler);
    }
}